// CheckStyle: start generated
package com.oracle.graal.python.nodes.truffle;

import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@GeneratedBy(PythonIntegerAndFloatTypes.class)
public final class PythonIntegerAndFloatTypesGen extends PythonIntegerAndFloatTypes {

    protected PythonIntegerAndFloatTypesGen() {
    }

    public static int expectImplicitInteger(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && value instanceof Integer) {
            return (int) value;
        } else if ((state & 0b10) != 0 && value instanceof Boolean) {
            return booleanToInt((boolean) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitInteger(int state, Object value) {
        return ((state & 0b1) != 0 && value instanceof Integer)
             || ((state & 0b10) != 0 && value instanceof Boolean);
    }

    public static boolean isImplicitInteger(Object value) {
        return value instanceof Integer
             || value instanceof Boolean;
    }

    public static int asImplicitInteger(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitInteger(value);
        }
        if ((state & 0b1) != 0 && value instanceof Integer) {
            return (int) value;
        } else if ((state & 0b10) != 0 && value instanceof Boolean) {
            return booleanToInt((boolean) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int asImplicitInteger(Object value) {
        if (value instanceof Integer) {
            return (int) value;
        } else if (value instanceof Boolean) {
            return booleanToInt((boolean) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitInteger(Object value) {
        if (value instanceof Integer) {
            return 0b1;
        } else if (value instanceof Boolean) {
            return 0b10;
        } else {
            return 0;
        }
    }

    public static long expectImplicitLong(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && value instanceof Long) {
            return (long) value;
        } else if ((state & 0b10) != 0 && value instanceof Boolean) {
            return booleanToLong((boolean) value);
        } else if ((state & 0b100) != 0 && value instanceof Integer) {
            return intToLong((int) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitLong(int state, Object value) {
        return ((state & 0b1) != 0 && value instanceof Long)
             || ((state & 0b10) != 0 && value instanceof Boolean)
             || ((state & 0b100) != 0 && value instanceof Integer);
    }

    public static boolean isImplicitLong(Object value) {
        return value instanceof Long
             || value instanceof Boolean
             || value instanceof Integer;
    }

    public static long asImplicitLong(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitLong(value);
        }
        if ((state & 0b1) != 0 && value instanceof Long) {
            return (long) value;
        } else if ((state & 0b10) != 0 && value instanceof Boolean) {
            return booleanToLong((boolean) value);
        } else if ((state & 0b100) != 0 && value instanceof Integer) {
            return intToLong((int) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static long asImplicitLong(Object value) {
        if (value instanceof Long) {
            return (long) value;
        } else if (value instanceof Boolean) {
            return booleanToLong((boolean) value);
        } else if (value instanceof Integer) {
            return intToLong((int) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitLong(Object value) {
        if (value instanceof Long) {
            return 0b1;
        } else if (value instanceof Boolean) {
            return 0b10;
        } else if (value instanceof Integer) {
            return 0b100;
        } else {
            return 0;
        }
    }

    public static double expectImplicitDouble(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && value instanceof Double) {
            return (double) value;
        } else if ((state & 0b10) != 0 && value instanceof PFloat) {
            return PFloatToDouble((PFloat) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitDouble(int state, Object value) {
        return ((state & 0b1) != 0 && value instanceof Double)
             || ((state & 0b10) != 0 && value instanceof PFloat);
    }

    public static boolean isImplicitDouble(Object value) {
        return value instanceof Double
             || value instanceof PFloat;
    }

    public static double asImplicitDouble(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitDouble(value);
        }
        if ((state & 0b1) != 0 && value instanceof Double) {
            return (double) value;
        } else if ((state & 0b10) != 0 && value instanceof PFloat) {
            return PFloatToDouble((PFloat) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static double asImplicitDouble(Object value) {
        if (value instanceof Double) {
            return (double) value;
        } else if (value instanceof PFloat) {
            return PFloatToDouble((PFloat) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitDouble(Object value) {
        if (value instanceof Double) {
            return 0b1;
        } else if (value instanceof PFloat) {
            return 0b10;
        } else {
            return 0;
        }
    }

}
