// CheckStyle: start generated
package com.oracle.graal.python.nodes;

import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

/**
 * Debug Info: <pre>
 *   Specialization {@link PRaiseNode#doProfile}
 *     Activation probability: 1.00000
 *     With/without class size: 24/1 bytes
 * </pre> */
@GeneratedBy(PRaiseNode.class)
@SuppressWarnings("javadoc")
public final class PRaiseNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static PRaiseNode getUncached() {
        return PRaiseNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul> */
    @NeverDefault
    public static PRaiseNode inline(@RequiredField(bits = 1, value = StateField.class) InlineTarget target) {
        return new PRaiseNodeGen.Inlined(target);
    }

    @GeneratedBy(PRaiseNode.class)
    @DenyReplace
    private static final class Inlined extends PRaiseNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link PRaiseNode#doProfile}
         *        Parameter: {@link InlinedBranchProfile} profile
         *        Inline method: {@link InlinedBranchProfile#inline}
         * </pre> */
        private final StateField state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link PRaiseNode#doProfile}
         *   Parameter: {@link InlinedBranchProfile} profile
         *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
        private final InlinedBranchProfile profile_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(PRaiseNode.class);
            this.state_0_ = target.getState(0, 1);
            this.profile_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(0, 1)));
        }

        @Override
        protected void executeEnterProfile(Node arg0Value) {
            assert InlineSupport.validate(arg0Value, this.state_0_);
            PRaiseNode.doProfile(arg0Value, this.profile_);
            return;
        }

    }
    @GeneratedBy(PRaiseNode.class)
    @DenyReplace
    private static final class Uncached extends PRaiseNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        protected void executeEnterProfile(Node arg0Value) {
            PRaiseNode.doProfile(arg0Value, (InlinedBranchProfile.getUncached()));
            return;
        }

    }
}
