// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.map;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.map.MapBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.map.MapBuiltins.MapNode;
import com.oracle.graal.python.builtins.objects.map.MapBuiltins.NextNode;
import com.oracle.graal.python.builtins.objects.map.MapBuiltins.ReduceNode;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes.GetInstanceShape;
import com.oracle.graal.python.builtins.objects.type.TypeNodes.HasObjectInitNode;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.GetInstanceShapeNodeGen;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.HasObjectInitNodeGen;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyIterNextNodeGen;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.IntField;
import com.oracle.truffle.api.dsl.InlineSupport.LongField;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(MapBuiltins.class)
@SuppressWarnings("javadoc")
public final class MapBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(MapNodeFactory.getInstance(), NextNodeFactory.getInstance(), IterNodeFactory.getInstance(), ReduceNodeFactory.getInstance());
    }

    @GeneratedBy(MapNode.class)
    public static final class MapNodeFactory implements NodeFactory<MapNode> {

        private static final MapNodeFactory MAP_NODE_FACTORY_INSTANCE = new MapNodeFactory();

        private MapNodeFactory() {
        }

        @Override
        public Class<MapNode> getNodeClass() {
            return MapNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public MapNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<MapNode> getInstance() {
            return MAP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MapNode create() {
            return new MapNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link MapNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 48/25 bytes
         * </pre> */
        @GeneratedBy(MapNode.class)
        @SuppressWarnings("javadoc")
        public static final class MapNodeGen extends MapNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}</pre> */
            private static final InlinedLoopConditionProfile INLINED_LOOP_PROFILE_ = InlinedLoopConditionProfile.inline(InlineTarget.create(InlinedLoopConditionProfile.class, LongField.create(MethodHandles.lookup(), "loopProfile__field0_"), IntField.create(MethodHandles.lookup(), "loopProfile__field1_")));
            private static final StateField STATE_0_MapNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link PyObjectGetIter} getIter
             *   Inline method: {@link PyObjectGetIterNodeGen#inline}</pre> */
            private static final PyObjectGetIter INLINED_GET_ITER_ = PyObjectGetIterNodeGen.inline(InlineTarget.create(PyObjectGetIter.class, STATE_0_MapNode_UPDATER.subUpdater(1, 2), ReferenceField.create(MethodHandles.lookup(), "getIter__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_MapNode_UPDATER.subUpdater(3, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MapNode#doit}
             *   1-2: InlinedCache
             *        Specialization: {@link MapNode#doit}
             *        Parameter: {@link PyObjectGetIter} getIter
             *        Inline method: {@link PyObjectGetIterNodeGen#inline}
             *   3: InlinedCache
             *        Specialization: {@link MapNode#doit}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link HasObjectInitNode} hasObjectInitNode</pre> */
            @Child private HasObjectInitNode hasObjectInitNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: long field0</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private long loopProfile__field0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link InlinedLoopConditionProfile} loopProfile
             *   Inline method: {@link InlinedLoopConditionProfile#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int loopProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link PyObjectGetIter} getIter
             *   Inline method: {@link PyObjectGetIterNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getIter__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MapNode#doit}
             *   Parameter: {@link GetInstanceShape} getInstanceShape</pre> */
            @Child private GetInstanceShape getInstanceShape_;

            private MapNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[MapBuiltins.MapNode.doit(VirtualFrame, Object, Object[], PKeyword[], Node, HasObjectInitNode, InlinedLoopConditionProfile, PyObjectGetIter, PythonLanguage, GetInstanceShape, PRaiseNode)] */) {
                    {
                        HasObjectInitNode hasObjectInitNode__ = this.hasObjectInitNode_;
                        if (hasObjectInitNode__ != null) {
                            GetInstanceShape getInstanceShape__ = this.getInstanceShape_;
                            if (getInstanceShape__ != null) {
                                Node inliningTarget__ = (this);
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return MapNode.doit(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, hasObjectInitNode__, INLINED_LOOP_PROFILE_, INLINED_GET_ITER_, language__, getInstanceShape__, INLINED_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private PMap executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                {
                    PythonLanguage language__ = null;
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    HasObjectInitNode hasObjectInitNode__ = this.insert((HasObjectInitNodeGen.create()));
                    Objects.requireNonNull(hasObjectInitNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.hasObjectInitNode_ = hasObjectInitNode__;
                    language__ = (PythonLanguage.get(this));
                    GetInstanceShape getInstanceShape__ = this.insert((GetInstanceShapeNodeGen.create()));
                    Objects.requireNonNull(getInstanceShape__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getInstanceShape_ = getInstanceShape__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[MapBuiltins.MapNode.doit(VirtualFrame, Object, Object[], PKeyword[], Node, HasObjectInitNode, InlinedLoopConditionProfile, PyObjectGetIter, PythonLanguage, GetInstanceShape, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return MapNode.doit(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, hasObjectInitNode__, INLINED_LOOP_PROFILE_, INLINED_GET_ITER_, language__, getInstanceShape__, INLINED_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(NextNode.class)
    public static final class NextNodeFactory implements NodeFactory<NextNode> {

        private static final NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        @Override
        public Class<NextNode> getNodeClass() {
            return NextNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NextNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NextNode create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NextNode#doOne}
         *     Activation probability: 0.65000
         *     With/without class size: 14/0 bytes
         *   Specialization {@link NextNode#doNext}
         *     Activation probability: 0.35000
         *     With/without class size: 9/0 bytes
         * </pre> */
        @GeneratedBy(NextNode.class)
        @SuppressWarnings("javadoc")
        public static final class NextNodeGen extends NextNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}</pre> */
            private static final PyIterNextNode INLINED_NEXT_NODE = PyIterNextNodeGen.inline(InlineTarget.create(PyIterNextNode.class, STATE_0_UPDATER.subUpdater(2, 28), STATE_1_UPDATER.subUpdater(0, 21), ReferenceField.create(MethodHandles.lookup(), "nextNode_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field4_", Object.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field6_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field7_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field8_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field9_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field10_", Node.class), ReferenceField.create(MethodHandles.lookup(), "nextNode_field11_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NextNode#doOne}
             *   1: SpecializationActive {@link NextNode#doNext}
             *   2-29: InlinedCache
             *        Specialization: {@link NextNode#doOne}
             *        Parameter: {@link PyIterNextNode} nextNode
             *        Inline method: {@link PyIterNextNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link NextNode#doOne}
             *        Parameter: {@link PyIterNextNode} nextNode
             *        Inline method: {@link PyIterNextNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link CallNode} callNode</pre> */
            @Child private CallNode callNode;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Object} field4</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object nextNode_field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field5</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field6</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field6_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field7</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field7_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field8</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field8_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field9</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field9_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field10</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field10_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doOne}
             *   Parameter: {@link PyIterNextNode} nextNode
             *   Inline method: {@link PyIterNextNodeGen#inline}
             *   Inline field: {@link Node} field11</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nextNode_field11_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[MapBuiltins.NextNode.doOne(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] || SpecializationActive[MapBuiltins.NextNode.doNext(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */ && arg0Value instanceof PMap) {
                    PMap arg0Value_ = (PMap) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[MapBuiltins.NextNode.doOne(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */) {
                        {
                            CallNode callNode_ = this.callNode;
                            if (callNode_ != null) {
                                if ((arg0Value_.getIterators().length == 1)) {
                                    Node inliningTarget__ = (this);
                                    return doOne(frameValue, arg0Value_, inliningTarget__, callNode_, INLINED_NEXT_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[MapBuiltins.NextNode.doNext(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */) {
                        {
                            CallNode callNode_1 = this.callNode;
                            if (callNode_1 != null) {
                                Node inliningTarget__1 = (this);
                                return doNext(frameValue, arg0Value_, inliningTarget__1, callNode_1, INLINED_NEXT_NODE);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PMap) {
                    PMap arg0Value_ = (PMap) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[MapBuiltins.NextNode.doNext(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */) {
                            if ((arg0Value_.getIterators().length == 1)) {
                                inliningTarget__ = (this);
                                CallNode callNode_;
                                CallNode callNode__shared = this.callNode;
                                if (callNode__shared != null) {
                                    callNode_ = callNode__shared;
                                } else {
                                    callNode_ = this.insert((CallNode.create()));
                                    if (callNode_ == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.callNode == null) {
                                    VarHandle.storeStoreFence();
                                    this.callNode = callNode_;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[MapBuiltins.NextNode.doOne(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */;
                                this.state_0_ = state_0;
                                return doOne(frameValue, arg0Value_, inliningTarget__, callNode_, INLINED_NEXT_NODE);
                            }
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        inliningTarget__1 = (this);
                        CallNode callNode_1;
                        CallNode callNode_1_shared = this.callNode;
                        if (callNode_1_shared != null) {
                            callNode_1 = callNode_1_shared;
                        } else {
                            callNode_1 = this.insert((CallNode.create()));
                            if (callNode_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.callNode == null) {
                            VarHandle.storeStoreFence();
                            this.callNode = callNode_1;
                        }
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[MapBuiltins.NextNode.doOne(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[MapBuiltins.NextNode.doNext(VirtualFrame, PMap, Node, CallNode, PyIterNextNode)] */;
                        this.state_0_ = state_0;
                        return doNext(frameValue, arg0Value_, inliningTarget__1, callNode_1, INLINED_NEXT_NODE);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(IterNode.class)
    public static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#iter}
             * </pre> */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[MapBuiltins.IterNode.iter(PMap)] */ && arg0Value instanceof PMap) {
                    PMap arg0Value_ = (PMap) arg0Value;
                    return IterNode.iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PMap executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PMap) {
                    PMap arg0Value_ = (PMap) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[MapBuiltins.IterNode.iter(PMap)] */;
                    this.state_0_ = state_0;
                    return IterNode.iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(ReduceNode.class)
    public static final class ReduceNodeFactory implements NodeFactory<ReduceNode> {

        private static final ReduceNodeFactory REDUCE_NODE_FACTORY_INSTANCE = new ReduceNodeFactory();

        private ReduceNodeFactory() {
        }

        @Override
        public Class<ReduceNode> getNodeClass() {
            return ReduceNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ReduceNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ReduceNode> getInstance() {
            return REDUCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReduceNode create(ReadArgumentNode[] arguments) {
            return new ReduceNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReduceNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(ReduceNode.class)
        @SuppressWarnings("javadoc")
        public static final class ReduceNodeGen extends ReduceNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReduceNode#doit}
             * </pre> */
            @CompilationFinal private int state_0_;

            private ReduceNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[MapBuiltins.ReduceNode.doit(PMap, Object, PythonLanguage)] */ && arguments0Value_ instanceof PMap) {
                    PMap arguments0Value__ = (PMap) arguments0Value_;
                    {
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        return ReduceNode.doit(arguments0Value__, arguments1Value_, language__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private PTuple executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                {
                    PythonLanguage language__ = null;
                    if (arguments0Value instanceof PMap) {
                        PMap arguments0Value_ = (PMap) arguments0Value;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b1 /* add SpecializationActive[MapBuiltins.ReduceNode.doit(PMap, Object, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return ReduceNode.doit(arguments0Value_, arguments1Value, language__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }

        }
    }
}
