// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes.BytesFromObject;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes.BytesLikeCheck;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodesFactory.BytesFromObjectNodeGen;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodesFactory.BytesLikeCheckNodeGen;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes.FromNativeSubclassNode;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes.PointerCompareNode;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory.PointerCompareNodeGen;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AbsNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AddNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AndNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AsIntegerRatioNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.BinaryBitwiseNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.BitCountNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.BitLengthNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.BoolNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.CeilNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.ConjugateNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.DenominatorNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.DivModNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.FloatNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.FloorDivNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.FloorNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.FormatNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.FromBytesNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.GetNewArgsNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.HashNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.ImagNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.IntNewNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.IntNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.InvertNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.IsIntegerNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.LShiftNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.ModNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.MulNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.NegNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.NumeratorNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.OrNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.PosNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.PowNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.RShiftNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.RealNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.RichCompareHelperNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.RichCompareNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.RoundNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.StrNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.SubNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.ToBytesNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.TrueDivNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.TruncNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.XorNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.IntNewNode.CreateIntSubclassNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.IntNewNode.IntNodeInnerNode;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins.RichCompareHelperNode.EqNodeNativePtr;
import com.oracle.graal.python.builtins.objects.ints.IntNodes.PyLongFromByteArray;
import com.oracle.graal.python.builtins.objects.ints.IntNodesFactory.PyLongFromByteArrayNodeGen;
import com.oracle.graal.python.builtins.objects.type.TypeNodes.GetInstanceShape;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.GetInstanceShapeNodeGen;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyLongCheckNodeGen;
import com.oracle.graal.python.lib.PyLongCopy;
import com.oracle.graal.python.lib.PyLongCopyNodeGen;
import com.oracle.graal.python.lib.PyLongFromUnicodeObject;
import com.oracle.graal.python.lib.PyLongFromUnicodeObjectNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberFloatNodeGen;
import com.oracle.graal.python.lib.PyNumberLongNode;
import com.oracle.graal.python.lib.PyNumberLongNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNodeGen;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNodeGen;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.lib.PyNumberLongNode.LongFromBufferNode;
import com.oracle.graal.python.lib.PyNumberLongNodeGen.LongFromBufferNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles.IsBuiltinClassExactProfile;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory.IsBuiltinClassExactProfileNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode.GetPythonObjectClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen.GetPythonObjectClassNodeGen;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypesGen;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.IntField;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleString.EqualNode;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.api.strings.TruffleString.FromLongNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;

@GeneratedBy(IntBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class IntBuiltinsFactory {

    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilationFinal(dimensions = 1) private static final RichCmpOp[] RICH_CMP_OP_VALUES = DSLSupport.lookupEnumConstants(RichCmpOp.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(IntNewNodeFactory.getInstance(), RoundNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), TrueDivNodeFactory.getInstance(), FloorDivNodeFactory.getInstance(), DivModNodeFactory.getInstance(), ModNodeFactory.getInstance(), MulNodeFactory.getInstance(), PowNodeFactory.getInstance(), AbsNodeFactory.getInstance(), CeilNodeFactory.getInstance(), FloorNodeFactory.getInstance(), PosNodeFactory.getInstance(), NegNodeFactory.getInstance(), InvertNodeFactory.getInstance(), LShiftNodeFactory.getInstance(), RShiftNodeFactory.getInstance(), AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance(), RichCompareNodeFactory.getInstance(), ToBytesNodeFactory.getInstance(), FromBytesNodeFactory.getInstance(), BoolNodeFactory.getInstance(), StrNodeFactory.getInstance(), ReprNodeFactory.getInstance(), FormatNodeFactory.getInstance(), HashNodeFactory.getInstance(), BitCountNodeFactory.getInstance(), BitLengthNodeFactory.getInstance(), IsIntegerNodeFactory.getInstance(), RealNodeFactory.getInstance(), ImagNodeFactory.getInstance(), NumeratorNodeFactory.getInstance(), ConjugateNodeFactory.getInstance(), DenominatorNodeFactory.getInstance(), AsIntegerRatioNodeFactory.getInstance(), TruncNodeFactory.getInstance(), IntNodeFactory.getInstance(), GetNewArgsNodeFactory.getInstance(), FloatNodeFactory.getInstance());
    }

    private static RichCmpOp decodeRichCmpOp(int state) {
        if (state >= 0) {
            return RICH_CMP_OP_VALUES[state];
        } else {
            return null;
        }
    }

    private static int encodeRichCmpOp(RichCmpOp e) {
        if (e != null) {
            return e.ordinal();
        } else {
            return -1;
        }
    }

    @GeneratedBy(IntNewNode.class)
    public static final class IntNewNodeFactory implements NodeFactory<IntNewNode> {

        private static final IntNewNodeFactory INT_NEW_NODE_FACTORY_INSTANCE = new IntNewNodeFactory();

        private IntNewNodeFactory() {
        }

        @Override
        public Class<IntNewNode> getNodeClass() {
            return IntNewNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IntNewNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IntNewNode> getInstance() {
            return INT_NEW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntNewNode create() {
            return new IntNewNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNewNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 40/19 bytes
         * </pre> */
        @GeneratedBy(IntNewNode.class)
        @SuppressWarnings("javadoc")
        public static final class IntNewNodeGen extends IntNewNode {

            private static final StateField STATE_0_IntNewNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link IntNodeInnerNode} innerNode
             *   Inline method: {@link IntNodeInnerNodeGen#inline}</pre> */
            private static final IntNodeInnerNode INLINED_INNER_NODE_ = IntNodeInnerNodeGen.inline(InlineTarget.create(IntNodeInnerNode.class, STATE_0_IntNewNode_UPDATER.subUpdater(0, 14), ReferenceField.create(MethodHandles.lookup(), "innerNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "innerNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "innerNode__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link IsBuiltinClassExactProfile} isPrimitiveIntProfile
             *   Inline method: {@link IsBuiltinClassExactProfileNodeGen#inline}</pre> */
            private static final IsBuiltinClassExactProfile INLINED_IS_PRIMITIVE_INT_PROFILE_ = IsBuiltinClassExactProfileNodeGen.inline(InlineTarget.create(IsBuiltinClassExactProfile.class, STATE_0_IntNewNode_UPDATER.subUpdater(14, 5)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link CreateIntSubclassNode} createIntSubclassNode
             *   Inline method: {@link CreateIntSubclassNodeGen#inline}</pre> */
            private static final CreateIntSubclassNode INLINED_CREATE_INT_SUBCLASS_NODE_ = CreateIntSubclassNodeGen.inline(InlineTarget.create(CreateIntSubclassNode.class, STATE_0_IntNewNode_UPDATER.subUpdater(19, 4), ReferenceField.create(MethodHandles.lookup(), "createIntSubclassNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0-13: InlinedCache
             *        Specialization: {@link IntNewNode#doGeneric}
             *        Parameter: {@link IntNodeInnerNode} innerNode
             *        Inline method: {@link IntNodeInnerNodeGen#inline}
             *   14-18: InlinedCache
             *        Specialization: {@link IntNewNode#doGeneric}
             *        Parameter: {@link IsBuiltinClassExactProfile} isPrimitiveIntProfile
             *        Inline method: {@link IsBuiltinClassExactProfileNodeGen#inline}
             *   19-22: InlinedCache
             *        Specialization: {@link IntNewNode#doGeneric}
             *        Parameter: {@link CreateIntSubclassNode} createIntSubclassNode
             *        Inline method: {@link CreateIntSubclassNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link IntNodeInnerNode} innerNode
             *   Inline method: {@link IntNodeInnerNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node innerNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link IntNodeInnerNode} innerNode
             *   Inline method: {@link IntNodeInnerNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node innerNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link IntNodeInnerNode} innerNode
             *   Inline method: {@link IntNodeInnerNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node innerNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNewNode#doGeneric}
             *   Parameter: {@link CreateIntSubclassNode} createIntSubclassNode
             *   Inline method: {@link CreateIntSubclassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node createIntSubclassNode__field1_;

            private IntNewNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                {
                    Node inliningTarget__ = (this);
                    return IntNewNode.doGeneric(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_INNER_NODE_, INLINED_IS_PRIMITIVE_INT_PROFILE_, INLINED_CREATE_INT_SUBCLASS_NODE_);
                }
            }

        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link CreateIntSubclassNode#doSubclass(Object, int, PythonLanguage, GetInstanceShape)}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link CreateIntSubclassNode#doSubclass(Object, long, PythonLanguage, GetInstanceShape)}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link CreateIntSubclassNode#doSubclass(Object, boolean, PythonLanguage, GetInstanceShape)}
         *     Activation probability: 0.20500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link CreateIntSubclassNode#doSubclass(Object, PInt, PythonLanguage, GetInstanceShape)}
         *     Activation probability: 0.11500
         *     With/without class size: 5/0 bytes
         * </pre> */
        @GeneratedBy(CreateIntSubclassNode.class)
        @SuppressWarnings("javadoc")
        static final class CreateIntSubclassNodeGen {

            /**
             * Required Fields: <ul>
             * <li>{@link Inlined#state_0_}
             * <li>{@link Inlined#getInstanceShape}
             * </ul> */
            @NeverDefault
            public static CreateIntSubclassNode inline(@RequiredField(bits = 4, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
                return new CreateIntSubclassNodeGen.Inlined(target);
            }

            @GeneratedBy(CreateIntSubclassNode.class)
            @DenyReplace
            private static final class Inlined extends CreateIntSubclassNode implements UnadoptableNode {

                /**
                 * State Info: <pre>
                 *   0: SpecializationActive {@link CreateIntSubclassNode#doSubclass(Object, int, PythonLanguage, GetInstanceShape)}
                 *   1: SpecializationActive {@link CreateIntSubclassNode#doSubclass(Object, long, PythonLanguage, GetInstanceShape)}
                 *   2: SpecializationActive {@link CreateIntSubclassNode#doSubclass(Object, boolean, PythonLanguage, GetInstanceShape)}
                 *   3: SpecializationActive {@link CreateIntSubclassNode#doSubclass(Object, PInt, PythonLanguage, GetInstanceShape)}
                 * </pre> */
                private final StateField state_0_;
                private final ReferenceField<GetInstanceShape> getInstanceShape;

                @SuppressWarnings("unchecked")
                private Inlined(InlineTarget target) {
                    assert target.getTargetClass().isAssignableFrom(CreateIntSubclassNode.class);
                    this.state_0_ = target.getState(0, 4);
                    this.getInstanceShape = target.getReference(1, GetInstanceShape.class);
                }

                @Override
                public Object execute(Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    if (state_0 != 0 /* is SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, int, PythonLanguage, GetInstanceShape)] || SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, long, PythonLanguage, GetInstanceShape)] || SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, boolean, PythonLanguage, GetInstanceShape)] || SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, PInt, PythonLanguage, GetInstanceShape)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, int, PythonLanguage, GetInstanceShape)] */ && arg2Value instanceof Integer) {
                            int arg2Value_ = (int) arg2Value;
                            {
                                GetInstanceShape getInstanceShape_ = this.getInstanceShape.get(arg0Value);
                                if (getInstanceShape_ != null) {
                                    PythonLanguage language__ = (PythonLanguage.get(arg0Value));
                                    return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__, getInstanceShape_);
                                }
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, long, PythonLanguage, GetInstanceShape)] */ && arg2Value instanceof Long) {
                            long arg2Value_ = (long) arg2Value;
                            {
                                GetInstanceShape getInstanceShape_1 = this.getInstanceShape.get(arg0Value);
                                if (getInstanceShape_1 != null) {
                                    PythonLanguage language__1 = (PythonLanguage.get(arg0Value));
                                    return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__1, getInstanceShape_1);
                                }
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, boolean, PythonLanguage, GetInstanceShape)] */ && arg2Value instanceof Boolean) {
                            boolean arg2Value_ = (boolean) arg2Value;
                            {
                                GetInstanceShape getInstanceShape_2 = this.getInstanceShape.get(arg0Value);
                                if (getInstanceShape_2 != null) {
                                    PythonLanguage language__2 = (PythonLanguage.get(arg0Value));
                                    return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__2, getInstanceShape_2);
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, PInt, PythonLanguage, GetInstanceShape)] */ && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            {
                                GetInstanceShape getInstanceShape_3 = this.getInstanceShape.get(arg0Value);
                                if (getInstanceShape_3 != null) {
                                    PythonLanguage language__3 = (PythonLanguage.get(arg0Value));
                                    return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__3, getInstanceShape_3);
                                }
                            }
                        }
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                }

                private Object executeAndSpecialize(Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    {
                        PythonLanguage language__ = null;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (int) arg2Value;
                            language__ = (PythonLanguage.get(arg0Value));
                            GetInstanceShape getInstanceShape_;
                            GetInstanceShape getInstanceShape__shared = this.getInstanceShape.get(arg0Value);
                            if (getInstanceShape__shared != null) {
                                getInstanceShape_ = getInstanceShape__shared;
                            } else {
                                getInstanceShape_ = arg0Value.insert((GetInstanceShapeNodeGen.create()));
                                if (getInstanceShape_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.getInstanceShape.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.getInstanceShape.set(arg0Value, getInstanceShape_);
                            }
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, int, PythonLanguage, GetInstanceShape)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__, getInstanceShape_);
                        }
                    }
                    {
                        PythonLanguage language__1 = null;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (long) arg2Value;
                            language__1 = (PythonLanguage.get(arg0Value));
                            GetInstanceShape getInstanceShape_1;
                            GetInstanceShape getInstanceShape_1_shared = this.getInstanceShape.get(arg0Value);
                            if (getInstanceShape_1_shared != null) {
                                getInstanceShape_1 = getInstanceShape_1_shared;
                            } else {
                                getInstanceShape_1 = arg0Value.insert((GetInstanceShapeNodeGen.create()));
                                if (getInstanceShape_1 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.getInstanceShape.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.getInstanceShape.set(arg0Value, getInstanceShape_1);
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, long, PythonLanguage, GetInstanceShape)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__1, getInstanceShape_1);
                        }
                    }
                    {
                        PythonLanguage language__2 = null;
                        if (arg2Value instanceof Boolean) {
                            boolean arg2Value_ = (boolean) arg2Value;
                            language__2 = (PythonLanguage.get(arg0Value));
                            GetInstanceShape getInstanceShape_2;
                            GetInstanceShape getInstanceShape_2_shared = this.getInstanceShape.get(arg0Value);
                            if (getInstanceShape_2_shared != null) {
                                getInstanceShape_2 = getInstanceShape_2_shared;
                            } else {
                                getInstanceShape_2 = arg0Value.insert((GetInstanceShapeNodeGen.create()));
                                if (getInstanceShape_2 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.getInstanceShape.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.getInstanceShape.set(arg0Value, getInstanceShape_2);
                            }
                            state_0 = state_0 | 0b100 /* add SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, boolean, PythonLanguage, GetInstanceShape)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__2, getInstanceShape_2);
                        }
                    }
                    {
                        PythonLanguage language__3 = null;
                        if (arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            language__3 = (PythonLanguage.get(arg0Value));
                            GetInstanceShape getInstanceShape_3;
                            GetInstanceShape getInstanceShape_3_shared = this.getInstanceShape.get(arg0Value);
                            if (getInstanceShape_3_shared != null) {
                                getInstanceShape_3 = getInstanceShape_3_shared;
                            } else {
                                getInstanceShape_3 = arg0Value.insert((GetInstanceShapeNodeGen.create()));
                                if (getInstanceShape_3 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.getInstanceShape.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.getInstanceShape.set(arg0Value, getInstanceShape_3);
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[IntNewNode.CreateIntSubclassNode.doSubclass(Object, PInt, PythonLanguage, GetInstanceShape)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__3, getInstanceShape_3);
                        }
                    }
                    throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
                }

            }
        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNodeInnerNode#doNoBase}
         *     Activation probability: 0.65000
         *     With/without class size: 22/10 bytes
         *   Specialization {@link IntNodeInnerNode#doWithBase}
         *     Activation probability: 0.35000
         *     With/without class size: 27/50 bytes
         * </pre> */
        @GeneratedBy(IntNodeInnerNode.class)
        @SuppressWarnings("javadoc")
        static final class IntNodeInnerNodeGen {

            private static final StateField FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER = StateField.create(FallbackData.lookup_(), "fallback_state_0_");
            private static final InlinedBranchProfile INLINED_FALLBACK_MISSING_ARGUMENT_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 1)));
            private static final InlinedBranchProfile INLINED_FALLBACK_WRONG_BASE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(1, 1)));
            private static final InlinedBranchProfile INLINED_FALLBACK_CANNOT_CONVERT_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(2, 1)));
            private static final PyNumberAsSizeNode INLINED_FALLBACK_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineTarget.create(PyNumberAsSizeNode.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(3, 5), ReferenceField.create(FallbackData.lookup_(), "fallback_asSizeNode__field1_", Node.class)));
            private static final PyUnicodeCheckNode INLINED_FALLBACK_UNICODE_CHECK_NODE_ = PyUnicodeCheckNodeGen.inline(InlineTarget.create(PyUnicodeCheckNode.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(8, 3), ReferenceField.create(FallbackData.lookup_(), "fallback_unicodeCheckNode__field1_", Node.class)));
            private static final PyLongFromUnicodeObject INLINED_FALLBACK_LONG_FROM_UNICODE_ = PyLongFromUnicodeObjectNodeGen.inline(InlineTarget.create(PyLongFromUnicodeObject.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(11, 11), ReferenceField.create(FallbackData.lookup_(), "fallback_longFromUnicode__field1_", Node.class), ReferenceField.create(FallbackData.lookup_(), "fallback_longFromUnicode__field2_", Node.class), ReferenceField.create(FallbackData.lookup_(), "fallback_longFromUnicode__field3_", Node.class), ReferenceField.create(FallbackData.lookup_(), "fallback_longFromUnicode__field4_", Node.class), ReferenceField.create(FallbackData.lookup_(), "fallback_longFromUnicode__field5_", Node.class)));
            private static final StateField FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_1_UPDATER = StateField.create(FallbackData.lookup_(), "fallback_state_1_");
            private static final BytesLikeCheck INLINED_FALLBACK_BYTES_LIKE_CHECK_ = BytesLikeCheckNodeGen.inline(InlineTarget.create(BytesLikeCheck.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_1_UPDATER.subUpdater(0, 19), ReferenceField.create(FallbackData.lookup_(), "fallback_bytesLikeCheck__field1_", Node.class), ReferenceField.create(FallbackData.lookup_(), "fallback_bytesLikeCheck__field2_", Node.class), ReferenceField.create(FallbackData.lookup_(), "fallback_bytesLikeCheck__field3_", Node.class)));
            private static final PRaiseNode INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(22, 1)));

            /**
             * Required Fields: <ul>
             * <li>{@link Inlined#state_0_}
             * <li>{@link Inlined#noBase_pyNumberLongNode__field1_}
             * <li>{@link Inlined#noBase_pyNumberLongNode__field2_}
             * <li>{@link Inlined#fallback_cache}
             * </ul> */
            @NeverDefault
            public static IntNodeInnerNode inline(@RequiredField(bits = 14, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
                return new IntNodeInnerNodeGen.Inlined(target);
            }

            @GeneratedBy(IntNodeInnerNode.class)
            @DenyReplace
            private static final class Inlined extends IntNodeInnerNode implements UnadoptableNode {

                /**
                 * State Info: <pre>
                 *   0: SpecializationActive {@link IntNodeInnerNode#doNoBase}
                 *   1: SpecializationActive {@link IntNodeInnerNode#doWithBase}
                 *   2: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doNoBase}
                 *        Parameter: {@link InlinedBranchProfile} noX
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   3-13: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doNoBase}
                 *        Parameter: {@link PyNumberLongNode} pyNumberLongNode
                 *        Inline method: {@link PyNumberLongNodeGen#inline}
                 * </pre> */
                private final StateField state_0_;
                private final ReferenceField<Node> noBase_pyNumberLongNode__field1_;
                private final ReferenceField<Node> noBase_pyNumberLongNode__field2_;
                private final ReferenceField<FallbackData> fallback_cache;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doNoBase}
                 *   Parameter: {@link InlinedBranchProfile} noX
                 *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
                private final InlinedBranchProfile noBase_noX_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doNoBase}
                 *   Parameter: {@link PyNumberLongNode} pyNumberLongNode
                 *   Inline method: {@link PyNumberLongNodeGen#inline}</pre> */
                private final PyNumberLongNode noBase_pyNumberLongNode_;

                @SuppressWarnings("unchecked")
                private Inlined(InlineTarget target) {
                    assert target.getTargetClass().isAssignableFrom(IntNodeInnerNode.class);
                    this.state_0_ = target.getState(0, 14);
                    this.noBase_pyNumberLongNode__field1_ = target.getReference(1, Node.class);
                    this.noBase_pyNumberLongNode__field2_ = target.getReference(2, Node.class);
                    this.fallback_cache = target.getReference(3, FallbackData.class);
                    this.noBase_noX_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, state_0_.subUpdater(2, 1)));
                    this.noBase_pyNumberLongNode_ = PyNumberLongNodeGen.inline(InlineTarget.create(PyNumberLongNode.class, state_0_.subUpdater(3, 11), noBase_pyNumberLongNode__field1_, noBase_pyNumberLongNode__field2_));
                }

                @SuppressWarnings("static-method")
                private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, Object arg2Value) {
                    if (!((state_0 & 0b1) != 0 /* is SpecializationActive[IntNewNode.IntNodeInnerNode.doNoBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, PyNumberLongNode)] */) && (PGuards.isNoValue(arg2Value))) {
                        return false;
                    }
                    return true;
                }

                @Override
                public Object execute(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    if ((state_0 & 0b11) != 0 /* is SpecializationActive[IntNewNode.IntNodeInnerNode.doNoBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, PyNumberLongNode)] || SpecializationActive[IntNewNode.IntNodeInnerNode.doWithBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, PyNumberAsSizeNode, PyUnicodeCheckNode, PyLongFromUnicodeObject, BytesLikeCheck, LongFromBufferNode, PRaiseNode)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntNewNode.IntNodeInnerNode.doNoBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, PyNumberLongNode)] */) {
                            if ((PGuards.isNoValue(arg2Value))) {
                                assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.noBase_pyNumberLongNode__field1_, this.noBase_pyNumberLongNode__field2_);
                                return IntNodeInnerNode.doNoBase(frameValue, arg0Value, arg1Value, arg2Value, this.noBase_noX_, this.noBase_pyNumberLongNode_);
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntNewNode.IntNodeInnerNode.doWithBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, PyNumberAsSizeNode, PyUnicodeCheckNode, PyLongFromUnicodeObject, BytesLikeCheck, LongFromBufferNode, PRaiseNode)] */) {
                            FallbackData s1_ = this.fallback_cache.get(arg0Value);
                            if (s1_ != null) {
                                if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                                    return IntNodeInnerNode.doWithBase(frameValue, s1_, arg1Value, arg2Value, INLINED_FALLBACK_MISSING_ARGUMENT_, INLINED_FALLBACK_WRONG_BASE_, INLINED_FALLBACK_CANNOT_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_UNICODE_CHECK_NODE_, INLINED_FALLBACK_LONG_FROM_UNICODE_, INLINED_FALLBACK_BYTES_LIKE_CHECK_, s1_.fromBufferNode_, INLINED_FALLBACK_RAISE_NODE_);
                                }
                            }
                        }
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
                }

                private Object executeAndSpecialize(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    if ((PGuards.isNoValue(arg2Value))) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntNewNode.IntNodeInnerNode.doNoBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, PyNumberLongNode)] */;
                        this.state_0_.set(arg0Value, state_0);
                        assert InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.noBase_pyNumberLongNode__field1_, this.noBase_pyNumberLongNode__field2_);
                        return IntNodeInnerNode.doNoBase(frameValue, arg0Value, arg1Value, arg2Value, this.noBase_noX_, this.noBase_pyNumberLongNode_);
                    }
                    FallbackData s1_ = arg0Value.insert(new FallbackData());
                    LongFromBufferNode fromBufferNode__ = s1_.insert((LongFromBufferNodeGen.create()));
                    Objects.requireNonNull(fromBufferNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.fromBufferNode_ = fromBufferNode__;
                    VarHandle.storeStoreFence();
                    this.fallback_cache.set(arg0Value, s1_);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IntNewNode.IntNodeInnerNode.doWithBase(VirtualFrame, Node, Object, Object, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, PyNumberAsSizeNode, PyUnicodeCheckNode, PyLongFromUnicodeObject, BytesLikeCheck, LongFromBufferNode, PRaiseNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return IntNodeInnerNode.doWithBase(frameValue, s1_, arg1Value, arg2Value, INLINED_FALLBACK_MISSING_ARGUMENT_, INLINED_FALLBACK_WRONG_BASE_, INLINED_FALLBACK_CANNOT_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_UNICODE_CHECK_NODE_, INLINED_FALLBACK_LONG_FROM_UNICODE_, INLINED_FALLBACK_BYTES_LIKE_CHECK_, fromBufferNode__, INLINED_FALLBACK_RAISE_NODE_);
                }

            }
            @GeneratedBy(IntNodeInnerNode.class)
            @DenyReplace
            private static final class FallbackData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link InlinedBranchProfile} missingArgument
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   1: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link InlinedBranchProfile} wrongBase
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   2: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link InlinedBranchProfile} cannotConvert
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   3-7: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link PyNumberAsSizeNode} asSizeNode
                 *        Inline method: {@link PyNumberAsSizeNodeGen#inline}
                 *   8-10: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link PyUnicodeCheckNode} unicodeCheckNode
                 *        Inline method: {@link PyUnicodeCheckNodeGen#inline}
                 *   11-21: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link PyLongFromUnicodeObject} longFromUnicode
                 *        Inline method: {@link PyLongFromUnicodeObjectNodeGen#inline}
                 *   22: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link PRaiseNode} raiseNode
                 *        Inline method: {@link PRaiseNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int fallback_state_0_;
                /**
                 * State Info: <pre>
                 *   0-18: InlinedCache
                 *        Specialization: {@link IntNodeInnerNode#doWithBase}
                 *        Parameter: {@link BytesLikeCheck} bytesLikeCheck
                 *        Inline method: {@link BytesLikeCheckNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int fallback_state_1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
                 *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_asSizeNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyUnicodeCheckNode} unicodeCheckNode
                 *   Inline method: {@link PyUnicodeCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_unicodeCheckNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyLongFromUnicodeObject} longFromUnicode
                 *   Inline method: {@link PyLongFromUnicodeObjectNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_longFromUnicode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyLongFromUnicodeObject} longFromUnicode
                 *   Inline method: {@link PyLongFromUnicodeObjectNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_longFromUnicode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyLongFromUnicodeObject} longFromUnicode
                 *   Inline method: {@link PyLongFromUnicodeObjectNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_longFromUnicode__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyLongFromUnicodeObject} longFromUnicode
                 *   Inline method: {@link PyLongFromUnicodeObjectNodeGen#inline}
                 *   Inline field: {@link Node} field4</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_longFromUnicode__field4_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link PyLongFromUnicodeObject} longFromUnicode
                 *   Inline method: {@link PyLongFromUnicodeObjectNodeGen#inline}
                 *   Inline field: {@link Node} field5</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_longFromUnicode__field5_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link BytesLikeCheck} bytesLikeCheck
                 *   Inline method: {@link BytesLikeCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_bytesLikeCheck__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link BytesLikeCheck} bytesLikeCheck
                 *   Inline method: {@link BytesLikeCheckNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_bytesLikeCheck__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link BytesLikeCheck} bytesLikeCheck
                 *   Inline method: {@link BytesLikeCheckNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node fallback_bytesLikeCheck__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IntNodeInnerNode#doWithBase}
                 *   Parameter: {@link LongFromBufferNode} fromBufferNode</pre> */
                @Child LongFromBufferNode fromBufferNode_;

                FallbackData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(RoundNode.class)
    static final class RoundNodeFactory implements NodeFactory<RoundNode> {

        private static final RoundNodeFactory ROUND_NODE_FACTORY_INSTANCE = new RoundNodeFactory();

        private RoundNodeFactory() {
        }

        @Override
        public Class<RoundNode> getNodeClass() {
            return RoundNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public RoundNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RoundNode> getInstance() {
            return ROUND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RoundNode create() {
            return new RoundNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RoundNode#roundIntNone}
         *     Activation probability: 0.17364
         *     With/without class size: 6/0 bytes
         *   Specialization {@link RoundNode#roundLongNone}
         *     Activation probability: 0.15727
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RoundNode#roundPIntNone}
         *     Activation probability: 0.14091
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RoundNode#roundLongInt}
         *     Activation probability: 0.12455
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RoundNode#roundPIntInt}
         *     Activation probability: 0.10818
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RoundNode#roundLongLong}
         *     Activation probability: 0.09182
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RoundNode#roundPIntLong(PInt, long, Node, InlinedBranchProfile, InlinedBranchProfile)}
         *     Activation probability: 0.07545
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RoundNode#roundPIntLong(long, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)}
         *     Activation probability: 0.05909
         *     With/without class size: 4/0 bytes
         *   Specialization {@link RoundNode#roundPIntPInt(PInt, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)}
         *     Activation probability: 0.04273
         *     With/without class size: 4/0 bytes
         *   Specialization {@link RoundNode#roundPIntPInt(Object, Object, Node)}
         *     Activation probability: 0.02636
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(RoundNode.class)
        @SuppressWarnings("javadoc")
        static final class RoundNodeGen extends RoundNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link RoundNode#roundLongInt}
             *   Parameter: {@link InlinedBranchProfile} intOverflow
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_INT_OVF = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(20, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link RoundNode#roundLongInt}
             *   Parameter: {@link InlinedBranchProfile} longOverflow
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_LONG_OVF = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(21, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RoundNode#roundIntNone}
             *   1: SpecializationActive {@link RoundNode#roundLongNone}
             *   2: SpecializationActive {@link RoundNode#roundPIntNone}
             *   3: SpecializationActive {@link RoundNode#roundLongInt}
             *   4: SpecializationActive {@link RoundNode#roundPIntInt}
             *   5: SpecializationActive {@link RoundNode#roundLongLong}
             *   6: SpecializationActive {@link RoundNode#roundPIntLong(PInt, long, Node, InlinedBranchProfile, InlinedBranchProfile)}
             *   7: SpecializationActive {@link RoundNode#roundPIntLong(long, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)}
             *   8: SpecializationActive {@link RoundNode#roundPIntPInt(PInt, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)}
             *   9: SpecializationActive {@link RoundNode#roundPIntPInt(Object, Object, Node)}
             *   10-11: ImplicitCast[type=int, index=0]
             *   12-14: ImplicitCast[type=long, index=0]
             *   15-16: ImplicitCast[type=int, index=1]
             *   17-19: ImplicitCast[type=long, index=1]
             *   20: InlinedCache
             *        Specialization: {@link RoundNode#roundLongInt}
             *        Parameter: {@link InlinedBranchProfile} intOverflow
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   21: InlinedCache
             *        Specialization: {@link RoundNode#roundLongInt}
             *        Parameter: {@link InlinedBranchProfile} longOverflow
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private RoundNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1111111111) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundIntNone(int, PNone)] || SpecializationActive[IntBuiltins.RoundNode.roundLongNone(long, PNone)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntNone(PInt, PNone, Node, PythonLanguage)] || SpecializationActive[IntBuiltins.RoundNode.roundLongInt(long, int, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntInt(PInt, int, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundLongLong(long, long, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(PInt, long, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(long, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(PInt, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(Object, Object, Node)] */) {
                    if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundIntNone(int, PNone)] || SpecializationActive[IntBuiltins.RoundNode.roundLongNone(long, PNone)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntNone(PInt, PNone, Node, PythonLanguage)] */ && arg1Value instanceof PNone) {
                        PNone arg1Value_ = (PNone) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundIntNone(int, PNone)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b110000000000) >>> 10 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b110000000000) >>> 10 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                            return RoundNode.roundIntNone(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundLongNone(long, PNone)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return RoundNode.roundLongNone(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntNone(PInt, PNone, Node, PythonLanguage)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            {
                                Node inliningTarget__ = (this);
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return RoundNode.roundPIntNone(arg0Value_, arg1Value_, inliningTarget__, language__);
                            }
                        }
                    }
                    if ((state_0 & 0b11000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundLongInt(long, int, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntInt(PInt, int, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18000) >>> 15 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18000) >>> 15 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundLongInt(long, int, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__1 = (this);
                                return RoundNode.roundLongInt(arg0Value_, arg1Value_, inliningTarget__1, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntInt(PInt, int, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            {
                                Node inliningTarget__2 = (this);
                                return RoundNode.roundPIntInt(arg0Value_, arg1Value_, inliningTarget__2, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                    }
                    if ((state_0 & 0b1100000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundLongLong(long, long, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(PInt, long, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundLongLong(long, long, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__3 = (this);
                                return RoundNode.roundLongLong(arg0Value_, arg1Value_, inliningTarget__3, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(PInt, long, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            {
                                Node inliningTarget__4 = (this);
                                return RoundNode.roundPIntLong(arg0Value_, arg1Value_, inliningTarget__4, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                    }
                    if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(long, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(PInt, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(long, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__5 = (this);
                                return RoundNode.roundPIntLong(arg0Value_, arg1Value_, inliningTarget__5, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(PInt, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            {
                                Node inliningTarget__6 = (this);
                                return RoundNode.roundPIntPInt(arg0Value_, arg1Value_, inliningTarget__6, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(Object, Object, Node)] */) {
                        if ((!(MathGuards.isInteger(arg1Value)))) {
                            Node inliningTarget__7 = (this);
                            return RoundNode.roundPIntPInt(arg0Value, arg1Value, inliningTarget__7);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof PNone) {
                    PNone arg1Value_ = (PNone) arg1Value;
                    {
                        int intCast0;
                        if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                            state_0 = (state_0 | (intCast0 << 10) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.RoundNode.roundIntNone(int, PNone)] */;
                            this.state_0_ = state_0;
                            return RoundNode.roundIntNone(arg0Value_, arg1Value_);
                        }
                    }
                    {
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            state_0 = (state_0 | (longCast0 << 12) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.RoundNode.roundLongNone(long, PNone)] */;
                            this.state_0_ = state_0;
                            return RoundNode.roundLongNone(arg0Value_, arg1Value_);
                        }
                    }
                    {
                        PythonLanguage language__ = null;
                        Node inliningTarget__ = null;
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            inliningTarget__ = (this);
                            language__ = (PythonLanguage.get(this));
                            state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.RoundNode.roundPIntNone(PInt, PNone, Node, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return RoundNode.roundPIntNone(arg0Value_, arg1Value_, inliningTarget__, language__);
                        }
                    }
                }
                {
                    int intCast1;
                    if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        {
                            Node inliningTarget__1 = null;
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                inliningTarget__1 = (this);
                                state_0 = (state_0 | (longCast0 << 12) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (intCast1 << 15) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.RoundNode.roundLongInt(long, int, Node, InlinedBranchProfile, InlinedBranchProfile)] */;
                                this.state_0_ = state_0;
                                return RoundNode.roundLongInt(arg0Value_, arg1Value_, inliningTarget__1, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                        {
                            Node inliningTarget__2 = null;
                            if (arg0Value instanceof PInt) {
                                PInt arg0Value_ = (PInt) arg0Value;
                                inliningTarget__2 = (this);
                                state_0 = (state_0 | (intCast1 << 15) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.RoundNode.roundPIntInt(PInt, int, Node, InlinedBranchProfile, InlinedBranchProfile)] */;
                                this.state_0_ = state_0;
                                return RoundNode.roundPIntInt(arg0Value_, arg1Value_, inliningTarget__2, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            Node inliningTarget__3 = null;
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                inliningTarget__3 = (this);
                                state_0 = (state_0 | (longCast0 << 12) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 17) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.RoundNode.roundLongLong(long, long, Node, InlinedBranchProfile, InlinedBranchProfile)] */;
                                this.state_0_ = state_0;
                                return RoundNode.roundLongLong(arg0Value_, arg1Value_, inliningTarget__3, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                        {
                            Node inliningTarget__4 = null;
                            if (arg0Value instanceof PInt) {
                                PInt arg0Value_ = (PInt) arg0Value;
                                inliningTarget__4 = (this);
                                state_0 = (state_0 | (longCast1 << 17) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(PInt, long, Node, InlinedBranchProfile, InlinedBranchProfile)] */;
                                this.state_0_ = state_0;
                                return RoundNode.roundPIntLong(arg0Value_, arg1Value_, inliningTarget__4, INLINED_INT_OVF, INLINED_LONG_OVF);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        Node inliningTarget__5 = null;
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            inliningTarget__5 = (this);
                            state_0 = (state_0 | (longCast0 << 12) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.RoundNode.roundPIntLong(long, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return RoundNode.roundPIntLong(arg0Value_, arg1Value_, inliningTarget__5, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                    }
                    {
                        Node inliningTarget__6 = null;
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            inliningTarget__6 = (this);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(PInt, PInt, Node, InlinedBranchProfile, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return RoundNode.roundPIntPInt(arg0Value_, arg1Value_, inliningTarget__6, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                    }
                }
                {
                    Node inliningTarget__7 = null;
                    if ((!(MathGuards.isInteger(arg1Value)))) {
                        inliningTarget__7 = (this);
                        state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.RoundNode.roundPIntPInt(Object, Object, Node)] */;
                        this.state_0_ = state_0;
                        return RoundNode.roundPIntPInt(arg0Value, arg1Value, inliningTarget__7);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(AddNode.class)
    public static final class AddNodeFactory implements NodeFactory<AddNode> {

        private static final AddNodeFactory ADD_NODE_FACTORY_INSTANCE = new AddNodeFactory();

        private AddNodeFactory() {
        }

        @Override
        public Class<AddNode> getNodeClass() {
            return AddNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public AddNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AddNode> getInstance() {
            return ADD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AddNode create() {
            return new AddNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AddNode#doII}
         *     Activation probability: 0.17364
         *     With/without class size: 6/0 bytes
         *   Specialization {@link AddNode#doLL}
         *     Activation probability: 0.15727
         *     With/without class size: 5/0 bytes
         *   Specialization {@link AddNode#doLLOvf}
         *     Activation probability: 0.14091
         *     With/without class size: 5/0 bytes
         *   Specialization {@link AddNode#doPLNarrow}
         *     Activation probability: 0.12455
         *     With/without class size: 5/0 bytes
         *   Specialization {@link AddNode#doPL}
         *     Activation probability: 0.10818
         *     With/without class size: 5/0 bytes
         *   Specialization {@link AddNode#doLPNarrow}
         *     Activation probability: 0.09182
         *     With/without class size: 5/0 bytes
         *   Specialization {@link AddNode#doLP}
         *     Activation probability: 0.07545
         *     With/without class size: 4/0 bytes
         *   Specialization {@link AddNode#doPPNarrow}
         *     Activation probability: 0.05909
         *     With/without class size: 4/0 bytes
         *   Specialization {@link AddNode#doPP}
         *     Activation probability: 0.04273
         *     With/without class size: 4/0 bytes
         *   Specialization {@link AddNode#doGeneric}
         *     Activation probability: 0.02636
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(AddNode.class)
        @SuppressWarnings("javadoc")
        public static final class AddNodeGen extends AddNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AddNode#doII}
             *   1: SpecializationExcluded {@link AddNode#doII}
             *   2: SpecializationActive {@link AddNode#doLL}
             *   3: SpecializationExcluded {@link AddNode#doLL}
             *   4: SpecializationActive {@link AddNode#doLLOvf}
             *   5: SpecializationActive {@link AddNode#doPLNarrow}
             *   6: SpecializationExcluded {@link AddNode#doPLNarrow}
             *   7: SpecializationActive {@link AddNode#doPL}
             *   8: SpecializationActive {@link AddNode#doLPNarrow}
             *   9: SpecializationExcluded {@link AddNode#doLPNarrow}
             *   10: SpecializationActive {@link AddNode#doLP}
             *   11: SpecializationActive {@link AddNode#doPPNarrow}
             *   12: SpecializationExcluded {@link AddNode#doPPNarrow}
             *   13: SpecializationActive {@link AddNode#doPP}
             *   14: SpecializationActive {@link AddNode#doGeneric}
             *   15-16: ImplicitCast[type=int, index=0]
             *   17-18: ImplicitCast[type=int, index=1]
             *   19-21: ImplicitCast[type=long, index=0]
             *   22-24: ImplicitCast[type=long, index=1]
             * </pre> */
            @CompilationFinal private int state_0_;

            private AddNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b110110110110101) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doII(int, int)] || SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] || SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] || SpecializationActive[IntBuiltins.AddNode.doPL(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] || SpecializationActive[IntBuiltins.AddNode.doLP(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.AddNode.doPP(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18000) >>> 15 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18000) >>> 15 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            try {
                                return AddNode.doII(arg0Value_, arg1Value_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0b10110100) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] || SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] || SpecializationActive[IntBuiltins.AddNode.doPL(PInt, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b10100) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] || SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */) {
                                try {
                                    return AddNode.doLL(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return AddNode.doLLOvf(arg0Value_, arg1Value_, language__);
                                }
                            }
                        }
                        if ((state_0 & 0b10100000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] || SpecializationActive[IntBuiltins.AddNode.doPL(PInt, long, PythonLanguage)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] */) {
                                try {
                                    return AddNode.doPLNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doPL(PInt, long, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__1 = (PythonLanguage.get(this));
                                    return AddNode.doPL(arg0Value_, arg1Value_, language__1);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10110100000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] || SpecializationActive[IntBuiltins.AddNode.doLP(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.AddNode.doPP(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b10100000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] || SpecializationActive[IntBuiltins.AddNode.doLP(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] */) {
                                try {
                                    return AddNode.doLPNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] */;
                                    state_0 = state_0 | 0b1000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLP(long, PInt, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__2 = (PythonLanguage.get(this));
                                    return AddNode.doLP(arg0Value_, arg1Value_, language__2);
                                }
                            }
                        }
                        if ((state_0 & 0b10100000000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.AddNode.doPP(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] */) {
                                try {
                                    return AddNode.doPPNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] */;
                                    state_0 = state_0 | 0b1000000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doPP(PInt, PInt, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__3 = (PythonLanguage.get(this));
                                    return AddNode.doPP(arg0Value_, arg1Value_, language__3);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doGeneric(Object, Object)] */) {
                        if ((AddNode.isNotImplemented(arg0Value) || AddNode.isNotImplemented(arg1Value))) {
                            return AddNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000010101) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doII(int, int)] || SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] || SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] || SpecializationActive[IntBuiltins.AddNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */) {
                        try {
                            return AddNode.doII(arg0Value, arg1Value);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b10100) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] || SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */) {
                                try {
                                    return AddNode.doLL(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */;
                                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return AddNode.doLLOvf(arg0Value_, arg1Value_, language__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.AddNode.doGeneric(Object, Object)] */) {
                        if ((AddNode.isNotImplemented(arg0Value) || AddNode.isNotImplemented(arg1Value))) {
                            return AddNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10100)) == 0 /* is-not SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] && SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            state_0 = (state_0 | (intCast0 << 15) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 17) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */;
                            this.state_0_ = state_0;
                            try {
                                return AddNode.doII(arg0Value_, arg1Value_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.AddNode.doII(int, int)] */;
                                    state_0 = (state_0 | (longCast0 << 19) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return AddNode.doLL(arg0Value_, arg1Value_);
                                    } catch (ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                                {
                                    PythonLanguage language__ = null;
                                    language__ = (PythonLanguage.get(this));
                                    state_0 = state_0 & 0xfffffffa /* remove SpecializationActive[IntBuiltins.AddNode.doII(int, int)], SpecializationActive[IntBuiltins.AddNode.doLL(long, long)] */;
                                    state_0 = (state_0 | (longCast0 << 19) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.AddNode.doLLOvf(long, long, PythonLanguage)] */;
                                    this.state_0_ = state_0;
                                    return AddNode.doLLOvf(arg0Value_, arg1Value_, language__);
                                }
                            }
                        }
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[IntBuiltins.AddNode.doPL(PInt, long, PythonLanguage)] */ && ((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */) {
                                state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] */;
                                this.state_0_ = state_0;
                                try {
                                    return AddNode.doPLNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] */;
                                    state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            {
                                PythonLanguage language__1 = null;
                                language__1 = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.AddNode.doPLNarrow(PInt, long)] */;
                                state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.AddNode.doPL(PInt, long, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return AddNode.doPL(arg0Value_, arg1Value_, language__1);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.AddNode.doLP(long, PInt, PythonLanguage)] */ && ((state_0 & 0b1000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                state_0 = (state_0 | (longCast0 << 19) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] */;
                                this.state_0_ = state_0;
                                try {
                                    return AddNode.doLPNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] */;
                                    state_0 = state_0 | 0b1000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            {
                                PythonLanguage language__2 = null;
                                language__2 = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.AddNode.doLPNarrow(long, PInt)] */;
                                state_0 = (state_0 | (longCast0 << 19) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.AddNode.doLP(long, PInt, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return AddNode.doLP(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if (((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.AddNode.doPP(PInt, PInt, PythonLanguage)] */ && ((state_0 & 0b1000000000000)) == 0 /* is-not SpecializationExcluded  */) {
                            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] */;
                            this.state_0_ = state_0;
                            try {
                                return AddNode.doPPNarrow(arg0Value_, arg1Value_);
                            } catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] */;
                                state_0 = state_0 | 0b1000000000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        {
                            PythonLanguage language__3 = null;
                            language__3 = (PythonLanguage.get(this));
                            state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[IntBuiltins.AddNode.doPPNarrow(PInt, PInt)] */;
                            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[IntBuiltins.AddNode.doPP(PInt, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return AddNode.doPP(arg0Value_, arg1Value_, language__3);
                        }
                    }
                }
                if ((AddNode.isNotImplemented(arg0Value) || AddNode.isNotImplemented(arg1Value))) {
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[IntBuiltins.AddNode.doGeneric(Object, Object)] */;
                    this.state_0_ = state_0;
                    return AddNode.doGeneric(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(SubNode.class)
    public static final class SubNodeFactory implements NodeFactory<SubNode> {

        private static final SubNodeFactory SUB_NODE_FACTORY_INSTANCE = new SubNodeFactory();

        private SubNodeFactory() {
        }

        @Override
        public Class<SubNode> getNodeClass() {
            return SubNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public SubNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<SubNode> getInstance() {
            return SUB_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SubNode create() {
            return new SubNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SubNode#doII}
         *     Activation probability: 0.15909
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doIIOvf}
         *     Activation probability: 0.14545
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doLL}
         *     Activation probability: 0.13182
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doLongWithOverflow}
         *     Activation probability: 0.11818
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doPIntLongAndNarrow}
         *     Activation probability: 0.10455
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doPIntLong}
         *     Activation probability: 0.09091
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doLongPIntAndNarrow}
         *     Activation probability: 0.07727
         *     With/without class size: 4/0 bytes
         *   Specialization {@link SubNode#doLongPInt}
         *     Activation probability: 0.06364
         *     With/without class size: 4/0 bytes
         *   Specialization {@link SubNode#doPIntPIntAndNarrow}
         *     Activation probability: 0.05000
         *     With/without class size: 4/0 bytes
         *   Specialization {@link SubNode#doPIntPInt}
         *     Activation probability: 0.03636
         *     With/without class size: 4/0 bytes
         *   Specialization {@link SubNode#doGeneric}
         *     Activation probability: 0.02273
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(SubNode.class)
        @SuppressWarnings("javadoc")
        public static final class SubNodeGen extends SubNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SubNode#doII}
             *   1: SpecializationExcluded {@link SubNode#doII}
             *   2: SpecializationActive {@link SubNode#doIIOvf}
             *   3: SpecializationActive {@link SubNode#doLL}
             *   4: SpecializationExcluded {@link SubNode#doLL}
             *   5: SpecializationActive {@link SubNode#doLongWithOverflow}
             *   6: SpecializationActive {@link SubNode#doPIntLongAndNarrow}
             *   7: SpecializationExcluded {@link SubNode#doPIntLongAndNarrow}
             *   8: SpecializationActive {@link SubNode#doPIntLong}
             *   9: SpecializationActive {@link SubNode#doLongPIntAndNarrow}
             *   10: SpecializationExcluded {@link SubNode#doLongPIntAndNarrow}
             *   11: SpecializationActive {@link SubNode#doLongPInt}
             *   12: SpecializationActive {@link SubNode#doPIntPIntAndNarrow}
             *   13: SpecializationExcluded {@link SubNode#doPIntPIntAndNarrow}
             *   14: SpecializationActive {@link SubNode#doPIntPInt}
             *   15: SpecializationActive {@link SubNode#doGeneric}
             *   16-17: ImplicitCast[type=int, index=0]
             *   18-19: ImplicitCast[type=int, index=1]
             *   20-22: ImplicitCast[type=long, index=0]
             *   23-25: ImplicitCast[type=long, index=1]
             * </pre> */
            @CompilationFinal private int state_0_;

            private SubNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */
                     && (state_0 & 0x3f00000) == 0x3f00000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] */
                     && (state_0 & 0x3800000) == 0x3800000) && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg1Value instanceof PInt) {
                    if (!((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] */
                     && (state_0 & 0x700000) == 0x700000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] */) && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1101101101101101) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doII(int, int)] || SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] || SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] || SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] || SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] || SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] || SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.SubNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doII(int, int)] || SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xc0000) >>> 18 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xc0000) >>> 18 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */) {
                                try {
                                    return SubNode.doII(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] */) {
                                return SubNode.doIIOvf(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0b101101000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] || SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] || SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] || SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x3800000) >>> 23 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x3800000) >>> 23 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] || SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x700000) >>> 20 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x700000) >>> 20 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */) {
                                try {
                                    return SubNode.doLL(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */) {
                                {
                                    Node inliningTarget__ = (this);
                                    return SubNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                                }
                            }
                        }
                        if ((state_0 & 0b101000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] || SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] */) {
                                try {
                                    return SubNode.doPIntLongAndNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return SubNode.doPIntLong(arg0Value_, arg1Value_, language__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b101101000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] || SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b101000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] || SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x700000) >>> 20 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x700000) >>> 20 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] */) {
                                try {
                                    return SubNode.doLongPIntAndNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] */;
                                    state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__1 = (PythonLanguage.get(this));
                                    return SubNode.doLongPInt(arg0Value_, arg1Value_, language__1);
                                }
                            }
                        }
                        if ((state_0 & 0b101000000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] */) {
                                try {
                                    return SubNode.doPIntPIntAndNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffefff /* remove SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] */;
                                    state_0 = state_0 | 0b10000000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] */) {
                                {
                                    PythonLanguage language__2 = (PythonLanguage.get(this));
                                    return SubNode.doPIntPInt(arg0Value_, arg1Value_, language__2);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return SubNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000101101) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doII(int, int)] || SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] || SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] || SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] || SpecializationActive[IntBuiltins.SubNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doII(int, int)] || SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */) {
                            try {
                                return SubNode.doII(arg0Value, arg1Value);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] */) {
                            return SubNode.doIIOvf(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] || SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x700000) >>> 20 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x700000) >>> 20 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x3800000) >>> 23 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x3800000) >>> 23 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */) {
                                try {
                                    return SubNode.doLL(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */) {
                                {
                                    Node inliningTarget__ = (this);
                                    return SubNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[IntBuiltins.SubNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return SubNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                                state_0 = (state_0 | (intCast0 << 16) /* set-int ImplicitCast[type=int, index=0] */);
                                state_0 = (state_0 | (intCast1 << 18) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */;
                                this.state_0_ = state_0;
                                try {
                                    return SubNode.doII(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.SubNode.doII(int, int)] */;
                            state_0 = (state_0 | (intCast0 << 16) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 18) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.SubNode.doIIOvf(int, int)] */;
                            this.state_0_ = state_0;
                            return SubNode.doIIOvf(arg0Value_, arg1Value_);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */ && ((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                                    state_0 = (state_0 | (longCast0 << 20) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 23) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return SubNode.doLL(arg0Value_, arg1Value_);
                                    } catch (ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                                {
                                    Node inliningTarget__ = null;
                                    inliningTarget__ = (this);
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.SubNode.doLL(long, long)] */;
                                    state_0 = (state_0 | (longCast0 << 20) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 23) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.SubNode.doLongWithOverflow(long, long, Node)] */;
                                    this.state_0_ = state_0;
                                    return SubNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                                }
                            }
                        }
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] */ && ((state_0 & 0b10000000)) == 0 /* is-not SpecializationExcluded  */) {
                                state_0 = (state_0 | (longCast1 << 23) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] */;
                                this.state_0_ = state_0;
                                try {
                                    return SubNode.doPIntLongAndNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] */;
                                    state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            {
                                PythonLanguage language__ = null;
                                language__ = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[IntBuiltins.SubNode.doPIntLongAndNarrow(PInt, long)] */;
                                state_0 = (state_0 | (longCast1 << 23) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.SubNode.doPIntLong(PInt, long, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return SubNode.doPIntLong(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] */ && ((state_0 & 0b10000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                state_0 = (state_0 | (longCast0 << 20) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] */;
                                this.state_0_ = state_0;
                                try {
                                    return SubNode.doLongPIntAndNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] */;
                                    state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            {
                                PythonLanguage language__1 = null;
                                language__1 = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[IntBuiltins.SubNode.doLongPIntAndNarrow(long, PInt)] */;
                                state_0 = (state_0 | (longCast0 << 20) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.SubNode.doLongPInt(long, PInt, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return SubNode.doLongPInt(arg0Value_, arg1Value_, language__1);
                            }
                        }
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if (((state_0 & 0b100000000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] */ && ((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationExcluded  */) {
                            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] */;
                            this.state_0_ = state_0;
                            try {
                                return SubNode.doPIntPIntAndNarrow(arg0Value_, arg1Value_);
                            } catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xffffefff /* remove SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] */;
                                state_0 = state_0 | 0b10000000000000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        {
                            PythonLanguage language__2 = null;
                            language__2 = (PythonLanguage.get(this));
                            state_0 = state_0 & 0xffffefff /* remove SpecializationActive[IntBuiltins.SubNode.doPIntPIntAndNarrow(PInt, PInt)] */;
                            state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[IntBuiltins.SubNode.doPIntPInt(PInt, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return SubNode.doPIntPInt(arg0Value_, arg1Value_, language__2);
                        }
                    }
                }
                state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[IntBuiltins.SubNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return SubNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(TrueDivNode.class)
    public static final class TrueDivNodeFactory implements NodeFactory<TrueDivNode> {

        private static final TrueDivNodeFactory TRUE_DIV_NODE_FACTORY_INSTANCE = new TrueDivNodeFactory();

        private TrueDivNodeFactory() {
        }

        @Override
        public Class<TrueDivNode> getNodeClass() {
            return TrueDivNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TrueDivNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<TrueDivNode> getInstance() {
            return TRUE_DIV_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TrueDivNode create() {
            return new TrueDivNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TrueDivNode#divII}
         *     Activation probability: 0.23929
         *     With/without class size: 7/0 bytes
         *   Specialization {@link TrueDivNode#divLL}
         *     Activation probability: 0.20714
         *     With/without class size: 7/0 bytes
         *   Specialization {@link TrueDivNode#divLLLarge}
         *     Activation probability: 0.17500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link TrueDivNode#doPI}
         *     Activation probability: 0.14286
         *     With/without class size: 6/0 bytes
         *   Specialization {@link TrueDivNode#doPL}
         *     Activation probability: 0.11071
         *     With/without class size: 5/0 bytes
         *   Specialization {@link TrueDivNode#doPP}
         *     Activation probability: 0.07857
         *     With/without class size: 5/0 bytes
         *   Specialization {@link TrueDivNode#doGeneric}
         *     Activation probability: 0.04643
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(TrueDivNode.class)
        @SuppressWarnings("javadoc")
        public static final class TrueDivNodeGen extends TrueDivNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link TrueDivNode#divII}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_UPDATER.subUpdater(17, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link TrueDivNode#divII}
             *   1: SpecializationActive {@link TrueDivNode#divLL}
             *   2: SpecializationActive {@link TrueDivNode#divLLLarge}
             *   3: SpecializationActive {@link TrueDivNode#doPI}
             *   4: SpecializationActive {@link TrueDivNode#doPL}
             *   5: SpecializationActive {@link TrueDivNode#doPP}
             *   6: SpecializationActive {@link TrueDivNode#doGeneric}
             *   7-8: ImplicitCast[type=int, index=0]
             *   9-10: ImplicitCast[type=int, index=1]
             *   11-13: ImplicitCast[type=long, index=0]
             *   14-16: ImplicitCast[type=long, index=1]
             *   17: InlinedCache
             *        Specialization: {@link TrueDivNode#divII}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private TrueDivNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divII(int, int, Node, PRaiseNode)] */
                 && (state_0 & 0b11110000000) == 0b11110000000) && PythonIntegerTypesGen.isImplicitInteger(arg0Value) && PythonIntegerTypesGen.isImplicitInteger(arg1Value)) {
                    return false;
                }
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                            if ((TrueDivNode.fitsIntoDouble(arg0Value_))) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                                if ((TrueDivNode.fitsIntoDouble(arg1Value_))) {
                                    return false;
                                }
                            }
                        }
                        {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                            if ((!(TrueDivNode.fitsIntoDouble(arg0Value_)) || !(TrueDivNode.fitsIntoDouble(arg1Value_)))) {
                                return false;
                            }
                        }
                    }
                    if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPI(long, PInt, Node, PRaiseNode)] */
                     && (state_0 & 0b11100000000000) == 0b11100000000000) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPL(PInt, long, Node, PRaiseNode)] */
                     && (state_0 & 0x1c000) == 0x1c000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPP(PInt, PInt, Node, PRaiseNode)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1111111) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doPI(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doPL(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doPP(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divII(int, int, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b110000000) >>> 7 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b110000000) >>> 7 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000000000) >>> 9 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000000000) >>> 9 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            {
                                Node inliningTarget__ = (this);
                                return TrueDivNode.divII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b1110) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doPI(long, PInt, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if ((state_0 & 0b110) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] */) {
                                if ((TrueDivNode.fitsIntoDouble(arg0Value_)) && (TrueDivNode.fitsIntoDouble(arg1Value_))) {
                                    Node inliningTarget__1 = (this);
                                    return TrueDivNode.divLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] */) {
                                if ((!(TrueDivNode.fitsIntoDouble(arg0Value_)) || !(TrueDivNode.fitsIntoDouble(arg1Value_)))) {
                                    Node inliningTarget__2 = (this);
                                    return TrueDivNode.divLLLarge(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                }
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPI(long, PInt, Node, PRaiseNode)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                Node inliningTarget__3 = (this);
                                return TrueDivNode.doPI(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b110000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPL(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doPP(PInt, PInt, Node, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPL(PInt, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__4 = (this);
                                return TrueDivNode.doPL(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doPP(PInt, PInt, Node, PRaiseNode)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                Node inliningTarget__5 = (this);
                                return TrueDivNode.doPP(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TrueDivNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000111) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divII(int, int, Node, PRaiseNode)] */) {
                        {
                            Node inliningTarget__ = (this);
                            return TrueDivNode.divII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b110) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000000000) >>> 11 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] */) {
                                if ((TrueDivNode.fitsIntoDouble(arg0Value_)) && (TrueDivNode.fitsIntoDouble(arg1Value_))) {
                                    Node inliningTarget__1 = (this);
                                    return TrueDivNode.divLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] */) {
                                if ((!(TrueDivNode.fitsIntoDouble(arg0Value_)) || !(TrueDivNode.fitsIntoDouble(arg1Value_)))) {
                                    Node inliningTarget__2 = (this);
                                    return TrueDivNode.divLLLarge(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.TrueDivNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TrueDivNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (intCast0 << 7) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 9) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.TrueDivNode.divII(int, int, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return TrueDivNode.divII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        {
                            int longCast1;
                            if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                                {
                                    Node inliningTarget__1 = null;
                                    if ((TrueDivNode.fitsIntoDouble(arg0Value_)) && (TrueDivNode.fitsIntoDouble(arg1Value_))) {
                                        inliningTarget__1 = (this);
                                        state_0 = (state_0 | (longCast0 << 11) /* set-int ImplicitCast[type=long, index=0] */);
                                        state_0 = (state_0 | (longCast1 << 14) /* set-int ImplicitCast[type=long, index=1] */);
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.TrueDivNode.divLL(long, long, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return TrueDivNode.divLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                                    }
                                }
                                {
                                    Node inliningTarget__2 = null;
                                    if ((!(TrueDivNode.fitsIntoDouble(arg0Value_)) || !(TrueDivNode.fitsIntoDouble(arg1Value_)))) {
                                        inliningTarget__2 = (this);
                                        state_0 = (state_0 | (longCast0 << 11) /* set-int ImplicitCast[type=long, index=0] */);
                                        state_0 = (state_0 | (longCast1 << 14) /* set-int ImplicitCast[type=long, index=1] */);
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.TrueDivNode.divLLLarge(long, long, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return TrueDivNode.divLLLarge(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                    }
                                }
                            }
                        }
                        {
                            Node inliningTarget__3 = null;
                            if (arg1Value instanceof PInt) {
                                PInt arg1Value_ = (PInt) arg1Value;
                                inliningTarget__3 = (this);
                                state_0 = (state_0 | (longCast0 << 11) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.TrueDivNode.doPI(long, PInt, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return TrueDivNode.doPI(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        Node inliningTarget__4 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__4 = (this);
                            state_0 = (state_0 | (longCast1 << 14) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.TrueDivNode.doPL(PInt, long, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return TrueDivNode.doPL(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                        }
                    }
                    {
                        Node inliningTarget__5 = null;
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            inliningTarget__5 = (this);
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.TrueDivNode.doPP(PInt, PInt, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return TrueDivNode.doPP(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                        }
                    }
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.TrueDivNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return TrueDivNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(FloorDivNode.class)
    public static final class FloorDivNodeFactory implements NodeFactory<FloorDivNode> {

        private static final FloorDivNodeFactory FLOOR_DIV_NODE_FACTORY_INSTANCE = new FloorDivNodeFactory();

        private FloorDivNodeFactory() {
        }

        @Override
        public Class<FloorDivNode> getNodeClass() {
            return FloorDivNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FloorDivNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<FloorDivNode> getInstance() {
            return FLOOR_DIV_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FloorDivNode create() {
            return new FloorDivNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FloorDivNode#doII}
         *     Activation probability: 0.15909
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FloorDivNode#doLL}
         *     Activation probability: 0.14545
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FloorDivNode#doIPi}
         *     Activation probability: 0.13182
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FloorDivNode#doLPi}
         *     Activation probability: 0.11818
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FloorDivNode#doPiIAndNarrow}
         *     Activation probability: 0.10455
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FloorDivNode#doPiI}
         *     Activation probability: 0.09091
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FloorDivNode#doPiLAndNarrow}
         *     Activation probability: 0.07727
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FloorDivNode#doPiL}
         *     Activation probability: 0.06364
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FloorDivNode#doPiPiAndNarrow}
         *     Activation probability: 0.05000
         *     With/without class size: 4/0 bytes
         *   Specialization {@link FloorDivNode#doPiPi}
         *     Activation probability: 0.03636
         *     With/without class size: 4/0 bytes
         *   Specialization {@link FloorDivNode#doGeneric}
         *     Activation probability: 0.02273
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(FloorDivNode.class)
        @SuppressWarnings("javadoc")
        public static final class FloorDivNodeGen extends FloorDivNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link FloorDivNode#doII}
             *   Parameter: {@link InlinedBranchProfile} overflowValueProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_OVERFLOW_VALUE_PROFILE = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(24, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link FloorDivNode#doII}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_UPDATER.subUpdater(25, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FloorDivNode#doII}
             *   1: SpecializationActive {@link FloorDivNode#doLL}
             *   2: SpecializationActive {@link FloorDivNode#doIPi}
             *   3: SpecializationActive {@link FloorDivNode#doLPi}
             *   4: SpecializationActive {@link FloorDivNode#doPiIAndNarrow}
             *   5: SpecializationExcluded {@link FloorDivNode#doPiIAndNarrow}
             *   6: SpecializationActive {@link FloorDivNode#doPiI}
             *   7: SpecializationActive {@link FloorDivNode#doPiLAndNarrow}
             *   8: SpecializationExcluded {@link FloorDivNode#doPiLAndNarrow}
             *   9: SpecializationActive {@link FloorDivNode#doPiL}
             *   10: SpecializationActive {@link FloorDivNode#doPiPiAndNarrow}
             *   11: SpecializationExcluded {@link FloorDivNode#doPiPiAndNarrow}
             *   12: SpecializationActive {@link FloorDivNode#doPiPi}
             *   13: SpecializationActive {@link FloorDivNode#doGeneric}
             *   14-15: ImplicitCast[type=int, index=0]
             *   16-17: ImplicitCast[type=int, index=1]
             *   18-20: ImplicitCast[type=long, index=0]
             *   21-23: ImplicitCast[type=long, index=1]
             *   24: InlinedCache
             *        Specialization: {@link FloorDivNode#doII}
             *        Parameter: {@link InlinedBranchProfile} overflowValueProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   25: InlinedCache
             *        Specialization: {@link FloorDivNode#doII}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private FloorDivNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doLL(long, long, Node, InlinedBranchProfile, PRaiseNode)] */
                     && (state_0 & 0xfc0000) == 0xfc0000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doLPi(long, PInt, Node, InlinedBranchProfile, PRaiseNode)] */
                     && (state_0 & 0x1c0000) == 0x1c0000) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */
                     && (state_0 & 0xe00000) == 0xe00000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11011011011111) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doII(int, int, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doLL(long, long, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doIPi(int, PInt, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doLPi(long, PInt, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doII(int, int, Node, InlinedBranchProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            {
                                Node inliningTarget__ = (this);
                                return FloorDivNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doLL(long, long, Node, InlinedBranchProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__1 = (this);
                                return FloorDivNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doIPi(int, PInt, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doLPi(long, PInt, Node, InlinedBranchProfile, PRaiseNode)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doIPi(int, PInt, Node, InlinedBranchProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                            {
                                Node inliningTarget__2 = (this);
                                return FloorDivNode.doIPi(arg0Value_, arg1Value_, inliningTarget__2, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doLPi(long, PInt, Node, InlinedBranchProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__3 = (this);
                                return FloorDivNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b1011011010000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b1010000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__4 = (this);
                                    try {
                                        return FloorDivNode.doPiIAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__5 = (this);
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return FloorDivNode.doPiI(arg0Value_, arg1Value_, inliningTarget__5, language__, INLINED_RAISE_NODE);
                                }
                            }
                        }
                        if ((state_0 & 0b1010000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__6 = (this);
                                    try {
                                        return FloorDivNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__7 = (this);
                                    PythonLanguage language__1 = (PythonLanguage.get(this));
                                    return FloorDivNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                                }
                            }
                        }
                        if ((state_0 & 0b1010000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__8 = (this);
                                    try {
                                        return FloorDivNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b100000000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__9 = (this);
                                    PythonLanguage language__2 = (PythonLanguage.get(this));
                                    return FloorDivNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__9, language__2, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return FloorDivNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000011) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doII(int, int, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doLL(long, long, Node, InlinedBranchProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.FloorDivNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doII(int, int, Node, InlinedBranchProfile, PRaiseNode)] */) {
                        {
                            Node inliningTarget__ = (this);
                            return FloorDivNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doLL(long, long, Node, InlinedBranchProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__1 = (this);
                                return FloorDivNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.FloorDivNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return FloorDivNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (intCast0 << 14) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 16) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.FloorDivNode.doII(int, int, Node, InlinedBranchProfile, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return FloorDivNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__1 = (this);
                            state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.FloorDivNode.doLL(long, long, Node, InlinedBranchProfile, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return FloorDivNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        Node inliningTarget__2 = null;
                        int intCast0;
                        if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                            inliningTarget__2 = (this);
                            state_0 = (state_0 | (intCast0 << 14) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.FloorDivNode.doIPi(int, PInt, Node, InlinedBranchProfile, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return FloorDivNode.doIPi(arg0Value_, arg1Value_, inliningTarget__2, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                    {
                        Node inliningTarget__3 = null;
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            inliningTarget__3 = (this);
                            state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doLPi(long, PInt, Node, InlinedBranchProfile, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return FloorDivNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            {
                                Node inliningTarget__4 = null;
                                if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[IntBuiltins.FloorDivNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b100000)) == 0 /* is-not SpecializationExcluded  */) {
                                    inliningTarget__4 = (this);
                                    state_0 = (state_0 | (intCast1 << 16) /* set-int ImplicitCast[type=int, index=1] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return FloorDivNode.doPiIAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            {
                                PythonLanguage language__ = null;
                                Node inliningTarget__5 = null;
                                inliningTarget__5 = (this);
                                language__ = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiIAndNarrow(PInt, int, Node, PRaiseNode)] */;
                                state_0 = (state_0 | (intCast1 << 16) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return FloorDivNode.doPiI(arg0Value_, arg1Value_, inliningTarget__5, language__, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    {
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            {
                                Node inliningTarget__6 = null;
                                if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b100000000)) == 0 /* is-not SpecializationExcluded  */) {
                                    inliningTarget__6 = (this);
                                    state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return FloorDivNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            {
                                PythonLanguage language__1 = null;
                                Node inliningTarget__7 = null;
                                inliningTarget__7 = (this);
                                language__1 = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return FloorDivNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        {
                            Node inliningTarget__8 = null;
                            if (((state_0 & 0b1000000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b100000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                inliningTarget__8 = (this);
                                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                try {
                                    return FloorDivNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                    state_0 = state_0 | 0b100000000000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                        }
                        {
                            PythonLanguage language__2 = null;
                            Node inliningTarget__9 = null;
                            inliningTarget__9 = (this);
                            language__2 = (PythonLanguage.get(this));
                            state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[IntBuiltins.FloorDivNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return FloorDivNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__9, language__2, INLINED_RAISE_NODE);
                        }
                    }
                }
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[IntBuiltins.FloorDivNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return FloorDivNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(DivModNode.class)
    static final class DivModNodeFactory implements NodeFactory<DivModNode> {

        private static final DivModNodeFactory DIV_MOD_NODE_FACTORY_INSTANCE = new DivModNodeFactory();

        private DivModNodeFactory() {
        }

        @Override
        public Class<DivModNode> getNodeClass() {
            return DivModNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public DivModNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<DivModNode> getInstance() {
            return DIV_MOD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DivModNode create() {
            return new DivModNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DivModNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 28/8 bytes
         * </pre> */
        @GeneratedBy(DivModNode.class)
        @SuppressWarnings("javadoc")
        static final class DivModNodeGen extends DivModNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DivModNode#doGeneric}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivModNode#doGeneric}
             *   Parameter: {@link FloorDivNode} floorDivNode</pre> */
            @Child private FloorDivNode floorDivNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivModNode#doGeneric}
             *   Parameter: {@link ModNode} modNode</pre> */
            @Child private ModNode modNode_;

            private DivModNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.DivModNode.doGeneric(VirtualFrame, Object, Object, Node, FloorDivNode, ModNode)] */) {
                    {
                        FloorDivNode floorDivNode__ = this.floorDivNode_;
                        if (floorDivNode__ != null) {
                            ModNode modNode__ = this.modNode_;
                            if (modNode__ != null) {
                                Node inliningTarget__ = (this);
                                return DivModNode.doGeneric(frameValue, arg0Value, arg1Value, inliningTarget__, floorDivNode__, modNode__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    FloorDivNode floorDivNode__ = this.insert((FloorDivNode.create()));
                    Objects.requireNonNull(floorDivNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.floorDivNode_ = floorDivNode__;
                    ModNode modNode__ = this.insert((ModNode.create()));
                    Objects.requireNonNull(modNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.modNode_ = modNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.DivModNode.doGeneric(VirtualFrame, Object, Object, Node, FloorDivNode, ModNode)] */;
                    this.state_0_ = state_0;
                    return DivModNode.doGeneric(frameValue, arg0Value, arg1Value, inliningTarget__, floorDivNode__, modNode__);
                }
            }

        }
    }
    @GeneratedBy(ModNode.class)
    public static final class ModNodeFactory implements NodeFactory<ModNode> {

        private static final ModNodeFactory MOD_NODE_FACTORY_INSTANCE = new ModNodeFactory();

        private ModNodeFactory() {
        }

        @Override
        public Class<ModNode> getNodeClass() {
            return ModNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ModNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ModNode> getInstance() {
            return MOD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ModNode create() {
            return new ModNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ModNode#doII}
         *     Activation probability: 0.11917
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doLL}
         *     Activation probability: 0.11167
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doLPiAndNarrow}
         *     Activation probability: 0.10417
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doLPi}
         *     Activation probability: 0.09667
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doLPiNegativeAndNarrow}
         *     Activation probability: 0.08917
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doLPiNegative}
         *     Activation probability: 0.08167
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doPiLAndNarrow}
         *     Activation probability: 0.07417
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doPiL}
         *     Activation probability: 0.06667
         *     With/without class size: 5/0 bytes
         *   Specialization {@link ModNode#doPiLNegAndNarrow}
         *     Activation probability: 0.05917
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ModNode#doPiLNeg}
         *     Activation probability: 0.05167
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ModNode#doPiPiAndNarrow}
         *     Activation probability: 0.04417
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ModNode#doPiPi}
         *     Activation probability: 0.03667
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ModNode#doPiPiNegAndNarrow}
         *     Activation probability: 0.02917
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ModNode#doPiPiNeg}
         *     Activation probability: 0.02167
         *     With/without class size: 4/0 bytes
         *   Specialization {@link ModNode#doGeneric}
         *     Activation probability: 0.01417
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(ModNode.class)
        @SuppressWarnings("javadoc")
        public static final class ModNodeGen extends ModNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ModNode#doII}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_UPDATER.subUpdater(31, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ModNode#doII}
             *   1: SpecializationActive {@link ModNode#doLL}
             *   2: SpecializationActive {@link ModNode#doLPiAndNarrow}
             *   3: SpecializationExcluded {@link ModNode#doLPiAndNarrow}
             *   4: SpecializationActive {@link ModNode#doLPi}
             *   5: SpecializationActive {@link ModNode#doLPiNegativeAndNarrow}
             *   6: SpecializationExcluded {@link ModNode#doLPiNegativeAndNarrow}
             *   7: SpecializationActive {@link ModNode#doLPiNegative}
             *   8: SpecializationActive {@link ModNode#doPiLAndNarrow}
             *   9: SpecializationExcluded {@link ModNode#doPiLAndNarrow}
             *   10: SpecializationActive {@link ModNode#doPiL}
             *   11: SpecializationActive {@link ModNode#doPiLNegAndNarrow}
             *   12: SpecializationExcluded {@link ModNode#doPiLNegAndNarrow}
             *   13: SpecializationActive {@link ModNode#doPiLNeg}
             *   14: SpecializationActive {@link ModNode#doPiPiAndNarrow}
             *   15: SpecializationExcluded {@link ModNode#doPiPiAndNarrow}
             *   16: SpecializationActive {@link ModNode#doPiPi}
             *   17: SpecializationActive {@link ModNode#doPiPiNegAndNarrow}
             *   18: SpecializationExcluded {@link ModNode#doPiPiNegAndNarrow}
             *   19: SpecializationActive {@link ModNode#doPiPiNeg}
             *   20: SpecializationActive {@link ModNode#doGeneric}
             *   21-22: ImplicitCast[type=int, index=0]
             *   23-24: ImplicitCast[type=int, index=1]
             *   25-27: ImplicitCast[type=long, index=0]
             *   28-30: ImplicitCast[type=long, index=1]
             *   31: InlinedCache
             *        Specialization: {@link ModNode#doII}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private ModNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] */
                     && (state_0 & 0x7e000000) == 0x7e000000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (arg1Value instanceof PInt) {
                        {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((arg1Value_.isZeroOrPositive())) {
                                return false;
                            }
                        }
                        {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((!(arg1Value_.isZeroOrPositive()))) {
                                return false;
                            }
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                            if ((arg1Value_ >= 0)) {
                                return false;
                            }
                        }
                        {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                            if ((arg1Value_ < 0)) {
                                return false;
                            }
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((arg1Value_.isZeroOrPositive())) {
                                return false;
                            }
                        }
                        {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((!(arg1Value_.isZeroOrPositive()))) {
                                return false;
                            }
                        }
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1b6db7) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPi(long, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiNegative(long, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLNeg(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.ModNode.doPiPiNeg(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.ModNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doII(int, int, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x600000) >>> 21 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x600000) >>> 21 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x1800000) >>> 23 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x1800000) >>> 23 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            {
                                Node inliningTarget__ = (this);
                                return ModNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b10110110) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPi(long, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiNegative(long, PInt, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__1 = (this);
                                return ModNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b10110100) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPi(long, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLPiNegative(long, PInt, Node, PythonLanguage, PRaiseNode)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] */) {
                                if ((arg1Value_.isZeroOrPositive())) {
                                    Node inliningTarget__2 = (this);
                                    try {
                                        return ModNode.doLPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLPi(long, PInt, Node, PythonLanguage, PRaiseNode)] */) {
                                if ((arg1Value_.isZeroOrPositive())) {
                                    Node inliningTarget__3 = (this);
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return ModNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, language__, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] */) {
                                if ((!(arg1Value_.isZeroOrPositive()))) {
                                    Node inliningTarget__4 = (this);
                                    try {
                                        return ModNode.doLPiNegativeAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLPiNegative(long, PInt, Node, PythonLanguage, PRaiseNode)] */) {
                                if ((!(arg1Value_.isZeroOrPositive()))) {
                                    Node inliningTarget__5 = (this);
                                    PythonLanguage language__1 = (PythonLanguage.get(this));
                                    return ModNode.doLPiNegative(arg0Value_, arg1Value_, inliningTarget__5, language__1, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0xb6d00) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLNeg(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.ModNode.doPiPiNeg(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b10110100000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiLNeg(PInt, long, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */) {
                                if ((arg1Value_ >= 0)) {
                                    Node inliningTarget__6 = (this);
                                    try {
                                        return ModNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b1000000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */) {
                                if ((arg1Value_ >= 0)) {
                                    Node inliningTarget__7 = (this);
                                    PythonLanguage language__2 = (PythonLanguage.get(this));
                                    return ModNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__2, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] */) {
                                if ((arg1Value_ < 0)) {
                                    Node inliningTarget__8 = (this);
                                    try {
                                        return ModNode.doPiLNegAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b1000000000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiLNeg(PInt, long, Node, PythonLanguage, PRaiseNode)] */) {
                                if ((arg1Value_ < 0)) {
                                    Node inliningTarget__9 = (this);
                                    PythonLanguage language__3 = (PythonLanguage.get(this));
                                    return ModNode.doPiLNeg(arg0Value_, arg1Value_, inliningTarget__9, language__3, INLINED_RAISE_NODE);
                                }
                            }
                        }
                        if ((state_0 & 0xb4000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] || SpecializationActive[IntBuiltins.ModNode.doPiPiNeg(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */) {
                                if ((arg1Value_.isZeroOrPositive())) {
                                    Node inliningTarget__10 = (this);
                                    try {
                                        return ModNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffbfff /* remove SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b1000000000000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0x10000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */) {
                                if ((arg1Value_.isZeroOrPositive())) {
                                    Node inliningTarget__11 = (this);
                                    PythonLanguage language__4 = (PythonLanguage.get(this));
                                    return ModNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__11, language__4, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0x20000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] */) {
                                if ((!(arg1Value_.isZeroOrPositive()))) {
                                    try {
                                        return ModNode.doPiPiNegAndNarrow(arg0Value_, arg1Value_);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffdffff /* remove SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] */;
                                        state_0 = state_0 | 0x40000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0x80000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doPiPiNeg(PInt, PInt, PythonLanguage)] */) {
                                if ((!(arg1Value_.isZeroOrPositive()))) {
                                    PythonLanguage language__5 = (PythonLanguage.get(this));
                                    return ModNode.doPiPiNeg(arg0Value_, arg1Value_, language__5);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x100000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return ModNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x100003) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.ModNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doII(int, int, Node, PRaiseNode)] */) {
                        {
                            Node inliningTarget__ = (this);
                            return ModNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000000) >>> 28 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__1 = (this);
                                return ModNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x100000) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return ModNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public int executeInt(int arg0Value, int arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.ModNode.doII(int, int, Node, PRaiseNode)] */) {
                    {
                        Node inliningTarget__ = (this);
                        return ModNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return expectInteger(executeAndSpecialize(arg0Value, arg1Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (intCast0 << 21) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 23) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.ModNode.doII(int, int, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return ModNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        {
                            Node inliningTarget__1 = null;
                            int longCast1;
                            if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                                inliningTarget__1 = (this);
                                state_0 = (state_0 | (longCast0 << 25) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 28) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.ModNode.doLL(long, long, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return ModNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                Node inliningTarget__2 = null;
                                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[IntBuiltins.ModNode.doLPi(long, PInt, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                                    if ((arg1Value_.isZeroOrPositive())) {
                                        inliningTarget__2 = (this);
                                        state_0 = (state_0 | (longCast0 << 25) /* set-int ImplicitCast[type=long, index=0] */);
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        try {
                                            return ModNode.doLPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                        } catch (OverflowException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_);
                                        }
                                    }
                                }
                            }
                            {
                                PythonLanguage language__ = null;
                                Node inliningTarget__3 = null;
                                if ((arg1Value_.isZeroOrPositive())) {
                                    inliningTarget__3 = (this);
                                    language__ = (PythonLanguage.get(this));
                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.ModNode.doLPiAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                    state_0 = (state_0 | (longCast0 << 25) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.ModNode.doLPi(long, PInt, Node, PythonLanguage, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    return ModNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, language__, INLINED_RAISE_NODE);
                                }
                            }
                            {
                                Node inliningTarget__4 = null;
                                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[IntBuiltins.ModNode.doLPiNegative(long, PInt, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */) {
                                    if ((!(arg1Value_.isZeroOrPositive()))) {
                                        inliningTarget__4 = (this);
                                        state_0 = (state_0 | (longCast0 << 25) /* set-int ImplicitCast[type=long, index=0] */);
                                        state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        try {
                                            return ModNode.doLPiNegativeAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                                        } catch (OverflowException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                            state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_);
                                        }
                                    }
                                }
                            }
                            {
                                PythonLanguage language__1 = null;
                                Node inliningTarget__5 = null;
                                if ((!(arg1Value_.isZeroOrPositive()))) {
                                    inliningTarget__5 = (this);
                                    language__1 = (PythonLanguage.get(this));
                                    state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.ModNode.doLPiNegativeAndNarrow(long, PInt, Node, PRaiseNode)] */;
                                    state_0 = (state_0 | (longCast0 << 25) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.ModNode.doLPiNegative(long, PInt, Node, PythonLanguage, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    return ModNode.doLPiNegative(arg0Value_, arg1Value_, inliningTarget__5, language__1, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            {
                                Node inliningTarget__6 = null;
                                if (((state_0 & 0b10000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.ModNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b1000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                    if ((arg1Value_ >= 0)) {
                                        inliningTarget__6 = (this);
                                        state_0 = (state_0 | (longCast1 << 28) /* set-int ImplicitCast[type=long, index=1] */);
                                        state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        try {
                                            return ModNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                                        } catch (OverflowException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                            state_0 = state_0 | 0b1000000000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_);
                                        }
                                    }
                                }
                            }
                            {
                                PythonLanguage language__2 = null;
                                Node inliningTarget__7 = null;
                                if ((arg1Value_ >= 0)) {
                                    inliningTarget__7 = (this);
                                    language__2 = (PythonLanguage.get(this));
                                    state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.ModNode.doPiLAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                    state_0 = (state_0 | (longCast1 << 28) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.ModNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    return ModNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__2, INLINED_RAISE_NODE);
                                }
                            }
                            {
                                Node inliningTarget__8 = null;
                                if (((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.ModNode.doPiLNeg(PInt, long, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b1000000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                    if ((arg1Value_ < 0)) {
                                        inliningTarget__8 = (this);
                                        state_0 = (state_0 | (longCast1 << 28) /* set-int ImplicitCast[type=long, index=1] */);
                                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        try {
                                            return ModNode.doPiLNegAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                                        } catch (OverflowException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                            state_0 = state_0 | 0b1000000000000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_);
                                        }
                                    }
                                }
                            }
                            {
                                PythonLanguage language__3 = null;
                                Node inliningTarget__9 = null;
                                if ((arg1Value_ < 0)) {
                                    inliningTarget__9 = (this);
                                    language__3 = (PythonLanguage.get(this));
                                    state_0 = state_0 & 0xfffff7ff /* remove SpecializationActive[IntBuiltins.ModNode.doPiLNegAndNarrow(PInt, long, Node, PRaiseNode)] */;
                                    state_0 = (state_0 | (longCast1 << 28) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[IntBuiltins.ModNode.doPiLNeg(PInt, long, Node, PythonLanguage, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    return ModNode.doPiLNeg(arg0Value_, arg1Value_, inliningTarget__9, language__3, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        {
                            Node inliningTarget__10 = null;
                            if (((state_0 & 0x10000)) == 0 /* is-not SpecializationActive[IntBuiltins.ModNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */ && ((state_0 & 0b1000000000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                if ((arg1Value_.isZeroOrPositive())) {
                                    inliningTarget__10 = (this);
                                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return ModNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xffffbfff /* remove SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b1000000000000000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                        }
                        {
                            PythonLanguage language__4 = null;
                            Node inliningTarget__11 = null;
                            if ((arg1Value_.isZeroOrPositive())) {
                                inliningTarget__11 = (this);
                                language__4 = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xffffbfff /* remove SpecializationActive[IntBuiltins.ModNode.doPiPiAndNarrow(PInt, PInt, Node, PRaiseNode)] */;
                                state_0 = state_0 | 0x10000 /* add SpecializationActive[IntBuiltins.ModNode.doPiPi(PInt, PInt, Node, PythonLanguage, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return ModNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__11, language__4, INLINED_RAISE_NODE);
                            }
                        }
                        if (((state_0 & 0x80000)) == 0 /* is-not SpecializationActive[IntBuiltins.ModNode.doPiPiNeg(PInt, PInt, PythonLanguage)] */ && ((state_0 & 0x40000)) == 0 /* is-not SpecializationExcluded  */) {
                            if ((!(arg1Value_.isZeroOrPositive()))) {
                                state_0 = state_0 | 0x20000 /* add SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] */;
                                this.state_0_ = state_0;
                                try {
                                    return ModNode.doPiPiNegAndNarrow(arg0Value_, arg1Value_);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffdffff /* remove SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] */;
                                    state_0 = state_0 | 0x40000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                        }
                        {
                            PythonLanguage language__5 = null;
                            if ((!(arg1Value_.isZeroOrPositive()))) {
                                language__5 = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xfffdffff /* remove SpecializationActive[IntBuiltins.ModNode.doPiPiNegAndNarrow(PInt, PInt)] */;
                                state_0 = state_0 | 0x80000 /* add SpecializationActive[IntBuiltins.ModNode.doPiPiNeg(PInt, PInt, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return ModNode.doPiPiNeg(arg0Value_, arg1Value_, language__5);
                            }
                        }
                    }
                }
                state_0 = state_0 | 0x100000 /* add SpecializationActive[IntBuiltins.ModNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return ModNode.doGeneric(arg0Value, arg1Value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (int) value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }

        }
    }
    @GeneratedBy(MulNode.class)
    public static final class MulNodeFactory implements NodeFactory<MulNode> {

        private static final MulNodeFactory MUL_NODE_FACTORY_INSTANCE = new MulNodeFactory();

        private MulNodeFactory() {
        }

        @Override
        public Class<MulNode> getNodeClass() {
            return MulNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public MulNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<MulNode> getInstance() {
            return MUL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MulNode create() {
            return new MulNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link MulNode#doII}
         *     Activation probability: 0.14679
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doIIL}
         *     Activation probability: 0.13526
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doLL}
         *     Activation probability: 0.12372
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doLongWithOverflow}
         *     Activation probability: 0.11218
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doPIntLongZero(PInt, long)}
         *     Activation probability: 0.10064
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doPIntLongZero(long, PInt)}
         *     Activation probability: 0.08910
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doPIntLongOne(PInt, long, PythonLanguage)}
         *     Activation probability: 0.07756
         *     With/without class size: 4/0 bytes
         *   Specialization {@link MulNode#doPIntLongOne(long, PInt, PythonLanguage)}
         *     Activation probability: 0.06603
         *     With/without class size: 4/0 bytes
         *   Specialization {@link MulNode#doPIntLong(PInt, long, PythonLanguage)}
         *     Activation probability: 0.05449
         *     With/without class size: 4/0 bytes
         *   Specialization {@link MulNode#doPIntLong(long, PInt, PythonLanguage)}
         *     Activation probability: 0.04295
         *     With/without class size: 4/0 bytes
         *   Specialization {@link MulNode#doPIntPInt}
         *     Activation probability: 0.03141
         *     With/without class size: 4/0 bytes
         *   Specialization {@link MulNode#doGeneric}
         *     Activation probability: 0.01987
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(MulNode.class)
        @SuppressWarnings("javadoc")
        public static final class MulNodeGen extends MulNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MulNode#doII}
             *   1: SpecializationExcluded {@link MulNode#doII}
             *   2: SpecializationActive {@link MulNode#doIIL}
             *   3: SpecializationActive {@link MulNode#doLL}
             *   4: SpecializationExcluded {@link MulNode#doLL}
             *   5: SpecializationActive {@link MulNode#doLongWithOverflow}
             *   6: SpecializationActive {@link MulNode#doPIntLongZero(PInt, long)}
             *   7: SpecializationActive {@link MulNode#doPIntLongZero(long, PInt)}
             *   8: SpecializationActive {@link MulNode#doPIntLongOne(PInt, long, PythonLanguage)}
             *   9: SpecializationActive {@link MulNode#doPIntLongOne(long, PInt, PythonLanguage)}
             *   10: SpecializationActive {@link MulNode#doPIntLong(PInt, long, PythonLanguage)}
             *   11: SpecializationActive {@link MulNode#doPIntLong(long, PInt, PythonLanguage)}
             *   12: SpecializationActive {@link MulNode#doPIntPInt}
             *   13: SpecializationActive {@link MulNode#doGeneric}
             *   14-15: ImplicitCast[type=int, index=0]
             *   16-17: ImplicitCast[type=int, index=1]
             *   18-20: ImplicitCast[type=long, index=0]
             *   21-23: ImplicitCast[type=long, index=1]
             * </pre> */
            @CompilationFinal private int state_0_;

            private MulNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */
                     && (state_0 & 0xfc0000) == 0xfc0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PInt) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                        if ((arg1Value_ == 0)) {
                            return false;
                        }
                    }
                }
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                    if ((arg0Value_ == 0)) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                    if ((arg1Value_ == 1)) {
                        return false;
                    }
                }
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                    if ((arg0Value_ == 1)) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                    if ((arg1Value_ != 0) && (arg1Value_ != 1)) {
                        return false;
                    }
                }
                if (arg1Value instanceof PInt) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                        if ((arg0Value_ != 0) && (arg0Value_ != 1)) {
                            return false;
                        }
                    }
                    if (!((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntPInt(PInt, PInt, PythonLanguage)] */) && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111111101101) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doII(int, int)] || SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] || SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] || SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] || SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(PInt, long)] || SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(long, PInt)] || SpecializationActive[IntBuiltins.MulNode.doPIntLongOne(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.MulNode.doPIntLongOne(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.MulNode.doPIntLong(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.MulNode.doPIntLong(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.MulNode.doPIntPInt(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.MulNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doII(int, int)] || SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */) {
                                try {
                                    return MulNode.doII(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] */) {
                                return MulNode.doIIL(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0b1101000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] || SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] || SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(PInt, long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] || SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */) {
                                try {
                                    return MulNode.doLL(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */) {
                                {
                                    Node inliningTarget__ = (this);
                                    return MulNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                                }
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(PInt, long)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((arg1Value_ == 0)) {
                                return MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(long, PInt)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((arg0Value_ == 0)) {
                                return MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLongOne(PInt, long, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((arg1Value_ == 1)) {
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return MulNode.doPIntLongOne(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLongOne(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((arg0Value_ == 1)) {
                                PythonLanguage language__1 = (PythonLanguage.get(this));
                                return doPIntLongOne(arg0Value_, arg1Value_, language__1);
                            }
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLong(PInt, long, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((arg1Value_ != 0) && (arg1Value_ != 1)) {
                                PythonLanguage language__2 = (PythonLanguage.get(this));
                                return MulNode.doPIntLong(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                    if ((state_0 & 0b1100000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLong(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.MulNode.doPIntPInt(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntLong(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((arg0Value_ != 0) && (arg0Value_ != 1)) {
                                PythonLanguage language__3 = (PythonLanguage.get(this));
                                return doPIntLong(arg0Value_, arg1Value_, language__3);
                            }
                        }
                        if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doPIntPInt(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            {
                                PythonLanguage language__4 = (PythonLanguage.get(this));
                                return MulNode.doPIntPInt(arg0Value_, arg1Value_, language__4);
                            }
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return MulNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000101101) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doII(int, int)] || SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] || SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] || SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] || SpecializationActive[IntBuiltins.MulNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doII(int, int)] || SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */) {
                            try {
                                return MulNode.doII(arg0Value, arg1Value);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] */) {
                            return MulNode.doIIL(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] || SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c0000) >>> 18 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */) {
                                try {
                                    return MulNode.doLL(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */) {
                                {
                                    Node inliningTarget__ = (this);
                                    return MulNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.MulNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return MulNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] */ && ((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                                state_0 = (state_0 | (intCast0 << 14) /* set-int ImplicitCast[type=int, index=0] */);
                                state_0 = (state_0 | (intCast1 << 16) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */;
                                this.state_0_ = state_0;
                                try {
                                    return MulNode.doII(arg0Value_, arg1Value_);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.MulNode.doII(int, int)] */;
                            state_0 = (state_0 | (intCast0 << 14) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 16) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.MulNode.doIIL(int, int)] */;
                            this.state_0_ = state_0;
                            return MulNode.doIIL(arg0Value_, arg1Value_);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */ && ((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                                    state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return MulNode.doLL(arg0Value_, arg1Value_);
                                    } catch (ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                                {
                                    Node inliningTarget__ = null;
                                    inliningTarget__ = (this);
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.MulNode.doLL(long, long)] */;
                                    state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.MulNode.doLongWithOverflow(long, long, Node)] */;
                                    this.state_0_ = state_0;
                                    return MulNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                                }
                            }
                        }
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((arg1Value_ == 0)) {
                                state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(PInt, long)] */;
                                this.state_0_ = state_0;
                                return MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                            }
                        }
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((arg0Value_ == 0)) {
                                state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntLongZero(long, PInt)] */;
                                this.state_0_ = state_0;
                                return MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                            }
                        }
                    }
                }
                {
                    PythonLanguage language__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            if ((arg1Value_ == 1)) {
                                language__ = (PythonLanguage.get(this));
                                state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntLongOne(PInt, long, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return MulNode.doPIntLongOne(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                }
                {
                    PythonLanguage language__1 = null;
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((arg0Value_ == 1)) {
                                language__1 = (PythonLanguage.get(this));
                                state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntLongOne(long, PInt, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return doPIntLongOne(arg0Value_, arg1Value_, language__1);
                            }
                        }
                    }
                }
                {
                    PythonLanguage language__2 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            if ((arg1Value_ != 0) && (arg1Value_ != 1)) {
                                language__2 = (PythonLanguage.get(this));
                                state_0 = (state_0 | (longCast1 << 21) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntLong(PInt, long, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return MulNode.doPIntLong(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        PythonLanguage language__3 = null;
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            if ((arg0Value_ != 0) && (arg0Value_ != 1)) {
                                language__3 = (PythonLanguage.get(this));
                                state_0 = (state_0 | (longCast0 << 18) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntLong(long, PInt, PythonLanguage)] */;
                                this.state_0_ = state_0;
                                return doPIntLong(arg0Value_, arg1Value_, language__3);
                            }
                        }
                    }
                    {
                        PythonLanguage language__4 = null;
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            language__4 = (PythonLanguage.get(this));
                            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[IntBuiltins.MulNode.doPIntPInt(PInt, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return MulNode.doPIntPInt(arg0Value_, arg1Value_, language__4);
                        }
                    }
                }
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[IntBuiltins.MulNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return MulNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(PowNode.class)
    public static final class PowNodeFactory implements NodeFactory<PowNode> {

        private static final PowNodeFactory POW_NODE_FACTORY_INSTANCE = new PowNodeFactory();

        private PowNodeFactory() {
        }

        @Override
        public Class<PowNode> getNodeClass() {
            return PowNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PowNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<PowNode> getInstance() {
            return POW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PowNode create() {
            return new PowNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PowNode#doIIFast}
         *     Activation probability: 0.13626
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowNode#doLLFast}
         *     Activation probability: 0.12637
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowNode#doLLPos}
         *     Activation probability: 0.11648
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowNode#doLLNeg}
         *     Activation probability: 0.10659
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowNode#doLPNarrow}
         *     Activation probability: 0.09670
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowNode#doLP}
         *     Activation probability: 0.08681
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowNode#doPLNarrow}
         *     Activation probability: 0.07692
         *     With/without class size: 4/0 bytes
         *   Specialization {@link PowNode#doPLPos}
         *     Activation probability: 0.06703
         *     With/without class size: 4/0 bytes
         *   Specialization {@link PowNode#doPLNeg}
         *     Activation probability: 0.05714
         *     With/without class size: 4/0 bytes
         *   Specialization {@link PowNode#doPP}
         *     Activation probability: 0.04725
         *     With/without class size: 4/0 bytes
         *   Specialization {@link PowNode#doLLPosLPos}
         *     Activation probability: 0.03736
         *     With/without class size: 4/0 bytes
         *   Specialization {@link PowNode#doLLPosLGeneric}
         *     Activation probability: 0.02747
         *     With/without class size: 4/1 bytes
         *   Specialization {@link PowNode#powModulo}
         *     Activation probability: 0.01758
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(PowNode.class)
        @SuppressWarnings("javadoc")
        public static final class PowNodeGen extends PowNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowNode#doLLNeg}
             *   Parameter: {@link InlinedConditionProfile} leftIsZero
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_LEFT_IS_ZERO = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(30, 2)));
            private static final StateField STATE_1_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowNode#doLLNeg}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_1_UPDATER.subUpdater(0, 1)));
            private static final StateField STATE_1_PowNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowNode#doLLPosLGeneric}
             *   Parameter: {@link InlinedConditionProfile} modNegativeProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_L_LPOS_LGENERIC_MOD_NEGATIVE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_1_PowNode_UPDATER.subUpdater(1, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowNode#doLLPosLGeneric}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_L_LPOS_LGENERIC_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_1_PowNode_UPDATER.subUpdater(3, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PowNode#doIIFast}
             *   1: SpecializationExcluded {@link PowNode#doIIFast}
             *   2: SpecializationActive {@link PowNode#doLLFast}
             *   3: SpecializationExcluded {@link PowNode#doLLFast}
             *   4: SpecializationActive {@link PowNode#doLLPos}
             *   5: SpecializationActive {@link PowNode#doLLNeg}
             *   6: SpecializationActive {@link PowNode#doLPNarrow}
             *   7: SpecializationExcluded {@link PowNode#doLPNarrow}
             *   8: SpecializationActive {@link PowNode#doLP}
             *   9: SpecializationActive {@link PowNode#doPLNarrow}
             *   10: SpecializationExcluded {@link PowNode#doPLNarrow}
             *   11: SpecializationActive {@link PowNode#doPLPos}
             *   12: SpecializationActive {@link PowNode#doPLNeg}
             *   13: SpecializationActive {@link PowNode#doPP}
             *   14: SpecializationActive {@link PowNode#powModulo}
             *   15: SpecializationActive {@link PowNode#doLLPosLPos}
             *   16: SpecializationActive {@link PowNode#doLLPosLGeneric}
             *   17-18: ImplicitCast[type=int, index=0]
             *   19-20: ImplicitCast[type=int, index=1]
             *   21-23: ImplicitCast[type=long, index=0]
             *   24-26: ImplicitCast[type=long, index=1]
             *   27-29: ImplicitCast[type=long, index=2]
             *   30-31: InlinedCache
             *        Specialization: {@link PowNode#doLLNeg}
             *        Parameter: {@link InlinedConditionProfile} leftIsZero
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link PowNode#doLLNeg}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             *   1-2: InlinedCache
             *        Specialization: {@link PowNode#doLLPosLGeneric}
             *        Parameter: {@link InlinedConditionProfile} modNegativeProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   3: InlinedCache
             *        Specialization: {@link PowNode#doLLPosLGeneric}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_1_;

            private PowNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1fb75) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] || SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doPLNeg(PInt, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doPP(PInt, PInt, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPosLPos(long, long, long)] || SpecializationActive[IntBuiltins.PowNode.doLLPosLGeneric(long, long, long, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */) {
                    if ((state_0 & 0b11101101110101) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] || SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doPLNeg(PInt, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doPP(PInt, PInt, PNone)] */ && arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone) arg2Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                            if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                                int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                                if ((arg1Value_ >= 0)) {
                                    try {
                                        return PowNode.doIIFast(arg0Value_, arg1Value_, arg2Value_);
                                    } catch (ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b101110100) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b110100) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                                if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        try {
                                            return PowNode.doLLFast(arg0Value_, arg1Value_, arg2Value_);
                                        } catch (ArithmeticException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */;
                                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                        }
                                    }
                                }
                                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        PythonLanguage language__ = (PythonLanguage.get(this));
                                        return doLLPos(arg0Value_, arg1Value_, arg2Value_, language__);
                                    }
                                }
                                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */) {
                                    if ((arg1Value_ < 0)) {
                                        Node inliningTarget__ = (this);
                                        return doLLNeg(arg0Value_, arg1Value_, arg2Value_, inliningTarget__, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                    }
                                }
                            }
                            if ((state_0 & 0b101000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] */ && arg1Value instanceof PInt) {
                                PInt arg1Value_ = (PInt) arg1Value;
                                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] */) {
                                    {
                                        Node inliningTarget__1 = (this);
                                        try {
                                            return doLPNarrow(arg0Value_, arg1Value_, arg2Value_, inliningTarget__1, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                        } catch (OverflowException | ArithmeticException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] */;
                                            state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                        }
                                    }
                                }
                                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] */) {
                                    return doLP(arg0Value_, arg1Value_, arg2Value_);
                                }
                            }
                        }
                        if ((state_0 & 0b11101000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doPLNeg(PInt, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.doPP(PInt, PInt, PNone)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((state_0 & 0b1101000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doPLNeg(PInt, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        try {
                                            return doPLNarrow(arg0Value_, arg1Value_, arg2Value_);
                                        } catch (OverflowException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] */;
                                            state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                        }
                                    }
                                }
                                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        PythonLanguage language__1 = (PythonLanguage.get(this));
                                        return doPLPos(arg0Value_, arg1Value_, arg2Value_, language__1);
                                    }
                                }
                                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doPLNeg(PInt, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */) {
                                    if ((arg1Value_ < 0)) {
                                        Node inliningTarget__2 = (this);
                                        return doPLNeg(arg0Value_, arg1Value_, arg2Value_, inliningTarget__2, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                    }
                                }
                            }
                            if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doPP(PInt, PInt, PNone)] */ && arg1Value instanceof PInt) {
                                PInt arg1Value_ = (PInt) arg1Value;
                                return doPP(arg0Value_, arg1Value_, arg2Value_);
                            }
                        }
                    }
                    if ((state_0 & 0x18000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLPosLPos(long, long, long)] || SpecializationActive[IntBuiltins.PowNode.doLLPosLGeneric(long, long, long, Node, InlinedConditionProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x38000000) >>> 27 /* get-int ImplicitCast[type=long, index=2] */, arg2Value)) {
                                long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x38000000) >>> 27 /* get-int ImplicitCast[type=long, index=2] */, arg2Value);
                                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLPosLPos(long, long, long)] */) {
                                    if ((arg1Value_ >= 0) && (arg2Value_ > 0)) {
                                        return PowNode.doLLPosLPos(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0x10000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLPosLGeneric(long, long, long, Node, InlinedConditionProfile, PRaiseNode)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        Node inliningTarget__3 = (this);
                                        return PowNode.doLLPosLGeneric(arg0Value_, arg1Value_, arg2Value_, inliningTarget__3, INLINED_L_LPOS_LGENERIC_MOD_NEGATIVE_PROFILE_, INLINED_L_LPOS_LGENERIC_RAISE_NODE_);
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */) {
                        return powModulo(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected Object execute(int arg0Value, int arg1Value, PNone arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000110101) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */) {
                    if ((state_0 & 0b110101) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */) {
                            if ((arg1Value >= 0)) {
                                try {
                                    return PowNode.doIIFast(arg0Value, arg1Value, arg2Value);
                                } catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                                }
                            }
                        }
                        if ((state_0 & 0b110100) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] || SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] || SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                                if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        try {
                                            return PowNode.doLLFast(arg0Value_, arg1Value_, arg2Value);
                                        } catch (ArithmeticException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */;
                                            state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value);
                                        }
                                    }
                                }
                                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] */) {
                                    if ((arg1Value_ >= 0)) {
                                        PythonLanguage language__ = (PythonLanguage.get(this));
                                        return doLLPos(arg0Value_, arg1Value_, arg2Value, language__);
                                    }
                                }
                                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */) {
                                    if ((arg1Value_ < 0)) {
                                        Node inliningTarget__ = (this);
                                        return doLLNeg(arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */) {
                        return powModulo(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected int executeInt(int arg0Value, int arg1Value, PNone arg2Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */) {
                    return expectInteger(this.execute(null, arg0Value, arg1Value, arg2Value));
                }
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */) {
                    if ((arg1Value >= 0)) {
                        try {
                            return PowNode.doIIFast(arg0Value, arg1Value, arg2Value);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return expectInteger(executeAndSpecialize(arg0Value, arg1Value, arg2Value));
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return expectInteger(executeAndSpecialize(arg0Value, arg1Value, arg2Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                int oldState_0 = (state_0 & 0x1ffff);
                try {
                    if (arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone) arg2Value;
                        if (((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                            int intCast0;
                            if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                                int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                                int intCast1;
                                if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                                    int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                                    if ((arg1Value_ >= 0)) {
                                        state_0 = (state_0 | (intCast0 << 17) /* set-int ImplicitCast[type=int, index=0] */);
                                        state_0 = (state_0 | (intCast1 << 19) /* set-int ImplicitCast[type=int, index=1] */);
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */;
                                        this.state_0_ = state_0;
                                        try {
                                            return PowNode.doIIFast(arg0Value_, arg1Value_, arg2Value_);
                                        } catch (ArithmeticException ex) {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            state_0 = this.state_0_;
                                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.PowNode.doIIFast(int, int, PNone)] */;
                                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                            this.state_0_ = state_0;
                                            return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                        }
                                    }
                                }
                            }
                        }
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                {
                                    int longCast1;
                                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */) {
                                            if ((arg1Value_ >= 0)) {
                                                state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                                state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                                state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */;
                                                this.state_0_ = state_0;
                                                try {
                                                    return PowNode.doLLFast(arg0Value_, arg1Value_, arg2Value_);
                                                } catch (ArithmeticException ex) {
                                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                                    state_0 = this.state_0_;
                                                    state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */;
                                                    state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                                    this.state_0_ = state_0;
                                                    return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                                }
                                            }
                                        }
                                        {
                                            PythonLanguage language__ = null;
                                            if ((arg1Value_ >= 0)) {
                                                language__ = (PythonLanguage.get(this));
                                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.PowNode.doLLFast(long, long, PNone)] */;
                                                state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                                state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                                state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.PowNode.doLLPos(long, long, PNone, PythonLanguage)] */;
                                                this.state_0_ = state_0;
                                                return doLLPos(arg0Value_, arg1Value_, arg2Value_, language__);
                                            }
                                        }
                                        {
                                            Node inliningTarget__ = null;
                                            if ((arg1Value_ < 0)) {
                                                inliningTarget__ = (this);
                                                state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                                state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.PowNode.doLLNeg(long, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */;
                                                this.state_0_ = state_0;
                                                return doLLNeg(arg0Value_, arg1Value_, arg2Value_, inliningTarget__, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                            }
                                        }
                                    }
                                }
                                if (arg1Value instanceof PInt) {
                                    PInt arg1Value_ = (PInt) arg1Value;
                                    {
                                        Node inliningTarget__1 = null;
                                        if (((state_0 & 0b100000000)) == 0 /* is-not SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] */ && ((state_0 & 0b10000000)) == 0 /* is-not SpecializationExcluded  */) {
                                            inliningTarget__1 = (this);
                                            state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                            state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] */;
                                            this.state_0_ = state_0;
                                            try {
                                                return doLPNarrow(arg0Value_, arg1Value_, arg2Value_, inliningTarget__1, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                            } catch (OverflowException | ArithmeticException ex) {
                                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                                state_0 = this.state_0_;
                                                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] */;
                                                state_0 = state_0 | 0b10000000 /* add SpecializationExcluded  */;
                                                this.state_0_ = state_0;
                                                return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                            }
                                        }
                                    }
                                    state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[IntBuiltins.PowNode.doLPNarrow(long, PInt, PNone, Node, InlinedConditionProfile, PRaiseNode)] */;
                                    state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.PowNode.doLP(long, PInt, PNone)] */;
                                    this.state_0_ = state_0;
                                    return doLP(arg0Value_, arg1Value_, arg2Value_);
                                }
                            }
                        }
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            {
                                int longCast1;
                                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                                    if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] */ && ((state_0 & 0b10000000000)) == 0 /* is-not SpecializationExcluded  */) {
                                        if ((arg1Value_ >= 0)) {
                                            state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] */;
                                            this.state_0_ = state_0;
                                            try {
                                                return doPLNarrow(arg0Value_, arg1Value_, arg2Value_);
                                            } catch (OverflowException ex) {
                                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                                state_0 = this.state_0_;
                                                state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] */;
                                                state_0 = state_0 | 0b10000000000 /* add SpecializationExcluded  */;
                                                this.state_0_ = state_0;
                                                return executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                            }
                                        }
                                    }
                                    {
                                        PythonLanguage language__1 = null;
                                        if ((arg1Value_ >= 0)) {
                                            language__1 = (PythonLanguage.get(this));
                                            state_0 = state_0 & 0xfffffdff /* remove SpecializationActive[IntBuiltins.PowNode.doPLNarrow(PInt, long, PNone)] */;
                                            state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.PowNode.doPLPos(PInt, long, PNone, PythonLanguage)] */;
                                            this.state_0_ = state_0;
                                            return doPLPos(arg0Value_, arg1Value_, arg2Value_, language__1);
                                        }
                                    }
                                    {
                                        Node inliningTarget__2 = null;
                                        if ((arg1Value_ < 0)) {
                                            inliningTarget__2 = (this);
                                            state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[IntBuiltins.PowNode.doPLNeg(PInt, long, PNone, Node, InlinedConditionProfile, PRaiseNode)] */;
                                            this.state_0_ = state_0;
                                            return doPLNeg(arg0Value_, arg1Value_, arg2Value_, inliningTarget__2, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                        }
                                    }
                                }
                            }
                            if (((state_0 & 0b100000000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */ && arg1Value instanceof PInt) {
                                PInt arg1Value_ = (PInt) arg1Value;
                                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[IntBuiltins.PowNode.doPP(PInt, PInt, PNone)] */;
                                this.state_0_ = state_0;
                                return doPP(arg0Value_, arg1Value_, arg2Value_);
                            }
                        }
                    }
                    {
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            int longCast1;
                            if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                                int longCast2;
                                if ((longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value)) != 0) {
                                    long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                                    if (((state_0 & 0x10000)) == 0 /* is-not SpecializationActive[IntBuiltins.PowNode.doLLPosLGeneric(long, long, long, Node, InlinedConditionProfile, PRaiseNode)] */) {
                                        if ((arg1Value_ >= 0) && (arg2Value_ > 0)) {
                                            state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                            state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                            state_0 = (state_0 | (longCast2 << 27) /* set-int ImplicitCast[type=long, index=2] */);
                                            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[IntBuiltins.PowNode.doLLPosLPos(long, long, long)] */;
                                            this.state_0_ = state_0;
                                            return PowNode.doLLPosLPos(arg0Value_, arg1Value_, arg2Value_);
                                        }
                                    }
                                    {
                                        Node inliningTarget__3 = null;
                                        if ((arg1Value_ >= 0)) {
                                            inliningTarget__3 = (this);
                                            state_0 = state_0 & 0xffff7fff /* remove SpecializationActive[IntBuiltins.PowNode.doLLPosLPos(long, long, long)] */;
                                            state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                            state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                            state_0 = (state_0 | (longCast2 << 27) /* set-int ImplicitCast[type=long, index=2] */);
                                            state_0 = state_0 | 0x10000 /* add SpecializationActive[IntBuiltins.PowNode.doLLPosLGeneric(long, long, long, Node, InlinedConditionProfile, PRaiseNode)] */;
                                            this.state_0_ = state_0;
                                            return PowNode.doLLPosLGeneric(arg0Value_, arg1Value_, arg2Value_, inliningTarget__3, INLINED_L_LPOS_LGENERIC_MOD_NEGATIVE_PROFILE_, INLINED_L_LPOS_LGENERIC_RAISE_NODE_);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    state_0 = state_0 & 0xffffdfff /* remove SpecializationActive[IntBuiltins.PowNode.doPP(PInt, PInt, PNone)] */;
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[IntBuiltins.PowNode.powModulo(Object, Object, Object)] */;
                    this.state_0_ = state_0;
                    return powModulo(arg0Value, arg1Value, arg2Value);
                } finally {
                    if (oldState_0 != 0) {
                        checkForPolymorphicSpecialize(oldState_0);
                    }
                }
            }

            private void checkForPolymorphicSpecialize(int oldState_0) {
                int state_0 = this.state_0_;
                int newState_0 = (state_0 & 0x1ffff);
                if (((oldState_0 ^ newState_0) != 0)) {
                    this.reportPolymorphicSpecialize();
                }
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (int) value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }

        }
    }
    @GeneratedBy(AbsNode.class)
    static final class AbsNodeFactory implements NodeFactory<AbsNode> {

        private static final AbsNodeFactory ABS_NODE_FACTORY_INSTANCE = new AbsNodeFactory();

        private AbsNodeFactory() {
        }

        @Override
        public Class<AbsNode> getNodeClass() {
            return AbsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public AbsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<AbsNode> getInstance() {
            return ABS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AbsNode create() {
            return new AbsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbsNode#absInt}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link AbsNode#absLong}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link AbsNode#absPInt}
         *     Activation probability: 0.20500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link AbsNode#absBoolean}
         *     Activation probability: 0.11500
         *     With/without class size: 5/0 bytes
         * </pre> */
        @GeneratedBy(AbsNode.class)
        @SuppressWarnings("javadoc")
        static final class AbsNodeGen extends AbsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbsNode#absInt}
             *   1: SpecializationActive {@link AbsNode#absLong}
             *   2: SpecializationActive {@link AbsNode#absPInt}
             *   3: SpecializationActive {@link AbsNode#absBoolean}
             * </pre> */
            @CompilationFinal private int state_0_;

            private AbsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.AbsNode.absInt(int)] || SpecializationActive[IntBuiltins.AbsNode.absLong(long, Node)] || SpecializationActive[IntBuiltins.AbsNode.absPInt(PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.AbsNode.absBoolean(boolean)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.AbsNode.absInt(int)] */ && arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        return AbsNode.absInt(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.AbsNode.absLong(long, Node)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        {
                            Node inliningTarget__ = (this);
                            return AbsNode.absLong(arg0Value_, inliningTarget__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.AbsNode.absPInt(PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return AbsNode.absPInt(arg0Value_, language__);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.AbsNode.absBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return AbsNode.absBoolean(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.AbsNode.absInt(int)] */;
                    this.state_0_ = state_0;
                    return AbsNode.absInt(arg0Value_);
                }
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        inliningTarget__ = (this);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.AbsNode.absLong(long, Node)] */;
                        this.state_0_ = state_0;
                        return AbsNode.absLong(arg0Value_, inliningTarget__);
                    }
                }
                {
                    PythonLanguage language__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.AbsNode.absPInt(PInt, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return AbsNode.absPInt(arg0Value_, language__);
                    }
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.AbsNode.absBoolean(boolean)] */;
                    this.state_0_ = state_0;
                    return AbsNode.absBoolean(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(CeilNode.class)
    static final class CeilNodeFactory implements NodeFactory<CeilNode> {

        private static final CeilNodeFactory CEIL_NODE_FACTORY_INSTANCE = new CeilNodeFactory();

        private CeilNodeFactory() {
        }

        @Override
        public Class<CeilNode> getNodeClass() {
            return CeilNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public CeilNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<CeilNode> getInstance() {
            return CEIL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CeilNode create() {
            return new CeilNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CeilNode#ceil(int)}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link CeilNode#ceil(long)}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link CeilNode#ceil(PInt)}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(CeilNode.class)
        @SuppressWarnings("javadoc")
        static final class CeilNodeGen extends CeilNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CeilNode#ceil(int)}
             *   1: SpecializationActive {@link CeilNode#ceil(long)}
             *   2: SpecializationActive {@link CeilNode#ceil(PInt)}
             *   3-4: ImplicitCast[type=int, index=0]
             *   5-7: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private CeilNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.CeilNode.ceil(int)] || SpecializationActive[IntBuiltins.CeilNode.ceil(long)] || SpecializationActive[IntBuiltins.CeilNode.ceil(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.CeilNode.ceil(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        return CeilNode.ceil(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.CeilNode.ceil(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return CeilNode.ceil(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.CeilNode.ceil(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return CeilNode.ceil(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        state_0 = (state_0 | (intCast0 << 3) /* set-int ImplicitCast[type=int, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.CeilNode.ceil(int)] */;
                        this.state_0_ = state_0;
                        return CeilNode.ceil(arg0Value_);
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 = (state_0 | (longCast0 << 5) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.CeilNode.ceil(long)] */;
                        this.state_0_ = state_0;
                        return CeilNode.ceil(arg0Value_);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.CeilNode.ceil(PInt)] */;
                    this.state_0_ = state_0;
                    return CeilNode.ceil(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(FloorNode.class)
    static final class FloorNodeFactory implements NodeFactory<FloorNode> {

        private static final FloorNodeFactory FLOOR_NODE_FACTORY_INSTANCE = new FloorNodeFactory();

        private FloorNodeFactory() {
        }

        @Override
        public Class<FloorNode> getNodeClass() {
            return FloorNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FloorNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<FloorNode> getInstance() {
            return FLOOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FloorNode create() {
            return new FloorNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FloorNode#floor(int)}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link FloorNode#floor(long)}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link FloorNode#floor(PInt, PythonLanguage)}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(FloorNode.class)
        @SuppressWarnings("javadoc")
        static final class FloorNodeGen extends FloorNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FloorNode#floor(int)}
             *   1: SpecializationActive {@link FloorNode#floor(long)}
             *   2: SpecializationActive {@link FloorNode#floor(PInt, PythonLanguage)}
             *   3-4: ImplicitCast[type=int, index=0]
             *   5-7: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private FloorNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.FloorNode.floor(int)] || SpecializationActive[IntBuiltins.FloorNode.floor(long)] || SpecializationActive[IntBuiltins.FloorNode.floor(PInt, PythonLanguage)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.FloorNode.floor(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        return FloorNode.floor(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.FloorNode.floor(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return FloorNode.floor(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.FloorNode.floor(PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return FloorNode.floor(arg0Value_, language__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        state_0 = (state_0 | (intCast0 << 3) /* set-int ImplicitCast[type=int, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.FloorNode.floor(int)] */;
                        this.state_0_ = state_0;
                        return FloorNode.floor(arg0Value_);
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 = (state_0 | (longCast0 << 5) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.FloorNode.floor(long)] */;
                        this.state_0_ = state_0;
                        return FloorNode.floor(arg0Value_);
                    }
                }
                {
                    PythonLanguage language__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.FloorNode.floor(PInt, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return FloorNode.floor(arg0Value_, language__);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(PosNode.class)
    static final class PosNodeFactory implements NodeFactory<PosNode> {

        private static final PosNodeFactory POS_NODE_FACTORY_INSTANCE = new PosNodeFactory();

        private PosNodeFactory() {
        }

        @Override
        public Class<PosNode> getNodeClass() {
            return PosNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PosNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<PosNode> getInstance() {
            return POS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PosNode create() {
            return new PosNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PosNode#pos(Integer)}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link PosNode#pos(Long)}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link PosNode#pos(PInt, PythonLanguage)}
         *     Activation probability: 0.20500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link PosNode#pos(boolean)}
         *     Activation probability: 0.11500
         *     With/without class size: 5/0 bytes
         * </pre> */
        @GeneratedBy(PosNode.class)
        @SuppressWarnings("javadoc")
        static final class PosNodeGen extends PosNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PosNode#pos(Integer)}
             *   1: SpecializationActive {@link PosNode#pos(Long)}
             *   2: SpecializationActive {@link PosNode#pos(PInt, PythonLanguage)}
             *   3: SpecializationActive {@link PosNode#pos(boolean)}
             * </pre> */
            @CompilationFinal private int state_0_;

            private PosNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.PosNode.pos(Integer)] || SpecializationActive[IntBuiltins.PosNode.pos(Long)] || SpecializationActive[IntBuiltins.PosNode.pos(PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.PosNode.pos(boolean)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.PosNode.pos(Integer)] */ && arg0Value instanceof Integer) {
                        Integer arg0Value_ = (Integer) arg0Value;
                        return PosNode.pos(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.PosNode.pos(Long)] */ && arg0Value instanceof Long) {
                        Long arg0Value_ = (Long) arg0Value;
                        return PosNode.pos(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.PosNode.pos(PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return PosNode.pos(arg0Value_, language__);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.PosNode.pos(boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return PosNode.pos(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    Integer arg0Value_ = (Integer) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.PosNode.pos(Integer)] */;
                    this.state_0_ = state_0;
                    return PosNode.pos(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    Long arg0Value_ = (Long) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.PosNode.pos(Long)] */;
                    this.state_0_ = state_0;
                    return PosNode.pos(arg0Value_);
                }
                {
                    PythonLanguage language__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.PosNode.pos(PInt, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return PosNode.pos(arg0Value_, language__);
                    }
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.PosNode.pos(boolean)] */;
                    this.state_0_ = state_0;
                    return PosNode.pos(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(NegNode.class)
    public static final class NegNodeFactory implements NodeFactory<NegNode> {

        private static final NegNodeFactory NEG_NODE_FACTORY_INSTANCE = new NegNodeFactory();

        private NegNodeFactory() {
        }

        @Override
        public Class<NegNode> getNodeClass() {
            return NegNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NegNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NegNode> getInstance() {
            return NEG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NegNode create() {
            return new NegNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NegNode#neg(int)}
         *     Activation probability: 0.27381
         *     With/without class size: 7/0 bytes
         *   Specialization {@link NegNode#negOvf(int)}
         *     Activation probability: 0.23095
         *     With/without class size: 6/0 bytes
         *   Specialization {@link NegNode#neg(long)}
         *     Activation probability: 0.18810
         *     With/without class size: 6/0 bytes
         *   Specialization {@link NegNode#negOvf(long, PythonLanguage)}
         *     Activation probability: 0.14524
         *     With/without class size: 5/0 bytes
         *   Specialization {@link NegNode#doPInt}
         *     Activation probability: 0.10238
         *     With/without class size: 5/0 bytes
         *   Specialization {@link NegNode#doBoolean}
         *     Activation probability: 0.05952
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(NegNode.class)
        @SuppressWarnings("javadoc")
        public static final class NegNodeGen extends NegNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NegNode#neg(int)}
             *   1: SpecializationExcluded {@link NegNode#neg(int)}
             *   2: SpecializationActive {@link NegNode#negOvf(int)}
             *   3: SpecializationActive {@link NegNode#neg(long)}
             *   4: SpecializationExcluded {@link NegNode#neg(long)}
             *   5: SpecializationActive {@link NegNode#negOvf(long, PythonLanguage)}
             *   6: SpecializationActive {@link NegNode#doPInt}
             *   7: SpecializationActive {@link NegNode#doBoolean}
             * </pre> */
            @CompilationFinal private int state_0_;

            private NegNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11101101) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(int)] || SpecializationActive[IntBuiltins.NegNode.negOvf(int)] || SpecializationActive[IntBuiltins.NegNode.neg(long)] || SpecializationActive[IntBuiltins.NegNode.negOvf(long, PythonLanguage)] || SpecializationActive[IntBuiltins.NegNode.doPInt(PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.NegNode.doBoolean(boolean)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(int)] || SpecializationActive[IntBuiltins.NegNode.negOvf(int)] */ && arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(int)] */) {
                            try {
                                return NegNode.neg(arg0Value_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.NegNode.neg(int)] */;
                                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value_);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.NegNode.negOvf(int)] */) {
                            return NegNode.negOvf(arg0Value_);
                        }
                    }
                    if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(long)] || SpecializationActive[IntBuiltins.NegNode.negOvf(long, PythonLanguage)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(long)] */) {
                            try {
                                return NegNode.neg(arg0Value_);
                            } catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.NegNode.neg(long)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                this.state_0_ = state_0;
                                return executeAndSpecialize(arg0Value_);
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.NegNode.negOvf(long, PythonLanguage)] */) {
                            {
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return NegNode.negOvf(arg0Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.NegNode.doPInt(PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            PythonLanguage language__1 = (PythonLanguage.get(this));
                            return NegNode.doPInt(arg0Value_, language__1);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.NegNode.doBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return NegNode.doBoolean(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            @Override
            public Object execute(int arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(int)] || SpecializationActive[IntBuiltins.NegNode.negOvf(int)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.NegNode.neg(int)] */) {
                        try {
                            return NegNode.neg(arg0Value);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.NegNode.neg(int)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(arg0Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.NegNode.negOvf(int)] */) {
                        return NegNode.negOvf(arg0Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    if (((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.NegNode.neg(int)] */;
                        this.state_0_ = state_0;
                        try {
                            return NegNode.neg(arg0Value_);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.NegNode.neg(int)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(arg0Value_);
                        }
                    }
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.NegNode.negOvf(int)] */;
                    this.state_0_ = state_0;
                    return NegNode.negOvf(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.NegNode.neg(long)] */;
                        this.state_0_ = state_0;
                        try {
                            return NegNode.neg(arg0Value_);
                        } catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.NegNode.neg(long)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return executeAndSpecialize(arg0Value_);
                        }
                    }
                    {
                        PythonLanguage language__ = null;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.NegNode.negOvf(long, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return NegNode.negOvf(arg0Value_, language__);
                    }
                }
                {
                    PythonLanguage language__1 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        language__1 = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.NegNode.doPInt(PInt, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return NegNode.doPInt(arg0Value_, language__1);
                    }
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.NegNode.doBoolean(boolean)] */;
                    this.state_0_ = state_0;
                    return NegNode.doBoolean(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(InvertNode.class)
    static final class InvertNodeFactory implements NodeFactory<InvertNode> {

        private static final InvertNodeFactory INVERT_NODE_FACTORY_INSTANCE = new InvertNodeFactory();

        private InvertNodeFactory() {
        }

        @Override
        public Class<InvertNode> getNodeClass() {
            return InvertNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public InvertNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<InvertNode> getInstance() {
            return INVERT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static InvertNode create() {
            return new InvertNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link InvertNode#neg(boolean)}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link InvertNode#neg(int)}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link InvertNode#neg(long)}
         *     Activation probability: 0.20500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link InvertNode#doPInt}
         *     Activation probability: 0.11500
         *     With/without class size: 5/0 bytes
         * </pre> */
        @GeneratedBy(InvertNode.class)
        @SuppressWarnings("javadoc")
        static final class InvertNodeGen extends InvertNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InvertNode#neg(boolean)}
             *   1: SpecializationActive {@link InvertNode#neg(int)}
             *   2: SpecializationActive {@link InvertNode#neg(long)}
             *   3: SpecializationActive {@link InvertNode#doPInt}
             * </pre> */
            @CompilationFinal private int state_0_;

            private InvertNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.InvertNode.neg(boolean)] || SpecializationActive[IntBuiltins.InvertNode.neg(int)] || SpecializationActive[IntBuiltins.InvertNode.neg(long)] || SpecializationActive[IntBuiltins.InvertNode.doPInt(PInt, PythonLanguage)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.InvertNode.neg(boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return InvertNode.neg(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.InvertNode.neg(int)] */ && arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        return InvertNode.neg(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.InvertNode.neg(long)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return InvertNode.neg(arg0Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.InvertNode.doPInt(PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return InvertNode.doPInt(arg0Value_, language__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.InvertNode.neg(boolean)] */;
                    this.state_0_ = state_0;
                    return InvertNode.neg(arg0Value_);
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.InvertNode.neg(int)] */;
                    this.state_0_ = state_0;
                    return InvertNode.neg(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.InvertNode.neg(long)] */;
                    this.state_0_ = state_0;
                    return InvertNode.neg(arg0Value_);
                }
                {
                    PythonLanguage language__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.InvertNode.doPInt(PInt, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return InvertNode.doPInt(arg0Value_, language__);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(LShiftNode.class)
    public static final class LShiftNodeFactory implements NodeFactory<LShiftNode> {

        private static final LShiftNodeFactory LSHIFT_NODE_FACTORY_INSTANCE = new LShiftNodeFactory();

        private LShiftNodeFactory() {
        }

        @Override
        public Class<LShiftNode> getNodeClass() {
            return LShiftNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public LShiftNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<LShiftNode> getInstance() {
            return LSHIFT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LShiftNode create() {
            return new LShiftNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LShiftNode#doII}
         *     Activation probability: 0.11917
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doIIOvf}
         *     Activation probability: 0.11167
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doLL}
         *     Activation probability: 0.10417
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doILOvf}
         *     Activation probability: 0.09667
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doLIOvf}
         *     Activation probability: 0.08917
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doLLOvf}
         *     Activation probability: 0.08167
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doIPiZero}
         *     Activation probability: 0.07417
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doIPi}
         *     Activation probability: 0.06667
         *     With/without class size: 5/0 bytes
         *   Specialization {@link LShiftNode#doLPiZero}
         *     Activation probability: 0.05917
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doLPi}
         *     Activation probability: 0.05167
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doPiI}
         *     Activation probability: 0.04417
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doPiL}
         *     Activation probability: 0.03667
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doPiPiZero}
         *     Activation probability: 0.02917
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doPiPi}
         *     Activation probability: 0.02167
         *     With/without class size: 4/0 bytes
         *   Specialization {@link LShiftNode#doGeneric}
         *     Activation probability: 0.01417
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(LShiftNode.class)
        @SuppressWarnings("javadoc")
        public static final class LShiftNodeGen extends LShiftNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link LShiftNode#doII}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_UPDATER.subUpdater(27, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link LShiftNode#doII}
             *   1: SpecializationExcluded {@link LShiftNode#doII}
             *   2: SpecializationActive {@link LShiftNode#doIIOvf}
             *   3: SpecializationActive {@link LShiftNode#doLL}
             *   4: SpecializationExcluded {@link LShiftNode#doLL}
             *   5: SpecializationActive {@link LShiftNode#doILOvf}
             *   6: SpecializationActive {@link LShiftNode#doLIOvf}
             *   7: SpecializationActive {@link LShiftNode#doLLOvf}
             *   8: SpecializationActive {@link LShiftNode#doIPiZero}
             *   9: SpecializationActive {@link LShiftNode#doIPi}
             *   10: SpecializationActive {@link LShiftNode#doLPiZero}
             *   11: SpecializationActive {@link LShiftNode#doLPi}
             *   12: SpecializationActive {@link LShiftNode#doPiI}
             *   13: SpecializationActive {@link LShiftNode#doPiL}
             *   14: SpecializationActive {@link LShiftNode#doPiPiZero}
             *   15: SpecializationActive {@link LShiftNode#doPiPi}
             *   16: SpecializationActive {@link LShiftNode#doGeneric}
             *   17-18: ImplicitCast[type=int, index=0]
             *   19-20: ImplicitCast[type=int, index=1]
             *   21-23: ImplicitCast[type=long, index=0]
             *   24-26: ImplicitCast[type=long, index=1]
             *   27: InlinedCache
             *        Specialization: {@link LShiftNode#doII}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private LShiftNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */
                     && (state_0 & 0x7e00000) == 0x7e00000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */
                     && (state_0 & 0xe00000) == 0xe00000) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiL(PInt, long, Node, PRaiseNode)] */
                     && (state_0 & 0x7000000) == 0x7000000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1ffed) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doIPiZero(int, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doIPi(int, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLPiZero(long, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doPiI(PInt, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doPiL(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doPiPiZero(PInt, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__ = (this);
                                    try {
                                        return LShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__1 = (this);
                                    return LShiftNode.doIIOvf(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__2 = (this);
                                try {
                                    return LShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                            {
                                Node inliningTarget__3 = (this);
                                return LShiftNode.doILOvf(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            {
                                Node inliningTarget__4 = (this);
                                return LShiftNode.doLIOvf(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__5 = (this);
                                return LShiftNode.doLLOvf(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b111100000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIPiZero(int, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doIPi(int, PInt, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLPiZero(long, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b1100000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIPiZero(int, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doIPi(int, PInt, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIPiZero(int, PInt)] */) {
                                if ((arg0Value_ == 0) && (arg1Value_.isZeroOrPositive())) {
                                    return LShiftNode.doIPiZero(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIPi(int, PInt, Node, PythonLanguage, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__6 = (this);
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return LShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                                }
                            }
                        }
                        if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLPiZero(long, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLPiZero(long, PInt)] */) {
                                if ((arg0Value_ == 0) && (arg1Value_.isZeroOrPositive())) {
                                    return LShiftNode.doLPiZero(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__7 = (this);
                                    return LShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__7, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1111000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiI(PInt, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doPiL(PInt, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doPiPiZero(PInt, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiI(PInt, int, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            {
                                Node inliningTarget__8 = (this);
                                return LShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiL(PInt, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__9 = (this);
                                return LShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__9, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b1100000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiPiZero(PInt, PInt)] || SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiPiZero(PInt, PInt)] */) {
                                if ((arg0Value_.isZero()) && (arg1Value_.isZeroOrPositive())) {
                                    return LShiftNode.doPiPiZero(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__10 = (this);
                                    return LShiftNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return LShiftNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x100ed) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b101) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                            {
                                Node inliningTarget__ = (this);
                                try {
                                    return LShiftNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */;
                                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value, arg1Value);
                                }
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] */) {
                            {
                                Node inliningTarget__1 = (this);
                                return LShiftNode.doIIOvf(arg0Value, arg1Value, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b101000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__2 = (this);
                                try {
                                    return LShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                } catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] */;
                                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                    this.state_0_ = state_0;
                                    return executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] */) {
                            {
                                Node inliningTarget__3 = (this);
                                return LShiftNode.doILOvf(arg0Value, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe00000) >>> 21 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] */) {
                            {
                                Node inliningTarget__4 = (this);
                                return LShiftNode.doLIOvf(arg0Value_, arg1Value, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__5 = (this);
                                return LShiftNode.doLLOvf(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return LShiftNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public int executeInt(int arg0Value, int arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11100100) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */) {
                    return expectInteger(this.execute(null, arg0Value, arg1Value));
                }
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                    {
                        Node inliningTarget__ = (this);
                        try {
                            return LShiftNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                        } catch (OverflowException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */;
                            state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            return expectInteger(executeAndSpecialize(arg0Value, arg1Value));
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return expectInteger(executeAndSpecialize(arg0Value, arg1Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            {
                                Node inliningTarget__ = null;
                                if (((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                                    inliningTarget__ = (this);
                                    state_0 = (state_0 | (intCast0 << 17) /* set-int ImplicitCast[type=int, index=0] */);
                                    state_0 = (state_0 | (intCast1 << 19) /* set-int ImplicitCast[type=int, index=1] */);
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return LShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.LShiftNode.doII(int, int, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                            {
                                Node inliningTarget__1 = null;
                                inliningTarget__1 = (this);
                                state_0 = (state_0 | (intCast0 << 17) /* set-int ImplicitCast[type=int, index=0] */);
                                state_0 = (state_0 | (intCast1 << 19) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.LShiftNode.doIIOvf(int, int, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doIIOvf(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            Node inliningTarget__2 = null;
                            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
                                int longCast0;
                                if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                    inliningTarget__2 = (this);
                                    state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] */;
                                    this.state_0_ = state_0;
                                    try {
                                        return LShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                    } catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.LShiftNode.doLL(long, long, Node, PRaiseNode)] */;
                                        state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                                        this.state_0_ = state_0;
                                        return executeAndSpecialize(arg0Value_, arg1Value_);
                                    }
                                }
                            }
                        }
                        {
                            Node inliningTarget__3 = null;
                            int intCast0;
                            if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                                int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                                inliningTarget__3 = (this);
                                state_0 = (state_0 | (intCast0 << 17) /* set-int ImplicitCast[type=int, index=0] */);
                                state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.LShiftNode.doILOvf(int, long, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doILOvf(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        {
                            Node inliningTarget__4 = null;
                            int intCast1;
                            if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                                int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                                inliningTarget__4 = (this);
                                state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (intCast1 << 19) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doLIOvf(long, int, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doLIOvf(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                        }
                        {
                            Node inliningTarget__5 = null;
                            int longCast1;
                            if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                                inliningTarget__5 = (this);
                                state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doLLOvf(long, long, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doLLOvf(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        int intCast0;
                        if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                            if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.LShiftNode.doIPi(int, PInt, Node, PythonLanguage, PRaiseNode)] */) {
                                if ((arg0Value_ == 0) && (arg1Value_.isZeroOrPositive())) {
                                    state_0 = (state_0 | (intCast0 << 17) /* set-int ImplicitCast[type=int, index=0] */);
                                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doIPiZero(int, PInt)] */;
                                    this.state_0_ = state_0;
                                    return LShiftNode.doIPiZero(arg0Value_, arg1Value_);
                                }
                            }
                            {
                                PythonLanguage language__ = null;
                                Node inliningTarget__6 = null;
                                inliningTarget__6 = (this);
                                language__ = (PythonLanguage.get(this));
                                state_0 = state_0 & 0xfffffeff /* remove SpecializationActive[IntBuiltins.LShiftNode.doIPiZero(int, PInt)] */;
                                state_0 = (state_0 | (intCast0 << 17) /* set-int ImplicitCast[type=int, index=0] */);
                                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doIPi(int, PInt, Node, PythonLanguage, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    {
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */) {
                                if ((arg0Value_ == 0) && (arg1Value_.isZeroOrPositive())) {
                                    state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doLPiZero(long, PInt)] */;
                                    this.state_0_ = state_0;
                                    return LShiftNode.doLPiZero(arg0Value_, arg1Value_);
                                }
                            }
                            {
                                Node inliningTarget__7 = null;
                                inliningTarget__7 = (this);
                                state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[IntBuiltins.LShiftNode.doLPiZero(long, PInt)] */;
                                state_0 = (state_0 | (longCast0 << 21) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__7, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        Node inliningTarget__8 = null;
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            inliningTarget__8 = (this);
                            state_0 = (state_0 | (intCast1 << 19) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doPiI(PInt, int, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return LShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                        }
                    }
                    {
                        Node inliningTarget__9 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__9 = (this);
                            state_0 = (state_0 | (longCast1 << 24) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doPiL(PInt, long, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return LShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__9, INLINED_RAISE_NODE);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if (((state_0 & 0b1000000000000000)) == 0 /* is-not SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] */) {
                            if ((arg0Value_.isZero()) && (arg1Value_.isZeroOrPositive())) {
                                state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doPiPiZero(PInt, PInt)] */;
                                this.state_0_ = state_0;
                                return LShiftNode.doPiPiZero(arg0Value_, arg1Value_);
                            }
                        }
                        {
                            Node inliningTarget__10 = null;
                            inliningTarget__10 = (this);
                            state_0 = state_0 & 0xffffbfff /* remove SpecializationActive[IntBuiltins.LShiftNode.doPiPiZero(PInt, PInt)] */;
                            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[IntBuiltins.LShiftNode.doPiPi(PInt, PInt, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return LShiftNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                        }
                    }
                }
                state_0 = state_0 | 0x10000 /* add SpecializationActive[IntBuiltins.LShiftNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return LShiftNode.doGeneric(arg0Value, arg1Value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (int) value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }

        }
    }
    @GeneratedBy(RShiftNode.class)
    public static final class RShiftNodeFactory implements NodeFactory<RShiftNode> {

        private static final RShiftNodeFactory RSHIFT_NODE_FACTORY_INSTANCE = new RShiftNodeFactory();

        private RShiftNodeFactory() {
        }

        @Override
        public Class<RShiftNode> getNodeClass() {
            return RShiftNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public RShiftNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<RShiftNode> getInstance() {
            return RSHIFT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RShiftNode create() {
            return new RShiftNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RShiftNode#doIISmall}
         *     Activation probability: 0.17364
         *     With/without class size: 6/0 bytes
         *   Specialization {@link RShiftNode#doII}
         *     Activation probability: 0.15727
         *     With/without class size: 6/0 bytes
         *   Specialization {@link RShiftNode#doLLSmall}
         *     Activation probability: 0.14091
         *     With/without class size: 6/0 bytes
         *   Specialization {@link RShiftNode#doLL}
         *     Activation probability: 0.12455
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RShiftNode#doIPi}
         *     Activation probability: 0.10818
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RShiftNode#doLPi}
         *     Activation probability: 0.09182
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RShiftNode#doPiI}
         *     Activation probability: 0.07545
         *     With/without class size: 5/0 bytes
         *   Specialization {@link RShiftNode#doPiL}
         *     Activation probability: 0.05909
         *     With/without class size: 4/0 bytes
         *   Specialization {@link RShiftNode#doPInt}
         *     Activation probability: 0.04273
         *     With/without class size: 4/0 bytes
         *   Specialization {@link RShiftNode#doGeneric}
         *     Activation probability: 0.02636
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(RShiftNode.class)
        @SuppressWarnings("javadoc")
        public static final class RShiftNodeGen extends RShiftNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link RShiftNode#doIISmall}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_UPDATER.subUpdater(20, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RShiftNode#doIISmall}
             *   1: SpecializationActive {@link RShiftNode#doII}
             *   2: SpecializationActive {@link RShiftNode#doLLSmall}
             *   3: SpecializationActive {@link RShiftNode#doLL}
             *   4: SpecializationActive {@link RShiftNode#doIPi}
             *   5: SpecializationActive {@link RShiftNode#doLPi}
             *   6: SpecializationActive {@link RShiftNode#doPiI}
             *   7: SpecializationActive {@link RShiftNode#doPiL}
             *   8: SpecializationActive {@link RShiftNode#doPInt}
             *   9: SpecializationActive {@link RShiftNode#doGeneric}
             *   10-11: ImplicitCast[type=int, index=0]
             *   12-13: ImplicitCast[type=int, index=1]
             *   14-16: ImplicitCast[type=long, index=0]
             *   17-19: ImplicitCast[type=long, index=1]
             *   20: InlinedCache
             *        Specialization: {@link RShiftNode#doIISmall}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private RShiftNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */
                     && (state_0 & 0xfc000) == 0xfc000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */
                     && (state_0 & 0x1c000) == 0x1c000) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */
                     && (state_0 & 0xe0000) == 0xe0000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doPInt(PInt, PInt, Node, PRaiseNode)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1111111111) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doIPi(int, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLPi(long, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doPInt(PInt, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b11) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b110000000000) >>> 10 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b110000000000) >>> 10 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] */) {
                                if ((arg1Value_ < 32)) {
                                    Node inliningTarget__ = (this);
                                    return RShiftNode.doIISmall(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__1 = (this);
                                    return RShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] */) {
                                if ((arg1Value_ < 64)) {
                                    Node inliningTarget__2 = (this);
                                    return RShiftNode.doLLSmall(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__3 = (this);
                                    return RShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b110000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIPi(int, PInt, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIPi(int, PInt, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b110000000000) >>> 10 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b110000000000) >>> 10 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                            {
                                Node inliningTarget__4 = (this);
                                return RShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__5 = (this);
                                return RShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b111000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doPInt(PInt, PInt, Node, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            {
                                Node inliningTarget__6 = (this);
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return RShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__7 = (this);
                                PythonLanguage language__1 = (PythonLanguage.get(this));
                                return RShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doPInt(PInt, PInt, Node, PRaiseNode)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                Node inliningTarget__8 = (this);
                                return RShiftNode.doPInt(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return RShiftNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000001111) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b11) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] */) {
                            if ((arg1Value < 32)) {
                                Node inliningTarget__ = (this);
                                return RShiftNode.doIISmall(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                            {
                                Node inliningTarget__1 = (this);
                                return RShiftNode.doII(arg0Value, arg1Value, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0b1100) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c000) >>> 14 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe0000) >>> 17 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] */) {
                                if ((arg1Value_ < 64)) {
                                    Node inliningTarget__2 = (this);
                                    return RShiftNode.doLLSmall(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */) {
                                {
                                    Node inliningTarget__3 = (this);
                                    return RShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return RShiftNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public int executeInt(int arg0Value, int arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] */) {
                        if ((arg1Value < 32)) {
                            Node inliningTarget__ = (this);
                            return RShiftNode.doIISmall(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                        {
                            Node inliningTarget__1 = (this);
                            return RShiftNode.doII(arg0Value, arg1Value, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return expectInteger(executeAndSpecialize(arg0Value, arg1Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            {
                                Node inliningTarget__ = null;
                                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */) {
                                    if ((arg1Value_ < 32)) {
                                        inliningTarget__ = (this);
                                        state_0 = (state_0 | (intCast0 << 10) /* set-int ImplicitCast[type=int, index=0] */);
                                        state_0 = (state_0 | (intCast1 << 12) /* set-int ImplicitCast[type=int, index=1] */);
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return RShiftNode.doIISmall(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                                    }
                                }
                            }
                            {
                                Node inliningTarget__1 = null;
                                inliningTarget__1 = (this);
                                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IntBuiltins.RShiftNode.doIISmall(int, int, Node, PRaiseNode)] */;
                                state_0 = (state_0 | (intCast0 << 10) /* set-int ImplicitCast[type=int, index=0] */);
                                state_0 = (state_0 | (intCast1 << 12) /* set-int ImplicitCast[type=int, index=1] */);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.RShiftNode.doII(int, int, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return RShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            {
                                Node inliningTarget__2 = null;
                                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */) {
                                    if ((arg1Value_ < 64)) {
                                        inliningTarget__2 = (this);
                                        state_0 = (state_0 | (longCast0 << 14) /* set-int ImplicitCast[type=long, index=0] */);
                                        state_0 = (state_0 | (longCast1 << 17) /* set-int ImplicitCast[type=long, index=1] */);
                                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return RShiftNode.doLLSmall(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                    }
                                }
                            }
                            {
                                Node inliningTarget__3 = null;
                                inliningTarget__3 = (this);
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.RShiftNode.doLLSmall(long, long, Node, PRaiseNode)] */;
                                state_0 = (state_0 | (longCast0 << 14) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 17) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.RShiftNode.doLL(long, long, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return RShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        Node inliningTarget__4 = null;
                        int intCast0;
                        if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                            inliningTarget__4 = (this);
                            state_0 = (state_0 | (intCast0 << 10) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.RShiftNode.doIPi(int, PInt, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return RShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                        }
                    }
                    {
                        Node inliningTarget__5 = null;
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            inliningTarget__5 = (this);
                            state_0 = (state_0 | (longCast0 << 14) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.RShiftNode.doLPi(long, PInt, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return RShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        PythonLanguage language__ = null;
                        Node inliningTarget__6 = null;
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            inliningTarget__6 = (this);
                            language__ = (PythonLanguage.get(this));
                            state_0 = (state_0 | (intCast1 << 12) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.RShiftNode.doPiI(PInt, int, Node, PythonLanguage, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return RShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                        }
                    }
                    {
                        PythonLanguage language__1 = null;
                        Node inliningTarget__7 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__7 = (this);
                            language__1 = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast1 << 17) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.RShiftNode.doPiL(PInt, long, Node, PythonLanguage, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return RShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                        }
                    }
                    {
                        Node inliningTarget__8 = null;
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            inliningTarget__8 = (this);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.RShiftNode.doPInt(PInt, PInt, Node, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return RShiftNode.doPInt(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                        }
                    }
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.RShiftNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return RShiftNode.doGeneric(arg0Value, arg1Value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (int) value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }

        }
    }
    @GeneratedBy(AndNode.class)
    public static final class AndNodeFactory implements NodeFactory<AndNode> {

        private static final AndNodeFactory AND_NODE_FACTORY_INSTANCE = new AndNodeFactory();

        private AndNodeFactory() {
        }

        @Override
        public Class<AndNode> getNodeClass() {
            return AndNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public AndNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AndNode> getInstance() {
            return AND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AndNode create() {
            return new AndNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BinaryBitwiseNode#doInteger(int, int)}
         *     Activation probability: 0.14679
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doInteger(long, long)}
         *     Activation probability: 0.13526
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#opVoidNativePtrLong}
         *     Activation probability: 0.12372
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#opVoidPtrLong}
         *     Activation probability: 0.11218
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsNative}
         *     Activation probability: 0.10064
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsANative}
         *     Activation probability: 0.08910
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsBNative}
         *     Activation probability: 0.07756
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsManaged}
         *     Activation probability: 0.06603
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(long, PInt, PythonLanguage)}
         *     Activation probability: 0.05449
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(PInt, long, PythonLanguage)}
         *     Activation probability: 0.04295
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(PInt, PInt, PythonLanguage)}
         *     Activation probability: 0.03141
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doGeneric}
         *     Activation probability: 0.01987
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(AndNode.class)
        @SuppressWarnings("javadoc")
        public static final class AndNodeGen extends AndNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, STATE_0_UPDATER.subUpdater(22, 7), ReferenceField.create(MethodHandles.lookup(), "h_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BinaryBitwiseNode#doInteger(int, int)}
             *   1: SpecializationActive {@link BinaryBitwiseNode#doInteger(long, long)}
             *   2: SpecializationActive {@link BinaryBitwiseNode#opVoidNativePtrLong}
             *   3: SpecializationActive {@link BinaryBitwiseNode#opVoidPtrLong}
             *   4: SpecializationActive {@link BinaryBitwiseNode#voidPtrsNative}
             *   5: SpecializationActive {@link BinaryBitwiseNode#voidPtrsANative}
             *   6: SpecializationActive {@link BinaryBitwiseNode#voidPtrsBNative}
             *   7: SpecializationActive {@link BinaryBitwiseNode#voidPtrsManaged}
             *   8: SpecializationActive {@link BinaryBitwiseNode#doPInt(long, PInt, PythonLanguage)}
             *   9: SpecializationActive {@link BinaryBitwiseNode#doPInt(PInt, long, PythonLanguage)}
             *   10: SpecializationActive {@link BinaryBitwiseNode#doPInt(PInt, PInt, PythonLanguage)}
             *   11: SpecializationActive {@link BinaryBitwiseNode#doGeneric}
             *   12-13: ImplicitCast[type=int, index=0]
             *   14-15: ImplicitCast[type=int, index=1]
             *   16-18: ImplicitCast[type=long, index=0]
             *   19-21: ImplicitCast[type=long, index=1]
             *   22-28: InlinedCache
             *        Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *        Parameter: {@link PyObjectHashNode} hashNode
             *        Inline method: {@link PyObjectHashNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field3_;

            private AndNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */
                     && (state_0 & 0x3f0000) == 0x3f0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                return false;
                            }
                        }
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((!(arg0Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr && arg1Value instanceof PythonNativeVoidPtr) {
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((arg0Value_.isNativePointer())) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((arg1Value_.isNativePointer())) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((arg0Value_.isNativePointer())) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((!(arg1Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((!(arg0Value_.isNativePointer()))) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((arg1Value_.isNativePointer())) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((!(arg0Value_.isNativePointer()))) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((!(arg1Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                }
                if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */
                 && (state_0 & 0x70000) == 0x70000) && PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    return false;
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */
                     && (state_0 & 0x380000) == 0x380000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111111111) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            return doInteger(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b1110) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return doInteger(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1100) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] */) {
                                if ((arg0Value_.isNativePointer())) {
                                    return opVoidNativePtrLong(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer()))) {
                                    Node inliningTarget__ = (this);
                                    return opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b11110000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if (arg1Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */) {
                                if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                                    return voidPtrsNative(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__1 = (this);
                                    return voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                    Node inliningTarget__2 = (this);
                                    return voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__3 = (this);
                                    return voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                PythonLanguage language__1 = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__1);
                            }
                        }
                        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                PythonLanguage language__2 = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            state_0 = (state_0 | (intCast0 << 12) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 14) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] */;
                            this.state_0_ = state_0;
                            return doInteger(arg0Value_, arg1Value_);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                state_0 = (state_0 | (longCast0 << 16) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */;
                                this.state_0_ = state_0;
                                return doInteger(arg0Value_, arg1Value_);
                            }
                        }
                        if (arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] */;
                                this.state_0_ = state_0;
                                return opVoidNativePtrLong(arg0Value_, arg1Value_);
                            }
                            {
                                Node inliningTarget__ = null;
                                if ((!(arg0Value_.isNativePointer()))) {
                                    inliningTarget__ = (this);
                                    state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */;
                                    this.state_0_ = state_0;
                                    return opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                                }
                            }
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                        if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */;
                            this.state_0_ = state_0;
                            return voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        {
                            Node inliningTarget__1 = null;
                            if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__1 = (this);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__2 = null;
                            if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                inliningTarget__2 = (this);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__3 = null;
                            if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__3 = (this);
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                    }
                }
                {
                    PythonLanguage language__ = null;
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            language__ = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast0 << 16) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__);
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        PythonLanguage language__1 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            language__1 = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__1);
                        }
                    }
                    {
                        PythonLanguage language__2 = null;
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            language__2 = (PythonLanguage.get(this));
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__2);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(OrNode.class)
    public static final class OrNodeFactory implements NodeFactory<OrNode> {

        private static final OrNodeFactory OR_NODE_FACTORY_INSTANCE = new OrNodeFactory();

        private OrNodeFactory() {
        }

        @Override
        public Class<OrNode> getNodeClass() {
            return OrNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public OrNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<OrNode> getInstance() {
            return OR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static OrNode create() {
            return new OrNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BinaryBitwiseNode#doInteger(int, int)}
         *     Activation probability: 0.14679
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doInteger(long, long)}
         *     Activation probability: 0.13526
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#opVoidNativePtrLong}
         *     Activation probability: 0.12372
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#opVoidPtrLong}
         *     Activation probability: 0.11218
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsNative}
         *     Activation probability: 0.10064
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsANative}
         *     Activation probability: 0.08910
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsBNative}
         *     Activation probability: 0.07756
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsManaged}
         *     Activation probability: 0.06603
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(long, PInt, PythonLanguage)}
         *     Activation probability: 0.05449
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(PInt, long, PythonLanguage)}
         *     Activation probability: 0.04295
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(PInt, PInt, PythonLanguage)}
         *     Activation probability: 0.03141
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doGeneric}
         *     Activation probability: 0.01987
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(OrNode.class)
        @SuppressWarnings("javadoc")
        public static final class OrNodeGen extends OrNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, STATE_0_UPDATER.subUpdater(22, 7), ReferenceField.create(MethodHandles.lookup(), "h_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BinaryBitwiseNode#doInteger(int, int)}
             *   1: SpecializationActive {@link BinaryBitwiseNode#doInteger(long, long)}
             *   2: SpecializationActive {@link BinaryBitwiseNode#opVoidNativePtrLong}
             *   3: SpecializationActive {@link BinaryBitwiseNode#opVoidPtrLong}
             *   4: SpecializationActive {@link BinaryBitwiseNode#voidPtrsNative}
             *   5: SpecializationActive {@link BinaryBitwiseNode#voidPtrsANative}
             *   6: SpecializationActive {@link BinaryBitwiseNode#voidPtrsBNative}
             *   7: SpecializationActive {@link BinaryBitwiseNode#voidPtrsManaged}
             *   8: SpecializationActive {@link BinaryBitwiseNode#doPInt(long, PInt, PythonLanguage)}
             *   9: SpecializationActive {@link BinaryBitwiseNode#doPInt(PInt, long, PythonLanguage)}
             *   10: SpecializationActive {@link BinaryBitwiseNode#doPInt(PInt, PInt, PythonLanguage)}
             *   11: SpecializationActive {@link BinaryBitwiseNode#doGeneric}
             *   12-13: ImplicitCast[type=int, index=0]
             *   14-15: ImplicitCast[type=int, index=1]
             *   16-18: ImplicitCast[type=long, index=0]
             *   19-21: ImplicitCast[type=long, index=1]
             *   22-28: InlinedCache
             *        Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *        Parameter: {@link PyObjectHashNode} hashNode
             *        Inline method: {@link PyObjectHashNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field3_;

            private OrNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */
                     && (state_0 & 0x3f0000) == 0x3f0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                return false;
                            }
                        }
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((!(arg0Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr && arg1Value instanceof PythonNativeVoidPtr) {
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((arg0Value_.isNativePointer())) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((arg1Value_.isNativePointer())) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((arg0Value_.isNativePointer())) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((!(arg1Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((!(arg0Value_.isNativePointer()))) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((arg1Value_.isNativePointer())) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((!(arg0Value_.isNativePointer()))) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((!(arg1Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                }
                if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */
                 && (state_0 & 0x70000) == 0x70000) && PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    return false;
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */
                     && (state_0 & 0x380000) == 0x380000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111111111) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            return doInteger(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b1110) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return doInteger(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1100) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] */) {
                                if ((arg0Value_.isNativePointer())) {
                                    return opVoidNativePtrLong(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer()))) {
                                    Node inliningTarget__ = (this);
                                    return opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b11110000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if (arg1Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */) {
                                if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                                    return voidPtrsNative(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__1 = (this);
                                    return voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                    Node inliningTarget__2 = (this);
                                    return voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__3 = (this);
                                    return voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                PythonLanguage language__1 = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__1);
                            }
                        }
                        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                PythonLanguage language__2 = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            state_0 = (state_0 | (intCast0 << 12) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 14) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] */;
                            this.state_0_ = state_0;
                            return doInteger(arg0Value_, arg1Value_);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                state_0 = (state_0 | (longCast0 << 16) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */;
                                this.state_0_ = state_0;
                                return doInteger(arg0Value_, arg1Value_);
                            }
                        }
                        if (arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] */;
                                this.state_0_ = state_0;
                                return opVoidNativePtrLong(arg0Value_, arg1Value_);
                            }
                            {
                                Node inliningTarget__ = null;
                                if ((!(arg0Value_.isNativePointer()))) {
                                    inliningTarget__ = (this);
                                    state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */;
                                    this.state_0_ = state_0;
                                    return opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                                }
                            }
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                        if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */;
                            this.state_0_ = state_0;
                            return voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        {
                            Node inliningTarget__1 = null;
                            if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__1 = (this);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__2 = null;
                            if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                inliningTarget__2 = (this);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__3 = null;
                            if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__3 = (this);
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                    }
                }
                {
                    PythonLanguage language__ = null;
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            language__ = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast0 << 16) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__);
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        PythonLanguage language__1 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            language__1 = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__1);
                        }
                    }
                    {
                        PythonLanguage language__2 = null;
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            language__2 = (PythonLanguage.get(this));
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__2);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(XorNode.class)
    public static final class XorNodeFactory implements NodeFactory<XorNode> {

        private static final XorNodeFactory XOR_NODE_FACTORY_INSTANCE = new XorNodeFactory();

        private XorNodeFactory() {
        }

        @Override
        public Class<XorNode> getNodeClass() {
            return XorNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public XorNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<XorNode> getInstance() {
            return XOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static XorNode create() {
            return new XorNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BinaryBitwiseNode#doInteger(int, int)}
         *     Activation probability: 0.14679
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doInteger(long, long)}
         *     Activation probability: 0.13526
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#opVoidNativePtrLong}
         *     Activation probability: 0.12372
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#opVoidPtrLong}
         *     Activation probability: 0.11218
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsNative}
         *     Activation probability: 0.10064
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsANative}
         *     Activation probability: 0.08910
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsBNative}
         *     Activation probability: 0.07756
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#voidPtrsManaged}
         *     Activation probability: 0.06603
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(long, PInt, PythonLanguage)}
         *     Activation probability: 0.05449
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(PInt, long, PythonLanguage)}
         *     Activation probability: 0.04295
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doPInt(PInt, PInt, PythonLanguage)}
         *     Activation probability: 0.03141
         *     With/without class size: 4/0 bytes
         *   Specialization {@link BinaryBitwiseNode#doGeneric}
         *     Activation probability: 0.01987
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(XorNode.class)
        @SuppressWarnings("javadoc")
        public static final class XorNodeGen extends XorNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, STATE_0_UPDATER.subUpdater(22, 7), ReferenceField.create(MethodHandles.lookup(), "h_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BinaryBitwiseNode#doInteger(int, int)}
             *   1: SpecializationActive {@link BinaryBitwiseNode#doInteger(long, long)}
             *   2: SpecializationActive {@link BinaryBitwiseNode#opVoidNativePtrLong}
             *   3: SpecializationActive {@link BinaryBitwiseNode#opVoidPtrLong}
             *   4: SpecializationActive {@link BinaryBitwiseNode#voidPtrsNative}
             *   5: SpecializationActive {@link BinaryBitwiseNode#voidPtrsANative}
             *   6: SpecializationActive {@link BinaryBitwiseNode#voidPtrsBNative}
             *   7: SpecializationActive {@link BinaryBitwiseNode#voidPtrsManaged}
             *   8: SpecializationActive {@link BinaryBitwiseNode#doPInt(long, PInt, PythonLanguage)}
             *   9: SpecializationActive {@link BinaryBitwiseNode#doPInt(PInt, long, PythonLanguage)}
             *   10: SpecializationActive {@link BinaryBitwiseNode#doPInt(PInt, PInt, PythonLanguage)}
             *   11: SpecializationActive {@link BinaryBitwiseNode#doGeneric}
             *   12-13: ImplicitCast[type=int, index=0]
             *   14-15: ImplicitCast[type=int, index=1]
             *   16-18: ImplicitCast[type=long, index=0]
             *   19-21: ImplicitCast[type=long, index=1]
             *   22-28: InlinedCache
             *        Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *        Parameter: {@link PyObjectHashNode} hashNode
             *        Inline method: {@link PyObjectHashNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BinaryBitwiseNode#opVoidPtrLong}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field3_;

            private XorNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */
                     && (state_0 & 0x3f0000) == 0x3f0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                return false;
                            }
                        }
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((!(arg0Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr && arg1Value instanceof PythonNativeVoidPtr) {
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((arg0Value_.isNativePointer())) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((arg1Value_.isNativePointer())) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((arg0Value_.isNativePointer())) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((!(arg1Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((!(arg0Value_.isNativePointer()))) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((arg1Value_.isNativePointer())) {
                                return false;
                            }
                        }
                    }
                    {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((!(arg0Value_.isNativePointer()))) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((!(arg1Value_.isNativePointer()))) {
                                return false;
                            }
                        }
                    }
                }
                if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */
                 && (state_0 & 0x70000) == 0x70000) && PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    return false;
                }
                if (arg0Value instanceof PInt) {
                    if (!((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */
                     && (state_0 & 0x380000) == 0x380000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111111111) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000000000000) >>> 12 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000000000000) >>> 14 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                            return doInteger(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b1110) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return doInteger(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1100) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] */) {
                                if ((arg0Value_.isNativePointer())) {
                                    return opVoidNativePtrLong(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer()))) {
                                    Node inliningTarget__ = (this);
                                    return opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b11110000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if (arg1Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */) {
                                if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                                    return voidPtrsNative(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__1 = (this);
                                    return voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                    Node inliningTarget__2 = (this);
                                    return voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__3 = (this);
                                    return voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                PythonLanguage language__ = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0b11000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] || SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                PythonLanguage language__1 = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__1);
                            }
                        }
                        if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            {
                                PythonLanguage language__2 = (PythonLanguage.get(this));
                                return doPInt(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        int intCast1;
                        if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                            state_0 = (state_0 | (intCast0 << 12) /* set-int ImplicitCast[type=int, index=0] */);
                            state_0 = (state_0 | (intCast1 << 14) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(int, int)] */;
                            this.state_0_ = state_0;
                            return doInteger(arg0Value_, arg1Value_);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast0;
                            if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                                long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                                state_0 = (state_0 | (longCast0 << 16) /* set-int ImplicitCast[type=long, index=0] */);
                                state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doInteger(long, long)] */;
                                this.state_0_ = state_0;
                                return doInteger(arg0Value_, arg1Value_);
                            }
                        }
                        if (arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidNativePtrLong(PythonNativeVoidPtr, long)] */;
                                this.state_0_ = state_0;
                                return opVoidNativePtrLong(arg0Value_, arg1Value_);
                            }
                            {
                                Node inliningTarget__ = null;
                                if ((!(arg0Value_.isNativePointer()))) {
                                    inliningTarget__ = (this);
                                    state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.opVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */;
                                    this.state_0_ = state_0;
                                    return opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                                }
                            }
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                        if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */;
                            this.state_0_ = state_0;
                            return voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        {
                            Node inliningTarget__1 = null;
                            if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__1 = (this);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__2 = null;
                            if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                inliningTarget__2 = (this);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__3 = null;
                            if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__3 = (this);
                                state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                    }
                }
                {
                    PythonLanguage language__ = null;
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            language__ = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast0 << 16) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(long, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__);
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    {
                        PythonLanguage language__1 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            language__1 = (PythonLanguage.get(this));
                            state_0 = (state_0 | (longCast1 << 19) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, long, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__1);
                        }
                    }
                    {
                        PythonLanguage language__2 = null;
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            language__2 = (PythonLanguage.get(this));
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doPInt(PInt, PInt, PythonLanguage)] */;
                            this.state_0_ = state_0;
                            return doPInt(arg0Value_, arg1Value_, language__2);
                        }
                    }
                }
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.BinaryBitwiseNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link RichCompareHelperNode#doII}
     *     Activation probability: 0.14679
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doLL}
     *     Activation probability: 0.13526
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doLPExact}
     *     Activation probability: 0.12372
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doPLExact}
     *     Activation probability: 0.11218
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doLP}
     *     Activation probability: 0.10064
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doPL}
     *     Activation probability: 0.08910
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doPP}
     *     Activation probability: 0.07756
     *     With/without class size: 4/0 bytes
     *   Specialization {@link RichCompareHelperNode#doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
     *     Activation probability: 0.06603
     *     With/without class size: 5/0 bytes
     *   Specialization {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)}
     *     Activation probability: 0.05449
     *     With/without class size: 4/0 bytes
     *   Specialization {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
     *     Activation probability: 0.04295
     *     With/without class size: 4/0 bytes
     *   Specialization {@link RichCompareHelperNode#doVoidPtr}
     *     Activation probability: 0.03141
     *     With/without class size: 4/10 bytes
     *   Specialization {@link RichCompareHelperNode#doGeneric}
     *     Activation probability: 0.01987
     *     With/without class size: 4/0 bytes
     * </pre> */
    @GeneratedBy(RichCompareHelperNode.class)
    @SuppressWarnings("javadoc")
    static final class RichCompareHelperNodeGen {

        private static final StateField VOID_PTR_RICH_COMPARE_HELPER_NODE_VOID_PTR_STATE_0_UPDATER = StateField.create(VoidPtrData.lookup_(), "voidPtr_state_0_");
        private static final PointerCompareNode INLINED_VOID_PTR_POINTER_COMPARE_NODE_ = PointerCompareNodeGen.inline(InlineTarget.create(PointerCompareNode.class, VOID_PTR_RICH_COMPARE_HELPER_NODE_VOID_PTR_STATE_0_UPDATER.subUpdater(0, 13), ReferenceField.create(VoidPtrData.lookup_(), "voidPtr_pointerCompareNode__field1_", Node.class)));

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#state_1_}
         * <li>{@link Inlined#getClass_field1_}
         * <li>{@link Inlined#getClass_field2_}
         * <li>{@link Inlined#getClass_field3_}
         * <li>{@link Inlined#isSubtype}
         * <li>{@link Inlined#nativeRight}
         * <li>{@link Inlined#nativeLeft}
         * <li>{@link Inlined#voidPtr_cache}
         * </ul> */
        @NeverDefault
        public static RichCompareHelperNode inline(@RequiredField(bits = 28, value = StateField.class)@RequiredField(bits = 5, value = StateField.class)@RequiredField(type = Object.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new RichCompareHelperNodeGen.Inlined(target);
        }

        @GeneratedBy(RichCompareHelperNode.class)
        @DenyReplace
        private static final class Inlined extends RichCompareHelperNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RichCompareHelperNode#doII}
             *   1: SpecializationActive {@link RichCompareHelperNode#doLL}
             *   2: SpecializationActive {@link RichCompareHelperNode#doLPExact}
             *   3: SpecializationExcluded {@link RichCompareHelperNode#doLPExact}
             *   4: SpecializationActive {@link RichCompareHelperNode#doLP}
             *   5: SpecializationActive {@link RichCompareHelperNode#doPLExact}
             *   6: SpecializationExcluded {@link RichCompareHelperNode#doPLExact}
             *   7: SpecializationActive {@link RichCompareHelperNode#doPL}
             *   8: SpecializationActive {@link RichCompareHelperNode#doPP}
             *   9: SpecializationActive {@link RichCompareHelperNode#doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
             *   10: GuardActive[guardIndex=0] {@link RichCompareHelperNode#doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
             *   11: SpecializationActive {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)}
             *   12: GuardActive[guardIndex=0] {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)}
             *   13: GuardActive[guardIndex=1] {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)}
             *   14: SpecializationActive {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
             *   15: GuardActive[guardIndex=0] {@link RichCompareHelperNode#doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
             *   16: SpecializationActive {@link RichCompareHelperNode#doVoidPtr}
             *   17: SpecializationActive {@link RichCompareHelperNode#doGeneric}
             *   18-19: ImplicitCast[type=int, index=1]
             *   20-21: ImplicitCast[type=int, index=2]
             *   22-24: ImplicitCast[type=long, index=1]
             *   25-27: ImplicitCast[type=long, index=2]
             * </pre> */
            private final StateField state_0_;
            /**
             * State Info: <pre>
             *   0-4: InlinedCache
             *        Specialization: {@link RichCompareHelperNode#doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
             *        Parameter: {@link GetPythonObjectClassNode} getClass
             *        Inline method: {@link GetPythonObjectClassNodeGen#inline}
             * </pre> */
            private final StateField state_1_;
            private final ReferenceField<Object> getClass_field1_;
            private final ReferenceField<Node> getClass_field2_;
            private final ReferenceField<Node> getClass_field3_;
            private final ReferenceField<IsSubtypeNode> isSubtype;
            private final ReferenceField<FromNativeSubclassNode> nativeRight;
            private final ReferenceField<FromNativeSubclassNode> nativeLeft;
            private final ReferenceField<VoidPtrData> voidPtr_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareHelperNode#doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)}
             *   Parameter: {@link GetPythonObjectClassNode} getClass
             *   Inline method: {@link GetPythonObjectClassNodeGen#inline}</pre> */
            private final GetPythonObjectClassNode getClass;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(RichCompareHelperNode.class);
                this.state_0_ = target.getState(0, 28);
                this.state_1_ = target.getState(1, 5);
                this.getClass_field1_ = target.getReference(2, Object.class);
                this.getClass_field2_ = target.getReference(3, Node.class);
                this.getClass_field3_ = target.getReference(4, Node.class);
                this.isSubtype = target.getReference(5, IsSubtypeNode.class);
                this.nativeRight = target.getReference(6, FromNativeSubclassNode.class);
                this.nativeLeft = target.getReference(7, FromNativeSubclassNode.class);
                this.voidPtr_cache = target.getReference(8, VoidPtrData.class);
                this.getClass = GetPythonObjectClassNodeGen.inline(InlineTarget.create(GetPythonObjectClassNode.class, state_1_.subUpdater(0, 5), getClass_field1_, getClass_field2_, getClass_field3_));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, Object arg2Value, RichCmpOp arg3Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doLL(long, long, RichCmpOp)] */
                     && (state_0 & 0xfc00000) == 0xfc00000) && PythonIntegerTypesGen.isImplicitLong(arg2Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doLP(long, PInt, RichCmpOp)] */
                     && (state_0 & 0x1c00000) == 0x1c00000) && arg2Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg1Value instanceof PInt) {
                    if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doPL(PInt, long, RichCmpOp)] */
                     && (state_0 & 0xe000000) == 0xe000000) && PythonIntegerTypesGen.isImplicitLong(arg2Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doPP(PInt, PInt, RichCmpOp)] */) && arg2Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg2Value instanceof PythonAbstractNativeObject) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject) arg2Value;
                        GetPythonObjectClassNode getClass_ = this.getClass;
                        IsSubtypeNode isSubtype_ = this.isSubtype.get(arg0Value);
                        if ((((state_0 & 0b10000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode), guardIndex=0] */ || getClass_ == null || isSubtype_ == null || (FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, getClass_, isSubtype_)))) {
                            return false;
                        }
                    }
                    if (arg1Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                        GetPythonObjectClassNode getClass_1 = this.getClass;
                        IsSubtypeNode isSubtype_1 = this.isSubtype.get(arg0Value);
                        if ((((state_0 & 0b1000000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode), guardIndex=0] */ || getClass_1 == null || isSubtype_1 == null || (FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, getClass_1, isSubtype_1)))) {
                            PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject) arg2Value;
                            if ((((state_0 & 0b10000000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode), guardIndex=1] */ || getClass_1 == null || isSubtype_1 == null || (FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, getClass_1, isSubtype_1)))) {
                                return false;
                            }
                        }
                    }
                }
                if (arg1Value instanceof PythonAbstractNativeObject && arg2Value instanceof Double) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                    GetPythonObjectClassNode getClass_2 = this.getClass;
                    IsSubtypeNode isSubtype_2 = this.isSubtype.get(arg0Value);
                    if ((((state_0 & 0b1000000000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode), guardIndex=0] */ || getClass_2 == null || isSubtype_2 == null || (FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, getClass_2, isSubtype_2)))) {
                        return false;
                    }
                }
                if (!((state_0 & 0x10000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doVoidPtr(VirtualFrame, Node, Object, Object, RichCmpOp, PointerCompareNode, EqNodeNativePtr)] */) && (RichCompareHelperNode.someIsNativePtr(arg1Value, arg2Value))) {
                    return false;
                }
                return true;
            }

            @Override
            Object execute(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value, RichCmpOp arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x34bb7) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doII(int, int, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doLL(long, long, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doPLExact(PInt, long, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doLP(long, PInt, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doPL(PInt, long, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doPP(PInt, PInt, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doVoidPtr(VirtualFrame, Node, Object, Object, RichCmpOp, PointerCompareNode, EqNodeNativePtr)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doGeneric(Object, Object, RichCmpOp)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doII(int, int, RichCmpOp)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xc0000) >>> 18 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xc0000) >>> 18 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x300000) >>> 20 /* get-int ImplicitCast[type=int, index=2] */, arg2Value)) {
                            int arg2Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x300000) >>> 20 /* get-int ImplicitCast[type=int, index=2] */, arg2Value);
                            return RichCompareHelperNode.doII(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0b110) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doLL(long, long, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doLL(long, long, RichCmpOp)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=2] */, arg2Value)) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=2] */, arg2Value);
                            return RichCompareHelperNode.doLL(arg1Value_, arg2Value_, arg3Value);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] */ && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            try {
                                return RichCompareHelperNode.doLPExact(arg1Value_, arg2Value_, arg3Value);
                            } catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_.get(arg0Value);
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_.set(arg0Value, state_0);
                                return executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doPLExact(PInt, long, RichCmpOp)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=2] */, arg2Value)) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=2] */, arg2Value);
                            try {
                                return RichCompareHelperNode.doPLExact(arg1Value_, arg2Value_, arg3Value);
                            } catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_.get(arg0Value);
                                state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.RichCompareHelperNode.doPLExact(PInt, long, RichCmpOp)] */;
                                state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                                this.state_0_.set(arg0Value, state_0);
                                return executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doLP(long, PInt, RichCmpOp)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                        if (arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            return RichCompareHelperNode.doLP(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0b110000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doPL(PInt, long, RichCmpOp)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doPP(PInt, PInt, RichCmpOp)] */ && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doPL(PInt, long, RichCmpOp)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=2] */, arg2Value)) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xe000000) >>> 25 /* get-int ImplicitCast[type=long, index=2] */, arg2Value);
                            return RichCompareHelperNode.doPL(arg1Value_, arg2Value_, arg3Value);
                        }
                        if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doPP(PInt, PInt, RichCmpOp)] */ && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            return RichCompareHelperNode.doPP(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0b101000000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)] */ && arg2Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject) arg2Value;
                        if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1c00000) >>> 22 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                IsSubtypeNode isSubtype_ = this.isSubtype.get(arg0Value);
                                if (isSubtype_ != null) {
                                    FromNativeSubclassNode nativeRight_ = this.nativeRight.get(arg0Value);
                                    if (nativeRight_ != null) {
                                        if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_))) {
                                            return RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_, nativeRight_);
                                        }
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)] */ && arg1Value instanceof PythonAbstractNativeObject) {
                            PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                            {
                                IsSubtypeNode isSubtype_1 = this.isSubtype.get(arg0Value);
                                if (isSubtype_1 != null) {
                                    FromNativeSubclassNode nativeLeft_ = this.nativeLeft.get(arg0Value);
                                    if (nativeLeft_ != null) {
                                        FromNativeSubclassNode nativeRight_1 = this.nativeRight.get(arg0Value);
                                        if (nativeRight_1 != null) {
                                            if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_1)) && (FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_1))) {
                                                return RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_1, nativeLeft_, nativeRight_1);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] */ && arg1Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                        if (arg2Value instanceof Double) {
                            double arg2Value_ = (double) arg2Value;
                            {
                                IsSubtypeNode isSubtype_2 = this.isSubtype.get(arg0Value);
                                if (isSubtype_2 != null) {
                                    FromNativeSubclassNode nativeLeft_1 = this.nativeLeft.get(arg0Value);
                                    if (nativeLeft_1 != null) {
                                        if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_2))) {
                                            return RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_2, nativeLeft_1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x30000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doVoidPtr(VirtualFrame, Node, Object, Object, RichCmpOp, PointerCompareNode, EqNodeNativePtr)] || SpecializationActive[IntBuiltins.RichCompareHelperNode.doGeneric(Object, Object, RichCmpOp)] */) {
                        if ((state_0 & 0x10000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doVoidPtr(VirtualFrame, Node, Object, Object, RichCmpOp, PointerCompareNode, EqNodeNativePtr)] */) {
                            VoidPtrData s10_ = this.voidPtr_cache.get(arg0Value);
                            if (s10_ != null) {
                                if ((RichCompareHelperNode.someIsNativePtr(arg1Value, arg2Value))) {
                                    return RichCompareHelperNode.doVoidPtr(frameValue, s10_, arg1Value, arg2Value, arg3Value, INLINED_VOID_PTR_POINTER_COMPARE_NODE_, s10_.pointerEqNode_);
                                }
                            }
                        }
                        if ((state_0 & 0x20000) != 0 /* is SpecializationActive[IntBuiltins.RichCompareHelperNode.doGeneric(Object, Object, RichCmpOp)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                                return RichCompareHelperNode.doGeneric(arg1Value, arg2Value, arg3Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value, RichCmpOp arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                {
                    int intCast1;
                    if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        int intCast2;
                        if ((intCast2 = PythonIntegerTypesGen.specializeImplicitInteger(arg2Value)) != 0) {
                            int arg2Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast2, arg2Value);
                            state_0 = (state_0 | (intCast1 << 18) /* set-int ImplicitCast[type=int, index=1] */);
                            state_0 = (state_0 | (intCast2 << 20) /* set-int ImplicitCast[type=int, index=2] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doII(int, int, RichCmpOp)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return RichCompareHelperNode.doII(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        {
                            int longCast2;
                            if ((longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value)) != 0) {
                                long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                                state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                                state_0 = (state_0 | (longCast2 << 25) /* set-int ImplicitCast[type=long, index=2] */);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doLL(long, long, RichCmpOp)] */;
                                this.state_0_.set(arg0Value, state_0);
                                return RichCompareHelperNode.doLL(arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                        if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[IntBuiltins.RichCompareHelperNode.doLP(long, PInt, RichCmpOp)] */ && ((state_0 & 0b1000)) == 0 /* is-not SpecializationExcluded  */ && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] */;
                            this.state_0_.set(arg0Value, state_0);
                            try {
                                return RichCompareHelperNode.doLPExact(arg1Value_, arg2Value_, arg3Value);
                            } catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_.get(arg0Value);
                                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] */;
                                state_0 = state_0 | 0b1000 /* add SpecializationExcluded  */;
                                this.state_0_.set(arg0Value, state_0);
                                return executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                }
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[IntBuiltins.RichCompareHelperNode.doPL(PInt, long, RichCmpOp)] */ && ((state_0 & 0b1000000)) == 0 /* is-not SpecializationExcluded  */ && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    int longCast2;
                    if ((longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value)) != 0) {
                        long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                        state_0 = (state_0 | (longCast2 << 25) /* set-int ImplicitCast[type=long, index=2] */);
                        state_0 = state_0 | 0b100000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doPLExact(PInt, long, RichCmpOp)] */;
                        this.state_0_.set(arg0Value, state_0);
                        try {
                            return RichCompareHelperNode.doPLExact(arg1Value_, arg2Value_, arg3Value);
                        } catch (OverflowException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_.get(arg0Value);
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.RichCompareHelperNode.doPLExact(PInt, long, RichCmpOp)] */;
                            state_0 = state_0 | 0b1000000 /* add SpecializationExcluded  */;
                            this.state_0_.set(arg0Value, state_0);
                            return executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                }
                {
                    int longCast1;
                    if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        if (arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[IntBuiltins.RichCompareHelperNode.doLPExact(long, PInt, RichCmpOp)] */;
                            state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doLP(long, PInt, RichCmpOp)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return RichCompareHelperNode.doLP(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    {
                        int longCast2;
                        if ((longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value)) != 0) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                            state_0 = state_0 & 0xffffffdf /* remove SpecializationActive[IntBuiltins.RichCompareHelperNode.doPLExact(PInt, long, RichCmpOp)] */;
                            state_0 = (state_0 | (longCast2 << 25) /* set-int ImplicitCast[type=long, index=2] */);
                            state_0 = state_0 | 0b10000000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doPL(PInt, long, RichCmpOp)] */;
                            this.state_0_.set(arg0Value, state_0);
                            return RichCompareHelperNode.doPL(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if (arg2Value instanceof PInt) {
                        PInt arg2Value_ = (PInt) arg2Value;
                        state_0 = state_0 | 0b100000000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doPP(PInt, PInt, RichCmpOp)] */;
                        this.state_0_.set(arg0Value, state_0);
                        return RichCompareHelperNode.doPP(arg1Value_, arg2Value_, arg3Value);
                    }
                }
                if (arg2Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject) arg2Value;
                    {
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            {
                                IsSubtypeNode isSubtype_;
                                IsSubtypeNode isSubtype__shared = this.isSubtype.get(arg0Value);
                                if (isSubtype__shared != null) {
                                    isSubtype_ = isSubtype__shared;
                                } else {
                                    isSubtype_ = arg0Value.insert((IsSubtypeNode.create()));
                                    if (isSubtype_ == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (((state_0 & 0b10000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode), guardIndex=0] */) {
                                    if (this.isSubtype.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.isSubtype.set(arg0Value, isSubtype_);
                                    }
                                    state_0 = state_0 | 0b10000000000 /* add GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode), guardIndex=0] */;
                                }
                                if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_))) {
                                    if (this.isSubtype.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.isSubtype.set(arg0Value, isSubtype_);
                                    }
                                    FromNativeSubclassNode nativeRight_;
                                    FromNativeSubclassNode nativeRight__shared = this.nativeRight.get(arg0Value);
                                    if (nativeRight__shared != null) {
                                        nativeRight_ = nativeRight__shared;
                                    } else {
                                        nativeRight_ = arg0Value.insert((FromNativeSubclassNode.create()));
                                        if (nativeRight_ == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.nativeRight.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.nativeRight.set(arg0Value, nativeRight_);
                                    }
                                    state_0 = (state_0 | (longCast1 << 22) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, long, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    return RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_, nativeRight_);
                                }
                            }
                        }
                    }
                    if (arg1Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                        {
                            IsSubtypeNode isSubtype_1;
                            IsSubtypeNode isSubtype_1_shared = this.isSubtype.get(arg0Value);
                            if (isSubtype_1_shared != null) {
                                isSubtype_1 = isSubtype_1_shared;
                            } else {
                                isSubtype_1 = arg0Value.insert((IsSubtypeNode.create()));
                                if (isSubtype_1 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (((state_0 & 0b1000000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode), guardIndex=0] */) {
                                if (this.isSubtype.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.isSubtype.set(arg0Value, isSubtype_1);
                                }
                                state_0 = state_0 | 0b1000000000000 /* add GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode), guardIndex=0] */;
                            }
                            if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_1))) {
                                if (((state_0 & 0b10000000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode), guardIndex=1] */) {
                                    if (this.isSubtype.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.isSubtype.set(arg0Value, isSubtype_1);
                                    }
                                    state_0 = state_0 | 0b10000000000000 /* add GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode), guardIndex=1] */;
                                }
                                if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_1))) {
                                    if (this.isSubtype.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.isSubtype.set(arg0Value, isSubtype_1);
                                    }
                                    FromNativeSubclassNode nativeLeft_;
                                    FromNativeSubclassNode nativeLeft__shared = this.nativeLeft.get(arg0Value);
                                    if (nativeLeft__shared != null) {
                                        nativeLeft_ = nativeLeft__shared;
                                    } else {
                                        nativeLeft_ = arg0Value.insert((FromNativeSubclassNode.create()));
                                        if (nativeLeft_ == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.nativeLeft.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.nativeLeft.set(arg0Value, nativeLeft_);
                                    }
                                    FromNativeSubclassNode nativeRight_1;
                                    FromNativeSubclassNode nativeRight_1_shared = this.nativeRight.get(arg0Value);
                                    if (nativeRight_1_shared != null) {
                                        nativeRight_1 = nativeRight_1_shared;
                                    } else {
                                        nativeRight_1 = arg0Value.insert((FromNativeSubclassNode.create()));
                                        if (nativeRight_1 == null) {
                                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                        }
                                    }
                                    if (this.nativeRight.get(arg0Value) == null) {
                                        VarHandle.storeStoreFence();
                                        this.nativeRight.set(arg0Value, nativeRight_1);
                                    }
                                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, PythonAbstractNativeObject, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode, FromNativeSubclassNode)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                    return RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_1, nativeLeft_, nativeRight_1);
                                }
                            }
                        }
                    }
                }
                if (arg1Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                    if (arg2Value instanceof Double) {
                        double arg2Value_ = (double) arg2Value;
                        {
                            IsSubtypeNode isSubtype_2;
                            IsSubtypeNode isSubtype_2_shared = this.isSubtype.get(arg0Value);
                            if (isSubtype_2_shared != null) {
                                isSubtype_2 = isSubtype_2_shared;
                            } else {
                                isSubtype_2 = arg0Value.insert((IsSubtypeNode.create()));
                                if (isSubtype_2 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (((state_0 & 0b1000000000000000)) == 0 /* is-not GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode), guardIndex=0] */) {
                                if (this.isSubtype.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.isSubtype.set(arg0Value, isSubtype_2);
                                }
                                state_0 = state_0 | 0b1000000000000000 /* add GuardActive[specialization=IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode), guardIndex=0] */;
                            }
                            if ((FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_2))) {
                                if (this.isSubtype.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.isSubtype.set(arg0Value, isSubtype_2);
                                }
                                FromNativeSubclassNode nativeLeft_1;
                                FromNativeSubclassNode nativeLeft_1_shared = this.nativeLeft.get(arg0Value);
                                if (nativeLeft_1_shared != null) {
                                    nativeLeft_1 = nativeLeft_1_shared;
                                } else {
                                    nativeLeft_1 = arg0Value.insert((FromNativeSubclassNode.create()));
                                    if (nativeLeft_1 == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.nativeLeft.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.nativeLeft.set(arg0Value, nativeLeft_1);
                                }
                                state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doDN(VirtualFrame, Node, PythonAbstractNativeObject, double, RichCmpOp, GetPythonObjectClassNode, IsSubtypeNode, FromNativeSubclassNode)] */;
                                this.state_0_.set(arg0Value, state_0);
                                return RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_2, nativeLeft_1);
                            }
                        }
                    }
                }
                if ((RichCompareHelperNode.someIsNativePtr(arg1Value, arg2Value))) {
                    VoidPtrData s10_ = arg0Value.insert(new VoidPtrData());
                    EqNodeNativePtr pointerEqNode__ = s10_.insert((EqNodeNativePtrNodeGen.create()));
                    Objects.requireNonNull(pointerEqNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s10_.pointerEqNode_ = pointerEqNode__;
                    VarHandle.storeStoreFence();
                    this.voidPtr_cache.set(arg0Value, s10_);
                    state_0 = state_0 | 0x10000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doVoidPtr(VirtualFrame, Node, Object, Object, RichCmpOp, PointerCompareNode, EqNodeNativePtr)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return RichCompareHelperNode.doVoidPtr(frameValue, s10_, arg1Value, arg2Value, arg3Value, INLINED_VOID_PTR_POINTER_COMPARE_NODE_, pointerEqNode__);
                }
                state_0 = state_0 | 0x20000 /* add SpecializationActive[IntBuiltins.RichCompareHelperNode.doGeneric(Object, Object, RichCmpOp)] */;
                this.state_0_.set(arg0Value, state_0);
                return RichCompareHelperNode.doGeneric(arg1Value, arg2Value, arg3Value);
            }

        }
        @GeneratedBy(RichCompareHelperNode.class)
        @DenyReplace
        private static final class VoidPtrData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-12: InlinedCache
             *        Specialization: {@link RichCompareHelperNode#doVoidPtr}
             *        Parameter: {@link PointerCompareNode} pointerCompareNode
             *        Inline method: {@link PointerCompareNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int voidPtr_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareHelperNode#doVoidPtr}
             *   Parameter: {@link PointerCompareNode} pointerCompareNode
             *   Inline method: {@link PointerCompareNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node voidPtr_pointerCompareNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareHelperNode#doVoidPtr}
             *   Parameter: {@link EqNodeNativePtr} pointerEqNode</pre> */
            @Child EqNodeNativePtr pointerEqNode_;

            VoidPtrData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        /**
         * Debug Info: <pre>
         *   Specialization {@link EqNodeNativePtr#eqLongVoidPtr}
         *     Activation probability: 0.19111
         *     With/without class size: 7/0 bytes
         *   Specialization {@link EqNodeNativePtr#eqPIntVoidPtr}
         *     Activation probability: 0.17111
         *     With/without class size: 6/0 bytes
         *   Specialization {@link EqNodeNativePtr#eqVoidPtrLong}
         *     Activation probability: 0.15111
         *     With/without class size: 6/0 bytes
         *   Specialization {@link EqNodeNativePtr#voidPtrsNative}
         *     Activation probability: 0.13111
         *     With/without class size: 5/0 bytes
         *   Specialization {@link EqNodeNativePtr#voidPtrsANative}
         *     Activation probability: 0.11111
         *     With/without class size: 5/0 bytes
         *   Specialization {@link EqNodeNativePtr#voidPtrsBNative}
         *     Activation probability: 0.09111
         *     With/without class size: 5/0 bytes
         *   Specialization {@link EqNodeNativePtr#voidPtrsManaged}
         *     Activation probability: 0.07111
         *     With/without class size: 5/0 bytes
         *   Specialization {@link EqNodeNativePtr#eqVoidPtrPInt}
         *     Activation probability: 0.05111
         *     With/without class size: 4/0 bytes
         *   Specialization {@link EqNodeNativePtr#doGeneric}
         *     Activation probability: 0.03111
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(EqNodeNativePtr.class)
        @SuppressWarnings("javadoc")
        static final class EqNodeNativePtrNodeGen extends EqNodeNativePtr {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNodeNativePtr#eqLongVoidPtr}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, STATE_0_UPDATER.subUpdater(15, 7), ReferenceField.create(MethodHandles.lookup(), "h_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "h_field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link EqNodeNativePtr#eqLongVoidPtr}
             *   1: SpecializationActive {@link EqNodeNativePtr#eqPIntVoidPtr}
             *   2: SpecializationActive {@link EqNodeNativePtr#eqVoidPtrLong}
             *   3: SpecializationActive {@link EqNodeNativePtr#voidPtrsNative}
             *   4: SpecializationActive {@link EqNodeNativePtr#voidPtrsANative}
             *   5: SpecializationActive {@link EqNodeNativePtr#voidPtrsBNative}
             *   6: SpecializationActive {@link EqNodeNativePtr#voidPtrsManaged}
             *   7: SpecializationActive {@link EqNodeNativePtr#eqVoidPtrPInt}
             *   8: SpecializationActive {@link EqNodeNativePtr#doGeneric}
             *   9-11: ImplicitCast[type=long, index=0]
             *   12-14: ImplicitCast[type=long, index=1]
             *   15-21: InlinedCache
             *        Specialization: {@link EqNodeNativePtr#eqLongVoidPtr}
             *        Parameter: {@link PyObjectHashNode} hashNode
             *        Inline method: {@link PyObjectHashNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNodeNativePtr#eqLongVoidPtr}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNodeNativePtr#eqLongVoidPtr}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNodeNativePtr#eqLongVoidPtr}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node h_field3_;

            private EqNodeNativePtrNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg1Value instanceof PythonNativeVoidPtr) {
                    if (!((state_0 & 0b1) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(VirtualFrame, long, PythonNativeVoidPtr, Node, PyObjectHashNode)] */
                     && (state_0 & 0b111000000000000) == 0b111000000000000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(PInt, PythonNativeVoidPtr)] */) && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    if (!((state_0 & 0b100) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                                if ((arg1Value_.isNativePointer())) {
                                    return false;
                                }
                            }
                        }
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((arg0Value_.isNativePointer())) {
                                PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                                if ((!(arg1Value_.isNativePointer()))) {
                                    return false;
                                }
                            }
                        }
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((!(arg0Value_.isNativePointer()))) {
                                PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                                if ((arg1Value_.isNativePointer())) {
                                    return false;
                                }
                            }
                        }
                        {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                            if ((!(arg0Value_.isNativePointer()))) {
                                PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                                if ((!(arg1Value_.isNativePointer()))) {
                                    return false;
                                }
                            }
                        }
                    }
                    if (!((state_0 & 0b10000000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(PythonNativeVoidPtr, PInt)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111111) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(VirtualFrame, long, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(PInt, PythonNativeVoidPtr)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(PythonNativeVoidPtr, PInt)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b11) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(VirtualFrame, long, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(PInt, PythonNativeVoidPtr)] */ && arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(VirtualFrame, long, PythonNativeVoidPtr, Node, PyObjectHashNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000000000) >>> 9 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            {
                                Node inliningTarget__ = (this);
                                return EqNodeNativePtr.eqLongVoidPtr(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(PInt, PythonNativeVoidPtr)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            return EqNodeNativePtr.eqPIntVoidPtr(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b11111100) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(PythonNativeVoidPtr, PInt)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000000000000) >>> 12 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__1 = (this);
                                return EqNodeNativePtr.eqVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                            }
                        }
                        if ((state_0 & 0b1111000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] || SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */ && arg1Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */) {
                                if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                                    return EqNodeNativePtr.voidPtrsNative(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__2 = (this);
                                    return EqNodeNativePtr.voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                    Node inliningTarget__3 = (this);
                                    return EqNodeNativePtr.voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                                }
                            }
                            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */) {
                                if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                    Node inliningTarget__4 = (this);
                                    return EqNodeNativePtr.voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__4, INLINED_H);
                                }
                            }
                        }
                        if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(PythonNativeVoidPtr, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return EqNodeNativePtr.eqVoidPtrPInt(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return EqNodeNativePtr.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                    {
                        Node inliningTarget__ = null;
                        int longCast0;
                        if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (longCast0 << 9) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(VirtualFrame, long, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                            this.state_0_ = state_0;
                            return EqNodeNativePtr.eqLongVoidPtr(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                        }
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(PInt, PythonNativeVoidPtr)] */;
                        this.state_0_ = state_0;
                        return EqNodeNativePtr.eqPIntVoidPtr(arg0Value_, arg1Value_);
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                    {
                        Node inliningTarget__1 = null;
                        int longCast1;
                        if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__1 = (this);
                            state_0 = (state_0 | (longCast1 << 12) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(VirtualFrame, PythonNativeVoidPtr, long, Node, PyObjectHashNode)] */;
                            this.state_0_ = state_0;
                            return EqNodeNativePtr.eqVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                        }
                    }
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr) arg1Value;
                        if ((arg0Value_.isNativePointer()) && (arg1Value_.isNativePointer())) {
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(PythonNativeVoidPtr, PythonNativeVoidPtr)] */;
                            this.state_0_ = state_0;
                            return EqNodeNativePtr.voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        {
                            Node inliningTarget__2 = null;
                            if ((arg0Value_.isNativePointer()) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__2 = (this);
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return EqNodeNativePtr.voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__3 = null;
                            if ((!(arg0Value_.isNativePointer())) && (arg1Value_.isNativePointer())) {
                                inliningTarget__3 = (this);
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return EqNodeNativePtr.voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                        {
                            Node inliningTarget__4 = null;
                            if ((!(arg0Value_.isNativePointer())) && (!(arg1Value_.isNativePointer()))) {
                                inliningTarget__4 = (this);
                                state_0 = state_0 | 0b1000000 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(VirtualFrame, PythonNativeVoidPtr, PythonNativeVoidPtr, Node, PyObjectHashNode)] */;
                                this.state_0_ = state_0;
                                return EqNodeNativePtr.voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__4, INLINED_H);
                            }
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        state_0 = state_0 | 0b10000000 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(PythonNativeVoidPtr, PInt)] */;
                        this.state_0_ = state_0;
                        return EqNodeNativePtr.eqVoidPtrPInt(arg0Value_, arg1Value_);
                    }
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[RichCompareHelperNode.EqNodeNativePtr.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return EqNodeNativePtr.doGeneric(arg0Value, arg1Value);
            }

            @NeverDefault
            public static EqNodeNativePtr create() {
                return new EqNodeNativePtrNodeGen();
            }

        }
    }
    @GeneratedBy(RichCompareNode.class)
    static final class RichCompareNodeFactory implements NodeFactory<RichCompareNode> {

        private static final RichCompareNodeFactory RICH_COMPARE_NODE_FACTORY_INSTANCE = new RichCompareNodeFactory();

        private RichCompareNodeFactory() {
        }

        @Override
        public Class<RichCompareNode> getNodeClass() {
            return RichCompareNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public RichCompareNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RichCompareNode> getInstance() {
            return RICH_COMPARE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RichCompareNode create() {
            return new RichCompareNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RichCompareNode#doCached}
         *     Activation probability: 1.00000
         *     With/without class size: 72/46 bytes
         * </pre> */
        @GeneratedBy(RichCompareNode.class)
        @SuppressWarnings("javadoc")
        static final class RichCompareNodeGen extends RichCompareNode {

            private static final StateField CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER = StateField.create(CachedData.lookup_(), "cached_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doCached}
             *   Parameter: {@link PyLongCheckNode} checkLeft
             *   Inline method: {@link PyLongCheckNodeGen#inline}</pre> */
            private static final PyLongCheckNode INLINED_CHECK_LEFT_ = PyLongCheckNodeGen.inline(InlineTarget.create(PyLongCheckNode.class, CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER.subUpdater(0, 5), ReferenceField.create(CachedData.lookup_(), "checkLeft__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doCached}
             *   Parameter: {@link PyLongCheckNode} checkRight
             *   Inline method: {@link PyLongCheckNodeGen#inline}</pre> */
            private static final PyLongCheckNode INLINED_CHECK_RIGHT_ = PyLongCheckNodeGen.inline(InlineTarget.create(PyLongCheckNode.class, CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER.subUpdater(5, 5), ReferenceField.create(CachedData.lookup_(), "checkRight__field1_", Node.class)));
            private static final StateField CACHED_RICH_COMPARE_NODE_CACHED_STATE_1_UPDATER = StateField.create(CachedData.lookup_(), "cached_state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link RichCompareNode#doCached}
             *   Parameter: {@link RichCompareHelperNode} cmpNode
             *   Inline method: {@link RichCompareHelperNodeGen#inline}</pre> */
            private static final RichCompareHelperNode INLINED_CMP_NODE_ = RichCompareHelperNodeGen.inline(InlineTarget.create(RichCompareHelperNode.class, CACHED_RICH_COMPARE_NODE_CACHED_STATE_1_UPDATER.subUpdater(0, 28), CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER.subUpdater(13, 5), ReferenceField.create(CachedData.lookup_(), "cmpNode__field2_", Object.class), ReferenceField.create(CachedData.lookup_(), "cmpNode__field3_", Node.class), ReferenceField.create(CachedData.lookup_(), "cmpNode__field4_", Node.class), ReferenceField.create(CachedData.lookup_(), "cmpNode__field5_", Node.class), ReferenceField.create(CachedData.lookup_(), "cmpNode__field6_", Node.class), ReferenceField.create(CachedData.lookup_(), "cmpNode__field7_", Node.class), ReferenceField.create(CachedData.lookup_(), "cmpNode__field8_", Node.class)));
            static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RichCompareNode#doCached}
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private CachedData cached_cache;

            private RichCompareNodeGen() {
            }

            @ExplodeLoop
            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.RichCompareNode.doCached(VirtualFrame, Object, Object, RichCmpOp, Node, PyLongCheckNode, PyLongCheckNode, RichCmpOp, RichCompareHelperNode)] */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if ((arg2Value == decodeRichCmpOp(((s0_.cached_state_0_ & 0b1110000000000) >>> 10 /* get-int EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)] */) - 2))) {
                            Node inliningTarget__ = (s0_);
                            return RichCompareNode.doCached(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_CHECK_LEFT_, INLINED_CHECK_RIGHT_, decodeRichCmpOp(((s0_.cached_state_0_ & 0b1110000000000) >>> 10 /* get-int EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)] */) - 2), INLINED_CMP_NODE_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    while (true) {
                        int count0_ = 0;
                        CachedData s0_ = CACHED_CACHE_UPDATER.getVolatile(this);
                        CachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg2Value == decodeRichCmpOp(((s0_.cached_state_0_ & 0b1110000000000) >>> 10 /* get-int EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)] */) - 2))) {
                                inliningTarget__ = (s0_);
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (arg2Value == decodeRichCmpOp(((s0_.cached_state_0_ & 0b1110000000000) >>> 10 /* get-int EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)] */) - 2));
                            if (count0_ < (6)) {
                                s0_ = this.insert(new CachedData(s0_original));
                                inliningTarget__ = (s0_);
                                s0_.cached_state_0_ = (s0_.cached_state_0_ | ((encodeRichCmpOp((arg2Value)) + 2) << 10) /* set-int EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)] */);
                                if (!CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.RichCompareNode.doCached(VirtualFrame, Object, Object, RichCmpOp, Node, PyLongCheckNode, PyLongCheckNode, RichCmpOp, RichCompareHelperNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return RichCompareNode.doCached(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_CHECK_LEFT_, INLINED_CHECK_RIGHT_, decodeRichCmpOp(((s0_.cached_state_0_ & 0b1110000000000) >>> 10 /* get-int EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)] */) - 2), INLINED_CMP_NODE_);
                        }
                        break;
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

            @GeneratedBy(RichCompareNode.class)
            @DenyReplace
            private static final class CachedData extends Node implements SpecializationDataNode {

                @Child CachedData next_;
                /**
                 * State Info: <pre>
                 *   0-4: InlinedCache
                 *        Specialization: {@link RichCompareNode#doCached}
                 *        Parameter: {@link PyLongCheckNode} checkLeft
                 *        Inline method: {@link PyLongCheckNodeGen#inline}
                 *   5-9: InlinedCache
                 *        Specialization: {@link RichCompareNode#doCached}
                 *        Parameter: {@link PyLongCheckNode} checkRight
                 *        Inline method: {@link PyLongCheckNodeGen#inline}
                 *   10-12: EncodedEnum[cache=IntBuiltins.RichCompareNode.doCached(..., RichCmpOp cachedOp, ...)]
                 *   13-17: InlinedCache
                 *        Specialization: {@link RichCompareNode#doCached}
                 *        Parameter: {@link RichCompareHelperNode} cmpNode
                 *        Inline method: {@link RichCompareHelperNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int cached_state_0_;
                /**
                 * State Info: <pre>
                 *   0-27: InlinedCache
                 *        Specialization: {@link RichCompareNode#doCached}
                 *        Parameter: {@link RichCompareHelperNode} cmpNode
                 *        Inline method: {@link RichCompareHelperNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int cached_state_1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link PyLongCheckNode} checkLeft
                 *   Inline method: {@link PyLongCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node checkLeft__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link PyLongCheckNode} checkRight
                 *   Inline method: {@link PyLongCheckNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node checkRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Object} field2</pre> */
                @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object cmpNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cmpNode__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Node} field4</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cmpNode__field4_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Node} field5</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cmpNode__field5_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Node} field6</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cmpNode__field6_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Node} field7</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cmpNode__field7_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link RichCompareNode#doCached}
                 *   Parameter: {@link RichCompareHelperNode} cmpNode
                 *   Inline method: {@link RichCompareHelperNodeGen#inline}
                 *   Inline field: {@link Node} field8</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cmpNode__field8_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(ToBytesNode.class)
    public static final class ToBytesNodeFactory implements NodeFactory<ToBytesNode> {

        private static final ToBytesNodeFactory TO_BYTES_NODE_FACTORY_INSTANCE = new ToBytesNodeFactory();

        private ToBytesNodeFactory() {
        }

        @Override
        public Class<ToBytesNode> getNodeClass() {
            return ToBytesNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ToBytesNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ToBytesNode> getInstance() {
            return TO_BYTES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ToBytesNode create(ReadArgumentNode[] arguments) {
            return new ToBytesNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
         *     Activation probability: 0.65000
         *     With/without class size: 17/1 bytes
         *   Specialization {@link ToBytesNode#fromPIntInt}
         *     Activation probability: 0.35000
         *     With/without class size: 11/1 bytes
         * </pre> */
        @GeneratedBy(ToBytesNode.class)
        @SuppressWarnings("javadoc")
        public static final class ToBytesNodeGen extends ToBytesNode {

            private static final StateField STATE_0_ToBytesNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *   Parameter: {@link InlinedConditionProfile} negativeByteCountProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_FROM_LONG_NEGATIVE_BYTE_COUNT_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_ToBytesNode_UPDATER.subUpdater(7, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *   Parameter: {@link InlinedConditionProfile} negativeNumberProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_FROM_LONG_NEGATIVE_NUMBER_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_ToBytesNode_UPDATER.subUpdater(9, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *   Parameter: {@link InlinedConditionProfile} overflowProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_FROM_LONG_OVERFLOW_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_ToBytesNode_UPDATER.subUpdater(11, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_FROM_LONG_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_ToBytesNode_UPDATER.subUpdater(13, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromPIntInt}
             *   Parameter: {@link InlinedConditionProfile} negativeByteCountProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_FROM_PINT_INT_NEGATIVE_BYTE_COUNT_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_ToBytesNode_UPDATER.subUpdater(14, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromPIntInt}
             *   Parameter: {@link InlinedConditionProfile} overflowProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_FROM_PINT_INT_OVERFLOW_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_ToBytesNode_UPDATER.subUpdater(16, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToBytesNode#fromPIntInt}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_FROM_PINT_INT_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_ToBytesNode_UPDATER.subUpdater(18, 1)));

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *   1: SpecializationActive {@link ToBytesNode#fromPIntInt}
             *   2-4: ImplicitCast[type=long, index=0]
             *   5-6: ImplicitCast[type=int, index=1]
             *   7-8: InlinedCache
             *        Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *        Parameter: {@link InlinedConditionProfile} negativeByteCountProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   9-10: InlinedCache
             *        Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *        Parameter: {@link InlinedConditionProfile} negativeNumberProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   11-12: InlinedCache
             *        Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *        Parameter: {@link InlinedConditionProfile} overflowProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   13: InlinedCache
             *        Specialization: {@link ToBytesNode#fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             *   14-15: InlinedCache
             *        Specialization: {@link ToBytesNode#fromPIntInt}
             *        Parameter: {@link InlinedConditionProfile} negativeByteCountProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link ToBytesNode#fromPIntInt}
             *        Parameter: {@link InlinedConditionProfile} overflowProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18: InlinedCache
             *        Specialization: {@link ToBytesNode#fromPIntInt}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private ToBytesNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[IntBuiltins.ToBytesNode.fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.ToBytesNode.fromPIntInt(PInt, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arguments1Value_)) {
                    int arguments1Value__ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arguments1Value_);
                    if (arguments2Value_ instanceof TruffleString) {
                        TruffleString arguments2Value__ = (TruffleString) arguments2Value_;
                        if (arguments3Value_ instanceof Boolean) {
                            boolean arguments3Value__ = (boolean) arguments3Value_;
                            if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.ToBytesNode.fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_)) {
                                long arguments0Value__ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_);
                                {
                                    Node inliningTarget__ = (this);
                                    PythonLanguage language__ = (PythonLanguage.get(this));
                                    return ToBytesNode.fromLong(arguments0Value__, arguments1Value__, arguments2Value__, arguments3Value__, inliningTarget__, language__, INLINED_FROM_LONG_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_LONG_NEGATIVE_NUMBER_PROFILE_, INLINED_FROM_LONG_OVERFLOW_PROFILE_, INLINED_FROM_LONG_RAISE_NODE_);
                                }
                            }
                            if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.ToBytesNode.fromPIntInt(PInt, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)] */ && arguments0Value_ instanceof PInt) {
                                PInt arguments0Value__ = (PInt) arguments0Value_;
                                {
                                    Node inliningTarget__1 = (this);
                                    PythonLanguage language__1 = (PythonLanguage.get(this));
                                    return ToBytesNode.fromPIntInt(arguments0Value__, arguments1Value__, arguments2Value__, arguments3Value__, inliningTarget__1, language__1, INLINED_FROM_PINT_INT_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_PINT_INT_OVERFLOW_PROFILE_, INLINED_FROM_PINT_INT_RAISE_NODE_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private PBytes executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                {
                    int intCast1;
                    if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arguments1Value)) != 0) {
                        int arguments1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arguments1Value);
                        if (arguments2Value instanceof TruffleString) {
                            TruffleString arguments2Value_ = (TruffleString) arguments2Value;
                            if (arguments3Value instanceof Boolean) {
                                boolean arguments3Value_ = (boolean) arguments3Value;
                                {
                                    PythonLanguage language__ = null;
                                    Node inliningTarget__ = null;
                                    int longCast0;
                                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arguments0Value)) != 0) {
                                        long arguments0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arguments0Value);
                                        inliningTarget__ = (this);
                                        language__ = (PythonLanguage.get(this));
                                        state_0 = (state_0 | (longCast0 << 2) /* set-int ImplicitCast[type=long, index=0] */);
                                        state_0 = (state_0 | (intCast1 << 5) /* set-int ImplicitCast[type=int, index=1] */);
                                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.ToBytesNode.fromLong(long, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return ToBytesNode.fromLong(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, inliningTarget__, language__, INLINED_FROM_LONG_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_LONG_NEGATIVE_NUMBER_PROFILE_, INLINED_FROM_LONG_OVERFLOW_PROFILE_, INLINED_FROM_LONG_RAISE_NODE_);
                                    }
                                }
                                {
                                    PythonLanguage language__1 = null;
                                    Node inliningTarget__1 = null;
                                    if (arguments0Value instanceof PInt) {
                                        PInt arguments0Value_ = (PInt) arguments0Value;
                                        inliningTarget__1 = (this);
                                        language__1 = (PythonLanguage.get(this));
                                        state_0 = (state_0 | (intCast1 << 5) /* set-int ImplicitCast[type=int, index=1] */);
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.ToBytesNode.fromPIntInt(PInt, int, TruffleString, boolean, Node, PythonLanguage, InlinedConditionProfile, InlinedConditionProfile, PRaiseNode)] */;
                                        this.state_0_ = state_0;
                                        return ToBytesNode.fromPIntInt(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, inliningTarget__1, language__1, INLINED_FROM_PINT_INT_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_PINT_INT_OVERFLOW_PROFILE_, INLINED_FROM_PINT_INT_RAISE_NODE_);
                                    }
                                }
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

        }
    }
    @GeneratedBy(FromBytesNode.class)
    public static final class FromBytesNodeFactory implements NodeFactory<FromBytesNode> {

        private static final FromBytesNodeFactory FROM_BYTES_NODE_FACTORY_INSTANCE = new FromBytesNodeFactory();

        private FromBytesNodeFactory() {
        }

        @Override
        public Class<FromBytesNode> getNodeClass() {
            return FromBytesNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public FromBytesNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<FromBytesNode> getInstance() {
            return FROM_BYTES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FromBytesNode create(ReadArgumentNode[] arguments) {
            return new FromBytesNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FromBytesNode#fromObject}
         *     Activation probability: 1.00000
         *     With/without class size: 44/22 bytes
         * </pre> */
        @GeneratedBy(FromBytesNode.class)
        @SuppressWarnings("javadoc")
        public static final class FromBytesNodeGen extends FromBytesNode {

            private static final StateField STATE_0_FromBytesNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link IsBuiltinClassExactProfile} isBuiltinIntProfile
             *   Inline method: {@link IsBuiltinClassExactProfileNodeGen#inline}</pre> */
            private static final IsBuiltinClassExactProfile INLINED_IS_BUILTIN_INT_PROFILE_ = IsBuiltinClassExactProfileNodeGen.inline(InlineTarget.create(IsBuiltinClassExactProfile.class, STATE_0_FromBytesNode_UPDATER.subUpdater(1, 5)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link InlinedBranchProfile} hasBytesProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_HAS_BYTES_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_FromBytesNode_UPDATER.subUpdater(6, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link PyLongFromByteArray} fromByteArray
             *   Inline method: {@link PyLongFromByteArrayNodeGen#inline}</pre> */
            private static final PyLongFromByteArray INLINED_FROM_BYTE_ARRAY_ = PyLongFromByteArrayNodeGen.inline(InlineTarget.create(PyLongFromByteArray.class, STATE_0_FromBytesNode_UPDATER.subUpdater(7, 6)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_FromBytesNode_UPDATER.subUpdater(13, 1)));

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FromBytesNode#fromObject}
             *   1-5: InlinedCache
             *        Specialization: {@link FromBytesNode#fromObject}
             *        Parameter: {@link IsBuiltinClassExactProfile} isBuiltinIntProfile
             *        Inline method: {@link IsBuiltinClassExactProfileNodeGen#inline}
             *   6: InlinedCache
             *        Specialization: {@link FromBytesNode#fromObject}
             *        Parameter: {@link InlinedBranchProfile} hasBytesProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   7-12: InlinedCache
             *        Specialization: {@link FromBytesNode#fromObject}
             *        Parameter: {@link PyLongFromByteArray} fromByteArray
             *        Inline method: {@link PyLongFromByteArrayNodeGen#inline}
             *   13: InlinedCache
             *        Specialization: {@link FromBytesNode#fromObject}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link LookupAndCallUnaryNode} callBytes</pre> */
            @Child private LookupAndCallUnaryNode callBytes_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre> */
            @Child private PythonBufferAccessLibrary bufferLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link EqualNode} equalNode</pre> */
            @Child private EqualNode equalNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link BytesFromObject} bytesFromObject</pre> */
            @Child private BytesFromObject bytesFromObject_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FromBytesNode#fromObject}
             *   Parameter: {@link CallNode} callCtor</pre> */
            @Child private CallNode callCtor_;

            private FromBytesNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.FromBytesNode.fromObject(VirtualFrame, Object, Object, TruffleString, boolean, Node, LookupAndCallUnaryNode, PythonBufferAccessLibrary, IsBuiltinClassExactProfile, InlinedBranchProfile, EqualNode, BytesFromObject, PyLongFromByteArray, CallNode, PRaiseNode)] */ && arguments2Value_ instanceof TruffleString) {
                    TruffleString arguments2Value__ = (TruffleString) arguments2Value_;
                    if (arguments3Value_ instanceof Boolean) {
                        boolean arguments3Value__ = (boolean) arguments3Value_;
                        {
                            LookupAndCallUnaryNode callBytes__ = this.callBytes_;
                            if (callBytes__ != null) {
                                PythonBufferAccessLibrary bufferLib__ = this.bufferLib_;
                                if (bufferLib__ != null) {
                                    EqualNode equalNode__ = this.equalNode_;
                                    if (equalNode__ != null) {
                                        BytesFromObject bytesFromObject__ = this.bytesFromObject_;
                                        if (bytesFromObject__ != null) {
                                            CallNode callCtor__ = this.callCtor_;
                                            if (callCtor__ != null) {
                                                Node inliningTarget__ = (this);
                                                return FromBytesNode.fromObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value__, arguments3Value__, inliningTarget__, callBytes__, bufferLib__, INLINED_IS_BUILTIN_INT_PROFILE_, INLINED_HAS_BYTES_PROFILE_, equalNode__, bytesFromObject__, INLINED_FROM_BYTE_ARRAY_, callCtor__, INLINED_RAISE_NODE_);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arguments2Value instanceof TruffleString) {
                        TruffleString arguments2Value_ = (TruffleString) arguments2Value;
                        if (arguments3Value instanceof Boolean) {
                            boolean arguments3Value_ = (boolean) arguments3Value;
                            inliningTarget__ = (this);
                            LookupAndCallUnaryNode callBytes__ = this.insert((LookupAndCallUnaryNode.create(SpecialMethodNames.T___BYTES__)));
                            Objects.requireNonNull(callBytes__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.callBytes_ = callBytes__;
                            PythonBufferAccessLibrary bufferLib__ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                            Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.bufferLib_ = bufferLib__;
                            EqualNode equalNode__ = this.insert((EqualNode.create()));
                            Objects.requireNonNull(equalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.equalNode_ = equalNode__;
                            BytesFromObject bytesFromObject__ = this.insert((BytesFromObjectNodeGen.create()));
                            Objects.requireNonNull(bytesFromObject__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.bytesFromObject_ = bytesFromObject__;
                            CallNode callCtor__ = this.insert((CallNode.create()));
                            Objects.requireNonNull(callCtor__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.callCtor_ = callCtor__;
                            state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.FromBytesNode.fromObject(VirtualFrame, Object, Object, TruffleString, boolean, Node, LookupAndCallUnaryNode, PythonBufferAccessLibrary, IsBuiltinClassExactProfile, InlinedBranchProfile, EqualNode, BytesFromObject, PyLongFromByteArray, CallNode, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return FromBytesNode.fromObject(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_, inliningTarget__, callBytes__, bufferLib__, INLINED_IS_BUILTIN_INT_PROFILE_, INLINED_HAS_BYTES_PROFILE_, equalNode__, bytesFromObject__, INLINED_FROM_BYTE_ARRAY_, callCtor__, INLINED_RAISE_NODE_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

        }
    }
    @GeneratedBy(BoolNode.class)
    public static final class BoolNodeFactory implements NodeFactory<BoolNode> {

        private static final BoolNodeFactory BOOL_NODE_FACTORY_INSTANCE = new BoolNodeFactory();

        private BoolNodeFactory() {
        }

        @Override
        public Class<BoolNode> getNodeClass() {
            return BoolNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public BoolNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public BoolNode getUncachedInstance() {
            return BoolNodeGen.UNCACHED;
        }

        public static NodeFactory<BoolNode> getInstance() {
            return BOOL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolNode create() {
            return new BoolNodeGen();
        }

        @NeverDefault
        public static BoolNode getUncached() {
            return BoolNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BoolNode#toBoolean(boolean)}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link BoolNode#toBoolean(int)}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link BoolNode#toBoolean(long)}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link BoolNode#toBoolean(PInt)}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link BoolNode#toBoolean(PythonNativeVoidPtr, InteropLibrary)}
         *     Activation probability: 0.08000
         *     With/without class size: 5/4 bytes
         * </pre> */
        @GeneratedBy(BoolNode.class)
        @SuppressWarnings("javadoc")
        public static final class BoolNodeGen extends BoolNode {

            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BoolNode#toBoolean(boolean)}
             *   1: SpecializationActive {@link BoolNode#toBoolean(int)}
             *   2: SpecializationActive {@link BoolNode#toBoolean(long)}
             *   3: SpecializationActive {@link BoolNode#toBoolean(PInt)}
             *   4: SpecializationActive {@link BoolNode#toBoolean(PythonNativeVoidPtr, InteropLibrary)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BoolNode#toBoolean(PythonNativeVoidPtr, InteropLibrary)}
             *   Parameter: {@link InteropLibrary} lib</pre> */
            @Child private InteropLibrary toBoolean4_lib_;

            private BoolNodeGen() {
            }

            @Override
            public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.BoolNode.toBoolean(boolean)] || SpecializationActive[IntBuiltins.BoolNode.toBoolean(int)] || SpecializationActive[IntBuiltins.BoolNode.toBoolean(long)] || SpecializationActive[IntBuiltins.BoolNode.toBoolean(PInt)] || SpecializationActive[IntBuiltins.BoolNode.toBoolean(PythonNativeVoidPtr, InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BoolNode.toBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BoolNode.toBoolean(int)] */ && arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BoolNode.toBoolean(long)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.BoolNode.toBoolean(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.BoolNode.toBoolean(PythonNativeVoidPtr, InteropLibrary)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        {
                            InteropLibrary lib__ = this.toBoolean4_lib_;
                            if (lib__ != null) {
                                return BoolNode.toBoolean(arg0Value_, lib__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.BoolNode.toBoolean(boolean)] */;
                    this.state_0_ = state_0;
                    return BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.BoolNode.toBoolean(int)] */;
                    this.state_0_ = state_0;
                    return BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (long) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.BoolNode.toBoolean(long)] */;
                    this.state_0_ = state_0;
                    return BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.BoolNode.toBoolean(PInt)] */;
                    this.state_0_ = state_0;
                    return BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                    InteropLibrary lib__ = this.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.toBoolean4_lib_ = lib__;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.BoolNode.toBoolean(PythonNativeVoidPtr, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return BoolNode.toBoolean(arg0Value_, lib__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
            }

            @GeneratedBy(BoolNode.class)
            @DenyReplace
            private static final class Uncached extends BoolNode implements UnadoptableNode {

                @Override
                public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    if (arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        return BoolNode.toBoolean(arg0Value_, (INTEROP_LIBRARY_.getUncached()));
                    }
                    throw newUnsupportedSpecializationException1(this, arg0Value);
                }

            }
        }
    }
    @GeneratedBy(StrNode.class)
    static final class StrNodeFactory implements NodeFactory<StrNode> {

        private static final StrNodeFactory STR_NODE_FACTORY_INSTANCE = new StrNodeFactory();

        private StrNodeFactory() {
        }

        @Override
        public Class<StrNode> getNodeClass() {
            return StrNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public StrNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<StrNode> getInstance() {
            return STR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StrNode create() {
            return new StrNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StrNode#doL}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link StrNode#doPInt}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link StrNode#doNativeVoidPtr}
         *     Activation probability: 0.18333
         *     With/without class size: 9/13 bytes
         * </pre> */
        @GeneratedBy(StrNode.class)
        @SuppressWarnings("javadoc")
        static final class StrNodeGen extends StrNode {

            private static final StateField STATE_0_StrNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}</pre> */
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_PROFILE_ = InlinedIntValueProfile.inline(InlineTarget.create(InlinedIntValueProfile.class, STATE_0_StrNode_UPDATER.subUpdater(6, 2), IntField.create(MethodHandles.lookup(), "pInt_maxDigitsProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsBitLengthProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}</pre> */
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_ = InlinedIntValueProfile.inline(InlineTarget.create(InlinedIntValueProfile.class, STATE_0_StrNode_UPDATER.subUpdater(8, 2), IntField.create(MethodHandles.lookup(), "pInt_maxDigitsBitLengthProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_P_INT_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_StrNode_UPDATER.subUpdater(10, 1)));
            private static final StateField NATIVE_VOID_PTR_STR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER = StateField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doNativeVoidPtr}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_NATIVE_VOID_PTR_HASH_NODE_ = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, NATIVE_VOID_PTR_STR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_hashNode__field1_", Node.class), ReferenceField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_hashNode__field2_", Node.class), ReferenceField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_hashNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StrNode#doL}
             *   1: SpecializationActive {@link StrNode#doPInt}
             *   2: SpecializationActive {@link StrNode#doNativeVoidPtr}
             *   3-5: ImplicitCast[type=long, index=0]
             *   6-7: InlinedCache
             *        Specialization: {@link StrNode#doPInt}
             *        Parameter: {@link InlinedIntValueProfile} maxDigitsProfile
             *        Inline method: {@link InlinedIntValueProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link StrNode#doPInt}
             *        Parameter: {@link InlinedIntValueProfile} maxDigitsBitLengthProfile
             *        Inline method: {@link InlinedIntValueProfile#inline}
             *   10: InlinedCache
             *        Specialization: {@link StrNode#doPInt}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doL}
             *   Parameter: {@link FromLongNode} fromLongNode</pre> */
            @Child private FromLongNode fromLong;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
            @Child private FromJavaStringNode pInt_fromJavaStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int pInt_maxDigitsProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsBitLengthProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int pInt_maxDigitsBitLengthProfile__field1_;
            @Child private NativeVoidPtrData nativeVoidPtr_cache;

            private StrNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doL(long, FromLongNode)] || SpecializationActive[IntBuiltins.StrNode.doPInt(PInt, Node, FromJavaStringNode, InlinedIntValueProfile, InlinedIntValueProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.StrNode.doNativeVoidPtr(VirtualFrame, PythonNativeVoidPtr, Node, PyObjectHashNode, FromLongNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doL(long, FromLongNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        {
                            FromLongNode fromLong_ = this.fromLong;
                            if (fromLong_ != null) {
                                return StrNode.doL(arg0Value_, fromLong_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doPInt(PInt, Node, FromJavaStringNode, InlinedIntValueProfile, InlinedIntValueProfile, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            FromJavaStringNode fromJavaStringNode__ = this.pInt_fromJavaStringNode_;
                            if (fromJavaStringNode__ != null) {
                                Node inliningTarget__ = (this);
                                return StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doNativeVoidPtr(VirtualFrame, PythonNativeVoidPtr, Node, PyObjectHashNode, FromLongNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        NativeVoidPtrData s2_ = this.nativeVoidPtr_cache;
                        if (s2_ != null) {
                            {
                                FromLongNode fromLong_1 = this.fromLong;
                                if (fromLong_1 != null) {
                                    Node inliningTarget__1 = (s2_);
                                    return StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        FromLongNode fromLong_;
                        FromLongNode fromLong__shared = this.fromLong;
                        if (fromLong__shared != null) {
                            fromLong_ = fromLong__shared;
                        } else {
                            fromLong_ = this.insert((FromLongNode.create()));
                            if (fromLong_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.fromLong == null) {
                            VarHandle.storeStoreFence();
                            this.fromLong = fromLong_;
                        }
                        state_0 = (state_0 | (longCast0 << 3) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.StrNode.doL(long, FromLongNode)] */;
                        this.state_0_ = state_0;
                        return StrNode.doL(arg0Value_, fromLong_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        inliningTarget__ = (this);
                        FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
                        Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pInt_fromJavaStringNode_ = fromJavaStringNode__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.StrNode.doPInt(PInt, Node, FromJavaStringNode, InlinedIntValueProfile, InlinedIntValueProfile, PRaiseNode)] */;
                        this.state_0_ = state_0;
                        return StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        NativeVoidPtrData s2_ = this.insert(new NativeVoidPtrData());
                        inliningTarget__1 = (s2_);
                        FromLongNode fromLong_1;
                        FromLongNode fromLong_1_shared = this.fromLong;
                        if (fromLong_1_shared != null) {
                            fromLong_1 = fromLong_1_shared;
                        } else {
                            fromLong_1 = s2_.insert((FromLongNode.create()));
                            if (fromLong_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.fromLong == null) {
                            this.fromLong = fromLong_1;
                        }
                        VarHandle.storeStoreFence();
                        this.nativeVoidPtr_cache = s2_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.StrNode.doNativeVoidPtr(VirtualFrame, PythonNativeVoidPtr, Node, PyObjectHashNode, FromLongNode)] */;
                        this.state_0_ = state_0;
                        return StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @GeneratedBy(StrNode.class)
            @DenyReplace
            private static final class NativeVoidPtrData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-6: InlinedCache
                 *        Specialization: {@link StrNode#doNativeVoidPtr}
                 *        Parameter: {@link PyObjectHashNode} hashNode
                 *        Inline method: {@link PyObjectHashNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int nativeVoidPtr_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StrNode#doNativeVoidPtr}
                 *   Parameter: {@link PyObjectHashNode} hashNode
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeVoidPtr_hashNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StrNode#doNativeVoidPtr}
                 *   Parameter: {@link PyObjectHashNode} hashNode
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeVoidPtr_hashNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StrNode#doNativeVoidPtr}
                 *   Parameter: {@link PyObjectHashNode} hashNode
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeVoidPtr_hashNode__field3_;

                NativeVoidPtrData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(ReprNode.class)
    static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StrNode#doL}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link StrNode#doPInt}
         *     Activation probability: 0.33333
         *     With/without class size: 14/13 bytes
         *   Specialization {@link StrNode#doNativeVoidPtr}
         *     Activation probability: 0.18333
         *     With/without class size: 9/13 bytes
         * </pre> */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        static final class ReprNodeGen extends ReprNode {

            private static final StateField STATE_0_ReprNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}</pre> */
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_PROFILE_ = InlinedIntValueProfile.inline(InlineTarget.create(InlinedIntValueProfile.class, STATE_0_ReprNode_UPDATER.subUpdater(6, 2), IntField.create(MethodHandles.lookup(), "pInt_maxDigitsProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsBitLengthProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}</pre> */
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_ = InlinedIntValueProfile.inline(InlineTarget.create(InlinedIntValueProfile.class, STATE_0_ReprNode_UPDATER.subUpdater(8, 2), IntField.create(MethodHandles.lookup(), "pInt_maxDigitsBitLengthProfile__field1_")));
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_P_INT_RAISE_NODE_ = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_ReprNode_UPDATER.subUpdater(10, 1)));
            private static final StateField NATIVE_VOID_PTR_REPR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER = StateField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doNativeVoidPtr}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre> */
            private static final PyObjectHashNode INLINED_NATIVE_VOID_PTR_HASH_NODE_ = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, NATIVE_VOID_PTR_REPR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_hashNode__field1_", Node.class), ReferenceField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_hashNode__field2_", Node.class), ReferenceField.create(NativeVoidPtrData.lookup_(), "nativeVoidPtr_hashNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StrNode#doL}
             *   1: SpecializationActive {@link StrNode#doPInt}
             *   2: SpecializationActive {@link StrNode#doNativeVoidPtr}
             *   3-5: ImplicitCast[type=long, index=0]
             *   6-7: InlinedCache
             *        Specialization: {@link StrNode#doPInt}
             *        Parameter: {@link InlinedIntValueProfile} maxDigitsProfile
             *        Inline method: {@link InlinedIntValueProfile#inline}
             *   8-9: InlinedCache
             *        Specialization: {@link StrNode#doPInt}
             *        Parameter: {@link InlinedIntValueProfile} maxDigitsBitLengthProfile
             *        Inline method: {@link InlinedIntValueProfile#inline}
             *   10: InlinedCache
             *        Specialization: {@link StrNode#doPInt}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doL}
             *   Parameter: {@link FromLongNode} fromLongNode</pre> */
            @Child private FromLongNode fromLong;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link FromJavaStringNode} fromJavaStringNode</pre> */
            @Child private FromJavaStringNode pInt_fromJavaStringNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int pInt_maxDigitsProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StrNode#doPInt}
             *   Parameter: {@link InlinedIntValueProfile} maxDigitsBitLengthProfile
             *   Inline method: {@link InlinedIntValueProfile#inline}
             *   Inline field: int field1</pre> */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int pInt_maxDigitsBitLengthProfile__field1_;
            @Child private NativeVoidPtrData nativeVoidPtr_cache;

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doL(long, FromLongNode)] || SpecializationActive[IntBuiltins.StrNode.doPInt(PInt, Node, FromJavaStringNode, InlinedIntValueProfile, InlinedIntValueProfile, PRaiseNode)] || SpecializationActive[IntBuiltins.StrNode.doNativeVoidPtr(VirtualFrame, PythonNativeVoidPtr, Node, PyObjectHashNode, FromLongNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doL(long, FromLongNode)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b111000) >>> 3 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        {
                            FromLongNode fromLong_ = this.fromLong;
                            if (fromLong_ != null) {
                                return StrNode.doL(arg0Value_, fromLong_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doPInt(PInt, Node, FromJavaStringNode, InlinedIntValueProfile, InlinedIntValueProfile, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        {
                            FromJavaStringNode fromJavaStringNode__ = this.pInt_fromJavaStringNode_;
                            if (fromJavaStringNode__ != null) {
                                Node inliningTarget__ = (this);
                                return StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.StrNode.doNativeVoidPtr(VirtualFrame, PythonNativeVoidPtr, Node, PyObjectHashNode, FromLongNode)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        NativeVoidPtrData s2_ = this.nativeVoidPtr_cache;
                        if (s2_ != null) {
                            {
                                FromLongNode fromLong_1 = this.fromLong;
                                if (fromLong_1 != null) {
                                    Node inliningTarget__1 = (s2_);
                                    return StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        FromLongNode fromLong_;
                        FromLongNode fromLong__shared = this.fromLong;
                        if (fromLong__shared != null) {
                            fromLong_ = fromLong__shared;
                        } else {
                            fromLong_ = this.insert((FromLongNode.create()));
                            if (fromLong_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.fromLong == null) {
                            VarHandle.storeStoreFence();
                            this.fromLong = fromLong_;
                        }
                        state_0 = (state_0 | (longCast0 << 3) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.StrNode.doL(long, FromLongNode)] */;
                        this.state_0_ = state_0;
                        return StrNode.doL(arg0Value_, fromLong_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        inliningTarget__ = (this);
                        FromJavaStringNode fromJavaStringNode__ = this.insert((FromJavaStringNode.create()));
                        Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.pInt_fromJavaStringNode_ = fromJavaStringNode__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.StrNode.doPInt(PInt, Node, FromJavaStringNode, InlinedIntValueProfile, InlinedIntValueProfile, PRaiseNode)] */;
                        this.state_0_ = state_0;
                        return StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                    }
                }
                {
                    Node inliningTarget__1 = null;
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        NativeVoidPtrData s2_ = this.insert(new NativeVoidPtrData());
                        inliningTarget__1 = (s2_);
                        FromLongNode fromLong_1;
                        FromLongNode fromLong_1_shared = this.fromLong;
                        if (fromLong_1_shared != null) {
                            fromLong_1 = fromLong_1_shared;
                        } else {
                            fromLong_1 = s2_.insert((FromLongNode.create()));
                            if (fromLong_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.fromLong == null) {
                            this.fromLong = fromLong_1;
                        }
                        VarHandle.storeStoreFence();
                        this.nativeVoidPtr_cache = s2_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.StrNode.doNativeVoidPtr(VirtualFrame, PythonNativeVoidPtr, Node, PyObjectHashNode, FromLongNode)] */;
                        this.state_0_ = state_0;
                        return StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @GeneratedBy(ReprNode.class)
            @DenyReplace
            private static final class NativeVoidPtrData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-6: InlinedCache
                 *        Specialization: {@link StrNode#doNativeVoidPtr}
                 *        Parameter: {@link PyObjectHashNode} hashNode
                 *        Inline method: {@link PyObjectHashNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int nativeVoidPtr_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StrNode#doNativeVoidPtr}
                 *   Parameter: {@link PyObjectHashNode} hashNode
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeVoidPtr_hashNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StrNode#doNativeVoidPtr}
                 *   Parameter: {@link PyObjectHashNode} hashNode
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeVoidPtr_hashNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link StrNode#doNativeVoidPtr}
                 *   Parameter: {@link PyObjectHashNode} hashNode
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeVoidPtr_hashNode__field3_;

                NativeVoidPtrData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(FormatNode.class)
    static final class FormatNodeFactory implements NodeFactory<FormatNode> {

        private static final FormatNodeFactory FORMAT_NODE_FACTORY_INSTANCE = new FormatNodeFactory();

        private FormatNodeFactory() {
        }

        @Override
        public Class<FormatNode> getNodeClass() {
            return FormatNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FormatNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<FormatNode> getInstance() {
            return FORMAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FormatNode create() {
            return new FormatNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FormatNodeBase#formatEmptyString}
         *     Activation probability: 0.32000
         *     With/without class size: 12/9 bytes
         *   Specialization {@link FormatNode#formatB}
         *     Activation probability: 0.26000
         *     With/without class size: 8/0 bytes
         *   Specialization {@link FormatNode#formatI}
         *     Activation probability: 0.20000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link FormatNode#formatL}
         *     Activation probability: 0.14000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FormatNode#formatPI}
         *     Activation probability: 0.08000
         *     With/without class size: 5/0 bytes
         * </pre> */
        @GeneratedBy(FormatNode.class)
        @SuppressWarnings("javadoc")
        static final class FormatNodeGen extends FormatNode {

            private static final StateField STATE_0_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNode#formatB}
             *   Parameter: {@link PRaiseNode} raiseNode
             *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, STATE_0_UPDATER.subUpdater(9, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNode#formatL}
             *   Parameter: {@link PyNumberFloatNode} floatNode
             *   Inline method: {@link PyNumberFloatNodeGen#inline}</pre> */
            private static final PyNumberFloatNode INLINED_FLOAT_NODE = PyNumberFloatNodeGen.inline(InlineTarget.create(PyNumberFloatNode.class, STATE_0_UPDATER.subUpdater(10, 5), ReferenceField.create(MethodHandles.lookup(), "floatNode_field1_", Node.class)));
            private static final StateField STATE_0_FormatNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNodeBase#formatEmptyString}
             *   Parameter: {@link PyObjectStrAsObjectNode} str
             *   Inline method: {@link PyObjectStrAsObjectNodeGen#inline}</pre> */
            private static final PyObjectStrAsObjectNode INLINED_FORMAT_EMPTY_STRING_STR_ = PyObjectStrAsObjectNodeGen.inline(InlineTarget.create(PyObjectStrAsObjectNode.class, STATE_0_FormatNode_UPDATER.subUpdater(5, 4), ReferenceField.create(MethodHandles.lookup(), "formatEmptyString_str__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "formatEmptyString_str__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FormatNodeBase#formatEmptyString}
             *   1: SpecializationActive {@link FormatNode#formatB}
             *   2: SpecializationActive {@link FormatNode#formatI}
             *   3: SpecializationActive {@link FormatNode#formatL}
             *   4: SpecializationActive {@link FormatNode#formatPI}
             *   5-8: InlinedCache
             *        Specialization: {@link FormatNodeBase#formatEmptyString}
             *        Parameter: {@link PyObjectStrAsObjectNode} str
             *        Inline method: {@link PyObjectStrAsObjectNodeGen#inline}
             *   9: InlinedCache
             *        Specialization: {@link FormatNode#formatB}
             *        Parameter: {@link PRaiseNode} raiseNode
             *        Inline method: {@link PRaiseNodeGen#inline}
             *   10-14: InlinedCache
             *        Specialization: {@link FormatNode#formatL}
             *        Parameter: {@link PyNumberFloatNode} floatNode
             *        Inline method: {@link PyNumberFloatNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNode#formatL}
             *   Parameter: {@link PyNumberFloatNode} floatNode
             *   Inline method: {@link PyNumberFloatNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node floatNode_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNodeBase#formatEmptyString}
             *   Parameter: {@link PyObjectStrAsObjectNode} str
             *   Inline method: {@link PyObjectStrAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node formatEmptyString_str__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNodeBase#formatEmptyString}
             *   Parameter: {@link PyObjectStrAsObjectNode} str
             *   Inline method: {@link PyObjectStrAsObjectNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node formatEmptyString_str__field2_;

            private FormatNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, Node, PyObjectStrAsObjectNode)] || SpecializationActive[IntBuiltins.FormatNode.formatB(boolean, TruffleString, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FormatNode.formatI(int, TruffleString, Node, PRaiseNode)] || SpecializationActive[IntBuiltins.FormatNode.formatL(VirtualFrame, long, TruffleString, Node, PythonLanguage, PyNumberFloatNode, PRaiseNode)] || SpecializationActive[IntBuiltins.FormatNode.formatPI(VirtualFrame, PInt, TruffleString, Node, PyNumberFloatNode, PRaiseNode)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, Node, PyObjectStrAsObjectNode)] */) {
                        if ((arg1Value_.isEmpty())) {
                            Node inliningTarget__ = (this);
                            return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, inliningTarget__, INLINED_FORMAT_EMPTY_STRING_STR_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.FormatNode.formatB(boolean, TruffleString, Node, PRaiseNode)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        if ((!(arg1Value_.isEmpty()))) {
                            Node inliningTarget__1 = (this);
                            return FormatNode.formatB(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.FormatNode.formatI(int, TruffleString, Node, PRaiseNode)] */ && arg0Value instanceof Integer) {
                        int arg0Value_ = (int) arg0Value;
                        if ((!(arg1Value_.isEmpty()))) {
                            Node inliningTarget__2 = (this);
                            return FormatNode.formatI(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.FormatNode.formatL(VirtualFrame, long, TruffleString, Node, PythonLanguage, PyNumberFloatNode, PRaiseNode)] */ && arg0Value instanceof Long) {
                        long arg0Value_ = (long) arg0Value;
                        if ((!(arg1Value_.isEmpty()))) {
                            Node inliningTarget__3 = (this);
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return FormatNode.formatL(frameValue, arg0Value_, arg1Value_, inliningTarget__3, language__, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.FormatNode.formatPI(VirtualFrame, PInt, TruffleString, Node, PyNumberFloatNode, PRaiseNode)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        if ((!(arg1Value_.isEmpty()))) {
                            Node inliningTarget__4 = (this);
                            return FormatNode.formatPI(frameValue, arg0Value_, arg1Value_, inliningTarget__4, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    {
                        Node inliningTarget__ = null;
                        if ((arg1Value_.isEmpty())) {
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, Node, PyObjectStrAsObjectNode)] */;
                            this.state_0_ = state_0;
                            return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, inliningTarget__, INLINED_FORMAT_EMPTY_STRING_STR_);
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        if (arg0Value instanceof Boolean) {
                            boolean arg0Value_ = (boolean) arg0Value;
                            if ((!(arg1Value_.isEmpty()))) {
                                inliningTarget__1 = (this);
                                state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.FormatNode.formatB(boolean, TruffleString, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return FormatNode.formatB(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    {
                        Node inliningTarget__2 = null;
                        if (arg0Value instanceof Integer) {
                            int arg0Value_ = (int) arg0Value;
                            if ((!(arg1Value_.isEmpty()))) {
                                inliningTarget__2 = (this);
                                state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.FormatNode.formatI(int, TruffleString, Node, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return FormatNode.formatI(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    {
                        PythonLanguage language__ = null;
                        Node inliningTarget__3 = null;
                        if (arg0Value instanceof Long) {
                            long arg0Value_ = (long) arg0Value;
                            if ((!(arg1Value_.isEmpty()))) {
                                inliningTarget__3 = (this);
                                language__ = (PythonLanguage.get(this));
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.FormatNode.formatL(VirtualFrame, long, TruffleString, Node, PythonLanguage, PyNumberFloatNode, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return FormatNode.formatL(frameValue, arg0Value_, arg1Value_, inliningTarget__3, language__, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    {
                        Node inliningTarget__4 = null;
                        if (arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            if ((!(arg1Value_.isEmpty()))) {
                                inliningTarget__4 = (this);
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.FormatNode.formatPI(VirtualFrame, PInt, TruffleString, Node, PyNumberFloatNode, PRaiseNode)] */;
                                this.state_0_ = state_0;
                                return FormatNode.formatPI(frameValue, arg0Value_, arg1Value_, inliningTarget__4, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(HashNode.class)
    public static final class HashNodeFactory implements NodeFactory<HashNode> {

        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        @Override
        public Class<HashNode> getNodeClass() {
            return HashNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public HashNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public HashNode getUncachedInstance() {
            return HashNodeGen.UNCACHED;
        }

        public static NodeFactory<HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNode create() {
            return new HashNodeGen();
        }

        @NeverDefault
        public static HashNode getUncached() {
            return HashNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HashNode#hash(int)}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link HashNode#hash(long)}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link HashNode#hash(PInt)}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link HashNode#hash(PythonNativeVoidPtr, InteropLibrary)}
         *     Activation probability: 0.14000
         *     With/without class size: 6/4 bytes
         *   Specialization {@link HashNode#hash(PythonNativeVoidPtr, InteropLibrary)}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(HashNode.class)
        @SuppressWarnings("javadoc")
        public static final class HashNodeGen extends HashNode {

            static final ReferenceField<Hash3Data> HASH3_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "hash3_cache", Hash3Data.class);
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HashNode#hash(int)}
             *   1: SpecializationActive {@link HashNode#hash(long)}
             *   2: SpecializationActive {@link HashNode#hash(PInt)}
             *   3: SpecializationActive {@link HashNode#hash(PythonNativeVoidPtr, InteropLibrary)}
             *   4: SpecializationActive {@link HashNode#hash(PythonNativeVoidPtr, InteropLibrary)}
             *   5-6: ImplicitCast[type=int, index=0]
             *   7-9: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private Hash3Data hash3_cache;

            private HashNodeGen() {
            }

            @Override
            public long executeLong(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(int)] || SpecializationActive[IntBuiltins.HashNode.hash(long)] || SpecializationActive[IntBuiltins.HashNode.hash(PInt)] || SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] || SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        return HashNode.hash(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return HashNode.hash(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return HashNode.hash(arg0Value_);
                    }
                    if ((state_0 & 0b11000) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] || SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */ && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */) {
                            Hash3Data s3_ = this.hash3_cache;
                            if (s3_ != null) {
                                if ((s3_.lib_.accepts(arg0Value_.getPointerObject()))) {
                                    return HashNode.hash(arg0Value_, s3_.lib_);
                                }
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */) {
                            return this.hash4Boundary(state_0, arg0Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private long hash4Boundary(int state_0, PythonNativeVoidPtr arg0Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        InteropLibrary lib__ = (INTEROP_LIBRARY_.getUncached(arg0Value_.getPointerObject()));
                        return HashNode.hash(arg0Value_, lib__);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        state_0 = (state_0 | (intCast0 << 5) /* set-int ImplicitCast[type=int, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.HashNode.hash(int)] */;
                        this.state_0_ = state_0;
                        return HashNode.hash(arg0Value_);
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 = (state_0 | (longCast0 << 7) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.HashNode.hash(long)] */;
                        this.state_0_ = state_0;
                        return HashNode.hash(arg0Value_);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.HashNode.hash(PInt)] */;
                    this.state_0_ = state_0;
                    return HashNode.hash(arg0Value_);
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */) {
                        while (true) {
                            int count3_ = 0;
                            Hash3Data s3_ = HASH3_CACHE_UPDATER.getVolatile(this);
                            Hash3Data s3_original = s3_;
                            while (s3_ != null) {
                                if ((s3_.lib_.accepts(arg0Value_.getPointerObject()))) {
                                    break;
                                }
                                count3_++;
                                s3_ = null;
                                break;
                            }
                            if (s3_ == null && count3_ < 1) {
                                // assert (s3_.lib_.accepts(arg0Value_.getPointerObject()));
                                s3_ = this.insert(new Hash3Data());
                                InteropLibrary lib__ = s3_.insert((INTEROP_LIBRARY_.create(arg0Value_.getPointerObject())));
                                Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s3_.lib_ = lib__;
                                if (!HASH3_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */;
                                this.state_0_ = state_0;
                            }
                            if (s3_ != null) {
                                return HashNode.hash(arg0Value_, s3_.lib_);
                            }
                            break;
                        }
                    }
                    {
                        InteropLibrary lib__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                lib__ = (INTEROP_LIBRARY_.getUncached(arg0Value_.getPointerObject()));
                                this.hash3_cache = null;
                                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */;
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.HashNode.hash(PythonNativeVoidPtr, InteropLibrary)] */;
                                this.state_0_ = state_0;
                                return HashNode.hash(arg0Value_, lib__);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

            @TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, arg0Value);
            }

            @GeneratedBy(HashNode.class)
            @DenyReplace
            private static final class Hash3Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link HashNode#hash(PythonNativeVoidPtr, InteropLibrary)}
                 *   Parameter: {@link InteropLibrary} lib</pre> */
                @Child InteropLibrary lib_;

                Hash3Data() {
                }

            }
            @GeneratedBy(HashNode.class)
            @DenyReplace
            private static final class Uncached extends HashNode implements UnadoptableNode {

                @Override
                public long executeLong(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    if (PythonIntegerTypesGen.isImplicitInteger(arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(arg0Value);
                        return HashNode.hash(arg0Value_);
                    }
                    if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                        return HashNode.hash(arg0Value_);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return HashNode.hash(arg0Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr) arg0Value;
                        return HashNode.hash(arg0Value_, (INTEROP_LIBRARY_.getUncached(arg0Value_.getPointerObject())));
                    }
                    throw newUnsupportedSpecializationException1(this, arg0Value);
                }

            }
        }
    }
    @GeneratedBy(BitCountNode.class)
    static final class BitCountNodeFactory implements NodeFactory<BitCountNode> {

        private static final BitCountNodeFactory BIT_COUNT_NODE_FACTORY_INSTANCE = new BitCountNodeFactory();

        private BitCountNodeFactory() {
        }

        @Override
        public Class<BitCountNode> getNodeClass() {
            return BitCountNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public BitCountNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<BitCountNode> getInstance() {
            return BIT_COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BitCountNode create(ReadArgumentNode[] arguments) {
            return new BitCountNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BitCountNode#bitCount(int)}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link BitCountNode#bitCount(long)}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link BitCountNode#bitCount(PInt)}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(BitCountNode.class)
        @SuppressWarnings("javadoc")
        static final class BitCountNodeGen extends BitCountNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BitCountNode#bitCount(int)}
             *   1: SpecializationActive {@link BitCountNode#bitCount(long)}
             *   2: SpecializationActive {@link BitCountNode#bitCount(PInt)}
             *   3-4: ImplicitCast[type=int, index=0]
             *   5-7: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private BitCountNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.BitCountNode.bitCount(int)] || SpecializationActive[IntBuiltins.BitCountNode.bitCount(long)] || SpecializationActive[IntBuiltins.BitCountNode.bitCount(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BitCountNode.bitCount(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arguments0Value_)) {
                        int arguments0Value__ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arguments0Value_);
                        return BitCountNode.bitCount(arguments0Value__);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BitCountNode.bitCount(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_)) {
                        long arguments0Value__ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_);
                        return BitCountNode.bitCount(arguments0Value__);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BitCountNode.bitCount(PInt)] */ && arguments0Value_ instanceof PInt) {
                        PInt arguments0Value__ = (PInt) arguments0Value_;
                        return BitCountNode.bitCount(arguments0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private int executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arguments0Value)) != 0) {
                        int arguments0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arguments0Value);
                        state_0 = (state_0 | (intCast0 << 3) /* set-int ImplicitCast[type=int, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.BitCountNode.bitCount(int)] */;
                        this.state_0_ = state_0;
                        return BitCountNode.bitCount(arguments0Value_);
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arguments0Value)) != 0) {
                        long arguments0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arguments0Value);
                        state_0 = (state_0 | (longCast0 << 5) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.BitCountNode.bitCount(long)] */;
                        this.state_0_ = state_0;
                        return BitCountNode.bitCount(arguments0Value_);
                    }
                }
                if (arguments0Value instanceof PInt) {
                    PInt arguments0Value_ = (PInt) arguments0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.BitCountNode.bitCount(PInt)] */;
                    this.state_0_ = state_0;
                    return BitCountNode.bitCount(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(BitLengthNode.class)
    public static final class BitLengthNodeFactory implements NodeFactory<BitLengthNode> {

        private static final BitLengthNodeFactory BIT_LENGTH_NODE_FACTORY_INSTANCE = new BitLengthNodeFactory();

        private BitLengthNodeFactory() {
        }

        @Override
        public Class<BitLengthNode> getNodeClass() {
            return BitLengthNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public BitLengthNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<BitLengthNode> getInstance() {
            return BIT_LENGTH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BitLengthNode create() {
            return new BitLengthNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BitLengthNode#bitLength(int)}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link BitLengthNode#bitLength(long)}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link BitLengthNode#bitLength(PInt)}
         *     Activation probability: 0.18333
         *     With/without class size: 6/0 bytes
         * </pre> */
        @GeneratedBy(BitLengthNode.class)
        @SuppressWarnings("javadoc")
        public static final class BitLengthNodeGen extends BitLengthNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BitLengthNode#bitLength(int)}
             *   1: SpecializationActive {@link BitLengthNode#bitLength(long)}
             *   2: SpecializationActive {@link BitLengthNode#bitLength(PInt)}
             *   3-4: ImplicitCast[type=int, index=0]
             *   5-7: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private BitLengthNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(int)] || SpecializationActive[IntBuiltins.BitLengthNode.bitLength(long)] || SpecializationActive[IntBuiltins.BitLengthNode.bitLength(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            @Override
            public int execute(Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(int)] || SpecializationActive[IntBuiltins.BitLengthNode.bitLength(long)] || SpecializationActive[IntBuiltins.BitLengthNode.bitLength(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.BitLengthNode.bitLength(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        state_0 = (state_0 | (intCast0 << 3) /* set-int ImplicitCast[type=int, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.BitLengthNode.bitLength(int)] */;
                        this.state_0_ = state_0;
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 = (state_0 | (longCast0 << 5) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.BitLengthNode.bitLength(long)] */;
                        this.state_0_ = state_0;
                        return BitLengthNode.bitLength(arg0Value_);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.BitLengthNode.bitLength(PInt)] */;
                    this.state_0_ = state_0;
                    return BitLengthNode.bitLength(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(IsIntegerNode.class)
    static final class IsIntegerNodeFactory implements NodeFactory<IsIntegerNode> {

        private static final IsIntegerNodeFactory IS_INTEGER_NODE_FACTORY_INSTANCE = new IsIntegerNodeFactory();

        private IsIntegerNodeFactory() {
        }

        @Override
        public Class<IsIntegerNode> getNodeClass() {
            return IsIntegerNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IsIntegerNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<IsIntegerNode> getInstance() {
            return IS_INTEGER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IsIntegerNode create() {
            return new IsIntegerNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IsIntegerNode#doLong}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link IsIntegerNode#doPInt}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(IsIntegerNode.class)
        @SuppressWarnings("javadoc")
        static final class IsIntegerNodeGen extends IsIntegerNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsIntegerNode#doLong}
             *   1: SpecializationActive {@link IsIntegerNode#doPInt}
             *   2-4: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private IsIntegerNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[IntBuiltins.IsIntegerNode.doLong(long)] || SpecializationActive[IntBuiltins.IsIntegerNode.doPInt(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.IsIntegerNode.doLong(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return IsIntegerNode.doLong(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.IsIntegerNode.doPInt(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return IsIntegerNode.doPInt(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 = (state_0 | (longCast0 << 2) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.IsIntegerNode.doLong(long)] */;
                        this.state_0_ = state_0;
                        return IsIntegerNode.doLong(arg0Value_);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.IsIntegerNode.doPInt(PInt)] */;
                    this.state_0_ = state_0;
                    return IsIntegerNode.doPInt(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(RealNode.class)
    static final class RealNodeFactory implements NodeFactory<RealNode> {

        private static final RealNodeFactory REAL_NODE_FACTORY_INSTANCE = new RealNodeFactory();

        private RealNodeFactory() {
        }

        @Override
        public Class<RealNode> getNodeClass() {
            return RealNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public RealNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RealNode> getInstance() {
            return REAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RealNode create() {
            return new RealNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNode#doCopy}
         *     Activation probability: 1.00000
         *     With/without class size: 24/2 bytes
         * </pre> */
        @GeneratedBy(RealNode.class)
        @SuppressWarnings("javadoc")
        static final class RealNodeGen extends RealNode {

            private static final StateField STATE_0_RealNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNode#doCopy}
             *   Parameter: {@link PyLongCopy} copy
             *   Inline method: {@link PyLongCopyNodeGen#inline}</pre> */
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineTarget.create(PyLongCopy.class, STATE_0_RealNode_UPDATER.subUpdater(0, 10)));

            /**
             * State Info: <pre>
             *   0-9: InlinedCache
             *        Specialization: {@link IntNode#doCopy}
             *        Parameter: {@link PyLongCopy} copy
             *        Inline method: {@link PyLongCopyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private RealNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
                }
            }

        }
    }
    @GeneratedBy(ImagNode.class)
    static final class ImagNodeFactory implements NodeFactory<ImagNode> {

        private static final ImagNodeFactory IMAG_NODE_FACTORY_INSTANCE = new ImagNodeFactory();

        private ImagNodeFactory() {
        }

        @Override
        public Class<ImagNode> getNodeClass() {
            return ImagNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ImagNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ImagNode> getInstance() {
            return IMAG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ImagNode create(ReadArgumentNode[] arguments) {
            return new ImagNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ImagNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(ImagNode.class)
        @SuppressWarnings("javadoc")
        static final class ImagNodeGen extends ImagNode {

            @Child private ReadArgumentNode arguments0_;

            private ImagNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return ImagNode.get(arguments0Value_);
            }

        }
    }
    @GeneratedBy(NumeratorNode.class)
    static final class NumeratorNodeFactory implements NodeFactory<NumeratorNode> {

        private static final NumeratorNodeFactory NUMERATOR_NODE_FACTORY_INSTANCE = new NumeratorNodeFactory();

        private NumeratorNodeFactory() {
        }

        @Override
        public Class<NumeratorNode> getNodeClass() {
            return NumeratorNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NumeratorNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NumeratorNode> getInstance() {
            return NUMERATOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NumeratorNode create() {
            return new NumeratorNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNode#doCopy}
         *     Activation probability: 1.00000
         *     With/without class size: 24/2 bytes
         * </pre> */
        @GeneratedBy(NumeratorNode.class)
        @SuppressWarnings("javadoc")
        static final class NumeratorNodeGen extends NumeratorNode {

            private static final StateField STATE_0_NumeratorNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNode#doCopy}
             *   Parameter: {@link PyLongCopy} copy
             *   Inline method: {@link PyLongCopyNodeGen#inline}</pre> */
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineTarget.create(PyLongCopy.class, STATE_0_NumeratorNode_UPDATER.subUpdater(0, 10)));

            /**
             * State Info: <pre>
             *   0-9: InlinedCache
             *        Specialization: {@link IntNode#doCopy}
             *        Parameter: {@link PyLongCopy} copy
             *        Inline method: {@link PyLongCopyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private NumeratorNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
                }
            }

        }
    }
    @GeneratedBy(ConjugateNode.class)
    static final class ConjugateNodeFactory implements NodeFactory<ConjugateNode> {

        private static final ConjugateNodeFactory CONJUGATE_NODE_FACTORY_INSTANCE = new ConjugateNodeFactory();

        private ConjugateNodeFactory() {
        }

        @Override
        public Class<ConjugateNode> getNodeClass() {
            return ConjugateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ConjugateNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ConjugateNode> getInstance() {
            return CONJUGATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ConjugateNode create() {
            return new ConjugateNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNode#doCopy}
         *     Activation probability: 1.00000
         *     With/without class size: 24/2 bytes
         * </pre> */
        @GeneratedBy(ConjugateNode.class)
        @SuppressWarnings("javadoc")
        static final class ConjugateNodeGen extends ConjugateNode {

            private static final StateField STATE_0_ConjugateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNode#doCopy}
             *   Parameter: {@link PyLongCopy} copy
             *   Inline method: {@link PyLongCopyNodeGen#inline}</pre> */
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineTarget.create(PyLongCopy.class, STATE_0_ConjugateNode_UPDATER.subUpdater(0, 10)));

            /**
             * State Info: <pre>
             *   0-9: InlinedCache
             *        Specialization: {@link IntNode#doCopy}
             *        Parameter: {@link PyLongCopy} copy
             *        Inline method: {@link PyLongCopyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private ConjugateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
                }
            }

        }
    }
    @GeneratedBy(DenominatorNode.class)
    static final class DenominatorNodeFactory implements NodeFactory<DenominatorNode> {

        private static final DenominatorNodeFactory DENOMINATOR_NODE_FACTORY_INSTANCE = new DenominatorNodeFactory();

        private DenominatorNodeFactory() {
        }

        @Override
        public Class<DenominatorNode> getNodeClass() {
            return DenominatorNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public DenominatorNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<DenominatorNode> getInstance() {
            return DENOMINATOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DenominatorNode create(ReadArgumentNode[] arguments) {
            return new DenominatorNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DenominatorNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(DenominatorNode.class)
        @SuppressWarnings("javadoc")
        static final class DenominatorNodeGen extends DenominatorNode {

            @Child private ReadArgumentNode arguments0_;

            private DenominatorNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return DenominatorNode.get(arguments0Value_);
            }

        }
    }
    @GeneratedBy(AsIntegerRatioNode.class)
    static final class AsIntegerRatioNodeFactory implements NodeFactory<AsIntegerRatioNode> {

        private static final AsIntegerRatioNodeFactory AS_INTEGER_RATIO_NODE_FACTORY_INSTANCE = new AsIntegerRatioNodeFactory();

        private AsIntegerRatioNodeFactory() {
        }

        @Override
        public Class<AsIntegerRatioNode> getNodeClass() {
            return AsIntegerRatioNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public AsIntegerRatioNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<AsIntegerRatioNode> getInstance() {
            return AS_INTEGER_RATIO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AsIntegerRatioNode create(ReadArgumentNode[] arguments) {
            return new AsIntegerRatioNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AsIntegerRatioNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(AsIntegerRatioNode.class)
        @SuppressWarnings("javadoc")
        static final class AsIntegerRatioNodeGen extends AsIntegerRatioNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AsIntegerRatioNode#get}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AsIntegerRatioNode#get}
             *   Parameter: {@link IntNode} intNode</pre> */
            @Child private IntNode intNode_;

            private AsIntegerRatioNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[IntBuiltins.AsIntegerRatioNode.get(VirtualFrame, Object, IntNode, PythonLanguage)] */) {
                    {
                        IntNode intNode__ = this.intNode_;
                        if (intNode__ != null) {
                            PythonLanguage language__ = (PythonLanguage.get(this));
                            return AsIntegerRatioNode.get(frameValue, arguments0Value_, intNode__, language__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value) {
                int state_0 = this.state_0_;
                {
                    PythonLanguage language__ = null;
                    IntNode intNode__ = this.insert((IntNodeFactory.create()));
                    Objects.requireNonNull(intNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.intNode_ = intNode__;
                    language__ = (PythonLanguage.get(this));
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.AsIntegerRatioNode.get(VirtualFrame, Object, IntNode, PythonLanguage)] */;
                    this.state_0_ = state_0;
                    return AsIntegerRatioNode.get(frameValue, arguments0Value, intNode__, language__);
                }
            }

        }
    }
    @GeneratedBy(TruncNode.class)
    static final class TruncNodeFactory implements NodeFactory<TruncNode> {

        private static final TruncNodeFactory TRUNC_NODE_FACTORY_INSTANCE = new TruncNodeFactory();

        private TruncNodeFactory() {
        }

        @Override
        public Class<TruncNode> getNodeClass() {
            return TruncNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TruncNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TruncNode> getInstance() {
            return TRUNC_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TruncNode create() {
            return new TruncNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNode#doCopy}
         *     Activation probability: 1.00000
         *     With/without class size: 24/2 bytes
         * </pre> */
        @GeneratedBy(TruncNode.class)
        @SuppressWarnings("javadoc")
        static final class TruncNodeGen extends TruncNode {

            private static final StateField STATE_0_TruncNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNode#doCopy}
             *   Parameter: {@link PyLongCopy} copy
             *   Inline method: {@link PyLongCopyNodeGen#inline}</pre> */
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineTarget.create(PyLongCopy.class, STATE_0_TruncNode_UPDATER.subUpdater(0, 10)));

            /**
             * State Info: <pre>
             *   0-9: InlinedCache
             *        Specialization: {@link IntNode#doCopy}
             *        Parameter: {@link PyLongCopy} copy
             *        Inline method: {@link PyLongCopyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private TruncNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
                }
            }

        }
    }
    @GeneratedBy(IntNode.class)
    static final class IntNodeFactory implements NodeFactory<IntNode> {

        private static final IntNodeFactory INT_NODE_FACTORY_INSTANCE = new IntNodeFactory();

        private IntNodeFactory() {
        }

        @Override
        public Class<IntNode> getNodeClass() {
            return IntNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IntNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<IntNode> getInstance() {
            return INT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntNode create() {
            return new IntNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IntNode#doCopy}
         *     Activation probability: 1.00000
         *     With/without class size: 24/2 bytes
         * </pre> */
        @GeneratedBy(IntNode.class)
        @SuppressWarnings("javadoc")
        static final class IntNodeGen extends IntNode {

            private static final StateField STATE_0_IntNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IntNode#doCopy}
             *   Parameter: {@link PyLongCopy} copy
             *   Inline method: {@link PyLongCopyNodeGen#inline}</pre> */
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineTarget.create(PyLongCopy.class, STATE_0_IntNode_UPDATER.subUpdater(0, 10)));

            /**
             * State Info: <pre>
             *   0-9: InlinedCache
             *        Specialization: {@link IntNode#doCopy}
             *        Parameter: {@link PyLongCopy} copy
             *        Inline method: {@link PyLongCopyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private IntNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
                }
            }

        }
    }
    @GeneratedBy(GetNewArgsNode.class)
    static final class GetNewArgsNodeFactory implements NodeFactory<GetNewArgsNode> {

        private static final GetNewArgsNodeFactory GET_NEW_ARGS_NODE_FACTORY_INSTANCE = new GetNewArgsNodeFactory();

        private GetNewArgsNodeFactory() {
        }

        @Override
        public Class<GetNewArgsNode> getNodeClass() {
            return GetNewArgsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetNewArgsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetNewArgsNode> getInstance() {
            return GET_NEW_ARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNewArgsNode create() {
            return new GetNewArgsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNewArgsNode#doI}
         *     Activation probability: 1.00000
         *     With/without class size: 24/2 bytes
         * </pre> */
        @GeneratedBy(GetNewArgsNode.class)
        @SuppressWarnings("javadoc")
        static final class GetNewArgsNodeGen extends GetNewArgsNode {

            private static final StateField STATE_0_GetNewArgsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewArgsNode#doI}
             *   Parameter: {@link PyLongCopy} copy
             *   Inline method: {@link PyLongCopyNodeGen#inline}</pre> */
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineTarget.create(PyLongCopy.class, STATE_0_GetNewArgsNode_UPDATER.subUpdater(0, 10)));

            /**
             * State Info: <pre>
             *   0-9: InlinedCache
             *        Specialization: {@link GetNewArgsNode#doI}
             *        Parameter: {@link PyLongCopy} copy
             *        Inline method: {@link PyLongCopyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private GetNewArgsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    PythonLanguage language__ = (PythonLanguage.get(this));
                    return GetNewArgsNode.doI(arg0Value, inliningTarget__, language__, INLINED_COPY_);
                }
            }

        }
    }
    @GeneratedBy(FloatNode.class)
    public static final class FloatNodeFactory implements NodeFactory<FloatNode> {

        private static final FloatNodeFactory FLOAT_NODE_FACTORY_INSTANCE = new FloatNodeFactory();

        private FloatNodeFactory() {
        }

        @Override
        public Class<FloatNode> getNodeClass() {
            return FloatNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FloatNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<FloatNode> getInstance() {
            return FLOAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FloatNode create() {
            return new FloatNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FloatNode#doBoolean}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link FloatNode#doInt}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link FloatNode#doLong}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link FloatNode#doPInt}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link FloatNode#doGeneric}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre> */
        @GeneratedBy(FloatNode.class)
        @SuppressWarnings("javadoc")
        public static final class FloatNodeGen extends FloatNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FloatNode#doBoolean}
             *   1: SpecializationActive {@link FloatNode#doInt}
             *   2: SpecializationActive {@link FloatNode#doLong}
             *   3: SpecializationActive {@link FloatNode#doPInt}
             *   4: SpecializationActive {@link FloatNode#doGeneric}
             *   5-6: ImplicitCast[type=int, index=0]
             *   7-9: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private FloatNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doLong(long)] */
                 && (state_0 & 0b1110000000) == 0b1110000000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    return false;
                }
                if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doPInt(PInt)] */) && arg0Value instanceof PInt) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doBoolean(boolean)] || SpecializationActive[IntBuiltins.FloatNode.doInt(int)] || SpecializationActive[IntBuiltins.FloatNode.doLong(long)] || SpecializationActive[IntBuiltins.FloatNode.doPInt(PInt)] || SpecializationActive[IntBuiltins.FloatNode.doGeneric(Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doBoolean(boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        return FloatNode.doBoolean(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doInt(int)] */ && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=0] */, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=0] */, arg0Value);
                        return FloatNode.doInt(arg0Value_);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doLong(long)] */ && PythonIntegerTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        return FloatNode.doLong(arg0Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doPInt(PInt)] */ && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        return doPInt(arg0Value_);
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IntBuiltins.FloatNode.doGeneric(Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value)) {
                            return FloatNode.doGeneric(arg0Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[IntBuiltins.FloatNode.doBoolean(boolean)] */;
                    this.state_0_ = state_0;
                    return FloatNode.doBoolean(arg0Value_);
                }
                {
                    int intCast0;
                    if ((intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        state_0 = (state_0 | (intCast0 << 5) /* set-int ImplicitCast[type=int, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[IntBuiltins.FloatNode.doInt(int)] */;
                        this.state_0_ = state_0;
                        return FloatNode.doInt(arg0Value_);
                    }
                }
                {
                    int longCast0;
                    if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 = (state_0 | (longCast0 << 7) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[IntBuiltins.FloatNode.doLong(long)] */;
                        this.state_0_ = state_0;
                        return FloatNode.doLong(arg0Value_);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt) arg0Value;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[IntBuiltins.FloatNode.doPInt(PInt)] */;
                    this.state_0_ = state_0;
                    return doPInt(arg0Value_);
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[IntBuiltins.FloatNode.doGeneric(Object)] */;
                this.state_0_ = state_0;
                return FloatNode.doGeneric(arg0Value);
            }

        }
    }
}
