// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.contextvars.ContextIteratorBuiltins.Iter;
import com.oracle.graal.python.builtins.objects.contextvars.ContextIteratorBuiltins.Next;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@GeneratedBy(ContextIteratorBuiltins.class)
@SuppressWarnings("javadoc")
public final class ContextIteratorBuiltinsFactory {

    public static List<NodeFactory<? extends PythonUnaryBuiltinNode>> getFactories() {
        return List.of(IterFactory.getInstance(), NextFactory.getInstance());
    }

    @GeneratedBy(Iter.class)
    public static final class IterFactory implements NodeFactory<Iter> {

        private static final IterFactory ITER_FACTORY_INSTANCE = new IterFactory();

        private IterFactory() {
        }

        @Override
        public Class<Iter> getNodeClass() {
            return Iter.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public Iter createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<Iter> getInstance() {
            return ITER_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static Iter create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link Iter#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(Iter.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends Iter {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Iter#iter}
             * </pre> */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ContextIteratorBuiltins.Iter.iter(PContextIterator)] */ && arg0Value instanceof PContextIterator) {
                    PContextIterator arg0Value_ = (PContextIterator) arg0Value;
                    return Iter.iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PContextIterator) {
                    PContextIterator arg0Value_ = (PContextIterator) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ContextIteratorBuiltins.Iter.iter(PContextIterator)] */;
                    this.state_0_ = state_0;
                    return Iter.iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(Next.class)
    public static final class NextFactory implements NodeFactory<Next> {

        private static final NextFactory NEXT_FACTORY_INSTANCE = new NextFactory();

        private NextFactory() {
        }

        @Override
        public Class<Next> getNodeClass() {
            return Next.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public Next createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<Next> getInstance() {
            return NEXT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static Next create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link Next#next}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(Next.class)
        @SuppressWarnings("javadoc")
        public static final class NextNodeGen extends Next {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Next#next}
             * </pre> */
            @CompilationFinal private int state_0_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ContextIteratorBuiltins.Next.next(PContextIterator, PythonLanguage)] */ && arg0Value instanceof PContextIterator) {
                    PContextIterator arg0Value_ = (PContextIterator) arg0Value;
                    {
                        PythonLanguage language__ = (PythonLanguage.get(this));
                        return Next.next(arg0Value_, language__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    PythonLanguage language__ = null;
                    if (arg0Value instanceof PContextIterator) {
                        PContextIterator arg0Value_ = (PContextIterator) arg0Value;
                        language__ = (PythonLanguage.get(this));
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ContextIteratorBuiltins.Next.next(PContextIterator, PythonLanguage)] */;
                        this.state_0_ = state_0;
                        return Next.next(arg0Value_, language__);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
}
