// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.NextNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(CoroutineWrapperBuiltins.class)
@SuppressWarnings("javadoc")
public final class CoroutineWrapperBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(IterNodeFactory.getInstance(), NextNodeFactory.getInstance(), SendNodeFactory.getInstance(), ThrowNodeFactory.getInstance(), CloseNodeFactory.getInstance());
    }

    @GeneratedBy(IterNode.class)
    public static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#getIter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#getIter}
             * </pre> */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CoroutineWrapperBuiltins.IterNode.getIter(PCoroutineWrapper)] */ && arg0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arg0Value_ = (PCoroutineWrapper) arg0Value;
                    return getIter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arg0Value_ = (PCoroutineWrapper) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CoroutineWrapperBuiltins.IterNode.getIter(PCoroutineWrapper)] */;
                    this.state_0_ = state_0;
                    return getIter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(NextNode.class)
    public static final class NextNodeFactory implements NodeFactory<NextNode> {

        private static final NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        @Override
        public Class<NextNode> getNodeClass() {
            return NextNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NextNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NextNode create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NextNode#doNext}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(NextNode.class)
        @SuppressWarnings("javadoc")
        public static final class NextNodeGen extends NextNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NextNode#doNext}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NextNode#doNext}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode} send</pre> */
            @Child private com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode send_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CoroutineWrapperBuiltins.NextNode.doNext(VirtualFrame, PCoroutineWrapper, SendNode)] */ && arg0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arg0Value_ = (PCoroutineWrapper) arg0Value;
                    {
                        com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode send__ = this.send_;
                        if (send__ != null) {
                            return doNext(frameValue, arg0Value_, send__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arg0Value_ = (PCoroutineWrapper) arg0Value;
                    com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode send__ = this.insert((com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltinsFactory.SendNodeFactory.create()));
                    Objects.requireNonNull(send__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.send_ = send__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CoroutineWrapperBuiltins.NextNode.doNext(VirtualFrame, PCoroutineWrapper, SendNode)] */;
                    this.state_0_ = state_0;
                    return doNext(frameValue, arg0Value_, send__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value);
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode.class)
    public static final class SendNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode> {

        private static final com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltinsFactory.SendNodeFactory SEND_NODE_FACTORY_INSTANCE = new SendNodeFactory();

        private SendNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode> getInstance() {
            return SEND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode create() {
            return new SendNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode#doSend}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode.class)
        @SuppressWarnings("javadoc")
        public static final class SendNodeGen extends com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode#doSend}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.SendNode#doSend}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode} send</pre> */
            @Child private com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode send_;

            private SendNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CoroutineWrapperBuiltins.SendNode.doSend(VirtualFrame, PCoroutineWrapper, Object, SendNode)] */ && arg0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arg0Value_ = (PCoroutineWrapper) arg0Value;
                    {
                        com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode send__ = this.send_;
                        if (send__ != null) {
                            return doSend(frameValue, arg0Value_, arg1Value, send__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arg0Value_ = (PCoroutineWrapper) arg0Value;
                    com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.SendNode send__ = this.insert((com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltinsFactory.SendNodeFactory.create()));
                    Objects.requireNonNull(send__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.send_ = send__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CoroutineWrapperBuiltins.SendNode.doSend(VirtualFrame, PCoroutineWrapper, Object, SendNode)] */;
                    this.state_0_ = state_0;
                    return doSend(frameValue, arg0Value_, arg1Value, send__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode.class)
    public static final class ThrowNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode> {

        private static final com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltinsFactory.ThrowNodeFactory THROW_NODE_FACTORY_INSTANCE = new ThrowNodeFactory();

        private ThrowNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode> getInstance() {
            return THROW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode create(ReadArgumentNode[] arguments) {
            return new ThrowNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode#doThrow}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode.class)
        @SuppressWarnings("javadoc")
        public static final class ThrowNodeGen extends com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode#doThrow}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.ThrowNode#doThrow}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.ThrowNode} throwNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.ThrowNode throwNode_;

            private ThrowNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[CoroutineWrapperBuiltins.ThrowNode.doThrow(VirtualFrame, PCoroutineWrapper, Object, Object, Object, ThrowNode)] */ && arguments0Value_ instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arguments0Value__ = (PCoroutineWrapper) arguments0Value_;
                    {
                        com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.ThrowNode throwNode__ = this.throwNode_;
                        if (throwNode__ != null) {
                            return doThrow(frameValue, arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, throwNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arguments0Value_ = (PCoroutineWrapper) arguments0Value;
                    com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.ThrowNode throwNode__ = this.insert((com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltinsFactory.ThrowNodeFactory.create()));
                    Objects.requireNonNull(throwNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.throwNode_ = throwNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CoroutineWrapperBuiltins.ThrowNode.doThrow(VirtualFrame, PCoroutineWrapper, Object, Object, Object, ThrowNode)] */;
                    this.state_0_ = state_0;
                    return doThrow(frameValue, arguments0Value_, arguments1Value, arguments2Value, arguments3Value, throwNode__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode.class)
    public static final class CloseNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode> {

        private static final com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltinsFactory.CloseNodeFactory CLOSE_NODE_FACTORY_INSTANCE = new CloseNodeFactory();

        private CloseNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode> getInstance() {
            return CLOSE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode create(ReadArgumentNode[] arguments) {
            return new CloseNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode#doThrow}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode.class)
        @SuppressWarnings("javadoc")
        public static final class CloseNodeGen extends com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode#doThrow}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins.CloseNode#doThrow}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.CloseNode} closeNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.CloseNode closeNode_;

            private CloseNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[CoroutineWrapperBuiltins.CloseNode.doThrow(VirtualFrame, PCoroutineWrapper, CloseNode)] */ && arguments0Value_ instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arguments0Value__ = (PCoroutineWrapper) arguments0Value_;
                    {
                        com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.CloseNode closeNode__ = this.closeNode_;
                        if (closeNode__ != null) {
                            return doThrow(frameValue, arguments0Value__, closeNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PCoroutineWrapper) {
                    PCoroutineWrapper arguments0Value_ = (PCoroutineWrapper) arguments0Value;
                    com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins.CloseNode closeNode__ = this.insert((com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltinsFactory.CloseNodeFactory.create()));
                    Objects.requireNonNull(closeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.closeNode_ = closeNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CoroutineWrapperBuiltins.CloseNode.doThrow(VirtualFrame, PCoroutineWrapper, CloseNode)] */;
                    this.state_0_ = state_0;
                    return doThrow(frameValue, arguments0Value_, closeNode__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
}
