// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects;

import com.oracle.graal.python.builtins.objects.NoneBuiltins.BoolNode;
import com.oracle.graal.python.builtins.objects.NoneBuiltins.NoneTypeNode;
import com.oracle.graal.python.builtins.objects.NoneBuiltins.ReprNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.util.List;

@GeneratedBy(NoneBuiltins.class)
@SuppressWarnings("javadoc")
public final class NoneBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(NoneTypeNodeFactory.getInstance(), BoolNodeFactory.getInstance(), ReprNodeFactory.getInstance());
    }

    @GeneratedBy(NoneTypeNode.class)
    public static final class NoneTypeNodeFactory implements NodeFactory<NoneTypeNode> {

        private static final NoneTypeNodeFactory NONE_TYPE_NODE_FACTORY_INSTANCE = new NoneTypeNodeFactory();

        private NoneTypeNodeFactory() {
        }

        @Override
        public Class<NoneTypeNode> getNodeClass() {
            return NoneTypeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public NoneTypeNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<NoneTypeNode> getInstance() {
            return NONE_TYPE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NoneTypeNode create(ReadArgumentNode[] arguments) {
            return new NoneTypeNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NoneTypeNode#module}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(NoneTypeNode.class)
        @SuppressWarnings("javadoc")
        public static final class NoneTypeNodeGen extends NoneTypeNode {

            @Child private ReadArgumentNode arguments0_;

            private NoneTypeNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return NoneTypeNode.module(arguments0Value_);
            }

        }
    }
    @GeneratedBy(BoolNode.class)
    static final class BoolNodeFactory implements NodeFactory<BoolNode> {

        private static final BoolNodeFactory BOOL_NODE_FACTORY_INSTANCE = new BoolNodeFactory();

        private BoolNodeFactory() {
        }

        @Override
        public Class<BoolNode> getNodeClass() {
            return BoolNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public BoolNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public BoolNode getUncachedInstance() {
            return BoolNodeGen.UNCACHED;
        }

        static NodeFactory<BoolNode> getInstance() {
            return BOOL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolNode create() {
            return new BoolNodeGen();
        }

        @NeverDefault
        public static BoolNode getUncached() {
            return BoolNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BoolNode#doNone}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(BoolNode.class)
        @SuppressWarnings("javadoc")
        static final class BoolNodeGen extends BoolNode {

            private static final Uncached UNCACHED = new Uncached();

            private BoolNodeGen() {
            }

            @Override
            public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                return BoolNode.doNone(arg0Value);
            }

            @GeneratedBy(BoolNode.class)
            @DenyReplace
            private static final class Uncached extends BoolNode implements UnadoptableNode {

                @Override
                public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return BoolNode.doNone(arg0Value);
                }

            }
        }
    }
    @GeneratedBy(ReprNode.class)
    static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#doNone}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        static final class ReprNodeGen extends ReprNode {

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return ReprNode.doNone(arg0Value);
            }

        }
    }
}
