/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMapFactory;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.object.GetForeignObjectClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;

@GenerateCached
@GenerateUncached
@GenerateInline(value=false)
public abstract class GetRegisteredClassNode
extends PNodeWithContext {
    public abstract Object execute(Object var1);

    @Specialization(assumptions={"getLanguage().noInteropTypeRegisteredAssumption"})
    static Object noRegisteredClass(Object foreignObject, @Cached.Shared @Cached GetForeignObjectClassNode getForeignObjectClassNode) {
        return getForeignObjectClassNode.execute(foreignObject);
    }

    @Specialization(guards={"objectLibrary.isMetaObject(foreignObject) || !objectLibrary.hasMetaObject(foreignObject)"})
    static Object getClassLookup(Object foreignObject, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") @Cached.Exclusive InteropLibrary objectLibrary, @Cached.Shared @Cached GetForeignObjectClassNode getForeignObjectClassNode) {
        return getForeignObjectClassNode.execute(foreignObject);
    }

    @Specialization(guards={"isSingleContext()", "!objectLibrary.isMetaObject(foreignObject)", "objectLibrary.hasMetaObject(foreignObject)", "metaObjectLibrary.isIdentical(metaObject, cachedMetaObject, metaObjectLibrary)"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"getContext().interopTypeRegistryCacheValidAssumption.getAssumption()"})
    static Object getCachedClassLookup(Object foreignObject, @CachedLibrary(value="foreignObject") InteropLibrary objectLibrary, @Bind(value="getMetaObject(objectLibrary, foreignObject)") Object metaObject, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") @Cached.Exclusive InteropLibrary metaObjectLibrary, @Cached(value="metaObject") Object cachedMetaObject, @Cached(value="lookupUncached($node, foreignObject, cachedMetaObject)") Object pythonClass) {
        return pythonClass;
    }

    static Object getMetaObject(InteropLibrary objectLibrary, Object foreignObject) {
        try {
            return objectLibrary.getMetaObject(foreignObject);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static Object lookupUncached(Node inliningTarget, Object foreignObject, Object metaObject) {
        return GetRegisteredClassNode.lookup(inliningTarget, InlinedConditionProfile.getUncached(), foreignObject, metaObject, InteropLibrary.getUncached(), ObjectHashMapFactory.GetNodeGen.getUncached());
    }

    @Specialization(replaces={"getCachedClassLookup"}, guards={"!objectLibrary.isMetaObject(foreignObject)", "objectLibrary.hasMetaObject(foreignObject)"})
    static Object getFullLookupNode(Object foreignObject, @Bind(value="$node") Node node, @Cached InlinedConditionProfile inlinedConditionProfile, @Cached ObjectHashMap.GetNode getNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") @Cached.Exclusive InteropLibrary objectLibrary, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") @Cached.Exclusive InteropLibrary classLibrary) {
        return GetRegisteredClassNode.lookup(node, inlinedConditionProfile, foreignObject, GetRegisteredClassNode.getMetaObject(objectLibrary, foreignObject), classLibrary, getNode);
    }

    static Object lookup(Node inliningTarget, InlinedConditionProfile builtClassFoundProfile, Object foreignObject, Object metaObject, InteropLibrary metaObjectLibrary, ObjectHashMap.GetNode getNode) {
        try {
            Object possiblePythonClass = getNode.execute(null, inliningTarget, PythonContext.get((Node)inliningTarget).interopGeneratedClassCache, metaObject, metaObjectLibrary.identityHashCode(metaObject));
            return builtClassFoundProfile.profile(inliningTarget, possiblePythonClass != null) ? possiblePythonClass : GetRegisteredClassNode.lookupWithInheritance(inliningTarget, foreignObject, metaObject);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static PythonClass buildClassAndRegister(Object foreignObject, Object metaObject, Object[] bases, Node inliningTarget, ObjectHashMap.PutNode putNode) throws UnsupportedMessageException {
        PythonClass pythonClass;
        String languageName;
        InteropLibrary interopLibrary = InteropLibrary.getUncached();
        PythonContext context = PythonContext.get(inliningTarget);
        try {
            languageName = context.getEnv().getLanguageInfo(interopLibrary.getLanguage(metaObject)).getName();
        }
        catch (UnsupportedMessageException e) {
            languageName = "Foreign";
        }
        languageName = languageName.equals("Host") ? "Java" : languageName;
        TruffleString className = PythonUtils.toTruffleStringUncached(String.format("%s_%s_generated", languageName, interopLibrary.getMetaQualifiedName(metaObject)));
        Object[] basesWithForeign = (PythonAbstractClass[])Arrays.copyOf(bases, bases.length + 1, PythonAbstractClass[].class);
        basesWithForeign[basesWithForeign.length - 1] = GetForeignObjectClassNode.getUncached().execute(foreignObject);
        try {
            pythonClass = context.factory().createPythonClassAndFixupSlots(PythonLanguage.get(inliningTarget), (Object)PythonBuiltinClassType.PythonClass, className, bases[0], (PythonAbstractClass[])basesWithForeign);
        }
        catch (PException e) {
            throw PRaiseNode.getUncached().raiseWithCause(PythonBuiltinClassType.TypeError, e, ErrorMessages.INTEROP_CLASS_CREATION_NOT_POSSIBLE, interopLibrary.getMetaQualifiedName(metaObject), Arrays.toString(basesWithForeign));
        }
        PythonModule module = context.lookupBuiltinModule(BuiltinNames.T_POLYGLOT);
        pythonClass.setAttribute(SpecialAttributeNames.T___MODULE__, module.getAttribute(SpecialAttributeNames.T___NAME__));
        putNode.put(null, inliningTarget, context.interopGeneratedClassCache, metaObject, InteropLibrary.getUncached().identityHashCode(metaObject), pythonClass);
        return pythonClass;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object lookupWithInheritance(Node inliningTarget, Object foreignObject, Object metaObject) {
        InteropLibrary interopLibrary = InteropLibrary.getUncached();
        try {
            ObjectHashMap registry = PythonContext.get((Node)inliningTarget).interopTypeRegistry;
            LinkedHashSet<Object> foundClasses = new LinkedHashSet<Object>();
            ObjectHashMap.GetNode getNode = ObjectHashMapFactory.GetNodeGen.getUncached();
            Object[] possiblePythonClasses = (Object[])getNode.execute(null, inliningTarget, registry, metaObject, interopLibrary.identityHashCode(metaObject));
            if (possiblePythonClasses != null) {
                Collections.addAll(foundClasses, possiblePythonClasses);
            }
            GetRegisteredClassNode.searchAllParentClassesBfs(new Object[]{metaObject}, foundClasses, registry, getNode, inliningTarget);
            return foundClasses.isEmpty() ? GetForeignObjectClassNode.getUncached().execute(foreignObject) : GetRegisteredClassNode.buildClassAndRegister(foreignObject, metaObject, foundClasses.toArray(), inliningTarget, ObjectHashMapFactory.PutNodeGen.getUncached());
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static void searchAllParentClassesBfs(Object[] children, LinkedHashSet<Object> foundClasses, ObjectHashMap registry, ObjectHashMap.GetNode getNode, Node inliningTarget) throws UnsupportedMessageException, InvalidArrayIndexException {
        if (children == null || children.length == 0) {
            return;
        }
        ArrayBuilder<Object> grandChildren = new ArrayBuilder<Object>();
        InteropLibrary interopLibrary = InteropLibrary.getUncached();
        for (Object child : children) {
            if (!interopLibrary.hasMetaParents(child)) continue;
            Object parents = interopLibrary.getMetaParents(child);
            long size = interopLibrary.getArraySize(parents);
            for (long i = 0L; i < size; ++i) {
                if (!interopLibrary.isArrayElementReadable(parents, i)) continue;
                Object metaObject = interopLibrary.readArrayElement(parents, i);
                Object[] possibleClasses = (Object[])getNode.execute(null, inliningTarget, registry, metaObject, interopLibrary.identityHashCode(metaObject));
                if (possibleClasses != null) {
                    Collections.addAll(foundClasses, possibleClasses);
                }
                grandChildren.add(metaObject);
            }
        }
        GetRegisteredClassNode.searchAllParentClassesBfs(grandChildren.toArray(PythonUtils.EMPTY_OBJECT_ARRAY), foundClasses, registry, getNode, inliningTarget);
    }
}

