/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.CallDispatchNodeGen;
import com.oracle.graal.python.nodes.call.CallTargetInvokeNode;
import com.oracle.graal.python.nodes.call.FunctionInvokeNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PythonOptions.class})
@GenerateUncached
public abstract class CallDispatchNode
extends PNodeWithContext {
    @NeverDefault
    protected static FunctionInvokeNode createInvokeNode(PFunction callee) {
        return FunctionInvokeNode.create(callee);
    }

    @NeverDefault
    protected static FunctionInvokeNode createInvokeNode(PBuiltinFunction callee) {
        return FunctionInvokeNode.create(callee);
    }

    @NeverDefault
    protected static CallTargetInvokeNode createCtInvokeNode(PFunction callee) {
        return CallTargetInvokeNode.create(callee);
    }

    @NeverDefault
    protected static CallTargetInvokeNode createCtInvokeNode(PBuiltinFunction callee) {
        return CallTargetInvokeNode.create(callee);
    }

    @NeverDefault
    public static CallDispatchNode create() {
        return CallDispatchNodeGen.create();
    }

    public static CallDispatchNode getUncached() {
        return CallDispatchNodeGen.getUncached();
    }

    public final Object executeCall(VirtualFrame frame, PFunction callee, Object[] arguments) {
        return this.executeInternal((Frame)frame, callee, arguments);
    }

    public final Object executeCall(VirtualFrame frame, PBuiltinFunction callee, Object[] arguments) {
        return this.executeInternal((Frame)frame, callee, arguments);
    }

    protected abstract Object executeInternal(Frame var1, PFunction var2, Object[] var3);

    protected abstract Object executeInternal(Frame var1, PBuiltinFunction var2, Object[] var3);

    @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
    protected static Object callFunctionCached(VirtualFrame frame, PFunction callee, Object[] arguments, @Cached(value="callee") PFunction cachedCallee, @Cached(value="createInvokeNode(cachedCallee)") FunctionInvokeNode invoke) {
        return invoke.execute(frame, arguments);
    }

    protected PCode getCode(Node inliningTarget, FunctionNodes.GetFunctionCodeNode getFunctionCodeNode, PFunction function) {
        return getFunctionCodeNode.execute(inliningTarget, function);
    }

    @Specialization(guards={"isSingleContext()", "callee == cachedCallee", "getCode(inliningTarget, getFunctionCodeNode, callee) == cachedCode"}, replaces={"callFunctionCached"}, limit="getCallSiteInlineCacheMaxDepth()")
    protected static Object callFunctionCachedCode(VirtualFrame frame, PFunction callee, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached(value="callee") PFunction cachedCallee, @Cached FunctionNodes.GetFunctionCodeNode getFunctionCodeNode, @Cached(value="getCode(inliningTarget, getFunctionCodeNode, callee)") PCode cachedCode, @Cached(value="createInvokeNode(cachedCallee)") FunctionInvokeNode invoke) {
        return invoke.execute(frame, arguments);
    }

    protected static RootCallTarget getCallTargetUncached(PFunction callee) {
        CompilerAsserts.neverPartOfCompilation();
        return FunctionNodes.GetCallTargetNode.getUncached().execute(callee);
    }

    @Specialization(guards={"getCt.execute(inliningTarget, callee.getCode()) == ct"}, limit="getCallSiteInlineCacheMaxDepth()", replaces={"callFunctionCachedCode"})
    protected static Object callFunctionCachedCt(VirtualFrame frame, PFunction callee, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached(value="getCallTargetUncached(callee)") RootCallTarget ct, @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached(value="createCtInvokeNode(callee)") CallTargetInvokeNode invoke) {
        return invoke.execute(frame, callee, callee.getGlobals(), callee.getClosure(), arguments);
    }

    @Specialization(guards={"isSingleContext()", "callee == cachedCallee"}, limit="getCallSiteInlineCacheMaxDepth()")
    protected static Object callBuiltinFunctionCached(VirtualFrame frame, PBuiltinFunction callee, Object[] arguments, @Cached(value="callee") PBuiltinFunction cachedCallee, @Cached(value="createInvokeNode(cachedCallee)") FunctionInvokeNode invoke) {
        return invoke.execute(frame, arguments);
    }

    @Specialization(guards={"callee.getCallTarget() == ct"}, limit="getCallSiteInlineCacheMaxDepth()")
    protected static Object callBuiltinFunctionCachedCt(VirtualFrame frame, PBuiltinFunction callee, Object[] arguments, @Cached(value="callee.getCallTarget()") RootCallTarget ct, @Cached(value="createCtInvokeNode(callee)") CallTargetInvokeNode invoke) {
        return invoke.execute(frame, null, null, null, arguments);
    }

    @Specialization(replaces={"callFunctionCached", "callFunctionCachedCode", "callFunctionCachedCt"})
    @ReportPolymorphism.Megamorphic
    protected static Object callFunctionUncached(Frame frame, PFunction callee, Object[] arguments, @Cached.Shared @Cached GenericInvokeNode invoke) {
        return invoke.executeInternal(frame, callee, arguments);
    }

    @Specialization(replaces={"callBuiltinFunctionCached", "callBuiltinFunctionCachedCt"})
    @ReportPolymorphism.Megamorphic
    protected static Object callBuiltinFunctionUncached(Frame frame, PBuiltinFunction callee, Object[] arguments, @Cached.Shared @Cached GenericInvokeNode invoke) {
        return invoke.executeInternal(frame, callee, arguments);
    }
}

