/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.ForeignMethod;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectGetMethod
extends Node {
    public final Object executeCached(Frame frame, Object receiver, TruffleString name) {
        return this.execute(frame, this, receiver, name);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, TruffleString var4);

    protected static boolean isObjectGetAttribute(Node inliningTarget, TpSlots.GetCachedTpSlotsNode getSlotsNode, Object lazyClass) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, lazyClass);
        return slots.tp_getattro() == ObjectBuiltins.SLOTS.tp_getattro();
    }

    @Specialization(guards={"isObjectGetAttribute(inliningTarget, getTypeSlotsNode, lazyClass)", "name == cachedName"}, limit="1")
    static Object getFixedAttr(VirtualFrame frame, Node inliningTarget, Object receiver, TruffleString name, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getTypeSlotsNode, @Bind(value="getClass.execute(inliningTarget, receiver)") Object lazyClass, @Cached(value="name") TruffleString cachedName, @Cached(value="create(name)") LookupAttributeInMRONode lookupNode, @Cached.Exclusive @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached.Exclusive @Cached TpSlotDescrGet.CallSlotDescrGet callGetNode, @Cached.Shared(value="readAttr") @Cached(inline=false) ReadAttributeFromObjectNode readAttr, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached InlinedBranchProfile hasDescr, @Cached InlinedBranchProfile returnDataDescr, @Cached InlinedBranchProfile returnAttr, @Cached InlinedBranchProfile returnUnboundMethod, @Cached InlinedBranchProfile returnBoundDescr) {
        Object attr;
        boolean methodFound = false;
        Object descr = lookupNode.execute(lazyClass);
        TpSlot getMethod = null;
        if (descr != PNone.NO_VALUE) {
            hasDescr.enter(inliningTarget);
            if (MaybeBindDescriptorNode.isMethodDescriptor(descr)) {
                methodFound = true;
            } else {
                TpSlots descrSlots = getSlotsNode.execute(inliningTarget, descr);
                getMethod = descrSlots.tp_descr_get();
                if (getMethod != null && TpSlotDescrSet.PyDescr_IsData(descrSlots)) {
                    returnDataDescr.enter(inliningTarget);
                    return new BoundDescriptor(callGetNode.execute(frame, inliningTarget, getMethod, descr, receiver, lazyClass));
                }
            }
        }
        if (receiver instanceof PythonAbstractObject && (attr = readAttr.execute(receiver, name)) != PNone.NO_VALUE) {
            returnAttr.enter(inliningTarget);
            return new BoundDescriptor(attr);
        }
        if (methodFound) {
            returnUnboundMethod.enter(inliningTarget);
            return descr;
        }
        if (getMethod != null) {
            returnBoundDescr.enter(inliningTarget);
            return new BoundDescriptor(callGetNode.execute(frame, inliningTarget, getMethod, descr, receiver, lazyClass));
        }
        if (descr != PNone.NO_VALUE) {
            return new BoundDescriptor(descr);
        }
        throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, receiver, name);
    }

    @Specialization(guards={"isObjectGetAttribute(inliningTarget, getTypeSlotsNode, lazyClass)"}, replaces={"getFixedAttr"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static Object getDynamicAttr(Frame frame, Node inliningTarget, Object receiver, TruffleString name, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getTypeSlotsNode, @Bind(value="getClass.execute(inliningTarget, receiver)") Object lazyClass, @Cached(inline=false) LookupAttributeInMRONode.Dynamic lookupNode, @Cached.Exclusive @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached.Exclusive @Cached TpSlotDescrGet.CallSlotDescrGet callGetNode, @Cached.Shared(value="readAttr") @Cached(inline=false) ReadAttributeFromObjectNode readAttr, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        Object attr;
        boolean methodFound = false;
        Object descr = lookupNode.execute(lazyClass, name);
        TpSlot getMethod = null;
        if (descr != PNone.NO_VALUE) {
            if (MaybeBindDescriptorNode.isMethodDescriptor(descr)) {
                methodFound = true;
            } else {
                TpSlots descrSlots = getSlotsNode.execute(inliningTarget, descr);
                getMethod = descrSlots.tp_descr_get();
                if (getMethod != null && TpSlotDescrSet.PyDescr_IsData(descrSlots)) {
                    return new BoundDescriptor(callGetNode.execute((VirtualFrame)frame, inliningTarget, getMethod, descr, receiver, lazyClass));
                }
            }
        }
        if (receiver instanceof PythonAbstractObject && (attr = readAttr.execute(receiver, name)) != PNone.NO_VALUE) {
            return new BoundDescriptor(attr);
        }
        if (methodFound) {
            return descr;
        }
        if (getMethod != null) {
            return new BoundDescriptor(callGetNode.execute((VirtualFrame)frame, inliningTarget, getMethod, descr, receiver, lazyClass));
        }
        if (descr != PNone.NO_VALUE) {
            return new BoundDescriptor(descr);
        }
        throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, receiver, name);
    }

    @Specialization(guards={"isForeignObject(inliningTarget, isForeignObjectNode, receiver)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static Object getForeignMethod(VirtualFrame frame, Node inliningTarget, Object receiver, TruffleString name, @Cached IsForeignObjectNode isForeignObjectNode, @Cached.Exclusive @Cached PyObjectGetAttr getAttr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttrError, @Cached(inline=false) TruffleString.ToJavaStringNode toJavaString, @CachedLibrary(value="receiver") InteropLibrary lib) {
        try {
            return PyObjectGetMethod.getGenericAttr((Frame)frame, inliningTarget, receiver, name, getAttr);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, isAttrError);
            String jName = toJavaString.execute((AbstractTruffleString)name);
            if (lib.isMemberInvocable(receiver, jName)) {
                return new BoundDescriptor(new ForeignMethod(receiver, jName));
            }
            throw e;
        }
    }

    @HostCompilerDirectives.InliningCutoff
    static boolean isForeignObject(Node inliningTarget, IsForeignObjectNode isForeignObjectNode, Object receiver) {
        return isForeignObjectNode.execute(inliningTarget, receiver);
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static Object getGenericAttr(Frame frame, Node inliningTarget, Object receiver, TruffleString name, @Cached.Exclusive @Cached PyObjectGetAttr getAttr) {
        return new BoundDescriptor(getAttr.execute(frame, inliningTarget, receiver, name));
    }
}

