/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.AttributeErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.AttributeError})
public final class AttributeErrorBuiltins
extends PythonBuiltins {
    private static final int IDX_NAME = 0;
    private static final int IDX_OBJ = 1;
    private static final int NUM_ATTRS = 2;
    private static final TruffleString T_NAME = PythonUtils.tsLiteral("name");
    private static final TruffleString T_OBJ = PythonUtils.tsLiteral("obj");
    private static final BaseExceptionAttrNode.StorageFactory ATTR_FACTORY = (args, factory) -> new Object[2];

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AttributeErrorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(VirtualFrame frame, PBaseException self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached GetStateNode getStateNode, @Cached PythonObjectFactory factory) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            PTuple args = getArgsNode.execute(inliningTarget, self);
            Object state = getStateNode.execute(frame, self);
            return factory.createTuple(new Object[]{clazz, args, state});
        }
    }

    @Builtin(name="__getstate__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetStateNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PBaseException self, @Bind(value="this") Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached GetDictIfExistsNode getDictIfExistsNode, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached HashingStorageNodes.HashingStorageCopy copyStorageNode, @Cached PythonObjectFactory factory) {
            PDict dict = getDictIfExistsNode.execute(self);
            Object name = attrNode.get(self, 0, ATTR_FACTORY);
            if (name != null) {
                HashingStorage storage = dict != null ? copyStorageNode.execute(inliningTarget, dict.getDictStorage()) : EmptyStorage.INSTANCE;
                storage = setHashingStorageItem.execute(inliningTarget, storage, T_NAME, name);
                return factory.createDict(storage);
            }
            if (dict != null) {
                return dict;
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="obj", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="object")
    @GenerateNodeFactory
    public static abstract class ObjNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 1, ATTR_FACTORY);
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="attribute name")
    @GenerateNodeFactory
    public static abstract class NameNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, ATTR_FACTORY);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        InitNode() {
        }

        @Specialization
        static Object init(PBaseException self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseExceptionInitNode, @Cached TruffleString.EqualNode equalNameNode, @Cached TruffleString.EqualNode equalObjNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached PRaiseNode raiseNode) {
            baseExceptionInitNode.execute(self, args);
            Object[] attrs = new Object[2];
            loopProfile.profileCounted(inliningTarget, (long)kwargs.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < kwargs.length)) {
                PKeyword kw = kwargs[i];
                TruffleString kwName = kw.getName();
                if (equalNameNode.execute((AbstractTruffleString)kwName, (AbstractTruffleString)T_NAME, PythonUtils.TS_ENCODING)) {
                    attrs[0] = kw.getValue();
                } else if (equalObjNode.execute((AbstractTruffleString)kwName, (AbstractTruffleString)T_OBJ, PythonUtils.TS_ENCODING)) {
                    attrs[1] = kw.getValue();
                } else {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_IS_AN_INVALID_ARG_FOR_S, kw.getName(), "AttributeError");
                }
                ++i;
            }
            self.setExceptionAttributes(attrs);
            return PNone.NONE;
        }
    }
}

