/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha512ModuleBuiltinsFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="_sha512")
public final class Sha512ModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Sha512ModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="sha512", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.SHA512Type, isPublic=false)
    @GenerateNodeFactory
    static abstract class Sha512Node
    extends PythonBuiltinNode {
        Sha512Node() {
        }

        @Specialization
        static Object sha512(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_sha512.sha512");
        }
    }

    @Builtin(name="sha384", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.SHA384Type, isPublic=false)
    @GenerateNodeFactory
    static abstract class Sha384Node
    extends PythonBuiltinNode {
        Sha384Node() {
        }

        @Specialization
        static Object sha384(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_sha512.sha384");
        }
    }

    @Builtin(name="sha512", minNumOfPositionalArgs=0, parameterNames={"string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    static abstract class Sha512FunctionNode
    extends PythonBuiltinNode {
        Sha512FunctionNode() {
        }

        @Specialization
        static Object newDigest(VirtualFrame frame, Object buffer, Object usedForSecurity, @Bind(value="this") Node inliningTarget, @Cached HashlibModuleBuiltins.CreateDigestNode createNode) {
            return createNode.execute(frame, inliningTarget, PythonBuiltinClassType.SHA512Type, "sha512", "sha512", buffer);
        }
    }

    @Builtin(name="sha384", minNumOfPositionalArgs=0, parameterNames={"string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    static abstract class Sha384FunctionNode
    extends PythonBuiltinNode {
        Sha384FunctionNode() {
        }

        @Specialization
        static Object newDigest(VirtualFrame frame, Object buffer, Object usedForSecurity, @Bind(value="this") Node inliningTarget, @Cached HashlibModuleBuiltins.CreateDigestNode createNode) {
            return createNode.execute(frame, inliningTarget, PythonBuiltinClassType.SHA384Type, "sha384", "sha384", buffer);
        }
    }
}

