/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.posix.PScandirIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyOSFSPathNode;
import com.oracle.graal.python.lib.PyObjectAsFileDescriptor;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="posix", extendsModule="nt", isEager=true)
public final class PosixModuleBuiltins
extends PythonBuiltins {
    static final StructSequence.BuiltinTypeDescriptor STAT_RESULT_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStatResult, "stat_result: Result from stat, fstat, or lstat.\n\nThis object may be accessed either as a tuple of\n  (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime)\nor via the attributes st_mode, st_ino, st_dev, st_nlink, st_uid, and so on.\n\nPosix/windows: If your platform supports st_blksize, st_blocks, st_rdev,\nor st_flags, they are available as attributes only.\n\nSee os.stat for more information.", 10, new String[]{"st_mode", "st_ino", "st_dev", "st_nlink", "st_uid", "st_gid", "st_size", null, null, null, "st_atime", "st_mtime", "st_ctime", "st_atime_ns", "st_mtime_ns", "st_ctime_ns"}, new String[]{"protection bits", "inode", "device", "number of hard links", "user ID of owner", "group ID of owner", "total size, in bytes", "integer time of last access", "integer time of last modification", "integer time of last change", "time of last access", "time of last modification", "time of last change", "time of last access in nanoseconds", "time of last modification in nanoseconds", "time of last change in nanoseconds"});
    static final StructSequence.BuiltinTypeDescriptor STATVFS_RESULT_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStatvfsResult, "statvfs_result: Result from statvfs or fstatvfs.\n\nThis object may be accessed either as a tuple of\n  (bsize, frsize, blocks, bfree, bavail, files, ffree, favail, flag, namemax),\nor via the attributes f_bsize, f_frsize, f_blocks, f_bfree, and so on.\n\nSee os.statvfs for more information.", 10, new String[]{"f_bsize", "f_frsize", "f_blocks", "f_bfree", "f_bavail", "f_files", "f_ffree", "f_favail", "f_flag", "f_namemax", "f_fsid"}, null);
    private static final StructSequence.BuiltinTypeDescriptor TERMINAL_SIZE_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PTerminalSize, "A tuple of (columns, lines) for holding terminal window size", 2, new String[]{"columns", "lines"}, new String[]{"width of the terminal window in characters", "height of the terminal window in characters"});
    private static final StructSequence.BuiltinTypeDescriptor UNAME_RESULT_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PUnameResult, "uname_result: Result from os.uname().\n\nThis object may be accessed either as a tuple of\n  (sysname, nodename, release, version, machine),\nor via the attributes sysname, nodename, release, version, and machine.\n\nSee os.uname for more information.", 5, new String[]{"sysname", "nodename", "release", "version", "machine"}, new String[]{"operating system name", "name of machine on network (implementation-defined)", "operating system release", "operating system version", "hardware identifier"});
    public static final int EMULATED_WNOHANG = 1;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PosixModuleBuiltinsFactory.getFactories();
    }

    public PosixModuleBuiltins() {
        this.addConstants(PosixConstants.openFlags);
        this.addConstants(PosixConstants.waitOptions);
        this.addConstants(PosixConstants.accessMode);
        this.addConstants(PosixConstants.exitStatus);
        this.addConstants(PosixConstants.rtld);
        this.addConstant(PosixConstants.SEEK_DATA);
        this.addConstant(PosixConstants.SEEK_HOLE);
    }

    private void addConstant(PosixConstants.IntConstant c) {
        if (c.defined) {
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
    }

    private void addConstants(PosixConstants.IntConstant[] constants) {
        for (PosixConstants.IntConstant c : constants) {
            this.addConstant(c);
        }
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        ArrayList<TruffleString> haveFunctions = new ArrayList<TruffleString>();
        if (PythonOS.getPythonOS() != PythonOS.PLATFORM_WIN32) {
            Collections.addAll(haveFunctions, PythonUtils.tsLiteral("HAVE_FACCESSAT"), PythonUtils.tsLiteral("HAVE_FCHDIR"), PythonUtils.tsLiteral("HAVE_FCHMOD"), PythonUtils.tsLiteral("HAVE_FCHMODAT"), PythonUtils.tsLiteral("HAVE_FDOPENDIR"), PythonUtils.tsLiteral("HAVE_FSTATAT"), PythonUtils.tsLiteral("HAVE_FTRUNCATE"), PythonUtils.tsLiteral("HAVE_FUTIMES"), PythonUtils.tsLiteral("HAVE_LUTIMES"), PythonUtils.tsLiteral("HAVE_MKDIRAT"), PythonUtils.tsLiteral("HAVE_OPENAT"), PythonUtils.tsLiteral("HAVE_READLINKAT"), PythonUtils.tsLiteral("HAVE_RENAMEAT"), PythonUtils.tsLiteral("HAVE_SYMLINKAT"), PythonUtils.tsLiteral("HAVE_UNLINKAT"));
            if (PosixConstants.HAVE_FUTIMENS.value) {
                haveFunctions.add(PythonUtils.tsLiteral("HAVE_FUTIMENS"));
            }
            if (PosixConstants.HAVE_UTIMENSAT.value) {
                haveFunctions.add(PythonUtils.tsLiteral("HAVE_UTIMENSAT"));
            }
        } else {
            haveFunctions.add(PythonUtils.tsLiteral("HAVE_FTRUNCATE"));
            haveFunctions.add(PythonUtils.tsLiteral("MS_WINDOWS"));
        }
        this.addBuiltinConstant("_have_functions", (Object)core.factory().createList(haveFunctions.toArray()));
        this.addBuiltinConstant("environ", (Object)core.factory().createDict());
        this.addBuiltinConstant("sysconf_names", (Object)core.factory().createDict());
        StructSequence.initType(core, STAT_RESULT_DESC);
        StructSequence.initType(core, STATVFS_RESULT_DESC);
        StructSequence.initType(core, TERMINAL_SIZE_DESC);
        StructSequence.initType(core, UNAME_RESULT_DESC);
        PythonModule posix = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? core.lookupBuiltinModule(BuiltinNames.T_NT) : core.lookupBuiltinModule(BuiltinNames.T_POSIX);
        posix.setAttribute(PythonBuiltinClassType.PStatResult.getName(), core.lookupType(PythonBuiltinClassType.PStatResult));
        posix.setAttribute(PythonBuiltinClassType.PStatvfsResult.getName(), core.lookupType(PythonBuiltinClassType.PStatvfsResult));
        posix.setAttribute(PythonBuiltinClassType.PTerminalSize.getName(), core.lookupType(PythonBuiltinClassType.PTerminalSize));
        posix.setAttribute(PythonUtils.tsLiteral("error"), core.lookupType(PythonBuiltinClassType.OSError));
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
        PosixSupport posixSupport = core.getContext().getPosixSupport();
        Map getenv = core.getContext().getEnv().getEnvironment();
        PDict environ = core.factory().createDict();
        String pyenvLauncherKey = "__PYVENV_LAUNCHER__";
        for (Map.Entry entry : getenv.entrySet()) {
            Object val;
            PBytes key;
            if (((String)entry.getKey()).equals("GRAAL_PYTHON_ARGS") && ((String)entry.getValue()).endsWith("\u000b")) continue;
            if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
                if (((String)entry.getKey()).startsWith("=")) continue;
                key = PythonUtils.toTruffleStringUncached((String)entry.getKey());
            } else {
                key = core.factory().createBytes(((String)entry.getKey()).getBytes());
            }
            if (pyenvLauncherKey.equals(entry.getKey())) {
                TruffleString value = core.getContext().getOption(PythonOptions.Executable);
                try {
                    Object k = posixLib.createPathFromString(posixSupport, PythonUtils.toTruffleStringUncached(pyenvLauncherKey));
                    Object v = posixLib.createPathFromString(posixSupport, value);
                    posixLib.setenv(posixSupport, k, v, true);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
                val = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? value : core.factory().createBytes(value.toJavaStringUncached().getBytes());
            } else {
                val = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? PythonUtils.toTruffleStringUncached((String)entry.getValue()) : core.factory().createBytes(((String)entry.getValue()).getBytes());
            }
            environ.setItem(key, val);
        }
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            environ.setItem(PythonUtils.toTruffleStringUncached("PIP_NO_CACHE_DIR"), PythonUtils.toTruffleStringUncached("0"));
        }
        PythonModule posix = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? core.lookupBuiltinModule(BuiltinNames.T_NT) : core.lookupBuiltinModule(BuiltinNames.T_POSIX);
        Object environAttr = posix.getAttribute(PythonUtils.tsLiteral("environ"));
        ((PDict)environAttr).setDictStorage(environ.getDictStorage());
        PDict sysconfNamesAttr = (PDict)posix.getAttribute(PythonUtils.tsLiteral("sysconf_names"));
        sysconfNamesAttr.setDictStorage(HashingStorageNodes.HashingStorageCopy.executeUncached(SysconfNode.SYSCONF_NAMES));
        if (posixLib.getBackend(posixSupport).toJavaStringUncached().equals("java")) {
            posix.setAttribute(PythonUtils.toTruffleStringUncached("statvfs"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("geteuid"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("getegid"), PNone.NO_VALUE);
            posix.setAttribute(PythonUtils.toTruffleStringUncached("WNOHANG"), 1);
        }
    }

    public static int mapPythonSeekWhenceToPosix(int pythonWhence) {
        switch (pythonWhence) {
            case 0: {
                return PosixConstants.SEEK_SET.value;
            }
            case 1: {
                return PosixConstants.SEEK_CUR.value;
            }
            case 2: {
                return PosixConstants.SEEK_END.value;
            }
        }
        return pythonWhence;
    }

    private static PTuple createStatvfsResult(Node inliningTarget, long[] out, InlinedConditionProfile positiveLongProfile, PythonObjectFactory factory) {
        Object[] res = new Object[out.length];
        for (int i = 0; i < out.length; ++i) {
            res[i] = PInt.createPythonIntFromUnsignedLong(inliningTarget, factory, positiveLongProfile, out[i]);
        }
        return factory.createStructSeq(STATVFS_RESULT_DESC, res);
    }

    static Object dupAndFdopendir(VirtualFrame frame, Node inliningTarget, PosixSupportLibrary posixLib, Object posixSupport, PosixFd fd, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
        int dupFd = -1;
        try {
            dupFd = posixLib.dup(posixSupport, fd.fd);
            return posixLib.fdopendir(posixSupport, dupFd);
        }
        catch (PosixSupportLibrary.PosixException e) {
            if (dupFd != -1) {
                try {
                    posixLib.close(posixSupport, dupFd);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
            }
            throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
        }
    }

    static int dirFdForAudit(int dirFd) {
        return dirFd == PosixConstants.AT_FDCWD.value ? -1 : dirFd;
    }

    public static PTuple createStatResult(Node inliningTarget, PythonObjectFactory factory, InlinedConditionProfile positiveLongProfile, long[] out) {
        int i;
        Object[] res = new Object[16];
        for (i = 0; i < 7; ++i) {
            res[i] = PInt.createPythonIntFromUnsignedLong(inliningTarget, factory, positiveLongProfile, out[i]);
        }
        res[6] = out[6];
        for (i = 7; i < 10; ++i) {
            long seconds = out[i];
            long nsFraction = out[i + 3];
            res[i] = seconds;
            res[i + 3] = (double)seconds + (double)nsFraction * 1.0E-9;
            res[i + 6] = factory.createInt(PosixModuleBuiltins.convertToNanoseconds(seconds, nsFraction));
        }
        return factory.createStructSeq(STAT_RESULT_DESC, res);
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger convertToNanoseconds(long sec, long ns) {
        BigInteger r = BigInteger.valueOf(sec);
        r = r.multiply(BigInteger.valueOf(1000000000L));
        return r.add(BigInteger.valueOf(ns));
    }

    public static PBytes opaquePathToBytes(Object opaquePath, PosixSupportLibrary posixLib, Object posixSupport, PythonObjectFactory factory) {
        PosixSupportLibrary.Buffer buf = posixLib.getPathAsBytes(posixSupport, opaquePath);
        if (buf.length > Integer.MAX_VALUE) {
            throw CompilerDirectives.shouldNotReachHere((String)"Posix path cannot fit into a Java array");
        }
        return factory.createBytes(buf.data, 0, (int)buf.length);
    }

    @Builtin(name="sysconf", minNumOfPositionalArgs=1, parameterNames={"name"})
    @GenerateNodeFactory
    static abstract class SysconfNode
    extends PythonUnaryBuiltinNode {
        public static final TruffleString T_SC_CLK_TCK = PythonUtils.tsLiteral("SC_CLK_TCK");
        public static final TruffleString T_SC_NPROCESSORS_ONLN = PythonUtils.tsLiteral("SC_NPROCESSORS_ONLN");
        public static final int SC_CLK_TCK = 2;
        public static final int SC_NPROCESSORS_ONLN = 84;
        public static final EconomicMapStorage SYSCONF_NAMES = EconomicMapStorage.create();

        SysconfNode() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        static int sysconf(VirtualFrame frame, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyLongCheckNode longCheckNode, @Cached PyLongAsIntNode asIntNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode.Lazy raiseNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int id;
            if (longCheckNode.execute(inliningTarget, arg)) {
                id = asIntNode.execute((Frame)frame, inliningTarget, arg);
            } else {
                if (!unicodeCheckNode.execute(inliningTarget, arg)) throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CONFIGURATION_NAMES_MUST_BE_STRINGS_OR_INTEGERS);
                Object idObj = getItem.execute((Frame)frame, inliningTarget, SYSCONF_NAMES, arg);
                if (!(idObj instanceof Integer)) throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.UNRECOGNIZED_CONF_NAME);
                Integer idInt = (Integer)idObj;
                id = idInt;
            }
            if (id == 2) {
                return 100;
            }
            if (id != 84) throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.EINVAL);
            return CpuCountNode.getCpuCount();
        }

        static {
            SYSCONF_NAMES.putUncachedWithJavaEq(T_SC_CLK_TCK, (Object)2);
            SYSCONF_NAMES.putUncachedWithJavaEq(T_SC_NPROCESSORS_ONLN, (Object)84);
        }
    }

    public static class PosixFd
    extends PosixFileHandle {
        public final int fd;

        public PosixFd(Object originalObject, int fd) {
            super(originalObject);
            this.fd = fd;
        }
    }

    public static class PosixPath
    extends PosixFileHandle {
        public final Object value;
        public final boolean wasBufferLike;

        public PosixPath(Object originalObject, Object value, boolean wasBufferLike) {
            super(originalObject);
            this.value = value;
            this.wasBufferLike = wasBufferLike;
        }
    }

    public static abstract class PosixFileHandle {
        public final Object originalObject;

        protected PosixFileHandle(Object originalObject) {
            this.originalObject = originalObject;
        }
    }

    public static abstract class GidConversionNode
    extends AbstractIdConversionNode {
        @Override
        protected String getIdName() {
            return "gid";
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static GidConversionNode create() {
            return PosixModuleBuiltinsFactory.GidConversionNodeGen.create();
        }
    }

    public static abstract class UidConversionNode
    extends AbstractIdConversionNode {
        @Override
        protected String getIdName() {
            return "uid";
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static UidConversionNode create() {
            return PosixModuleBuiltinsFactory.UidConversionNodeGen.create();
        }
    }

    @GenerateCached(value=false)
    public static abstract class AbstractIdConversionNode
    extends ArgumentCastNode {
        private static final long MAX_UINT32 = 0xFFFFFFFFL;

        public abstract long executeLong(VirtualFrame var1, Object var2);

        @Specialization
        long doInt(int value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return this.checkValue(inliningTarget, value, raiseNode);
        }

        @Specialization
        long doLong(long value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return this.checkValue(inliningTarget, value, raiseNode);
        }

        @Specialization(guards={"!isInteger(value)"})
        long doGeneric(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode pyNumberIndexNode, @Cached PyLongAsLongNode asLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object index;
            try {
                index = pyNumberIndexNode.execute((Frame)frame, inliningTarget, value);
            }
            catch (PException ex) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_SHOULD_BE_INTEGER_NOT_P, this.getIdName(), value);
            }
            return this.checkValue(inliningTarget, asLongNode.execute((Frame)frame, inliningTarget, index), raiseNode);
        }

        private long checkValue(Node inliningTarget, long value, PRaiseNode.Lazy raiseNode) {
            if (value < -1L) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.S_IS_LESS_THAN_MINIMUM, this.getIdName());
            }
            if (value > 0xFFFFFFFFL) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.S_IS_GREATER_THAN_MAXIUMUM, this.getIdName());
            }
            return value;
        }

        protected abstract String getIdName();
    }

    public static abstract class PidtConversionNode
    extends ArgumentCastNode {
        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Specialization(guards={"!isInteger(value)"})
        static long doGeneric(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongNode asLongNode) {
            return asLongNode.execute((Frame)frame, inliningTarget, value);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static PidtConversionNode create() {
            return PosixModuleBuiltinsFactory.PidtConversionNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class FileDescriptorConversionNode
    extends ArgumentCastNode {
        @Specialization
        static int doIndex(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectAsFileDescriptor asFileDescriptor) {
            return asFileDescriptor.execute((Frame)frame, inliningTarget, value);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
        @NeverDefault
        public static FileDescriptorConversionNode create() {
            return PosixModuleBuiltinsFactory.FileDescriptorConversionNodeGen.create();
        }
    }

    public static abstract class OffsetConversionNode
    extends ArgumentCastNode {
        @Specialization
        static long doInt(int i) {
            return i;
        }

        @Specialization
        static long doLong(long l) {
            return l;
        }

        @Specialization
        static long doOthers(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongNode asLongNode) {
            return asLongNode.execute((Frame)frame, inliningTarget, value);
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Long})
        @NeverDefault
        public static OffsetConversionNode create() {
            return PosixModuleBuiltinsFactory.OffsetConversionNodeGen.create();
        }
    }

    public static abstract class PathConversionNode
    extends ArgumentCastNode {
        private final String functionNameWithColon;
        private final String argumentName;
        protected final boolean nullable;
        protected final boolean allowFd;

        public PathConversionNode(String functionName, String argumentName, boolean nullable, boolean allowFd) {
            this.functionNameWithColon = functionName != null ? functionName + ": " : "";
            this.argumentName = argumentName != null ? argumentName : "path";
            this.nullable = nullable;
            this.allowFd = allowFd;
        }

        @Specialization(guards={"nullable"})
        PosixFileHandle doNone(PNone value, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object path = posixLib.createPathFromString(PosixSupport.get(inliningTarget), StringLiterals.T_DOT);
            return new PosixPath(null, this.checkPath(inliningTarget, path, raiseNode), false);
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdBool(boolean value) {
            return new PosixFd(value, PInt.intValue(value));
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdInt(int value) {
            return new PosixFd(value, value);
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdLong(long value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return new PosixFd(value, DirFdConversionNode.longToFd(inliningTarget, value, raiseNode));
        }

        @Specialization(guards={"allowFd"})
        static PosixFileHandle doFdPInt(PInt value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return new PosixFd(value, DirFdConversionNode.longToFd(inliningTarget, castToLongNode.execute(inliningTarget, value), raiseNode));
        }

        @Specialization(guards={"isString(value)"})
        PosixFileHandle doUnicode(Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString str = castToStringNode.execute(inliningTarget, value);
            Object path = posixLib.createPathFromString(PosixSupport.get(inliningTarget), str);
            return new PosixPath(value, this.checkPath(inliningTarget, path, raiseNode), false);
        }

        @Specialization
        PosixFileHandle doBytes(PBytes value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.ToBytesNode toByteArrayNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object path = posixLib.createPathFromBytes(PosixSupport.get(inliningTarget), toByteArrayNode.execute(value));
            return new PosixPath(value, this.checkPath(inliningTarget, path, raiseNode), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isHandled(value)", "bufferAcquireLib.hasBuffer(value)"}, limit="3")
        PosixFileHandle doBuffer(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="value") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached WarningsModuleBuiltins.WarnNode warningNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(value, frame, this.getContext(), this.getLanguage(), indirectCallData);
            try {
                warningNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.S_S_SHOULD_BE_S_NOT_P, this.functionNameWithColon, this.argumentName, this.getAllowedTypes(), value);
                Object path = posixLib.createPathFromBytes(PosixSupport.get(inliningTarget), bufferLib.getCopiedByteArray(value));
                PosixPath posixPath = new PosixPath(value, this.checkPath(inliningTarget, path, raiseNode), true);
                return posixPath;
            }
            finally {
                bufferLib.release(buffer, frame, this.getContext(), this.getLanguage(), indirectCallData);
            }
        }

        @Specialization(guards={"!isHandled(value)", "!bufferAcquireLib.hasBuffer(value)", "allowFd", "indexCheckNode.execute(this, value)"}, limit="1")
        PosixFileHandle doIndex(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="bufferAcquireLib") @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @Cached.Exclusive @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object o = indexNode.execute((Frame)frame, inliningTarget, value);
            return new PosixFd(value, DirFdConversionNode.longToFd(inliningTarget, castToLongNode.execute(inliningTarget, o), raiseNode));
        }

        @Specialization(guards={"!isHandled(value)", "!bufferAcquireLib.hasBuffer(value)", "!allowFd || !indexCheckNode.execute(this, value)"}, limit="1")
        PosixFileHandle doGeneric(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="bufferAcquireLib") @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @Cached.Exclusive @Cached PyIndexCheckNode indexCheckNode, @Cached(value="create(T___FSPATH__)") LookupAndCallUnaryNode callFSPath, @Cached.Exclusive @Cached BytesNodes.ToBytesNode toByteArrayNode, @Cached.Exclusive @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object pathObject = callFSPath.executeObject(frame, value);
            if (pathObject == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_S_SHOULD_BE_S_NOT_P, this.functionNameWithColon, this.argumentName, this.getAllowedTypes(), value);
            }
            if (pathObject instanceof PBytes) {
                return this.doBytes((PBytes)pathObject, inliningTarget, toByteArrayNode, posixLib, raiseNode);
            }
            if (PGuards.isString(pathObject)) {
                return this.doUnicode(pathObject, inliningTarget, castToStringNode, posixLib, raiseNode);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_FSPATH_TO_RETURN_STR_OR_BYTES, value, pathObject);
        }

        protected boolean isHandled(Object value) {
            return PGuards.isPNone(value) && this.nullable || PGuards.canBeInteger(value) && this.allowFd || PGuards.isString(value) || PGuards.isPBytes(value);
        }

        private String getAllowedTypes() {
            return this.allowFd && this.nullable ? "string, bytes, os.PathLike, integer or None" : (this.allowFd ? "string, bytes, os.PathLike or integer" : (this.nullable ? "string, bytes, os.PathLike or None" : "string, bytes or os.PathLike"));
        }

        private Object checkPath(Node inliningTarget, Object path, PRaiseNode.Lazy raiseNode) {
            if (path == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.S_EMBEDDED_NULL_CHARACTER_IN_S, this.functionNameWithColon, this.argumentName);
            }
            return path;
        }

        @ClinicConverterFactory
        @NeverDefault
        public static PathConversionNode create(@ClinicConverterFactory.BuiltinName String functionName, @ClinicConverterFactory.ArgumentName String argumentName, boolean nullable, boolean allowFd) {
            return PosixModuleBuiltinsFactory.PathConversionNodeGen.create(functionName, argumentName, nullable, allowFd);
        }
    }

    public static abstract class DirFdConversionNode
    extends ArgumentCastNode {
        @Specialization
        static int doNone(PNone value) {
            return PosixConstants.AT_FDCWD.value;
        }

        @Specialization
        static int doFdBool(boolean value) {
            return PInt.intValue(value);
        }

        @Specialization
        static int doFdInt(int value) {
            return value;
        }

        @Specialization
        int doFdLong(long value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return DirFdConversionNode.longToFd(inliningTarget, value, raiseNode);
        }

        @Specialization
        int doFdPInt(PInt value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return this.doFdLong(castToLongNode.execute(inliningTarget, value), inliningTarget, raiseNode);
        }

        @Specialization(guards={"!isPNone(value)", "!canBeInteger(value)"})
        int doIndex(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached.Exclusive @Cached CastToJavaLongLossyNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (indexCheckNode.execute(inliningTarget, value)) {
                Object o = indexNode.execute((Frame)frame, inliningTarget, value);
                return this.doFdLong(castToLongNode.execute(inliningTarget, o), inliningTarget, raiseNode);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ARG_SHOULD_BE_INT_OR_NONE, value);
        }

        private static int longToFd(Node inliningTarget, long value, PRaiseNode.Lazy raiseNode) {
            if (value > Integer.MAX_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.FD_IS_GREATER_THAN_MAXIMUM);
            }
            if (value < Integer.MIN_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.FD_IS_LESS_THAN_MINIMUM);
            }
            return (int)value;
        }

        @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
        @NeverDefault
        public static DirFdConversionNode create() {
            return PosixModuleBuiltinsFactory.DirFdConversionNodeGen.create();
        }
    }

    public static abstract class FsConverterNode
    extends ArgumentCastNode {
        @Specialization
        static PBytes convert(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyOSFSPathNode fspathNode, @Cached StringOrBytesToBytesNode stringOrBytesToBytesNode) {
            return stringOrBytesToBytesNode.execute(inliningTarget, fspathNode.execute((Frame)frame, inliningTarget, value));
        }

        @ClinicConverterFactory
        @NeverDefault
        public static FsConverterNode create() {
            return PosixModuleBuiltinsFactory.FsConverterNodeGen.create();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={BinaryArithmetic.class, PGuards.class})
    static abstract class SplitLongToSAndNsNode
    extends ConvertToTimespecBaseNode {
        private static final long BILLION = 1000000000L;

        SplitLongToSAndNsNode() {
        }

        @Specialization
        static void doInt(int value, long[] timespec, int offset) {
            SplitLongToSAndNsNode.doLong(value, timespec, offset);
        }

        @Specialization
        static void doLong(long value, long[] timespec, int offset) {
            timespec[offset] = Math.floorDiv(value, 1000000000L);
            timespec[offset + 1] = Math.floorMod(value, 1000000000L);
        }

        @Specialization(guards={"!isInteger(value)"})
        static void doGeneric(VirtualFrame frame, Node inliningTarget, Object value, long[] timespec, int offset, @Cached(value="DivMod.create()", inline=false) BinaryOpNode callDivmod, @Cached SequenceNodes.LenNode lenNode, @Cached(value="createNotNormalized()", inline=false) SequenceStorageNodes.GetItemNode getItemNode, @Cached PyLongAsLongNode asLongNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object divmod = callDivmod.executeObject(frame, value, 1000000000L);
            if (!PGuards.isPTuple(divmod) || lenNode.execute(inliningTarget, (PSequence)divmod) != 2) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MUST_RETURN_2TUPLE, value, divmod);
            }
            SequenceStorage storage = ((PTuple)divmod).getSequenceStorage();
            timespec[offset] = asLongNode.execute((Frame)frame, inliningTarget, getItemNode.execute(storage, 0));
            timespec[offset + 1] = asLongNode.execute((Frame)frame, inliningTarget, getItemNode.execute(storage, 1));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class ObjectToTimespecNode
    extends ConvertToTimespecBaseNode {
        ObjectToTimespecNode() {
        }

        @Specialization
        static void doDouble(Node inliningTarget, double value, long[] timespec, int offset, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (Double.isNaN(value)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.INVALID_VALUE_NAN);
            }
            double denominator = 1.0E9;
            double floatPart = value % 1.0;
            double intPart = value - floatPart;
            if ((floatPart = Math.floor(floatPart * denominator)) >= denominator) {
                floatPart -= denominator;
                intPart += 1.0;
            } else if (floatPart < 0.0) {
                floatPart += denominator;
                intPart -= 1.0;
            }
            assert (0.0 <= floatPart && floatPart < denominator);
            if (!MathGuards.fitLong(intPart)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.TIMESTAMP_OUT_OF_RANGE);
            }
            timespec[offset] = (long)intPart;
            timespec[offset + 1] = (long)floatPart;
            assert (0L <= timespec[offset + 1] && timespec[offset + 1] < (long)denominator);
        }

        @Specialization
        static void doPFloat(Node inliningTarget, PFloat obj, long[] timespec, int offset, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            ObjectToTimespecNode.doDouble(inliningTarget, obj.getValue(), timespec, offset, raiseNode);
        }

        @Specialization
        static void doInt(int value, long[] timespec, int offset) {
            timespec[offset] = value;
            timespec[offset + 1] = 0L;
        }

        @Specialization
        static void doLong(long value, long[] timespec, int offset) {
            timespec[offset] = value;
            timespec[offset + 1] = 0L;
        }

        @Specialization(guards={"!isDouble(value)", "!isPFloat(value)", "!isInteger(value)"})
        static void doGeneric(VirtualFrame frame, Node inliningTarget, Object value, long[] timespec, int offset, @Cached PyLongAsLongAndOverflowNode asLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                timespec[offset] = asLongNode.execute((Frame)frame, inliningTarget, value);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.TIMESTAMP_OUT_OF_RANGE);
            }
            timespec[offset + 1] = 0L;
        }
    }

    static abstract class ConvertToTimespecBaseNode
    extends Node {
        ConvertToTimespecBaseNode() {
        }

        abstract void execute(VirtualFrame var1, Node var2, Object var3, long[] var4, int var5);
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ObjectToOpaquePathNode
    extends Node {
        ObjectToOpaquePathNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, boolean var4);

        @Specialization(guards={"!checkEmpty"})
        static Object noCheck(VirtualFrame frame, Node inliningTarget, Object obj, boolean checkEmpty, @Cached.Exclusive @Cached PyOSFSPathNode fspathNode, @Cached.Exclusive @Cached StringOrBytesToOpaquePathNode stringOrBytesToOpaquePathNode) {
            return stringOrBytesToOpaquePathNode.execute(inliningTarget, fspathNode.execute((Frame)frame, inliningTarget, obj));
        }

        @Specialization(guards={"checkEmpty"})
        static Object withCheck(VirtualFrame frame, Node inliningTarget, Object obj, boolean checkEmpty, @Cached.Exclusive @Cached PyOSFSPathNode fspathNode, @Cached PyObjectSizeNode sizeNode, @Cached.Exclusive @Cached StringOrBytesToOpaquePathNode stringOrBytesToOpaquePathNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object stringOrBytes = fspathNode.execute((Frame)frame, inliningTarget, obj);
            if (sizeNode.execute((Frame)frame, inliningTarget, obj) == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EXECV_ARG2_FIRST_ELEMENT_CANNOT_BE_EMPTY);
            }
            return stringOrBytesToOpaquePathNode.execute(inliningTarget, stringOrBytes);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class StringOrBytesToOpaquePathNode
    extends Node {
        StringOrBytesToOpaquePathNode() {
        }

        abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"isString(strObj)"})
        static Object doString(Node inliningTarget, Object strObj, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString str = castToStringNode.execute(inliningTarget, strObj);
            return StringOrBytesToOpaquePathNode.checkPath(inliningTarget, posixLib.createPathFromString(PosixSupport.get(inliningTarget), str), raiseNode);
        }

        @Specialization
        static Object doBytes(Node inliningTarget, PBytes bytes, @Cached(inline=false) BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return StringOrBytesToOpaquePathNode.checkPath(inliningTarget, posixLib.createPathFromBytes(PosixSupport.get(inliningTarget), toBytesNode.execute(bytes)), raiseNode);
        }

        private static Object checkPath(Node inliningTarget, Object path, PRaiseNode.Lazy raiseNode) {
            if (path == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return path;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class StringOrBytesToBytesNode
    extends Node {
        public abstract PBytes execute(Node var1, Object var2);

        @Specialization(guards={"isString(strObj)"})
        static PBytes doString(Node inliningTarget, Object strObj, @Cached CastToTruffleStringNode castToStringNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached(inline=false) TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached(inline=false) PythonObjectFactory factory) {
            TruffleString str = castToStringNode.execute(inliningTarget, strObj);
            TruffleString utf8 = switchEncodingNode.execute((AbstractTruffleString)str, TruffleString.Encoding.UTF_8);
            byte[] bytes = new byte[utf8.byteLength(TruffleString.Encoding.UTF_8)];
            copyToByteArrayNode.execute((AbstractTruffleString)utf8, 0, bytes, 0, bytes.length, TruffleString.Encoding.UTF_8);
            return factory.createBytes(bytes);
        }

        @Specialization
        static PBytes doBytes(PBytes bytes) {
            return bytes;
        }
    }

    @Builtin(name="register_at_fork", keywordOnlyNames={"before", "after_in_child", "after_in_parent"})
    @GenerateNodeFactory
    static abstract class RegisterAtForkNode
    extends PythonBuiltinNode {
        RegisterAtForkNode() {
        }

        @Specialization
        Object register(Object before, Object afterInChild, Object afterInParent) {
            return PNone.NONE;
        }
    }

    @Builtin(name="fspath", minNumOfPositionalArgs=1, parameterNames={"path"})
    @GenerateNodeFactory
    public static abstract class FspathNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doTrivial(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyOSFSPathNode fsPathNode) {
            return fsPathNode.execute((Frame)frame, inliningTarget, value);
        }
    }

    @Builtin(name="killpg", minNumOfPositionalArgs=2, parameterNames={"pgid", "signal"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pgid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="signal", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    static abstract class KillPgNode
    extends PythonBinaryClinicBuiltinNode {
        KillPgNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.KillNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone kill(VirtualFrame frame, long pid, int signal, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "killpg", pid, signal);
            try {
                posixLib.killpg(this.getPosixSupport(), pid, signal);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
        }
    }

    @Builtin(name="kill", minNumOfPositionalArgs=2, parameterNames={"pid", "signal"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="signal", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    static abstract class KillNode
    extends PythonBinaryClinicBuiltinNode {
        KillNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.KillNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone kill(VirtualFrame frame, long pid, int signal, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "kill", pid, signal);
            try {
                posixLib.kill(this.getPosixSupport(), pid, signal);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
        }
    }

    @Builtin(name="ctermid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class CtermId
    extends PythonBuiltinNode {
        CtermId() {
        }

        @Specialization
        TruffleString ctermid(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.ctermid(this.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="umask", minNumOfPositionalArgs=1, parameterNames={"mask"})
    @ArgumentClinic(name="mask", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class UmaskNode
    extends PythonUnaryClinicBuiltinNode {
        UmaskNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UmaskNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int umask(VirtualFrame frame, int mask, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.umask(this.getPosixSupport(), mask);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="cpu_count", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class CpuCountNode
    extends PythonBuiltinNode {
        CpuCountNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static int getCpuCount() {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    @Builtin(name="urandom", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class URandomNode
    extends PythonUnaryClinicBuiltinNode {
        URandomNode() {
        }

        @Specialization(guards={"size >= 0"})
        PBytes urandom(int size, @Cached PythonObjectFactory factory) {
            byte[] bytes = new byte[size];
            URandomNode.nextBytes(this.getContext().getSecureRandom(), bytes);
            return factory.createBytes(bytes);
        }

        @Specialization(guards={"size < 0"})
        static Object urandomNeg(int size, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.NEG_ARG_NOT_ALLOWED);
        }

        @CompilerDirectives.TruffleBoundary
        private static void nextBytes(SecureRandom secureRandom, byte[] bytes) {
            secureRandom.nextBytes(bytes);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.URandomNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="system", minNumOfPositionalArgs=1, parameterNames={"command"})
    @ArgumentClinic(name="command", conversionClass=FsConverterNode.class)
    @GenerateNodeFactory
    static abstract class SystemNode
    extends PythonUnaryClinicBuiltinNode {
        SystemNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SystemNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        int system(PBytes command, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached GilNode gil) {
            auditNode.audit(inliningTarget, "os.system", command);
            byte[] bytes = toBytesNode.execute(command);
            gil.release(true);
            try {
                Object cmdOpaque = posixLib.createPathFromBytes(this.getPosixSupport(), bytes);
                int n = posixLib.system(this.getPosixSupport(), cmdOpaque);
                return n;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="WSTOPSIG", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WstopsigNode
    extends PythonUnaryClinicBuiltinNode {
        WstopsigNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WstopsigNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int wstopsig(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wstopsig(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WTERMSIG", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WtermsigNode
    extends PythonUnaryClinicBuiltinNode {
        WtermsigNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WtermsigNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int wtermsig(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wtermsig(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WEXITSTATUS", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WexitstatusNode
    extends PythonUnaryClinicBuiltinNode {
        WexitstatusNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WexitstatusNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int wexitstatus(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wexitstatus(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFEXITED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifexitedNode
    extends PythonUnaryClinicBuiltinNode {
        WifexitedNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifexitedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean wifexited(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wifexited(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFSIGNALED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifsignaledNode
    extends PythonUnaryClinicBuiltinNode {
        WifsignaledNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifsignaledNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean wifsignaled(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wifsignaled(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFSTOPPED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifstoppedNode
    extends PythonUnaryClinicBuiltinNode {
        WifstoppedNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifstoppedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean wifstopped(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wifstopped(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WIFCONTINUED", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WifcontinuedNode
    extends PythonUnaryClinicBuiltinNode {
        WifcontinuedNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WifcontinuedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean wifcontinued(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wifcontinued(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="WCOREDUMP", minNumOfPositionalArgs=1, parameterNames={"status"})
    @ArgumentClinic(name="status", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WcoredumpNode
    extends PythonUnaryClinicBuiltinNode {
        WcoredumpNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WcoredumpNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean wcoredump(int status, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.wcoredump(this.getPosixSupport(), status);
        }
    }

    @Builtin(name="waitstatus_to_exitcode", minNumOfPositionalArgs=1, parameterNames={"status"})
    @GenerateNodeFactory
    static abstract class WaitstatusToExitcodeNode
    extends PythonUnaryBuiltinNode {
        WaitstatusToExitcodeNode() {
        }

        @Specialization
        static int waitstatusToExitcode(VirtualFrame frame, Object statusObj, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached PyLongAsIntNode longAsInt, @Cached PRaiseNode.Lazy raiseNode) {
            int status = longAsInt.execute((Frame)frame, inliningTarget, statusObj);
            PosixSupport posixSupport = PosixSupport.get(inliningTarget);
            if (posixLib.wifexited(posixSupport, status)) {
                int exitcode = posixLib.wexitstatus(posixSupport, status);
                if (exitcode < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_WEXITSTATUS, exitcode);
                }
                return exitcode;
            }
            if (posixLib.wifsignaled(posixSupport, status)) {
                int signum = posixLib.wtermsig(posixSupport, status);
                if (signum <= 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_WTERMSIG, signum);
                }
                return -signum;
            }
            if (posixLib.wifstopped(posixSupport, status)) {
                int signum = posixLib.wstopsig(posixSupport, status);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.PROCESS_STOPPED_BY_DELIVERY_OF_SIGNAL, signum);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_WAIT_STATUS, status);
        }
    }

    @Builtin(name="waitpid", minNumOfPositionalArgs=2, parameterNames={"pid", "options"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="options", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class WaitpidNode
    extends PythonBinaryClinicBuiltinNode {
        WaitpidNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WaitpidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PTuple waitpid(VirtualFrame frame, long pid, int options, @Bind(value="this") Node inliningTarget, @Cached GilNode gil, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            gil.release(true);
            while (true) {
                try {
                    long[] result = posixLib.waitpid(this.getPosixSupport(), pid, options);
                    PTuple pTuple = factory.createTuple(new Object[]{result[0], result[1]});
                    return pTuple;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(this);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="_exit", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class ExitNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object exit(final int status) {
            PythonContext context = this.getContext();
            if (context.getOption(PythonOptions.RunViaLauncher).booleanValue()) {
                Runtime.getRuntime().halt(status);
            }
            ArrayList<Thread> otherThreads = new ArrayList<Thread>(Arrays.asList(context.getThreads()));
            otherThreads.remove(context.getMainThread());
            otherThreads.remove(Thread.currentThread());
            context.getEnv().submitThreadLocal(otherThreads.toArray(new Thread[0]), new ThreadLocalAction(true, false){

                protected void perform(ThreadLocalAction.Access access) {
                    throw new ThreadDeath();
                }
            });
            if (Thread.currentThread() == context.getMainThread()) {
                throw new PythonExitException(this, status);
            }
            context.getEnv().submitThreadLocal(new Thread[]{context.getMainThread()}, new ThreadLocalAction(this, true, false){
                final /* synthetic */ ExitNode this$0;
                {
                    this.this$0 = this$0;
                    super(hasSideEffects, synchronous);
                }

                protected void perform(ThreadLocalAction.Access access) {
                    throw new PythonExitException(this.this$0, status);
                }
            });
            throw new ThreadDeath();
        }
    }

    @Builtin(name="strerror", minNumOfPositionalArgs=1, parameterNames={"code"})
    @ArgumentClinic(name="code", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class StrErrorNode
    extends PythonUnaryClinicBuiltinNode {
        StrErrorNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.StrErrorNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        TruffleString getStrError(int code, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.strerror(this.getPosixSupport(), code);
        }
    }

    @Builtin(name="readlink", minNumOfPositionalArgs=1, parameterNames={"path"}, varArgsMarker=true, keywordOnlyNames={"dir_fd"}, doc="readlink(path, *, dir_fd=None) -> path\n\nReturn a string representing the path to which the symbolic link points.\n")
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class ReadlinkNode
    extends PythonClinicBuiltinNode {
        ReadlinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ReadlinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object readlinkAsBytes(VirtualFrame frame, PosixPath path, int dirFd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile wasBufferLikeProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                Object link = posixLib.readlinkat(this.getPosixSupport(), dirFd, path.value);
                if (wasBufferLikeProfile.profile(inliningTarget, path.wasBufferLike)) {
                    return PosixModuleBuiltins.opaquePathToBytes(link, posixLib, this.getPosixSupport(), factory);
                }
                return posixLib.getPathAsString(this.getPosixSupport(), link);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }
    }

    @Builtin(name="chown", minNumOfPositionalArgs=3, parameterNames={"path", "uid", "gid"}, keywordOnlyNames={"dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="uid", conversionClass=UidConversionNode.class), @ArgumentClinic(name="gid", conversionClass=GidConversionNode.class), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class ChownNode
    extends PythonClinicBuiltinNode {
        ChownNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object chown(VirtualFrame frame, PosixPath path, long uid, long gid, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            auditNode.audit(inliningTarget, "os.chown", path.originalObject, uid, gid, dirFd != PosixConstants.AT_FDCWD.value ? dirFd : -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchownat(PosixSupport.get(inliningTarget), dirFd, path.value, uid, gid, followSymlinks);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object chown(VirtualFrame frame, PosixFd fd, long uid, long gid, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (dirFd != PosixConstants.AT_FDCWD.value) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_BOTH_DIR_FD_AND_FD);
            }
            if (followSymlinks) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "chown");
            }
            auditNode.audit(inliningTarget, "os.chown", fd.originalObject, uid, gid, -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchown(PosixSupport.get(inliningTarget), fd.fd, uid, gid);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ChownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="lchown", parameterNames={"path", "uid", "gid"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="uid", conversionClass=UidConversionNode.class), @ArgumentClinic(name="gid", conversionClass=GidConversionNode.class)})
    @GenerateNodeFactory
    static abstract class LChownNode
    extends PythonTernaryClinicBuiltinNode {
        LChownNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object chown(VirtualFrame frame, PosixPath path, long uid, long gid, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.chown", path.originalObject, uid, gid, -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchownat(this.getPosixSupport(), PosixConstants.AT_FDCWD.value, path.value, uid, gid, false);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LChownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="fchown", parameterNames={"fd", "uid", "gid"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="uid", conversionClass=UidConversionNode.class), @ArgumentClinic(name="gid", conversionClass=GidConversionNode.class)})
    @GenerateNodeFactory
    static abstract class FChownNode
    extends PythonTernaryClinicBuiltinNode {
        FChownNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object chown(VirtualFrame frame, int fd, long uid, long gid, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.chown", fd, uid, gid, -1);
            try {
                gil.release(true);
                try {
                    posixLib.fchown(this.getPosixSupport(), fd, uid, gid);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FChownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="chmod", minNumOfPositionalArgs=2, parameterNames={"path", "mode"}, varArgsMarker=true, keywordOnlyNames={"dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", defaultValue="true", conversion=ArgumentClinic.ClinicConversion.Boolean)})
    @GenerateNodeFactory
    static abstract class ChmodNode
    extends PythonClinicBuiltinNode {
        ChmodNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ChmodNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone chmodFollow(VirtualFrame frame, PosixPath path, int mode, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            auditNode.audit(inliningTarget, "os.chmod", path.originalObject, mode, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.fchmodat(PosixSupport.get(inliningTarget), dirFd, path.value, mode, followSymlinks);
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (e.getErrorCode() == OSErrorEnum.EOPNOTSUPP.getNumber() && !followSymlinks) {
                    if (dirFd != PosixConstants.AT_FDCWD.value) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "chmod");
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.NotImplementedError, ErrorMessages.UNAVAILABLE_ON_THIS_PLATFORM, "chmod", "follow_symlinks");
                }
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        @Specialization
        PNone chmodFollow(VirtualFrame frame, PosixFd fd, int mode, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            auditNode.audit(inliningTarget, "os.chmod", fd.originalObject, mode, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.fchmod(this.getPosixSupport(), fd.fd, mode);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="fchmod", minNumOfPositionalArgs=2, parameterNames={"fd", "mode"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class FChmodNode
    extends PythonBinaryClinicBuiltinNode {
        FChmodNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FChmodNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone fchmod(VirtualFrame frame, int fd, int mode, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.chmod", fd, mode, -1);
            try {
                posixLib.fchmod(this.getPosixSupport(), fd, mode);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="access", minNumOfPositionalArgs=2, parameterNames={"path", "mode"}, varArgsMarker=true, keywordOnlyNames={"dir_fd", "effective_ids", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="effective_ids", defaultValue="false", conversion=ArgumentClinic.ClinicConversion.Boolean), @ArgumentClinic(name="follow_symlinks", defaultValue="true", conversion=ArgumentClinic.ClinicConversion.Boolean)})
    @GenerateNodeFactory
    static abstract class AccessNode
    extends PythonClinicBuiltinNode {
        AccessNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.AccessNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean access(PosixPath path, int mode, int dirFd, boolean effectiveIds, boolean followSymlinks, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.faccessat(this.getPosixSupport(), dirFd, path.value, mode, effectiveIds, followSymlinks);
        }
    }

    @Builtin(name="replace", minNumOfPositionalArgs=2, parameterNames={"src", "dst"}, varArgsMarker=true, keywordOnlyNames={"src_dir_fd", "dst_dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="src_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="dst_dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class ReplaceNode
    extends RenameNode {
        ReplaceNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ReplaceNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="rename", minNumOfPositionalArgs=2, parameterNames={"src", "dst"}, varArgsMarker=true, keywordOnlyNames={"src_dir_fd", "dst_dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="src_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="dst_dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class RenameNode
    extends PythonClinicBuiltinNode {
        RenameNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.RenameNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone rename(VirtualFrame frame, PosixPath src, PosixPath dst, int srcDirFd, int dstDirFd, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.rename", src.originalObject, dst.originalObject, PosixModuleBuiltins.dirFdForAudit(srcDirFd), PosixModuleBuiltins.dirFdForAudit(dstDirFd));
            try {
                posixLib.renameat(this.getPosixSupport(), srcDirFd, src.value, dstDirFd, dst.value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, src.originalObject, dst.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="utime", minNumOfPositionalArgs=1, parameterNames={"path", "times"}, varArgsMarker=true, keywordOnlyNames={"ns", "dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    @ImportStatic(value={PosixConstants.class})
    static abstract class UtimeNode
    extends PythonClinicBuiltinNode {
        UtimeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UtimeNodeClinicProviderGen.INSTANCE;
        }

        private static Object checkNone(Object o) {
            return PGuards.isPNone(o) ? PNone.NONE : o;
        }

        @Specialization(guards={"HAVE_UTIMENSAT.value"})
        static PNone utimensat(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long[] timespec = timespecNode.execute(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", path.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.utimensat(PosixSupport.get(inliningTarget), dirFd, path.value, timespec, followSymlinks);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "isDefault(dirFd)", "followSymlinks"})
        static PNone utimes(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.Timeval[] timeval = timespecNode.toTimeval(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", path.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.utimes(PosixSupport.get(inliningTarget), path.value, timeval);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "isDefault(dirFd)", "!followSymlinks"})
        static PNone lutimes(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.Timeval[] timeval = timespecNode.toTimeval(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", path.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.lutimes(PosixSupport.get(inliningTarget), path.value, timeval);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "!isDefault(dirFd)", "followSymlinks"})
        static PNone dirFdNotSupported(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.NotImplementedError, ErrorMessages.UNAVAILABLE_ON_THIS_PLATFORM_NO_FUNC, "dir_fd");
        }

        @Specialization(guards={"!HAVE_UTIMENSAT.value", "!isDefault(dirFd)", "!followSymlinks"})
        static PNone dirFdAndFollowSymlinksNotSupported(VirtualFrame frame, PosixPath path, Object times, Object ns, int dirFd, boolean followSymlinks, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.UTIME_CANNOT_USE_DIR_FD_AND_FOLLOW_SYMLINKS, "dir_fd");
        }

        @Specialization(guards={"HAVE_FUTIMENS.value", "isDefault(dirFd)", "followSymlinks"})
        static PNone futimens(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long[] timespec = timespecNode.execute(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", fd.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.futimens(PosixSupport.get(inliningTarget), fd.fd, timespec);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!HAVE_FUTIMENS.value", "isDefault(dirFd)", "followSymlinks"})
        static PNone futimes(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached UtimeArgsToTimespecNode timespecNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.Timeval[] timeval = timespecNode.toTimeval(frame, times, ns);
            auditNode.audit(inliningTarget, "os.utime", fd.originalObject, UtimeNode.checkNone(times), UtimeNode.checkNone(ns), PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.futimes(PosixSupport.get(inliningTarget), fd.fd, timeval);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"isPNone(times) || isNoValue(ns)", "!isDefault(dirFd)"})
        static PNone fdWithDirFd(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_DIRFD_WITHOUT_PATH, "utime");
        }

        @Specialization(guards={"isPNone(times) || isNoValue(ns)", "isDefault(dirFd)", "!followSymlinks"})
        static PNone fdWithFollowSymlinks(VirtualFrame frame, PosixFd fd, Object times, Object ns, int dirFd, boolean followSymlinks, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "utime");
        }

        protected static boolean isDefault(int dirFd) {
            return dirFd == PosixConstants.AT_FDCWD.value;
        }
    }

    @ImportStatic(value={PGuards.class})
    static abstract class UtimeArgsToTimespecNode
    extends Node {
        UtimeArgsToTimespecNode() {
        }

        abstract long[] execute(VirtualFrame var1, Object var2, Object var3);

        final PosixSupportLibrary.Timeval[] toTimeval(VirtualFrame frame, Object times, Object ns) {
            PosixSupportLibrary.Timeval[] timevalArray;
            long[] timespec = this.execute(frame, times, ns);
            if (timespec == null) {
                timevalArray = null;
            } else {
                PosixSupportLibrary.Timeval[] timevalArray2 = new PosixSupportLibrary.Timeval[2];
                timevalArray2[0] = new PosixSupportLibrary.Timeval(timespec[0], timespec[1] / 1000L);
                timevalArray = timevalArray2;
                timevalArray2[1] = new PosixSupportLibrary.Timeval(timespec[2], timespec[3] / 1000L);
            }
            return timevalArray;
        }

        @Specialization(guards={"isNoValue(ns)"})
        static long[] now(VirtualFrame frame, PNone times, PNone ns) {
            return null;
        }

        @Specialization(guards={"isNoValue(ns)"})
        static long[] times(VirtualFrame frame, PTuple times, PNone ns, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.LenNode lenNode, @Cached.Shared @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached ObjectToTimespecNode objectToTimespecNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return UtimeArgsToTimespecNode.convertToTimespec(frame, inliningTarget, times, lenNode, getItemNode, objectToTimespecNode, raiseNode);
        }

        @Specialization
        static long[] ns(VirtualFrame frame, PNone times, PTuple ns, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.LenNode lenNode, @Cached.Shared @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached SplitLongToSAndNsNode splitLongToSAndNsNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return UtimeArgsToTimespecNode.convertToTimespec(frame, inliningTarget, ns, lenNode, getItemNode, splitLongToSAndNsNode, raiseNode);
        }

        @Specialization(guards={"!isPNone(times)", "!isNoValue(ns)"})
        static long[] bothSpecified(VirtualFrame frame, Object times, Object ns, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.YOU_MAY_SPECIFY_EITHER_OR_BUT_NOT_BOTH, "utime", "times", "ns");
        }

        @Specialization(guards={"!isPNone(times)", "!isPTuple(times)", "isNoValue(ns)"})
        static long[] timesNotATuple(VirtualFrame frame, Object times, PNone ns, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw UtimeArgsToTimespecNode.timesTupleError(raiseNode);
        }

        @Specialization(guards={"!isNoValue(ns)", "!isPTuple(ns)"})
        static long[] nsNotATuple(VirtualFrame frame, PNone times, Object ns, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE, "utime", "ns", "a tuple of two ints");
        }

        private static PException timesTupleError(PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_EITHER_OR, "utime", "times", "a tuple of two ints", "None");
        }

        private static long[] convertToTimespec(VirtualFrame frame, Node inliningTarget, PTuple times, SequenceNodes.LenNode lenNode, SequenceStorageNodes.GetItemNode getItemNode, ConvertToTimespecBaseNode convertToTimespecBaseNode, PRaiseNode.Lazy raiseNode) {
            if (lenNode.execute(inliningTarget, times) != 2) {
                throw UtimeArgsToTimespecNode.timesTupleError(raiseNode.get(inliningTarget));
            }
            long[] timespec = new long[4];
            convertToTimespecBaseNode.execute(frame, inliningTarget, getItemNode.execute(times.getSequenceStorage(), 0), timespec, 0);
            convertToTimespecBaseNode.execute(frame, inliningTarget, getItemNode.execute(times.getSequenceStorage(), 1), timespec, 2);
            return timespec;
        }
    }

    @Builtin(name="listdir", minNumOfPositionalArgs=0, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"true", "true"})
    @GenerateNodeFactory
    static abstract class ListdirNode
    extends PythonUnaryClinicBuiltinNode {
        ListdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ListdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PList listdirPath(VirtualFrame frame, PosixPath path, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            auditNode.audit(inliningTarget, "os.listdir", path.originalObject == null ? PNone.NONE : path.originalObject);
            try {
                return this.listdir(frame, inliningTarget, posixLib.opendir(this.getPosixSupport(), path.value), path.wasBufferLike, false, posixLib, constructAndRaiseNode, factory);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization
        PList listdirFd(VirtualFrame frame, PosixFd fd, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            auditNode.audit(inliningTarget, "os.listdir", fd.originalObject);
            Object dirStream = PosixModuleBuiltins.dupAndFdopendir(frame, inliningTarget, posixLib, this.getPosixSupport(), fd, constructAndRaiseNode);
            return this.listdir(frame, inliningTarget, dirStream, false, true, posixLib, constructAndRaiseNode, factory);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private PList listdir(VirtualFrame frame, Node inliningTarget, Object dirStream, boolean produceBytes, boolean needsRewind, PosixSupportLibrary posixLib, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PythonObjectFactory factory) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                while (true) {
                    Object dirEntry;
                    if ((dirEntry = posixLib.readdir(this.getPosixSupport(), dirStream)) == null) {
                        PList pList = factory.createList(ListdirNode.listToArray(list));
                        return pList;
                    }
                    Object name = posixLib.dirEntryGetName(this.getPosixSupport(), dirEntry);
                    if (produceBytes) {
                        ListdirNode.addToList(list, PosixModuleBuiltins.opaquePathToBytes(name, posixLib, this.getPosixSupport(), factory));
                        continue;
                    }
                    ListdirNode.addToList(list, posixLib.getPathAsString(this.getPosixSupport(), name));
                    continue;
                    break;
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                if (needsRewind) {
                    posixLib.rewinddir(this.getPosixSupport(), dirStream);
                }
                try {
                    posixLib.closedir(this.getPosixSupport(), dirStream);
                }
                catch (PosixSupportLibrary.PosixException posixException) {}
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void addToList(List<Object> list, Object element) {
            list.add(element);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] listToArray(List<Object> list) {
            return list.toArray();
        }
    }

    @Builtin(name="scandir", minNumOfPositionalArgs=0, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"true", "true"})
    @GenerateNodeFactory
    static abstract class ScandirNode
    extends PythonUnaryClinicBuiltinNode {
        ScandirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ScandirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PScandirIterator scandirPath(VirtualFrame frame, PosixPath path, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            auditNode.audit(inliningTarget, "os.scandir", path.originalObject == null ? PNone.NONE : path.originalObject);
            try {
                return factory.createScandirIterator(this.getContext(), posixLib.opendir(this.getPosixSupport(), path.value), path, false);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization
        PScandirIterator scandirFd(VirtualFrame frame, PosixFd fd, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            auditNode.audit(inliningTarget, "os.scandir", fd.originalObject);
            Object dirStream = PosixModuleBuiltins.dupAndFdopendir(frame, inliningTarget, posixLib, this.getPosixSupport(), fd, constructAndRaiseNode);
            return factory.createScandirIterator(this.getContext(), dirStream, fd, true);
        }
    }

    @Builtin(name="DirEntry", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDirEntry, isPublic=true)
    @GenerateNodeFactory
    static abstract class DirEntryNode
    extends PythonBuiltinNode {
        DirEntryNode() {
        }

        @Specialization
        static Object dirEntry(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "posix.DirEntry");
        }
    }

    @Builtin(name="ScandirIterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PScandirIterator, isPublic=false)
    @GenerateNodeFactory
    static abstract class ScandirIteratorNode
    extends PythonBuiltinNode {
        ScandirIteratorNode() {
        }

        @Specialization
        static Object scandirIterator(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "posix.ScandirIterator");
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class IsattyNode
    extends PythonUnaryClinicBuiltinNode {
        IsattyNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.IsattyNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        boolean isatty(int fd, @Cached GilNode gil, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            gil.release(true);
            try {
                boolean bl = posixLib.isatty(this.getPosixSupport(), fd);
                return bl;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="fchdir", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversionClass=FileDescriptorConversionNode.class)
    @GenerateNodeFactory
    static abstract class FchdirNode
    extends PythonUnaryClinicBuiltinNode {
        FchdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FchdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone fchdir(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            while (true) {
                try {
                    posixLib.fchdir(this.getPosixSupport(), fd);
                    return PNone.NONE;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(this);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="chdir", minNumOfPositionalArgs=1, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"})
    @GenerateNodeFactory
    static abstract class ChdirNode
    extends PythonUnaryClinicBuiltinNode {
        ChdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ChdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone chdirPath(VirtualFrame frame, PosixPath path, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.chdir(this.getPosixSupport(), path.value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }

        @Specialization
        PNone chdirFd(VirtualFrame frame, PosixFd fd, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.fchdir(this.getPosixSupport(), fd.fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getcwdb", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetcwdbNode
    extends PythonBuiltinNode {
        GetcwdbNode() {
        }

        @Specialization
        PBytes getcwdb(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                return PosixModuleBuiltins.opaquePathToBytes(posixLib.getcwd(this.getPosixSupport()), posixLib, this.getPosixSupport(), factory);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getcwd", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetcwdNode
    extends PythonBuiltinNode {
        GetcwdNode() {
        }

        @Specialization
        TruffleString getcwd(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getPathAsString(this.getPosixSupport(), posixLib.getcwd(this.getPosixSupport()));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="rmdir", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class RmdirNode
    extends PythonClinicBuiltinNode {
        RmdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.RmdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone rmdir(VirtualFrame frame, PosixPath path, int dirFd, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.rmdir", path.originalObject, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.unlinkat(this.getPosixSupport(), dirFd, path.value, true);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="mkdir", minNumOfPositionalArgs=1, parameterNames={"path", "mode"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0777"), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class MkdirNode
    extends PythonClinicBuiltinNode {
        MkdirNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.MkdirNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone mkdir(VirtualFrame frame, PosixPath path, int mode, int dirFd, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.mkdir", path.originalObject, mode, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.mkdirat(this.getPosixSupport(), dirFd, path.value, mode);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="symlink", minNumOfPositionalArgs=2, parameterNames={"src", "dst", "target_is_directory"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="target_is_directory", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class SymlinkNode
    extends PythonClinicBuiltinNode {
        SymlinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SymlinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone symlink(VirtualFrame frame, PosixPath src, PosixPath dst, boolean targetIsDir, int dirFd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.symlinkat(this.getPosixSupport(), src.value, dirFd, dst.value);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, src.originalObject, dst.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="link", minNumOfPositionalArgs=2, parameterNames={"src", "dst"}, keywordOnlyNames={"src_dir_fd", "dst_dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="src", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dst", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="src_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="dst_dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class LinkNode
    extends PythonClinicBuiltinNode {
        LinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone link(VirtualFrame frame, PosixPath src, PosixPath dst, int srcDirFd, int dstDirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.linkat(this.getPosixSupport(), srcDirFd, src.value, dstDirFd, dst.value, followSymlinks ? PosixConstants.AT_SYMLINK_FOLLOW.value : 0);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, src.originalObject, dst.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=1, parameterNames={"path"}, varArgsMarker=true, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class RemoveNode
    extends UnlinkNode {
        RemoveNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.RemoveNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="unlink", minNumOfPositionalArgs=1, parameterNames={"path"}, varArgsMarker=true, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class UnlinkNode
    extends PythonClinicBuiltinNode {
        UnlinkNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UnlinkNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone unlink(VirtualFrame frame, PosixPath path, int dirFd, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.remove", path.originalObject, PosixModuleBuiltins.dirFdForAudit(dirFd));
            try {
                posixLib.unlinkat(this.getPosixSupport(), dirFd, path.value, false);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
            return PNone.NONE;
        }
    }

    @Builtins(value={@Builtin(name="uname", minNumOfPositionalArgs=0, os=PythonOS.PLATFORM_LINUX), @Builtin(name="uname", minNumOfPositionalArgs=0, os=PythonOS.PLATFORM_DARWIN)})
    @GenerateNodeFactory
    static abstract class UnameNode
    extends PythonBuiltinNode {
        UnameNode() {
        }

        @Specialization
        PTuple uname(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                return factory.createStructSeq(UNAME_RESULT_DESC, posixLib.uname(this.getPosixSupport()));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="fstatvfs", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class FStatvfsNode
    extends PythonUnaryClinicBuiltinNode {
        FStatvfsNode() {
        }

        @Specialization
        PTuple doStatvfs(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile positiveLongProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            long[] out;
            try {
                out = posixLib.fstatvfs(this.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd);
            }
            return PosixModuleBuiltins.createStatvfsResult(inliningTarget, out, positiveLongProfile, factory);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FStatvfsNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="statvfs", minNumOfPositionalArgs=1, parameterNames={"path"})
    @ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"})
    @GenerateNodeFactory
    static abstract class StatvfsNode
    extends PythonUnaryClinicBuiltinNode {
        StatvfsNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.StatvfsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PTuple doStatvfs(VirtualFrame frame, PosixFileHandle posixFileHandle, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile posixPathProfile, @Cached InlinedConditionProfile positiveLongProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            long[] out;
            try {
                out = posixPathProfile.profile(inliningTarget, posixFileHandle instanceof PosixPath) ? posixLib.statvfs(this.getPosixSupport(), ((PosixPath)posixFileHandle).value) : posixLib.fstatvfs(this.getPosixSupport(), ((PosixFd)posixFileHandle).fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, posixFileHandle.originalObject);
            }
            return PosixModuleBuiltins.createStatvfsResult(inliningTarget, out, positiveLongProfile, factory);
        }
    }

    @Builtin(name="fstat", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class FStatNode
    extends PythonUnaryClinicBuiltinNode {
        FStatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FStatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PTuple doStatFd(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile positiveLongProfile, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            while (true) {
                try {
                    long[] out = posixLib.fstat(this.getPosixSupport(), fd);
                    return PosixModuleBuiltins.createStatResult(inliningTarget, factory, positiveLongProfile, out);
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(this);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="lstat", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    static abstract class LStatNode
    extends PythonClinicBuiltinNode {
        LStatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LStatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PTuple doStatPath(VirtualFrame frame, PosixPath path, int dirFd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile positiveLongProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                long[] out = posixLib.fstatat(this.getPosixSupport(), dirFd, path.value, false);
                return PosixModuleBuiltins.createStatResult(inliningTarget, factory, positiveLongProfile, out);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }
    }

    @Builtin(name="stat", minNumOfPositionalArgs=1, parameterNames={"path"}, keywordOnlyNames={"dir_fd", "follow_symlinks"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class), @ArgumentClinic(name="follow_symlinks", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class StatNode
    extends PythonClinicBuiltinNode {
        StatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.StatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PTuple doStatPath(VirtualFrame frame, PosixPath path, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared(value="positive") @Cached InlinedConditionProfile positiveLongProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                long[] out = posixLib.fstatat(this.getPosixSupport(), dirFd, path.value, followSymlinks);
                return PosixModuleBuiltins.createStatResult(inliningTarget, factory, positiveLongProfile, out);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization(guards={"!isDefault(dirFd)"})
        static PTuple doStatFdWithDirFd(PosixFd fd, int dirFd, boolean followSymlinks, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.CANT_SPECIFY_DIRFD_WITHOUT_PATH, "stat");
        }

        @Specialization(guards={"isDefault(dirFd)", "!followSymlinks"})
        static PTuple doStatFdWithFollowSymlinks(VirtualFrame frame, PosixFd fd, int dirFd, boolean followSymlinks, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_FD_AND_FOLLOW_SYMLINKS_TOGETHER, "stat");
        }

        @Specialization(guards={"isDefault(dirFd)", "followSymlinks"})
        PTuple doStatFd(VirtualFrame frame, PosixFd fd, int dirFd, boolean followSymlinks, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared(value="positive") @Cached InlinedConditionProfile positiveLongProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                long[] out = posixLib.fstat(this.getPosixSupport(), fd.fd);
                return PosixModuleBuiltins.createStatResult(inliningTarget, factory, positiveLongProfile, out);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, fd.originalObject);
            }
        }

        protected static boolean isDefault(int dirFd) {
            return dirFd == PosixConstants.AT_FDCWD.value;
        }
    }

    @Builtin(name="get_terminal_size", minNumOfPositionalArgs=0, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1")
    @GenerateNodeFactory
    static abstract class GetTerminalSizeNode
    extends PythonUnaryClinicBuiltinNode {
        GetTerminalSizeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetTerminalSizeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PTuple getTerminalSize(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                int[] result = posixLib.getTerminalSize(this.getPosixSupport(), fd);
                return factory.createStructSeq(TERMINAL_SIZE_DESC, result[0], result[1]);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="set_blocking", minNumOfPositionalArgs=2, parameterNames={"fd", "blocking"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="blocking", conversion=ArgumentClinic.ClinicConversion.IntToBoolean)})
    @GenerateNodeFactory
    static abstract class SetBlockingNode
    extends PythonBinaryClinicBuiltinNode {
        SetBlockingNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SetBlockingNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone setBlocking(VirtualFrame frame, int fd, boolean blocking, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setBlocking(this.getPosixSupport(), fd, blocking);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="get_blocking", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class GetBlockingNode
    extends PythonUnaryClinicBuiltinNode {
        GetBlockingNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetBlockingNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean getBlocking(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getBlocking(this.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="fsync", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversionClass=FileDescriptorConversionNode.class)
    @GenerateNodeFactory
    static abstract class FSyncNode
    extends PythonUnaryClinicBuiltinNode {
        FSyncNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FSyncNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone fsync(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            while (true) {
                try {
                    posixLib.fsync(this.getPosixSupport(), fd);
                    return PNone.NONE;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(this);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=2, parameterNames={"path", "length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "true"}), @ArgumentClinic(name="length", conversionClass=OffsetConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class TruncateNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.TruncateNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PNone truncate(VirtualFrame frame, PosixPath path, long length, @Bind(value="this") Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.truncate", path.originalObject, length);
            try {
                gil.release(true);
                try {
                    posixLib.truncate(posixSupport, path.value, length);
                }
                finally {
                    gil.acquire();
                }
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
            }
        }

        @Specialization
        static PNone ftruncate(VirtualFrame frame, PosixFd fd, long length, @Bind(value="this") Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached InlinedBranchProfile errorProfile, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            return FtruncateNode.ftruncate(frame, fd.fd, length, inliningTarget, posixSupport, posixLib, auditNode, gil, errorProfile, constructAndRaiseNode);
        }
    }

    @Builtin(name="ftruncate", minNumOfPositionalArgs=2, parameterNames={"fd", "length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="length", conversionClass=OffsetConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class FtruncateNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.FtruncateNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PNone ftruncate(VirtualFrame frame, int fd, long length, @Bind(value="this") Node inliningTarget, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached InlinedBranchProfile errorProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "os.truncate", fd, length);
            while (true) {
                try {
                    gil.release(true);
                    try {
                        posixLib.ftruncate(posixSupport, fd, length);
                    }
                    finally {
                        gil.acquire();
                    }
                    return PNone.NONE;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                break;
            }
        }
    }

    @Builtin(name="lseek", minNumOfPositionalArgs=3, parameterNames={"fd", "pos", "how"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="pos", conversionClass=OffsetConversionNode.class), @ArgumentClinic(name="how", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    public static abstract class LseekNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.LseekNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        long lseek(VirtualFrame frame, int fd, long pos, int how, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.lseek(this.getPosixSupport(), fd, pos, PosixModuleBuiltins.mapPythonSeekWhenceToPosix(how));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="pipe", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class PipeNode
    extends PythonBuiltinNode {
        PipeNode() {
        }

        @Specialization
        PTuple pipe(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached GilNode gil, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            int[] pipe;
            gil.release(true);
            try {
                pipe = posixLib.pipe(this.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                gil.acquire();
            }
            return factory.createTuple(new Object[]{pipe[0], pipe[1]});
        }
    }

    @Builtin(name="set_inheritable", minNumOfPositionalArgs=2, parameterNames={"fd", "inheritable"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="inheritable", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class SetInheritableNode
    extends PythonBinaryClinicBuiltinNode {
        SetInheritableNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SetInheritableNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone setInheritable(VirtualFrame frame, int fd, int inheritable, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setInheritable(this.getPosixSupport(), fd, inheritable != 0);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="get_inheritable", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class GetInheritableNode
    extends PythonUnaryClinicBuiltinNode {
        GetInheritableNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetInheritableNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean getInheritable(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getInheritable(this.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="dup2", minNumOfPositionalArgs=2, parameterNames={"fd", "fd2", "inheritable"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="fd2", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="inheritable", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class Dup2Node
    extends PythonTernaryClinicBuiltinNode {
        Dup2Node() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.Dup2NodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int dup2(VirtualFrame frame, int fd, int fd2, boolean inheritable, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            if (fd < 0 || fd2 < 0) {
                int error = OSErrorEnum.EINVAL.getNumber();
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, error, posixLib.strerror(this.getPosixSupport(), error));
            }
            try {
                return posixLib.dup2(this.getPosixSupport(), fd, fd2, inheritable);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="dup", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class DupNode
    extends PythonUnaryClinicBuiltinNode {
        DupNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.DupNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int dup(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.dup(this.getPosixSupport(), fd);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2, parameterNames={"fd", "data"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)})
    @GenerateNodeFactory
    public static abstract class WriteNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(limit="3")
        static long doWrite(VirtualFrame frame, int fd, Object dataBuffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="dataBuffer") PythonBufferAccessLibrary bufferLib, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                long l = WriteNode.write(fd, bufferLib.getInternalOrCopiedByteArray(dataBuffer), bufferLib.getBufferLength(dataBuffer), inliningTarget, posixLib, errorProfile, gil);
                return l;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                bufferLib.release(dataBuffer, frame, indirectCallData);
            }
        }

        public static long write(int fd, byte[] dataBytes, int dataLen, Node inliningTarget, PosixSupportLibrary posixLib, InlinedBranchProfile errorProfile, GilNode gil) throws PosixSupportLibrary.PosixException {
            gil.release(true);
            while (true) {
                try {
                    long l = posixLib.write(PosixSupport.get(inliningTarget), fd, new PosixSupportLibrary.Buffer(dataBytes, dataLen));
                    return l;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=2, parameterNames={"fd", "length"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    public static abstract class ReadNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PBytes doRead(VirtualFrame frame, int fd, int length, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile1, @Cached InlinedBranchProfile errorProfile2, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            if (length < 0) {
                int error = OSErrorEnum.EINVAL.getNumber();
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, error, posixLib.strerror(this.getPosixSupport(), error));
            }
            try {
                return this.read(fd, length, inliningTarget, posixLib, errorProfile1, gil, factory);
            }
            catch (PosixSupportLibrary.PosixException e) {
                errorProfile2.enter(inliningTarget);
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        public PBytes read(int fd, int length, Node inliningTarget, PosixSupportLibrary posixLib, InlinedBranchProfile errorProfile, GilNode gil, PythonObjectFactory factory) throws PosixSupportLibrary.PosixException {
            gil.release(true);
            while (true) {
                try {
                    PosixSupportLibrary.Buffer result = posixLib.read(this.getPosixSupport(), fd, length);
                    if (result.length > Integer.MAX_VALUE) {
                        throw CompilerDirectives.shouldNotReachHere((String)"Posix read() returned more bytes than requested");
                    }
                    PBytes pBytes = factory.createBytes(result.data, 0, (int)result.length);
                    return pBytes;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(this);
                        continue;
                    }
                    throw e;
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @ArgumentClinic(name="fd", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class CloseNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.CloseNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PNone close(VirtualFrame frame, int fd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                PythonContext ctx = this.getContext();
                if (ctx.getSharedMultiprocessingData().decrementFDRefCount(fd)) {
                    return PNone.NONE;
                }
                gil.release(true);
                try {
                    posixLib.close(this.getPosixSupport(), fd);
                }
                finally {
                    gil.acquire();
                }
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="open", numOfPositionalOnlyArgs=0, minNumOfPositionalArgs=2, parameterNames={"path", "flags", "mode"}, keywordOnlyNames={"dir_fd"})
    @ArgumentsClinic(value={@ArgumentClinic(name="path", conversionClass=PathConversionNode.class, args={"false", "false"}), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0777"), @ArgumentClinic(name="dir_fd", conversionClass=DirFdConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class OpenNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.OpenNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int open(VirtualFrame frame, PosixPath path, int flags, int mode, int dirFd, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached InlinedBranchProfile errorProfile, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int fixedFlags = flags;
            if (PosixConstants.O_CLOEXEC.defined) {
                fixedFlags |= PosixConstants.O_CLOEXEC.getValueIfDefined();
            }
            auditNode.audit(inliningTarget, "open", path.originalObject, PNone.NONE, fixedFlags);
            gil.release(true);
            while (true) {
                try {
                    int n = posixLib.openat(this.getPosixSupport(), dirFd, path.value, fixedFlags, mode);
                    return n;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    errorProfile.enter(inliningTarget);
                    if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(this);
                        continue;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, path.originalObject);
                }
                break;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="openpty")
    @GenerateNodeFactory
    public static abstract class OpenPtyNode
    extends PythonBuiltinNode {
        @Specialization
        Object openpty(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                PosixSupportLibrary.OpenPtyResult result = posixLib.openpty(this.getPosixSupport());
                posixLib.setInheritable(this.getPosixSupport(), result.masterFd(), false);
                posixLib.setInheritable(this.getPosixSupport(), result.slaveFd(), false);
                return factory.createTuple(new int[]{result.masterFd(), result.slaveFd()});
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getgroups")
    @GenerateNodeFactory
    static abstract class GetGroupsNode
    extends PythonBuiltinNode {
        GetGroupsNode() {
        }

        @Specialization
        Object getgroups(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                long[] groups = posixLib.getgroups(this.getPosixSupport());
                return factory.createList(new LongSequenceStorage(groups));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="setsid")
    @GenerateNodeFactory
    public static abstract class SetSidNode
    extends PythonBuiltinNode {
        @Specialization
        Object setsid(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setsid(this.getPosixSupport());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getsid", minNumOfPositionalArgs=1, parameterNames={"pid"})
    @ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class)
    @GenerateNodeFactory
    public static abstract class GetSidNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetSidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        long getSid(VirtualFrame frame, long pid, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getsid(this.getPosixSupport(), pid);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getpgrp", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetPgrpNode
    extends PythonBuiltinNode {
        @Specialization
        long getPpid(@CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getpgrp(this.getPosixSupport());
        }
    }

    @Builtin(name="setpgrp", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class SetPgrpdNode
    extends PythonBuiltinNode {
        @Specialization
        Object getPpid(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setpgid(this.getPosixSupport(), 0L, 0L);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="setpgid", minNumOfPositionalArgs=2, parameterNames={"pid", "pgid"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class), @ArgumentClinic(name="pgid", conversionClass=PidtConversionNode.class)})
    @GenerateNodeFactory
    public static abstract class SetPgidNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.SetPgidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object setPgid(VirtualFrame frame, long pid, long pgid, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setpgid(this.getPosixSupport(), pid, pgid);
                return PNone.NONE;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getpgid", minNumOfPositionalArgs=1, parameterNames={"pid"})
    @ArgumentClinic(name="pid", conversionClass=PidtConversionNode.class)
    @GenerateNodeFactory
    public static abstract class GetPgidNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.GetPgidNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        long getPgid(VirtualFrame frame, long pid, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                return posixLib.getpgid(this.getPosixSupport(), pid);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getloadavg", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetLoadAvgNode
    extends PythonBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        PTuple getloadavg(@Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory) {
            double load = -1.0;
            if (ManagementFactory.getOperatingSystemMXBean() != null) {
                load = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            }
            if (load < 0.0) {
                PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.OSError);
            }
            return factory.createTuple(new Object[]{load, load, load});
        }
    }

    @Builtin(name="getppid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetPpidNode
    extends PythonBuiltinNode {
        @Specialization
        long getPpid(@CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.getppid(this.getPosixSupport());
        }
    }

    @Builtin(name="getegid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetEGidNode
    extends PythonBuiltinNode {
        @Specialization
        long getGid(@CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.getegid(this.getPosixSupport());
        }
    }

    @Builtin(name="getgid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetGidNode
    extends PythonBuiltinNode {
        @Specialization
        long getGid(@CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.getgid(this.getPosixSupport());
        }
    }

    @Builtin(name="geteuid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetEUidNode
    extends PythonBuiltinNode {
        @Specialization
        long getUid(@CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.geteuid(this.getPosixSupport());
        }
    }

    @Builtin(name="getuid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetUidNode
    extends PythonBuiltinNode {
        @Specialization
        long getUid(@CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.getuid(this.getPosixSupport());
        }
    }

    @Builtin(name="getpid", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetPidNode
    extends PythonBuiltinNode {
        @Specialization
        long getPid(@CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            return posixLib.getpid(this.getPosixSupport());
        }
    }

    @Builtin(name="execv", minNumOfPositionalArgs=2, parameterNames={"pathname", "argv"})
    @ArgumentClinic(name="pathname", conversionClass=PathConversionNode.class, args={"false", "false"})
    @GenerateNodeFactory
    public static abstract class ExecvNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.ExecvNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object execvArgsList(VirtualFrame frame, PosixPath path, PList argv, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached.Shared @Cached ObjectToOpaquePathNode toOpaquePathNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            ExecvNode.execv(frame, path, argv, argv.getSequenceStorage(), inliningTarget, posixLib, toArrayNode, toOpaquePathNode, auditNode, gil, constructAndRaiseNode, raiseNode);
            throw CompilerDirectives.shouldNotReachHere((String)"execv should not return normally");
        }

        @Specialization
        static Object execvArgsTuple(VirtualFrame frame, PosixPath path, PTuple argv, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached.Shared @Cached ObjectToOpaquePathNode toOpaquePathNode, @Cached.Shared @Cached SysModuleBuiltins.AuditNode auditNode, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            ExecvNode.execv(frame, path, argv, argv.getSequenceStorage(), inliningTarget, posixLib, toArrayNode, toOpaquePathNode, auditNode, gil, constructAndRaiseNode, raiseNode);
            throw CompilerDirectives.shouldNotReachHere((String)"execv should not return normally");
        }

        @Specialization(guards={"!isList(argv)", "!isPTuple(argv)"})
        static Object execvInvalidArgs(VirtualFrame frame, PosixPath path, Object argv, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S, "execv()", 2, "tuple or list");
        }

        private static void execv(VirtualFrame frame, PosixPath path, Object argv, SequenceStorage argvStorage, Node inliningTarget, PosixSupportLibrary posixLib, SequenceStorageNodes.ToArrayNode toArrayNode, ObjectToOpaquePathNode toOpaquePathNode, SysModuleBuiltins.AuditNode auditNode, GilNode gil, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PRaiseNode.Lazy raiseNode) {
            Object[] args = toArrayNode.execute(inliningTarget, argvStorage);
            if (args.length < 1) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARG_MUST_NOT_BE_EMPTY, "execv()", 2);
            }
            Object[] opaqueArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                opaqueArgs[i] = toOpaquePathNode.execute(frame, inliningTarget, args[i], i == 0);
            }
            auditNode.audit(inliningTarget, "os.exec", path.originalObject, argv, PNone.NONE);
            gil.release(true);
            try {
                posixLib.execv(PosixSupport.get(inliningTarget), path.value, opaqueArgs);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                gil.acquire();
            }
            throw CompilerDirectives.shouldNotReachHere((String)"execv should not return normally");
        }
    }

    @Builtin(name="unsetenv", minNumOfPositionalArgs=1, parameterNames={"name"})
    @ArgumentClinic(name="name", conversionClass=FsConverterNode.class)
    @GenerateNodeFactory
    public static abstract class UnsetenvNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.UnsetenvNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PNone putenv(VirtualFrame frame, PBytes nameBytes, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            byte[] name = toBytesNode.execute(nameBytes);
            Object nameOpaque = UnsetenvNode.checkNull(inliningTarget, posixLib.createPathFromBytes(this.getPosixSupport(), name), raiseNode);
            auditNode.audit(inliningTarget, "os.unsetenv", nameBytes);
            try {
                posixLib.unsetenv(this.getPosixSupport(), nameOpaque);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        private static Object checkNull(Node inliningTarget, Object value, PRaiseNode.Lazy raiseNode) {
            if (value == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return value;
        }
    }

    @Builtin(name="putenv", minNumOfPositionalArgs=2, parameterNames={"name", "value"})
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversionClass=FsConverterNode.class), @ArgumentClinic(name="value", conversionClass=FsConverterNode.class)})
    @GenerateNodeFactory
    public static abstract class PutenvNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixModuleBuiltinsClinicProviders.PutenvNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone putenv(VirtualFrame frame, PBytes nameBytes, PBytes valueBytes, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            byte[] name = toBytesNode.execute(nameBytes);
            byte[] value = toBytesNode.execute(valueBytes);
            PosixSupport posixSupport = PosixSupport.get(inliningTarget);
            Object nameOpaque = PutenvNode.checkNull(inliningTarget, posixLib.createPathFromBytes(posixSupport, name), raiseNode);
            Object valueOpaque = PutenvNode.checkNull(inliningTarget, posixLib.createPathFromBytes(posixSupport, value), raiseNode);
            PutenvNode.checkEqualSign(inliningTarget, name, raiseNode);
            auditNode.audit(inliningTarget, "os.putenv", nameBytes, valueBytes);
            try {
                posixLib.setenv(posixSupport, nameOpaque, valueOpaque, true);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        private static Object checkNull(Node inliningTarget, Object value, PRaiseNode.Lazy raiseNode) {
            if (value == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return value;
        }

        private static void checkEqualSign(Node inliningTarget, byte[] bytes, PRaiseNode.Lazy raiseNode) {
            for (byte b : bytes) {
                if (b != 61) continue;
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ILLEGAL_ENVIRONMENT_VARIABLE_NAME);
            }
        }
    }

    @Builtin(name="statvfs_result", minNumOfPositionalArgs=1, parameterNames={"$cls", "sequence", "dict"}, constructsClass=PythonBuiltinClassType.PStatvfsResult)
    @ImportStatic(value={PosixModuleBuiltins.class})
    @GenerateNodeFactory
    public static abstract class StatvfsResultNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        public static Object generic(VirtualFrame frame, Object cls, Object sequence, Object dict, @Cached(value="create(STATVFS_RESULT_DESC)") StructSequence.NewNode newNode2) {
            return newNode2.execute(frame, cls, sequence, dict);
        }
    }

    @Builtin(name="stat_result", minNumOfPositionalArgs=1, parameterNames={"$cls", "sequence", "dict"}, constructsClass=PythonBuiltinClassType.PStatResult)
    @ImportStatic(value={PosixModuleBuiltins.class})
    @GenerateNodeFactory
    public static abstract class StatResultNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        public static PTuple generic(VirtualFrame frame, Object cls, Object sequence, Object dict, @Cached(value="create(STAT_RESULT_DESC)") StructSequence.NewNode newNode2) {
            PTuple p = (PTuple)newNode2.execute(frame, cls, sequence, dict);
            Object[] data = ((ObjectSequenceStorage)CompilerDirectives.castExact((Object)p.getSequenceStorage(), ObjectSequenceStorage.class)).getInternalObjectArray();
            for (int i = 7; i <= 9; ++i) {
                if (data[i + 3] != PNone.NONE) continue;
                data[i + 3] = data[i];
            }
            return p;
        }
    }
}

