/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.exception;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
public abstract class ValidExceptionNode
extends PNodeWithContext {
    public abstract boolean execute(Frame var1, Object var2);

    protected static boolean isPythonExceptionType(PythonBuiltinClassType type) {
        for (PythonBuiltinClassType base = type; base != null; base = base.getBase()) {
            if (base != PythonBuiltinClassType.PBaseException) continue;
            return true;
        }
        return false;
    }

    @Specialization(guards={"cachedType == type"}, limit="3")
    static boolean isPythonExceptionTypeCached(PythonBuiltinClassType type, @Cached(value="type") PythonBuiltinClassType cachedType, @Cached(value="isPythonExceptionType(type)") boolean isExceptionType) {
        return isExceptionType;
    }

    @Specialization(guards={"cachedType == klass.getType()"}, limit="3")
    static boolean isPythonExceptionClassCached(PythonBuiltinClass klass, @Cached(value="klass.getType()") PythonBuiltinClassType cachedType, @Cached(value="isPythonExceptionType(cachedType)") boolean isExceptionType) {
        return isExceptionType;
    }

    @Specialization(guards={"isTypeNode.execute(inliningTarget, type)"}, limit="1", replaces={"isPythonExceptionTypeCached", "isPythonExceptionClassCached"})
    static boolean isPythonException(VirtualFrame frame, Object type, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached IsSubtypeNode isSubtype) {
        return isSubtype.execute(frame, type, (Object)PythonBuiltinClassType.PBaseException);
    }

    @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, type)"}, limit="1")
    static boolean isForeign(Object type, @Bind(value="this") Node inliningTarget, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop) {
        return interop.isMetaObject(type);
    }

    @Fallback
    static boolean isAnException(Object type) {
        return false;
    }
}

