/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.RaiseNodeGen;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.exception.ValidExceptionNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateInline(value=false)
public abstract class RaiseNode
extends PNodeWithContext {
    public abstract void execute(VirtualFrame var1, Object var2, Object var3, boolean var4);

    @Specialization(guards={"isNoValue(type)"})
    static void reraise(VirtualFrame frame, PNone type, Object cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raise, @Cached ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode, @Cached InlinedConditionProfile hasPException) {
        AbstractTruffleException caughtException = getCaughtExceptionNode.execute(frame);
        if (hasPException.profile(inliningTarget, caughtException instanceof PException)) {
            throw ((PException)caughtException).getExceptionForReraise(rootNodeVisible);
        }
        if (caughtException != null) {
            throw caughtException;
        }
        throw raise.raise(PythonErrorType.RuntimeError, ErrorMessages.NO_ACTIVE_EX_TO_RERAISE);
    }

    @Specialization(guards={"isNoValue(cause)"})
    public static void doRaise(VirtualFrame frame, PBaseException exception, PNone cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget) {
        throw PRaiseNode.raiseExceptionObject(inliningTarget, exception);
    }

    @Specialization(guards={"check.execute(inliningTarget, exception)", "isNoValue(cause)"})
    public static void doRaiseNative(VirtualFrame frame, PythonAbstractNativeObject exception, PNone cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check) {
        throw PRaiseNode.raiseExceptionObject(inliningTarget, exception);
    }

    @Specialization(guards={"!isNoValue(cause)"})
    public static void doRaise(VirtualFrame frame, PBaseException exception, Object cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SetExceptionCauseNode setExceptionCauseNode) {
        setExceptionCauseNode.execute(frame, exception, cause);
        throw PRaiseNode.raiseExceptionObject(inliningTarget, exception);
    }

    @Specialization(guards={"check.execute(inliningTarget, exception)", "!isNoValue(cause)"})
    public static void doRaiseNative(VirtualFrame frame, PythonAbstractNativeObject exception, Object cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyExceptionInstanceCheckNode check, @Cached.Shared @Cached SetExceptionCauseNode setExceptionCauseNode) {
        setExceptionCauseNode.execute(frame, exception, cause);
        throw PRaiseNode.raiseExceptionObject(inliningTarget, exception);
    }

    private static void checkBaseClass(VirtualFrame frame, Node inliningTarget, Object pythonClass, ValidExceptionNode validException, PRaiseNode.Lazy raise, InlinedBranchProfile baseCheckFailedProfile) {
        if (!validException.execute((Frame)frame, pythonClass)) {
            baseCheckFailedProfile.enter(inliningTarget);
            throw RaiseNode.raiseNoException(raise.get(inliningTarget));
        }
    }

    @Specialization(guards={"isTypeNode.execute(this, pythonClass)", "isNoValue(cause)"}, limit="1")
    public static void doRaise(VirtualFrame frame, Object pythonClass, PNone cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached ValidExceptionNode validException, @Cached.Exclusive @Cached CallNode callConstructor, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached.Exclusive @Cached InlinedBranchProfile baseCheckFailedProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raise) {
        RaiseNode.checkBaseClass(frame, inliningTarget, pythonClass, validException, raise, baseCheckFailedProfile);
        Object newException = callConstructor.execute((Frame)frame, pythonClass, new Object[0]);
        if (check.execute(inliningTarget, newException)) {
            throw PRaiseNode.raiseExceptionObject(inliningTarget, newException);
        }
        throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_HAVE_RETURNED_EXCEPTION, pythonClass, newException);
    }

    @Specialization(guards={"isTypeNode.execute(this, pythonClass)", "!isNoValue(cause)"}, limit="1")
    public static void doRaise(VirtualFrame frame, Object pythonClass, Object cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached ValidExceptionNode validException, @Cached.Exclusive @Cached PRaiseNode.Lazy raise, @Cached.Exclusive @Cached CallNode callConstructor, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached.Exclusive @Cached InlinedBranchProfile baseCheckFailedProfile, @Cached.Exclusive @Cached SetExceptionCauseNode setExceptionCauseNode) {
        RaiseNode.checkBaseClass(frame, inliningTarget, pythonClass, validException, raise, baseCheckFailedProfile);
        Object newException = callConstructor.execute((Frame)frame, pythonClass, new Object[0]);
        if (check.execute(inliningTarget, newException)) {
            setExceptionCauseNode.execute(frame, newException, cause);
            throw PRaiseNode.raiseExceptionObject(inliningTarget, newException);
        }
        throw raise.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_HAVE_RETURNED_EXCEPTION, pythonClass, newException);
    }

    @Fallback
    public static void doRaise(VirtualFrame frame, Object exception, Object cause, boolean rootNodeVisible, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") InteropLibrary lib, @Cached.Exclusive @Cached PRaiseNode.Lazy raise) {
        if (lib.isException(exception)) {
            try {
                throw lib.throwException(exception);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        throw RaiseNode.raiseNoException(raise.get(inliningTarget));
    }

    private static PException raiseNoException(PRaiseNode raise) {
        throw raise.raise(PythonErrorType.TypeError, ErrorMessages.EXCEPTIONS_MUST_DERIVE_FROM_BASE_EX);
    }

    public static RaiseNode create() {
        return RaiseNodeGen.create();
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class SetExceptionCauseNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"isNone(cause)"})
        static void setNone(VirtualFrame frame, Object exception, PNone cause, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached ExceptionNodes.SetCauseNode setCauseNode) {
            setCauseNode.execute(inliningTarget, exception, PNone.NONE);
        }

        @Specialization(guards={"check.execute(inliningTarget, cause)"}, limit="1")
        static void setCause(VirtualFrame frame, Object exception, Object cause, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached.Exclusive @Cached ExceptionNodes.SetCauseNode setCauseNode) {
            setCauseNode.execute(inliningTarget, exception, cause);
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, causeClass)"}, limit="1")
        static void setCause(VirtualFrame frame, Object exception, Object causeClass, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached InlinedBranchProfile baseCheckFailedProfile, @Cached.Exclusive @Cached ValidExceptionNode validException, @Cached.Exclusive @Cached CallNode callConstructor, @Cached.Exclusive @Cached PRaiseNode.Lazy raise, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached.Exclusive @Cached ExceptionNodes.SetCauseNode setCauseNode) {
            if (!validException.execute((Frame)frame, causeClass)) {
                baseCheckFailedProfile.enter(inliningTarget);
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXCEPTION_CAUSES_MUST_DERIVE_FROM_BASE_EX);
            }
            Object cause = callConstructor.execute((Frame)frame, causeClass, new Object[0]);
            if (check.execute(inliningTarget, cause)) {
                setCauseNode.execute(inliningTarget, exception, cause);
            } else {
                setCauseNode.execute(inliningTarget, exception, PNone.NONE);
            }
        }

        @Specialization(guards={"!check.execute(inliningTarget, cause)", "!isTypeNode.execute(inliningTarget, cause)"}, limit="1")
        static void setCause(VirtualFrame frame, Object exception, Object cause, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached PyExceptionInstanceCheckNode check, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXCEPTION_CAUSES_MUST_DERIVE_FROM_BASE_EX);
        }
    }
}

