/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.vector;

import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.arrow.ArrowArray;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import sun.misc.Unsafe;

@GenerateCached(value=false)
@GenerateInline
public abstract class VectorToArrowArrayNode
extends PNodeWithContext {
    public abstract ArrowArray execute(Node var1, Object var2);

    @Specialization(guards={"ctx.arrowVectorSupport.isFixedWidthVector(vector)"})
    static ArrowArray doIntVector(Node inliningTarget, Object vector, @Bind(value="getContext(inliningTarget)") PythonContext ctx, @CachedLibrary(limit="3") InteropLibrary interopLib) {
        ArrowArray.Snapshot snapshot = new ArrowArray.Snapshot();
        Unsafe unsafe = ctx.getUnsafe();
        try {
            snapshot.length = ((Integer)interopLib.invokeMember(vector, "getValueCount", new Object[0])).intValue();
            snapshot.null_count = ((Integer)interopLib.invokeMember(vector, "getNullCount", new Object[0])).intValue();
            snapshot.n_buffers = ((Integer)interopLib.invokeMember(vector, "getExportedCDataBufferCount", new Object[0])).intValue();
            if (snapshot.n_buffers != 2L) {
                throw CompilerDirectives.shouldNotReachHere((String)"We expect that Vector implementation to has just 2 buffers, those are validity buffer and value buffer. This should never happen unless arrow changes internally");
            }
            snapshot.buffers = unsafe.allocateMemory(16L);
            long validityPointer = (Long)interopLib.invokeMember(vector, "getValidityBufferAddress", new Object[0]);
            unsafe.putLong(snapshot.buffers, validityPointer);
            long dataPointer = (Long)interopLib.invokeMember(vector, "getDataBufferAddress", new Object[0]);
            unsafe.putLong(snapshot.buffers + 8L, dataPointer);
            snapshot.release = ctx.arrowVectorSupport.getVectorArrowArrayReleaseCallback();
            return ArrowArray.allocateFromSnapshot(snapshot);
        }
        catch (Exception e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Unable to convert vector to arrow array. Error: " + e.getMessage()));
        }
    }

    @Fallback
    static ArrowArray doError(Node inliningTarget, Object object) {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

