/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class PyObjectRichCompareBool {

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GeNode
    extends ComparisonBaseNode {
        public static final GeComparison CMP = new GeComparison();

        @Override
        public final boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            return this.execute(frame, inliningTarget, a, b, CMP);
        }

        @Specialization(insertBefore="doGeneric")
        static boolean doSS(TruffleString a, TruffleString b, Comparison cmp, @Cached(inline=false) TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(a, b, compareIntsUTF32Node) >= 0;
        }

        private static final class GeComparison
        extends Comparison {
            private GeComparison() {
            }

            @Override
            protected boolean op(boolean a, boolean b) {
                return a || !b;
            }

            @Override
            protected boolean op(int a, int b) {
                return a >= b;
            }

            @Override
            protected boolean op(long a, long b) {
                return a >= b;
            }

            @Override
            protected boolean op(double a, double b) {
                return a >= b;
            }

            @Override
            protected SpecialMethodSlot getSlot() {
                return SpecialMethodSlot.Ge;
            }

            @Override
            protected SpecialMethodSlot getReverseSlot() {
                return SpecialMethodSlot.Le;
            }

            @Override
            protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, ">=", a, b);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GtNode
    extends ComparisonBaseNode {
        public static final GtComparison CMP = new GtComparison();

        @Override
        public final boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            return this.execute(frame, inliningTarget, a, b, CMP);
        }

        @Specialization(insertBefore="doGeneric")
        static boolean doSS(TruffleString a, TruffleString b, Comparison cmp, @Cached(inline=false) TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(a, b, compareIntsUTF32Node) > 0;
        }

        private static final class GtComparison
        extends Comparison {
            private GtComparison() {
            }

            @Override
            protected boolean op(boolean a, boolean b) {
                return a && !b;
            }

            @Override
            protected boolean op(int a, int b) {
                return a > b;
            }

            @Override
            protected boolean op(long a, long b) {
                return a > b;
            }

            @Override
            protected boolean op(double a, double b) {
                return a > b;
            }

            @Override
            protected SpecialMethodSlot getSlot() {
                return SpecialMethodSlot.Gt;
            }

            @Override
            protected SpecialMethodSlot getReverseSlot() {
                return SpecialMethodSlot.Lt;
            }

            @Override
            protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, ">", a, b);
            }
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class LeNode
    extends ComparisonBaseNode {
        public static final LeComparison CMP = new LeComparison();

        @Override
        public final boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            return this.execute(frame, inliningTarget, a, b, CMP);
        }

        @Specialization(insertBefore="doGeneric")
        static boolean doSS(TruffleString a, TruffleString b, Comparison cmp, @Cached(inline=false) TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(a, b, compareIntsUTF32Node) <= 0;
        }

        private static final class LeComparison
        extends Comparison {
            private LeComparison() {
            }

            @Override
            protected boolean op(boolean a, boolean b) {
                return b || !a;
            }

            @Override
            protected boolean op(int a, int b) {
                return a <= b;
            }

            @Override
            protected boolean op(long a, long b) {
                return a <= b;
            }

            @Override
            protected boolean op(double a, double b) {
                return a <= b;
            }

            @Override
            protected SpecialMethodSlot getSlot() {
                return SpecialMethodSlot.Le;
            }

            @Override
            protected SpecialMethodSlot getReverseSlot() {
                return SpecialMethodSlot.Ge;
            }

            @Override
            protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, "<=", a, b);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class LtNode
    extends ComparisonBaseNode {
        public static final LtComparison CMP = new LtComparison();

        @Override
        public boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            return this.execute(frame, inliningTarget, a, b, CMP);
        }

        @Specialization(insertBefore="doGeneric")
        static boolean doSS(TruffleString a, TruffleString b, Comparison cmp, @Cached(inline=false) TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(a, b, compareIntsUTF32Node) < 0;
        }

        private static final class LtComparison
        extends Comparison {
            private LtComparison() {
            }

            @Override
            protected boolean op(boolean a, boolean b) {
                return !a && b;
            }

            @Override
            protected boolean op(int a, int b) {
                return a < b;
            }

            @Override
            protected boolean op(long a, long b) {
                return a < b;
            }

            @Override
            protected boolean op(double a, double b) {
                return a < b;
            }

            @Override
            protected SpecialMethodSlot getSlot() {
                return SpecialMethodSlot.Lt;
            }

            @Override
            protected SpecialMethodSlot getReverseSlot() {
                return SpecialMethodSlot.Gt;
            }

            @Override
            protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, "<", a, b);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NeNode
    extends ComparisonBaseNode {
        private static final NeComparison CMP = new NeComparison();

        @Override
        public final boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            return this.execute(frame, inliningTarget, a, b, CMP);
        }

        @Specialization(insertBefore="doGeneric")
        static boolean doSS(TruffleString a, TruffleString b, Comparison cmp, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            return !equalNode.execute((AbstractTruffleString)a, (AbstractTruffleString)b, PythonUtils.TS_ENCODING);
        }

        private static final class NeComparison
        extends Comparison {
            private NeComparison() {
            }

            @Override
            protected boolean op(boolean a, boolean b) {
                return a != b;
            }

            @Override
            protected boolean op(int a, int b) {
                return a != b;
            }

            @Override
            protected boolean op(long a, long b) {
                return a != b;
            }

            @Override
            protected boolean op(double a, double b) {
                return a != b;
            }

            @Override
            protected SpecialMethodSlot getSlot() {
                return SpecialMethodSlot.Ne;
            }

            @Override
            protected SpecialMethodSlot getReverseSlot() {
                return SpecialMethodSlot.Ne;
            }

            @Override
            protected boolean needsIdentityComparison() {
                return true;
            }

            @Override
            protected boolean identityComparisonResult() {
                return false;
            }

            @Override
            protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
                return true;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class EqNode
    extends ComparisonBaseNode {
        private static final EqComparison CMP = new EqComparison();

        public final boolean compareCached(Frame frame, Object a, Object b) {
            return this.compare(frame, this, a, b);
        }

        @Override
        public final boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            return this.execute(frame, inliningTarget, a, b, CMP);
        }

        public static boolean compareUncached(Object a, Object b) {
            return PyObjectRichCompareBoolFactory.EqNodeGen.getUncached().compare(null, null, a, b);
        }

        @Specialization(insertBefore="doGeneric")
        @HostCompilerDirectives.InliningCutoff
        static boolean doSS(TruffleString a, TruffleString b, Comparison cmp, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)a, (AbstractTruffleString)b, PythonUtils.TS_ENCODING);
        }

        @NeverDefault
        public static EqNode create() {
            return PyObjectRichCompareBoolFactory.EqNodeGen.create();
        }

        public static EqNode getUncached() {
            return PyObjectRichCompareBoolFactory.EqNodeGen.getUncached();
        }

        private static final class EqComparison
        extends Comparison {
            private EqComparison() {
            }

            @Override
            protected boolean op(boolean a, boolean b) {
                return a == b;
            }

            @Override
            protected boolean op(int a, int b) {
                return a == b;
            }

            @Override
            protected boolean op(long a, long b) {
                return a == b;
            }

            @Override
            protected boolean op(double a, double b) {
                return a == b || Double.isNaN(a) && Double.isNaN(b);
            }

            @Override
            protected SpecialMethodSlot getSlot() {
                return SpecialMethodSlot.Eq;
            }

            @Override
            protected SpecialMethodSlot getReverseSlot() {
                return SpecialMethodSlot.Eq;
            }

            @Override
            protected boolean needsIdentityComparison() {
                return true;
            }

            @Override
            protected boolean identityComparisonResult() {
                return true;
            }

            @Override
            protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
                return false;
            }
        }
    }

    @GenerateCached(value=false)
    @GenerateInline(value=false)
    @GenerateUncached(value=false)
    public static abstract class ComparisonBaseNode
    extends PNodeWithContext {
        public boolean compare(Frame frame, Node inliningTarget, Object a, Object b) {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected abstract boolean execute(Frame var1, Node var2, Object var3, Object var4, Comparison var5);

        @Specialization
        static boolean doBB(boolean a, boolean b, Comparison cmp) {
            return cmp.op(a, b);
        }

        @Specialization
        static boolean doII(int a, int b, Comparison cmp) {
            return cmp.op(a, b);
        }

        @Specialization
        static boolean doIL(int a, long b, Comparison cmp) {
            return cmp.op((long)a, b);
        }

        @Specialization
        static boolean doID(int a, double b, Comparison cmp) {
            return cmp.op((double)a, b);
        }

        @Specialization(guards={"isBuiltinPInt(b)"}, rewriteOn={OverflowException.class})
        static boolean doIPNoOVerflow(int a, PInt b, Comparison cmp) throws OverflowException {
            return cmp.op(a, b.intValueExact());
        }

        @Specialization(guards={"isBuiltinPInt(b)"}, replaces={"doIPNoOVerflow"})
        static boolean doIP(int a, PInt b, Comparison cmp) {
            try {
                return cmp.op(a, b.intValueExact());
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization
        static boolean doLL(long a, long b, Comparison cmp) {
            return cmp.op(a, b);
        }

        @Specialization
        static boolean doLI(long a, int b, Comparison cmp) {
            return cmp.op(a, (long)b);
        }

        @Specialization
        static boolean doLD(long a, double b, Comparison cmp) {
            return cmp.op((double)a, b);
        }

        @Specialization(guards={"isBuiltinPInt(b)"}, rewriteOn={OverflowException.class})
        static boolean doLPNoOVerflow(long a, PInt b, Comparison cmp) throws OverflowException {
            return cmp.op(a, b.longValueExact());
        }

        @Specialization(guards={"isBuiltinPInt(b)"}, replaces={"doLPNoOVerflow"})
        static boolean doLP(long a, PInt b, Comparison cmp) {
            try {
                return cmp.op(a, b.longValueExact());
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization(guards={"isBuiltinPInt(a)"}, rewriteOn={OverflowException.class})
        static boolean doPINoOverflow(PInt a, int b, Comparison cmp) throws OverflowException {
            return cmp.op(a.intValueExact(), b);
        }

        @Specialization(guards={"isBuiltinPInt(a)"}, replaces={"doPINoOverflow"})
        static boolean doPI(PInt a, int b, Comparison cmp) {
            try {
                return cmp.op(a.intValueExact(), b);
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization(guards={"isBuiltinPInt(a)"}, rewriteOn={OverflowException.class})
        static boolean doPLNoOverflow(PInt a, long b, Comparison cmp) throws OverflowException {
            return cmp.op(a.longValueExact(), b);
        }

        @Specialization(guards={"isBuiltinPInt(a)"}, replaces={"doPLNoOverflow"})
        static boolean doPL(PInt a, long b, Comparison cmp) {
            try {
                return cmp.op(a.longValueExact(), b);
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization(guards={"isBuiltinPInt(a)", "isBuiltinPInt(b)"})
        @CompilerDirectives.TruffleBoundary
        static boolean doPP(PInt a, PInt b, Comparison cmp) {
            return cmp.op(a.compareTo(b), 0);
        }

        @Specialization
        static boolean doDD(double a, double b, Comparison cmp) {
            return cmp.op(a, b);
        }

        @Specialization
        static boolean doDI(double a, int b, Comparison cmp) {
            return cmp.op(a, (double)b);
        }

        @Specialization
        static boolean doDL(double a, long b, Comparison cmp) {
            return cmp.op(a, (double)b);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static boolean doGeneric(VirtualFrame frame, Node inliningTarget, Object a, Object b, Comparison cmp, @Cached(inline=false) IsNode isNode, @Cached GetClassNode getClassA, @Cached GetClassNode getClassB, @Cached InlinedConditionProfile reversedFirst, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached(parameters={"cmp.getSlot()"}, inline=false) LookupSpecialMethodSlotNode lookupMethod, @Cached(parameters={"cmp.getReverseSlot()"}, inline=false) LookupSpecialMethodSlotNode lookupReverseMethod, @Cached(inline=false) CallBinaryMethodNode callMethod, @Cached(inline=false) CallBinaryMethodNode callReverseMethod, @Cached PyObjectIsTrueNode isTrueNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object result;
            Object reverseMethod;
            Object method;
            Object result2;
            Object bType;
            if (cmp.needsIdentityComparison() && isNode.execute(a, b)) {
                return cmp.identityComparisonResult();
            }
            boolean checkedReverseOp = false;
            Object aType = getClassA.execute(inliningTarget, a);
            if (reversedFirst.profile(inliningTarget, !isSameTypeNode.execute(inliningTarget, aType, bType = getClassB.execute(inliningTarget, b)) && isSubtypeNode.execute(bType, aType))) {
                checkedReverseOp = true;
                Object reverseMethod2 = ComparisonBaseNode.lookupMethodIgnoreDescriptorError(frame, lookupReverseMethod, bType, b);
                if (reverseMethod2 != PNone.NO_VALUE && (result2 = callReverseMethod.executeObject((Frame)frame, reverseMethod2, b, a)) != PNotImplemented.NOT_IMPLEMENTED) {
                    return isTrueNode.execute((Frame)frame, inliningTarget, result2);
                }
            }
            if ((method = ComparisonBaseNode.lookupMethodIgnoreDescriptorError(frame, lookupMethod, aType, a)) != PNone.NO_VALUE && (result2 = callMethod.executeObject((Frame)frame, method, a, b)) != PNotImplemented.NOT_IMPLEMENTED) {
                return isTrueNode.execute((Frame)frame, inliningTarget, result2);
            }
            if (!checkedReverseOp && (reverseMethod = ComparisonBaseNode.lookupMethodIgnoreDescriptorError(frame, lookupReverseMethod, bType, b)) != PNone.NO_VALUE && (result = callReverseMethod.executeObject((Frame)frame, reverseMethod, b, a)) != PNotImplemented.NOT_IMPLEMENTED) {
                return isTrueNode.execute((Frame)frame, inliningTarget, result);
            }
            return cmp.doDefault(inliningTarget, raiseNode, a, b);
        }

        private static Object lookupMethodIgnoreDescriptorError(VirtualFrame frame, LookupSpecialMethodSlotNode lookupMethod, Object aType, Object a) {
            try {
                return lookupMethod.execute((Frame)frame, aType, a);
            }
            catch (PException e) {
                return PNone.NO_VALUE;
            }
        }
    }

    public static abstract class Comparison {
        protected boolean op(boolean a, boolean b) {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected boolean op(int a, int b) {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected boolean op(long a, long b) {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected boolean op(double a, double b) {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected SpecialMethodSlot getSlot() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected SpecialMethodSlot getReverseSlot() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected boolean needsIdentityComparison() {
            return false;
        }

        protected boolean identityComparisonResult() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }

        protected boolean doDefault(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object a, Object b) {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract method");
        }
    }
}

