/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.socket;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.socket.SocketNodesFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyTimeFromObjectNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public abstract class SocketNodes {

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class ParseTimeoutNode
    extends Node {
        public abstract long execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization(guards={"isNone(none)"})
        static long parse(PNone none) {
            return -1L;
        }

        @Specialization(guards={"!isNone(seconds)"})
        static long parse(VirtualFrame frame, Node inliningTarget, Object seconds, @Cached PyTimeFromObjectNode timeFromObjectNode, @Cached PRaiseNode.Lazy raiseNode) {
            long timeout = timeFromObjectNode.execute(frame, inliningTarget, seconds, PyTimeFromObjectNode.RoundType.TIMEOUT, 1000000000L);
            if (timeout < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.TIMEOUT_VALUE_OUT_OF_RANGE);
            }
            return timeout;
        }
    }

    public static abstract class IdnaFromStringOrBytesConverterNode
    extends Node {
        private final String builtinName;
        private final int argumentIndex;

        public IdnaFromStringOrBytesConverterNode(String builtinName, int argumentIndex) {
            this.builtinName = builtinName;
            this.argumentIndex = argumentIndex;
        }

        public abstract byte[] execute(VirtualFrame var1, Object var2);

        @Specialization
        byte[] convert(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached BytesNodes.BytesLikeCheck bytesLikeCheck, @Cached CastToTruffleStringNode castToString, @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached CodecsModuleBuiltins.EncodeNode encodeNode, @Cached PRaiseNode.Lazy raise) {
            Object bytes;
            if (unicodeCheckNode.execute(inliningTarget, value)) {
                TruffleString string = castToString.execute(inliningTarget, value);
                if (getCodeRangeNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII) {
                    return copyToByteArrayNode.execute((AbstractTruffleString)switchEncodingNode.execute((AbstractTruffleString)string, TruffleString.Encoding.US_ASCII), TruffleString.Encoding.US_ASCII);
                }
                bytes = encodeNode.execute(frame, value, StringLiterals.T_IDNA, StringLiterals.T_STRICT);
            } else if (bytesLikeCheck.execute(inliningTarget, value)) {
                bytes = value;
            } else {
                if (this.builtinName != null) {
                    throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_BYTELIKE_OR_BYTEARRAY, this.builtinName, this.argumentIndex, value);
                }
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.STR_BYTES_OR_BYTEARRAY_EXPECTED, value);
            }
            return bufferLib.getCopiedByteArray(bytes);
        }

        @NeverDefault
        public static IdnaFromStringOrBytesConverterNode create(String builtinName, int argumentIndex) {
            return SocketNodesFactory.IdnaFromStringOrBytesConverterNodeGen.create(builtinName, argumentIndex);
        }

        @NeverDefault
        public static IdnaFromStringOrBytesConverterNode create() {
            return SocketNodesFactory.IdnaFromStringOrBytesConverterNodeGen.create(null, 0);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MakeIpAddrNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, PosixSupportLibrary.UniversalSockAddr var3);

        @Specialization(limit="1")
        static Object makeAddr(VirtualFrame frame, Node inliningTarget, PosixSupportLibrary.UniversalSockAddr addr, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(value="addr") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PythonContext context = PythonContext.get(inliningTarget);
                int family = addrLib.getFamily(addr);
                if (family == PosixConstants.AF_INET.value) {
                    PosixSupportLibrary.Inet4SockAddr inet4SockAddr = addrLib.asInet4SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    return posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet4SockAddr.getAddressAsBytes()));
                }
                if (family == PosixConstants.AF_INET6.value) {
                    PosixSupportLibrary.Inet6SockAddr inet6SockAddr = addrLib.asInet6SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    return posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet6SockAddr.getAddress()));
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("makesockaddr: unknown address family"));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING));
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MakeSockAddrNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, PosixSupportLibrary.UniversalSockAddr var3);

        @Specialization(limit="1")
        static Object makeSockAddr(VirtualFrame frame, Node inliningTarget, PosixSupportLibrary.UniversalSockAddr addr, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(value="addr") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @Cached(inline=false) PythonObjectFactory factory, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode, @Cached(inline=false) TruffleString.FromByteArrayNode fromByteArrayNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PythonContext context = PythonContext.get(inliningTarget);
                int family = addrLib.getFamily(addr);
                if (family == PosixConstants.AF_INET.value) {
                    PosixSupportLibrary.Inet4SockAddr inet4SockAddr = addrLib.asInet4SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    TruffleString addressString = posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet4SockAddr.getAddressAsBytes()));
                    return factory.createTuple(new Object[]{addressString, inet4SockAddr.getPort()});
                }
                if (family == PosixConstants.AF_INET6.value) {
                    PosixSupportLibrary.Inet6SockAddr inet6SockAddr = addrLib.asInet6SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    TruffleString addressString = posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet6SockAddr.getAddress()));
                    return factory.createTuple(new Object[]{addressString, inet6SockAddr.getPort(), inet6SockAddr.getFlowInfo(), inet6SockAddr.getScopeId()});
                }
                if (family == PosixConstants.AF_UNIX.value) {
                    PosixSupportLibrary.UnixSockAddr unixSockAddr = addrLib.asUnixSockAddr(addr);
                    byte[] path = unixSockAddr.getPath();
                    if (PosixConstants.IS_LINUX && path.length > 0 && path[0] == 0) {
                        return factory.createBytes(PythonUtils.arrayCopyOf(path, path.length));
                    }
                    return MakeSockAddrNode.bytesToString(path, fromByteArrayNode, switchEncodingNode);
                }
                if (family == PosixConstants.AF_UNSPEC.value) {
                    return PNone.NONE;
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("makesockaddr: unknown address family"));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING));
            }
        }

        private static TruffleString bytesToString(byte[] path, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
            int len;
            for (len = 0; len < path.length && path[len] != 0; ++len) {
            }
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(path, 0, len, TruffleString.Encoding.UTF_8, true), PythonUtils.TS_ENCODING);
        }
    }

    public static abstract class SetIpAddrNode
    extends Node {
        private static final byte[] BROADCAST_IP = "255.255.255.255".getBytes();
        private static final byte[] BROADCAST = "<broadcast>".getBytes();

        public abstract PosixSupportLibrary.UniversalSockAddr execute(VirtualFrame var1, byte[] var2, int var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Specialization
        static PosixSupportLibrary.UniversalSockAddr setipaddr(VirtualFrame frame, byte[] name, int family, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary addrInfoLib, @Cached InetPtoNCachedPNode inetPtoNCachedPNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            PosixSupport posixSupport = context.getPosixSupport();
            try {
                byte[] bytes;
                if (name.length == 0) {
                    gil.release(true);
                    try {
                        PosixSupportLibrary.AddrInfoCursor cursor = posixLib.getaddrinfo(posixSupport, null, posixLib.createPathFromString(posixSupport, StringLiterals.T_ZERO), family, PosixConstants.SOCK_DGRAM.value, 0, PosixConstants.AI_PASSIVE.value);
                        try {
                            if (addrInfoLib.next(cursor)) {
                                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.WILD_CARD_RESOLVED_TO_MULTIPLE_ADDRESS);
                            }
                            PosixSupportLibrary.UniversalSockAddr universalSockAddr = addrInfoLib.getSockAddr(cursor);
                            addrInfoLib.release(cursor);
                            return universalSockAddr;
                        }
                        catch (Throwable throwable) {
                            addrInfoLib.release(cursor);
                            throw throwable;
                        }
                    }
                    finally {
                        gil.acquire();
                    }
                }
                if (Arrays.equals(name, BROADCAST_IP) || Arrays.equals(name, BROADCAST)) {
                    if (family != PosixConstants.AF_INET.value && family != PosixConstants.AF_UNSPEC.value) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.ADDRESS_FAMILY_MISMATCHED);
                    }
                    return posixLib.createUniversalSockAddrInet4(posixSupport, new PosixSupportLibrary.Inet4SockAddr(0, PosixConstants.INADDR_BROADCAST.value));
                }
                if ((family == PosixConstants.AF_INET.value || family == PosixConstants.AF_UNSPEC.value) && (bytes = inetPtoNCachedPNode.execute(inliningTarget, posixLib, posixSupport, PosixConstants.AF_INET.value, name)) != null) {
                    return posixLib.createUniversalSockAddrInet4(posixSupport, new PosixSupportLibrary.Inet4SockAddr(0, bytes));
                }
                if (!(family != PosixConstants.AF_INET6.value && family != PosixConstants.AF_UNSPEC.value || SetIpAddrNode.hasScopeId(name) || (bytes = inetPtoNCachedPNode.execute(inliningTarget, posixLib, posixSupport, PosixConstants.AF_INET6.value, name)) == null)) {
                    return posixLib.createUniversalSockAddrInet6(posixSupport, new PosixSupportLibrary.Inet6SockAddr(0, bytes, 0, 0));
                }
                gil.release(true);
                try {
                    PosixSupportLibrary.AddrInfoCursor cursor = posixLib.getaddrinfo(posixSupport, posixLib.createPathFromBytes(posixSupport, name), null, family, 0, 0, 0);
                    try {
                        PosixSupportLibrary.UniversalSockAddr universalSockAddr = addrInfoLib.getSockAddr(cursor);
                        addrInfoLib.release(cursor);
                        return universalSockAddr;
                    }
                    catch (Throwable throwable) {
                        addrInfoLib.release(cursor);
                        throw throwable;
                    }
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.GetAddrInfoException e) {
                throw constructAndRaiseNode.get(inliningTarget).executeWithArgsOnly((Frame)frame, PythonBuiltinClassType.SocketGAIError, new Object[]{e.getErrorCode(), e.getMessage()});
            }
        }

        private static boolean hasScopeId(byte[] name) {
            for (byte b : name) {
                if (b != 37) continue;
                return true;
            }
            return false;
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={Arrays.class})
        static abstract class InetPtoNCachedPNode
        extends Node {
            InetPtoNCachedPNode() {
            }

            abstract byte[] execute(Node var1, PosixSupportLibrary var2, Object var3, int var4, byte[] var5);

            @Specialization(guards={"family == cachedFamily", "equals(string, cachedString)"}, limit="3")
            static byte[] cached(PosixSupportLibrary posixLib, Object posixSupport, int family, byte[] string, @Cached(value="family") int cachedFamily, @Cached(value="string", dimensions=1) byte[] cachedString, @Cached(value="doParse(posixLib, posixSupport, family, string)", dimensions=1) byte[] cachedResult) {
                return cachedResult;
            }

            @Specialization(replaces={"cached"})
            static byte[] doParse(PosixSupportLibrary posixLib, Object posixSupport, int family, byte[] string) {
                assert (family == PosixConstants.AF_INET.value || family == PosixConstants.AF_INET6.value);
                try {
                    return posixLib.inet_pton(posixSupport, family, posixLib.createPathFromBytes(posixSupport, string));
                }
                catch (PosixSupportLibrary.InvalidAddressException | PosixSupportLibrary.PosixException e) {
                    return null;
                }
            }
        }
    }

    @GenerateInline(value=false)
    public static abstract class GetSockAddrArgNode
    extends Node {
        public abstract PosixSupportLibrary.UniversalSockAddr execute(VirtualFrame var1, PSocket var2, Object var3, String var4);

        @Specialization(guards={"isInet(socket)"})
        static PosixSupportLibrary.UniversalSockAddr doInet(VirtualFrame frame, PSocket socket, Object address, String caller, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") @Cached.Shared(value="posixLib") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") @Cached.Shared(value="sockAddrLib") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLib, @Cached @Cached.Shared(value="getObjectArray") SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached @Cached.Shared(value="asInt") PyLongAsIntNode asIntNode, @Cached @Cached.Shared(value="idnaConverter") IdnaFromStringOrBytesConverterNode idnaConverter, @Cached @Cached.Shared(value="errorProfile") BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached @Cached.Shared(value="setIpAddr") SetIpAddrNode setIpAddrNode, @Cached @Cached.Shared PRaiseNode.Lazy raiseNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            if (!(address instanceof PTuple)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_AF_INET_VALUES_MUST_BE_TUPLE_NOT_P, caller, address);
            }
            Object[] hostAndPort = getObjectArrayNode.execute(inliningTarget, address);
            if (hostAndPort.length != 2) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.AF_INET_VALUES_MUST_BE_PAIR);
            }
            byte[] host = idnaConverter.execute(frame, hostAndPort[0]);
            int port = GetSockAddrArgNode.parsePort(frame, caller, asIntNode, inliningTarget, errorProfile, hostAndPort[1], raiseNode);
            PosixSupportLibrary.UniversalSockAddr addr = setIpAddrNode.execute(frame, host, PosixConstants.AF_INET.value);
            PosixSupport posixSupport = context.getPosixSupport();
            return posixLib.createUniversalSockAddrInet4(posixSupport, new PosixSupportLibrary.Inet4SockAddr(port, sockAddrLib.asInet4SockAddr(addr).getAddress()));
        }

        @Specialization(guards={"isInet6(socket)"})
        static PosixSupportLibrary.UniversalSockAddr doInet6(VirtualFrame frame, PSocket socket, Object address, String caller, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") @Cached.Shared(value="posixLib") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") @Cached.Shared(value="sockAddrLib") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLib, @Cached @Cached.Shared(value="getObjectArray") SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached @Cached.Shared(value="asInt") PyLongAsIntNode asIntNode, @Cached @Cached.Shared(value="idnaConverter") IdnaFromStringOrBytesConverterNode idnaConverter, @Cached @Cached.Shared(value="errorProfile") BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached @Cached.Shared(value="setIpAddr") SetIpAddrNode setIpAddrNode, @Cached @Cached.Shared PRaiseNode.Lazy raiseNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            if (!(address instanceof PTuple)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_AF_INET_VALUES_MUST_BE_TUPLE_NOT_S, caller, address);
            }
            Object[] hostAndPort = getObjectArrayNode.execute(inliningTarget, address);
            if (hostAndPort.length < 2 || hostAndPort.length > 4) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.AF_INET6_ADDR_MUST_BE_TUPLE);
            }
            byte[] host = idnaConverter.execute(frame, hostAndPort[0]);
            int port = GetSockAddrArgNode.parsePort(frame, caller, asIntNode, inliningTarget, errorProfile, hostAndPort[1], raiseNode);
            int flowinfo = 0;
            if (hostAndPort.length > 2 && ((flowinfo = asIntNode.execute((Frame)frame, inliningTarget, hostAndPort[2])) < 0 || flowinfo > 1048575)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_FLOWINFO_RANGE, caller);
            }
            int scopeid = 0;
            if (hostAndPort.length > 3) {
                scopeid = asIntNode.execute((Frame)frame, inliningTarget, hostAndPort[3]);
            }
            PosixSupportLibrary.UniversalSockAddr addr = setIpAddrNode.execute(frame, host, PosixConstants.AF_INET6.value);
            PosixSupport posixSupport = context.getPosixSupport();
            return posixLib.createUniversalSockAddrInet6(posixSupport, new PosixSupportLibrary.Inet6SockAddr(port, sockAddrLib.asInet6SockAddr(addr).getAddress(), flowinfo, scopeid));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isUnix(socket)"})
        static PosixSupportLibrary.UniversalSockAddr doUnix(VirtualFrame frame, PSocket socket, Object address, String caller, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @CachedLibrary(limit="1") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(limit="1") @Cached.Shared(value="posixLib") PosixSupportLibrary posixLib, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            byte[] path;
            if (unicodeCheckNode.execute(inliningTarget, address)) {
                TruffleString utf8 = switchEncodingNode.execute((AbstractTruffleString)toTruffleStringNode.execute(inliningTarget, address), TruffleString.Encoding.UTF_8);
                path = copyToByteArrayNode.execute((AbstractTruffleString)utf8, TruffleString.Encoding.UTF_8);
            } else {
                Object buffer = bufferAcquireLib.acquireReadonly(address, frame, indirectCallData);
                try {
                    path = bufferLib.getCopiedByteArray(buffer);
                }
                finally {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
            }
            if (!PosixConstants.IS_LINUX || path.length > 0 && path[0] != 0) {
                path = PythonUtils.arrayCopyOf(path, path.length + 1);
            }
            PythonContext context = PythonContext.get(inliningTarget);
            PosixSupport posixSupport = context.getPosixSupport();
            try {
                return posixLib.createUniversalSockAddrUnix(posixSupport, new PosixSupportLibrary.UnixSockAddr(path));
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.AF_UNIX_NOT_SUPPORTED, caller);
            }
            catch (PosixSupportLibrary.InvalidUnixSocketPathException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.AF_UNIX_PATH_TOO_LONG, caller);
            }
        }

        @Specialization(guards={"!isInet(socket)", "!isInet6(socket)", "!isUnix(socket)"})
        static PosixSupportLibrary.UniversalSockAddr getSockAddr(VirtualFrame frame, PSocket socket, Object address, String caller, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.OSError, ErrorMessages.BAD_FAMILY, caller);
        }

        static boolean isInet(PSocket socket) {
            return socket.getFamily() == PosixConstants.AF_INET.value;
        }

        static boolean isInet6(PSocket socket) {
            return socket.getFamily() == PosixConstants.AF_INET6.value;
        }

        static boolean isUnix(PSocket socket) {
            return socket.getFamily() == PosixConstants.AF_UNIX.value;
        }

        private static int parsePort(VirtualFrame frame, String caller, PyLongAsIntNode asIntNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, Object portObj, PRaiseNode.Lazy raiseNode) {
            int port;
            try {
                port = asIntNode.execute((Frame)frame, inliningTarget, portObj);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.OverflowError, errorProfile);
                port = -1;
            }
            if (port < 0 || port > 65535) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_PORT_RANGE, caller);
            }
            return port;
        }
    }
}

