/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltins;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetNodesFactory;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public abstract class SetNodes {

    public static abstract class DiscardNode
    extends PythonBinaryBuiltinNode {
        public abstract boolean execute(VirtualFrame var1, PSet var2, Object var3);

        @Specialization
        boolean discard(VirtualFrame frame, PSet self, Object key, @Bind(value="this") Node inliningTarget, @Cached BaseSetBuiltins.ConvertKeyNode conv, @Cached HashingStorageNodes.HashingStorageDelItem delItem) {
            Object checkedKey = conv.execute(inliningTarget, key);
            return delItem.execute((Frame)frame, inliningTarget, self.getDictStorage(), checkedKey, self);
        }
    }

    @GenerateUncached
    public static abstract class AddNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, PSet var2, Object var3);

        @Specialization
        public static void add(VirtualFrame frame, PSet self, Object o, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.SetItemNode setItemNode) {
            setItemNode.execute((Frame)frame, inliningTarget, self, o, PNone.NONE);
        }

        @NeverDefault
        public static AddNode create() {
            return SetNodesFactory.AddNodeGen.create();
        }

        public static AddNode getUncached() {
            return SetNodesFactory.AddNodeGen.getUncached();
        }
    }

    @GenerateUncached
    public static abstract class ConstructSetNode
    extends PNodeWithContext {
        public abstract PSet execute(Frame var1, Object var2, Object var3);

        public final PSet executeWith(Frame frame, Object value) {
            return this.execute(frame, (Object)PythonBuiltinClassType.PSet, value);
        }

        @Specialization
        static PSet setString(VirtualFrame frame, Object cls, TruffleString arg, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached HashingCollectionNodes.SetItemNode setItemNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            PSet set = factory.createSet(cls);
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)arg, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int cp = nextNode.execute(it);
                TruffleString s = fromCodePointNode.execute(cp, PythonUtils.TS_ENCODING, true);
                setItemNode.execute((Frame)frame, inliningTarget, set, s, PNone.NONE);
            }
            return set;
        }

        @Specialization(guards={"emptyArguments(none)"})
        static PSet set(Object cls, PNone none, @Cached.Exclusive @Cached PythonObjectFactory factory) {
            return factory.createSet(cls);
        }

        @Specialization(guards={"!isNoValue(iterable)"})
        static PSet setIterable(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached HashingCollectionNodes.SetItemNode setItemNode, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            PSet set = factory.createSet(cls);
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            try {
                while (true) {
                    setItemNode.execute((Frame)frame, inliningTarget, set, nextNode.execute((Frame)frame, iterator), PNone.NONE);
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return set;
            }
        }

        @Fallback
        static PSet setObject(Object cls, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, value);
        }

        @NeverDefault
        public static ConstructSetNode create() {
            return SetNodesFactory.ConstructSetNodeGen.create();
        }

        public static ConstructSetNode getUncached() {
            return SetNodesFactory.ConstructSetNodeGen.getUncached();
        }
    }
}

