/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.referencetype;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.referencetype.PReferenceType;
import com.oracle.graal.python.builtins.objects.referencetype.ReferenceTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PReferenceType})
public final class ReferenceTypeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ReferenceTypeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RefTypeNeNode
    extends PythonBuiltinNode {
        @Specialization(guards={"self.getObject() != null", "other.getObject() != null"})
        Object ne(VirtualFrame frame, PReferenceType self, PReferenceType other, @Cached BinaryComparisonNode.NeNode neNode) {
            return neNode.executeObject(frame, self.getObject(), other.getObject());
        }

        @Specialization(guards={"self.getObject() == null || other.getObject() == null"})
        boolean ne(PReferenceType self, PReferenceType other) {
            return self != other;
        }

        @Fallback
        Object eq(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RefTypeEqNode
    extends PythonBuiltinNode {
        @Specialization(guards={"self.getObject() != null", "other.getObject() != null"})
        Object eq(VirtualFrame frame, PReferenceType self, PReferenceType other, @Cached BinaryComparisonNode.EqNode eqNode) {
            return eqNode.executeObject(frame, self.getObject(), other.getObject());
        }

        @Specialization(guards={"self.getObject() == null || other.getObject() == null"})
        boolean eq(PReferenceType self, PReferenceType other) {
            return self == other;
        }

        @Fallback
        Object eq(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class RefTypeReprNode
    extends PythonBuiltinNode {
        RefTypeReprNode() {
        }

        @Specialization(guards={"self.getObject() == null"})
        static TruffleString repr(PReferenceType self, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<weakref at %d; dead>", PythonAbstractObject.objectHashCode(self));
        }

        @Specialization(guards={"self.getObject() != null"})
        static TruffleString repr(VirtualFrame frame, PReferenceType self, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object object = self.getObject();
            Object cls = getClassNode.execute(inliningTarget, object);
            TruffleString className = getNameNode.execute(inliningTarget, cls);
            Object name = lookup.execute((Frame)frame, inliningTarget, object, SpecialAttributeNames.T___NAME__);
            if (name == PNone.NO_VALUE) {
                return simpleTruffleStringFormatNode.format("<weakref at %d; to '%s' at %d>", PythonAbstractObject.objectHashCode(self), className, PythonAbstractObject.objectHashCode(object));
            }
            return simpleTruffleStringFormatNode.format("<weakref at %d; to '%s' at %d (%s)>", PythonAbstractObject.objectHashCode(self), className, PythonAbstractObject.objectHashCode(object), RefTypeReprNode.toStr(name));
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStr(Object o) {
            return o.toString();
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RefTypeHashNode
    extends PythonUnaryBuiltinNode {
        static long HASH_UNSET = -1L;

        @Specialization(guards={"self.getHash() != HASH_UNSET"})
        static long getHash(PReferenceType self) {
            return self.getHash();
        }

        @Specialization(guards={"self.getHash() == HASH_UNSET"})
        static long computeHash(VirtualFrame frame, PReferenceType self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile referentProfile, @Cached PyObjectHashNode hashNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object referent = self.getObject();
            if (referentProfile.profile(inliningTarget, referent != null)) {
                long hash = hashNode.execute((Frame)frame, inliningTarget, referent);
                self.setHash(hash);
                return hash;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.WEAK_OBJ_GONE_AWAY);
        }

        @Fallback
        static int hashWrong(Object self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__hash__", "weakref", self);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RefTypeCallNode
    extends PythonBuiltinNode {
        @Specialization
        public Object call(PReferenceType self) {
            return self.getPyObject();
        }
    }

    @Builtin(name="__callback__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RefTypeCallbackPropertyNode
    extends PythonBuiltinNode {
        @Specialization
        public Object getCallback(PReferenceType self) {
            return self.getCallback();
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        Object init(Object self, Object obj, Object callback) {
            return PNone.NONE;
        }
    }
}

