/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.copying;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.copying.SharedObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.BiFunction;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.util.concurrent.atomic.AtomicInteger;

public final class NativeLibraryLocator {
    static final TruffleLogger LOGGER = PythonLanguage.getLogger("NativeLibraryLocator");
    private static final int MAX_CEXT_COPIES = Integer.getInteger("python.MaximumNumberOfCextCopies", 64);
    private static final AtomicInteger CEXT_COPY_INDICES = new AtomicInteger(MAX_CEXT_COPIES);
    private final int capiSlot;
    private final String capiOriginal;
    private final String capiCopy;

    public NativeLibraryLocator(PythonContext context, TruffleFile capiLibrary, boolean isolateNative) throws LoadCExtException.ApiInitException {
        this.capiOriginal = capiLibrary.getName();
        if (isolateNative) {
            this.capiSlot = MAX_CEXT_COPIES - CEXT_COPY_INDICES.getAndDecrement();
            if (this.capiSlot < 0) {
                CEXT_COPY_INDICES.set(0);
                throw new LoadCExtException.ApiInitException(ErrorMessages.CAPI_ISOLATION_CAPPED_AT_D, MAX_CEXT_COPIES);
            }
            this.capiCopy = NativeLibraryLocator.resolve(context, capiLibrary, this.capiSlot, null);
        } else {
            this.capiSlot = -1;
            this.capiCopy = capiLibrary.getPath();
        }
    }

    public String resolve(PythonContext context, TruffleFile original) throws LoadCExtException.ImportException {
        try {
            return NativeLibraryLocator.resolve(context, original, this.capiSlot, this.capiOriginal);
        }
        catch (LoadCExtException.ApiInitException e) {
            throw new LoadCExtException.ImportException(null, PythonUtils.toTruffleStringUncached(original.getName()), PythonUtils.toTruffleStringUncached(original.getPath()), PythonUtils.toTruffleStringUncached(e.getMessage()), new Object[0]);
        }
    }

    public String getCapiLibrary() {
        return this.capiCopy;
    }

    public void close() {
    }

    public static void replicate(TruffleFile venvDirectory, PythonContext context, int count) throws IOException, InterruptedException {
        if (count > MAX_CEXT_COPIES) {
            LOGGER.warning(() -> String.format("The current limit for concurrent Python contexts accessing the Python C API is %d, but we are preparing %d copies. The extra copies will only be used if a different value of the system property %s is set.", MAX_CEXT_COPIES, count, "python.MaximumNumberOfCextCopies"));
        }
        String suffix = context.getSoAbi().toJavaStringUncached();
        TruffleFile capiLibrary = context.getPublicTruffleFileRelaxed(context.getCAPIHome(), new TruffleString[0]).resolve(PythonContext.getSupportLibName("python-native"));
        try {
            for (int i = 0; i < count; ++i) {
                NativeLibraryLocator.replicate(capiLibrary, venvDirectory.resolve(NativeLibraryLocator.copyNameOf(capiLibrary.getName(), i)), context, i, new String[0]);
                NativeLibraryLocator.walk(context.getPublicTruffleFileRelaxed(context.getCoreHome(), new TruffleString[0]), suffix, capiLibrary.getName(), context, i, (o, n) -> venvDirectory.resolve(n));
                NativeLibraryLocator.walk(venvDirectory, suffix, capiLibrary.getName(), context, i, (o, n) -> o.resolveSibling(n));
            }
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioCause = (IOException)cause;
                throw ioCause;
            }
            if (cause instanceof InterruptedException) {
                InterruptedException intCause = (InterruptedException)cause;
                throw intCause;
            }
            throw e;
        }
    }

    private static String copyNameOf(String original, int capiSlot) {
        return original + ".dup" + Integer.toHexString(capiSlot);
    }

    private static String resolve(PythonContext context, TruffleFile original, int capiSlot, String capiOrignalName) throws LoadCExtException.ApiInitException {
        TruffleFile copy;
        if (capiSlot < 0) {
            return original.getPath();
        }
        TruffleLanguage.Env env = context.getEnv();
        String newName = NativeLibraryLocator.copyNameOf(original.getName(), capiSlot);
        if (original.getAbsoluteFile().startsWith(context.getCoreHome().toJavaStringUncached())) {
            Object sysBasePrefix;
            Object sysPrefix = context.getSysModule().getAttribute(StringLiterals.T_PREFIX);
            if (sysPrefix.equals(sysBasePrefix = context.getSysModule().getAttribute(StringLiterals.T_BASE_PREFIX))) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.SYS_PREFIX_MUST_POINT_TO_A_VENV_FOR_CAPI_ISOLATION, new Object[0]);
            }
            try {
                TruffleString tsSysPrefix = CastToTruffleStringNode.executeUncached(sysPrefix);
                copy = env.getPublicTruffleFile(tsSysPrefix.toJavaStringUncached()).resolve(newName);
            }
            catch (CannotCastException e) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.SYS_PREFIX_MUST_BE_STRING_NOT_P_FOR_CAPI_ISOLATION, sysPrefix);
            }
        } else {
            copy = original.resolveSibling(newName);
        }
        if (!copy.isReadable()) {
            try {
                NativeLibraryLocator.replicate(original, copy, context, capiSlot, capiOrignalName);
            }
            catch (IOException | InterruptedException e) {
                throw new LoadCExtException.ApiInitException(e);
            }
        }
        return copy.getPath();
    }

    private static void replicate(TruffleFile original, TruffleFile copy, PythonContext context, int slot, String ... dependenciesToUpdate) throws IOException, InterruptedException {
        try (SharedObject o = SharedObject.open(original, context);){
            for (String depToUpdate : dependenciesToUpdate) {
                if (depToUpdate == null) continue;
                String newDepName = NativeLibraryLocator.copyNameOf(depToUpdate, slot);
                o.changeOrAddDependency(depToUpdate, newDepName);
            }
            o.setId(copy.getName());
            o.write(copy);
        }
    }

    private static void walk(TruffleFile dir, String suffix, String capiOriginalName, PythonContext context, int capiSlot, BiFunction<TruffleFile, String, TruffleFile> f) throws IOException, InterruptedException {
        try (DirectoryStream ds = dir.newDirectoryStream();){
            for (TruffleFile e : ds) {
                if (e.isDirectory(new LinkOption[0])) {
                    NativeLibraryLocator.walk(e, suffix, capiOriginalName, context, capiSlot, f);
                    continue;
                }
                if (!e.getName().endsWith(suffix) || !e.isRegularFile(new LinkOption[0])) continue;
                NativeLibraryLocator.replicate(e, (TruffleFile)f.apply(e, NativeLibraryLocator.copyNameOf(e.getName(), capiSlot)), context, capiSlot, capiOriginalName);
            }
        }
    }
}

