/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.WinregModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.WinregModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="winreg", isEager=true, os=PythonOS.PLATFORM_WIN32)
public final class WinregModuleBuiltins
extends PythonBuiltins {
    private static final int HKEY_CURRENT_USER = 1;
    private static final int HKEY_LOCAL_MACHINE = 2;
    private static final int HKEY_CLASSES_ROOT = 3;
    private static final int HKEY_USERS = 4;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return WinregModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("HKEY_CURRENT_USER", (Object)1);
        this.addBuiltinConstant("HKEY_LOCAL_MACHINE", (Object)2);
        this.addBuiltinConstant("HKEY_CLASSES_ROOT", (Object)3);
        this.addBuiltinConstant("HKEY_USERS", (Object)4);
        this.addBuiltinConstant("error", (Object)PNone.NONE);
        this.addBuiltinConstant("EnumValue", (Object)PNone.NONE);
    }

    @Builtin(name="OpenKeyEx", minNumOfPositionalArgs=2, parameterNames={"key", "index"})
    @GenerateNodeFactory
    public static abstract class OpenKeyExNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object enumKey(VirtualFrame frame, Object key, Object index, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.ENOENT);
        }
    }

    @Builtin(name="EnumKey", minNumOfPositionalArgs=2, parameterNames={"key", "index"})
    @GenerateNodeFactory
    public static abstract class EnumKeyNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object enumKey(VirtualFrame frame, Object key, Object index, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.ENOENT);
        }
    }

    @Builtin(name="OpenKey", minNumOfPositionalArgs=2, parameterNames={"key", "sub_key", "reserved", "access"})
    @ArgumentsClinic(value={@ArgumentClinic(name="reserved", defaultValue="0"), @ArgumentClinic(name="access", defaultValue="131097")})
    @GenerateNodeFactory
    public static abstract class OpenKeyNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return WinregModuleBuiltinsClinicProviders.OpenKeyNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object openKey(VirtualFrame frame, Object key, Object subKey, Object reserved, Object access, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            Integer intKey;
            if (key instanceof Integer && (intKey = (Integer)key) == 3) {
                return factory.createLock();
            }
            throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.ENOENT);
        }
    }
}

