/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

public final class ForeignSequenceStorage
extends SequenceStorage {
    private final Object foreignArray;

    public ForeignSequenceStorage(Object foreignArray, int size) {
        assert (IsForeignObjectNode.executeUncached(foreignArray));
        assert (InteropLibrary.getUncached().hasArrayElements(foreignArray));
        this.foreignArray = foreignArray;
        this.length = size;
        this.capacity = size;
    }

    public int getArraySize(Node inliningTarget, InteropLibrary interop, InlinedBranchProfile errorProfile) {
        long size;
        try {
            size = interop.getArraySize(this.foreignArray);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        return PInt.long2int(inliningTarget, size, errorProfile);
    }

    @Override
    public void setNewLength(int length) {
        this.length = length;
        this.capacity = length;
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Generic;
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "ForeignSequenceStorage[]";
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ClearNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, ForeignSequenceStorage var2);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static void clear(Node inliningTarget, ForeignSequenceStorage storage, @Cached RemoveNode removeNode2) {
            int size = storage.length;
            for (int i = size - 1; i >= 0; --i) {
                removeNode2.execute(inliningTarget, storage, i);
            }
            storage.setNewLength(0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class RemoveNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, ForeignSequenceStorage var2, int var3);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static void remove(Node inliningTarget, ForeignSequenceStorage storage, int index, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                interop.removeArrayElement(storage.foreignArray, (long)index);
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.ITEM_S_OF_S_OBJ_IS_NOT_REMOVABLE, index, storage.foreignArray);
            }
            finally {
                gil.acquire();
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WriteNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, ForeignSequenceStorage var2, int var3, Object var4);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static void write(Node inliningTarget, ForeignSequenceStorage storage, int index, Object value, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                interop.writeArrayElement(storage.foreignArray, (long)index, value);
            }
            catch (InvalidArrayIndexException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, index);
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.ITEM_S_OF_S_OBJ_IS_NOT_WRITABLE, index, storage.foreignArray);
            }
            catch (UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TYPE_P_NOT_SUPPORTED_BY_FOREIGN_OBJ, value);
            }
            finally {
                gil.acquire();
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, ForeignSequenceStorage var2, int var3);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static Object read(Node inliningTarget, ForeignSequenceStorage storage, int index, @Cached ReadNoConversionNode readNoConversionNode, @Cached(inline=false) PForeignToPTypeNode toPythonNode) {
            Object value = readNoConversionNode.execute(inliningTarget, storage, index);
            return toPythonNode.executeConvert(value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadNoConversionNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, ForeignSequenceStorage var2, int var3);

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static Object read(Node inliningTarget, ForeignSequenceStorage storage, int index, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                Object object = interop.readArrayElement(storage.foreignArray, (long)index);
                return object;
            }
            catch (UnsupportedMessageException ex) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.ITEM_S_OF_S_OBJ_IS_NOT_READABLE, index, storage.foreignArray);
            }
            catch (InvalidArrayIndexException ex) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, index);
            }
            finally {
                gil.acquire();
            }
        }
    }
}

