/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow;

import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.util.PythonUtils;
import sun.misc.Unsafe;

public class ArrowSchema {
    private static final Unsafe unsafe = PythonUtils.initUnsafe();
    private static final int SIZE_OF = 72;
    public static final byte[] CAPSULE_NAME = PyCapsule.capsuleName("arrow_schema");
    private static final byte NULL = 0;
    private static final long FORMAT_INDEX = 0L;
    private static final long NAME_INDEX = 8L;
    private static final long METADATA_INDEX = 16L;
    private static final long FLAGS_INDEX = 24L;
    private static final long N_CHILDREN_INDEX = 32L;
    private static final long CHILDREN_INDEX = 40L;
    private static final long DICTIONARY_INDEX = 48L;
    private static final long RELEASE_CALLBACK_INDEX = 56L;
    private static final long PRIVATE_DATA_INDEX = 64L;
    public final long memoryAddr;

    private ArrowSchema(long memoryAddr) {
        this.memoryAddr = memoryAddr;
    }

    public static ArrowSchema allocate() {
        ArrowSchema arrowSchema = new ArrowSchema(unsafe.allocateMemory(72L));
        arrowSchema.markRelease();
        return arrowSchema;
    }

    public static ArrowSchema allocateFromSnapshot(Snapshot snapshot) {
        ArrowSchema arrowSchema = new ArrowSchema(unsafe.allocateMemory(72L));
        arrowSchema.load(snapshot);
        return arrowSchema;
    }

    public static ArrowSchema wrap(long arrowSchemaPointer) {
        return new ArrowSchema(arrowSchemaPointer);
    }

    public long getFormat() {
        return unsafe.getLong(this.memoryAddr);
    }

    public boolean isReleased() {
        return unsafe.getLong(this.memoryAddr + 56L) == 0L;
    }

    public void markRelease() {
        unsafe.putLong(this.memoryAddr + 56L, 0L);
    }

    public void load(Snapshot snapshot) {
        unsafe.putLong(this.memoryAddr + 0L, snapshot.format);
        unsafe.putLong(this.memoryAddr + 8L, snapshot.name);
        unsafe.putLong(this.memoryAddr + 16L, snapshot.metadata);
        unsafe.putLong(this.memoryAddr + 24L, snapshot.flags);
        unsafe.putLong(this.memoryAddr + 32L, snapshot.n_children);
        unsafe.putLong(this.memoryAddr + 40L, snapshot.children);
        unsafe.putLong(this.memoryAddr + 48L, snapshot.dictionary);
        unsafe.putLong(this.memoryAddr + 56L, snapshot.release);
        unsafe.putLong(this.memoryAddr + 64L, snapshot.private_data);
    }

    public static class Snapshot {
        public long format = 0L;
        public long name = 0L;
        public long metadata = 0L;
        public long flags = 0L;
        public long n_children = 0L;
        public long children = 0L;
        public long dictionary = 0L;
        public long release = 0L;
        public long private_data = 0L;
    }
}

