/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.exception.OsErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorBuiltins;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorCode;
import com.oracle.graal.python.nodes.PConstructAndRaiseNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.formatting.ErrorMessageFormatter;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@ImportStatic(value={PGuards.class})
public abstract class PConstructAndRaiseNode
extends Node {
    public final PException executeWithArgsOnly(Frame frame, PythonBuiltinClassType type, Object[] arguments) {
        return this.execute(frame, type, null, null, null, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    public final PException executeWithFmtMessageAndArgs(Frame frame, PythonBuiltinClassType type, TruffleString format, Object[] formatArgs, Object[] arguments) {
        return this.execute(frame, type, null, format, formatArgs, arguments, PKeyword.EMPTY_KEYWORDS);
    }

    public abstract PException execute(Frame var1, PythonBuiltinClassType var2, Object var3, TruffleString var4, Object[] var5, Object[] var6, PKeyword[] var7);

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getFormattedMessage(TruffleString format, Object[] formatArgs) {
        return PythonUtils.toTruffleStringUncached(ErrorMessageFormatter.format(format, formatArgs));
    }

    private PException raiseInternal(VirtualFrame frame, PythonBuiltinClassType type, Object cause, Object[] arguments, PKeyword[] keywords, CallVarargsMethodNode callNode, Python3Core core, TruffleString.FromJavaStringNode fromJavaStringNode) {
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (!(arguments[i] instanceof String)) continue;
                arguments[i] = fromJavaStringNode.execute((String)arguments[i], PythonUtils.TS_ENCODING);
            }
        }
        PBaseException error = (PBaseException)callNode.execute((Frame)frame, core.lookupType(type), arguments, keywords);
        if (cause != null) {
            error.setContext(cause);
            error.setCause(cause);
        }
        return PRaiseNode.raiseExceptionObject(this, error);
    }

    @Specialization(guards={"format == null", "formatArgs == null"})
    PException constructAndRaiseNoFormatString(VirtualFrame frame, PythonBuiltinClassType type, Object cause, TruffleString format, Object[] formatArgs, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="callNode") @Cached CallVarargsMethodNode callNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        PythonContext core = PythonContext.get(this);
        return this.raiseInternal(frame, type, cause, arguments, keywords, callNode, core, fromJavaStringNode);
    }

    @Specialization(guards={"format != null", "arguments == null"})
    PException constructAndRaiseNoArgs(VirtualFrame frame, PythonBuiltinClassType type, Object cause, TruffleString format, Object[] formatArgs, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="callNode") @Cached CallVarargsMethodNode callNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        PythonContext core = PythonContext.get(this);
        Object[] args = new Object[]{formatArgs != null ? PConstructAndRaiseNode.getFormattedMessage(format, formatArgs) : format};
        return this.raiseInternal(frame, type, cause, args, keywords, callNode, core, fromJavaStringNode);
    }

    @Specialization(guards={"format != null", "arguments != null"})
    PException constructAndRaise(VirtualFrame frame, PythonBuiltinClassType type, Object cause, TruffleString format, Object[] formatArgs, Object[] arguments, PKeyword[] keywords, @Cached.Shared(value="callNode") @Cached CallVarargsMethodNode callNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        PythonContext core = PythonContext.get(this);
        Object[] args = new Object[arguments.length + 1];
        args[0] = formatArgs != null ? PConstructAndRaiseNode.getFormattedMessage(format, formatArgs) : format;
        System.arraycopy(arguments, 0, args, 1, arguments.length);
        return this.raiseInternal(frame, type, cause, args, keywords, callNode, core, fromJavaStringNode);
    }

    public final PException raiseImportErrorWithModule(Frame frame, Object name, Object path, TruffleString format, Object ... formatArgs) {
        return this.raiseImportErrorInternal(frame, format, formatArgs, new PKeyword[]{new PKeyword(StringLiterals.T_NAME, name), new PKeyword(StringLiterals.T_PATH, path)});
    }

    public final PException raiseImportError(Frame frame, TruffleString format, Object ... formatArgs) {
        return this.raiseImportErrorInternal(frame, format, formatArgs, PKeyword.EMPTY_KEYWORDS);
    }

    private PException raiseImportErrorInternal(Frame frame, TruffleString format, Object[] formatArgs, PKeyword[] keywords) {
        return this.execute(frame, PythonBuiltinClassType.ImportError, null, format, formatArgs, null, keywords);
    }

    public final PException raiseImportErrorWithModuleAndCause(Frame frame, Object cause, Object name, Object path, TruffleString format, Object ... formatArgs) {
        return this.execute(frame, PythonBuiltinClassType.ImportError, cause, format, formatArgs, null, new PKeyword[]{new PKeyword(StringLiterals.T_NAME, name), new PKeyword(StringLiterals.T_PATH, path)});
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getMessage(Exception exception) {
        return PythonUtils.toTruffleStringUncached(exception.getMessage());
    }

    private PException raise(Frame frame, PythonBuiltinClassType err, TruffleString message, Object ... formatArgs) {
        return this.executeWithFmtMessageAndArgs(frame, err, message, formatArgs, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    private static Object[] createOsErrorArgs(int errno, TruffleString message) {
        return new Object[]{errno, message};
    }

    private static Object[] createOsErrorArgs(int errno, TruffleString message, Object filename1) {
        return PConstructAndRaiseNode.createOsErrorArgs(errno, message, filename1, null);
    }

    private static Object[] createOsErrorArgs(OSErrorEnum osErrorEnum, TruffleString filename1) {
        return PConstructAndRaiseNode.createOsErrorArgs(osErrorEnum.getNumber(), osErrorEnum.getMessage(), filename1, null);
    }

    private static Object[] createOsErrorArgs(int errno, TruffleString message, Object filename1, Object filename2) {
        if (filename1 != null) {
            if (filename2 != null) {
                return new Object[]{errno, message, filename1, 0, filename2};
            }
            return new Object[]{errno, message, filename1};
        }
        assert (filename2 == null);
        return new Object[]{errno, message};
    }

    private static Object[] createOsErrorArgs(OSErrorEnum osErrorEnum) {
        return new Object[]{osErrorEnum.getNumber(), osErrorEnum.getMessage()};
    }

    private static Object[] createOsErrorArgs(Exception exception, TruffleString.EqualNode eqNode) {
        OSErrorEnum.ErrorAndMessagePair errorAndMessage = OSErrorEnum.fromException(exception, eqNode);
        return new Object[]{errorAndMessage.oserror.getNumber(), errorAndMessage.message};
    }

    private PException raiseOSErrorInternal(Frame frame, Object[] arguments) {
        return this.executeWithArgsOnly(frame, PythonBuiltinClassType.OSError, arguments);
    }

    public final PException raiseOSError(Frame frame, OSErrorEnum osErrorEnum) {
        return this.raiseOSErrorInternal(frame, PConstructAndRaiseNode.createOsErrorArgs(osErrorEnum));
    }

    public final PException raiseOSError(Frame frame, OSErrorEnum osErrorEnum, TruffleString filename) {
        return this.raiseOSErrorInternal(frame, PConstructAndRaiseNode.createOsErrorArgs(osErrorEnum, filename));
    }

    public final PException raiseOSError(Frame frame, Exception exception, TruffleString.EqualNode eqNode) {
        return this.raiseOSErrorInternal(frame, PConstructAndRaiseNode.createOsErrorArgs(exception, eqNode));
    }

    public final PException raiseOSError(Frame frame, OSErrorEnum osErrorEnum, Exception exception) {
        return this.raiseOSError(frame, osErrorEnum, PConstructAndRaiseNode.getMessage(exception));
    }

    public final PException raiseOSError(Frame frame, int errno, TruffleString message, Object filename) {
        return this.raiseOSErrorInternal(frame, PConstructAndRaiseNode.createOsErrorArgs(errno, message, filename));
    }

    public final PException raiseOSError(VirtualFrame frame, int errno, TruffleString message) {
        return this.raiseOSErrorInternal((Frame)frame, PConstructAndRaiseNode.createOsErrorArgs(errno, message));
    }

    public final PException raiseOSErrorFromPosixException(VirtualFrame frame, PosixSupportLibrary.PosixException e) {
        return this.raiseOSErrorInternal((Frame)frame, PConstructAndRaiseNode.createOsErrorArgs(e.getErrorCode(), e.getMessageAsTruffleString()));
    }

    public final PException raiseOSErrorFromPosixException(VirtualFrame frame, PosixSupportLibrary.PosixException e, Object filename1) {
        return this.raiseOSErrorInternal((Frame)frame, PConstructAndRaiseNode.createOsErrorArgs(e.getErrorCode(), e.getMessageAsTruffleString(), filename1));
    }

    public final PException raiseOSErrorFromPosixException(VirtualFrame frame, PosixSupportLibrary.PosixException e, Object filename1, Object filename2) {
        return this.raiseOSErrorInternal((Frame)frame, PConstructAndRaiseNode.createOsErrorArgs(e.getErrorCode(), e.getMessageAsTruffleString(), filename1, filename2));
    }

    public final PException raiseOSErrorUnsupported(VirtualFrame frame, PosixSupportLibrary.UnsupportedPosixFeatureException e) {
        return this.raiseOSError((Frame)frame, OSErrorEnum.EINVAL, PConstructAndRaiseNode.createUnsupportedErrorMessage(e));
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString createUnsupportedErrorMessage(PosixSupportLibrary.UnsupportedPosixFeatureException e) {
        return TruffleString.fromJavaStringUncached((String)e.getMessage(), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
    }

    public final PException raiseSSLError(Frame frame, TruffleString message) {
        return this.raiseSSLError(frame, message, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    private PException raiseSSLError(Frame frame, TruffleString message, Object ... formatArgs) {
        return this.raise(frame, PythonBuiltinClassType.SSLError, message, formatArgs);
    }

    public PException raiseSSLError(Frame frame, SSLErrorCode errorCode, Exception ex) {
        return this.raiseSSLError(frame, errorCode, PConstructAndRaiseNode.getMessage(ex), new Object[0]);
    }

    public PException raiseSSLError(Frame frame, SSLErrorCode errorCode, TruffleString format, Object ... formatArgs) {
        TruffleString message = PConstructAndRaiseNode.getFormattedMessage(format, formatArgs);
        try {
            return this.executeWithFmtMessageAndArgs(frame, errorCode.getType(), null, null, new Object[]{errorCode.getErrno(), message});
        }
        catch (PException pException) {
            SSLErrorBuiltins.setSSLErrorAttributes(pException, errorCode, message);
            return pException;
        }
    }

    public static PException raiseUncachedSSLError(TruffleString message) {
        return PConstructAndRaiseNode.getUncached().raiseSSLError(null, message);
    }

    public static PException raiseUncachedSSLError(TruffleString message, Object ... formatArgs) {
        return PConstructAndRaiseNode.getUncached().raiseSSLError(null, message, formatArgs);
    }

    public static PException raiseUncachedSSLError(SSLErrorCode errorCode, Exception ex) {
        return PConstructAndRaiseNode.getUncached().raiseSSLError(null, errorCode, ex);
    }

    public static PException raiseUncachedSSLError(SSLErrorCode errorCode, TruffleString format, Object ... formatArgs) {
        return PConstructAndRaiseNode.getUncached().raiseSSLError(null, errorCode, format, formatArgs);
    }

    private PException raiseOSErrorSubType(Frame frame, PythonBuiltinClassType osErrorSubtype, TruffleString format, Object ... fmtArgs) {
        TruffleString message = PConstructAndRaiseNode.getFormattedMessage(format, fmtArgs);
        OSErrorEnum osErrorEnum = OsErrorBuiltins.errorType2errno(osErrorSubtype);
        assert (osErrorEnum != null) : "could not determine an errno for this error, either not an OSError subtype or multiple errno codes are available";
        return this.executeWithArgsOnly(frame, osErrorSubtype, new Object[]{osErrorEnum.getNumber(), message});
    }

    public final PException raiseFileNotFoundError(Frame frame, TruffleString format, Object ... fmtArgs) {
        return this.raiseOSErrorSubType(frame, PythonBuiltinClassType.FileNotFoundError, format, fmtArgs);
    }

    public final PException raiseTimeoutError(Frame frame, TruffleString message) {
        return this.executeWithArgsOnly(frame, PythonBuiltinClassType.TimeoutError, new Object[]{message});
    }

    public final PException raiseUnicodeEncodeError(Frame frame, String encoding, TruffleString object, int start, int end, String reason) {
        return this.executeWithArgsOnly(frame, PythonBuiltinClassType.UnicodeEncodeError, new Object[]{encoding, object, start, end, reason});
    }

    @NeverDefault
    public static PConstructAndRaiseNode create() {
        return PConstructAndRaiseNodeGen.create();
    }

    public static PConstructAndRaiseNode getUncached() {
        return PConstructAndRaiseNodeGen.getUncached();
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class Lazy
    extends Node {
        public static Lazy getUncached() {
            return PConstructAndRaiseNodeGen.LazyNodeGen.getUncached();
        }

        public final PConstructAndRaiseNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract PConstructAndRaiseNode execute(Node var1);

        @Specialization
        static PConstructAndRaiseNode doIt(@Cached(inline=false) PConstructAndRaiseNode node) {
            return node;
        }
    }
}

