/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PUnionType;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PUnionType})
public final class UnionTypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = UnionTypeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnionTypeBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Node.Child
        BinaryOpNode orNode = BinaryArithmetic.Or.create();

        GetItemNode() {
        }

        @Specialization
        Object getitem(VirtualFrame frame, PUnionType self, Object item, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory.Lazy factory) {
            if (self.getParameters() == null) {
                self.setParameters(factory.get(inliningTarget).createTuple(GenericTypeNodes.makeParameters(self.getArgs())));
            }
            Object[] newargs = GenericTypeNodes.subsParameters(this, self, self.getArgs(), self.getParameters(), item);
            Object result = newargs[0];
            for (int i = 1; i < newargs.length; ++i) {
                result = this.orNode.executeObject(frame, result, newargs[i]);
            }
            return result;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        static boolean eq(VirtualFrame frame, PUnionType self, PUnionType other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached PythonObjectFactory factory) {
            PFrozenSet argSet1 = factory.createFrozenSet(getHashingStorageNode.doNoValue(frame, inliningTarget, self.getArgs()));
            PFrozenSet argSet2 = factory.createFrozenSet(getHashingStorageNode.doNoValue(frame, inliningTarget, other.getArgs()));
            return eqNode.compare((Frame)frame, inliningTarget, argSet1, argSet2);
        }

        @Fallback
        Object eq(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__subclasscheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubclassCheckNode
    extends PythonBinaryBuiltinNode {
        SubclassCheckNode() {
        }

        @Specialization
        static boolean check(VirtualFrame frame, PUnionType self, Object other, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached SequenceStorageNodes.GetItemScalarNode getItem, @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!isTypeNode.execute(inliningTarget, other)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISSUBCLASS_ARG_1_MUST_BE_A_CLASS);
            }
            SequenceStorage argsStorage = self.getArgs().getSequenceStorage();
            boolean result = false;
            for (int i = 0; i < argsStorage.length(); ++i) {
                Object arg = getItem.execute(inliningTarget, argsStorage, i);
                if (arg instanceof PGenericAlias) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISSUBCLASS_ARG_2_CANNOT_CONTAIN_A_PARAMETERIZED_GENERIC);
                }
                if (result) continue;
                result = isSubClassNode.executeWith(frame, other, arg);
            }
            return result;
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstanceCheckNode
    extends PythonBinaryBuiltinNode {
        InstanceCheckNode() {
        }

        @Specialization
        static boolean check(VirtualFrame frame, PUnionType self, Object other, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetItemScalarNode getItem, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage argsStorage = self.getArgs().getSequenceStorage();
            boolean result = false;
            for (int i = 0; i < argsStorage.length(); ++i) {
                Object arg = getItem.execute(inliningTarget, argsStorage, i);
                if (arg instanceof PGenericAlias) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISINSTANCE_ARG_2_CANNOT_CONTAIN_A_PARAMETERIZED_GENERIC);
                }
                if (result) continue;
                result = isInstanceNode.executeWith(frame, other, arg);
            }
            return result;
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        Object getattribute(VirtualFrame frame, PUnionType self, Object nameObj, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached TruffleString.EqualNode equalNode, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttr getAttr, @Cached ObjectBuiltins.GetAttributeNode genericGetAttribute) {
            TruffleString name;
            try {
                name = cast.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            if (equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialAttributeNames.T___MODULE__, PythonUtils.TS_ENCODING)) {
                return getAttr.execute((Frame)frame, inliningTarget, getClassNode.execute(inliningTarget, self), name);
            }
            return genericGetAttribute.execute(frame, self, nameObj);
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long hash(VirtualFrame frame, PUnionType self, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode, @Cached PythonObjectFactory factory) {
            PFrozenSet argSet = factory.createFrozenSet(getHashingStorageNode.doNoValue(frame, inliningTarget, self.getArgs()));
            return hashNode.execute((Frame)frame, inliningTarget, argSet);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString SEPARATOR = PythonUtils.tsLiteral(" | ");

        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object repr(PUnionType self) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            SequenceStorage argsStorage = self.getArgs().getSequenceStorage();
            for (int i = 0; i < argsStorage.length(); ++i) {
                if (i > 0) {
                    sb.appendStringUncached(SEPARATOR);
                }
                ReprNode.reprItem(sb, SequenceStorageNodes.GetItemScalarNode.executeUncached(argsStorage, i));
            }
            return sb.toStringUncached();
        }

        private static void reprItem(TruffleStringBuilder sb, Object obj) {
            if (TypeNodes.IsSameTypeNode.executeUncached(obj, (Object)PythonBuiltinClassType.PNone)) {
                sb.appendStringUncached(StringLiterals.T_NONE);
                return;
            }
            GenericTypeNodes.reprItem(sb, obj);
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode orNode) {
            return orNode.execute(self, other);
        }
    }

    @Builtin(name="__parameters__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ParametersNode
    extends PythonUnaryBuiltinNode {
        ParametersNode() {
        }

        @Specialization
        static Object parameters(PUnionType self, @Cached PythonObjectFactory factory) {
            if (self.getParameters() == null) {
                self.setParameters(factory.createTuple(GenericTypeNodes.makeParameters(self.getArgs())));
            }
            return self.getParameters();
        }
    }

    @Builtin(name="__args__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ArgsNode
    extends PythonUnaryBuiltinNode {
        ArgsNode() {
        }

        @Specialization
        Object args(PUnionType self) {
            return self.getArgs();
        }
    }
}

