/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ManagedMethodWrappers;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.SlotMethodDef;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupNativeSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class ToNativeTypeNode {
    private static Object getSlot(PythonManagedClass obj, SlotMethodDef slot) {
        return LookupNativeSlotNode.executeUncached(obj, slot);
    }

    private static boolean hasAsyncMethods(PythonManagedClass obj) {
        return (obj.getMethodsFlags() & 0x3C0000000000000L) != 0L;
    }

    private static boolean hasSequenceMethods(PythonManagedClass obj) {
        return (obj.getMethodsFlags() & 0x3AD0000000000L) != 0L;
    }

    private static Object allocatePyAsyncMethods(PythonManagedClass obj, Object nullValue) {
        Object mem = CStructAccess.AllocateNode.allocUncached(CStructs.PyAsyncMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        writePointerNode.write(mem, CFields.PyAsyncMethods__am_await, ToNativeTypeNode.getSlot(obj, SlotMethodDef.AM_AWAIT));
        writePointerNode.write(mem, CFields.PyAsyncMethods__am_aiter, ToNativeTypeNode.getSlot(obj, SlotMethodDef.AM_AITER));
        writePointerNode.write(mem, CFields.PyAsyncMethods__am_anext, ToNativeTypeNode.getSlot(obj, SlotMethodDef.AM_ANEXT));
        writePointerNode.write(mem, CFields.PyAsyncMethods__am_send, nullValue);
        return mem;
    }

    private static void writeGroupSlots(CFields groupField, TpSlots slots, CStructAccess.WritePointerNode writePointerNode, Object groupPointer, Object nullValue) {
        for (TpSlots.TpSlotMeta def : TpSlots.TpSlotMeta.VALUES) {
            if (def.getNativeGroupOrField() != groupField) continue;
            writePointerNode.write(groupPointer, def.getNativeField(), def.getNativeValue(slots, nullValue));
        }
    }

    private static Object allocatePyMappingMethods(TpSlots slots, Object nullValue) {
        Object mem = CStructAccess.AllocateNode.allocUncached(CStructs.PyMappingMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        ToNativeTypeNode.writeGroupSlots(CFields.PyTypeObject__tp_as_mapping, slots, writePointerNode, mem, nullValue);
        return mem;
    }

    private static Object allocatePyNumberMethods(PythonManagedClass obj, TpSlots slots, Object nullValue) {
        Object mem = CStructAccess.AllocateNode.allocUncached(CStructs.PyNumberMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        ToNativeTypeNode.writeGroupSlots(CFields.PyTypeObject__tp_as_number, slots, writePointerNode, mem, nullValue);
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_absolute, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_ABSOLUTE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_float, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_FLOAT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_index, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INDEX));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_add, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_ADD));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_and, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_AND));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_floor_divide, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_FLOOR_DIVIDE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_lshift, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_LSHIFT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_matrix_multiply, nullValue);
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_multiply, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_MULTIPLY));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_or, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_OR));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_power, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_POWER));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_remainder, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_REMAINDER));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_rshift, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_RSHIFT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_subtract, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_SUBTRACT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_true_divide, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_TRUE_DIVIDE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_xor, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INPLACE_XOR));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_int, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_invert, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_INVERT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_negative, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_NEGATIVE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_positive, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_POSITIVE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_power, ToNativeTypeNode.getSlot(obj, SlotMethodDef.NB_POWER));
        return mem;
    }

    private static Object allocatePySequenceMethods(TpSlots slots, Object nullValue) {
        Object mem = CStructAccess.AllocateNode.allocUncached(CStructs.PyNumberMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        ToNativeTypeNode.writeGroupSlots(CFields.PyTypeObject__tp_as_sequence, slots, writePointerNode, mem, nullValue);
        return mem;
    }

    private static Object lookup(PythonManagedClass clazz, CFields member, HiddenAttr hiddenName) {
        Object result = CExtNodes.lookupNativeMemberInMRO(clazz, member, hiddenName);
        if (result == PNone.NO_VALUE) {
            return PythonContext.get(null).getNativeNull();
        }
        return result;
    }

    private static long lookupSize(PythonManagedClass clazz, CFields member, HiddenAttr hiddenName) {
        return CExtNodes.lookupNativeI64MemberInMRO(clazz, member, hiddenName);
    }

    private static Object lookup(PythonManagedClass obj, SlotMethodDef slot) {
        return LookupNativeSlotNode.executeUncached(obj, slot);
    }

    static void initializeType(PythonClassNativeWrapper obj, Object mem, boolean heaptype) {
        TpSlots.TpSlotMeta[] dictStorage;
        PDict dict;
        long weaklistoffset;
        Object base;
        CompilerAsserts.neverPartOfCompilation();
        PythonManagedClass clazz = (PythonManagedClass)obj.getDelegate();
        TpSlots slots = TpSlots.GetTpSlotsNode.executeUncached(clazz);
        boolean isType = BuiltinClassProfiles.IsBuiltinClassExactProfile.profileClassSlowPath(clazz, PythonBuiltinClassType.PythonClass);
        CApiTransitions.PythonToNativeNode toNative = CApiTransitionsFactory.PythonToNativeNodeGen.getUncached();
        CApiTransitions.PythonToNativeNewRefNode toNativeNewRef = CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached();
        CStructAccess.WritePointerNode writePtrNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        CStructAccess.WriteLongNode writeI64Node = CStructAccessFactory.WriteLongNodeGen.getUncached();
        CStructAccess.WriteIntNode writeI32Node = CStructAccessFactory.WriteIntNodeGen.getUncached();
        TypeNodes.GetTypeFlagsNode getTypeFlagsNode = TypeNodesFactory.GetTypeFlagsNodeGen.getUncached();
        PythonContext ctx = PythonContext.get(null);
        PythonObjectSlowPathFactory factory = ctx.factory();
        NativePointer nullValue = ctx.getNativeNull();
        writeI64Node.write(mem, CFields.PyObject__ob_refcnt, 0x3FFFFFFFFFFFFFFFL);
        if (isType) {
            writePtrNode.write(mem, CFields.PyObject__ob_type, mem);
        } else {
            writePtrNode.write(mem, CFields.PyObject__ob_type, toNative.execute(GetClassNode.executeUncached(clazz)));
        }
        long flags = getTypeFlagsNode.execute(clazz);
        if (!heaptype) {
            flags &= 0xFFFFFFFFFFFFFDFFL;
        }
        if ((base = TypeNodes.GetBaseClassNode.executeUncached(clazz)) == null) {
            base = ctx.getNativeNull();
        } else if (base instanceof PythonBuiltinClassType) {
            PythonBuiltinClassType builtinClass = (PythonBuiltinClassType)((Object)base);
            base = ctx.lookupType(builtinClass);
        }
        writeI64Node.write(mem, CFields.PyVarObject__ob_size, 0L);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_name, clazz.getClassNativeWrapper().getNameWrapper());
        writeI64Node.write(mem, CFields.PyTypeObject__tp_basicsize, TypeNodes.GetBasicSizeNode.executeUncached(clazz));
        writeI64Node.write(mem, CFields.PyTypeObject__tp_itemsize, TypeNodes.GetItemSizeNode.executeUncached(clazz));
        if (clazz instanceof PythonBuiltinClass) {
            PythonBuiltinClass builtin = (PythonBuiltinClass)clazz;
            weaklistoffset = builtin.getType().getWeaklistoffset();
        } else {
            weaklistoffset = CExtNodes.lookupNativeI64MemberInMRO(clazz, CFields.PyTypeObject__tp_weaklistoffset, SpecialAttributeNames.T___WEAKLISTOFFSET__);
        }
        NativePointer asAsync = ToNativeTypeNode.hasAsyncMethods(clazz) ? ToNativeTypeNode.allocatePyAsyncMethods(clazz, nullValue) : nullValue;
        NativePointer asNumber = BuiltinClassProfiles.IsBuiltinClassExactProfile.profileClassSlowPath(clazz, PythonBuiltinClassType.PythonObject) ? nullValue : ToNativeTypeNode.allocatePyNumberMethods(clazz, slots, nullValue);
        Object asSequence = slots.has_as_sequence() || ToNativeTypeNode.hasSequenceMethods(clazz) ? ToNativeTypeNode.allocatePySequenceMethods(slots, nullValue) : nullValue;
        NativePointer asMapping = slots.has_as_mapping() ? ToNativeTypeNode.allocatePyMappingMethods(slots, nullValue) : nullValue;
        Object asBuffer = ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_as_buffer, HiddenAttr.AS_BUFFER);
        writeI64Node.write(mem, CFields.PyTypeObject__tp_weaklistoffset, weaklistoffset);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_dealloc, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_dealloc, HiddenAttr.DEALLOC));
        writeI64Node.write(mem, CFields.PyTypeObject__tp_vectorcall_offset, ToNativeTypeNode.lookupSize(clazz, CFields.PyTypeObject__tp_vectorcall_offset, HiddenAttr.VECTORCALL_OFFSET));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_getattr, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_async, asAsync);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_repr, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_REPR));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_number, asNumber);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_sequence, asSequence);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_mapping, asMapping);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_hash, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_HASH));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_call, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_CALL));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_str, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_STR));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_buffer, asBuffer);
        writeI64Node.write(mem, CFields.PyTypeObject__tp_flags, flags);
        Object docObj = clazz.getAttribute(SpecialAttributeNames.T___DOC__);
        try {
            docObj = new CArrayWrappers.CStringWrapper(CastToTruffleStringNode.executeUncached(docObj).switchEncodingUncached(TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
        }
        catch (CannotCastException e) {
            docObj = ctx.getNativeNull();
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_doc, docObj);
        Object tpTraverse = nullValue;
        Object tpIsGc = nullValue;
        if ((flags & 0x4000L) != 0L) {
            tpTraverse = ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_traverse, HiddenAttr.TRAVERSE);
            tpIsGc = ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_is_gc, HiddenAttr.IS_GC);
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_traverse, tpTraverse);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_is_gc, tpIsGc);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_richcompare, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_RICHCOMPARE));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_iter, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_ITER));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_iternext, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_ITERNEXT));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_methods, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_members, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_getset, nullValue);
        if (!isType) {
            writePtrNode.write(mem, CFields.PyTypeObject__tp_base, toNative.execute(base));
        }
        if (!((dict = GetOrCreateDictNode.executeUncached(clazz)) instanceof StgDictObject) && !((dictStorage = dict.getDictStorage()) instanceof DynamicObjectStorage)) {
            DynamicObjectStorage storage = new DynamicObjectStorage(clazz);
            dict.setDictStorage(HashingStorageNodes.HashingStorageAddAllToOther.executeUncached((HashingStorage)dictStorage, storage));
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_dict, toNative.execute(dict));
        for (TpSlots.TpSlotMeta def : TpSlots.TpSlotMeta.VALUES) {
            if (def.hasGroup() || !def.hasNativeWrapperFactory()) continue;
            writePtrNode.write(mem, def.getNativeGroupOrField(), def.getNativeValue(slots, (Object)nullValue));
        }
        writeI64Node.write(mem, CFields.PyTypeObject__tp_dictoffset, TypeNodes.GetDictOffsetNode.executeUncached(clazz));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_init, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_INIT));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_alloc, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_alloc, HiddenAttr.ALLOC));
        Object newFunction = LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.New).execute(clazz);
        if (newFunction instanceof PDecoratedMethod) {
            newFunction = ((PDecoratedMethod)newFunction).getCallable();
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_new, ManagedMethodWrappers.createKeywords(newFunction));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_free, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_free, HiddenAttr.FREE));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_clear, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_clear, HiddenAttr.CLEAR));
        if (clazz.basesTuple == null) {
            clazz.basesTuple = factory.createTuple(TypeNodes.GetBaseClassesNode.executeUncached(clazz));
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_bases, toNative.execute(clazz.basesTuple));
        if (clazz.mroStore == null) {
            clazz.mroStore = factory.createTuple(TypeNodes.GetMroStorageNode.executeUncached(clazz));
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_mro, toNative.execute(clazz.mroStore));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_cache, nullValue);
        PDict subclasses = TypeNodes.GetSubclassesNode.executeUncached(clazz);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_subclasses, toNativeNewRef.execute(subclasses));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_weaklist, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_del, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_del, HiddenAttr.DEL));
        writeI32Node.write(mem, CFields.PyTypeObject__tp_version_tag, 0);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_finalize, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_vectorcall, nullValue);
        if (heaptype) {
            assert ((flags & 0x200L) != 0L);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__as_async, asAsync);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__as_number, asNumber);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__as_mapping, asMapping);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__as_sequence, asSequence);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__as_buffer, asBuffer);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__ht_name, toNativeNewRef.execute(clazz.getName()));
            writePtrNode.write(mem, CFields.PyHeapTypeObject__ht_qualname, toNativeNewRef.execute(clazz.getQualName()));
            writePtrNode.write(mem, CFields.PyHeapTypeObject__ht_module, nullValue);
            Object dunderSlots = clazz.getAttribute(SpecialAttributeNames.T___SLOTS__);
            writePtrNode.write(mem, CFields.PyHeapTypeObject__ht_slots, dunderSlots != PNone.NO_VALUE ? toNativeNewRef.execute(dunderSlots) : nullValue);
        }
    }
}

