/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.json;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONEncoderBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.json.JSONEncoderBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.json.JSONUtils;
import com.oracle.graal.python.builtins.modules.json.PJSONEncoder;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyListCheckExactNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF32;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.JSONEncoder})
public final class JSONEncoderBuiltins
extends PythonBuiltins {
    private static final TruffleString T_NULL = PythonUtils.tsLiteral("null");
    private static final TruffleString T_TRUE = PythonUtils.tsLiteral("true");
    private static final TruffleString T_FALSE = PythonUtils.tsLiteral("false");
    private static final TruffleString T_POSITIVE_INFINITY = PythonUtils.tsLiteral("Infinity");
    private static final TruffleString T_NEGATIVE_INFINITY = PythonUtils.tsLiteral("-Infinity");
    private static final TruffleString T_NAN = PythonUtils.tsLiteral("NaN");
    private static final TruffleString T_BRACES = PythonUtils.tsLiteral("{}");
    private static final TruffleString T_BRACKETS = PythonUtils.tsLiteral("[]");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return JSONEncoderBuiltinsFactory.getFactories();
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, parameterNames={"$self", "obj", "_current_indent_level"})
    @ArgumentClinic(name="_current_indent_level", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class CallEncoderNode
    extends PythonTernaryClinicBuiltinNode {
        @Node.Child
        private LookupAndCallUnaryNode callGetItems = LookupAndCallUnaryNode.create(SpecialMethodNames.T_ITEMS);
        @Node.Child
        private LookupAndCallUnaryNode callGetDictIter = LookupAndCallUnaryNode.create(SpecialMethodSlot.Iter);
        @Node.Child
        private LookupAndCallUnaryNode callGetListIter = LookupAndCallUnaryNode.create(SpecialMethodSlot.Iter);
        @Node.Child
        private ListBuiltins.ListSortNode sortList = ListBuiltins.ListSortNode.create();

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return JSONEncoderBuiltinsClinicProviders.CallEncoderNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        protected PTuple call(PJSONEncoder self, Object obj, int indent, @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{this.jsonEncode(self, obj)});
        }

        @CompilerDirectives.TruffleBoundary
        private TruffleString jsonEncode(PJSONEncoder encoder, Object obj) {
            TruffleStringBuilderUTF32 builder = PythonUtils.createStringBuilder();
            this.appendListObj(encoder, builder, obj);
            return TruffleStringBuilder.ToStringNode.getUncached().execute((TruffleStringBuilder)builder);
        }

        private void appendConst(TruffleStringBuilderUTF32 builder, Object obj) {
            if (obj == PNone.NONE) {
                builder.appendStringUncached(T_NULL);
            } else if (obj == Boolean.TRUE) {
                builder.appendStringUncached(T_TRUE);
            } else {
                assert (obj == Boolean.FALSE);
                builder.appendStringUncached(T_FALSE);
            }
        }

        private void appendFloat(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, double obj) {
            if (!Double.isFinite(obj)) {
                if (!encoder.allowNan) {
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.OUT_OF_RANGE_FLOAT_NOT_JSON_COMPLIANT);
                }
                if (obj > 0.0) {
                    builder.appendStringUncached(T_POSITIVE_INFINITY);
                } else if (obj < 0.0) {
                    builder.appendStringUncached(T_NEGATIVE_INFINITY);
                } else {
                    builder.appendStringUncached(T_NAN);
                }
            } else {
                builder.appendStringUncached(this.formatDouble(obj));
            }
        }

        private TruffleString formatDouble(double obj) {
            FloatFormatter f = new FloatFormatter(FloatBuiltins.StrNode.spec, this);
            f.setMinFracDigits(1);
            return FloatBuiltins.StrNode.doFormat(obj, f);
        }

        private void appendString(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, TruffleString obj) {
            switch (encoder.fastEncode) {
                case FastEncode: {
                    JSONUtils.appendStringUncached(obj, builder, false);
                    break;
                }
                case FastEncodeAscii: {
                    JSONUtils.appendStringUncached(obj, builder, true);
                    break;
                }
                case None: {
                    Object result = CallUnaryMethodNode.getUncached().executeObject(encoder.encoder, obj);
                    if (!PGuards.isString(result)) {
                        throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.ENCODER_MUST_RETURN_STR, result);
                    }
                    builder.appendStringUncached(CastToTruffleStringNode.executeUncached(result));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private static boolean isSimpleObj(Object obj) {
            return obj == PNone.NONE || obj == Boolean.TRUE || obj == Boolean.FALSE || PGuards.isString(obj) || PGuards.isInteger(obj) || PGuards.isPInt(obj) || obj instanceof Float || PGuards.isDouble(obj) || PGuards.isPFloat(obj);
        }

        private boolean appendSimpleObj(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, Object obj) {
            if (obj == PNone.NONE || obj == Boolean.TRUE || obj == Boolean.FALSE) {
                this.appendConst(builder, obj);
            } else if (TruffleStringMigrationHelpers.isJavaString(obj)) {
                this.appendString(encoder, builder, PythonUtils.toTruffleStringUncached((String)obj));
            } else if (obj instanceof TruffleString) {
                this.appendString(encoder, builder, (TruffleString)obj);
            } else if (obj instanceof PString) {
                this.appendString(encoder, builder, StringNodes.StringMaterializeNode.executeUncached((PString)obj));
            } else if (obj instanceof Integer) {
                builder.appendIntNumberUncached(((Integer)obj).intValue());
            } else if (obj instanceof Long) {
                builder.appendLongNumberUncached(((Long)obj).longValue());
            } else if (obj instanceof PInt) {
                builder.appendStringUncached(TruffleString.FromJavaStringNode.getUncached().execute(((PInt)CompilerDirectives.castExact((Object)obj, PInt.class)).toString(), PythonUtils.TS_ENCODING));
            } else if (obj instanceof Float) {
                this.appendFloat(encoder, builder, ((Float)obj).floatValue());
            } else if (obj instanceof Double) {
                this.appendFloat(encoder, builder, (Double)obj);
            } else if (obj instanceof PFloat) {
                this.appendFloat(encoder, builder, ((PFloat)obj).asDouble());
            } else {
                return false;
            }
            return true;
        }

        private void appendListObj(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, Object obj) {
            if (!this.appendSimpleObj(encoder, builder, obj)) {
                if (obj instanceof PList || obj instanceof PTuple) {
                    this.appendList(encoder, builder, (PSequence)obj);
                } else if (obj instanceof PDict) {
                    this.appendDict(encoder, builder, (PDict)obj);
                } else {
                    this.startRecursion(encoder, obj);
                    Object newObj = CallUnaryMethodNode.getUncached().executeObject(encoder.defaultFn, obj);
                    this.appendListObj(encoder, builder, newObj);
                    CallEncoderNode.endRecursion(encoder, obj);
                }
            }
        }

        private static void endRecursion(PJSONEncoder encoder, Object obj) {
            if (encoder.markers != PNone.NONE) {
                encoder.removeCircular(obj);
            }
        }

        private void startRecursion(PJSONEncoder encoder, Object obj) {
            if (encoder.markers != PNone.NONE && !encoder.tryAddCircular(obj)) {
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.CIRCULAR_REFERENCE_DETECTED);
            }
        }

        private void appendDict(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, PDict dict) {
            HashingStorage storage = dict.getDictStorage();
            if (HashingStorageNodes.HashingStorageLen.executeUncached(storage) == 0) {
                builder.appendStringUncached(T_BRACES);
            } else {
                this.startRecursion(encoder, dict);
                builder.appendCodePointUncached(123);
                if (!encoder.sortKeys && PGuards.isBuiltinDict(dict)) {
                    HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(storage);
                    boolean first = true;
                    while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(storage, it)) {
                        Object key = HashingStorageNodes.HashingStorageIteratorKey.executeUncached(storage, it);
                        Object value = HashingStorageNodes.HashingStorageIteratorValue.executeUncached(storage, it);
                        first = this.appendDictEntry(encoder, builder, first, key, value);
                    }
                } else {
                    this.appendDictSlowPath(encoder, builder, dict);
                }
                builder.appendCodePointUncached(125);
                CallEncoderNode.endRecursion(encoder, dict);
            }
        }

        private void appendDictSlowPath(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, PDict dict) {
            PList items = ListNodes.ConstructListNode.getUncached().execute(null, this.callGetItems.executeObject(null, dict));
            if (encoder.sortKeys) {
                this.sortList.execute(null, items);
            }
            Object iter = this.callGetDictIter.executeObject(null, items);
            boolean first = true;
            while (true) {
                PTuple itemTuple;
                Object item;
                try {
                    item = GetNextNode.getUncached().execute(null, iter);
                }
                catch (PException e) {
                    e.expectStopIteration(null, BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached());
                    break;
                }
                if (!(item instanceof PTuple) || (itemTuple = (PTuple)item).getSequenceStorage().length() != 2) {
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.ITEMS_MUST_RETURN_2_TUPLES);
                }
                SequenceStorage sequenceStorage = itemTuple.getSequenceStorage();
                Object key = SequenceStorageNodes.GetItemScalarNode.executeUncached(sequenceStorage, 0);
                Object value = SequenceStorageNodes.GetItemScalarNode.executeUncached(sequenceStorage, 1);
                first = this.appendDictEntry(encoder, builder, first, key, value);
            }
        }

        private boolean appendDictEntry(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, boolean first, Object key, Object value) {
            if (!first) {
                builder.appendStringUncached(encoder.itemSeparator);
            }
            if (PGuards.isString(key)) {
                this.appendSimpleObj(encoder, builder, key);
            } else {
                if (!CallEncoderNode.isSimpleObj(key)) {
                    if (encoder.skipKeys) {
                        return true;
                    }
                    throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.KEYS_MUST_BE_STR_INT___NOT_P, key);
                }
                builder.appendCodePointUncached(34);
                this.appendSimpleObj(encoder, builder, key);
                builder.appendCodePointUncached(34);
            }
            builder.appendStringUncached(encoder.keySeparator);
            this.appendListObj(encoder, builder, value);
            return false;
        }

        private void appendList(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, PSequence list) {
            SequenceStorage storage = list.getSequenceStorage();
            if (storage.length() == 0) {
                builder.appendStringUncached(T_BRACKETS);
            } else {
                this.startRecursion(encoder, list);
                builder.appendCodePointUncached(91);
                if (PyTupleCheckExactNode.executeUncached(list) || PyListCheckExactNode.executeUncached(list)) {
                    for (int i = 0; i < storage.length(); ++i) {
                        if (i > 0) {
                            builder.appendStringUncached(encoder.itemSeparator);
                        }
                        this.appendListObj(encoder, builder, SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, i));
                    }
                } else {
                    this.appendListSlowPath(encoder, builder, list);
                }
                builder.appendCodePointUncached(93);
                CallEncoderNode.endRecursion(encoder, list);
            }
        }

        private void appendListSlowPath(PJSONEncoder encoder, TruffleStringBuilderUTF32 builder, PSequence list) {
            Object iter = this.callGetListIter.executeObject(null, list);
            boolean first = true;
            while (true) {
                Object item;
                try {
                    item = GetNextNode.getUncached().execute(null, iter);
                }
                catch (PException e) {
                    e.expectStopIteration(null, BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached());
                    break;
                }
                if (!first) {
                    builder.appendStringUncached(encoder.itemSeparator);
                }
                first = false;
                this.appendListObj(encoder, builder, item);
            }
        }
    }
}

