// CheckStyle: start generated
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.nio.ByteOrder;

@GeneratedBy(ByteSequenceStorage.class)
final class ByteSequenceStorageGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ByteSequenceStorage.class, new PythonBufferAccessLibraryExports());
    }

    private ByteSequenceStorageGen() {
    }

    @GeneratedBy(ByteSequenceStorage.class)
    private static final class PythonBufferAccessLibraryExports extends LibraryExport<PythonBufferAccessLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private PythonBufferAccessLibraryExports() {
            super(PythonBufferAccessLibrary.class, ByteSequenceStorage.class, false, false, 0);
        }

        @Override
        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            assert receiver instanceof ByteSequenceStorage;
            PythonBufferAccessLibrary uncached = PythonBufferAccessLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected PythonBufferAccessLibrary createCached(Object receiver) {
            assert receiver instanceof ByteSequenceStorage;
            return PythonBufferAccessLibraryExports.CACHE;
        }

        @GeneratedBy(ByteSequenceStorage.class)
        private static final class Cached extends PythonBufferAccessLibrary implements UnadoptableNode {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ByteSequenceStorage) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ByteSequenceStorage;
            }

            @Override
            public boolean isBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).isBuffer();
            }

            @Override
            public boolean isReadonly(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).isReadonly();
            }

            @Override
            public int getBufferLength(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).getBufferLength();
            }

            @Override
            public boolean hasInternalByteArray(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).hasInternalByteArray();
            }

            @Override
            public byte[] getInternalByteArray(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).getInternalByteArray();
            }

            @Override
            public byte readByte(Object receiver, int byteOffset) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).readByte(byteOffset);
            }

            @Override
            public void writeByte(Object receiver, int byteOffset, byte value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((ByteSequenceStorage) receiver)).writeByte(byteOffset, value);
                return;
            }

            @Override
            public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).readShortByteOrder(byteOffset, byteOrder);
            }

            @Override
            public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((ByteSequenceStorage) receiver)).writeShortByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @Override
            public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).readIntByteOrder(byteOffset, byteOrder);
            }

            @Override
            public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((ByteSequenceStorage) receiver)).writeIntByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @Override
            public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).readLongByteOrder(byteOffset, byteOrder);
            }

            @Override
            public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((ByteSequenceStorage) receiver)).writeLongByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @Override
            public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).readFloatByteOrder(byteOffset, byteOrder);
            }

            @Override
            public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((ByteSequenceStorage) receiver)).writeFloatByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @Override
            public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((ByteSequenceStorage) receiver)).readDoubleByteOrder(byteOffset, byteOrder);
            }

            @Override
            public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (((ByteSequenceStorage) receiver)).writeDoubleByteOrder(byteOffset, value, byteOrder);
                return;
            }

        }
        @GeneratedBy(ByteSequenceStorage.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAccessLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ByteSequenceStorage) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ByteSequenceStorage;
            }

            @TruffleBoundary
            @Override
            public boolean isBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .isBuffer();
            }

            @TruffleBoundary
            @Override
            public boolean isReadonly(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .isReadonly();
            }

            @TruffleBoundary
            @Override
            public int getBufferLength(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .getBufferLength();
            }

            @TruffleBoundary
            @Override
            public boolean hasInternalByteArray(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .hasInternalByteArray();
            }

            @TruffleBoundary
            @Override
            public byte[] getInternalByteArray(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .getInternalByteArray();
            }

            @TruffleBoundary
            @Override
            public byte readByte(Object receiver, int byteOffset) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .readByte(byteOffset);
            }

            @TruffleBoundary
            @Override
            public void writeByte(Object receiver, int byteOffset, byte value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteSequenceStorage) receiver) .writeByte(byteOffset, value);
                return;
            }

            @TruffleBoundary
            @Override
            public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .readShortByteOrder(byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteSequenceStorage) receiver) .writeShortByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .readIntByteOrder(byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteSequenceStorage) receiver) .writeIntByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .readLongByteOrder(byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteSequenceStorage) receiver) .writeLongByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .readFloatByteOrder(byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteSequenceStorage) receiver) .writeFloatByteOrder(byteOffset, value, byteOrder);
                return;
            }

            @TruffleBoundary
            @Override
            public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteSequenceStorage) receiver) .readDoubleByteOrder(byteOffset, byteOrder);
            }

            @TruffleBoundary
            @Override
            public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteSequenceStorage) receiver) .writeDoubleByteOrder(byteOffset, value, byteOrder);
                return;
            }

        }
    }
}
