// CheckStyle: start generated
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PosixSupportLibrary.Inet4SockAddr;
import com.oracle.graal.python.runtime.PosixSupportLibrary.Inet6SockAddr;
import com.oracle.graal.python.runtime.PosixSupportLibrary.UniversalSockAddr;
import com.oracle.graal.python.runtime.PosixSupportLibrary.UniversalSockAddrLibrary;
import com.oracle.graal.python.runtime.PosixSupportLibrary.UnixSockAddr;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(UniversalSockAddrLibrary.class)
final class UniversalSockAddrLibraryGen extends LibraryFactory<UniversalSockAddrLibrary> {

    private static final Class<UniversalSockAddrLibrary> LIBRARY_CLASS = UniversalSockAddrLibraryGen.lazyLibraryClass();
    private static final Message GET_FAMILY = new MessageImpl("getFamily", 0, false, int.class, UniversalSockAddr.class);
    private static final Message AS_INET4_SOCK_ADDR = new MessageImpl("asInet4SockAddr", 1, false, Inet4SockAddr.class, UniversalSockAddr.class);
    private static final Message AS_INET6_SOCK_ADDR = new MessageImpl("asInet6SockAddr", 2, false, Inet6SockAddr.class, UniversalSockAddr.class);
    private static final Message AS_UNIX_SOCK_ADDR = new MessageImpl("asUnixSockAddr", 3, false, UnixSockAddr.class, UniversalSockAddr.class);
    private static final UniversalSockAddrLibraryGen INSTANCE = new UniversalSockAddrLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(UniversalSockAddrLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(UniversalSockAddrLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private UniversalSockAddrLibraryGen() {
        super(UniversalSockAddrLibraryGen.LIBRARY_CLASS, List.of(UniversalSockAddrLibraryGen.GET_FAMILY, UniversalSockAddrLibraryGen.AS_INET4_SOCK_ADDR, UniversalSockAddrLibraryGen.AS_INET6_SOCK_ADDR, UniversalSockAddrLibraryGen.AS_UNIX_SOCK_ADDR));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return UniversalSockAddrLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected UniversalSockAddrLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected UniversalSockAddrLibrary createDelegate(UniversalSockAddrLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        UniversalSockAddrLibrary lib = (UniversalSockAddrLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.getFamily((UniversalSockAddr) receiver);
            case 1 :
                return lib.asInet4SockAddr((UniversalSockAddr) receiver);
            case 2 :
                return lib.asInet6SockAddr((UniversalSockAddr) receiver);
            case 3 :
                return lib.asUnixSockAddr((UniversalSockAddr) receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected UniversalSockAddrLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected UniversalSockAddrLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<UniversalSockAddrLibrary> lazyLibraryClass() {
        try {
            return (Class<UniversalSockAddrLibrary>) Class.forName("com.oracle.graal.python.runtime.PosixSupportLibrary$UniversalSockAddrLibrary", false, UniversalSockAddrLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static final class Default extends LibraryExport<UniversalSockAddrLibrary> {

        private Default() {
            super(UniversalSockAddrLibrary.class, UniversalSockAddr.class, false, false, 0);
        }

        @Override
        protected UniversalSockAddrLibrary createUncached(Object receiver) {
            assert receiver instanceof UniversalSockAddr;
            UniversalSockAddrLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected UniversalSockAddrLibrary createCached(Object receiver) {
            assert receiver instanceof UniversalSockAddr;
            return new Cached(receiver);
        }

        @GeneratedBy(UniversalSockAddrLibrary.class)
        private static final class Cached extends UniversalSockAddrLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public int getFamily(UniversalSockAddr receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(UniversalSockAddrLibrary.class)
        @DenyReplace
        private static final class Uncached extends UniversalSockAddrLibrary implements UnadoptableNode {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public int getFamily(UniversalSockAddr receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(UniversalSockAddrLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static final class Proxy extends UniversalSockAddrLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public int getFamily(UniversalSockAddr receiver_) {
            try {
                return (int) lib.send(receiver_, UniversalSockAddrLibraryGen.GET_FAMILY);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver_) {
            try {
                return (Inet4SockAddr) lib.send(receiver_, UniversalSockAddrLibraryGen.AS_INET4_SOCK_ADDR);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver_) {
            try {
                return (Inet6SockAddr) lib.send(receiver_, UniversalSockAddrLibraryGen.AS_INET6_SOCK_ADDR);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver_) {
            try {
                return (UnixSockAddr) lib.send(receiver_, UniversalSockAddrLibraryGen.AS_UNIX_SOCK_ADDR);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static final class Delegate extends UniversalSockAddrLibrary {

        @Child private UniversalSockAddrLibrary delegateLibrary;

        Delegate(UniversalSockAddrLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public int getFamily(UniversalSockAddr receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getFamily((UniversalSockAddr) delegate);
            } else {
                return this.delegateLibrary.getFamily(receiver_);
            }
        }

        @Override
        public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).asInet4SockAddr((UniversalSockAddr) delegate);
            } else {
                return this.delegateLibrary.asInet4SockAddr(receiver_);
            }
        }

        @Override
        public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).asInet6SockAddr((UniversalSockAddr) delegate);
            } else {
                return this.delegateLibrary.asInet6SockAddr(receiver_);
            }
        }

        @Override
        public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).asUnixSockAddr((UniversalSockAddr) delegate);
            } else {
                return this.delegateLibrary.asUnixSockAddr(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static final class CachedToUncachedDispatch extends UniversalSockAddrLibrary {

        @TruffleBoundary
        @Override
        public int getFamily(UniversalSockAddr receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getFamily(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).asInet4SockAddr(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).asInet6SockAddr(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).asUnixSockAddr(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends UniversalSockAddrLibrary implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public int getFamily(UniversalSockAddr receiver_) {
            return INSTANCE.getUncached(receiver_).getFamily(receiver_);
        }

        @TruffleBoundary
        @Override
        public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver_) {
            return INSTANCE.getUncached(receiver_).asInet4SockAddr(receiver_);
        }

        @TruffleBoundary
        @Override
        public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver_) {
            return INSTANCE.getUncached(receiver_).asInet6SockAddr(receiver_);
        }

        @TruffleBoundary
        @Override
        public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver_) {
            return INSTANCE.getUncached(receiver_).asUnixSockAddr(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(UniversalSockAddrLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(UniversalSockAddrLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

    }
    @GeneratedBy(UniversalSockAddrLibrary.class)
    private abstract static class CachedDispatch extends UniversalSockAddrLibrary {

        @Child UniversalSockAddrLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(UniversalSockAddrLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public int getFamily(UniversalSockAddr receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    UniversalSockAddrLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getFamily(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Inet4SockAddr asInet4SockAddr(UniversalSockAddr receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    UniversalSockAddrLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.asInet4SockAddr(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Inet6SockAddr asInet6SockAddr(UniversalSockAddr receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    UniversalSockAddrLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.asInet6SockAddr(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public UnixSockAddr asUnixSockAddr(UniversalSockAddr receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    UniversalSockAddrLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.asUnixSockAddr(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(UniversalSockAddr receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                UniversalSockAddrLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        UniversalSockAddrLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
