// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.complex;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess.ReadDoubleNode;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.AbsNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.AddNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.BoolNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ComplexEqNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ComplexNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ComplexValue;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ConjugateNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.DivNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.EqNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.FormatNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.GeNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.GetNewArgsNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.GtNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.HashNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ImagNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.LeNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.LtNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.MulNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.NeNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.NegNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.PosNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.PowerNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.RealNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.SubNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ToComplexValueNode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyComplexCheckExactNode;
import com.oracle.graal.python.lib.PyComplexCheckExactNodeGen;
import com.oracle.graal.python.lib.PyComplexCheckNode;
import com.oracle.graal.python.lib.PyComplexCheckNodeGen;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyFloatCheckNode;
import com.oracle.graal.python.lib.PyFloatCheckNodeGen;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyLongAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyLongCheckNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;

@GeneratedBy(ComplexBuiltins.class)
@SuppressWarnings("javadoc")
public final class ComplexBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(ComplexNodeFactory.getInstance(), AbsNodeFactory.getInstance(), AddNodeFactory.getInstance(), DivNodeFactory.getInstance(), MulNodeFactory.getInstance(), SubNodeFactory.getInstance(), PowerNodeFactory.getInstance(), EqNodeFactory.getInstance(), NeNodeFactory.getInstance(), GeNodeFactory.getInstance(), GtNodeFactory.getInstance(), LtNodeFactory.getInstance(), LeNodeFactory.getInstance(), ReprNodeFactory.getInstance(), FormatNodeFactory.getInstance(), BoolNodeFactory.getInstance(), NegNodeFactory.getInstance(), PosNodeFactory.getInstance(), GetNewArgsNodeFactory.getInstance(), RealNodeFactory.getInstance(), ImagNodeFactory.getInstance(), HashNodeFactory.getInstance(), ConjugateNodeFactory.getInstance());
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link ToComplexValueNode#doComplex}
     *     Activation probability: 0.23929
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ToComplexValueNode#doNative}
     *     Activation probability: 0.20714
     *     With/without class size: 9/9 bytes
     *   Specialization {@link ToComplexValueNode#doInt}
     *     Activation probability: 0.17500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link ToComplexValueNode#doDouble}
     *     Activation probability: 0.14286
     *     With/without class size: 5/0 bytes
     *   Specialization {@link ToComplexValueNode#doIntGeneric}
     *     Activation probability: 0.11071
     *     With/without class size: 7/15 bytes
     *   Specialization {@link ToComplexValueNode#doFloatGeneric}
     *     Activation probability: 0.07857
     *     With/without class size: 6/14 bytes
     *   Specialization {@link ToComplexValueNode#doOther}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre> */
    @GeneratedBy(ToComplexValueNode.class)
    @SuppressWarnings("javadoc")
    static final class ToComplexValueNodeGen {

        private static final StateField NATIVE_TO_COMPLEX_VALUE_NODE_NATIVE_STATE_0_UPDATER = StateField.create(NativeData.lookup_(), "native_state_0_");
        private static final StateField INT_GENERIC_TO_COMPLEX_VALUE_NODE_INT_GENERIC_STATE_0_UPDATER = StateField.create(IntGenericData.lookup_(), "intGeneric_state_0_");
        private static final StateField FLOAT_GENERIC_TO_COMPLEX_VALUE_NODE_FLOAT_GENERIC_STATE_0_UPDATER = StateField.create(FloatGenericData.lookup_(), "floatGeneric_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static ToComplexValueNode getUncached() {
            return ToComplexValueNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#native_cache}
         * <li>{@link Inlined#intGeneric_cache}
         * <li>{@link Inlined#floatGeneric_cache}
         * </ul> */
        @NeverDefault
        public static ToComplexValueNode inline(@RequiredField(bits = 7, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new ToComplexValueNodeGen.Inlined(target);
        }

        @GeneratedBy(ToComplexValueNode.class)
        @DenyReplace
        private static final class Inlined extends ToComplexValueNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ToComplexValueNode#doComplex}
             *   1: SpecializationActive {@link ToComplexValueNode#doNative}
             *   2: SpecializationActive {@link ToComplexValueNode#doInt}
             *   3: SpecializationActive {@link ToComplexValueNode#doDouble}
             *   4: SpecializationActive {@link ToComplexValueNode#doIntGeneric}
             *   5: SpecializationActive {@link ToComplexValueNode#doFloatGeneric}
             *   6: SpecializationActive {@link ToComplexValueNode#doOther}
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<NativeData> native_cache;
            private final ReferenceField<IntGenericData> intGeneric_cache;
            private final ReferenceField<FloatGenericData> floatGeneric_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doNative}
             *   Parameter: {@link PyComplexCheckNode} check
             *   Inline method: {@link PyComplexCheckNodeGen#inline}</pre> */
            private final PyComplexCheckNode native_check_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doIntGeneric}
             *   Parameter: {@link PyLongCheckNode} check
             *   Inline method: {@link PyLongCheckNodeGen#inline}</pre> */
            private final PyLongCheckNode intGeneric_check_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doIntGeneric}
             *   Parameter: {@link PyLongAsDoubleNode} longAsDoubleNode
             *   Inline method: {@link PyLongAsDoubleNodeGen#inline}</pre> */
            private final PyLongAsDoubleNode intGeneric_longAsDoubleNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *   Parameter: {@link PyFloatCheckNode} check
             *   Inline method: {@link PyFloatCheckNodeGen#inline}</pre> */
            private final PyFloatCheckNode floatGeneric_check_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *   Parameter: {@link PyFloatAsDoubleNode} floatAsDoubleNode
             *   Inline method: {@link PyFloatAsDoubleNodeGen#inline}</pre> */
            private final PyFloatAsDoubleNode floatGeneric_floatAsDoubleNode_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ToComplexValueNode.class);
                this.state_0_ = target.getState(0, 7);
                this.native_cache = target.getReference(1, NativeData.class);
                this.intGeneric_cache = target.getReference(2, IntGenericData.class);
                this.floatGeneric_cache = target.getReference(3, FloatGenericData.class);
                this.native_check_ = PyComplexCheckNodeGen.inline(InlineTarget.create(PyComplexCheckNode.class, NATIVE_TO_COMPLEX_VALUE_NODE_NATIVE_STATE_0_UPDATER.subUpdater(2, 3), ReferenceField.create(NativeData.lookup_(), "native_check__field1_", Node.class)));
                this.intGeneric_check_ = PyLongCheckNodeGen.inline(InlineTarget.create(PyLongCheckNode.class, INT_GENERIC_TO_COMPLEX_VALUE_NODE_INT_GENERIC_STATE_0_UPDATER.subUpdater(2, 5), ReferenceField.create(IntGenericData.lookup_(), "intGeneric_check__field1_", Node.class)));
                this.intGeneric_longAsDoubleNode_ = PyLongAsDoubleNodeGen.inline(InlineTarget.create(PyLongAsDoubleNode.class, INT_GENERIC_TO_COMPLEX_VALUE_NODE_INT_GENERIC_STATE_0_UPDATER.subUpdater(7, 7), INT_GENERIC_TO_COMPLEX_VALUE_NODE_INT_GENERIC_STATE_0_UPDATER.subUpdater(14, 5), ReferenceField.create(IntGenericData.lookup_(), "intGeneric_longAsDoubleNode__field2_", Node.class), ReferenceField.create(IntGenericData.lookup_(), "intGeneric_longAsDoubleNode__field3_", Node.class)));
                this.floatGeneric_check_ = PyFloatCheckNodeGen.inline(InlineTarget.create(PyFloatCheckNode.class, FLOAT_GENERIC_TO_COMPLEX_VALUE_NODE_FLOAT_GENERIC_STATE_0_UPDATER.subUpdater(2, 4), ReferenceField.create(FloatGenericData.lookup_(), "floatGeneric_check__field1_", Node.class)));
                this.floatGeneric_floatAsDoubleNode_ = PyFloatAsDoubleNodeGen.inline(InlineTarget.create(PyFloatAsDoubleNode.class, FLOAT_GENERIC_TO_COMPLEX_VALUE_NODE_FLOAT_GENERIC_STATE_0_UPDATER.subUpdater(6, 7), ReferenceField.create(FloatGenericData.lookup_(), "floatGeneric_floatAsDoubleNode__field1_", Node.class), ReferenceField.create(FloatGenericData.lookup_(), "floatGeneric_floatAsDoubleNode__field2_", Node.class)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doComplex(PComplex)] */) && arg1Value instanceof PComplex) {
                    return false;
                }
                if (arg1Value instanceof PythonAbstractNativeObject) {
                    NativeData s1_ = this.native_cache.get(arg0Value);
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                    if ((s1_ == null || ((s1_.native_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doNative(Node, PythonAbstractNativeObject, PyComplexCheckNode, ReadDoubleNode), guardIndex=0] */ || (this.native_check_.execute(s1_, arg1Value_)))) {
                        return false;
                    }
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doInt(int)] */) && arg1Value instanceof Integer) {
                    return false;
                }
                if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doDouble(double)] */) && arg1Value instanceof Double) {
                    return false;
                }
                {
                    IntGenericData s4_ = this.intGeneric_cache.get(arg0Value);
                    if ((s4_ == null || ((s4_.intGeneric_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode), guardIndex=0] */ || (this.intGeneric_check_.execute(s4_, arg1Value)))) {
                        return false;
                    }
                }
                {
                    FloatGenericData s5_ = this.floatGeneric_cache.get(arg0Value);
                    if ((s5_ == null || ((s5_.floatGeneric_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode), guardIndex=0] */ || (this.floatGeneric_check_.execute(s5_, arg1Value)))) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public ComplexValue execute(Node arg0Value, Object arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doComplex(PComplex)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doNative(Node, PythonAbstractNativeObject, PyComplexCheckNode, ReadDoubleNode)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doInt(int)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doDouble(double)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doOther(Node, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doComplex(PComplex)] */ && arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        return ToComplexValueNode.doComplex(arg1Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doNative(Node, PythonAbstractNativeObject, PyComplexCheckNode, ReadDoubleNode)] */ && arg1Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                        NativeData s1_ = this.native_cache.get(arg0Value);
                        if (s1_ != null) {
                            if ((s1_.native_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.native_check_.execute(s1_, arg1Value_))) {
                                return ToComplexValueNode.doNative(s1_, arg1Value_, this.native_check_, s1_.read_);
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doInt(int)] */ && arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        return ToComplexValueNode.doInt(arg1Value_);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doDouble(double)] */ && arg1Value instanceof Double) {
                        double arg1Value_ = (double) arg1Value;
                        return ToComplexValueNode.doDouble(arg1Value_);
                    }
                    if ((state_0 & 0b1110000) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode)] || SpecializationActive[ComplexBuiltins.ToComplexValueNode.doOther(Node, Object)] */) {
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode)] */) {
                            IntGenericData s4_ = this.intGeneric_cache.get(arg0Value);
                            if (s4_ != null) {
                                if ((s4_.intGeneric_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.intGeneric_check_.execute(s4_, arg1Value))) {
                                    return ToComplexValueNode.doIntGeneric(s4_, arg1Value, this.intGeneric_check_, this.intGeneric_longAsDoubleNode_);
                                }
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode)] */) {
                            FloatGenericData s5_ = this.floatGeneric_cache.get(arg0Value);
                            if (s5_ != null) {
                                if ((s5_.floatGeneric_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.floatGeneric_check_.execute(s5_, arg1Value))) {
                                    return ToComplexValueNode.doFloatGeneric(s5_, arg1Value, this.floatGeneric_check_, this.floatGeneric_floatAsDoubleNode_);
                                }
                            }
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ComplexBuiltins.ToComplexValueNode.doOther(Node, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                return ToComplexValueNode.doOther(arg0Value, arg1Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private ComplexValue executeAndSpecialize(Node arg0Value, Object arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg1Value instanceof PComplex) {
                    PComplex arg1Value_ = (PComplex) arg1Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doComplex(PComplex)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToComplexValueNode.doComplex(arg1Value_);
                }
                if (arg1Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                    while (true) {
                        int count1_ = 0;
                        NativeData s1_ = this.native_cache.getVolatile(arg0Value);
                        NativeData s1_original = s1_;
                        while (s1_ != null) {
                            if ((s1_.native_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.native_check_.execute(s1_, arg1Value_))) {
                                break;
                            }
                            if ((s1_.native_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                                count1_++;
                            }
                            s1_ = null;
                            break;
                        }
                        if (s1_ == null && count1_ < 1) {
                            {
                                s1_ = arg0Value.insert(new NativeData());
                                if (((s1_.native_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doNative(Node, PythonAbstractNativeObject, PyComplexCheckNode, ReadDoubleNode), guardIndex=0] */) {
                                    s1_.native_state_0_ = s1_.native_state_0_ | 0b1 /* add GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doNative(Node, PythonAbstractNativeObject, PyComplexCheckNode, ReadDoubleNode), guardIndex=0] */;
                                    if (!this.native_cache.compareAndSet(arg0Value, s1_original, s1_)) {
                                        continue;
                                    }
                                    s1_original = s1_;
                                    s1_ = arg0Value.insert(new NativeData(s1_));
                                }
                                if ((this.native_check_.execute(s1_, arg1Value_))) {
                                    ReadDoubleNode read__ = s1_.insert((ReadDoubleNode.create()));
                                    Objects.requireNonNull(read__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                    s1_.read_ = read__;
                                    s1_.native_state_0_ = s1_.native_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                                    if (!this.native_cache.compareAndSet(arg0Value, s1_original, s1_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doNative(Node, PythonAbstractNativeObject, PyComplexCheckNode, ReadDoubleNode)] */;
                                    this.state_0_.set(arg0Value, state_0);
                                } else {
                                    s1_ = null;
                                }
                            }
                        }
                        if (s1_ != null) {
                            return ToComplexValueNode.doNative(s1_, arg1Value_, this.native_check_, s1_.read_);
                        }
                        break;
                    }
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doInt(int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToComplexValueNode.doInt(arg1Value_);
                }
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (double) arg1Value;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doDouble(double)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ToComplexValueNode.doDouble(arg1Value_);
                }
                while (true) {
                    int count4_ = 0;
                    IntGenericData s4_ = this.intGeneric_cache.getVolatile(arg0Value);
                    IntGenericData s4_original = s4_;
                    while (s4_ != null) {
                        if ((s4_.intGeneric_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.intGeneric_check_.execute(s4_, arg1Value))) {
                            break;
                        }
                        if ((s4_.intGeneric_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                            count4_++;
                        }
                        s4_ = null;
                        break;
                    }
                    if (s4_ == null && count4_ < 1) {
                        {
                            s4_ = arg0Value.insert(new IntGenericData());
                            if (((s4_.intGeneric_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode), guardIndex=0] */) {
                                s4_.intGeneric_state_0_ = s4_.intGeneric_state_0_ | 0b1 /* add GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode), guardIndex=0] */;
                                if (!this.intGeneric_cache.compareAndSet(arg0Value, s4_original, s4_)) {
                                    continue;
                                }
                                s4_original = s4_;
                                s4_ = arg0Value.insert(new IntGenericData(s4_));
                            }
                            if ((this.intGeneric_check_.execute(s4_, arg1Value))) {
                                s4_.intGeneric_state_0_ = s4_.intGeneric_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                                if (!this.intGeneric_cache.compareAndSet(arg0Value, s4_original, s4_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doIntGeneric(Node, Object, PyLongCheckNode, PyLongAsDoubleNode)] */;
                                this.state_0_.set(arg0Value, state_0);
                            } else {
                                s4_ = null;
                            }
                        }
                    }
                    if (s4_ != null) {
                        return ToComplexValueNode.doIntGeneric(s4_, arg1Value, this.intGeneric_check_, this.intGeneric_longAsDoubleNode_);
                    }
                    break;
                }
                while (true) {
                    int count5_ = 0;
                    FloatGenericData s5_ = this.floatGeneric_cache.getVolatile(arg0Value);
                    FloatGenericData s5_original = s5_;
                    while (s5_ != null) {
                        if ((s5_.floatGeneric_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.floatGeneric_check_.execute(s5_, arg1Value))) {
                            break;
                        }
                        if ((s5_.floatGeneric_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                            count5_++;
                        }
                        s5_ = null;
                        break;
                    }
                    if (s5_ == null && count5_ < 1) {
                        {
                            s5_ = arg0Value.insert(new FloatGenericData());
                            if (((s5_.floatGeneric_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode), guardIndex=0] */) {
                                s5_.floatGeneric_state_0_ = s5_.floatGeneric_state_0_ | 0b1 /* add GuardActive[specialization=ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode), guardIndex=0] */;
                                if (!this.floatGeneric_cache.compareAndSet(arg0Value, s5_original, s5_)) {
                                    continue;
                                }
                                s5_original = s5_;
                                s5_ = arg0Value.insert(new FloatGenericData(s5_));
                            }
                            if ((this.floatGeneric_check_.execute(s5_, arg1Value))) {
                                s5_.floatGeneric_state_0_ = s5_.floatGeneric_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                                if (!this.floatGeneric_cache.compareAndSet(arg0Value, s5_original, s5_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doFloatGeneric(Node, Object, PyFloatCheckNode, PyFloatAsDoubleNode)] */;
                                this.state_0_.set(arg0Value, state_0);
                            } else {
                                s5_ = null;
                            }
                        }
                    }
                    if (s5_ != null) {
                        return ToComplexValueNode.doFloatGeneric(s5_, arg1Value, this.floatGeneric_check_, this.floatGeneric_floatAsDoubleNode_);
                    }
                    break;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[ComplexBuiltins.ToComplexValueNode.doOther(Node, Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return ToComplexValueNode.doOther(arg0Value, arg1Value);
            }

        }
        @GeneratedBy(ToComplexValueNode.class)
        @DenyReplace
        private static final class NativeData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0: GuardActive[guardIndex=0] {@link ToComplexValueNode#doNative}
             *   1: SpecializationCachesInitialized {@link ToComplexValueNode#doNative}
             *   2-4: InlinedCache
             *        Specialization: {@link ToComplexValueNode#doNative}
             *        Parameter: {@link PyComplexCheckNode} check
             *        Inline method: {@link PyComplexCheckNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int native_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doNative}
             *   Parameter: {@link PyComplexCheckNode} check
             *   Inline method: {@link PyComplexCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node native_check__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doNative}
             *   Parameter: {@link ReadDoubleNode} read</pre> */
            @Child ReadDoubleNode read_;

            NativeData() {
            }

            NativeData(NativeData delegate) {
                this.native_state_0_ = delegate.native_state_0_;
                this.native_check__field1_ = delegate.native_check__field1_;
                this.read_ = delegate.read_;
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ToComplexValueNode.class)
        @DenyReplace
        private static final class IntGenericData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0: GuardActive[guardIndex=0] {@link ToComplexValueNode#doIntGeneric}
             *   1: SpecializationCachesInitialized {@link ToComplexValueNode#doIntGeneric}
             *   2-6: InlinedCache
             *        Specialization: {@link ToComplexValueNode#doIntGeneric}
             *        Parameter: {@link PyLongCheckNode} check
             *        Inline method: {@link PyLongCheckNodeGen#inline}
             *   7-13: InlinedCache
             *        Specialization: {@link ToComplexValueNode#doIntGeneric}
             *        Parameter: {@link PyLongAsDoubleNode} longAsDoubleNode
             *        Inline method: {@link PyLongAsDoubleNodeGen#inline}
             *   14-18: InlinedCache
             *        Specialization: {@link ToComplexValueNode#doIntGeneric}
             *        Parameter: {@link PyLongAsDoubleNode} longAsDoubleNode
             *        Inline method: {@link PyLongAsDoubleNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int intGeneric_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doIntGeneric}
             *   Parameter: {@link PyLongCheckNode} check
             *   Inline method: {@link PyLongCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node intGeneric_check__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doIntGeneric}
             *   Parameter: {@link PyLongAsDoubleNode} longAsDoubleNode
             *   Inline method: {@link PyLongAsDoubleNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node intGeneric_longAsDoubleNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doIntGeneric}
             *   Parameter: {@link PyLongAsDoubleNode} longAsDoubleNode
             *   Inline method: {@link PyLongAsDoubleNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node intGeneric_longAsDoubleNode__field3_;

            IntGenericData() {
            }

            IntGenericData(IntGenericData delegate) {
                this.intGeneric_state_0_ = delegate.intGeneric_state_0_;
                this.intGeneric_check__field1_ = delegate.intGeneric_check__field1_;
                this.intGeneric_longAsDoubleNode__field2_ = delegate.intGeneric_longAsDoubleNode__field2_;
                this.intGeneric_longAsDoubleNode__field3_ = delegate.intGeneric_longAsDoubleNode__field3_;
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ToComplexValueNode.class)
        @DenyReplace
        private static final class FloatGenericData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0: GuardActive[guardIndex=0] {@link ToComplexValueNode#doFloatGeneric}
             *   1: SpecializationCachesInitialized {@link ToComplexValueNode#doFloatGeneric}
             *   2-5: InlinedCache
             *        Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *        Parameter: {@link PyFloatCheckNode} check
             *        Inline method: {@link PyFloatCheckNodeGen#inline}
             *   6-12: InlinedCache
             *        Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *        Parameter: {@link PyFloatAsDoubleNode} floatAsDoubleNode
             *        Inline method: {@link PyFloatAsDoubleNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int floatGeneric_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *   Parameter: {@link PyFloatCheckNode} check
             *   Inline method: {@link PyFloatCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node floatGeneric_check__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *   Parameter: {@link PyFloatAsDoubleNode} floatAsDoubleNode
             *   Inline method: {@link PyFloatAsDoubleNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node floatGeneric_floatAsDoubleNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ToComplexValueNode#doFloatGeneric}
             *   Parameter: {@link PyFloatAsDoubleNode} floatAsDoubleNode
             *   Inline method: {@link PyFloatAsDoubleNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node floatGeneric_floatAsDoubleNode__field2_;

            FloatGenericData() {
            }

            FloatGenericData(FloatGenericData delegate) {
                this.floatGeneric_state_0_ = delegate.floatGeneric_state_0_;
                this.floatGeneric_check__field1_ = delegate.floatGeneric_check__field1_;
                this.floatGeneric_floatAsDoubleNode__field1_ = delegate.floatGeneric_floatAsDoubleNode__field1_;
                this.floatGeneric_floatAsDoubleNode__field2_ = delegate.floatGeneric_floatAsDoubleNode__field2_;
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ToComplexValueNode.class)
        @DenyReplace
        private static final class Uncached extends ToComplexValueNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public ComplexValue execute(Node arg0Value, Object arg1Value) {
                if (arg1Value instanceof PComplex) {
                    PComplex arg1Value_ = (PComplex) arg1Value;
                    return ToComplexValueNode.doComplex(arg1Value_);
                }
                if (arg1Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                    if (((PyComplexCheckNodeGen.getUncached()).execute(arg0Value, arg1Value_))) {
                        return ToComplexValueNode.doNative(arg0Value, arg1Value_, (PyComplexCheckNodeGen.getUncached()), (ReadDoubleNode.getUncached()));
                    }
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return ToComplexValueNode.doInt(arg1Value_);
                }
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (double) arg1Value;
                    return ToComplexValueNode.doDouble(arg1Value_);
                }
                if (((PyLongCheckNode.getUncached()).execute(arg0Value, arg1Value))) {
                    return ToComplexValueNode.doIntGeneric(arg0Value, arg1Value, (PyLongCheckNode.getUncached()), (PyLongAsDoubleNodeGen.getUncached()));
                }
                if (((PyFloatCheckNodeGen.getUncached()).execute(arg0Value, arg1Value))) {
                    return ToComplexValueNode.doFloatGeneric(arg0Value, arg1Value, (PyFloatCheckNodeGen.getUncached()), (PyFloatAsDoubleNodeGen.getUncached()));
                }
                return ToComplexValueNode.doOther(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(ComplexNode.class)
    static final class ComplexNodeFactory implements NodeFactory<ComplexNode> {

        private static final ComplexNodeFactory COMPLEX_NODE_FACTORY_INSTANCE = new ComplexNodeFactory();

        private ComplexNodeFactory() {
        }

        @Override
        public Class<ComplexNode> getNodeClass() {
            return ComplexNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ComplexNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ComplexNode> getInstance() {
            return COMPLEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ComplexNode create() {
            return new ComplexNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ComplexNode#complex}
         *     Activation probability: 1.00000
         *     With/without class size: 48/28 bytes
         * </pre> */
        @GeneratedBy(ComplexNode.class)
        @SuppressWarnings("javadoc")
        static final class ComplexNodeGen extends ComplexNode {

            private static final StateField STATE_0_ComplexNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link PyComplexCheckExactNode} check
             *   Inline method: {@link PyComplexCheckExactNodeGen#inline}</pre> */
            private static final PyComplexCheckExactNode INLINED_CHECK_ = PyComplexCheckExactNodeGen.inline(InlineTarget.create(PyComplexCheckExactNode.class, STATE_0_ComplexNode_UPDATER.subUpdater(0, 21), ReferenceField.create(MethodHandles.lookup(), "check__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "check__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_ComplexNode_UPDATER.subUpdater(21, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy} factory
             *   Inline method: {@link com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy INLINED_FACTORY_ = com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy.class, STATE_0_ComplexNode_UPDATER.subUpdater(28, 1), ReferenceField.create(MethodHandles.lookup(), "factory__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0-20: InlinedCache
             *        Specialization: {@link ComplexNode#complex}
             *        Parameter: {@link PyComplexCheckExactNode} check
             *        Inline method: {@link PyComplexCheckExactNodeGen#inline}
             *   21-27: InlinedCache
             *        Specialization: {@link ComplexNode#complex}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   28: InlinedCache
             *        Specialization: {@link ComplexNode#complex}
             *        Parameter: {@link com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy} factory
             *        Inline method: {@link com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link PyComplexCheckExactNode} check
             *   Inline method: {@link PyComplexCheckExactNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node check__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link PyComplexCheckExactNode} check
             *   Inline method: {@link PyComplexCheckExactNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node check__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexNode#complex}
             *   Parameter: {@link com.oracle.graal.python.runtime.object.PythonObjectFactory.Lazy} factory
             *   Inline method: {@link com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node factory__field1_;

            private ComplexNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return ComplexNode.complex(arg0Value, inliningTarget__, INLINED_CHECK_, INLINED_TO_COMPLEX_VALUE_NODE_, INLINED_FACTORY_);
                }
            }

        }
    }
    @GeneratedBy(AbsNode.class)
    public static final class AbsNodeFactory implements NodeFactory<AbsNode> {

        private static final AbsNodeFactory ABS_NODE_FACTORY_INSTANCE = new AbsNodeFactory();

        private AbsNodeFactory() {
        }

        @Override
        public Class<AbsNode> getNodeClass() {
            return AbsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public AbsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AbsNode> getInstance() {
            return ABS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AbsNode create() {
            return new AbsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre> */
        @GeneratedBy(AbsNode.class)
        @SuppressWarnings("javadoc")
        public static final class AbsNodeGen extends AbsNode {

            private static final StateField STATE_0_AbsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_AbsNode_UPDATER.subUpdater(0, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.nodes.PRaiseNode.Lazy INLINED_RAISE_NODE_ = com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.nodes.PRaiseNode.Lazy.class, STATE_0_AbsNode_UPDATER.subUpdater(7, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   7: InlinedCache
             *        Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *        Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *        Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AbsNode#abs(Object, Node, ToComplexValueNode, com.oracle.graal.python.nodes.PRaiseNode.Lazy)}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private AbsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return AbsNode.abs(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, INLINED_RAISE_NODE_);
                }
            }

            @Override
            public double executeDouble(Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return AbsNode.abs(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, INLINED_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(AddNode.class)
    static final class AddNodeFactory implements NodeFactory<AddNode> {

        private static final AddNodeFactory ADD_NODE_FACTORY_INSTANCE = new AddNodeFactory();

        private AddNodeFactory() {
        }

        @Override
        public Class<AddNode> getNodeClass() {
            return AddNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public AddNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<AddNode> getInstance() {
            return ADD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AddNode create() {
            return new AddNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AddNode#doInt}
         *     Activation probability: 0.48333
         *     With/without class size: 9/0 bytes
         *   Specialization {@link AddNode#doDouble}
         *     Activation probability: 0.33333
         *     With/without class size: 8/0 bytes
         *   Specialization {@link AddNode#doGeneric}
         *     Activation probability: 0.18333
         *     With/without class size: 12/26 bytes
         * </pre> */
        @GeneratedBy(AddNode.class)
        @SuppressWarnings("javadoc")
        static final class AddNodeGen extends AddNode {

            private static final StateField GENERIC_ADD_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AddNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_GENERIC_TO_COMPLEX_LEFT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, GENERIC_ADD_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(GenericData.lookup_(), "generic_toComplexLeft__field1_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_toComplexLeft__field2_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_toComplexLeft__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AddNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_GENERIC_TO_COMPLEX_RIGHT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, GENERIC_ADD_NODE_GENERIC_STATE_0_UPDATER.subUpdater(7, 7), ReferenceField.create(GenericData.lookup_(), "generic_toComplexRight__field1_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_toComplexRight__field2_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_toComplexRight__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link AddNode#doGeneric}
             *   Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_GENERIC_NOT_IMPLEMENTED_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, GENERIC_ADD_NODE_GENERIC_STATE_0_UPDATER.subUpdater(14, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AddNode#doInt}
             *   1: SpecializationActive {@link AddNode#doDouble}
             *   2: SpecializationActive {@link AddNode#doGeneric}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AddNode#doInt}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory;
            @Child private GenericData generic_cache;

            private AddNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doInt(PComplex, int, PythonObjectFactory)] || SpecializationActive[ComplexBuiltins.AddNode.doDouble(PComplex, double, PythonObjectFactory)] || SpecializationActive[ComplexBuiltins.AddNode.doGeneric(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */) {
                    if ((state_0 & 0b11) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doInt(PComplex, int, PythonObjectFactory)] || SpecializationActive[ComplexBuiltins.AddNode.doDouble(PComplex, double, PythonObjectFactory)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doInt(PComplex, int, PythonObjectFactory)] */ && arg1Value instanceof Integer) {
                            int arg1Value_ = (int) arg1Value;
                            {
                                PythonObjectFactory factory_ = this.factory;
                                if (factory_ != null) {
                                    return AddNode.doInt(arg0Value_, arg1Value_, factory_);
                                }
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doDouble(PComplex, double, PythonObjectFactory)] */ && arg1Value instanceof Double) {
                            double arg1Value_ = (double) arg1Value;
                            {
                                PythonObjectFactory factory_1 = this.factory;
                                if (factory_1 != null) {
                                    return AddNode.doDouble(arg0Value_, arg1Value_, factory_1);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doGeneric(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */) {
                        GenericData s2_ = this.generic_cache;
                        if (s2_ != null) {
                            {
                                PythonObjectFactory factory_2 = this.factory;
                                if (factory_2 != null) {
                                    Node inliningTarget__ = (s2_);
                                    return AddNode.doGeneric(arg0Value, arg1Value, inliningTarget__, INLINED_GENERIC_TO_COMPLEX_LEFT_, INLINED_GENERIC_TO_COMPLEX_RIGHT_, INLINED_GENERIC_NOT_IMPLEMENTED_PROFILE_, factory_2);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        PythonObjectFactory factory_;
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = this.insert((PythonObjectFactory.create()));
                            if (factory_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.AddNode.doInt(PComplex, int, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return AddNode.doInt(arg0Value_, arg1Value_, factory_);
                    }
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (double) arg1Value;
                        PythonObjectFactory factory_1;
                        PythonObjectFactory factory_1_shared = this.factory;
                        if (factory_1_shared != null) {
                            factory_1 = factory_1_shared;
                        } else {
                            factory_1 = this.insert((PythonObjectFactory.create()));
                            if (factory_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_1;
                        }
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.AddNode.doDouble(PComplex, double, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return AddNode.doDouble(arg0Value_, arg1Value_, factory_1);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    GenericData s2_ = this.insert(new GenericData());
                    inliningTarget__ = (s2_);
                    PythonObjectFactory factory_2;
                    PythonObjectFactory factory_2_shared = this.factory;
                    if (factory_2_shared != null) {
                        factory_2 = factory_2_shared;
                    } else {
                        factory_2 = s2_.insert((PythonObjectFactory.create()));
                        if (factory_2 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        this.factory = factory_2;
                    }
                    VarHandle.storeStoreFence();
                    this.generic_cache = s2_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.AddNode.doGeneric(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return AddNode.doGeneric(arg0Value, arg1Value, inliningTarget__, INLINED_GENERIC_TO_COMPLEX_LEFT_, INLINED_GENERIC_TO_COMPLEX_RIGHT_, INLINED_GENERIC_NOT_IMPLEMENTED_PROFILE_, factory_2);
                }
            }

            @GeneratedBy(AddNode.class)
            @DenyReplace
            private static final class GenericData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-6: InlinedCache
                 *        Specialization: {@link AddNode#doGeneric}
                 *        Parameter: {@link ToComplexValueNode} toComplexLeft
                 *        Inline method: {@link ToComplexValueNodeGen#inline}
                 *   7-13: InlinedCache
                 *        Specialization: {@link AddNode#doGeneric}
                 *        Parameter: {@link ToComplexValueNode} toComplexRight
                 *        Inline method: {@link ToComplexValueNodeGen#inline}
                 *   14-15: InlinedCache
                 *        Specialization: {@link AddNode#doGeneric}
                 *        Parameter: {@link InlinedConditionProfile} notImplementedProfile
                 *        Inline method: {@link InlinedConditionProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddNode#doGeneric}
                 *   Parameter: {@link ToComplexValueNode} toComplexLeft
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexLeft__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddNode#doGeneric}
                 *   Parameter: {@link ToComplexValueNode} toComplexLeft
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexLeft__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddNode#doGeneric}
                 *   Parameter: {@link ToComplexValueNode} toComplexLeft
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexLeft__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddNode#doGeneric}
                 *   Parameter: {@link ToComplexValueNode} toComplexRight
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddNode#doGeneric}
                 *   Parameter: {@link ToComplexValueNode} toComplexRight
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexRight__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddNode#doGeneric}
                 *   Parameter: {@link ToComplexValueNode} toComplexRight
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexRight__field3_;

                GenericData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(DivNode.class)
    public static final class DivNodeFactory implements NodeFactory<DivNode> {

        private static final DivNodeFactory DIV_NODE_FACTORY_INSTANCE = new DivNodeFactory();

        private DivNodeFactory() {
        }

        @Override
        public Class<DivNode> getNodeClass() {
            return DivNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public DivNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<DivNode> getInstance() {
            return DIV_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DivNode create() {
            return new DivNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DivNode#doComplex}
         *     Activation probability: 1.00000
         *     With/without class size: 56/35 bytes
         * </pre> */
        @GeneratedBy(DivNode.class)
        @SuppressWarnings("javadoc")
        public static final class DivNodeGen extends DivNode {

            private static final StateField STATE_0_DivNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_LEFT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_DivNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexLeft__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexLeft__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexLeft__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_RIGHT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_DivNode_UPDATER.subUpdater(8, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexRight__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexRight__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexRight__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_NOT_IMPLEMENTED_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_DivNode_UPDATER.subUpdater(15, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link InlinedConditionProfile} topConditionProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_TOP_CONDITION_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_DivNode_UPDATER.subUpdater(17, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link InlinedConditionProfile} zeroDivisionProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_ZERO_DIVISION_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_DivNode_UPDATER.subUpdater(19, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.nodes.PRaiseNode.Lazy INLINED_RAISE_NODE_ = com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.nodes.PRaiseNode.Lazy.class, STATE_0_DivNode_UPDATER.subUpdater(21, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DivNode#doComplex}
             *   1-7: InlinedCache
             *        Specialization: {@link DivNode#doComplex}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   8-14: InlinedCache
             *        Specialization: {@link DivNode#doComplex}
             *        Parameter: {@link ToComplexValueNode} toComplexRight
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   15-16: InlinedCache
             *        Specialization: {@link DivNode#doComplex}
             *        Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   17-18: InlinedCache
             *        Specialization: {@link DivNode#doComplex}
             *        Parameter: {@link InlinedConditionProfile} topConditionProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   19-20: InlinedCache
             *        Specialization: {@link DivNode#doComplex}
             *        Parameter: {@link InlinedConditionProfile} zeroDivisionProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   21: InlinedCache
             *        Specialization: {@link DivNode#doComplex}
             *        Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *        Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexLeft__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexRight__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexRight__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private DivNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PythonObjectFactory, Lazy)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return DivNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_TO_COMPLEX_LEFT_, INLINED_TO_COMPLEX_RIGHT_, INLINED_NOT_IMPLEMENTED_PROFILE_, INLINED_TOP_CONDITION_PROFILE_, INLINED_ZERO_DIVISION_PROFILE_, factory__, INLINED_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public PComplex executeComplex(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return (PComplex) this.execute(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, PythonObjectFactory, Lazy)] */;
                    this.state_0_ = state_0;
                    return DivNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_TO_COMPLEX_LEFT_, INLINED_TO_COMPLEX_RIGHT_, INLINED_NOT_IMPLEMENTED_PROFILE_, INLINED_TOP_CONDITION_PROFILE_, INLINED_ZERO_DIVISION_PROFILE_, factory__, INLINED_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(MulNode.class)
    static final class MulNodeFactory implements NodeFactory<MulNode> {

        private static final MulNodeFactory MUL_NODE_FACTORY_INSTANCE = new MulNodeFactory();

        private MulNodeFactory() {
        }

        @Override
        public Class<MulNode> getNodeClass() {
            return MulNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public MulNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<MulNode> getInstance() {
            return MUL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MulNode create() {
            return new MulNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link MulNode#doComplex}
         *     Activation probability: 1.00000
         *     With/without class size: 52/30 bytes
         * </pre> */
        @GeneratedBy(MulNode.class)
        @SuppressWarnings("javadoc")
        static final class MulNodeGen extends MulNode {

            private static final StateField STATE_0_MulNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_LEFT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_MulNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexLeft__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexLeft__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexLeft__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_RIGHT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_MulNode_UPDATER.subUpdater(8, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexRight__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexRight__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexRight__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_NOT_IMPLEMENTED_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_MulNode_UPDATER.subUpdater(15, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MulNode#doComplex}
             *   1-7: InlinedCache
             *        Specialization: {@link MulNode#doComplex}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   8-14: InlinedCache
             *        Specialization: {@link MulNode#doComplex}
             *        Parameter: {@link ToComplexValueNode} toComplexRight
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   15-16: InlinedCache
             *        Specialization: {@link MulNode#doComplex}
             *        Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexLeft__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexRight__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexRight__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MulNode#doComplex}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private MulNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return MulNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_TO_COMPLEX_LEFT_, INLINED_TO_COMPLEX_RIGHT_, INLINED_NOT_IMPLEMENTED_PROFILE_, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.MulNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return MulNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_TO_COMPLEX_LEFT_, INLINED_TO_COMPLEX_RIGHT_, INLINED_NOT_IMPLEMENTED_PROFILE_, factory__);
                }
            }

        }
    }
    @GeneratedBy(SubNode.class)
    static final class SubNodeFactory implements NodeFactory<SubNode> {

        private static final SubNodeFactory SUB_NODE_FACTORY_INSTANCE = new SubNodeFactory();

        private SubNodeFactory() {
        }

        @Override
        public Class<SubNode> getNodeClass() {
            return SubNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public SubNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<SubNode> getInstance() {
            return SUB_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SubNode create() {
            return new SubNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SubNode#doComplex(PComplex, int, PythonObjectFactory)}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
         *     Activation probability: 0.35000
         *     With/without class size: 19/26 bytes
         * </pre> */
        @GeneratedBy(SubNode.class)
        @SuppressWarnings("javadoc")
        static final class SubNodeGen extends SubNode {

            private static final StateField COMPLEX1_SUB_NODE_COMPLEX1_STATE_0_UPDATER = StateField.create(Complex1Data.lookup_(), "complex1_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_COMPLEX1_TO_COMPLEX_LEFT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX1_SUB_NODE_COMPLEX1_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexLeft__field1_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexLeft__field2_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexLeft__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_COMPLEX1_TO_COMPLEX_RIGHT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX1_SUB_NODE_COMPLEX1_STATE_0_UPDATER.subUpdater(7, 7), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexRight__field1_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexRight__field2_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexRight__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
             *   Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_COMPLEX1_NOT_IMPLEMENTED_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, COMPLEX1_SUB_NODE_COMPLEX1_STATE_0_UPDATER.subUpdater(14, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SubNode#doComplex(PComplex, int, PythonObjectFactory)}
             *   1: SpecializationActive {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubNode#doComplex(PComplex, int, PythonObjectFactory)}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory;
            @Child private Complex1Data complex1_cache;

            private SubNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, int, PythonObjectFactory)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, int, PythonObjectFactory)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if (arg1Value instanceof Integer) {
                            int arg1Value_ = (int) arg1Value;
                            {
                                PythonObjectFactory factory_ = this.factory;
                                if (factory_ != null) {
                                    return SubNode.doComplex(arg0Value_, arg1Value_, factory_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */) {
                        Complex1Data s1_ = this.complex1_cache;
                        if (s1_ != null) {
                            {
                                PythonObjectFactory factory_1 = this.factory;
                                if (factory_1 != null) {
                                    Node inliningTarget__ = (s1_);
                                    return SubNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_COMPLEX1_TO_COMPLEX_LEFT_, INLINED_COMPLEX1_TO_COMPLEX_RIGHT_, INLINED_COMPLEX1_NOT_IMPLEMENTED_PROFILE_, factory_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        PythonObjectFactory factory_;
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = this.insert((PythonObjectFactory.create()));
                            if (factory_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, int, PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return SubNode.doComplex(arg0Value_, arg1Value_, factory_);
                    }
                }
                {
                    Node inliningTarget__ = null;
                    Complex1Data s1_ = this.insert(new Complex1Data());
                    inliningTarget__ = (s1_);
                    PythonObjectFactory factory_1;
                    PythonObjectFactory factory_1_shared = this.factory;
                    if (factory_1_shared != null) {
                        factory_1 = factory_1_shared;
                    } else {
                        factory_1 = s1_.insert((PythonObjectFactory.create()));
                        if (factory_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        this.factory = factory_1;
                    }
                    VarHandle.storeStoreFence();
                    this.complex1_cache = s1_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return SubNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_COMPLEX1_TO_COMPLEX_LEFT_, INLINED_COMPLEX1_TO_COMPLEX_RIGHT_, INLINED_COMPLEX1_NOT_IMPLEMENTED_PROFILE_, factory_1);
                }
            }

            @GeneratedBy(SubNode.class)
            @DenyReplace
            private static final class Complex1Data extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-6: InlinedCache
                 *        Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *        Parameter: {@link ToComplexValueNode} toComplexLeft
                 *        Inline method: {@link ToComplexValueNodeGen#inline}
                 *   7-13: InlinedCache
                 *        Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *        Parameter: {@link ToComplexValueNode} toComplexRight
                 *        Inline method: {@link ToComplexValueNodeGen#inline}
                 *   14-15: InlinedCache
                 *        Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *        Parameter: {@link InlinedConditionProfile} notImplementedProfile
                 *        Inline method: {@link InlinedConditionProfile#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int complex1_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *   Parameter: {@link ToComplexValueNode} toComplexLeft
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexLeft__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *   Parameter: {@link ToComplexValueNode} toComplexLeft
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexLeft__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *   Parameter: {@link ToComplexValueNode} toComplexLeft
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexLeft__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *   Parameter: {@link ToComplexValueNode} toComplexRight
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexRight__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *   Parameter: {@link ToComplexValueNode} toComplexRight
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexRight__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SubNode#doComplex(Object, Object, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, PythonObjectFactory)}
                 *   Parameter: {@link ToComplexValueNode} toComplexRight
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexRight__field3_;

                Complex1Data() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(PowerNode.class)
    static final class PowerNodeFactory implements NodeFactory<PowerNode> {

        private static final PowerNodeFactory POWER_NODE_FACTORY_INSTANCE = new PowerNodeFactory();

        private PowerNodeFactory() {
        }

        @Override
        public Class<PowerNode> getNodeClass() {
            return PowerNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PowerNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<PowerNode> getInstance() {
            return POWER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PowerNode create() {
            return new PowerNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PowerNode#doGeneric}
         *     Activation probability: 0.65000
         *     With/without class size: 37/35 bytes
         *   Specialization {@link PowerNode#error}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(PowerNode.class)
        @SuppressWarnings("javadoc")
        static final class PowerNodeGen extends PowerNode {

            private static final StateField STATE_0_PowerNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_GENERIC_TO_COMPLEX_LEFT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_PowerNode_UPDATER.subUpdater(2, 7), ReferenceField.create(MethodHandles.lookup(), "generic_toComplexLeft__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "generic_toComplexLeft__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "generic_toComplexLeft__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_GENERIC_TO_COMPLEX_RIGHT_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_PowerNode_UPDATER.subUpdater(9, 7), ReferenceField.create(MethodHandles.lookup(), "generic_toComplexRight__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "generic_toComplexRight__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "generic_toComplexRight__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private static final InlinedConditionProfile INLINED_GENERIC_NOT_IMPLEMENTED_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_PowerNode_UPDATER.subUpdater(16, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link InlinedBranchProfile} rightZeroProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_GENERIC_RIGHT_ZERO_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_PowerNode_UPDATER.subUpdater(18, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link InlinedBranchProfile} leftZeroProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_GENERIC_LEFT_ZERO_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_PowerNode_UPDATER.subUpdater(19, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link InlinedBranchProfile} smallPositiveProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_GENERIC_SMALL_POSITIVE_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_PowerNode_UPDATER.subUpdater(20, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link InlinedBranchProfile} smallNegativeProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_GENERIC_SMALL_NEGATIVE_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_PowerNode_UPDATER.subUpdater(21, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link InlinedBranchProfile} complexProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre> */
            private static final InlinedBranchProfile INLINED_GENERIC_COMPLEX_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_PowerNode_UPDATER.subUpdater(22, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.nodes.PRaiseNode.Lazy INLINED_GENERIC_RAISE_NODE_ = com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.nodes.PRaiseNode.Lazy.class, STATE_0_PowerNode_UPDATER.subUpdater(23, 1), ReferenceField.create(MethodHandles.lookup(), "generic_raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PowerNode#doGeneric}
             *   1: SpecializationActive {@link PowerNode#error}
             *   2-8: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   9-15: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link ToComplexValueNode} toComplexRight
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   16-17: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link InlinedConditionProfile} notImplementedProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   18: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} rightZeroProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   19: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} leftZeroProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   20: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} smallPositiveProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   21: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} smallNegativeProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   22: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link InlinedBranchProfile} complexProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   23: InlinedCache
             *        Specialization: {@link PowerNode#doGeneric}
             *        Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *        Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexLeft__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexRight__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_toComplexRight__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory generic_factory_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#doGeneric}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_raiseNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PowerNode#error}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode error_raiseNode_;

            private PowerNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, PNone, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, PythonObjectFactory, Lazy)] || SpecializationActive[ComplexBuiltins.PowerNode.error(Object, Object, Object, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, PNone, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, PythonObjectFactory, Lazy)] */ && arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone) arg2Value;
                        {
                            PythonObjectFactory factory__ = this.generic_factory_;
                            if (factory__ != null) {
                                Node inliningTarget__ = (this);
                                return PowerNode.doGeneric(arg0Value, arg1Value, arg2Value_, inliningTarget__, INLINED_GENERIC_TO_COMPLEX_LEFT_, INLINED_GENERIC_TO_COMPLEX_RIGHT_, INLINED_GENERIC_NOT_IMPLEMENTED_PROFILE_, INLINED_GENERIC_RIGHT_ZERO_PROFILE_, INLINED_GENERIC_LEFT_ZERO_PROFILE_, INLINED_GENERIC_SMALL_POSITIVE_PROFILE_, INLINED_GENERIC_SMALL_NEGATIVE_PROFILE_, INLINED_GENERIC_COMPLEX_PROFILE_, factory__, INLINED_GENERIC_RAISE_NODE_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.error(Object, Object, Object, PRaiseNode)] */) {
                        {
                            PRaiseNode raiseNode__ = this.error_raiseNode_;
                            if (raiseNode__ != null) {
                                if ((!(PGuards.isPNone(arg2Value)))) {
                                    return PowerNode.error(arg0Value, arg1Value, arg2Value, raiseNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone) arg2Value;
                        inliningTarget__ = (this);
                        PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                        Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.generic_factory_ = factory__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, PNone, Node, ToComplexValueNode, ToComplexValueNode, InlinedConditionProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, InlinedBranchProfile, PythonObjectFactory, Lazy)] */;
                        this.state_0_ = state_0;
                        return PowerNode.doGeneric(arg0Value, arg1Value, arg2Value_, inliningTarget__, INLINED_GENERIC_TO_COMPLEX_LEFT_, INLINED_GENERIC_TO_COMPLEX_RIGHT_, INLINED_GENERIC_NOT_IMPLEMENTED_PROFILE_, INLINED_GENERIC_RIGHT_ZERO_PROFILE_, INLINED_GENERIC_LEFT_ZERO_PROFILE_, INLINED_GENERIC_SMALL_POSITIVE_PROFILE_, INLINED_GENERIC_SMALL_NEGATIVE_PROFILE_, INLINED_GENERIC_COMPLEX_PROFILE_, factory__, INLINED_GENERIC_RAISE_NODE_);
                    }
                }
                if ((!(PGuards.isPNone(arg2Value)))) {
                    PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                    Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.error_raiseNode_ = raiseNode__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.PowerNode.error(Object, Object, Object, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return PowerNode.error(arg0Value, arg1Value, arg2Value, raiseNode__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value);
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ComplexEqNode#doComplex(PComplex, PComplex)}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
     *     Activation probability: 0.23095
     *     With/without class size: 15/31 bytes
     *   Specialization {@link ComplexEqNode#doComplexDouble}
     *     Activation probability: 0.18810
     *     With/without class size: 10/13 bytes
     *   Specialization {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
     *     Activation probability: 0.14524
     *     With/without class size: 8/14 bytes
     *   Specialization {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
     *     Activation probability: 0.10238
     *     With/without class size: 7/13 bytes
     *   Specialization {@link ComplexEqNode#doNotImplemented}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre> */
    @GeneratedBy(ComplexEqNode.class)
    @SuppressWarnings("javadoc")
    static final class ComplexEqNodeGen {

        private static final StateField COMPLEX1_COMPLEX_EQ_NODE_COMPLEX1_STATE_0_UPDATER = StateField.create(Complex1Data.lookup_(), "complex1_state_0_");
        private static final StateField COMPLEX_DOUBLE_COMPLEX_EQ_NODE_COMPLEX_DOUBLE_STATE_0_UPDATER = StateField.create(ComplexDoubleData.lookup_(), "complexDouble_state_0_");
        private static final StateField COMPLEX_INT0_COMPLEX_EQ_NODE_COMPLEX_INT0_STATE_0_UPDATER = StateField.create(ComplexInt0Data.lookup_(), "complexInt0_state_0_");
        private static final StateField COMPLEX_INT1_COMPLEX_EQ_NODE_COMPLEX_INT1_STATE_0_UPDATER = StateField.create(ComplexInt1Data.lookup_(), "complexInt1_state_0_");

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#complex1_cache}
         * <li>{@link Inlined#complexDouble_cache}
         * <li>{@link Inlined#complexInt0_cache}
         * <li>{@link Inlined#complexInt1_cache}
         * </ul> */
        @NeverDefault
        public static ComplexEqNode inline(@RequiredField(bits = 11, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new ComplexEqNodeGen.Inlined(target);
        }

        @GeneratedBy(ComplexEqNode.class)
        @DenyReplace
        private static final class Inlined extends ComplexEqNode implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ComplexEqNode#doComplex(PComplex, PComplex)}
             *   1: SpecializationActive {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   2: SpecializationActive {@link ComplexEqNode#doComplexDouble}
             *   3: SpecializationActive {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *   4: SpecializationActive {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
             *   5: SpecializationActive {@link ComplexEqNode#doNotImplemented}
             *   6-7: ImplicitCast[type=double, index=2]
             *   8-10: ImplicitCast[type=long, index=2]
             * </pre> */
            private final StateField state_0_;
            private final ReferenceField<Complex1Data> complex1_cache;
            private final ReferenceField<ComplexDoubleData> complexDouble_cache;
            private final ReferenceField<ComplexInt0Data> complexInt0_cache;
            private final ReferenceField<ComplexInt1Data> complexInt1_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link PyComplexCheckNode} check
             *   Inline method: {@link PyComplexCheckNodeGen#inline}</pre> */
            private final PyComplexCheckNode complex1_check_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private final ToComplexValueNode complex1_toComplexLeft_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private final ToComplexValueNode complex1_toComplexRight_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexDouble}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private final ToComplexValueNode complexDouble_toComplexLeft_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private final ToComplexValueNode complexInt0_toComplexLeft_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} longFitsToDoubleProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre> */
            private final InlinedConditionProfile complexInt0_longFitsToDoubleProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private final ToComplexValueNode complexInt1_toComplexLeft_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(ComplexEqNode.class);
                this.state_0_ = target.getState(0, 11);
                this.complex1_cache = target.getReference(1, Complex1Data.class);
                this.complexDouble_cache = target.getReference(2, ComplexDoubleData.class);
                this.complexInt0_cache = target.getReference(3, ComplexInt0Data.class);
                this.complexInt1_cache = target.getReference(4, ComplexInt1Data.class);
                this.complex1_check_ = PyComplexCheckNodeGen.inline(InlineTarget.create(PyComplexCheckNode.class, COMPLEX1_COMPLEX_EQ_NODE_COMPLEX1_STATE_0_UPDATER.subUpdater(2, 3), ReferenceField.create(Complex1Data.lookup_(), "complex1_check__field1_", Node.class)));
                this.complex1_toComplexLeft_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX1_COMPLEX_EQ_NODE_COMPLEX1_STATE_0_UPDATER.subUpdater(5, 7), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexLeft__field1_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexLeft__field2_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexLeft__field3_", Node.class)));
                this.complex1_toComplexRight_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX1_COMPLEX_EQ_NODE_COMPLEX1_STATE_0_UPDATER.subUpdater(12, 7), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexRight__field1_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexRight__field2_", Node.class), ReferenceField.create(Complex1Data.lookup_(), "complex1_toComplexRight__field3_", Node.class)));
                this.complexDouble_toComplexLeft_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX_DOUBLE_COMPLEX_EQ_NODE_COMPLEX_DOUBLE_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(ComplexDoubleData.lookup_(), "complexDouble_toComplexLeft__field1_", Node.class), ReferenceField.create(ComplexDoubleData.lookup_(), "complexDouble_toComplexLeft__field2_", Node.class), ReferenceField.create(ComplexDoubleData.lookup_(), "complexDouble_toComplexLeft__field3_", Node.class)));
                this.complexInt0_toComplexLeft_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX_INT0_COMPLEX_EQ_NODE_COMPLEX_INT0_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(ComplexInt0Data.lookup_(), "complexInt0_toComplexLeft__field1_", Node.class), ReferenceField.create(ComplexInt0Data.lookup_(), "complexInt0_toComplexLeft__field2_", Node.class), ReferenceField.create(ComplexInt0Data.lookup_(), "complexInt0_toComplexLeft__field3_", Node.class)));
                this.complexInt0_longFitsToDoubleProfile_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, COMPLEX_INT0_COMPLEX_EQ_NODE_COMPLEX_INT0_STATE_0_UPDATER.subUpdater(7, 2)));
                this.complexInt1_toComplexLeft_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, COMPLEX_INT1_COMPLEX_EQ_NODE_COMPLEX_INT1_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(ComplexInt1Data.lookup_(), "complexInt1_toComplexLeft__field1_", Node.class), ReferenceField.create(ComplexInt1Data.lookup_(), "complexInt1_toComplexLeft__field2_", Node.class), ReferenceField.create(ComplexInt1Data.lookup_(), "complexInt1_toComplexLeft__field3_", Node.class)));
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, Object arg2Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(PComplex, PComplex)] */) && arg1Value instanceof PComplex && arg2Value instanceof PComplex) {
                    return false;
                }
                {
                    Complex1Data s1_ = this.complex1_cache.get(arg0Value);
                    if ((s1_ == null || ((s1_.complex1_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode), guardIndex=0] */ || (this.complex1_check_.execute(s1_, arg2Value)))) {
                        return false;
                    }
                }
                if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexDouble(Node, Object, double, ToComplexValueNode)] */
                 && (state_0 & 0b11000000) == 0b11000000) && PythonArithmeticTypesGen.isImplicitDouble(arg2Value)) {
                    return false;
                }
                if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)] */
                 && (state_0 & 0b11100000000) == 0b11100000000) && PythonArithmeticTypesGen.isImplicitLong(arg2Value)) {
                    return false;
                }
                if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, PInt, ToComplexValueNode)] */) && arg2Value instanceof PInt) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(Node arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexDouble(Node, Object, double, ToComplexValueNode)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, PInt, ToComplexValueNode)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doNotImplemented(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(PComplex, PComplex)] */ && arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        if (arg2Value instanceof PComplex) {
                            PComplex arg2Value_ = (PComplex) arg2Value;
                            return ComplexEqNode.doComplex(arg1Value_, arg2Value_);
                        }
                    }
                    if ((state_0 & 0b111110) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexDouble(Node, Object, double, ToComplexValueNode)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, PInt, ToComplexValueNode)] || SpecializationActive[ComplexBuiltins.ComplexEqNode.doNotImplemented(Object, Object)] */) {
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)] */) {
                            Complex1Data s1_ = this.complex1_cache.get(arg0Value);
                            if (s1_ != null) {
                                if ((s1_.complex1_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.complex1_check_.execute(s1_, arg2Value))) {
                                    return ComplexEqNode.doComplex(s1_, arg1Value, arg2Value, this.complex1_check_, this.complex1_toComplexLeft_, this.complex1_toComplexRight_);
                                }
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexDouble(Node, Object, double, ToComplexValueNode)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b11000000) >>> 6 /* get-int ImplicitCast[type=double, index=2] */, arg2Value)) {
                            double arg2Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b11000000) >>> 6 /* get-int ImplicitCast[type=double, index=2] */, arg2Value);
                            ComplexDoubleData s2_ = this.complexDouble_cache.get(arg0Value);
                            if (s2_ != null) {
                                return ComplexEqNode.doComplexDouble(s2_, arg1Value, arg2Value_, this.complexDouble_toComplexLeft_);
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100000000) >>> 8 /* get-int ImplicitCast[type=long, index=2] */, arg2Value)) {
                            long arg2Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100000000) >>> 8 /* get-int ImplicitCast[type=long, index=2] */, arg2Value);
                            ComplexInt0Data s3_ = this.complexInt0_cache.get(arg0Value);
                            if (s3_ != null) {
                                return ComplexEqNode.doComplexInt(s3_, arg1Value, arg2Value_, this.complexInt0_toComplexLeft_, this.complexInt0_longFitsToDoubleProfile_);
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, PInt, ToComplexValueNode)] */ && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt) arg2Value;
                            ComplexInt1Data s4_ = this.complexInt1_cache.get(arg0Value);
                            if (s4_ != null) {
                                return ComplexEqNode.doComplexInt(s4_, arg1Value, arg2Value_, this.complexInt1_toComplexLeft_);
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.ComplexEqNode.doNotImplemented(Object, Object)] */) {
                            if (fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                                return ComplexEqNode.doNotImplemented(arg1Value, arg2Value);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(Node arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg1Value instanceof PComplex) {
                    PComplex arg1Value_ = (PComplex) arg1Value;
                    if (arg2Value instanceof PComplex) {
                        PComplex arg2Value_ = (PComplex) arg2Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(PComplex, PComplex)] */;
                        this.state_0_.set(arg0Value, state_0);
                        return ComplexEqNode.doComplex(arg1Value_, arg2Value_);
                    }
                }
                while (true) {
                    int count1_ = 0;
                    Complex1Data s1_ = this.complex1_cache.getVolatile(arg0Value);
                    Complex1Data s1_original = s1_;
                    while (s1_ != null) {
                        if ((s1_.complex1_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */ && (this.complex1_check_.execute(s1_, arg2Value))) {
                            break;
                        }
                        if ((s1_.complex1_state_0_ & 0b10) != 0 /* is SpecializationCachesInitialized  */) {
                            count1_++;
                        }
                        s1_ = null;
                        break;
                    }
                    if (s1_ == null && count1_ < 1) {
                        {
                            s1_ = arg0Value.insert(new Complex1Data());
                            if (((s1_.complex1_state_0_ & 0b1)) == 0 /* is-not GuardActive[specialization=ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode), guardIndex=0] */) {
                                s1_.complex1_state_0_ = s1_.complex1_state_0_ | 0b1 /* add GuardActive[specialization=ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode), guardIndex=0] */;
                                if (!this.complex1_cache.compareAndSet(arg0Value, s1_original, s1_)) {
                                    continue;
                                }
                                s1_original = s1_;
                                s1_ = arg0Value.insert(new Complex1Data(s1_));
                            }
                            if ((this.complex1_check_.execute(s1_, arg2Value))) {
                                s1_.complex1_state_0_ = s1_.complex1_state_0_ | 0b10 /* add SpecializationCachesInitialized  */;
                                if (!this.complex1_cache.compareAndSet(arg0Value, s1_original, s1_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)] */;
                                this.state_0_.set(arg0Value, state_0);
                            } else {
                                s1_ = null;
                            }
                        }
                    }
                    if (s1_ != null) {
                        return ComplexEqNode.doComplex(s1_, arg1Value, arg2Value, this.complex1_check_, this.complex1_toComplexLeft_, this.complex1_toComplexRight_);
                    }
                    break;
                }
                {
                    int doubleCast2;
                    if ((doubleCast2 = PythonArithmeticTypesGen.specializeImplicitDouble(arg2Value)) != 0) {
                        double arg2Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast2, arg2Value);
                        ComplexDoubleData s2_ = arg0Value.insert(new ComplexDoubleData());
                        VarHandle.storeStoreFence();
                        this.complexDouble_cache.set(arg0Value, s2_);
                        state_0 = (state_0 | (doubleCast2 << 6) /* set-int ImplicitCast[type=double, index=2] */);
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexDouble(Node, Object, double, ToComplexValueNode)] */;
                        this.state_0_.set(arg0Value, state_0);
                        return ComplexEqNode.doComplexDouble(s2_, arg1Value, arg2Value_, this.complexDouble_toComplexLeft_);
                    }
                }
                {
                    int longCast2;
                    if ((longCast2 = PythonArithmeticTypesGen.specializeImplicitLong(arg2Value)) != 0) {
                        long arg2Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast2, arg2Value);
                        ComplexInt0Data s3_ = arg0Value.insert(new ComplexInt0Data());
                        VarHandle.storeStoreFence();
                        this.complexInt0_cache.set(arg0Value, s3_);
                        state_0 = (state_0 | (longCast2 << 8) /* set-int ImplicitCast[type=long, index=2] */);
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)] */;
                        this.state_0_.set(arg0Value, state_0);
                        return ComplexEqNode.doComplexInt(s3_, arg1Value, arg2Value_, this.complexInt0_toComplexLeft_, this.complexInt0_longFitsToDoubleProfile_);
                    }
                }
                if (arg2Value instanceof PInt) {
                    PInt arg2Value_ = (PInt) arg2Value;
                    ComplexInt1Data s4_ = arg0Value.insert(new ComplexInt1Data());
                    VarHandle.storeStoreFence();
                    this.complexInt1_cache.set(arg0Value, s4_);
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.ComplexEqNode.doComplexInt(Node, Object, PInt, ToComplexValueNode)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return ComplexEqNode.doComplexInt(s4_, arg1Value, arg2Value_, this.complexInt1_toComplexLeft_);
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[ComplexBuiltins.ComplexEqNode.doNotImplemented(Object, Object)] */;
                this.state_0_.set(arg0Value, state_0);
                return ComplexEqNode.doNotImplemented(arg1Value, arg2Value);
            }

        }
        @GeneratedBy(ComplexEqNode.class)
        @DenyReplace
        private static final class Complex1Data extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0: GuardActive[guardIndex=0] {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   1: SpecializationCachesInitialized {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   2-4: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *        Parameter: {@link PyComplexCheckNode} check
             *        Inline method: {@link PyComplexCheckNodeGen#inline}
             *   5-11: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   12-18: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *        Parameter: {@link ToComplexValueNode} toComplexRight
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int complex1_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link PyComplexCheckNode} check
             *   Inline method: {@link PyComplexCheckNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_check__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexLeft__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexRight__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexRight__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplex(Node, Object, Object, PyComplexCheckNode, ToComplexValueNode, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexRight
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complex1_toComplexRight__field3_;

            Complex1Data() {
            }

            Complex1Data(Complex1Data delegate) {
                this.complex1_state_0_ = delegate.complex1_state_0_;
                this.complex1_check__field1_ = delegate.complex1_check__field1_;
                this.complex1_toComplexLeft__field1_ = delegate.complex1_toComplexLeft__field1_;
                this.complex1_toComplexLeft__field2_ = delegate.complex1_toComplexLeft__field2_;
                this.complex1_toComplexLeft__field3_ = delegate.complex1_toComplexLeft__field3_;
                this.complex1_toComplexRight__field1_ = delegate.complex1_toComplexRight__field1_;
                this.complex1_toComplexRight__field2_ = delegate.complex1_toComplexRight__field2_;
                this.complex1_toComplexRight__field3_ = delegate.complex1_toComplexRight__field3_;
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ComplexEqNode.class)
        @DenyReplace
        private static final class ComplexDoubleData extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplexDouble}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int complexDouble_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexDouble}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexDouble_toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexDouble}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexDouble_toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexDouble}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexDouble_toComplexLeft__field3_;

            ComplexDoubleData() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ComplexEqNode.class)
        @DenyReplace
        private static final class ComplexInt0Data extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             *   7-8: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} longFitsToDoubleProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int complexInt0_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexInt0_toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexInt0_toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, long, ToComplexValueNode, InlinedConditionProfile)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexInt0_toComplexLeft__field3_;

            ComplexInt0Data() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
        @GeneratedBy(ComplexEqNode.class)
        @DenyReplace
        private static final class ComplexInt1Data extends Node implements SpecializationDataNode {

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
             *        Parameter: {@link ToComplexValueNode} toComplexLeft
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int complexInt1_state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexInt1_toComplexLeft__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexInt1_toComplexLeft__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ComplexEqNode#doComplexInt(Node, Object, PInt, ToComplexValueNode)}
             *   Parameter: {@link ToComplexValueNode} toComplexLeft
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexInt1_toComplexLeft__field3_;

            ComplexInt1Data() {
            }

            private static Lookup lookup_() {
                return MethodHandles.lookup();
            }

        }
    }
    @GeneratedBy(EqNode.class)
    static final class EqNodeFactory implements NodeFactory<EqNode> {

        private static final EqNodeFactory EQ_NODE_FACTORY_INSTANCE = new EqNodeFactory();

        private EqNodeFactory() {
        }

        @Override
        public Class<EqNode> getNodeClass() {
            return EqNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public EqNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<EqNode> getInstance() {
            return EQ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EqNode create() {
            return new EqNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EqNode#doComplex}
         *     Activation probability: 1.00000
         *     With/without class size: 40/18 bytes
         * </pre> */
        @GeneratedBy(EqNode.class)
        @SuppressWarnings("javadoc")
        static final class EqNodeGen extends EqNode {

            private static final StateField STATE_0_EqNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}</pre> */
            private static final ComplexEqNode INLINED_COMPLEX_EQ_NODE_ = ComplexEqNodeGen.inline(InlineTarget.create(ComplexEqNode.class, STATE_0_EqNode_UPDATER.subUpdater(0, 11), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field4_", Node.class)));

            /**
             * State Info: <pre>
             *   0-10: InlinedCache
             *        Specialization: {@link EqNode#doComplex}
             *        Parameter: {@link ComplexEqNode} complexEqNode
             *        Inline method: {@link ComplexEqNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field4_;

            private EqNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    return EqNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_COMPLEX_EQ_NODE_);
                }
            }

        }
    }
    @GeneratedBy(NeNode.class)
    static final class NeNodeFactory implements NodeFactory<NeNode> {

        private static final NeNodeFactory NE_NODE_FACTORY_INSTANCE = new NeNodeFactory();

        private NeNodeFactory() {
        }

        @Override
        public Class<NeNode> getNodeClass() {
            return NeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NeNode> getInstance() {
            return NE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NeNode create() {
            return new NeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NeNode#doComplex}
         *     Activation probability: 1.00000
         *     With/without class size: 40/18 bytes
         * </pre> */
        @GeneratedBy(NeNode.class)
        @SuppressWarnings("javadoc")
        static final class NeNodeGen extends NeNode {

            private static final StateField STATE_0_NeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NeNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}</pre> */
            private static final ComplexEqNode INLINED_COMPLEX_EQ_NODE_ = ComplexEqNodeGen.inline(InlineTarget.create(ComplexEqNode.class, STATE_0_NeNode_UPDATER.subUpdater(0, 11), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "complexEqNode__field4_", Node.class)));

            /**
             * State Info: <pre>
             *   0-10: InlinedCache
             *        Specialization: {@link NeNode#doComplex}
             *        Parameter: {@link ComplexEqNode} complexEqNode
             *        Inline method: {@link ComplexEqNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NeNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NeNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NeNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NeNode#doComplex}
             *   Parameter: {@link ComplexEqNode} complexEqNode
             *   Inline method: {@link ComplexEqNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node complexEqNode__field4_;

            private NeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    return NeNode.doComplex(arg0Value, arg1Value, inliningTarget__, INLINED_COMPLEX_EQ_NODE_);
                }
            }

        }
    }
    @GeneratedBy(GeNode.class)
    static final class GeNodeFactory implements NodeFactory<GeNode> {

        private static final GeNodeFactory GE_NODE_FACTORY_INSTANCE = new GeNodeFactory();

        private GeNodeFactory() {
        }

        @Override
        public Class<GeNode> getNodeClass() {
            return GeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GeNode> getInstance() {
            return GE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GeNode create() {
            return new GeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GeNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(GeNode.class)
        @SuppressWarnings("javadoc")
        static final class GeNodeGen extends GeNode {

            private GeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return GeNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(GtNode.class)
    static final class GtNodeFactory implements NodeFactory<GtNode> {

        private static final GtNodeFactory GT_NODE_FACTORY_INSTANCE = new GtNodeFactory();

        private GtNodeFactory() {
        }

        @Override
        public Class<GtNode> getNodeClass() {
            return GtNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GtNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GtNode> getInstance() {
            return GT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GtNode create() {
            return new GtNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GtNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(GtNode.class)
        @SuppressWarnings("javadoc")
        static final class GtNodeGen extends GtNode {

            private GtNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return GtNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(LtNode.class)
    static final class LtNodeFactory implements NodeFactory<LtNode> {

        private static final LtNodeFactory LT_NODE_FACTORY_INSTANCE = new LtNodeFactory();

        private LtNodeFactory() {
        }

        @Override
        public Class<LtNode> getNodeClass() {
            return LtNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public LtNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<LtNode> getInstance() {
            return LT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LtNode create() {
            return new LtNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LtNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(LtNode.class)
        @SuppressWarnings("javadoc")
        static final class LtNodeGen extends LtNode {

            private LtNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return LtNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(LeNode.class)
    static final class LeNodeFactory implements NodeFactory<LeNode> {

        private static final LeNodeFactory LE_NODE_FACTORY_INSTANCE = new LeNodeFactory();

        private LeNodeFactory() {
        }

        @Override
        public Class<LeNode> getNodeClass() {
            return LeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public LeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<LeNode> getInstance() {
            return LE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LeNode create() {
            return new LeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LeNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(LeNode.class)
        @SuppressWarnings("javadoc")
        static final class LeNodeGen extends LeNode {

            private LeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return LeNode.doGeneric(arg0Value, arg1Value);
            }

        }
    }
    @GeneratedBy(ReprNode.class)
    static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#repr}
         *     Activation probability: 1.00000
         *     With/without class size: 36/13 bytes
         * </pre> */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        static final class ReprNodeGen extends ReprNode {

            private static final StateField STATE_0_ReprNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_ReprNode_UPDATER.subUpdater(0, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link ReprNode#repr}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReprNode#repr}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return ReprNode.repr(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(FormatNode.class)
    static final class FormatNodeFactory implements NodeFactory<FormatNode> {

        private static final FormatNodeFactory FORMAT_NODE_FACTORY_INSTANCE = new FormatNodeFactory();

        private FormatNodeFactory() {
        }

        @Override
        public Class<FormatNode> getNodeClass() {
            return FormatNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public FormatNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<FormatNode> getInstance() {
            return FORMAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FormatNode create() {
            return new FormatNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FormatNodeBase#formatEmptyString}
         *     Activation probability: 0.65000
         *     With/without class size: 17/4 bytes
         *   Specialization {@link FormatNode#format}
         *     Activation probability: 0.35000
         *     With/without class size: 16/17 bytes
         * </pre> */
        @GeneratedBy(FormatNode.class)
        @SuppressWarnings("javadoc")
        static final class FormatNodeGen extends FormatNode {

            private static final StateField FORMAT_FORMAT_NODE_FORMAT_STATE_0_UPDATER = StateField.create(FormatData.lookup_(), "format_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNode#format}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_FORMAT_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, FORMAT_FORMAT_NODE_FORMAT_STATE_0_UPDATER.subUpdater(0, 7), ReferenceField.create(FormatData.lookup_(), "format_toComplexValueNode__field1_", Node.class), ReferenceField.create(FormatData.lookup_(), "format_toComplexValueNode__field2_", Node.class), ReferenceField.create(FormatData.lookup_(), "format_toComplexValueNode__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNode#format}
             *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
             *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}</pre> */
            private static final com.oracle.graal.python.nodes.PRaiseNode.Lazy INLINED_FORMAT_RAISE_NODE_ = com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen.inline(InlineTarget.create(com.oracle.graal.python.nodes.PRaiseNode.Lazy.class, FORMAT_FORMAT_NODE_FORMAT_STATE_0_UPDATER.subUpdater(7, 1), ReferenceField.create(FormatData.lookup_(), "format_raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FormatNodeBase#formatEmptyString}
             *   1: SpecializationActive {@link FormatNode#format}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNodeBase#formatEmptyString}
             *   Parameter: {@link LookupAndCallUnaryNode} lookupAndCallNode</pre> */
            @Child private LookupAndCallUnaryNode formatEmptyString_lookupAndCallNode_;
            @Child private FormatData format_cache;

            private FormatNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)] || SpecializationActive[ComplexBuiltins.FormatNode.format(Object, TruffleString, Node, ToComplexValueNode, Lazy)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)] */) {
                        {
                            LookupAndCallUnaryNode lookupAndCallNode__ = this.formatEmptyString_lookupAndCallNode_;
                            if (lookupAndCallNode__ != null) {
                                if ((arg1Value_.isEmpty())) {
                                    return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, lookupAndCallNode__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.FormatNode.format(Object, TruffleString, Node, ToComplexValueNode, Lazy)] */) {
                        FormatData s1_ = this.format_cache;
                        if (s1_ != null) {
                            {
                                Node inliningTarget__ = (s1_);
                                return FormatNode.format(arg0Value, arg1Value_, inliningTarget__, INLINED_FORMAT_TO_COMPLEX_VALUE_NODE_, INLINED_FORMAT_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg1Value_.isEmpty())) {
                        LookupAndCallUnaryNode lookupAndCallNode__ = this.insert((LookupAndCallUnaryNode.create(SpecialMethodSlot.Str)));
                        Objects.requireNonNull(lookupAndCallNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.formatEmptyString_lookupAndCallNode_ = lookupAndCallNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)] */;
                        this.state_0_ = state_0;
                        return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, lookupAndCallNode__);
                    }
                    {
                        Node inliningTarget__ = null;
                        FormatData s1_ = this.insert(new FormatData());
                        inliningTarget__ = (s1_);
                        VarHandle.storeStoreFence();
                        this.format_cache = s1_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.FormatNode.format(Object, TruffleString, Node, ToComplexValueNode, Lazy)] */;
                        this.state_0_ = state_0;
                        return FormatNode.format(arg0Value, arg1Value_, inliningTarget__, INLINED_FORMAT_TO_COMPLEX_VALUE_NODE_, INLINED_FORMAT_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

            @GeneratedBy(FormatNode.class)
            @DenyReplace
            private static final class FormatData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-6: InlinedCache
                 *        Specialization: {@link FormatNode#format}
                 *        Parameter: {@link ToComplexValueNode} toComplexValueNode
                 *        Inline method: {@link ToComplexValueNodeGen#inline}
                 *   7: InlinedCache
                 *        Specialization: {@link FormatNode#format}
                 *        Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
                 *        Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
                 * </pre> */
                @CompilationFinal @UnsafeAccessedField private int format_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FormatNode#format}
                 *   Parameter: {@link ToComplexValueNode} toComplexValueNode
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node format_toComplexValueNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FormatNode#format}
                 *   Parameter: {@link ToComplexValueNode} toComplexValueNode
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node format_toComplexValueNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FormatNode#format}
                 *   Parameter: {@link ToComplexValueNode} toComplexValueNode
                 *   Inline method: {@link ToComplexValueNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node format_toComplexValueNode__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link FormatNode#format}
                 *   Parameter: {@link com.oracle.graal.python.nodes.PRaiseNode.Lazy} raiseNode
                 *   Inline method: {@link com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre> */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node format_raiseNode__field1_;

                FormatData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(BoolNode.class)
    static final class BoolNodeFactory implements NodeFactory<BoolNode> {

        private static final BoolNodeFactory BOOL_NODE_FACTORY_INSTANCE = new BoolNodeFactory();

        private BoolNodeFactory() {
        }

        @Override
        public Class<BoolNode> getNodeClass() {
            return BoolNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public BoolNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        @Override
        public BoolNode getUncachedInstance() {
            return BoolNodeGen.UNCACHED;
        }

        static NodeFactory<BoolNode> getInstance() {
            return BOOL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolNode create() {
            return new BoolNodeGen();
        }

        @NeverDefault
        public static BoolNode getUncached() {
            return BoolNodeGen.UNCACHED;
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BoolNode#bool}
         *     Activation probability: 1.00000
         *     With/without class size: 36/13 bytes
         * </pre> */
        @GeneratedBy(BoolNode.class)
        @SuppressWarnings("javadoc")
        static final class BoolNodeGen extends BoolNode {

            private static final StateField STATE_0_BoolNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link BoolNode#bool}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_BoolNode_UPDATER.subUpdater(0, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));
            private static final Uncached UNCACHED = new Uncached();

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link BoolNode#bool}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BoolNode#bool}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BoolNode#bool}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BoolNode#bool}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;

            private BoolNodeGen() {
            }

            @Override
            public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return BoolNode.bool(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_);
                }
            }

            @GeneratedBy(BoolNode.class)
            @DenyReplace
            private static final class Uncached extends BoolNode implements UnadoptableNode {

                @Override
                public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return BoolNode.bool(arg0Value, (this), (ToComplexValueNodeGen.getUncached()));
                }

            }
        }
    }
    @GeneratedBy(NegNode.class)
    static final class NegNodeFactory implements NodeFactory<NegNode> {

        private static final NegNodeFactory NEG_NODE_FACTORY_INSTANCE = new NegNodeFactory();

        private NegNodeFactory() {
        }

        @Override
        public Class<NegNode> getNodeClass() {
            return NegNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NegNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NegNode> getInstance() {
            return NEG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NegNode create() {
            return new NegNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NegNode#neg}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre> */
        @GeneratedBy(NegNode.class)
        @SuppressWarnings("javadoc")
        static final class NegNodeGen extends NegNode {

            private static final StateField STATE_0_NegNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NegNode#neg}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_NegNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NegNode#neg}
             *   1-7: InlinedCache
             *        Specialization: {@link NegNode#neg}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NegNode#neg}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NegNode#neg}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NegNode#neg}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link NegNode#neg}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private NegNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.NegNode.neg(Object, Node, ToComplexValueNode, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return NegNode.neg(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PComplex executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.NegNode.neg(Object, Node, ToComplexValueNode, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return NegNode.neg(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                }
            }

        }
    }
    @GeneratedBy(PosNode.class)
    static final class PosNodeFactory implements NodeFactory<PosNode> {

        private static final PosNodeFactory POS_NODE_FACTORY_INSTANCE = new PosNodeFactory();

        private PosNodeFactory() {
        }

        @Override
        public Class<PosNode> getNodeClass() {
            return PosNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public PosNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<PosNode> getInstance() {
            return POS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PosNode create() {
            return new PosNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PosNode#pos}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre> */
        @GeneratedBy(PosNode.class)
        @SuppressWarnings("javadoc")
        static final class PosNodeGen extends PosNode {

            private static final StateField STATE_0_PosNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PosNode#pos}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_PosNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PosNode#pos}
             *   1-7: InlinedCache
             *        Specialization: {@link PosNode#pos}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PosNode#pos}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PosNode#pos}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PosNode#pos}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PosNode#pos}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private PosNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.PosNode.pos(Object, Node, ToComplexValueNode, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return PosNode.pos(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PComplex executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.PosNode.pos(Object, Node, ToComplexValueNode, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return PosNode.pos(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                }
            }

        }
    }
    @GeneratedBy(GetNewArgsNode.class)
    static final class GetNewArgsNodeFactory implements NodeFactory<GetNewArgsNode> {

        private static final GetNewArgsNodeFactory GET_NEW_ARGS_NODE_FACTORY_INSTANCE = new GetNewArgsNodeFactory();

        private GetNewArgsNodeFactory() {
        }

        @Override
        public Class<GetNewArgsNode> getNodeClass() {
            return GetNewArgsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetNewArgsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetNewArgsNode> getInstance() {
            return GET_NEW_ARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNewArgsNode create() {
            return new GetNewArgsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNewArgsNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre> */
        @GeneratedBy(GetNewArgsNode.class)
        @SuppressWarnings("javadoc")
        static final class GetNewArgsNodeGen extends GetNewArgsNode {

            private static final StateField STATE_0_GetNewArgsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewArgsNode#get}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_GetNewArgsNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetNewArgsNode#get}
             *   1-7: InlinedCache
             *        Specialization: {@link GetNewArgsNode#get}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewArgsNode#get}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewArgsNode#get}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewArgsNode#get}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetNewArgsNode#get}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private GetNewArgsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.GetNewArgsNode.get(Object, Node, ToComplexValueNode, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return GetNewArgsNode.get(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PTuple executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.GetNewArgsNode.get(Object, Node, ToComplexValueNode, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return GetNewArgsNode.get(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                }
            }

        }
    }
    @GeneratedBy(RealNode.class)
    static final class RealNodeFactory implements NodeFactory<RealNode> {

        private static final RealNodeFactory REAL_NODE_FACTORY_INSTANCE = new RealNodeFactory();

        private RealNodeFactory() {
        }

        @Override
        public Class<RealNode> getNodeClass() {
            return RealNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public RealNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RealNode> getInstance() {
            return REAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RealNode create(ReadArgumentNode[] arguments) {
            return new RealNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RealNode#get}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link RealNode#getNative}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(RealNode.class)
        @SuppressWarnings("javadoc")
        static final class RealNodeGen extends RealNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RealNode#get}
             *   1: SpecializationActive {@link RealNode#getNative}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RealNode#getNative}
             *   Parameter: {@link ReadDoubleNode} read</pre> */
            @Child private ReadDoubleNode getNative_read_;

            private RealNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.RealNode.get(PComplex)] || SpecializationActive[ComplexBuiltins.RealNode.getNative(PythonAbstractNativeObject, ReadDoubleNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.RealNode.get(PComplex)] */ && arguments0Value_ instanceof PComplex) {
                        PComplex arguments0Value__ = (PComplex) arguments0Value_;
                        return RealNode.get(arguments0Value__);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.RealNode.getNative(PythonAbstractNativeObject, ReadDoubleNode)] */ && arguments0Value_ instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arguments0Value__ = (PythonAbstractNativeObject) arguments0Value_;
                        {
                            ReadDoubleNode read__ = this.getNative_read_;
                            if (read__ != null) {
                                return RealNode.getNative(arguments0Value__, read__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private double executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PComplex) {
                    PComplex arguments0Value_ = (PComplex) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.RealNode.get(PComplex)] */;
                    this.state_0_ = state_0;
                    return RealNode.get(arguments0Value_);
                }
                if (arguments0Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arguments0Value_ = (PythonAbstractNativeObject) arguments0Value;
                    ReadDoubleNode read__ = this.insert((ReadDoubleNode.create()));
                    Objects.requireNonNull(read__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getNative_read_ = read__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.RealNode.getNative(PythonAbstractNativeObject, ReadDoubleNode)] */;
                    this.state_0_ = state_0;
                    return RealNode.getNative(arguments0Value_, read__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(ImagNode.class)
    static final class ImagNodeFactory implements NodeFactory<ImagNode> {

        private static final ImagNodeFactory IMAG_NODE_FACTORY_INSTANCE = new ImagNodeFactory();

        private ImagNodeFactory() {
        }

        @Override
        public Class<ImagNode> getNodeClass() {
            return ImagNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ImagNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ImagNode> getInstance() {
            return IMAG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ImagNode create(ReadArgumentNode[] arguments) {
            return new ImagNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ImagNode#get}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link ImagNode#getNative}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(ImagNode.class)
        @SuppressWarnings("javadoc")
        static final class ImagNodeGen extends ImagNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ImagNode#get}
             *   1: SpecializationActive {@link ImagNode#getNative}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ImagNode#getNative}
             *   Parameter: {@link ReadDoubleNode} read</pre> */
            @Child private ReadDoubleNode getNative_read_;

            private ImagNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.ImagNode.get(PComplex)] || SpecializationActive[ComplexBuiltins.ImagNode.getNative(PythonAbstractNativeObject, ReadDoubleNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.ImagNode.get(PComplex)] */ && arguments0Value_ instanceof PComplex) {
                        PComplex arguments0Value__ = (PComplex) arguments0Value_;
                        return ImagNode.get(arguments0Value__);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.ImagNode.getNative(PythonAbstractNativeObject, ReadDoubleNode)] */ && arguments0Value_ instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arguments0Value__ = (PythonAbstractNativeObject) arguments0Value_;
                        {
                            ReadDoubleNode read__ = this.getNative_read_;
                            if (read__ != null) {
                                return ImagNode.getNative(arguments0Value__, read__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private double executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PComplex) {
                    PComplex arguments0Value_ = (PComplex) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ImagNode.get(PComplex)] */;
                    this.state_0_ = state_0;
                    return ImagNode.get(arguments0Value_);
                }
                if (arguments0Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arguments0Value_ = (PythonAbstractNativeObject) arguments0Value;
                    ReadDoubleNode read__ = this.insert((ReadDoubleNode.create()));
                    Objects.requireNonNull(read__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.getNative_read_ = read__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.ImagNode.getNative(PythonAbstractNativeObject, ReadDoubleNode)] */;
                    this.state_0_ = state_0;
                    return ImagNode.getNative(arguments0Value_, read__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(HashNode.class)
    static final class HashNodeFactory implements NodeFactory<HashNode> {

        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        @Override
        public Class<HashNode> getNodeClass() {
            return HashNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public HashNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNode create() {
            return new HashNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HashNode#doPComplex}
         *     Activation probability: 1.00000
         *     With/without class size: 36/13 bytes
         * </pre> */
        @GeneratedBy(HashNode.class)
        @SuppressWarnings("javadoc")
        static final class HashNodeGen extends HashNode {

            private static final StateField STATE_0_HashNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#doPComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_HashNode_UPDATER.subUpdater(0, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0-6: InlinedCache
             *        Specialization: {@link HashNode#doPComplex}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#doPComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#doPComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#doPComplex}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;

            private HashNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return HashNode.doPComplex(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(ConjugateNode.class)
    static final class ConjugateNodeFactory implements NodeFactory<ConjugateNode> {

        private static final ConjugateNodeFactory CONJUGATE_NODE_FACTORY_INSTANCE = new ConjugateNodeFactory();

        private ConjugateNodeFactory() {
        }

        @Override
        public Class<ConjugateNode> getNodeClass() {
            return ConjugateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ConjugateNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ConjugateNode> getInstance() {
            return CONJUGATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ConjugateNode create() {
            return new ConjugateNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ConjugateNode#hash}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre> */
        @GeneratedBy(ConjugateNode.class)
        @SuppressWarnings("javadoc")
        static final class ConjugateNodeGen extends ConjugateNode {

            private static final StateField STATE_0_ConjugateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConjugateNode#hash}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}</pre> */
            private static final ToComplexValueNode INLINED_TO_COMPLEX_VALUE_NODE_ = ToComplexValueNodeGen.inline(InlineTarget.create(ToComplexValueNode.class, STATE_0_ConjugateNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "toComplexValueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConjugateNode#hash}
             *   1-7: InlinedCache
             *        Specialization: {@link ConjugateNode#hash}
             *        Parameter: {@link ToComplexValueNode} toComplexValueNode
             *        Inline method: {@link ToComplexValueNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConjugateNode#hash}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConjugateNode#hash}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConjugateNode#hash}
             *   Parameter: {@link ToComplexValueNode} toComplexValueNode
             *   Inline method: {@link ToComplexValueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toComplexValueNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConjugateNode#hash}
             *   Parameter: {@link PythonObjectFactory} factory</pre> */
            @Child private PythonObjectFactory factory_;

            private ConjugateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.ConjugateNode.hash(Object, Node, ToComplexValueNode, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            Node inliningTarget__ = (this);
                            return ConjugateNode.hash(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PComplex executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ConjugateNode.hash(Object, Node, ToComplexValueNode, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return ConjugateNode.hash(arg0Value, inliningTarget__, INLINED_TO_COMPLEX_VALUE_NODE_, factory__);
                }
            }

        }
    }
}
