// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.bool;

import com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.RepNode;
import com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.StrNode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(BoolBuiltins.class)
@SuppressWarnings("javadoc")
public final class BoolBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(StrNodeFactory.getInstance(), RepNodeFactory.getInstance(), AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance());
    }

    @GeneratedBy(StrNode.class)
    static final class StrNodeFactory implements NodeFactory<StrNode> {

        private static final StrNodeFactory STR_NODE_FACTORY_INSTANCE = new StrNodeFactory();

        private StrNodeFactory() {
        }

        @Override
        public Class<StrNode> getNodeClass() {
            return StrNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public StrNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<StrNode> getInstance() {
            return STR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StrNode create(ReadArgumentNode[] arguments) {
            return new StrNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StrNode#doLong}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link StrNode#doPInt}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(StrNode.class)
        @SuppressWarnings("javadoc")
        static final class StrNodeGen extends StrNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StrNode#doLong}
             *   1: SpecializationActive {@link StrNode#doPInt}
             *   2-4: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private StrNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[BoolBuiltins.StrNode.doLong(long)] || SpecializationActive[BoolBuiltins.StrNode.doPInt(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.StrNode.doLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_)) {
                        long arguments0Value__ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_);
                        return StrNode.doLong(arguments0Value__);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BoolBuiltins.StrNode.doPInt(PInt)] */ && arguments0Value_ instanceof PInt) {
                        PInt arguments0Value__ = (PInt) arguments0Value_;
                        return StrNode.doPInt(arguments0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private TruffleString executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                {
                    int longCast0;
                    if ((longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arguments0Value)) != 0) {
                        long arguments0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arguments0Value);
                        state_0 = (state_0 | (longCast0 << 2) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[BoolBuiltins.StrNode.doLong(long)] */;
                        this.state_0_ = state_0;
                        return StrNode.doLong(arguments0Value_);
                    }
                }
                if (arguments0Value instanceof PInt) {
                    PInt arguments0Value_ = (PInt) arguments0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[BoolBuiltins.StrNode.doPInt(PInt)] */;
                    this.state_0_ = state_0;
                    return StrNode.doPInt(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(RepNode.class)
    static final class RepNodeFactory implements NodeFactory<RepNode> {

        private static final RepNodeFactory REP_NODE_FACTORY_INSTANCE = new RepNodeFactory();

        private RepNodeFactory() {
        }

        @Override
        public Class<RepNode> getNodeClass() {
            return RepNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public RepNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RepNode> getInstance() {
            return REP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RepNode create(ReadArgumentNode[] arguments) {
            return new RepNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StrNode#doLong}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link StrNode#doPInt}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre> */
        @GeneratedBy(RepNode.class)
        @SuppressWarnings("javadoc")
        static final class RepNodeGen extends RepNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StrNode#doLong}
             *   1: SpecializationActive {@link StrNode#doPInt}
             *   2-4: ImplicitCast[type=long, index=0]
             * </pre> */
            @CompilationFinal private int state_0_;

            private RepNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[BoolBuiltins.StrNode.doLong(long)] || SpecializationActive[BoolBuiltins.StrNode.doPInt(PInt)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.StrNode.doLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_)) {
                        long arguments0Value__ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arguments0Value_);
                        return StrNode.doLong(arguments0Value__);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BoolBuiltins.StrNode.doPInt(PInt)] */ && arguments0Value_ instanceof PInt) {
                        PInt arguments0Value__ = (PInt) arguments0Value_;
                        return StrNode.doPInt(arguments0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private TruffleString executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                {
                    int longCast0;
                    if ((longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arguments0Value)) != 0) {
                        long arguments0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arguments0Value);
                        state_0 = (state_0 | (longCast0 << 2) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[BoolBuiltins.StrNode.doLong(long)] */;
                        this.state_0_ = state_0;
                        return StrNode.doLong(arguments0Value_);
                    }
                }
                if (arguments0Value instanceof PInt) {
                    PInt arguments0Value_ = (PInt) arguments0Value;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[BoolBuiltins.StrNode.doPInt(PInt)] */;
                    this.state_0_ = state_0;
                    return StrNode.doPInt(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.class)
    static final class AndNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode> {

        private static final AndNodeFactory AND_NODE_FACTORY_INSTANCE = new AndNodeFactory();

        private AndNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode> getInstance() {
            return AND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode create() {
            return new AndNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode#doBool}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode#doOther}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.class)
        @SuppressWarnings("javadoc")
        static final class AndNodeGen extends com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode#doBool}
             *   1: SpecializationActive {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode#doOther}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AndNode} andNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AndNode fallback_andNode_;

            private AndNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.AndNode.doBool(boolean, boolean)] */) && arg0Value instanceof Boolean && arg1Value instanceof Boolean) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BoolBuiltins.AndNode.doBool(boolean, boolean)] || SpecializationActive[BoolBuiltins.AndNode.doOther(VirtualFrame, Object, Object, AndNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.AndNode.doBool(boolean, boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        if (arg1Value instanceof Boolean) {
                            boolean arg1Value_ = (boolean) arg1Value;
                            return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.doBool(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BoolBuiltins.AndNode.doOther(VirtualFrame, Object, Object, AndNode)] */) {
                        {
                            com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AndNode andNode__ = this.fallback_andNode_;
                            if (andNode__ != null) {
                                if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                    return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.doOther(frameValue, arg0Value, arg1Value, andNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (boolean) arg1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[BoolBuiltins.AndNode.doBool(boolean, boolean)] */;
                        this.state_0_ = state_0;
                        return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.doBool(arg0Value_, arg1Value_);
                    }
                }
                com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AndNode andNode__ = this.insert((com.oracle.graal.python.builtins.objects.ints.IntBuiltins.AndNode.create()));
                Objects.requireNonNull(andNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_andNode_ = andNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[BoolBuiltins.AndNode.doOther(VirtualFrame, Object, Object, AndNode)] */;
                this.state_0_ = state_0;
                return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.AndNode.doOther(frameValue, arg0Value, arg1Value, andNode__);
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.class)
    static final class OrNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode> {

        private static final OrNodeFactory OR_NODE_FACTORY_INSTANCE = new OrNodeFactory();

        private OrNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode> getInstance() {
            return OR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode create() {
            return new OrNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode#doBool}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode#doOther}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.class)
        @SuppressWarnings("javadoc")
        static final class OrNodeGen extends com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode#doBool}
             *   1: SpecializationActive {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode#doOther}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.ints.IntBuiltins.OrNode} orNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.ints.IntBuiltins.OrNode fallback_orNode_;

            private OrNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.OrNode.doBool(boolean, boolean)] */) && arg0Value instanceof Boolean && arg1Value instanceof Boolean) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BoolBuiltins.OrNode.doBool(boolean, boolean)] || SpecializationActive[BoolBuiltins.OrNode.doOther(VirtualFrame, Object, Object, OrNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.OrNode.doBool(boolean, boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        if (arg1Value instanceof Boolean) {
                            boolean arg1Value_ = (boolean) arg1Value;
                            return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.doBool(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BoolBuiltins.OrNode.doOther(VirtualFrame, Object, Object, OrNode)] */) {
                        {
                            com.oracle.graal.python.builtins.objects.ints.IntBuiltins.OrNode orNode__ = this.fallback_orNode_;
                            if (orNode__ != null) {
                                if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                    return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.doOther(frameValue, arg0Value, arg1Value, orNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (boolean) arg1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[BoolBuiltins.OrNode.doBool(boolean, boolean)] */;
                        this.state_0_ = state_0;
                        return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.doBool(arg0Value_, arg1Value_);
                    }
                }
                com.oracle.graal.python.builtins.objects.ints.IntBuiltins.OrNode orNode__ = this.insert((com.oracle.graal.python.builtins.objects.ints.IntBuiltins.OrNode.create()));
                Objects.requireNonNull(orNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_orNode_ = orNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[BoolBuiltins.OrNode.doOther(VirtualFrame, Object, Object, OrNode)] */;
                this.state_0_ = state_0;
                return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.OrNode.doOther(frameValue, arg0Value, arg1Value, orNode__);
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.class)
    static final class XorNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode> {

        private static final XorNodeFactory XOR_NODE_FACTORY_INSTANCE = new XorNodeFactory();

        private XorNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode> getInstance() {
            return XOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode create() {
            return new XorNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode#doBool}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode#doOther}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.class)
        @SuppressWarnings("javadoc")
        static final class XorNodeGen extends com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode#doBool}
             *   1: SpecializationActive {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode#doOther}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode#doOther}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.ints.IntBuiltins.XorNode} xorNode</pre> */
            @Child private com.oracle.graal.python.builtins.objects.ints.IntBuiltins.XorNode fallback_xorNode_;

            private XorNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.XorNode.doBool(boolean, boolean)] */) && arg0Value instanceof Boolean && arg1Value instanceof Boolean) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[BoolBuiltins.XorNode.doBool(boolean, boolean)] || SpecializationActive[BoolBuiltins.XorNode.doOther(VirtualFrame, Object, Object, XorNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[BoolBuiltins.XorNode.doBool(boolean, boolean)] */ && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (boolean) arg0Value;
                        if (arg1Value instanceof Boolean) {
                            boolean arg1Value_ = (boolean) arg1Value;
                            return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.doBool(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[BoolBuiltins.XorNode.doOther(VirtualFrame, Object, Object, XorNode)] */) {
                        {
                            com.oracle.graal.python.builtins.objects.ints.IntBuiltins.XorNode xorNode__ = this.fallback_xorNode_;
                            if (xorNode__ != null) {
                                if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                                    return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.doOther(frameValue, arg0Value, arg1Value, xorNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (boolean) arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (boolean) arg1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[BoolBuiltins.XorNode.doBool(boolean, boolean)] */;
                        this.state_0_ = state_0;
                        return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.doBool(arg0Value_, arg1Value_);
                    }
                }
                com.oracle.graal.python.builtins.objects.ints.IntBuiltins.XorNode xorNode__ = this.insert((com.oracle.graal.python.builtins.objects.ints.IntBuiltins.XorNode.create()));
                Objects.requireNonNull(xorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_xorNode_ = xorNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[BoolBuiltins.XorNode.doOther(VirtualFrame, Object, Object, XorNode)] */;
                this.state_0_ = state_0;
                return com.oracle.graal.python.builtins.objects.bool.BoolBuiltins.XorNode.doOther(frameValue, arg0Value, arg1Value, xorNode__);
            }

        }
    }
}
