// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.IOBaseDictBuiltins.DictNode;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(IOBaseDictBuiltins.class)
@SuppressWarnings("javadoc")
public final class IOBaseDictBuiltinsFactory {

    public static List<NodeFactory<DictNode>> getFactories() {
        return List.of(DictNodeFactory.getInstance());
    }

    @GeneratedBy(DictNode.class)
    public static final class DictNodeFactory implements NodeFactory<DictNode> {

        private static final DictNodeFactory DICT_NODE_FACTORY_INSTANCE = new DictNodeFactory();

        private DictNodeFactory() {
        }

        @Override
        public Class<DictNode> getNodeClass() {
            return DictNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public DictNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<DictNode> getInstance() {
            return DICT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DictNode create() {
            return new DictNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DictNode#doit}
         *     Activation probability: 0.65000
         *     With/without class size: 27/18 bytes
         *   Specialization {@link DictNode#setDict}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre> */
        @GeneratedBy(DictNode.class)
        @SuppressWarnings("javadoc")
        public static final class DictNodeGen extends DictNode {

            private static final StateField STATE_0_DictNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link DictNode#doit}
             *   Parameter: {@link GetOrCreateDictNode} getDict
             *   Inline method: {@link GetOrCreateDictNodeGen#inline}</pre> */
            private static final GetOrCreateDictNode INLINED_IT_GET_DICT_ = GetOrCreateDictNodeGen.inline(InlineTarget.create(GetOrCreateDictNode.class, STATE_0_DictNode_UPDATER.subUpdater(2, 10), ReferenceField.create(MethodHandles.lookup(), "it_getDict__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "it_getDict__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "it_getDict__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "it_getDict__field4_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DictNode#doit}
             *   1: SpecializationActive {@link DictNode#setDict}
             *   2-11: InlinedCache
             *        Specialization: {@link DictNode#doit}
             *        Parameter: {@link GetOrCreateDictNode} getDict
             *        Inline method: {@link GetOrCreateDictNodeGen#inline}
             * </pre> */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DictNode#doit}
             *   Parameter: {@link GetOrCreateDictNode} getDict
             *   Inline method: {@link GetOrCreateDictNodeGen#inline}
             *   Inline field: {@link Node} field1</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node it_getDict__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DictNode#doit}
             *   Parameter: {@link GetOrCreateDictNode} getDict
             *   Inline method: {@link GetOrCreateDictNodeGen#inline}
             *   Inline field: {@link Node} field2</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node it_getDict__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DictNode#doit}
             *   Parameter: {@link GetOrCreateDictNode} getDict
             *   Inline method: {@link GetOrCreateDictNodeGen#inline}
             *   Inline field: {@link Node} field3</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node it_getDict__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DictNode#doit}
             *   Parameter: {@link GetOrCreateDictNode} getDict
             *   Inline method: {@link GetOrCreateDictNodeGen#inline}
             *   Inline field: {@link Node} field4</pre> */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node it_getDict__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DictNode#setDict}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode setDict_raiseNode_;

            private DictNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[IOBaseDictBuiltins.DictNode.doit(PythonObject, PNone, Node, GetOrCreateDictNode)] || SpecializationActive[IOBaseDictBuiltins.DictNode.setDict(PythonObject, Object, PRaiseNode)] */ && arg0Value instanceof PythonObject) {
                    PythonObject arg0Value_ = (PythonObject) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[IOBaseDictBuiltins.DictNode.doit(PythonObject, PNone, Node, GetOrCreateDictNode)] */ && arg1Value instanceof PNone) {
                        PNone arg1Value_ = (PNone) arg1Value;
                        if ((PGuards.isNoValue(arg1Value_))) {
                            Node inliningTarget__ = (this);
                            return DictNode.doit(arg0Value_, arg1Value_, inliningTarget__, INLINED_IT_GET_DICT_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[IOBaseDictBuiltins.DictNode.setDict(PythonObject, Object, PRaiseNode)] */) {
                        {
                            PRaiseNode raiseNode__ = this.setDict_raiseNode_;
                            if (raiseNode__ != null) {
                                return DictNode.setDict(arg0Value_, arg1Value, raiseNode__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PythonObject) {
                    PythonObject arg0Value_ = (PythonObject) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if (arg1Value instanceof PNone) {
                            PNone arg1Value_ = (PNone) arg1Value;
                            if ((PGuards.isNoValue(arg1Value_))) {
                                inliningTarget__ = (this);
                                state_0 = state_0 | 0b1 /* add SpecializationActive[IOBaseDictBuiltins.DictNode.doit(PythonObject, PNone, Node, GetOrCreateDictNode)] */;
                                this.state_0_ = state_0;
                                return DictNode.doit(arg0Value_, arg1Value_, inliningTarget__, INLINED_IT_GET_DICT_);
                            }
                        }
                    }
                    PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                    Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.setDict_raiseNode_ = raiseNode__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[IOBaseDictBuiltins.DictNode.setDict(PythonObject, Object, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return DictNode.setDict(arg0Value_, arg1Value, raiseNode__);
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
}
