/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.native_memory.NativeBuffer;
import com.oracle.graal.python.runtime.native_memory.NativePrimitiveReference;
import com.oracle.graal.python.runtime.sequence.storage.NativeIntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativePrimitiveSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Unsafe;

public class NativeBufferContext {
    private static final Unsafe unsafe = PythonUtils.initUnsafe();
    private ReferenceQueue<NativePrimitiveSequenceStorage> referenceQueue;
    private ConcurrentHashMap<NativePrimitiveReference, NativePrimitiveReference> phantomReferences;
    private Thread nativeBufferReferenceCleanerThread;

    @CompilerDirectives.TruffleBoundary
    public void initReferenceQueue() {
        PythonContext context = PythonContext.get(null);
        this.referenceQueue = new ReferenceQueue();
        this.phantomReferences = new ConcurrentHashMap();
        TruffleLanguage.Env env = context.getEnv();
        if (env.isCreateThreadAllowed()) {
            NativeBufferDeallocatorRunnable runnable = new NativeBufferDeallocatorRunnable(this.referenceQueue, this.phantomReferences);
            Thread thread = env.newTruffleThreadBuilder((Runnable)runnable).build();
            thread.setDaemon(true);
            thread.start();
            this.nativeBufferReferenceCleanerThread = thread;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public NativeIntSequenceStorage createNativeIntStorage(NativeBuffer valueBuffer, int length) {
        NativeIntSequenceStorage storage = new NativeIntSequenceStorage(valueBuffer, length);
        NativePrimitiveReference phantomRef = new NativePrimitiveReference(storage, this.getReferenceQueue());
        this.phantomReferences.put(phantomRef, phantomRef);
        return storage;
    }

    public void finalizeContext() {
        Thread thread = this.nativeBufferReferenceCleanerThread;
        if (thread != null) {
            if (thread.isAlive() && !thread.isInterrupted()) {
                thread.interrupt();
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public NativeIntSequenceStorage toNativeIntStorage(int[] arr) {
        long sizeInBytes = (long)arr.length * 4L;
        NativeBuffer nativeBuffer = NativeBuffer.allocateNew(sizeInBytes);
        unsafe.copyMemory(arr, Unsafe.ARRAY_INT_BASE_OFFSET, null, nativeBuffer.getMemoryAddress(), sizeInBytes);
        return this.createNativeIntStorage(nativeBuffer, arr.length);
    }

    private ReferenceQueue<NativePrimitiveSequenceStorage> getReferenceQueue() {
        assert (PythonContext.get(null).ownsGil());
        if (this.referenceQueue == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initReferenceQueue();
        }
        return this.referenceQueue;
    }

    static final class NativeBufferDeallocatorRunnable
    implements Runnable {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(NativeBufferDeallocatorRunnable.class);
        private final ReferenceQueue<NativePrimitiveSequenceStorage> referenceQueue;
        private final ConcurrentHashMap<NativePrimitiveReference, NativePrimitiveReference> references;

        public NativeBufferDeallocatorRunnable(ReferenceQueue<NativePrimitiveSequenceStorage> referenceQueue, ConcurrentHashMap<NativePrimitiveReference, NativePrimitiveReference> references) {
            this.referenceQueue = referenceQueue;
            this.references = references;
        }

        @Override
        public void run() {
            PythonContext pythonContext = PythonContext.get(null);
            PythonLanguage language = pythonContext.getLanguage();
            while (!pythonContext.getThreadState(language).isShuttingDown()) {
                try {
                    NativePrimitiveReference phantomRef = (NativePrimitiveReference)this.referenceQueue.remove();
                    phantomRef.release();
                    this.references.remove(phantomRef);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.fine("Native buffer reference cleaner thread was interrupted and is exiting");
                    return;
                }
            }
            LOGGER.fine("Native buffer reference cleaner thread is exiting.");
        }
    }
}

