/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.GetMethodsFlagsNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class, SpecialMethodSlot.class, ExternalFunctionNodes.PExternalFunctionWrapper.class})
@GenerateInline(value=false)
@GenerateUncached
public abstract class PySequenceDelItemNode
extends Node {
    private static final NativeCAPISymbol SYMBOL = NativeCAPISymbol.FUN_PY_SEQUENCE_DEL_ITEM;
    private static final CApiTiming C_API_TIMING = CApiTiming.create(true, SYMBOL.getName());

    public abstract Object execute(Frame var1, Object var2, int var3);

    public final Object execute(Object object, int index) {
        return this.execute(null, object, index);
    }

    @Specialization(guards={"!isNativeObject(object)"})
    static Object doGenericManaged(VirtualFrame frame, Object object, int index, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached GetMethodsFlagsNode getMethodsFlagsNode, @Cached(parameters={"DelItem"}) LookupSpecialMethodSlotNode lookupDelItem, @Cached CallBinaryMethodNode callDelItem, @Cached PRaiseNode.Lazy raise) {
        Object type = getClassNode.execute(inliningTarget, object);
        if ((getMethodsFlagsNode.execute(inliningTarget, type) & 0x200000000000L) != 0L) {
            Object delItem = lookupDelItem.execute((Frame)frame, type, object);
            assert (delItem != PNone.NO_VALUE);
            return callDelItem.executeObject((Frame)frame, delItem, object, index);
        }
        if ((getMethodsFlagsNode.execute(inliningTarget, type) & 0x10000000000000L) != 0L) {
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, object);
        }
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_DELETION, object);
    }

    @Specialization
    static Object doNative(VirtualFrame frame, PythonAbstractNativeObject object, int index, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionWrapperInvokeNode invokeNode2) {
        Object executable = CApiContext.getNativeSymbol(inliningTarget, SYMBOL);
        return invokeNode2.execute(frame, ExternalFunctionNodes.PExternalFunctionWrapper.DELITEM, C_API_TIMING, SYMBOL.getTsName(), executable, new Object[]{toNativeNode.execute(object), index});
    }
}

