/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.lib.PyObjectAsciiNodeGen;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class PyObjectAsciiNode
extends PNodeWithContext {
    public static TruffleString executeUncached(Object object) {
        return PyObjectAsciiNodeGen.getUncached().execute(null, null, object);
    }

    public final TruffleString executeCached(Frame frame, Object object) {
        return this.execute(frame, this, object);
    }

    public abstract TruffleString execute(Frame var1, Node var2, Object var3);

    @Specialization
    public static TruffleString ascii(VirtualFrame frame, Node inliningTarget, Object obj, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached(inline=false) TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached(inline=false) TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached(inline=false) TruffleStringIterator.NextNode nextNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.FromByteArrayNode fromByteArrayNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode) {
        TruffleString repr = reprNode.execute((Frame)frame, inliningTarget, obj);
        if (getCodeRangeNode.execute((AbstractTruffleString)repr, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII) {
            return repr;
        }
        byte[] bytes = new byte[codePointLengthNode.execute((AbstractTruffleString)repr, PythonUtils.TS_ENCODING) * 10];
        TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)repr, PythonUtils.TS_ENCODING);
        int j = 0;
        while (it.hasNext()) {
            int ch = nextNode.execute(it);
            j = BytesUtils.unicodeNonAsciiEscape(ch, j, bytes);
        }
        return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, 0, j, TruffleString.Encoding.US_ASCII, true), PythonUtils.TS_ENCODING);
    }

    @NeverDefault
    public static PyObjectAsciiNode create() {
        return PyObjectAsciiNodeGen.create();
    }

    public static PyObjectAsciiNode getUncached() {
        return PyObjectAsciiNodeGen.getUncached();
    }
}

