/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.pickle.PPickleBuffer;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.memoryview.CExtPyBuffer;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.NativeBufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.lib.PyMemoryViewFromObjectNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(value=false)
public abstract class PyMemoryViewFromObject
extends PNodeWithContext {
    public abstract PMemoryView execute(VirtualFrame var1, Object var2);

    @Specialization
    static PMemoryView fromMemoryView(PMemoryView object, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        object.checkReleased(inliningTarget, raiseNode);
        return factory.createMemoryView(PythonContext.get(inliningTarget), object.getLifecycleManager(), object.getBuffer(), object.getOwner(), object.getLength(), object.isReadOnly(), object.getItemSize(), object.getFormat(), object.getFormatString(), object.getDimensions(), object.getBufferPointer(), object.getOffset(), object.getBufferShape(), object.getBufferStrides(), object.getBufferSuboffsets(), object.getFlags());
    }

    @Specialization
    static PMemoryView fromNative(PythonNativeObject object, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.CreateMemoryViewFromNativeNode fromNativeNode) {
        return fromNativeNode.execute(inliningTarget, object, 284);
    }

    @Specialization
    static PMemoryView fromPickleBuffer(VirtualFrame frame, PPickleBuffer object, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PyMemoryViewFromObject recursive, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        Object owner = null;
        if (object.getView() != null) {
            owner = bufferLib.getOwner(object.getView());
        }
        if (owner == null) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.OP_FORBIDDEN_ON_OBJECT, "PickleBuffer");
        }
        return recursive.execute(frame, owner);
    }

    @Fallback
    static PMemoryView fromManaged(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile hasSlotProfile, @Cached InlinedConditionProfile isBuiltinClassTypeProfile, @Cached GetClassNode getClassNode, @Cached HiddenAttr.ReadNode readGetBufferNode, @Cached HiddenAttr.ReadNode readReleaseBufferNode, @Cached CallNode callNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached MemoryViewNodes.InitFlagsNode initFlagsNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode atIndexNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        Object typeObj = getClassNode.execute(inliningTarget, object);
        assert (typeObj instanceof PythonBuiltinClassType || typeObj instanceof PythonAbstractObject);
        PythonAbstractObject type = isBuiltinClassTypeProfile.profile(inliningTarget, typeObj instanceof PythonBuiltinClassType) ? PythonContext.get(inliningTarget).lookupType((PythonBuiltinClassType)((Object)typeObj)) : (PythonAbstractObject)typeObj;
        Object getBufferAttr = readGetBufferNode.execute(inliningTarget, type, HiddenAttr.GETBUFFER, null);
        if (hasSlotProfile.profile(inliningTarget, getBufferAttr != null)) {
            int[] strides;
            int[] shape;
            Object result = callNode.execute((Frame)frame, getBufferAttr, object, 284);
            if (!(result instanceof CExtPyBuffer)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("The internal " + String.valueOf(HiddenAttr.GETBUFFER) + " is expected to return a CExtPyBuffer object."));
            }
            CExtPyBuffer cBuffer = (CExtPyBuffer)result;
            Object releaseBufferAttr = readReleaseBufferNode.execute(inliningTarget, type, HiddenAttr.RELEASEBUFFER, null);
            NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromSlot bufferLifecycleManager = null;
            if (releaseBufferAttr != null) {
                bufferLifecycleManager = new NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromSlot(cBuffer, object, releaseBufferAttr);
            }
            if ((shape = cBuffer.getShape()) == null) {
                shape = new int[]{cBuffer.getLen() / cBuffer.getItemSize()};
            }
            if ((strides = cBuffer.getStrides()) == null) {
                strides = PMemoryView.initStridesFromShape(cBuffer.getDims(), cBuffer.getItemSize(), shape);
            }
            int[] suboffsets = cBuffer.getSuboffsets();
            int flags = initFlagsNode.execute(inliningTarget, cBuffer.getDims(), cBuffer.getItemSize(), shape, strides, suboffsets);
            NativeByteSequenceStorage pythonBuffer = NativeByteSequenceStorage.create(cBuffer.getBuf(), cBuffer.getLen(), cBuffer.getLen(), false);
            TruffleString format = cBuffer.getFormat();
            return factory.createMemoryView(PythonContext.get(inliningTarget), bufferLifecycleManager, pythonBuffer, cBuffer.getObj(), cBuffer.getLen(), cBuffer.isReadOnly(), cBuffer.getItemSize(), BufferFormat.forMemoryView(format, lengthNode, atIndexNode), format, cBuffer.getDims(), cBuffer.getBuf(), 0, shape, strides, suboffsets, flags);
        }
        if (bufferAcquireLib.hasBuffer(object)) {
            Object buffer = bufferAcquireLib.acquire(object, 284, frame, indirectCallData);
            return factory.createMemoryViewForManagedObject(buffer, bufferLib.getOwner(buffer), bufferLib.getItemSize(buffer), bufferLib.getBufferLength(buffer), bufferLib.isReadonly(buffer), bufferLib.getFormatString(buffer), lengthNode, atIndexNode);
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_A_BYTES_LIKE_OBJECT_REQUIRED_NOT_P, object);
    }

    @NeverDefault
    public static PyMemoryViewFromObject create() {
        return PyMemoryViewFromObjectNodeGen.create();
    }
}

