/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.superobject;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.superobject.SuperBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.superobject.SuperBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.superobject.SuperObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Super})
public final class SuperBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = SuperBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SuperBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class SuperReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        TruffleString repr(SuperObject self, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetTypeNode getType, @Cached GetObjectTypeNode getObjectType, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            String typeName;
            Object type = getType.execute(inliningTarget, self);
            Object objType = getObjectType.execute(inliningTarget, self);
            String string = typeName = type != null ? getNameNode.execute(inliningTarget, type) : "NULL";
            if (objType != null) {
                return simpleTruffleStringFormatNode.format("<super: %s, <%s object>>", typeName, getNameNode.execute(inliningTarget, objType));
            }
            return simpleTruffleStringFormatNode.format("<super: %s, NULL>", typeName);
        }
    }

    @Builtin(name="__self_class__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class SelfClassNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object getClass(SuperObject self, @Bind(value="this") Node inliningTarget, @Cached GetObjectTypeNode getObjectType) {
            Object objectType = getObjectType.execute(inliningTarget, self);
            if (objectType == null) {
                return PNone.NONE;
            }
            return objectType;
        }
    }

    @Builtin(name="__self__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class SelfNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object getClass(SuperObject self, @Bind(value="this") Node inliningTarget, @Cached GetObjectNode getObject) {
            Object object = getObject.execute(inliningTarget, self);
            if (object == null) {
                return PNone.NONE;
            }
            return object;
        }
    }

    @Builtin(name="__thisclass__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ThisClassNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object getClass(SuperObject self, @Bind(value="this") Node inliningTarget, @Cached GetTypeNode getType) {
            Object type = getType.execute(inliningTarget, self);
            if (type == null) {
                return PNone.NONE;
            }
            return type;
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetattributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @Node.Child
        private ReadAttributeFromObjectNode readFromDict = ReadAttributeFromObjectNode.createForceType();
        @Node.Child
        private TpSlotDescrGet.CallSlotDescrGet callGetSlotNode;
        @Node.Child
        private GetTypeNode getType;
        @Node.Child
        private GetObjectNode getObject;
        @Node.Child
        private ObjectBuiltins.GetAttributeNode objectGetattributeNode;
        @Node.Child
        private TypeNodes.GetMroNode getMroNode;
        @Node.Child
        private TypeNodes.IsSameTypeNode isSameTypeNode;

        private Object genericGetAttr(VirtualFrame frame, Object object, Object attr) {
            if (this.objectGetattributeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectGetattributeNode = (ObjectBuiltins.GetAttributeNode)this.insert(ObjectBuiltinsFactory.GetAttributeNodeFactory.create());
            }
            return this.objectGetattributeNode.execute(frame, object, attr);
        }

        @Specialization
        Object get(VirtualFrame frame, SuperObject self, Object attr, @Bind(value="this") Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TruffleString.EqualNode equalNode, @Cached GetObjectTypeNode getObjectType, @Cached StringNodes.CastToTruffleStringCheckedNode castToTruffleStringNode) {
            Object startType = getObjectType.execute(inliningTarget, self);
            if (startType == null) {
                return this.genericGetAttr(frame, self, attr);
            }
            TruffleString stringAttr = castToTruffleStringNode.cast(inliningTarget, attr, ErrorMessages.ATTR_NAME_MUST_BE_STRING, attr);
            if (equalNode.execute((AbstractTruffleString)stringAttr, (AbstractTruffleString)SpecialAttributeNames.T___CLASS__, PythonUtils.TS_ENCODING)) {
                return this.genericGetAttr(frame, self, SpecialAttributeNames.T___CLASS__);
            }
            if (this.getType == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getType = (GetTypeNode)this.insert(SuperBuiltinsFactory.GetTypeNodeGen.create());
            }
            PythonAbstractClass[] mro = this.getMro(startType);
            int i = 0;
            int n = mro.length;
            i = 0;
            while (i + 1 < n && !this.isSameType(this.getType.executeCached(self), mro[i])) {
                ++i;
            }
            if (++i >= n) {
                return this.genericGetAttr(frame, self, stringAttr);
            }
            while (i < n) {
                PythonAbstractClass tmp = mro[i];
                Object res = this.readFromDict.execute(tmp, stringAttr);
                if (res != PNone.NO_VALUE) {
                    TpSlots resSlots = getSlotsNode.execute(inliningTarget, res);
                    if (resSlots.tp_descr_get() != null) {
                        if (this.callGetSlotNode == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.callGetSlotNode = (TpSlotDescrGet.CallSlotDescrGet)this.insert(TpSlotDescrGet.CallSlotDescrGet.create());
                        }
                        if (this.getObject == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.getObject = (GetObjectNode)this.insert(SuperBuiltinsFactory.GetObjectNodeGen.create());
                        }
                        res = this.callGetSlotNode.executeCached(frame, resSlots.tp_descr_get(), res, this.getObject.executeCached(self) == startType ? PNone.NO_VALUE : self.getObject(), startType);
                    }
                    return res;
                }
                ++i;
            }
            return this.genericGetAttr(frame, self, stringAttr);
        }

        private boolean isSameType(Object execute, Object abstractPythonClass) {
            if (this.isSameTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSameTypeNode = (TypeNodes.IsSameTypeNode)this.insert(TypeNodesFactory.IsSameTypeNodeGen.create());
            }
            return this.isSameTypeNode.executeCached(execute, abstractPythonClass);
        }

        private PythonAbstractClass[] getMro(Object clazz) {
            if (this.getMroNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getMroNode = (TypeNodes.GetMroNode)this.insert(TypeNodes.GetMroNode.create());
            }
            return this.getMroNode.executeCached(clazz);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class DoGetNode
    extends Node {
        DoGetNode() {
        }

        public abstract Object execute(Node var1, SuperObject var2, Object var3);

        @Specialization
        static Object doIt(Node inliningTarget, SuperObject self, Object obj, @Cached GetTypeNode getType, @Cached(inline=false) SuperInitNode superInit, @Cached GetClassNode getClass, @Cached(inline=false) PythonObjectFactory factory) {
            SuperObject newSuper = factory.createSuperObject(getClass.execute(inliningTarget, self));
            superInit.execute(null, (Object)newSuper, getType.execute(inliningTarget, self), obj);
            return newSuper;
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        @Specialization
        static Object doNoneOrBound(SuperObject self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile objIsNoneProfile, @Cached InlinedConditionProfile selfObjIsNullProfile, @Cached GetObjectNode getObject, @Cached DoGetNode doGetNode) {
            if (objIsNoneProfile.profile(inliningTarget, PGuards.isPNone(obj)) || selfObjIsNullProfile.profile(inliningTarget, getObject.execute(inliningTarget, self) != null)) {
                return self;
            }
            return doGetNode.execute(inliningTarget, self, obj);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, alwaysNeedsCallerFrame=true)
    @GenerateNodeFactory
    public static abstract class SuperInitNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private IsSubtypeNode isSubtypeNode;
        @Node.Child
        private GetClassNode getClassNode;
        @Node.Child
        private PyObjectLookupAttr getAttrNode;
        @Node.Child
        private TypeNodes.IsTypeNode isTypeNode;

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (keywords.length != 0) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNEXPECTED_KEYWORD_ARGS, "super()");
            }
            if (arguments.length == 1) {
                return this.execute(frame, arguments[0], PNone.NO_VALUE, PNone.NO_VALUE);
            }
            if (arguments.length == 2) {
                return this.execute(frame, arguments[0], arguments[1], PNone.NO_VALUE);
            }
            if (arguments.length == 3) {
                return this.execute(frame, arguments[0], arguments[1], arguments[2]);
            }
            throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.INVALID_NUMBER_OF_ARGUMENTS, "super()");
        }

        @Override
        public final Object execute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            if (keywords.length != 0) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNEXPECTED_KEYWORD_ARGS, "super()");
            }
            if (arguments.length == 0) {
                return this.execute(frame, self, PNone.NO_VALUE, PNone.NO_VALUE);
            }
            if (arguments.length == 1) {
                return this.execute(frame, self, arguments[0], PNone.NO_VALUE);
            }
            if (arguments.length == 2) {
                return this.execute(frame, self, arguments[0], arguments[1]);
            }
            throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.TOO_MANY_ARG, "super()");
        }

        protected abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization(guards={"!isNoValue(cls)"})
        PNone init(VirtualFrame frame, SuperObject self, Object cls, Object obj) {
            if (!(obj instanceof PNone)) {
                Object type = this.supercheck(frame, cls, obj);
                self.init(cls, type, obj);
            } else {
                self.init(cls, null, null);
            }
            return PNone.NONE;
        }

        @Idempotent
        protected boolean isInBuiltinFunctionRoot() {
            return this.getRootNode() instanceof BuiltinFunctionRootNode;
        }

        @Specialization(guards={"!isInBuiltinFunctionRoot()", "isNoValue(clsArg)", "isNoValue(objArg)"})
        PNone initInPlace(VirtualFrame frame, SuperObject self, PNone clsArg, PNone objArg, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CellBuiltins.GetRefNode getRefNode) {
            PBytecodeRootNode rootNode = (PBytecodeRootNode)this.getRootNode();
            VirtualFrame localFrame = frame;
            if (rootNode.getCodeUnit().isGeneratorOrCoroutine()) {
                localFrame = PArguments.getGeneratorFrame((Frame)frame);
            }
            return this.initFromLocalFrame(frame, inliningTarget, self, rootNode, (Frame)localFrame, getRefNode);
        }

        @Specialization(guards={"isInBuiltinFunctionRoot()", "isNoValue(clsArg)", "isNoValue(objArg)"})
        PNone init(VirtualFrame frame, SuperObject self, PNone clsArg, PNone objArg, @Bind(value="this") Node inliningTarget, @Cached ReadCallerFrameNode readCaller, @Cached.Shared @Cached CellBuiltins.GetRefNode getRefNode) {
            PFrame target = readCaller.executeWith(frame, ReadCallerFrameNode.FrameSelector.SKIP_PYTHON_BUILTIN, 0);
            if (target == null) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.NO_CURRENT_FRAME, "super()");
            }
            MaterializedFrame locals = target.getLocals();
            if (locals == null) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.SUPER_NO_CLASS);
            }
            FrameInfo frameInfo = (FrameInfo)locals.getFrameDescriptor().getInfo();
            return this.initFromLocalFrame(frame, inliningTarget, self, frameInfo.getRootNode(), (Frame)locals, getRefNode);
        }

        private PNone initFromLocalFrame(VirtualFrame frame, Node inliningTarget, SuperObject self, PBytecodeRootNode rootNode, Frame localFrame, CellBuiltins.GetRefNode getRefNode) {
            PCell classCell = rootNode.readClassCell(localFrame);
            if (classCell == null) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.SUPER_NO_CLASS);
            }
            Object cls = getRefNode.execute(inliningTarget, classCell);
            if (cls == null) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.SUPER_EMPTY_CLASS);
            }
            Object obj = rootNode.readSelf(localFrame);
            if (obj == null) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.NO_ARGS, "super()");
            }
            return this.init(frame, self, cls, obj);
        }

        @Fallback
        PNone initFallback(Object self, Object cls, Object obj) {
            throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.INVALID_ARGS, "super()");
        }

        private IsSubtypeNode getIsSubtype() {
            if (this.isSubtypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSubtypeNode = (IsSubtypeNode)this.insert(IsSubtypeNode.create());
            }
            return this.isSubtypeNode;
        }

        private GetClassNode getGetClass() {
            if (this.getClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getClassNode;
        }

        private TypeNodes.IsTypeNode ensureIsTypeNode() {
            if (this.isTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTypeNode = (TypeNodes.IsTypeNode)this.insert(TypeNodes.IsTypeNode.create());
            }
            return this.isTypeNode;
        }

        private PyObjectLookupAttr getGetAttr() {
            if (this.getAttrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getAttrNode = (PyObjectLookupAttr)this.insert(PyObjectLookupAttr.create());
            }
            return this.getAttrNode;
        }

        private Object supercheck(VirtualFrame frame, Object cls, Object object) {
            if (this.ensureIsTypeNode().executeCached(object) && this.getIsSubtype().execute(frame, object, cls)) {
                return object;
            }
            Object objectType = this.getGetClass().executeCached(object);
            if (this.getIsSubtype().execute(frame, objectType, cls)) {
                return objectType;
            }
            try {
                Object classObject = this.getGetAttr().executeCached((Frame)frame, object, SpecialAttributeNames.T___CLASS__);
                if (this.ensureIsTypeNode().executeCached(classObject) && this.getIsSubtype().execute(frame, classObject, cls)) {
                    return classObject;
                }
            }
            catch (PException pException) {
                // empty catch block
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.SUPER_OBJ_MUST_BE_INST_SUB_OR_TYPE);
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    static abstract class GetObjectNode
    extends PNodeWithContext {
        GetObjectNode() {
        }

        abstract Object execute(Node var1, SuperObject var2);

        final Object executeCached(SuperObject self) {
            return this.execute(this, self);
        }

        @Specialization(guards={"isSingleContext()", "self == cachedSelf"}, assumptions={"cachedSelf.getNeverReinitializedAssumption()"}, limit="1")
        static Object cached(@NeverDefault SuperObject self, @Cached(value="self") SuperObject cachedSelf, @Cached(value="self.getObject()") Object object) {
            return object;
        }

        @Specialization(replaces={"cached"})
        static Object uncached(SuperObject self) {
            return self.getObject();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetObjectTypeNode
    extends PNodeWithContext {
        GetObjectTypeNode() {
        }

        abstract Object execute(Node var1, SuperObject var2);

        @Specialization(guards={"isSingleContext()", "self == cachedSelf"}, assumptions={"cachedSelf.getNeverReinitializedAssumption()"}, limit="1")
        static Object cached(@NeverDefault SuperObject self, @Cached(value="self") SuperObject cachedSelf, @Cached(value="self.getObjectType()") Object type) {
            return type;
        }

        @Specialization(replaces={"cached"})
        static Object uncached(SuperObject self) {
            return self.getObjectType();
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    static abstract class GetTypeNode
    extends PNodeWithContext {
        GetTypeNode() {
        }

        abstract Object execute(Node var1, SuperObject var2);

        final Object executeCached(SuperObject self) {
            return this.execute(this, self);
        }

        @Specialization(guards={"isSingleContext()", "self == cachedSelf"}, assumptions={"cachedSelf.getNeverReinitializedAssumption()"}, limit="1")
        static Object cached(@NeverDefault SuperObject self, @Cached(value="self") SuperObject cachedSelf, @Cached(value="self.getType()") Object type) {
            return type;
        }

        @Specialization(replaces={"cached"})
        static Object uncached(SuperObject self) {
            return self.getType();
        }
    }
}

