/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.socket.SocketUtils;
import com.oracle.graal.python.builtins.objects.ssl.PMemoryBIO;
import com.oracle.graal.python.builtins.objects.ssl.PSSLSocket;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorCode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

@GenerateInline
@GenerateCached(value=false)
public abstract class SSLOperationNode
extends PNodeWithContext {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final int TLS_HEADER_SIZE = 5;

    public void write(VirtualFrame frame, Node inliningTarget, PSSLSocket socket, ByteBuffer input) {
        this.execute(frame, inliningTarget, socket, input, EMPTY_BUFFER, SSLOperation.WRITE);
    }

    public void read(VirtualFrame frame, Node inliningTarget, PSSLSocket socket, ByteBuffer target) {
        this.execute(frame, inliningTarget, socket, EMPTY_BUFFER, target, SSLOperation.READ);
    }

    public void handshake(VirtualFrame frame, Node inliningTarget, PSSLSocket socket) {
        if (!socket.isHandshakeComplete()) {
            try {
                SSLOperationNode.beginHandshake(socket);
            }
            catch (SSLException e) {
                throw SSLOperationNode.handleSSLException(e);
            }
            this.execute(frame, inliningTarget, socket, EMPTY_BUFFER, EMPTY_BUFFER, SSLOperation.HANDSHAKE);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void beginHandshake(PSSLSocket socket) throws SSLException {
        socket.getEngine().beginHandshake();
    }

    public void shutdown(VirtualFrame frame, Node inliningTarget, PSSLSocket socket) {
        SSLOperationNode.closeOutbound(socket);
        this.execute(frame, inliningTarget, socket, EMPTY_BUFFER, EMPTY_BUFFER, SSLOperation.SHUTDOWN);
    }

    @CompilerDirectives.TruffleBoundary
    private static void closeOutbound(PSSLSocket socket) {
        socket.getEngine().closeOutbound();
    }

    protected abstract void execute(VirtualFrame var1, Node var2, PSSLSocket var3, ByteBuffer var4, ByteBuffer var5, SSLOperation var6);

    @Specialization(guards={"socket.getSocket() != null"})
    static void doSocket(VirtualFrame frame, Node inliningTarget, PSSLSocket socket, ByteBuffer appInput, ByteBuffer targetBuffer, SSLOperation operation, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached(inline=false) GilNode gil, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
        assert (socket.getSocket() != null);
        SSLOperationNode.prepare(socket);
        SocketUtils.TimeoutHelper timeoutHelper = null;
        if (socket.getSocket().getTimeoutNs() > 0L) {
            timeoutHelper = new SocketUtils.TimeoutHelper(socket.getSocket().getTimeoutNs());
        }
        PythonContext context = PythonContext.get(inliningTarget);
        while (true) {
            try {
                SSLOperationStatus status = SSLOperationNode.loop(socket, appInput, targetBuffer, operation);
                switch (status.ordinal()) {
                    case 2: {
                        return;
                    }
                    case 0: {
                        PMemoryBIO networkInboundBIO = socket.getNetworkInboundBIO();
                        int packetLen = networkInboundBIO.getPending() >= 5 ? 5 + ((networkInboundBIO.getByte(3) & 0xFF) << 8) + (networkInboundBIO.getByte(4) & 0xFF) : 5;
                        if (networkInboundBIO.getPending() >= packetLen) {
                            throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL, ErrorMessages.PACKET_SIZE_MISMATCH, new Object[0]);
                        }
                        int len1 = packetLen - networkInboundBIO.getPending();
                        networkInboundBIO.ensureWriteCapacity(len1);
                        byte[] bytes1 = networkInboundBIO.getInternalBytes();
                        int offset1 = networkInboundBIO.getWritePosition();
                        try {
                            int recvlen = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket.getSocket(), (p, s) -> p.recv(s, socket.getSocket().getFd(), bytes1, offset1, len1, 0), true, false, timeoutHelper);
                            if (recvlen == 0) {
                                if (socket.hasSavedException()) {
                                    throw socket.getAndClearSavedException();
                                }
                                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_EOF, ErrorMessages.SSL_ERROR_EOF, new Object[0]);
                            }
                            networkInboundBIO.advanceWritePosition(recvlen);
                            break;
                        }
                        catch (PosixSupportLibrary.PosixException e) {
                            if (e.getErrorCode() == OSErrorEnum.EAGAIN.getNumber() || e.getErrorCode() == OSErrorEnum.EWOULDBLOCK.getNumber()) {
                                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_WANT_READ, ErrorMessages.SSL_WANT_READ, new Object[0]);
                            }
                            if (socket.hasSavedException()) {
                                throw socket.getAndClearSavedException();
                            }
                            throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING), null, null);
                        }
                    }
                    case 1: {
                        PMemoryBIO networkOutboundBIO = socket.getNetworkOutboundBIO();
                        byte[] bytes2 = networkOutboundBIO.getInternalBytes();
                        int offset2 = networkOutboundBIO.getReadPosition();
                        int len2 = networkOutboundBIO.getPending();
                        try {
                            int writtenBytes = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket.getSocket(), (p, s) -> p.send(s, socket.getSocket().getFd(), bytes2, offset2, len2, 0), true, false, timeoutHelper);
                            networkOutboundBIO.advanceReadPosition(writtenBytes);
                            break;
                        }
                        catch (PosixSupportLibrary.PosixException e) {
                            if (e.getErrorCode() == OSErrorEnum.EAGAIN.getNumber() || e.getErrorCode() == OSErrorEnum.EWOULDBLOCK.getNumber()) {
                                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_WANT_WRITE, ErrorMessages.SSL_WANT_WRITE, new Object[0]);
                            }
                            if (socket.hasSavedException()) {
                                throw socket.getAndClearSavedException();
                            }
                            throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING), null, null);
                        }
                    }
                }
            }
            catch (SSLException e) {
                throw SSLOperationNode.handleSSLException(e);
            }
            catch (OverflowException | OutOfMemoryError node) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
            PythonContext.triggerAsyncActions(inliningTarget);
        }
    }

    @Specialization(guards={"socket.getSocket() == null"})
    static void doMemory(VirtualFrame frame, Node inliningTarget, PSSLSocket socket, ByteBuffer appInput, ByteBuffer targetBuffer, SSLOperation operation, @Cached.Shared @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
        SSLOperationNode.prepare(socket);
        try {
            SSLOperationStatus status = SSLOperationNode.loop(socket, appInput, targetBuffer, operation);
            switch (status.ordinal()) {
                case 2: {
                    return;
                }
                case 0: {
                    if (socket.getNetworkInboundBIO().didWriteEOF()) {
                        if (socket.hasSavedException()) {
                            throw socket.getAndClearSavedException();
                        }
                        throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_EOF, ErrorMessages.SSL_ERROR_EOF, new Object[0]);
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_WANT_READ, ErrorMessages.SSL_WANT_READ, new Object[0]);
                }
                case 1: {
                    throw CompilerDirectives.shouldNotReachHere((String)"MemoryBIO-based socket operation returned WANTS_WRITE");
                }
            }
        }
        catch (SSLException e) {
            throw SSLOperationNode.handleSSLException(e);
        }
        catch (OverflowException | OutOfMemoryError node) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
        }
    }

    private static void prepare(PSSLSocket socket) {
        if ((socket.getContext().getOptions() & 0x4000L) != 0L) {
            SSLOperationNode.invalidateSession(socket);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void invalidateSession(PSSLSocket socket) {
        socket.getEngine().getSession().invalidate();
    }

    private static void putAsMuchAsPossible(ByteBuffer target, PMemoryBIO sourceBIO) {
        ByteBuffer source = sourceBIO.getBufferForReading();
        int remaining = Math.min(source.remaining(), target.remaining());
        int oldLimit = source.limit();
        source.limit(source.position() + remaining);
        target.put(source);
        source.limit(oldLimit);
        sourceBIO.applyRead(source);
    }

    @CompilerDirectives.TruffleBoundary
    private static SSLOperationStatus loop(PSSLSocket socket, ByteBuffer appInput, ByteBuffer targetBuffer, SSLOperation op) throws SSLException, OverflowException {
        PMemoryBIO applicationInboundBIO = socket.getApplicationInboundBIO();
        PMemoryBIO networkInboundBIO = socket.getNetworkInboundBIO();
        PMemoryBIO networkOutboundBIO = socket.getNetworkOutboundBIO();
        if (op == SSLOperation.READ && applicationInboundBIO.getPending() > 0) {
            SSLOperationNode.putAsMuchAsPossible(targetBuffer, applicationInboundBIO);
            return SSLOperationStatus.COMPLETE;
        }
        SSLEngine engine = socket.getEngine();
        PSocket pSocket = socket.getSocket();
        boolean writeDirectlyToTarget = true;
        boolean didReadApplicationData = false;
        if (pSocket != null && networkOutboundBIO.getPending() > 0) {
            return SSLOperationStatus.WANTS_WRITE;
        }
        block27: while (true) {
            SSLEngineResult result;
            boolean currentlyWrapping;
            SSLEngineResult.HandshakeStatus lastStatus = engine.getHandshakeStatus();
            switch (lastStatus) {
                case NEED_TASK: {
                    socket.setHandshakeComplete(false);
                    while (true) {
                        Runnable task;
                        if ((task = engine.getDelegatedTask()) == null) continue block27;
                        task.run();
                    }
                }
                case NEED_WRAP: {
                    socket.setHandshakeComplete(false);
                    currentlyWrapping = true;
                    break;
                }
                case NEED_UNWRAP: {
                    socket.setHandshakeComplete(false);
                    currentlyWrapping = false;
                    break;
                }
                case NOT_HANDSHAKING: {
                    currentlyWrapping = op != SSLOperation.READ;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"Unhandled SSL handshake status");
                }
            }
            if (engine.isOutboundDone()) {
                currentlyWrapping = false;
            }
            try {
                if (currentlyWrapping) {
                    result = SSLOperationNode.doWrap(engine, appInput, networkOutboundBIO, engine.getSession().getPacketBufferSize());
                } else {
                    result = SSLOperationNode.doUnwrap(engine, networkInboundBIO, targetBuffer, applicationInboundBIO, writeDirectlyToTarget);
                    didReadApplicationData = result.bytesProduced() > 0;
                }
            }
            catch (SSLException e) {
                if (socket.hasSavedException()) {
                    throw socket.getAndClearSavedException();
                }
                socket.setException(e);
                engine.closeOutbound();
                continue;
            }
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && !engine.isOutboundDone()) {
                socket.setHandshakeComplete(true);
            }
            if (pSocket != null && networkOutboundBIO.getPending() > 0) {
                return SSLOperationStatus.WANTS_WRITE;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                engine.closeOutbound();
            }
            if (engine.isOutboundDone() && engine.isInboundDone()) {
                if (socket.hasSavedException()) {
                    throw socket.getAndClearSavedException();
                }
                switch (op.ordinal()) {
                    case 0: {
                        break block27;
                    }
                    case 3: {
                        break block27;
                    }
                    case 1: 
                    case 2: {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_ZERO_RETURN, ErrorMessages.SSL_SESSION_CLOSED, new Object[0]);
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
            }
            if (engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && engine.getHandshakeStatus() != lastStatus) continue;
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    if (currentlyWrapping) {
                        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected overflow of network buffer");
                    }
                    writeDirectlyToTarget = false;
                    continue block27;
                }
                case BUFFER_UNDERFLOW: {
                    return SSLOperationStatus.WANTS_READ;
                }
            }
            if (engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            switch (result.getStatus()) {
                case OK: {
                    switch (op.ordinal()) {
                        case 0: {
                            if (!didReadApplicationData) continue block27;
                            break block27;
                        }
                        case 2: {
                            break block27;
                        }
                        case 1: {
                            if (!appInput.hasRemaining()) break block27;
                            continue block27;
                        }
                        case 3: {
                            continue block27;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                }
                case CLOSED: {
                    continue block27;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"Unhandled SSL engine status");
                }
            }
            break;
        }
        if (socket.hasSavedException()) {
            throw socket.getAndClearSavedException();
        }
        assert (!appInput.hasRemaining());
        return SSLOperationStatus.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLEngineResult doUnwrap(SSLEngine engine, PMemoryBIO networkInboundBIO, ByteBuffer targetBuffer, PMemoryBIO applicationInboundBIO, boolean writeDirectlyToTarget) throws SSLException, OverflowException {
        ByteBuffer readBuffer = networkInboundBIO.getBufferForReading();
        try {
            SSLEngineResult sSLEngineResult;
            if (writeDirectlyToTarget) {
                SSLEngineResult sSLEngineResult2 = engine.unwrap(readBuffer, targetBuffer);
                return sSLEngineResult2;
            }
            applicationInboundBIO.ensureWriteCapacity(engine.getSession().getApplicationBufferSize());
            ByteBuffer writeBuffer = applicationInboundBIO.getBufferForWriting();
            try {
                sSLEngineResult = engine.unwrap(readBuffer, writeBuffer);
                applicationInboundBIO.applyWrite(writeBuffer);
            }
            catch (Throwable throwable) {
                applicationInboundBIO.applyWrite(writeBuffer);
                SSLOperationNode.putAsMuchAsPossible(targetBuffer, applicationInboundBIO);
                throw throwable;
            }
            SSLOperationNode.putAsMuchAsPossible(targetBuffer, applicationInboundBIO);
            return sSLEngineResult;
        }
        finally {
            networkInboundBIO.applyRead(readBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLEngineResult doWrap(SSLEngine engine, ByteBuffer appInput, PMemoryBIO networkOutboundBIO, int netBufferSize) throws SSLException, OverflowException {
        networkOutboundBIO.ensureWriteCapacity(netBufferSize);
        ByteBuffer writeBuffer = networkOutboundBIO.getBufferForWriting();
        try {
            SSLEngineResult sSLEngineResult = engine.wrap(appInput, writeBuffer);
            return sSLEngineResult;
        }
        finally {
            networkOutboundBIO.applyWrite(writeBuffer);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static PException handleSSLException(SSLException e) {
        if (e.getCause() instanceof CertificateException) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_CERT_VERIFICATION, ErrorMessages.CERTIFICATE_VERIFY_FAILED, e.toString());
        }
        throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL, PythonUtils.toTruffleStringUncached(e.toString()), new Object[0]);
    }

    protected static enum SSLOperation {
        READ,
        WRITE,
        HANDSHAKE,
        SHUTDOWN;

    }

    protected static enum SSLOperationStatus {
        WANTS_READ,
        WANTS_WRITE,
        COMPLETE;

    }
}

