/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.getsetdescriptor;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.IndexedSlotDescriptor;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.GetSetDescriptor, PythonBuiltinClassType.MemberDescriptor})
public final class DescriptorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DescriptorBuiltinsFactory.getFactories();
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class GetOrCreateIndexedSlots
    extends Node {
        GetOrCreateIndexedSlots() {
        }

        abstract Object[] execute(Node var1, PythonAbstractObject var2);

        @Specialization(guards={"object.getIndexedSlots() != null"})
        static Object[] doGet(PythonAbstractObject object) {
            return object.getIndexedSlots();
        }

        @Specialization(guards={"object.getIndexedSlots() == null"})
        static Object[] doCreate(Node inliningTarget, PythonAbstractObject object, @Cached TypeNodes.GetIndexedSlotsCountNode getIndexedSlotsCountNode, @Cached GetClassNode getClassNode) {
            Object cls = getClassNode.execute(inliningTarget, object);
            int slotCount = getIndexedSlotsCountNode.execute(inliningTarget, cls);
            Object[] slots = new Object[slotCount];
            object.setIndexedSlots(slots);
            return slots;
        }
    }

    @GenerateInline(value=false)
    public static abstract class DescrDeleteNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached CallBinaryMethodNode callNode, @Cached InlinedBranchProfile branchProfile) {
            if (descr.allowsDelete()) {
                return callNode.executeObject((Frame)frame, descr.getSet(), obj, DescriptorDeleteMarker.INSTANCE);
            }
            branchProfile.enter(inliningTarget);
            if (descr.getSet() != null) {
                if (descr.getName().equalsUncached((AbstractTruffleString)IONodes.T__CHUNK_SIZE, PythonUtils.TS_ENCODING)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.CANNOT_DELETE);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_DELETE_ATTRIBUTE, getNameNode.execute(inliningTarget, descr.getType()), descr.getName());
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTRIBUTE_S_OF_P_OBJECTS_IS_NOT_WRITABLE, descr.getName(), obj);
        }

        @Specialization
        Object doIndexedSlotDescriptor(IndexedSlotDescriptor descr, PythonAbstractObject obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached GetOrCreateIndexedSlots getSlotsNode, @Cached InlinedConditionProfile profile) {
            Object[] slots = getSlotsNode.execute(inliningTarget, obj);
            if (profile.profile(inliningTarget, slots[descr.getIndex()] != null)) {
                slots[descr.getIndex()] = null;
                return PNone.NONE;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.S, descr.getName());
        }
    }

    @GenerateInline(value=false)
    public static abstract class DescrSetNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object value, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getNameNode, @Cached PRaiseNode.Lazy raiseNode, @Cached CallBinaryMethodNode callNode) {
            if (descr.getSet() != null) {
                return callNode.executeObject((Frame)frame, descr.getSet(), obj, value);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_WRITABLE, descr.getName(), getNameNode.execute(inliningTarget, descr.getType()));
        }

        @Specialization
        static Object doIndexedSlotDescriptor(IndexedSlotDescriptor descr, PythonAbstractObject obj, Object value, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateIndexedSlots getSlotsNode) {
            getSlotsNode.execute((Node)inliningTarget, (PythonAbstractObject)obj)[descr.getIndex()] = value;
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class DescrGetNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached CallUnaryMethodNode callNode) {
            if (descr.getGet() != null) {
                return callNode.executeObject((Frame)frame, descr.getGet(), obj);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_IS_NOT_READABLE, descr.getName(), getNameNode.execute(inliningTarget, descr.getType()));
        }

        @Specialization
        Object doIndexedSlotDescriptor(IndexedSlotDescriptor descr, PythonAbstractObject obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached GetOrCreateIndexedSlots getSlotsNode) {
            Object[] slots = getSlotsNode.execute(inliningTarget, obj);
            Object val = slots[descr.getIndex()];
            if (val != null) {
                return val;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_N_HAS_NO_ATTR_S, descr.getType(), descr.getName());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class DescriptorCheckNode
    extends Node {
        DescriptorCheckNode() {
        }

        public abstract void execute(Node var1, Object var2, Object var3, Object var4);

        @Specialization
        static void check(Node inliningTarget, Object descrType, Object name, Object obj, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached(inline=false) PRaiseNode raiseNode) {
            Object type = getClassNode.execute(inliningTarget, obj);
            if (!isSubtypeNode.execute(type, descrType)) {
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESC_S_FOR_N_DOESNT_APPLY_TO_N, name, descrType, type);
            }
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doGetSetDescriptor(GetSetDescriptor self) {
            return self.getName();
        }

        @Specialization
        static TruffleString doIndexedSlotDescriptor(IndexedSlotDescriptor self) {
            return self.getName();
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class QualnameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor self, @Cached.Shared @Cached(value="create(T___QUALNAME__)") GetAttributeNode.GetFixedAttributeNode readQualNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("%s.%s", QualnameNode.toStr(readQualNameNode.executeObject(frame, self.getType())), self.getName());
        }

        @Specialization
        static TruffleString doIndexedSlotDescriptor(VirtualFrame frame, IndexedSlotDescriptor self, @Cached.Shared @Cached(value="create(T___QUALNAME__)") GetAttributeNode.GetFixedAttributeNode readQualNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("%s.%s", QualnameNode.toStr(readQualNameNode.executeObject(frame, self.getType())), self.getName());
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStr(Object o) {
            return o.toString();
        }
    }
}

