/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.foreign.AccessForeignItemNodesFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

abstract class AccessForeignItemNodes {
    AccessForeignItemNodes() {
    }

    private static PException keyError(AccessForeignItemBaseNode node, Object key, InteropLibrary lib, TruffleString.SwitchEncodingNode switchEncodingNode) {
        try {
            return node.raise(PythonErrorType.KeyError, switchEncodingNode.execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(key, true)), PythonUtils.TS_ENCODING), new Object[0]);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @ImportStatic(value={PythonOptions.class})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    protected static abstract class AccessForeignItemBaseNode
    extends PNodeWithContext {
        @Node.Child
        PRaiseNode raiseNode;

        protected AccessForeignItemBaseNode() {
        }

        protected PException raise(PythonBuiltinClassType type, TruffleString msg, Object ... arguments) {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode.raise(type, msg, arguments);
        }

        protected static boolean isSlice(Object o) {
            return o instanceof PSlice;
        }

        protected int getForeignSize(Object object, InteropLibrary libForObject) {
            long foreignSizeObj = 0L;
            try {
                foreignSizeObj = libForObject.getArraySize(object);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (foreignSizeObj <= Integer.MAX_VALUE) {
                return (int)foreignSizeObj;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.NUMBER_S_CANNOT_FIT_INTO_INDEXSIZED_INT, foreignSizeObj);
        }

        protected PSlice.SliceInfo materializeSlice(VirtualFrame frame, PSlice idxSlice, Object object, SliceNodes.ComputeIndices compute, InteropLibrary libForObject) {
            int foreignSize = this.getForeignSize(object, libForObject);
            return compute.execute((Frame)frame, idxSlice, foreignSize);
        }
    }

    protected static abstract class RemoveForeignItemNode
    extends AccessForeignItemBaseNode {
        protected RemoveForeignItemNode() {
        }

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"lib.hasArrayElements(object)"})
        Object doArraySlice(VirtualFrame frame, Object object, PSlice idxSlice, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Bind(value="this") Node inliningTarget, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached.Shared(value="gil") @Cached GilNode gil) {
            PSlice.SliceInfo mslice = this.materializeSlice(frame, sliceCast.execute(inliningTarget, idxSlice), object, compute, lib);
            gil.release(true);
            try {
                for (int i = mslice.start; i < mslice.stop; i += mslice.step) {
                    this.removeForeignValue(object, i, lib);
                }
            }
            finally {
                gil.acquire();
            }
            return PNone.NONE;
        }

        @Specialization(guards={"lib.hasArrayElements(object)", "!isPSlice(key)"})
        Object doArrayIndex(Object object, Object key, @Cached IndexNodes.NormalizeIndexNode normalize, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached.Shared(value="gil") @Cached GilNode gil) {
            if (lib.isNumber(key) && lib.fitsInInt(key)) {
                gil.release(true);
                try {
                    this.removeForeignValue(object, normalize.execute(lib.asInt(key), (int)lib.getArraySize(object)), lib);
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                finally {
                    gil.acquire();
                }
            }
            if (lib.isBoolean(key)) {
                gil.release(true);
                try {
                    this.removeForeignValue(object, lib.asBoolean(key) ? 1 : 0, lib);
                    PNone e = PNone.NONE;
                    return e;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                finally {
                    gil.acquire();
                }
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, object, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"lib.hasHashEntries(object)"})
        Object doHashKey(Object object, Object key, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
            if (lib.isHashEntryRemovable(object, key)) {
                gil.release(true);
                try {
                    lib.removeHashEntry(object, key);
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                catch (UnknownKeyException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                catch (UnsupportedMessageException e) {
                    PException pException = this.raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_REMOVABLE, key, object);
                    return pException;
                }
                finally {
                    gil.acquire();
                }
            }
            throw AccessForeignItemNodes.keyError(this, key, lib, switchEncodingNode);
        }

        @Fallback
        Object doFail(Object object, Object key) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_DOESNT_SUPPORT_DELETION, object);
        }

        private void removeForeignValue(Object object, int idx, InteropLibrary libForObject) {
            if (libForObject.isArrayElementRemovable(object, (long)idx)) {
                try {
                    libForObject.removeArrayElement(object, (long)idx);
                    return;
                }
                catch (InvalidArrayIndexException ex) {
                    throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, idx);
                }
                catch (UnsupportedMessageException e) {
                    throw this.raise(PythonErrorType.IndexError, ErrorMessages.ITEM_S_OF_S_OBJ_IS_NOT_REMOVABLE, idx, object);
                }
            }
            throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, idx);
        }

        public static RemoveForeignItemNode create() {
            return AccessForeignItemNodesFactory.RemoveForeignItemNodeGen.create();
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    protected static abstract class SetForeignItemNode
    extends AccessForeignItemBaseNode {
        protected SetForeignItemNode() {
        }

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"lib.hasArrayElements(object)"})
        public Object doArraySlice(VirtualFrame frame, Object object, PSlice idxSlice, Object pvalues, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNext, @Cached.Exclusive @Cached InlinedBranchProfile wrongIndex, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached.Shared(value="gil") @Cached GilNode gil) {
            PSlice.SliceInfo mslice = this.materializeSlice(frame, sliceCast.execute(inliningTarget, idxSlice), object, compute, lib);
            Object iter = getIter.execute((Frame)frame, inliningTarget, pvalues);
            for (int i = mslice.start; i < mslice.stop; i += mslice.step) {
                Object value = getNext.execute((Frame)frame, iter);
                gil.release(true);
                try {
                    this.writeForeignIndex(inliningTarget, object, i, value, lib, wrongIndex);
                    continue;
                }
                finally {
                    gil.acquire();
                }
            }
            return PNone.NONE;
        }

        @Specialization(guards={"lib.hasArrayElements(object)", "!isPSlice(key)"})
        Object doArrayIndex(Object object, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached IndexNodes.NormalizeIndexNode normalize, @Cached.Exclusive @Cached InlinedBranchProfile wrongIndex, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached.Shared(value="gil") @Cached GilNode gil) {
            if (lib.isNumber(key) && lib.fitsInInt(key)) {
                gil.release(true);
                try {
                    this.writeForeignIndex(inliningTarget, object, normalize.execute(lib.asInt(key), (int)lib.getArraySize(object)), value, lib, wrongIndex);
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                finally {
                    gil.acquire();
                }
            }
            if (lib.isBoolean(key)) {
                gil.release(true);
                try {
                    this.writeForeignIndex(inliningTarget, object, lib.asBoolean(key) ? 1 : 0, value, lib, wrongIndex);
                    PNone e = PNone.NONE;
                    return e;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                finally {
                    gil.acquire();
                }
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, object, key);
        }

        @Specialization(guards={"lib.hasHashEntries(object)"})
        Object doHashKey(Object object, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile wrongIndex, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
            if (lib.isHashEntryWritable(object, key)) {
                gil.release(true);
                try {
                    lib.writeHashEntry(object, key, value);
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                catch (UnknownKeyException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                catch (UnsupportedMessageException e) {
                    if (lib.isHashEntryExisting(object, key)) {
                        PException pException = this.raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_WRITABLE, key, object);
                        return pException;
                    }
                    PException pException = this.raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_OBJ_IS_NOT_INSERTABLE, key, object);
                    return pException;
                }
                catch (UnsupportedTypeException e) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TYPE_P_NOT_SUPPORTED_BY_FOREIGN_OBJ, value);
                }
                catch (Throwable e) {
                    throw e;
                }
                finally {
                    gil.acquire();
                }
            }
            wrongIndex.enter(inliningTarget);
            gil.release(true);
            try {
                throw AccessForeignItemNodes.keyError(this, key, lib, switchEncodingNode);
            }
            catch (Throwable throwable) {
                gil.acquire();
                throw throwable;
            }
        }

        @Fallback
        Object doFail(Object object, Object key, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, object);
        }

        private void writeForeignIndex(Node inliningTarget, Object object, int idx, Object value, InteropLibrary libForObject, InlinedBranchProfile wrongIndex) {
            if (libForObject.isArrayElementWritable(object, (long)idx)) {
                try {
                    libForObject.writeArrayElement(object, (long)idx, value);
                    return;
                }
                catch (InvalidArrayIndexException e) {
                    throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, idx);
                }
                catch (UnsupportedMessageException e) {
                    throw this.raise(PythonErrorType.IndexError, ErrorMessages.ITEM_S_OF_S_OBJ_IS_NOT_WRITABLE, idx, object);
                }
                catch (UnsupportedTypeException e) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TYPE_P_NOT_SUPPORTED_BY_FOREIGN_OBJ, value);
                }
            }
            wrongIndex.enter(inliningTarget);
            throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, idx);
        }

        public static SetForeignItemNode create() {
            return AccessForeignItemNodesFactory.SetForeignItemNodeGen.create();
        }
    }

    protected static abstract class GetForeignItemNode
    extends AccessForeignItemBaseNode {
        @Node.Child
        private PForeignToPTypeNode toPythonNode;

        protected GetForeignItemNode() {
        }

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"lib.hasArrayElements(object)"})
        Object doArraySlice(VirtualFrame frame, Object object, PSlice idxSlice, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached PythonObjectFactory factory, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached RangeNodes.LenOfRangeNode sliceLen, @Cached.Shared(value="gil") @Cached GilNode gil) {
            PSlice.SliceInfo mslice = this.materializeSlice(frame, sliceCast.execute(inliningTarget, idxSlice), object, compute, lib);
            gil.release(true);
            try {
                Object[] values = new Object[sliceLen.len(inliningTarget, mslice)];
                int i = mslice.start;
                int j = 0;
                while (i < mslice.stop) {
                    values[j] = this.readForeignIndex(object, i, lib);
                    i += mslice.step;
                    ++j;
                }
                PList pList = factory.createList(values);
                return pList;
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"lib.hasArrayElements(object)", "!isPSlice(key)"})
        Object doArrayIndex(Object object, Object key, @Cached IndexNodes.NormalizeIndexNode normalize, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached.Shared(value="gil") @Cached GilNode gil) {
            if (lib.isNumber(key) && lib.fitsInLong(key)) {
                gil.release(true);
                try {
                    Object object2 = this.readForeignIndex(object, normalize.executeLong(lib.asLong(key), lib.getArraySize(object)), lib);
                    return object2;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                finally {
                    gil.acquire();
                }
            }
            if (lib.isBoolean(key)) {
                gil.release(true);
                try {
                    Object e = this.readForeignIndex(object, lib.asBoolean(key) ? 1L : 0L, lib);
                    return e;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                finally {
                    gil.acquire();
                }
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, object, key);
        }

        @Specialization(guards={"lib.isString(object)", "!lib.hasArrayElements(object)"})
        Object doString(VirtualFrame frame, Object object, Object idx, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached StringBuiltins.StrGetItemNode getItemNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
            TruffleString string;
            gil.release(true);
            try {
                string = switchEncodingNode.execute((AbstractTruffleString)lib.asTruffleString(object), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
            return getItemNode.execute(frame, string, idx);
        }

        @Specialization(guards={"lib.hasHashEntries(object)"})
        Object doHashKey(Object object, Object key, @Cached.Shared(value="lib") @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary lib, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
            if (lib.isHashEntryReadable(object, key)) {
                gil.release(true);
                try {
                    Object object2 = this.getToPythonNode().executeConvert(lib.readHashValue(object, key));
                    return object2;
                }
                catch (UnknownKeyException | UnsupportedMessageException e) {
                    throw AccessForeignItemNodes.keyError(this, key, lib, switchEncodingNode);
                }
                finally {
                    gil.acquire();
                }
            }
            throw AccessForeignItemNodes.keyError(this, key, lib, switchEncodingNode);
        }

        @Fallback
        Object doFail(Object object, Object key) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, object);
        }

        public Object readForeignIndex(Object object, long index, InteropLibrary libForObject) {
            if (libForObject.isArrayElementReadable(object, index)) {
                try {
                    return this.getToPythonNode().executeConvert(libForObject.readArrayElement(object, index));
                }
                catch (UnsupportedMessageException ex) {
                    throw this.raise(PythonErrorType.IndexError, ErrorMessages.ITEM_S_OF_S_OBJ_IS_NOT_READABLE, index, object);
                }
                catch (InvalidArrayIndexException ex) {
                    throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, index);
                }
            }
            throw this.raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX_S, index);
        }

        private PForeignToPTypeNode getToPythonNode() {
            if (this.toPythonNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toPythonNode = (PForeignToPTypeNode)this.insert(PForeignToPTypeNode.create());
            }
            return this.toPythonNode;
        }
    }
}

