/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyDictSetDefault;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDict, PythonBuiltinClassType.PDefaultDict})
public final class DictBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DictBuiltinsSlotsGen.SLOTS;

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialMethodNames.T___HASH__, (Object)PNone.NONE);
    }

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__ior__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IOrNode
    extends PythonBinaryBuiltinNode {
        IOrNode() {
        }

        @Specialization
        PDict or(VirtualFrame frame, PDict self, Object other, @Cached DictNodes.UpdateNode updateNode) {
            updateNode.execute((Frame)frame, self, other);
            return self;
        }
    }

    @Builtins(value={@Builtin(name="__or__", minNumOfPositionalArgs=2), @Builtin(name="__ror__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        OrNode() {
        }

        @Specialization
        static PDict or(VirtualFrame frame, PDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached DictNodes.UpdateNode updateNode, @Cached PythonObjectFactory factory) {
            PDict merged = factory.createDict(copyNode.execute(inliningTarget, self.getDictStorage()));
            updateNode.execute((Frame)frame, merged, other);
            return merged;
        }

        @Fallback
        static Object or(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="fromkeys", minNumOfPositionalArgs=2, parameterNames={"$cls", "iterable", "value"}, isClassmethod=true)
    @ImportStatic(value={SpecialMethodSlot.class})
    @GenerateNodeFactory
    public static abstract class FromKeysNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"isBuiltinDict(inliningTarget, cls, isSameTypeNode)"}, limit="1")
        static Object doKeys(VirtualFrame frame, Object cls, Object iterable, Object value, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode, @Cached PythonObjectFactory factory) {
            HashingStorage s = getHashingStorageNode.execute(frame, inliningTarget, iterable, value);
            return factory.createDict(cls, s);
        }

        @Fallback
        static Object doKeys(VirtualFrame frame, Object cls, Object iterable, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached CallNode callCtor, @Cached GetClassNode getClassNode, @Cached(parameters={"SetItem"}) LookupSpecialMethodSlotNode lookupSetItem, @Cached CallTernaryMethodNode callSetItem, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PRaiseNode.Lazy raiseNode) {
            Object dict = callCtor.execute((Frame)frame, cls, new Object[0]);
            Object val = value == PNone.NO_VALUE ? PNone.NONE : value;
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            Object setitemMethod = lookupSetItem.execute((Frame)frame, getClassNode.execute(inliningTarget, dict), dict);
            if (setitemMethod != PNone.NO_VALUE) {
                try {
                    while (true) {
                        Object key = nextNode.execute((Frame)frame, it);
                        callSetItem.execute((Frame)frame, setitemMethod, dict, key, val);
                    }
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    return dict;
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.P_OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, iterable);
        }

        protected static boolean isBuiltinDict(Node inliningTarget, Object cls, TypeNodes.IsSameTypeNode isSameTypeNode) {
            return isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PDict, cls);
        }
    }

    @Builtin(name="update", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class UpdateNode
    extends PythonBuiltinNode {
        @Specialization(guards={"args.length == 0", "kwargs.length == 0"})
        static Object updateEmpy(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 1", "kwargs.length == 0"})
        static Object update(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs, @Cached.Shared(value="updateNode") @Cached DictNodes.UpdateNode updateNode) {
            updateNode.execute((Frame)frame, self, args[0]);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 0", "kwargs.length > 0"})
        static Object update(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="initNode") @Cached HashingStorage.InitNode initNode, @Cached.Shared(value="addAllToOther") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            UpdateNode.updateKwargs(frame, inliningTarget, self, kwargs, initNode, addAllToOtherNode);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 1", "kwargs.length > 0"})
        static Object update(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="updateNode") @Cached DictNodes.UpdateNode updateNode, @Cached.Shared(value="initNode") @Cached HashingStorage.InitNode initNode, @Cached.Shared(value="addAllToOther") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            updateNode.execute((Frame)frame, self, args[0]);
            UpdateNode.updateKwargs(frame, inliningTarget, self, kwargs, initNode, addAllToOtherNode);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length > 1"})
        static Object error(PDict self, Object[] args, PKeyword[] kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_AT_MOST_D_ARGS_GOT_D, "update", 1, args.length);
        }

        private static void updateKwargs(VirtualFrame frame, Node inliningTarget, PDict self, PKeyword[] kwargs, HashingStorage.InitNode initNode, HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            addAllToOtherNode.execute((Frame)frame, inliningTarget, initNode.execute(frame, PNone.NO_VALUE, kwargs), self);
        }
    }

    @Builtin(name="values", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ValuesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDictView values(PDict self, @Cached PythonObjectFactory factory) {
            return factory.createDictValuesView(self);
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone clear(PDict dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageClear clearNode) {
            HashingStorage newStorage = clearNode.execute(inliningTarget, dict.getDictStorage());
            dict.setDictStorage(newStorage);
            return PNone.NONE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDict copy(VirtualFrame frame, PDict dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached PythonObjectFactory factory) {
            return factory.createDict(copyNode.execute(inliningTarget, dict.getDictStorage()));
        }
    }

    @Slot(value=Slot.SlotKind.mp_length)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        static int len(PDict self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, self.getDictStorage());
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static boolean run(VirtualFrame frame, PDict self, Object key, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return getItem.hasKey((Frame)frame, inliningTarget, self.getDictStorage(), key);
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doDictDict(VirtualFrame frame, PDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageEq eqNode) {
            return eqNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage());
        }

        @Fallback
        static PNotImplemented doGeneric(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object run(PDict self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIterator, @Cached PythonObjectFactory factory) {
            HashingStorage storage = self.getDictStorage();
            return factory.createDictKeyIterator(getReverseIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object run(PDict self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached PythonObjectFactory factory) {
            HashingStorage dictStorage = self.getDictStorage();
            return factory.createDictKeyIterator(getIterator.execute(inliningTarget, dictStorage), dictStorage, lenNode.execute(inliningTarget, dictStorage));
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DelItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object run(VirtualFrame frame, PDict self, Object key, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached PRaiseNode.Lazy raiseNode) {
            Object found = delItem.executePop((Frame)frame, inliningTarget, self.getDictStorage(), key, self);
            if (found != null) {
                return PNone.NONE;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, new Object[]{key});
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetItemNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object run(VirtualFrame frame, PDict self, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.SetItemNode setItemNode) {
            setItemNode.execute((Frame)frame, inliningTarget, self, key, value);
            return PNone.NONE;
        }
    }

    @ImportStatic(value={SpecialMethodSlot.class})
    @GenerateInline(value=false)
    protected static abstract class DispatchMissingNode
    extends Node {
        protected DispatchMissingNode() {
        }

        protected abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        static Object missing(VirtualFrame frame, Object self, Object key, @Bind(value="this") Node inliningTarget, @Cached(value="create(Missing)") LookupAndCallBinaryNode callMissing, @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callMissing.executeObject(frame, self, key);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, new Object[]{key});
            }
            return result;
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Node.Child
        private DispatchMissingNode missing;

        @Specialization
        Object getItem(VirtualFrame frame, PDict self, Object key, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile notFoundProfile, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode raiseNode) {
            Object result = getItem.execute((Frame)frame, inliningTarget, self.getDictStorage(), key);
            if (notFoundProfile.profile(inliningTarget, result == null)) {
                return this.handleMissing(frame, self, key, raiseNode);
            }
            return result;
        }

        @HostCompilerDirectives.InliningCutoff
        private Object handleMissing(VirtualFrame frame, PDict self, Object key, PRaiseNode raiseNode) {
            if (!PGuards.isBuiltinDict(self)) {
                if (this.missing == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.missing = (DispatchMissingNode)this.insert(DictBuiltinsFactory.DispatchMissingNodeGen.create());
                }
                return this.missing.execute(frame, self, key);
            }
            throw raiseNode.raise(PythonErrorType.KeyError, new Object[]{key});
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object doWithDefault(VirtualFrame frame, PDict self, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            Object value = getItem.execute((Frame)frame, inliningTarget, self.getDictStorage(), key);
            return value != null ? value : (defaultValue == PNone.NO_VALUE ? PNone.NONE : defaultValue);
        }
    }

    @Builtin(name="items", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ItemsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDictView items(PDict self, @Cached PythonObjectFactory factory) {
            return factory.createDictItemsView(self);
        }
    }

    @Builtin(name="keys", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class KeysNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PDictView keys(PDict self, @Cached PythonObjectFactory factory) {
            return factory.createDictKeysView(self);
        }
    }

    @Builtin(name="popitem", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class PopItemNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object popItem(PDict dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStoragePop popNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object[] result = popNode.execute(inliningTarget, dict.getDictStorage(), dict);
            if (result == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, ErrorMessages.IS_EMPTY, "popitem(): dictionary");
            }
            return factory.createTuple(result);
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class PopNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object popDefault(VirtualFrame frame, PDict dict, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasKeyProfile, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached PRaiseNode.Lazy raiseNode) {
            Object retVal = delItem.executePop((Frame)frame, inliningTarget, dict.getDictStorage(), key, dict);
            if (hasKeyProfile.profile(inliningTarget, retVal != null)) {
                return retVal;
            }
            if (PGuards.isNoValue(defaultValue)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, new Object[]{key});
            }
            return defaultValue;
        }
    }

    @Builtin(name="setdefault", minNumOfPositionalArgs=2, parameterNames={"self", "key", "default"})
    @ArgumentClinic(name="default", defaultValue="PNone.NONE")
    @GenerateNodeFactory
    static abstract class SetDefaultNode
    extends PythonTernaryClinicBuiltinNode {
        SetDefaultNode() {
        }

        @Specialization
        Object doIt(VirtualFrame frame, PDict dict, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached PyDictSetDefault setDefault) {
            return setDefault.execute((Frame)frame, inliningTarget, dict, key, defaultValue);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DictBuiltinsClinicProviders.SetDefaultNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private HashingStorage.InitNode initNode;

        private HashingStorage.InitNode getInitNode() {
            if (this.initNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initNode = (HashingStorage.InitNode)this.insert(HashingStorage.InitNode.create());
            }
            return this.initNode;
        }

        @Specialization(guards={"args.length == 1"})
        Object doVarargs(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="addAllToOther") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            addAllToOtherNode.execute((Frame)frame, inliningTarget, this.getInitNode().execute(frame, args[0], kwargs), self);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 0", "kwargs.length > 0"})
        Object doKeywords(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="addAllToOther") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            addAllToOtherNode.execute((Frame)frame, inliningTarget, this.getInitNode().execute(frame, PNone.NO_VALUE, kwargs), self);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 0", "kwargs.length == 0"})
        static Object doEmpty(PDict self, Object[] args, PKeyword[] kwargs) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length > 1"})
        Object doGeneric(PDict self, Object[] args, PKeyword[] kwargs) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_AT_MOST_D_ARGS_GOT_D, "dict", 1, args.length);
        }
    }
}

