/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodesFactory;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyByteArrayCheckNode;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyOSFSPathNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class BytesNodes {
    public static int adjustStartIndex(int startIn, int len) {
        if (startIn < 0) {
            int start = startIn + len;
            return start < 0 ? 0 : start;
        }
        return startIn;
    }

    public static int adjustEndIndex(int endIn, int len) {
        if (endIn > len) {
            return len;
        }
        if (endIn < 0) {
            int end = endIn + len;
            return end < 0 ? 0 : end;
        }
        return endIn;
    }

    static boolean compareByteArrays(ComparisonOp op, byte[] selfArray, int selfLength, byte[] otherArray, int otherLength) {
        int compareResult = 0;
        if ((op == ComparisonOp.EQ || op == ComparisonOp.NE) && selfLength != otherLength) {
            return op == ComparisonOp.NE;
        }
        for (int i = 0; i < Math.min(selfLength, otherLength) && (compareResult = Byte.compareUnsigned(selfArray[i], otherArray[i])) == 0; ++i) {
        }
        if (compareResult == 0) {
            compareResult = Integer.compare(selfLength, otherLength);
        }
        return op.cmpResultToBool(compareResult);
    }

    @GenerateUncached
    public static abstract class BytesLikeNoGeneralizationNode
    extends SequenceStorageNodes.NoGeneralizationNode {
        public static final SequenceStorageNodes.GenNodeSupplier SUPPLIER = new SequenceStorageNodes.GenNodeSupplier(){

            @Override
            public SequenceStorageNodes.GeneralizationNode create() {
                return BytesNodesFactory.BytesLikeNoGeneralizationNodeGen.create();
            }

            @Override
            public SequenceStorageNodes.GeneralizationNode getUncached() {
                return BytesNodesFactory.BytesLikeNoGeneralizationNodeGen.getUncached();
            }
        };

        @Override
        protected final TruffleString getErrorMessage() {
            return ErrorMessages.BYTE_MUST_BE_IN_RANGE;
        }
    }

    @GenerateCached(value=false)
    public static abstract class BaseTranslateNode
    extends PythonBuiltinNode {
        static void checkLengthOfTable(Node inliningTarget, byte[] table, InlinedConditionProfile isLenTable256Profile, PRaiseNode.Lazy raiseNode) {
            if (isLenTable256Profile.profile(inliningTarget, table.length != 256)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.TRANS_TABLE_MUST_BE_256);
            }
        }

        protected static boolean[] createDeleteTable(byte[] delete) {
            boolean[] result = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                result[i] = false;
            }
            for (byte b : delete) {
                result[b & 0xFF] = true;
            }
            return result;
        }

        protected static Result delete(byte[] self, byte[] table) {
            int length = self.length;
            byte[] result = new byte[length];
            int resultLen = 0;
            boolean[] toDelete = BaseTranslateNode.createDeleteTable(table);
            for (byte b : self) {
                if (toDelete[b & 0xFF]) continue;
                result[resultLen] = b;
                ++resultLen;
            }
            if (resultLen == length) {
                return new Result(result, false);
            }
            return new Result(Arrays.copyOf(result, resultLen), true);
        }

        protected static Result translate(byte[] self, byte[] table) {
            int length = self.length;
            byte[] result = new byte[length];
            boolean changed = false;
            for (int i = 0; i < length; ++i) {
                int idx = self[i] & 0xFF;
                byte b = table[idx];
                if (!changed && b != self[i]) {
                    changed = true;
                }
                result[i] = b;
            }
            return new Result(result, changed);
        }

        protected static Result translateAndDelete(byte[] self, byte[] table, byte[] delete) {
            int length = self.length;
            byte[] result = new byte[length];
            int resultLen = 0;
            boolean changed = false;
            boolean[] toDelete = BaseTranslateNode.createDeleteTable(delete);
            for (byte value : self) {
                int idx = value & 0xFF;
                if (toDelete[idx]) continue;
                byte b = table[idx];
                if (!changed && b != value) {
                    changed = true;
                }
                result[resultLen] = b;
                ++resultLen;
            }
            if (resultLen == length) {
                return new Result(result, changed);
            }
            return new Result(Arrays.copyOf(result, resultLen), true);
        }

        protected static class Result {
            byte[] array;
            boolean changed;

            public Result(byte[] array, boolean changed) {
                this.array = array;
                this.changed = changed;
            }
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class GetNativeBytesStorage
    extends Node {
        public abstract NativeByteSequenceStorage execute(PythonAbstractNativeObject var1);

        @Specialization
        NativeByteSequenceStorage getNative(PythonAbstractNativeObject bytes, @Cached CStructAccess.GetElementPtrNode getContents, @Cached CStructAccess.ReadI64Node readI64Node) {
            assert (PyBytesCheckNode.executeUncached(bytes) || PyByteArrayCheckNode.executeUncached(bytes));
            Object array = getContents.getElementPtr(bytes.getPtr(), CFields.PyBytesObject__ob_sval);
            int size = (int)readI64Node.readFromObj(bytes, CFields.PyVarObject__ob_size);
            return NativeByteSequenceStorage.create(array, size, size, false);
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class GetBytesStorage
    extends Node {
        public abstract SequenceStorage execute(Node var1, Object var2);

        @Specialization
        SequenceStorage getManaged(PBytesLike bytes) {
            return bytes.getSequenceStorage();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        SequenceStorage getNative(PythonAbstractNativeObject bytes, @Cached(inline=false) GetNativeBytesStorage getNativeTupleStorage) {
            return getNativeTupleStorage.execute(bytes);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class HexStringToBytesNode
    extends Node {
        public abstract byte[] execute(TruffleString var1);

        @Specialization(guards={"isAscii(str, getCodeRangeNode)"})
        static byte[] ascii(TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString ascii = switchEncodingNode.execute((AbstractTruffleString)str, TruffleString.Encoding.US_ASCII);
            InternalByteArray iba = getInternalByteArrayNode.execute((AbstractTruffleString)ascii, TruffleString.Encoding.US_ASCII);
            byte[] bytes = new byte[iba.getLength() / 2];
            byte[] strchar = iba.getArray();
            int n = 0;
            for (int i = iba.getOffset(); i < iba.getEnd(); ++i) {
                byte c = strchar[i];
                if (BytesUtils.isSpace(c)) continue;
                int top = BytesUtils.digitValue(c);
                if (top >= 16 || top < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NON_HEX_NUMBER_IN_FROMHEX, i);
                }
                c = i + 1 < iba.getEnd() ? strchar[++i] : (byte)0;
                int bottom = BytesUtils.digitValue(c);
                if (bottom >= 16 || bottom < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NON_HEX_NUMBER_IN_FROMHEX, i);
                }
                bytes[n++] = (byte)(top << 4 | bottom);
            }
            if (n != bytes.length) {
                bytes = PythonUtils.arrayCopyOf(bytes, n);
            }
            return bytes;
        }

        @Specialization(guards={"!isAscii(str, getCodeRangeNode)"})
        static byte[] nonAscii(TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
            int i = 0;
            while (it.hasNext()) {
                if (nextNode.execute(it) > 127) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NON_HEX_NUMBER_IN_FROMHEX, i);
                }
                ++i;
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HashBufferNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, Object var2);

        @Specialization(guards={"bufferLib.hasInternalByteArray(buffer)"}, limit="2")
        static long hashDirect(Object buffer, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib) {
            PythonBufferAccessLibrary.assertIsBuffer(buffer);
            int len = bufferLib.getBufferLength(buffer);
            byte[] array = bufferLib.getInternalByteArray(buffer);
            return HashBufferNode.computeHash(len, array);
        }

        @CompilerDirectives.TruffleBoundary
        private static int computeHash(int len, byte[] array) {
            int result = 1;
            for (int i = 0; i < len; ++i) {
                result = 31 * result + array[i];
            }
            return result;
        }

        @Specialization(guards={"!bufferLib.hasInternalByteArray(buffer)"}, limit="2")
        static long hashIndirect(Object buffer, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib) {
            PythonBufferAccessLibrary.assertIsBuffer(buffer);
            int len = bufferLib.getBufferLength(buffer);
            int result = 1;
            for (int i = 0; i < len; ++i) {
                result = 31 * result + bufferLib.readByte(buffer, i);
            }
            return result;
        }
    }

    @GenerateInline(value=false)
    public static abstract class DecodeUTF8FSPathNode
    extends Node {
        public abstract TruffleString execute(VirtualFrame var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString doit(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached CastToTruffleStringNode toString, @Cached PyOSFSPathNode fsPath, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            Object path = fsPath.execute((Frame)frame, inliningTarget, value);
            if (bufferAcquireLib.hasBuffer(path)) {
                Object buffer = bufferAcquireLib.acquireReadonly(path, frame, indirectCallData);
                try {
                    TruffleString utf8 = fromByteArrayNode.execute(bufferLib.getCopiedByteArray(path), TruffleString.Encoding.UTF_8, false);
                    TruffleString truffleString = switchEncodingNode.execute((AbstractTruffleString)utf8, PythonUtils.TS_ENCODING);
                    return truffleString;
                }
                finally {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
            }
            return toString.execute(inliningTarget, path);
        }
    }

    public static abstract class IterableToByteNode
    extends Node {
        public abstract byte[] execute(VirtualFrame var1, Object var2);

        @Specialization
        static byte[] bytearray(VirtualFrame frame, Object iterable, @Bind(value="this") Node inliningTarget, @Cached IteratorNodes.GetLength lenghtHintNode, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached CastToByteNode castToByteNode, @Cached PyObjectGetIter getIter) {
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            int len = lenghtHintNode.execute(frame, inliningTarget, iterable);
            byte[] arr = new byte[len < 16 && len > 0 ? len : 16];
            int i = 0;
            try {
                while (true) {
                    byte item = castToByteNode.execute(frame, getNextNode.execute((Frame)frame, it));
                    if (i >= arr.length) {
                        arr = IterableToByteNode.resize(arr, arr.length * 2);
                    }
                    arr[i++] = item;
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, stopIterationProfile);
                return IterableToByteNode.resize(arr, i);
            }
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private static byte[] resize(byte[] arr, int len) {
            return Arrays.copyOf(arr, len);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ByteToHexNode
    extends PNodeWithContext {
        public abstract TruffleString execute(Node var1, byte[] var2, int var3, byte var4, int var5);

        @Specialization(guards={"bytesPerSepGroup == 0"})
        static TruffleString zero(byte[] argbuf, int arglen, byte sep, int bytesPerSepGroup, @Cached.Shared @Cached(inline=false) TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode) {
            int resultlen = arglen * 2;
            byte[] retbuf = new byte[resultlen];
            int j = 0;
            for (int i = 0; i < arglen; ++i) {
                assert (j + 1 < resultlen);
                int c = argbuf[i] & 0xFF;
                retbuf[j++] = BytesUtils.HEXDIGITS[c >>> 4];
                retbuf[j++] = BytesUtils.HEXDIGITS[c & 0xF];
            }
            return BytesUtils.createASCIIString(retbuf, fromByteArrayNode, switchEncodingNode);
        }

        @Specialization(guards={"bytesPerSepGroup < 0"})
        static TruffleString negative(Node inliningTarget, byte[] argbuf, int arglen, byte sep, int bytesPerSepGroup, @Cached.Shared @Cached InlinedConditionProfile earlyExit, @Cached.Shared @Cached(inline=false) TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (earlyExit.profile(inliningTarget, arglen == 0)) {
                return StringLiterals.T_EMPTY_STRING;
            }
            int absBytesPerSepGroup = -bytesPerSepGroup;
            int resultlen = (arglen - 1) / absBytesPerSepGroup;
            if (arglen >= 0x3FFFFFFF - resultlen) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.MemoryError);
            }
            resultlen += arglen * 2;
            if (absBytesPerSepGroup >= arglen) {
                return ByteToHexNode.zero(argbuf, arglen, sep, 0, fromByteArrayNode, switchEncodingNode);
            }
            byte[] retbuf = new byte[resultlen];
            int chunks = (arglen - 1) / absBytesPerSepGroup;
            int i = 0;
            int j = 0;
            for (int chunk = 0; chunk < chunks; ++chunk) {
                for (int k = 0; k < absBytesPerSepGroup; ++k) {
                    int c = argbuf[i++] & 0xFF;
                    retbuf[j++] = BytesUtils.HEXDIGITS[c >>> 4];
                    retbuf[j++] = BytesUtils.HEXDIGITS[c & 0xF];
                }
                retbuf[j++] = sep;
            }
            while (i < arglen) {
                int c = argbuf[i++] & 0xFF;
                retbuf[j++] = BytesUtils.HEXDIGITS[c >>> 4];
                retbuf[j++] = BytesUtils.HEXDIGITS[c & 0xF];
            }
            return BytesUtils.createASCIIString(retbuf, fromByteArrayNode, switchEncodingNode);
        }

        @Specialization(guards={"absBytesPerSepGroup > 0"})
        static TruffleString positive(Node inliningTarget, byte[] argbuf, int arglen, byte sep, int absBytesPerSepGroup, @Cached.Shared @Cached InlinedConditionProfile earlyExit, @Cached.Shared @Cached(inline=false) TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (earlyExit.profile(inliningTarget, arglen == 0)) {
                return StringLiterals.T_EMPTY_STRING;
            }
            int resultlen = (arglen - 1) / absBytesPerSepGroup;
            if (arglen >= 0x3FFFFFFF - resultlen) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.MemoryError);
            }
            resultlen += arglen * 2;
            if (absBytesPerSepGroup >= arglen) {
                return ByteToHexNode.zero(argbuf, arglen, sep, 0, fromByteArrayNode, switchEncodingNode);
            }
            byte[] retbuf = new byte[resultlen];
            int chunks = (arglen - 1) / absBytesPerSepGroup;
            int i = arglen - 1;
            int j = resultlen - 1;
            for (int chunk = 0; chunk < chunks; ++chunk) {
                for (int k = 0; k < absBytesPerSepGroup; ++k) {
                    int c = argbuf[i--] & 0xFF;
                    retbuf[j--] = BytesUtils.HEXDIGITS[c & 0xF];
                    retbuf[j--] = BytesUtils.HEXDIGITS[c >>> 4];
                }
                retbuf[j--] = sep;
            }
            while (i >= 0) {
                int c = argbuf[i--] & 0xFF;
                retbuf[j--] = BytesUtils.HEXDIGITS[c & 0xF];
                retbuf[j--] = BytesUtils.HEXDIGITS[c >>> 4];
            }
            return BytesUtils.createASCIIString(retbuf, fromByteArrayNode, switchEncodingNode);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class BytesInitNode
    extends PNodeWithContext {
        public abstract byte[] execute(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5);

        @Specialization
        static byte[] none(PNone source, PNone encoding, PNone errors) {
            return PythonUtils.EMPTY_BYTE_ARRAY;
        }

        @Specialization(guards={"isByteStorage(source)"})
        static byte[] byteslike(PBytesLike source, PNone encoding, PNone errors) {
            return (byte[])((ByteSequenceStorage)source.getSequenceStorage()).getCopyOfInternalArrayObject();
        }

        @Specialization(guards={"!isString(source)", "!isNoValue(source)"})
        static byte[] fromObject(VirtualFrame frame, Node inliningTarget, Object source, PNone encoding, PNone errors, @Cached PyIndexCheckNode indexCheckNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyNumberAsSizeNode asSizeNode, @Cached(inline=false) BytesFromObject bytesFromObject, @Cached @Cached.Exclusive PRaiseNode.Lazy raiseNode) {
            if (indexCheckNode.execute(inliningTarget, source)) {
                try {
                    int size = asSizeNode.executeExact((Frame)frame, inliningTarget, source);
                    if (size < 0) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_COUNT);
                    }
                    try {
                        return new byte[size];
                    }
                    catch (OutOfMemoryError error) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.MemoryError);
                    }
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonErrorType.TypeError, errorProfile);
                }
            }
            return bytesFromObject.execute(frame, source);
        }

        @Specialization(guards={"isString(source)", "isString(encoding)"})
        static byte[] fromString(Node inliningTarget, Object source, Object encoding, PNone errors, @Cached @Cached.Shared CastToTruffleStringNode castStr, @Cached(inline=false) @Cached.Shared CodecsModuleBuiltins.CodecsEncodeToJavaBytesNode encodeNode) {
            return encodeNode.execute(source, castStr.execute(inliningTarget, encoding), StringLiterals.T_STRICT);
        }

        @Specialization(guards={"isString(source)", "isString(encoding)", "isString(errors)"})
        static byte[] fromString(Node inliningTarget, Object source, Object encoding, Object errors, @Cached @Cached.Shared CastToTruffleStringNode castStr, @Cached(inline=false) @Cached.Shared CodecsModuleBuiltins.CodecsEncodeToJavaBytesNode encodeNode) {
            return encodeNode.execute(source, castStr.execute(inliningTarget, encoding), castStr.execute(inliningTarget, errors));
        }

        @Specialization(guards={"isString(source)"})
        static byte[] fromString(Node inliningTarget, Object source, PNone encoding, Object errors, @Cached @Cached.Shared PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.STRING_ARG_WO_ENCODING);
        }

        @Fallback
        public static byte[] error(Node inliningTarget, Object source, Object encoding, Object errors, @Cached @Cached.Shared PRaiseNode.Lazy raiseNode) {
            if (PGuards.isNone(encoding)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ENCODING_ARG_WO_STRING);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ERRORS_WITHOUT_STR_ARG);
        }
    }

    @GenerateInline(value=false)
    public static abstract class BytesFromObject
    extends Node {
        public abstract byte[] execute(VirtualFrame var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static byte[] doGeneric(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached IterableToByteNode iterableToByteNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PRaiseNode.Lazy raiseNode) {
            if (bufferAcquireLib.hasBuffer(object)) {
                Object buffer = bufferAcquireLib.acquire(object, 8, frame, indirectCallData);
                try {
                    byte[] byArray = bufferLib.getCopiedByteArray(buffer);
                    return byArray;
                }
                finally {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
            }
            if (!PGuards.isString(object)) {
                try {
                    return iterableToByteNode.execute(frame, object);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonErrorType.TypeError, errorProfile);
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CONVERT_P_OBJ_TO_S, object, "bytes");
        }
    }

    public static abstract class ExpectStringNode
    extends ArgumentCastNode {
        private final int argNum;
        private final String className;

        protected ExpectStringNode(int argNum, String className) {
            this.argNum = argNum;
            this.className = className;
        }

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNoValue(none)"})
        static Object none(PNone none) {
            return none;
        }

        @Specialization
        static Object str(TruffleString str) {
            return str;
        }

        @Specialization
        static Object str(PString str, @Bind(value="this") Node inliningTarget, @Cached StringNodes.StringMaterializeNode toStr) {
            return toStr.execute(inliningTarget, str);
        }

        @Fallback
        Object doOthers(VirtualFrame frame, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, new Object[]{this.className, this.argNum, PythonBuiltinClassType.PString, value});
        }

        @ClinicConverterFactory
        @NeverDefault
        public static ExpectStringNode create(@ClinicConverterFactory.ArgumentIndex int argNum, String className) {
            return BytesNodesFactory.ExpectStringNodeGen.create(argNum, className);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CmpNode
    extends PNodeWithContext {
        public abstract int execute(VirtualFrame var1, Node var2, PBytesLike var3, PBytesLike var4);

        @Specialization
        static int cmp(PBytesLike left, PBytesLike right, @Cached(inline=false) SequenceStorageNodes.GetItemNode getLeftItemNode, @Cached(inline=false) SequenceStorageNodes.GetItemNode getRightItemNode) {
            int llen = left.getSequenceStorage().length();
            int rlen = right.getSequenceStorage().length();
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                int b;
                int a = getLeftItemNode.executeKnownInt(left.getSequenceStorage(), i);
                if (a == (b = getRightItemNode.executeKnownInt(right.getSequenceStorage(), i))) continue;
                return (a & 0xFF) - (b & 0xFF);
            }
            return llen - rlen;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class BytesLikeCheck
    extends PNodeWithContext {
        public abstract boolean execute(Node var1, Object var2);

        @Specialization
        static boolean check(PBytesLike obj) {
            return true;
        }

        @Specialization(guards={"!isPBytes(obj)"})
        static boolean check(Node inliningTarget, PythonAbstractNativeObject obj, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode) {
            Object type = getClassNode.execute(inliningTarget, obj);
            return isSubtypeNode.execute(null, type, (Object)PythonBuiltinClassType.PBytes) || isSubtypeNode.execute(null, type, (Object)PythonBuiltinClassType.PByteArray);
        }

        @Fallback
        static boolean check(Object obj) {
            return false;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FindNode
    extends PNodeWithContext {
        public abstract int execute(VirtualFrame var1, Node var2, Object var3, Object var4, int var5, int var6, boolean var7);

        public final int execute(VirtualFrame frame, Node inliningTarget, Object self, Object needle, int start, int end) {
            return this.execute(frame, inliningTarget, self, needle, start, end, false);
        }

        public final int executeReverse(VirtualFrame frame, Node inliningTarget, Object self, Object needle, int start, int end) {
            return this.execute(frame, inliningTarget, self, needle, start, end, true);
        }

        @Specialization
        static int find(VirtualFrame frame, Node inliningTarget, Object self, Object needle, int start, int end, boolean reverse, @Cached NeedleToBytesNode needleToBytesNode, @Cached GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getInternalArray) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            int len = storage.length();
            return FindNode.find(getInternalArray.execute(inliningTarget, storage), storage.length(), needleToBytesNode.execute(frame, inliningTarget, needle), BytesNodes.adjustStartIndex(start, len), BytesNodes.adjustEndIndex(end, len), reverse);
        }

        public static int find(byte[] haystack, int len1, byte needle, int start, int end, boolean reverse) {
            if (start >= len1) {
                return -1;
            }
            return FindNode.findElement(haystack, needle, start, end, reverse);
        }

        public static int find(byte[] haystack, int len1, byte[] needle, int start, int end, boolean reverse) {
            int len2 = needle.length;
            if (len2 == 0 && start <= len1) {
                if (!reverse) {
                    return start;
                }
                return end;
            }
            if (start >= len1 || len1 < len2) {
                return -1;
            }
            if (len2 == 1) {
                return FindNode.findElement(haystack, needle[0], start, end, reverse);
            }
            return FindNode.findSubSequence(haystack, needle, len2, start, end, reverse);
        }

        private static int isEqual(int i, byte[] haystack, byte[] needle, int len2) {
            for (int j = 0; j < len2; ++j) {
                if (haystack[i + j] == needle[j]) continue;
                return -1;
            }
            return i;
        }

        private static int findSubSequence(byte[] haystack, byte[] needle, int len2, int start, int end, boolean reverse) {
            if (!reverse) {
                return FindNode.findSubSequenceForward(haystack, needle, len2, start, end);
            }
            return FindNode.findSubSequenceReverse(haystack, needle, len2, start, end);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static int findSubSequenceForward(byte[] haystack, byte[] needle, int len2, int start, int end) {
            for (int i = start; i < end - len2 + 1; ++i) {
                if (FindNode.isEqual(i, haystack, needle, len2) == -1) continue;
                return i;
            }
            return -1;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static int findSubSequenceReverse(byte[] haystack, byte[] needle, int len2, int start, int end) {
            for (int i = end - len2; i >= start; --i) {
                if (FindNode.isEqual(i, haystack, needle, len2) == -1) continue;
                return i;
            }
            return -1;
        }

        private static int findElement(byte[] haystack, byte sub, int start, int end, boolean reverse) {
            if (!reverse) {
                return FindNode.findElementForward(haystack, sub, start, end);
            }
            return FindNode.findElementReverse(haystack, sub, start, end);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static int findElementForward(byte[] haystack, byte sub, int start, int end) {
            for (int i = start; i < end; ++i) {
                if (haystack[i] != sub) continue;
                return i;
            }
            return -1;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static int findElementReverse(byte[] haystack, byte sub, int start, int end) {
            for (int i = end - 1; i >= start; --i) {
                if (haystack[i] != sub) continue;
                return i;
            }
            return -1;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NeedleToBytesNode
    extends PNodeWithContext {
        public abstract byte[] execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization(guards={"indexCheck.execute(inliningTarget, needle)"})
        static byte[] number(VirtualFrame frame, Node inliningTarget, Object needle, @Cached.Shared @Cached PyIndexCheckNode indexCheck, @Cached(inline=false) CastToByteNode castToByteNode) {
            return new byte[]{castToByteNode.execute(frame, needle)};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!indexCheck.execute(inliningTarget, needle)"}, limit="3")
        static byte[] bytesLike(Node inliningTarget, Object needle, @Cached.Shared @Cached PyIndexCheckNode indexCheck, @CachedLibrary(value="needle") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            Object buffer = acquireLib.acquireReadonly(needle);
            try {
                byte[] byArray = bufferLib.getCopiedByteArray(buffer);
                return byArray;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToBytesWithoutFrameNode
    extends Node {
        public abstract byte[] execute(Node var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static byte[] doBuffer(Node inliningTarget, Object object, @CachedLibrary(value="object") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer;
            try {
                buffer = bufferAcquireLib.acquireReadonly(object);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_BYTESLIKE_GOT_P, object);
            }
            try {
                byte[] byArray = bufferLib.getCopiedByteArray(buffer);
                return byArray;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }

    @ImportStatic(value={PGuards.class, SpecialMethodNames.class})
    public static abstract class ToBytesNode
    extends Node {
        private final PythonBuiltinClassType errorType;
        private final TruffleString errorMessageFormat;

        ToBytesNode(PythonBuiltinClassType errorType, TruffleString errorMessageFormat) {
            this.errorType = errorType;
            this.errorMessageFormat = errorMessageFormat;
        }

        public final byte[] execute(PBytesLike obj) {
            return this.execute(null, obj);
        }

        public abstract byte[] execute(VirtualFrame var1, Object var2);

        @Specialization(limit="2")
        byte[] doBytes(PBytesLike bytes, @CachedLibrary(value="bytes") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.getCopiedByteArray(bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        byte[] doBuffer(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="object") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer;
            try {
                buffer = bufferAcquireLib.acquireReadonly(object, frame, indirectCallData);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(this.errorType, this.errorMessageFormat, object);
            }
            try {
                byte[] byArray = bufferLib.getCopiedByteArray(buffer);
                return byArray;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @NeverDefault
        public static ToBytesNode create() {
            return BytesNodesFactory.ToBytesNodeGen.create(PythonErrorType.TypeError, ErrorMessages.EXPECTED_BYTESLIKE_GOT_P);
        }

        public static ToBytesNode create(PythonBuiltinClassType errorType, TruffleString errorMessageFormat) {
            return BytesNodesFactory.ToBytesNodeGen.create(errorType, errorMessageFormat);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class})
    public static abstract class BytesJoinNode
    extends PNodeWithContext {
        public abstract byte[] execute(VirtualFrame var1, Node var2, byte[] var3, Object var4);

        @Specialization
        static byte[] join(VirtualFrame frame, Node inliningTarget, byte[] sep, Object iterable, @Cached PyObjectGetIter getIter, @Cached(inline=false) GetNextNode getNextNode, @Cached(inline=false) ToBytesNode toBytesNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            ArrayList<byte[]> parts = new ArrayList<byte[]>();
            int partsTotalSize = 0;
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            try {
                while (true) {
                    partsTotalSize += BytesJoinNode.append(parts, toBytesNode.execute(frame, getNextNode.execute((Frame)frame, iterator)));
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return BytesJoinNode.joinArrays(sep, parts, partsTotalSize);
            }
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static int append(ArrayList<byte[]> parts, byte[] barr) {
            parts.add(barr);
            return barr.length;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static byte[] joinArrays(byte[] sep, ArrayList<byte[]> parts, int partsTotalSize) {
            byte[] joinedBytes = new byte[Math.max(0, partsTotalSize + (parts.size() - 1) * sep.length)];
            if (parts.size() > 0) {
                int offset = 0;
                byte[] array = parts.get(0);
                PythonUtils.arraycopy(array, 0, joinedBytes, offset, array.length);
                offset += array.length;
                for (int i = 1; i < parts.size(); ++i) {
                    array = parts.get(i);
                    PythonUtils.arraycopy(sep, 0, joinedBytes, offset, sep.length);
                    PythonUtils.arraycopy(array, 0, joinedBytes, offset += sep.length, array.length);
                    offset += array.length;
                }
            }
            return joinedBytes;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CreateBytesNode
    extends Node {
        public final PBytesLike execute(Node inliningTarget, PythonObjectFactory factory, Object basedOn, byte[] bytes) {
            return this.execute(inliningTarget, factory, basedOn, new ByteSequenceStorage(bytes));
        }

        public abstract PBytesLike execute(Node var1, PythonObjectFactory var2, Object var3, SequenceStorage var4);

        @Specialization
        static PBytesLike bytes(PythonObjectFactory factory, PBytes basedOn, SequenceStorage bytes) {
            return factory.createBytes(bytes);
        }

        @Specialization
        static PBytesLike bytearray(PythonObjectFactory factory, PByteArray basedOn, SequenceStorage bytes) {
            return factory.createByteArray(bytes);
        }

        @Specialization(guards={"checkBytes.execute(inliningTarget, basedOn)"})
        static PBytesLike bytes(Node inliningTarget, PythonObjectFactory factory, Object basedOn, SequenceStorage bytes, @Cached.Shared @Cached PyBytesCheckNode checkBytes) {
            return factory.createBytes(bytes);
        }

        @Specialization(guards={"!checkBytes.execute(inliningTarget, basedOn)"})
        static PBytesLike bytearray(Node inliningTarget, PythonObjectFactory factory, Object basedOn, SequenceStorage bytes, @Cached.Shared @Cached PyBytesCheckNode checkBytes) {
            assert (PyByteArrayCheckNode.executeUncached(basedOn));
            return factory.createByteArray(bytes);
        }
    }
}

