/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.pickle.ByteArrayView;
import com.oracle.graal.python.builtins.modules.pickle.MemoTable;
import com.oracle.graal.python.builtins.modules.pickle.PPickleBuffer;
import com.oracle.graal.python.builtins.modules.pickle.PPicklerFactory;
import com.oracle.graal.python.builtins.modules.pickle.PickleState;
import com.oracle.graal.python.builtins.modules.pickle.PickleUtils;
import com.oracle.graal.python.builtins.modules.pickle.PicklerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.ints.IntNodesFactory;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.Consumer;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.graalvm.collections.Pair;

public class PPickler
extends PythonBuiltinObject {
    private MemoTable memo;
    private Object persFunc = null;
    private Object persFuncSelf;
    private Object dispatchTable = null;
    private Object reducerOverride = null;
    private Object write = null;
    private byte[] outputBuffer;
    private int outputLen = 0;
    private int maxOutputLen = 4096;
    private int proto = 0;
    private int bin = 0;
    private boolean framing = false;
    private int frameStart = -1;
    private int fast = 0;
    private int fastNesting = 0;
    private boolean fixImports = false;
    private final Map<Object, Object> fastMemo = PPickler.createFastMemoTable();
    private Object bufferCallback = null;

    public PPickler(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
        this.memo = new MemoTable();
        this.outputBuffer = new byte[this.maxOutputLen];
    }

    @CompilerDirectives.TruffleBoundary
    private static Map<Object, Object> createFastMemoTable() {
        return Collections.synchronizedMap(new WeakHashMap());
    }

    public int getProto() {
        return this.proto;
    }

    public int getBin() {
        return this.bin;
    }

    public void setBin(int bin) {
        this.bin = bin;
    }

    public boolean isBin() {
        return this.bin != 0;
    }

    public int getFast() {
        return this.fast;
    }

    public void setFast(int fast) {
        this.fast = fast;
    }

    public boolean isFast() {
        return this.fast != 0;
    }

    public boolean isFraming() {
        return this.framing;
    }

    public Object getWrite() {
        return this.write;
    }

    public Object getDispatchTable() {
        return this.dispatchTable;
    }

    public void setDispatchTable(Object dispatchTable) {
        this.dispatchTable = dispatchTable;
    }

    public MemoTable getMemo() {
        return this.memo;
    }

    public void setMemo(MemoTable memo) {
        this.memo = memo;
    }

    public Object getPersFunc() {
        return this.persFunc;
    }

    public void setPersFunc(Object persFunc) {
        this.persFunc = persFunc;
    }

    public Object getPersFuncSelf() {
        return this.persFuncSelf;
    }

    public void setPersFuncSelf(Object persFuncSelf) {
        this.persFuncSelf = persFuncSelf;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean fastMemoContains(Object object) {
        return this.fastMemo.containsKey(object);
    }

    @CompilerDirectives.TruffleBoundary
    private void fastMemoPut(Object object) {
        this.fastMemo.put(object, true);
    }

    @CompilerDirectives.TruffleBoundary
    private void fastMemoRemove(Object object) {
        this.fastMemo.remove(object);
    }

    public void setProtocol(Node inliningTarget, PRaiseNode.Lazy raiseNode, int protocol, boolean fixImports) {
        this.proto = protocol;
        if (this.proto < 0) {
            this.proto = 5;
        } else if (this.proto > 5) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.PICKLE_PROTO_MUST_BE_LE, 5);
        }
        this.bin = this.proto > 0 ? 1 : 0;
        this.fixImports = fixImports && this.proto < 3;
    }

    public void setOutputStream(VirtualFrame frame, Node inliningTarget, PRaiseNode.Lazy raiseNode, PyObjectLookupAttr lookup, Object file) {
        this.write = lookup.execute((Frame)frame, inliningTarget, file, PickleUtils.T_METHOD_WRITE);
        if (this.write == PNone.NO_VALUE) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.FILE_MUST_HAVE_WRITE_ATTR);
        }
    }

    public void setBufferCallback(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object callback) {
        this.bufferCallback = callback;
        if (PGuards.isNone(callback) || PGuards.isNoValue(callback)) {
            this.bufferCallback = null;
        }
        if (this.bufferCallback != null && this.proto < 5) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BUFFCB_NEEDS_PROTO_GE_5);
        }
    }

    public void initInternals(VirtualFrame frame, Node inliningTarget, PyObjectLookupAttr lookup) {
        if (this.memo == null) {
            this.memo = new MemoTable();
        }
        this.outputLen = 0;
        if (this.outputBuffer == null) {
            this.maxOutputLen = 4096;
            this.outputBuffer = new byte[this.maxOutputLen];
        }
        this.fast = 0;
        this.fastNesting = 0;
        Pair<Object, Object> pair = PickleUtils.initMethodRef(frame, inliningTarget, lookup, this, PickleUtils.T_METHOD_PERSISTENT_ID);
        this.persFunc = pair.getLeft();
        this.persFuncSelf = pair.getRight();
        this.dispatchTable = lookup.execute((Frame)frame, inliningTarget, this, PickleUtils.T_ATTR_DISPATCH_TABLE);
        if (this.dispatchTable == PNone.NO_VALUE) {
            this.dispatchTable = null;
        }
    }

    public void clearMemo() {
        this.memo.clear();
    }

    public void clearBuffer() {
        this.outputBuffer = new byte[this.maxOutputLen];
        this.outputLen = 0;
        this.frameStart = -1;
    }

    public void commitFrame() {
        if (!this.isFraming() || this.frameStart == -1) {
            return;
        }
        int frameLen = this.outputLen - this.frameStart - 9;
        ByteArrayView qdata = new ByteArrayView(this.outputBuffer, this.frameStart);
        if (frameLen >= 4) {
            qdata.put(0, (byte)-107);
            qdata.add(1);
            qdata.writeSize64(frameLen);
        } else {
            qdata.memmove(9, frameLen);
            this.outputLen -= 9;
        }
        this.frameStart = -1;
    }

    public PBytes getString(PythonObjectFactory factory) {
        this.commitFrame();
        return factory.createBytes(this.outputBuffer, this.outputLen);
    }

    public static abstract class DumpNode
    extends BasePickleWriteNode {
        public abstract void execute(VirtualFrame var1, PPickler var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public void dump(VirtualFrame frame, PPickler pickler, Object obj, @Cached SaveNode saveNode) {
            try {
                Object tmp = this.getLookupAttrNode().executeCached((Frame)frame, pickler, REDUCE_OVERRIDE);
                pickler.reducerOverride = tmp != PNone.NO_VALUE ? tmp : null;
                if (pickler.proto >= 2) {
                    assert (pickler.proto <= 256);
                    byte[] header = new byte[]{-128, (byte)pickler.proto};
                    try {
                        this.write(pickler, header, 2);
                    }
                    catch (Exception e) {
                        DumpNode.handleError(pickler);
                        throw e;
                    }
                    if (pickler.proto >= 4) {
                        pickler.framing = true;
                    }
                }
                saveNode.execute(frame, pickler, obj, 0);
                this.write(pickler, (byte)46);
                pickler.commitFrame();
            }
            finally {
                pickler.framing = false;
            }
        }
    }

    public static abstract class SaveNode
    extends BasePickleWriteNode {
        @Node.Child
        private SaveNode recursiveSaveNode;
        @Node.Child
        private PyLongAsLongNode pyLongAsLongNode;
        @Node.Child
        private PyObjectStrAsObjectNode pyObjectStrAsObjectNode;
        @Node.Child
        private PyObjectIsTrueNode isTrueNode;
        @Node.Child
        private IsNode isNode;
        @Node.Child
        private PythonBufferAcquireLibrary bufferAcquireLibrary;
        @Node.Child
        private PythonBufferAccessLibrary bufferLibrary;
        @Node.Child
        private PyCallableCheckNode callableCheckNode;
        @Node.Child
        private PyObjectReprAsTruffleStringNode reprNode;
        @Node.Child
        private PyObjectGetIter getIterNode;
        @Node.Child
        private HashingStorageNodes.HashingStorageLen hashingStorageLenNode;

        private int getHashingStorageLength(HashingStorage storage) {
            if (this.hashingStorageLenNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashingStorageLenNode = (HashingStorageNodes.HashingStorageLen)this.insert(HashingStorageNodes.HashingStorageLen.create());
            }
            return this.hashingStorageLenNode.executeCached(storage);
        }

        private void save(VirtualFrame frame, PPickler pickler, Object obj, int persSave) {
            if (this.recursiveSaveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.recursiveSaveNode = (SaveNode)this.insert(PPicklerFactory.SaveNodeGen.create());
            }
            this.recursiveSaveNode.execute(frame, pickler, obj, persSave);
        }

        private long asLong(VirtualFrame frame, Object object) {
            if (this.pyLongAsLongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyLongAsLongNode = (PyLongAsLongNode)this.insert(PyLongAsLongNode.create());
            }
            return this.pyLongAsLongNode.executeCached((Frame)frame, object);
        }

        private Object convertToStr(VirtualFrame frame, Object object) {
            if (this.pyObjectStrAsObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyObjectStrAsObjectNode = (PyObjectStrAsObjectNode)this.insert(PyObjectStrAsObjectNode.create());
            }
            return this.pyObjectStrAsObjectNode.executeCached((Frame)frame, object);
        }

        private boolean isTrue(VirtualFrame frame, Object object) {
            if (this.isTrueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTrueNode = (PyObjectIsTrueNode)this.insert(PyObjectIsTrueNode.create());
            }
            return this.isTrueNode.executeCached((Frame)frame, object);
        }

        private boolean isSame(Object a, Object b) {
            if (this.isNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isNode = (IsNode)this.insert(IsNode.create());
            }
            return this.isNode.execute(a, b);
        }

        private boolean isCallable(Object object) {
            if (this.callableCheckNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callableCheckNode = (PyCallableCheckNode)this.insert(PyCallableCheckNode.create());
            }
            return this.callableCheckNode.execute(object);
        }

        private TruffleString repr(VirtualFrame frame, Object object) {
            if (this.reprNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reprNode = (PyObjectReprAsTruffleStringNode)this.insert(PyObjectReprAsTruffleStringNode.create());
            }
            return this.reprNode.executeCached((Frame)frame, object);
        }

        private Object getIter(VirtualFrame frame, Object object) {
            if (this.getIterNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getIterNode = (PyObjectGetIter)this.insert(PyObjectGetIter.create());
            }
            return this.getIterNode.executeCached((Frame)frame, object);
        }

        private PythonBufferAcquireLibrary getBufferAcquireLibrary() {
            if (this.bufferAcquireLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferAcquireLibrary = (PythonBufferAcquireLibrary)this.insert((Node)((PythonBufferAcquireLibrary)PythonBufferAcquireLibrary.getFactory().createDispatched(3)));
            }
            return this.bufferAcquireLibrary;
        }

        private PythonBufferAccessLibrary getBufferLibrary() {
            if (this.bufferLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferLibrary = (PythonBufferAccessLibrary)this.insert((Node)((PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().createDispatched(3)));
            }
            return this.bufferLibrary;
        }

        public abstract void execute(VirtualFrame var1, PPickler var2, Object var3, int var4);

        private void saveHashingStorageBatched(VirtualFrame frame, PPickler pickler, HashingStorage storage, byte opcodeBatch, TruffleString name, boolean saveValues) {
            int i;
            int initialSize = this.getHashingStorageLength(storage);
            HashingStorageNodes.HashingStorageIterator it = this.getHashingStorageIterator(storage);
            HashingStorageNodes.HashingStorageIteratorNext nextNode = this.ensureHashingStorageIteratorNext();
            HashingStorageNodes.HashingStorageIteratorKey getKeyNode = this.ensureHashingStorageIteratorKey();
            HashingStorageNodes.HashingStorageIteratorValue getValueNode = null;
            if (saveValues) {
                getValueNode = this.ensureHashingStorageIteratorValue();
            }
            do {
                i = 0;
                this.write(pickler, (byte)40);
                while (nextNode.executeCached(storage, it)) {
                    this.save(frame, pickler, getKeyNode.executeCached(storage, it), 0);
                    if (saveValues) {
                        this.save(frame, pickler, getValueNode.executeCached(storage, it), 0);
                    }
                    if (++i != 1000) continue;
                }
                this.write(pickler, opcodeBatch);
                if (this.getHashingStorageLength(storage) == initialSize) continue;
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CHANGED_SIZE_DURING_ITERATION, name);
            } while (i == 1000);
        }

        private void saveDictHashingStorageBatched(VirtualFrame frame, PPickler pickler, HashingStorage storage) {
            this.saveHashingStorageBatched(frame, pickler, storage, (byte)117, T_DICTIONARY, true);
        }

        private void saveSetHashingStorageBatched(VirtualFrame frame, PPickler pickler, HashingStorage storage) {
            this.saveHashingStorageBatched(frame, pickler, storage, (byte)-112, T_SET, false);
        }

        private void saveSetHashingStorage(VirtualFrame frame, PPickler pickler, HashingStorage storage) {
            HashingStorageNodes.HashingStorageIterator it = this.getHashingStorageIterator(storage);
            HashingStorageNodes.HashingStorageIteratorNext next = this.ensureHashingStorageIteratorNext();
            HashingStorageNodes.HashingStorageIteratorKey getKeyNode = this.ensureHashingStorageIteratorKey();
            while (next.executeCached(storage, it)) {
                Object item = getKeyNode.executeCached(storage, it);
                this.save(frame, pickler, item, 0);
            }
        }

        private void saveIteratorBatchedUnrolled(VirtualFrame frame, PPickler pickler, Object iterator, byte opcodeOneItem, byte opcodeMultipleItems, Consumer<Object> checkItem, Consumer<Object> saveItem) {
            Object firstItem;
            while ((firstItem = this.getNextItem(frame, iterator)) != null) {
                checkItem.accept(firstItem);
                Object obj = this.getNextItem(frame, iterator);
                if (obj == null) {
                    saveItem.accept(firstItem);
                    this.write(pickler, opcodeOneItem);
                    break;
                }
                this.write(pickler, (byte)40);
                saveItem.accept(firstItem);
                int n = 1;
                do {
                    checkItem.accept(obj);
                    saveItem.accept(obj);
                } while (++n != 1000 && (obj = this.getNextItem(frame, iterator)) != null);
                this.write(pickler, opcodeMultipleItems);
                if (n == 1000) continue;
            }
        }

        private void saveDictIteratorBatchUnrolled(VirtualFrame frame, PPickler pickler, Object iterator) {
            this.saveIteratorBatchedUnrolled(frame, pickler, iterator, (byte)115, (byte)117, item -> {
                if (!(item instanceof PTuple) || this.length(frame, item) != 2) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.MUST_S_ITER_RETURN_2TUPLE, DICT_ITEMS);
                }
            }, item -> {
                this.save(frame, pickler, this.getItem(frame, item, (Object)0), 0);
                this.save(frame, pickler, this.getItem(frame, item, (Object)1), 0);
            });
        }

        private void saveListIteratorBatchUnrolled(VirtualFrame frame, PPickler pickler, Object iterator) {
            this.saveIteratorBatchedUnrolled(frame, pickler, iterator, (byte)97, (byte)101, item -> {}, item -> this.save(frame, pickler, item, 0));
        }

        private void saveIterator(VirtualFrame frame, PPickler pickler, Object iterator, byte opcode, Consumer<Object> itemConsumer) {
            Object item;
            while ((item = this.getNextItem(frame, iterator)) != null) {
                itemConsumer.accept(item);
                if (opcode == 0) continue;
                this.write(pickler, opcode);
            }
        }

        private void saveListIterator(VirtualFrame frame, PPickler pickler, Object iterator) {
            this.saveIterator(frame, pickler, iterator, (byte)97, item -> this.save(frame, pickler, item, 0));
        }

        private void saveFrozenSetIterator(VirtualFrame frame, PPickler pickler, Object iterator) {
            this.saveIterator(frame, pickler, iterator, (byte)0, item -> this.save(frame, pickler, item, 0));
        }

        private void saveDictIterator(VirtualFrame frame, PPickler pickler, Object iterator) {
            this.saveIterator(frame, pickler, iterator, (byte)115, item -> {
                if (!(item instanceof PTuple) || this.length(frame, item) != 2) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.MUST_S_ITER_RETURN_2TUPLE, DICT_ITEMS);
                }
                this.save(frame, pickler, this.getItem(frame, item, (Object)0), 0);
                this.save(frame, pickler, this.getItem(frame, item, (Object)1), 0);
            });
        }

        private boolean savePers(VirtualFrame frame, PPickler pickler, Object obj) {
            Object pid = pickler.persFuncSelf == null ? this.getCallNode().execute((Frame)frame, pickler.persFunc, obj) : this.getCallNode().execute((Frame)frame, pickler.persFunc, pickler.persFuncSelf, obj);
            if (pid != PNone.NONE) {
                if (pickler.isBin()) {
                    this.save(frame, pickler, pid, 1);
                    this.write(pickler, (byte)81);
                } else {
                    TruffleString pidStr = this.asString(this.convertToStr(frame, pid));
                    if (!PythonUtils.isAscii(pidStr, this.ensureTsGetCodeRangeNode())) {
                        throw this.raise(PythonBuiltinClassType.PicklingError, ErrorMessages.PIDS_MUST_BE_ASCII_STRS);
                    }
                    this.write(pickler, (byte)80);
                    this.writeASCII(pickler, pidStr);
                    this.writeASCII(pickler, StringLiterals.T_NEWLINE);
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void memoGet(PPickler pickler, int value) {
            int len;
            byte[] pdata;
            if (pickler.isBin()) {
                pdata = new byte[5];
                if (value < 256) {
                    pdata[0] = 104;
                    pdata[1] = (byte)(value & 0xFF);
                    len = 2;
                } else {
                    if (Long.compareUnsigned(value, 0xFFFFFFFFL) > 0) throw this.raise(PythonErrorType.PicklingError, ErrorMessages.MEMO_ID_TOO_LARGE_FOR_S, "LONG_BINGET");
                    pdata[0] = 106;
                    pdata[1] = (byte)(value & 0xFF);
                    pdata[2] = (byte)(value >> 8 & 0xFF);
                    pdata[3] = (byte)(value >> 16 & 0xFF);
                    pdata[4] = (byte)(value >> 24 & 0xFF);
                    len = 5;
                }
            } else {
                pdata = new byte[30];
                pdata[0] = 103;
                len = PickleUtils.toAsciiBytesWithNewLine(pdata, 1, value, this.ensureTsFromLongNode(), this.ensureTsCopyToByteArrayNode());
            }
            this.write(pickler, pdata, len);
        }

        private void memoPut(PPickler pickler, Object obj) {
            int len;
            byte[] pdata;
            if (pickler.isFast()) {
                return;
            }
            int idx = pickler.memo.size();
            pickler.memo.set(obj, idx);
            if (pickler.proto >= 4) {
                this.write(pickler, (byte)-108);
                return;
            }
            if (!pickler.isBin()) {
                pdata = new byte[30];
                pdata[0] = 112;
                len = PickleUtils.toAsciiBytesWithNewLine(pdata, 1, idx, this.ensureTsFromLongNode(), this.ensureTsCopyToByteArrayNode());
            } else {
                pdata = new byte[5];
                if (idx < 256) {
                    pdata[0] = 113;
                    pdata[1] = (byte)idx;
                    len = 2;
                } else if (Long.compareUnsigned(idx, 0xFFFFFFFFL) <= 0) {
                    pdata[0] = 114;
                    pdata[1] = (byte)(idx & 0xFF);
                    pdata[2] = (byte)(idx >> 8 & 0xFF);
                    pdata[3] = (byte)(idx >> 16 & 0xFF);
                    pdata[4] = (byte)(idx >> 24 & 0xFF);
                    len = 5;
                } else {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.MEMO_ID_TOO_LARGE_FOR_S, "LONG_BINPUT");
                }
            }
            this.write(pickler, pdata, len);
        }

        private void handleReduce(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj, Object reduceValue) {
            if (PGuards.isString(reduceValue)) {
                this.saveGlobal(frame, ctx, pickler, obj, reduceValue);
                return;
            }
            if (!(reduceValue instanceof PTuple)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_MUST_RETURN_S_OR_S, SpecialMethodNames.T___REDUCE__, "string", "tuple");
            }
            this.saveReduce(frame, ctx, pickler, reduceValue, obj);
        }

        private void saveReduce(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object arguments, Object obj) {
            TruffleString stringName;
            Object name;
            boolean useNewobj = false;
            boolean useNewobjEx = false;
            if (!(arguments instanceof PTuple)) {
                throw this.getRaiseNode().raiseBadInternalCall();
            }
            int size = this.length(frame, arguments);
            if (size < 2 || size > 6) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.TUPLE_RET_BY_REDUCE_2_6);
            }
            Object callable = this.getItem(frame, arguments, (Object)0);
            Object argtup = this.getItem(frame, arguments, (Object)1);
            Object state = this.getItem(frame, arguments, size, 2, null);
            Object listitems = this.getItem(frame, arguments, size, 3, PNone.NONE);
            Object dictitems = this.getItem(frame, arguments, size, 4, PNone.NONE);
            Object stateSetter = this.getItem(frame, arguments, size, 5, PNone.NONE);
            if (!this.isCallable(callable)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ITEM_REDUCE_MUST_BE_S, "first", "callable");
            }
            if (!(argtup instanceof PTuple)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ITEM_REDUCE_MUST_BE_S, "second", "a tuple");
            }
            if (state == PNone.NONE) {
                state = null;
            }
            if (listitems == PNone.NONE) {
                listitems = null;
            } else if (!this.isIterator(listitems)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ELEM_REDUCE_MUST_BE_S_NOT_P, "fourth", "an iterator", listitems);
            }
            if (dictitems == PNone.NONE) {
                dictitems = null;
            } else if (!this.isIterator(dictitems)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ELEM_REDUCE_MUST_BE_S_NOT_P, "fifth", "an iterator", dictitems);
            }
            if (stateSetter == PNone.NONE) {
                stateSetter = null;
            } else if (!this.isCallable(stateSetter)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ELEM_REDUCE_MUST_BE_S_NOT_P, "sixth", "a function", stateSetter);
            }
            if (pickler.proto >= 2 && (name = this.lookupAttribute((Frame)frame, callable, SpecialAttributeNames.T___NAME__)) != PNone.NO_VALUE && (stringName = this.asString(name)) != null && !(useNewobjEx = this.ensureTsEqualNode().execute((AbstractTruffleString)stringName, (AbstractTruffleString)SpecialAttributeNames.T___NEWOBJ_EX__, PythonUtils.TS_ENCODING))) {
                useNewobj = this.ensureTsEqualNode().execute((AbstractTruffleString)stringName, (AbstractTruffleString)SpecialAttributeNames.T___NEWOBJ__, PythonUtils.TS_ENCODING);
            }
            int argtupSize = this.length(frame, argtup);
            if (useNewobjEx) {
                if (argtupSize != 3) {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.LEN_OF_S_MUST_BE_D_NOT_D, "NEWOBJ_EX", 3, argtupSize);
                }
                cls = this.getItem(frame, argtup, (Object)0);
                if (!this.isType(cls)) {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ITEM_FROM_S_MUST_BE_S_NOT_P, "first", "NEWOBJ_EX", "a class", cls);
                }
                Object args = this.getItem(frame, argtup, (Object)1);
                if (!(args instanceof PTuple)) {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ITEM_FROM_S_MUST_BE_S_NOT_P, "second", "NEWOBJ_EX", "a tuple", args);
                }
                Object kwargs = this.getItem(frame, argtup, (Object)2);
                if (!(kwargs instanceof PDict)) {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.S_ITEM_FROM_S_MUST_BE_S_NOT_P, "third", "NEWOBJ_EX", "a dict", kwargs);
                }
                if (pickler.proto >= 4) {
                    this.save(frame, pickler, cls, 0);
                    this.save(frame, pickler, args, 0);
                    this.save(frame, pickler, kwargs, 0);
                    this.write(pickler, (byte)-110);
                } else {
                    Object clsNew;
                    PickleState st = this.getGlobalState(ctx.getCore());
                    int argsSize = this.length(frame, args);
                    Object[] newargs = new Object[argsSize + 2];
                    newargs[0] = clsNew = this.lookupAttributeStrict((Frame)frame, cls, SpecialMethodNames.T___NEW__);
                    newargs[1] = cls;
                    for (int i = 0; i < argsSize; ++i) {
                        Object item;
                        newargs[i + 2] = item = this.getItem(frame, args, (Object)i);
                    }
                    callable = this.callStarArgsAndKwArgs(frame, st.partial, newargs, kwargs);
                    this.save(frame, pickler, callable, 0);
                    this.save(frame, pickler, this.factory().createEmptyTuple(), 0);
                    this.write(pickler, (byte)82);
                }
            } else if (useNewobj) {
                if (argtupSize < 1) {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.IS_EMPTY, "__newobj__ arglist");
                }
                cls = this.getItem(frame, argtup, (Object)0);
                if (!this.isType(cls)) {
                    throw this.raise(PythonErrorType.PicklingError, ErrorMessages.ARGS_0_FROM_S_ARGS_S, "__newobj__", "is not a type");
                }
                if (obj != null) {
                    boolean p;
                    Object objClass = this.getClass((Frame)frame, obj);
                    boolean bl = p = objClass != cls;
                    if (p) {
                        throw this.raise(PythonErrorType.PicklingError, ErrorMessages.ARGS_0_FROM_S_ARGS_S, "__newobj__", "has the wrong class");
                    }
                }
                this.save(frame, pickler, cls, 0);
                Object newargtup = this.getItem(frame, argtup, this.factory().createIntSlice(1, argtupSize, 1));
                this.save(frame, pickler, newargtup, 0);
                this.write(pickler, (byte)-127);
            } else {
                this.save(frame, pickler, callable, 0);
                this.save(frame, pickler, argtup, 0);
                this.write(pickler, (byte)82);
            }
            if (obj != null) {
                int memoIndex = pickler.memo.get(obj);
                if (memoIndex != -1) {
                    this.write(pickler, (byte)48);
                    this.memoGet(pickler, memoIndex);
                } else {
                    this.memoPut(pickler, obj);
                }
            }
            if (listitems != null) {
                this.batchList(frame, pickler, listitems);
            }
            if (dictitems != null) {
                this.batchDict(frame, pickler, dictitems);
            }
            if (state != null) {
                if (stateSetter == null) {
                    this.save(frame, pickler, state, 0);
                    this.write(pickler, (byte)98);
                } else {
                    this.save(frame, pickler, stateSetter, 0);
                    this.save(frame, pickler, obj, 0);
                    this.save(frame, pickler, state, 0);
                    this.write(pickler, (byte)-122);
                    this.write(pickler, (byte)82);
                    this.write(pickler, (byte)48);
                }
            }
        }

        private void saveNone(PPickler pickler, Object obj) {
            this.write(pickler, (byte)78);
        }

        private void saveBool(VirtualFrame frame, PPickler pickler, Object obj) {
            if (pickler.proto >= 2) {
                this.write(pickler, this.isTrue(frame, obj) ? (byte)-120 : -119);
            } else {
                this.writeASCII(pickler, this.isTrue(frame, obj) ? PickleUtils.T_PROTO_LE2_TRUE : PickleUtils.T_PROTO_LE2_FALSE);
            }
        }

        private void saveLong(VirtualFrame frame, PPickler pickler, Object obj) {
            try {
                long value = this.asLong(frame, obj);
                if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                    int len;
                    byte[] pdata;
                    if (pickler.isBin()) {
                        pdata = new byte[5];
                        pdata[1] = (byte)(value & 0xFFL);
                        pdata[2] = (byte)(value >> 8 & 0xFFL);
                        pdata[3] = (byte)(value >> 16 & 0xFFL);
                        pdata[4] = (byte)(value >> 24 & 0xFFL);
                        if (pdata[4] != 0 || pdata[3] != 0) {
                            pdata[0] = 74;
                            len = 5;
                        } else if (pdata[2] != 0) {
                            pdata[0] = 77;
                            len = 3;
                        } else {
                            pdata[0] = 75;
                            len = 2;
                        }
                    } else {
                        pdata = new byte[32];
                        pdata[0] = 73;
                        len = PickleUtils.toAsciiBytesWithNewLine(pdata, 1, value, this.ensureTsFromLongNode(), this.ensureTsCopyToByteArrayNode());
                    }
                    this.write(pickler, pdata, len);
                    return;
                }
            }
            catch (PException e) {
                e.expectCached(PythonErrorType.OverflowError, this.ensureErrProfile());
            }
            if (pickler.proto >= 2) {
                int size;
                int nbits;
                int nbytes;
                byte[] header = new byte[5];
                int sign = this.getSign(obj);
                if (sign == 0) {
                    header[0] = -118;
                    header[1] = 0;
                    this.write(pickler, header, 2);
                }
                if (Long.compareUnsigned(nbytes = ((nbits = this.getNumBits(obj)) >> 3) + 1, Integer.MAX_VALUE) > 0) {
                    throw this.raise(PythonErrorType.OverflowError, ErrorMessages.S_TO_LARGE_TO_PICKLE, "int");
                }
                byte[] pdata = this.longAsBytes(obj, nbytes, false);
                if (sign < 0 && nbytes > 1 && pdata[nbytes - 1] == -1 && (pdata[nbytes - 2] & 0x80) != 0) {
                    --nbytes;
                }
                if (nbytes < 256) {
                    header[0] = -118;
                    header[1] = (byte)nbytes;
                    size = 2;
                } else {
                    header[0] = -117;
                    size = nbytes;
                    for (int i = 1; i < 5; ++i) {
                        header[i] = (byte)(size & 0xFF);
                        size >>= 8;
                    }
                    size = 5;
                }
                this.write(pickler, header, size);
                this.write(pickler, pdata, nbytes);
            } else {
                TruffleString repr = this.repr(frame, obj);
                this.write(pickler, (byte)76);
                this.writeASCII(pickler, this.asStringStrict(repr));
                this.writeASCII(pickler, T_L_NEW_LINE);
            }
        }

        private void saveFloat(VirtualFrame frame, PPickler pickler, Object obj, Node inliningTarget, PyFloatAsDoubleNode asDoubleNode) {
            double value = asDoubleNode.execute(frame, inliningTarget, obj);
            if (pickler.isBin()) {
                byte[] pdata = new byte[9];
                pdata[0] = 71;
                NumericSupport.bigEndian().putDouble(pdata, 1, value);
                this.write(pickler, pdata, 9);
            } else {
                this.write(pickler, (byte)70);
                TruffleString repr = PickleUtils.doubleToAsciiString(value);
                this.writeASCII(pickler, repr);
                this.writeASCII(pickler, StringLiterals.T_NEWLINE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveBytes(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj, IndirectCallData indirectCallData) {
            Object buffer = this.getBufferAcquireLibrary().acquireReadonly(obj, frame, indirectCallData);
            try {
                if (pickler.proto < 3) {
                    PTuple reduceValue;
                    if (this.getBufferLibrary().getBufferLength(buffer) == 0) {
                        reduceValue = this.createTuple(ctx.getCore().lookupType(PythonBuiltinClassType.PBytes), this.createTuple(new Object[0]));
                    } else {
                        PickleState st = this.getGlobalState(ctx.getCore());
                        TruffleString unicodeStr = PickleUtils.decodeLatin1Strict(this.getBufferLibrary().getCopiedByteArray(buffer), this.ensureTsFromByteArray(), this.ensureTsSwitchEncodingNode());
                        reduceValue = this.createTuple(st.codecsEncode, this.createTuple(unicodeStr, LATIN1));
                    }
                    this.saveReduce(frame, ctx, pickler, reduceValue, obj);
                } else {
                    byte[] bytes = this.getBufferLibrary().getCopiedByteArray(buffer);
                    this.saveBytesData(frame, pickler, obj, bytes, bytes.length);
                }
            }
            finally {
                this.getBufferLibrary().release(buffer, frame, indirectCallData);
            }
        }

        private void saveBytesData(VirtualFrame frame, PPickler pickler, Object obj, byte[] data, int size) {
            int len;
            assert (pickler.proto >= 3);
            byte[] header = new byte[9];
            if (size <= 255) {
                header[0] = 67;
                header[1] = (byte)size;
                len = 2;
            } else if (Long.compareUnsigned(size, 0xFFFFFFFFL) < 0) {
                header[0] = 66;
                header[1] = (byte)(size & 0xFF);
                header[2] = (byte)(size >> 8 & 0xFF);
                header[3] = (byte)(size >> 16 & 0xFF);
                header[4] = (byte)(size >> 24 & 0xFF);
                len = 5;
            } else if (pickler.proto >= 4) {
                header[0] = -114;
                PickleUtils.writeSize64(header, 1, size);
                len = 9;
            } else {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.SER_OVER_4GB);
            }
            this.writeBytes(frame, pickler, header, len, data, size, obj);
            this.memoPut(pickler, obj);
        }

        private void writeUnicodeBinary(VirtualFrame frame, PPickler pickler, Object obj) {
            int len;
            int size;
            Object encoded = null;
            byte[] header = new byte[9];
            byte[] data = PickleUtils.encodeUTF8Strict(this.asStringStrict(obj), this.ensureTsSwitchEncodingNode(), this.ensureTsCopyToByteArrayNode(), this.ensureTsGetCodeRangeNode());
            if (data == null) {
                encoded = this.getItem(frame, this.encode(obj, StringLiterals.T_UTF8, T_ERRORS_SURROGATEPASS), (Object)0);
                data = this.toBytes(frame, encoded);
            }
            if ((size = data.length) <= 255 && pickler.proto >= 4) {
                header[0] = -116;
                header[1] = (byte)(size & 0xFF);
                len = 2;
            } else if (Long.compareUnsigned(size, 0xFFFFFFFFL) <= 0) {
                header[0] = 88;
                header[1] = (byte)(size & 0xFF);
                header[2] = (byte)(size >> 8 & 0xFF);
                header[3] = (byte)(size >> 16 & 0xFF);
                header[4] = (byte)(size >> 24 & 0xFF);
                len = 5;
            } else if (pickler.proto >= 4) {
                header[0] = -115;
                PickleUtils.writeSize64(header, 1, size);
                len = 9;
            } else {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.SER_OVER_4GB);
            }
            this.writeBytes(frame, pickler, header, len, data, size, encoded);
        }

        private void saveUnicode(VirtualFrame frame, PPickler pickler, Object obj) {
            if (pickler.isBin()) {
                this.writeUnicodeBinary(frame, pickler, obj);
            } else {
                byte[] encoded = PickleUtils.rawUnicodeEscape(this.asStringStrict(obj), this.ensureTsCodePointLengthNode(), this.ensureTsCodePointAtIndexNode());
                this.write(pickler, (byte)86);
                this.write(pickler, encoded);
                this.writeASCII(pickler, StringLiterals.T_NEWLINE);
            }
            this.memoPut(pickler, obj);
        }

        private void batchDictExact(VirtualFrame frame, PPickler pickler, PDict dict) {
            HashingStorage storage = this.getHashingStorage(frame, dict);
            int length = this.getHashingStorageLength(storage);
            if (length == 1) {
                HashingStorageNodes.HashingStorageIterator it = this.getHashingStorageIterator(storage);
                if (!this.ensureHashingStorageIteratorNext().executeCached(storage, it)) {
                    throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CHANGED_SIZE_DURING_ITERATION, T_DICTIONARY);
                }
                HashingStorageNodes.HashingStorageIteratorKey getKeyNode = this.ensureHashingStorageIteratorKey();
                HashingStorageNodes.HashingStorageIteratorValue getValueNode = this.ensureHashingStorageIteratorValue();
                this.save(frame, pickler, getKeyNode.executeCached(storage, it), 0);
                this.save(frame, pickler, getValueNode.executeCached(storage, it), 0);
                this.write(pickler, (byte)115);
            } else {
                this.saveDictHashingStorageBatched(frame, pickler, storage);
            }
        }

        private void batchDict(VirtualFrame frame, PPickler pickler, Object iterator) {
            assert (iterator != null);
            if (pickler.proto == 0) {
                this.saveDictIterator(frame, pickler, iterator);
            } else {
                this.saveDictIteratorBatchUnrolled(frame, pickler, iterator);
            }
        }

        private void saveDict(VirtualFrame frame, Node inliningTarget, PyObjectCallMethodObjArgs callMethod, PPickler pickler, Object obj) {
            int len;
            byte[] header = new byte[3];
            if (pickler.isFast()) {
                this.fastSaveEnter(pickler, obj);
            }
            if (pickler.isBin()) {
                header[0] = 125;
                len = 1;
            } else {
                header[0] = 40;
                header[1] = 100;
                len = 2;
            }
            this.write(pickler, header, len);
            this.memoPut(pickler, obj);
            if (this.length(frame, obj) > 0) {
                if (PGuards.isDict(obj) && pickler.proto > 0) {
                    this.batchDictExact(frame, pickler, (PDict)obj);
                } else {
                    Object items = callMethod.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T_ITEMS, new Object[0]);
                    this.batchDict(frame, pickler, this.getIter(frame, items));
                }
            }
            if (pickler.isFast()) {
                SaveNode.fastSaveLeave(pickler, obj);
            }
        }

        private void batchSetExact(VirtualFrame frame, PPickler pickler, Object obj) {
            HashingStorage storage = this.getHashingStorage(frame, obj);
            this.saveSetHashingStorageBatched(frame, pickler, storage);
        }

        private void batchSet(VirtualFrame frame, PPickler pickler, Object obj) {
            int i;
            Object iterator = this.getIter(frame, obj);
            int setSize = this.length(frame, obj);
            do {
                Object item;
                i = 0;
                this.write(pickler, (byte)40);
                while ((item = this.getNextItem(frame, iterator)) != null) {
                    this.save(frame, pickler, item, 0);
                    if (++i != 1000) continue;
                    break;
                }
                this.write(pickler, (byte)-112);
                if (this.length(frame, obj) == setSize) continue;
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CHANGED_SIZE_DURING_ITERATION, "set");
            } while (i == 1000);
        }

        private void saveSet(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj) {
            if (pickler.proto < 4) {
                Object items = this.createList(frame, obj);
                PTuple reduceValue = this.createTuple(ctx.getCore().lookupType(PythonBuiltinClassType.PSet), this.createTuple(items));
                this.saveReduce(frame, ctx, pickler, reduceValue, obj);
                return;
            }
            this.write(pickler, (byte)-113);
            this.memoPut(pickler, obj);
            int setSize = this.length(frame, obj);
            if (setSize == 0) {
                return;
            }
            if (PGuards.isPSet(obj)) {
                this.batchSetExact(frame, pickler, obj);
            } else {
                this.batchSet(frame, pickler, obj);
            }
        }

        private void saveFrozenset(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj) {
            if (pickler.isFast()) {
                this.fastSaveEnter(pickler, obj);
            }
            if (pickler.proto < 4) {
                Object items = this.createList(frame, obj);
                PTuple reduceValue = this.createTuple(ctx.getCore().lookupType(PythonBuiltinClassType.PFrozenSet), this.createTuple(items));
                this.saveReduce(frame, ctx, pickler, reduceValue, obj);
                return;
            }
            this.write(pickler, (byte)40);
            if (PGuards.isPFrozenSet(obj)) {
                HashingStorage storage = this.getHashingStorage(frame, obj);
                this.saveSetHashingStorage(frame, pickler, storage);
            } else {
                Object iterator = this.getIter(frame, obj);
                this.saveFrozenSetIterator(frame, pickler, iterator);
            }
            int memoIndex = pickler.memo.get(obj);
            if (memoIndex != -1) {
                this.write(pickler, (byte)49);
                this.memoGet(pickler, memoIndex);
                return;
            }
            this.write(pickler, (byte)-111);
            this.memoPut(pickler, obj);
        }

        private void batchListExact(VirtualFrame frame, PPickler pickler, Object obj) {
            SequenceStorage storage = this.getSequenceStorage(obj);
            if (this.length(frame, obj) == 1) {
                Object item = this.getItem(frame, storage, 0);
                this.save(frame, pickler, item, 0);
                this.write(pickler, (byte)97);
                return;
            }
            int total = 0;
            do {
                int thisBatch = 0;
                this.write(pickler, (byte)40);
                while (total < this.length(frame, obj)) {
                    Object item = this.getItem(frame, storage, total);
                    this.save(frame, pickler, item, 0);
                    ++total;
                    if (++thisBatch != 1000) continue;
                }
                this.write(pickler, (byte)101);
            } while (total < this.length(frame, obj));
        }

        private void batchList(VirtualFrame frame, PPickler pickler, Object iterator) {
            assert (iterator != null);
            if (pickler.proto == 0) {
                this.saveListIterator(frame, pickler, iterator);
            } else {
                this.saveListIteratorBatchUnrolled(frame, pickler, iterator);
            }
        }

        private void saveList(VirtualFrame frame, PPickler pickler, Object obj) {
            int len;
            byte[] header = new byte[3];
            if (pickler.isFast()) {
                this.fastSaveEnter(pickler, obj);
            }
            if (pickler.isBin()) {
                header[0] = 93;
                len = 1;
            } else {
                header[0] = 40;
                header[1] = 108;
                len = 2;
            }
            this.write(pickler, header, len);
            len = this.length(frame, obj);
            this.memoPut(pickler, obj);
            if (len != 0) {
                if (PGuards.isList(obj) && pickler.proto > 0) {
                    this.batchListExact(frame, pickler, obj);
                } else {
                    this.batchList(frame, pickler, this.getIter(frame, obj));
                }
            }
            if (pickler.isFast()) {
                SaveNode.fastSaveLeave(pickler, obj);
            }
        }

        private void storeTupleElements(VirtualFrame frame, PPickler pickler, Object obj, int len) {
            assert (PyObjectSizeNode.executeUncached((Frame)frame, obj) == len);
            for (int i = 0; i < len; ++i) {
                Object element = this.getItem(frame, obj, (Object)i);
                this.save(frame, pickler, element, 0);
            }
        }

        private void saveTuple(VirtualFrame frame, PPickler pickler, Object obj) {
            int len = this.length(frame, obj);
            if (len == 0) {
                byte[] pdata = new byte[2];
                if (pickler.proto != 0) {
                    pdata[0] = 41;
                    len = 1;
                } else {
                    pdata[0] = 40;
                    pdata[1] = 116;
                    len = 2;
                }
                this.write(pickler, pdata, len);
                return;
            }
            if (len <= 3 && pickler.proto >= 2) {
                this.storeTupleElements(frame, pickler, obj, len);
                int memoIndex = pickler.memo.get(obj);
                if (memoIndex != -1) {
                    for (int i = 0; i < len; ++i) {
                        this.write(pickler, (byte)48);
                    }
                    this.memoGet(pickler, memoIndex);
                    return;
                }
                this.write(pickler, TUPLE_LEN_2_OPCODE[len]);
                this.memoPut(pickler, obj);
                return;
            }
            this.write(pickler, (byte)40);
            this.storeTupleElements(frame, pickler, obj, len);
            int memoIndex = pickler.memo.get(obj);
            if (memoIndex != -1) {
                if (pickler.isBin()) {
                    this.write(pickler, (byte)49);
                } else {
                    for (int i = 0; i <= len; ++i) {
                        this.write(pickler, (byte)48);
                    }
                }
                this.memoGet(pickler, memoIndex);
                return;
            }
            this.write(pickler, (byte)116);
            this.memoPut(pickler, obj);
        }

        private void saveBytearrayData(VirtualFrame frame, PPickler pickler, Object obj, byte[] data, int size) {
            assert (pickler.proto >= 5);
            if (size < 0) {
                return;
            }
            byte[] header = new byte[9];
            header[0] = -106;
            PickleUtils.writeSize64(header, 1, size);
            int len = 9;
            this.writeBytes(frame, pickler, header, len, data, size, obj);
            this.memoPut(pickler, obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveBytearray(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj, IndirectCallData indirectCallData) {
            Object buffer = this.getBufferAcquireLibrary().acquireReadonly(obj, frame, indirectCallData);
            try {
                if (pickler.proto < 5) {
                    PTuple reduceValue;
                    PythonBuiltinClass byteArrayClass = ctx.getCore().lookupType(PythonBuiltinClassType.PByteArray);
                    if (this.getBufferLibrary().getBufferLength(buffer) == 0) {
                        reduceValue = this.createTuple(byteArrayClass, this.createTuple(new Object[0]));
                    } else {
                        byte[] bytes = this.getBufferLibrary().getCopiedByteArray(buffer);
                        reduceValue = this.createTuple(byteArrayClass, this.createTuple(this.factory().createBytes(bytes)));
                    }
                    this.saveReduce(frame, ctx, pickler, reduceValue, obj);
                } else {
                    this.saveBytearrayData(frame, pickler, obj, this.getBufferLibrary().getCopiedByteArray(buffer), this.length(frame, obj));
                }
            }
            finally {
                this.getBufferLibrary().release(buffer, frame, indirectCallData);
            }
        }

        private void savePicklebuffer(VirtualFrame frame, PPickler pickler, PPickleBuffer obj) {
            if (pickler.proto < 5) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.PICKLEBUFF_CANNOT_PICKLE_WITH_PROTO5);
            }
            Object buffer = obj.getView();
            PythonBufferAccessLibrary bufferLib = this.getBufferLibrary();
            int bytesLen = bufferLib.getBufferLength(buffer);
            byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
            boolean inBand = true;
            if (pickler.bufferCallback != null) {
                Object ret = this.getCallNode().execute((Frame)frame, pickler.bufferCallback, obj);
                inBand = this.isTrue(frame, ret);
            }
            boolean readOnly = bufferLib.isReadonly(buffer);
            if (inBand) {
                if (readOnly) {
                    this.saveBytesData(frame, pickler, obj, bytes, bytesLen);
                } else {
                    this.saveBytearrayData(frame, pickler, obj, bytes, bytesLen);
                }
            } else {
                this.write(pickler, (byte)-105);
                if (readOnly) {
                    this.write(pickler, (byte)-104);
                }
            }
        }

        private void saveSingletonType(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj, Object singleton) {
            PTuple reduceValue = this.createTuple(ctx.getCore().lookupType(PythonBuiltinClassType.PythonClass), this.createTuple(singleton));
            this.saveReduce(frame, ctx, pickler, reduceValue, obj);
        }

        private void saveType(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj) {
            if (this.isBuiltinClass(obj, PythonBuiltinClassType.PNone)) {
                this.saveSingletonType(frame, ctx, pickler, obj, PNone.NONE);
            } else if (this.isBuiltinClass(obj, PythonBuiltinClassType.PEllipsis)) {
                this.saveSingletonType(frame, ctx, pickler, obj, PEllipsis.INSTANCE);
            } else if (this.isBuiltinClass(obj, PythonBuiltinClassType.PNotImplemented)) {
                this.saveSingletonType(frame, ctx, pickler, obj, PNotImplemented.NOT_IMPLEMENTED);
            } else {
                Object type = obj instanceof PythonBuiltinClassType ? ctx.getCore().lookupType((PythonBuiltinClassType)((Object)obj)) : obj;
                this.saveGlobal(frame, ctx, pickler, type, null);
            }
        }

        private void saveGlobal(VirtualFrame frame, PythonContext ctx, PPickler pickler, Object obj, Object name) {
            boolean genGlobal;
            PythonModule module;
            Object gName;
            PickleState st = this.getGlobalState(ctx.getCore());
            if (name != null) {
                gName = name;
            } else {
                gName = this.lookupAttribute((Frame)frame, obj, SpecialAttributeNames.T___QUALNAME__);
                if (gName == PNone.NO_VALUE) {
                    gName = this.lookupAttributeStrict((Frame)frame, obj, SpecialAttributeNames.T___NAME__);
                }
            }
            TruffleString globalName = this.asStringStrict(gName);
            TruffleString[] dottedPath = this.getDottedPath(obj, globalName);
            TruffleString moduleName = this.whichModule(frame, ctx, obj, dottedPath);
            try {
                module = AbstractImportNode.importModule(moduleName);
            }
            catch (PException e) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_P_IMPORT_OF_MODULE_S_FAILED, obj, moduleName);
            }
            Pair<Object, Object> pair = SaveNode.getDeepAttribute(frame, this.getLookupAttrNode(), module, dottedPath);
            if (pair == null) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_P_ATTR_LOOKUP_FAIL_S_S, obj, globalName, moduleName);
            }
            Object cls = pair.getLeft();
            Object parent = pair.getRight();
            if (!this.isSame(cls, obj)) {
                throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_P_NOT_SAME_OBJ_AS_S_S, obj, moduleName, globalName);
            }
            if (pickler.proto >= 2) {
                genGlobal = false;
                byte[] pdata = new byte[5];
                PTuple extensionKey = this.createTuple(moduleName, globalName);
                Object codeObj = this.getDictItem(frame, st.extensionRegistry, extensionKey);
                if (codeObj == null) {
                    genGlobal = true;
                } else {
                    int n;
                    if (!PGuards.canBeInteger(codeObj)) {
                        throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_P_EXT_CODE_P_NOT_AN_INT, obj, codeObj);
                    }
                    long code = this.asLong(frame, codeObj);
                    if (code <= 0L || code > Integer.MAX_VALUE) {
                        throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_P_EXT_CODE_OO_RANGE, obj, code);
                    }
                    if (code <= 255L) {
                        pdata[0] = -126;
                        pdata[1] = (byte)code;
                        n = 2;
                    } else if (code <= 65535L) {
                        pdata[0] = -125;
                        pdata[1] = (byte)(code & 0xFFL);
                        pdata[2] = (byte)(code >> 8 & 0xFFL);
                        n = 3;
                    } else {
                        pdata[0] = -124;
                        pdata[1] = (byte)(code & 0xFFL);
                        pdata[2] = (byte)(code >> 8 & 0xFFL);
                        pdata[3] = (byte)(code >> 16 & 0xFFL);
                        pdata[4] = (byte)(code >> 24 & 0xFFL);
                        n = 5;
                    }
                    this.write(pickler, pdata, n);
                }
            } else {
                genGlobal = true;
            }
            if (genGlobal) {
                TruffleString lastname = dottedPath[dottedPath.length - 1];
                if (parent == module) {
                    globalName = lastname;
                }
                if (pickler.proto >= 4) {
                    this.save(frame, pickler, moduleName, 0);
                    this.save(frame, pickler, globalName, 0);
                    this.write(pickler, (byte)-109);
                } else if (parent != module) {
                    PTuple reduceValue = this.createTuple(st.getattr, this.createTuple(parent, lastname));
                    this.saveReduce(frame, ctx, pickler, reduceValue, null);
                } else {
                    this.write(pickler, (byte)99);
                    if (pickler.proto < 3 && pickler.fixImports) {
                        Pair<TruffleString, TruffleString> to2Mapping = this.get3to2Mapping(frame, ctx.getCore(), moduleName, globalName);
                        moduleName = (TruffleString)to2Mapping.getLeft();
                        globalName = (TruffleString)to2Mapping.getRight();
                    }
                    TruffleString.Encoding encoding = pickler.proto == 3 ? TruffleString.Encoding.UTF_8 : TruffleString.Encoding.US_ASCII;
                    byte[] encoded = PickleUtils.encodeStrict(moduleName, this.ensureTsSwitchEncodingNode(), encoding, this.ensureTsCopyToByteArrayNode(), this.ensureTsGetCodeRangeNode());
                    if (encoded == null) {
                        throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_MODULE_S_USING_PROTO_D, moduleName, pickler.proto);
                    }
                    this.write(pickler, encoded);
                    this.writeASCII(pickler, StringLiterals.T_NEWLINE);
                    encoded = PickleUtils.encodeStrict(globalName, this.ensureTsSwitchEncodingNode(), encoding, this.ensureTsCopyToByteArrayNode(), this.ensureTsGetCodeRangeNode());
                    if (encoded == null) {
                        throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANT_PICKLE_MODULE_S_USING_PROTO_D, moduleName, pickler.proto);
                    }
                    this.write(pickler, encoded);
                    this.writeASCII(pickler, StringLiterals.T_NEWLINE);
                }
                this.memoPut(pickler, obj);
            }
        }

        @Specialization
        void saveGeneric(VirtualFrame frame, PPickler pickler, Object objArg, int persSave, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached CallNode callNode, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object reduceValue;
            Object reduceValue2;
            int memoIndex;
            Object obj = objArg;
            this.opcodeBoundary(frame, pickler);
            if (persSave == 0 && pickler.persFunc != null && this.savePers(frame, pickler, obj)) {
                return;
            }
            Object type = this.getClass(obj);
            if (obj == PNone.NONE) {
                this.saveNone(pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.Boolean)) {
                this.saveBool(frame, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PInt)) {
                this.saveLong(frame, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PFloat)) {
                this.saveFloat(frame, pickler, obj, inliningTarget, asDoubleNode);
                return;
            }
            if (obj instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType classType = (PythonBuiltinClassType)((Object)obj);
                obj = PythonContext.get(this).getCore().lookupType(classType);
            }
            if ((memoIndex = pickler.memo.get(obj)) != -1) {
                this.memoGet(pickler, memoIndex);
                return;
            }
            PythonContext ctx = PythonContext.get(this);
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PBytes)) {
                this.saveBytes(frame, ctx, pickler, obj, indirectCallData);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PString)) {
                this.saveUnicode(frame, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PDict)) {
                this.saveDict(frame, inliningTarget, callMethod, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PSet)) {
                this.saveSet(frame, ctx, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PFrozenSet)) {
                this.saveFrozenset(frame, ctx, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PList)) {
                this.saveList(frame, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PTuple)) {
                this.saveTuple(frame, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PByteArray)) {
                this.saveBytearray(frame, ctx, pickler, obj, indirectCallData);
                return;
            }
            if (obj instanceof PPickleBuffer) {
                PPickleBuffer buffer = (PPickleBuffer)obj;
                this.savePicklebuffer(frame, pickler, buffer);
                return;
            }
            if (pickler.reducerOverride != null && (reduceValue2 = callNode.execute((Frame)frame, pickler.reducerOverride, obj)) != PNotImplemented.NOT_IMPLEMENTED) {
                this.handleReduce(frame, ctx, pickler, obj, reduceValue2);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PythonClass)) {
                this.saveType(frame, ctx, pickler, obj);
                return;
            }
            if (this.isBuiltinClass(type, PythonBuiltinClassType.PFunction)) {
                this.saveGlobal(frame, ctx, pickler, obj, null);
                return;
            }
            Object reduceFunc = null;
            if (pickler.dispatchTable == null) {
                PickleState state = this.getGlobalState(ctx.getCore());
                reduceFunc = this.getDictItem(frame, state.dispatchTable, type);
            } else {
                try {
                    reduceFunc = this.getItem(frame, pickler.dispatchTable, type);
                }
                catch (PException ex) {
                    ex.expectCached(PythonErrorType.KeyError, this.ensureErrProfile());
                }
            }
            if (reduceFunc != null) {
                reduceValue = callNode.execute((Frame)frame, reduceFunc, obj);
            } else {
                if (this.isSubType(type, (Object)PythonBuiltinClassType.PythonClass)) {
                    this.saveGlobal(frame, ctx, pickler, obj, null);
                    return;
                }
                reduceFunc = this.lookupAttribute((Frame)frame, obj, SpecialMethodNames.T___REDUCE_EX__);
                if (reduceFunc != PNone.NO_VALUE) {
                    reduceValue = callNode.execute((Frame)frame, reduceFunc, pickler.proto);
                } else {
                    reduceFunc = this.lookupAttribute((Frame)frame, obj, SpecialMethodNames.T___REDUCE__);
                    if (reduceFunc != PNone.NO_VALUE) {
                        reduceValue = callNode.execute((Frame)frame, reduceFunc, new Object[0]);
                    } else {
                        throw this.raise(PythonErrorType.PicklingError, ErrorMessages.CANNOT_PICKLE_P_P, type, obj);
                    }
                }
            }
            this.handleReduce(frame, ctx, pickler, obj, reduceValue);
        }
    }

    public static abstract class FlushToFileNode
    extends BasePickleWriteNode {
        public abstract void execute(VirtualFrame var1, PPickler var2);

        @Specialization
        public void flush(VirtualFrame frame, PPickler pickler) {
            assert (pickler.write != null);
            PBytes output = pickler.getString(this.factory());
            this.call(frame, pickler.write, output);
        }
    }

    public static abstract class BasePickleWriteNode
    extends PicklerNodes.BasePickleNode {
        static final byte[] TUPLE_LEN_2_OPCODE = new byte[]{41, -123, -122, -121};
        static final byte NEW_LINE_BYTE = 10;
        static final TruffleString DICT_ITEMS = PythonUtils.tsLiteral("dict items");
        static final TruffleString LATIN1 = PythonUtils.tsLiteral("latin1");
        static final TruffleString REDUCE_OVERRIDE = PythonUtils.tsLiteral("reducer_override");
        static final TruffleString T_L_NEW_LINE = PythonUtils.tsLiteral("L\n");
        static final TruffleString T_SET = PythonUtils.tsLiteral("set");
        static final TruffleString T_DICTIONARY = PythonUtils.tsLiteral("dictionary");
        @Node.Child
        private IntNodes.PyLongSign pyLongSign;
        @Node.Child
        private IntNodes.PyLongNumBits pyLongNumBits;
        @Node.Child
        private IntNodes.PyLongAsByteArray pyLongAsByteArray;
        @Node.Child
        private ListNodes.ConstructListNode constructListNode;
        @Node.Child
        private IsSubtypeNode isSubTypeNode;
        @Node.Child
        private TypeNodes.IsTypeNode isTypeNode;
        @Node.Child
        private FlushToFileNode flushToFileNode;
        @Node.Child
        private CallNode callNode;

        protected boolean isType(Object obj) {
            if (this.isTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTypeNode = (TypeNodes.IsTypeNode)this.insert(TypeNodes.IsTypeNode.create());
            }
            return this.isTypeNode.executeCached(obj);
        }

        protected void flushToFile(VirtualFrame frame, PPickler pickler) {
            if (this.flushToFileNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.flushToFileNode = (FlushToFileNode)this.insert(PPicklerFactory.FlushToFileNodeGen.create());
            }
            this.flushToFileNode.execute(frame, pickler);
        }

        protected int getSign(Object value) {
            if (this.pyLongSign == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyLongSign = (IntNodes.PyLongSign)this.insert(IntNodesFactory.PyLongSignNodeGen.create());
            }
            return this.pyLongSign.execute(value);
        }

        protected int getNumBits(Object value) {
            if (this.pyLongNumBits == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyLongNumBits = (IntNodes.PyLongNumBits)this.insert(IntNodesFactory.PyLongNumBitsNodeGen.create());
            }
            return this.pyLongNumBits.execute(value);
        }

        protected byte[] longAsBytes(Object value, int size, boolean bigEndian) {
            if (this.pyLongAsByteArray == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyLongAsByteArray = (IntNodes.PyLongAsByteArray)this.insert(IntNodesFactory.PyLongAsByteArrayNodeGen.create());
            }
            return this.pyLongAsByteArray.executeCached(value, size, bigEndian);
        }

        protected Object createList(VirtualFrame frame, Object iterable) {
            if (this.constructListNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.constructListNode = (ListNodes.ConstructListNode)this.insert(ListNodes.ConstructListNode.create());
            }
            return this.constructListNode.execute((Frame)frame, iterable);
        }

        protected boolean isSubType(Object clsA, Object clsB) {
            if (this.isSubTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSubTypeNode = (IsSubtypeNode)this.insert(IsSubtypeNode.create());
            }
            return this.isSubTypeNode.execute(clsA, clsB);
        }

        protected CallNode getCallNode() {
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNode = (CallNode)this.insert(CallNode.create());
            }
            return this.callNode;
        }

        public void opcodeBoundary(VirtualFrame frame, PPickler pickler) {
            if (!pickler.isFraming() || pickler.frameStart == -1) {
                return;
            }
            int frameLen = pickler.outputLen - pickler.frameStart - 9;
            if (frameLen >= 65536) {
                pickler.commitFrame();
                if (pickler.write != null) {
                    this.flushToFile(frame, pickler);
                    pickler.clearBuffer();
                }
            }
        }

        public static void handleError(PPickler pickler) {
            pickler.framing = false;
            pickler.reducerOverride = null;
        }

        protected void writeASCII(PPickler pickler, TruffleString string) {
            assert (string.getCodeRangeUncached(PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII);
            byte[] bytes = PythonUtils.getAsciiBytes(string, this.ensureTsCopyToByteArrayNode(), this.ensureTsSwitchEncodingNode());
            this.write(pickler, bytes, bytes.length);
        }

        protected void write(PPickler pickler, byte oneByte) {
            this.write(pickler, new byte[]{oneByte}, 1);
        }

        protected void write(PPickler pickler, byte[] bytes) {
            this.write(pickler, bytes, bytes.length);
        }

        protected void write(PPickler pickler, byte[] bytes, int dataLen) {
            boolean needNewFrame = pickler.isFraming() && pickler.frameStart == -1;
            int n = needNewFrame ? dataLen + 9 : dataLen;
            int required = pickler.outputLen + n;
            if (required > pickler.maxOutputLen) {
                if (pickler.outputLen >= 0x3FFFFFFF - n) {
                    throw this.raise(PythonBuiltinClassType.MemoryError);
                }
                pickler.maxOutputLen = (pickler.outputLen + n) / 2 * 3;
                pickler.outputBuffer = PickleUtils.resize(pickler.outputBuffer, pickler.maxOutputLen);
            }
            if (needNewFrame) {
                int frameStart;
                pickler.frameStart = frameStart = pickler.outputLen;
                for (int i = 0; i < 9; ++i) {
                    pickler.outputBuffer[frameStart + i] = -2;
                }
                pickler.outputLen += 9;
            }
            PythonUtils.arraycopy(bytes, 0, pickler.outputBuffer, pickler.outputLen, dataLen);
            pickler.outputLen += dataLen;
        }

        protected void writeBytes(VirtualFrame frame, PPickler pickler, byte[] header, int headerSize, byte[] data, int dataSize, Object payload) {
            boolean bypassBuffer = dataSize >= 65536;
            boolean framing = pickler.framing;
            if (bypassBuffer) {
                assert (pickler.outputBuffer != null);
                pickler.commitFrame();
                pickler.framing = false;
            }
            this.write(pickler, header, headerSize);
            if (bypassBuffer && pickler.write != null) {
                this.flushToFile(frame, pickler);
                Object pld = payload;
                if (pld == null) {
                    pld = this.factory().createBytes(data, 0, dataSize);
                }
                this.getCallNode().execute((Frame)frame, pickler.write, pld);
                pickler.clearBuffer();
            } else {
                this.write(pickler, data, dataSize);
            }
            pickler.framing = framing;
        }

        protected PTuple createTuple(Object ... items) {
            if (items.length == 0) {
                return this.factory().createEmptyTuple();
            }
            return this.factory().createTuple(items);
        }

        protected void fastSaveEnter(PPickler pickler, Object obj) {
            if (++pickler.fastNesting >= 50) {
                if (pickler.fastMemoContains(obj)) {
                    pickler.fastNesting = -1;
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.FAST_MEMO_CANT_PICKLE_CYCLIC_OBJ_P_S, obj, obj);
                }
                pickler.fastMemoPut(obj);
            }
        }

        protected static void fastSaveLeave(PPickler pickler, Object obj) {
            if (pickler.fastNesting-- >= 50) {
                pickler.fastMemoRemove(obj);
            }
        }
    }
}

