/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

public final class StgDictObject
extends PDict {
    protected static final int VOID_PTR_SIZE = 8;
    protected static final int DICTFLAG_FINAL = 4096;
    int size;
    int align;
    int length;
    FFIType ffi_type_pointer;
    Object proto;
    FFIType.FieldSet setfunc = FFIType.FieldSet.nil;
    FFIType.FieldGet getfunc = FFIType.FieldGet.nil;
    int paramfunc = -1;
    Object[] argtypes;
    Object[] converters;
    Object restype;
    Object checker;
    int flags;
    TruffleString format = null;
    int ndim = 0;
    int[] shape = null;
    Object[] fieldsNames = null;
    int[] fieldsOffsets;
    FFIType.FFI_TYPES[] fieldsTypes;

    public StgDictObject(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
        this.ffi_type_pointer = new FFIType();
    }

    protected void clear() {
        this.proto = null;
        this.argtypes = null;
        this.converters = null;
        this.restype = null;
        this.checker = null;
    }

    protected static void clone(StgDictObject dst, StgDictObject src) {
        dst.clear();
        dst.format = null;
        dst.shape = null;
        dst.ffi_type_pointer = new FFIType();
        if (src.format != null) {
            dst.format = src.format;
        }
        if (src.shape != null) {
            dst.shape = new int[src.ndim];
            PythonUtils.arraycopy(dst.shape, 0, src.shape, 0, src.ndim);
        }
        if (src.ffi_type_pointer.elements == null) {
            return;
        }
        int size = src.length;
        dst.ffi_type_pointer.elements = new FFIType[size];
        PythonUtils.arraycopy(dst.ffi_type_pointer.elements, 0, src.ffi_type_pointer.elements, 0, size);
    }
}

