/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextFileBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNode;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextErrBuiltins {
    private static Object noneToNativeNull(Node node, Object obj) {
        return obj instanceof PNone ? PythonContext.get(node).getNativeNull() : obj;
    }

    static abstract class PyException_SetTraceback
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetTraceback() {
        }

        @Specialization
        Object setTraceback(Object exc, Object traceback, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___TRACEBACK__, traceback);
            return 0;
        }
    }

    static abstract class PyException_GetTraceback
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetTraceback() {
        }

        @Specialization
        Object getTraceback(Object exc, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___TRACEBACK__));
        }
    }

    static abstract class PyException_SetContext
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetContext() {
        }

        @Specialization
        Object setContext(Object exc, Object context, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CONTEXT__, context);
            return PNone.NONE;
        }
    }

    static abstract class PyException_GetContext
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetContext() {
        }

        @Specialization
        Object setCause(Object exc, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CONTEXT__));
        }
    }

    static abstract class PyException_GetCause
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetCause() {
        }

        @Specialization
        Object getCause(Object exc, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CAUSE__));
        }
    }

    static abstract class PyException_SetCause
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetCause() {
        }

        @Specialization
        Object setCause(Object exc, Object cause, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CAUSE__, cause);
            return PNone.NONE;
        }
    }

    static abstract class PyErr_PrintEx
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyErr_PrintEx() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object raise(int set_sys_last_vars, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached SysModuleBuiltins.ExcInfoNode excInfoNode, @Cached PyErr_Restore restoreNode, @Cached PythonCextFileBuiltins.PyFile_WriteObject writeFileNode, @Cached PosixModuleBuiltins.ExitNode exitNode, @Cached PyErr_Display errDisplayNode) {
            Object exceptHook;
            PythonContext context = PythonContext.get(null);
            NativePointer nativeNull = context.getNativeNull();
            PythonContext.PythonThreadState threadState = context.getThreadState(PythonLanguage.get(null));
            Object err = CExtNodes.PyErrOccurredNode.executeUncached(threadState);
            PythonModule sys = context.getSysModule();
            if (err != nativeNull && BuiltinClassProfiles.IsBuiltinObjectProfile.profileObjectUncached(err, PythonBuiltinClassType.SystemExit)) {
                PyErr_PrintEx.handleSystemExit(excInfoNode, isInstanceNode, restoreNode, (SysModuleBuiltins)sys.getBuiltins(), writeFileNode, exitNode);
            }
            CExtNodes.ExceptionState fetched = CExtNodes.PyErrFetchNode.executeUncached(threadState);
            Object type = null;
            Object val = null;
            Object tb = null;
            if (fetched != null) {
                type = fetched.type();
                val = fetched.value();
                tb = fetched.traceback();
            }
            if (type == null || type == PNone.NONE) {
                return PNone.NONE;
            }
            if (tb == null) {
                tb = PNone.NONE;
            }
            if (PyObjectLookupAttr.executeUncached(val, SpecialAttributeNames.T___TRACEBACK__) == PNone.NONE) {
                WriteAttributeToObjectNode.getUncached().execute(val, SpecialAttributeNames.T___TRACEBACK__, tb);
            }
            if (set_sys_last_vars != 0) {
                PyErr_PrintEx.writeLastVars(sys, type, val, tb, restoreNode);
            }
            if ((exceptHook = PyObjectLookupAttr.executeUncached(sys, BuiltinNames.T_EXCEPTHOOK)) != PNone.NO_VALUE) {
                PyErr_PrintEx.handleExceptHook(exceptHook, type, val, tb, excInfoNode, sys, errDisplayNode);
            }
            return PNone.NONE;
        }

        private static void writeLastVars(PythonModule sys, Object type, Object val, Object tb, PyErr_Restore restoreNode) {
            CompilerAsserts.neverPartOfCompilation();
            try {
                WriteAttributeToObjectNode.getUncached().execute(sys, BuiltinNames.T_LAST_TYPE, type);
                WriteAttributeToObjectNode.getUncached().execute(sys, BuiltinNames.T_LAST_VALUE, val);
                WriteAttributeToObjectNode.getUncached().execute(sys, BuiltinNames.T_LAST_TRACEBACK, tb);
            }
            catch (PException e) {
                restoreNode.execute(PNone.NONE, PNone.NONE, PNone.NONE);
            }
        }

        private static void handleExceptHook(Object exceptHook, Object type, Object val, Object tb, SysModuleBuiltins.ExcInfoNode excInfoNode, PythonModule sys, PyErr_Display errDisplayNode) {
            CompilerAsserts.neverPartOfCompilation();
            try {
                CallNode.executeUncached(exceptHook, type, val, tb);
            }
            catch (PException e) {
                PTuple sysInfo = excInfoNode.execute(null);
                Object type1 = PyTupleGetItem.executeUncached(sysInfo, 0);
                Object val1 = PyTupleGetItem.executeUncached(sysInfo, 1);
                Object tb1 = PyTupleGetItem.executeUncached(sysInfo, 2);
                Object stdErr = ((SysModuleBuiltins)sys.getBuiltins()).getStdErr();
                Object writeMethod = PyObjectGetAttr.executeUncached(stdErr, IONodes.T_WRITE);
                CallNode.executeUncached(writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, "Error in sys.excepthook:\n"));
                errDisplayNode.execute(type1, val1, tb1);
                CallNode.executeUncached(writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, "\nOriginal exception was:\n"));
                errDisplayNode.execute(type, val, tb);
                PyObjectCallMethodObjArgs.executeUncached(stdErr, IONodes.T_FLUSH, new Object[0]);
            }
        }

        private static void handleSystemExit(SysModuleBuiltins.ExcInfoNode excInfoNode, BuiltinFunctions.IsInstanceNode isInstanceNode, PyErr_Restore restoreNode, SysModuleBuiltins sys, PythonCextFileBuiltins.PyFile_WriteObject writeFileNode, PosixModuleBuiltins.ExitNode exitNode) {
            CompilerAsserts.neverPartOfCompilation();
            PTuple sysInfo = excInfoNode.execute(null);
            int rc = 0;
            Object returnObject = null;
            Object val = PyTupleGetItem.executeUncached(sysInfo, 1);
            Object codeAttr = PyObjectLookupAttr.executeUncached(val, PBaseException.T_CODE);
            if (val != PNone.NONE && !(codeAttr instanceof PNone)) {
                returnObject = codeAttr;
            }
            if (!(codeAttr instanceof PNone) && isInstanceNode.executeWith(null, codeAttr, (Object)PythonBuiltinClassType.PInt)) {
                rc = (Integer)codeAttr;
            } else {
                restoreNode.execute(PNone.NONE, PNone.NONE, PNone.NONE);
                Object stdErr = sys.getStdErr();
                if (stdErr != null && stdErr != PNone.NONE) {
                    writeFileNode.execute(returnObject, stdErr, 1);
                } else {
                    Object stdOut = sys.getStdOut();
                    Object writeMethod = PyObjectGetAttr.executeUncached(stdOut, IONodes.T_WRITE);
                    CallNode.executeUncached(writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, returnObject));
                    PyObjectCallMethodObjArgs.executeUncached(stdOut, IONodes.T_FLUSH, new Object[0]);
                }
            }
            exitNode.execute(null, rc);
        }
    }

    static abstract class _PyErr_WriteUnraisableMsg
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyErr_WriteUnraisableMsg() {
        }

        @Specialization
        static Object write(Object msg, Object obj, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached WriteUnraisableNode writeUnraisableNode, @Cached CExtCommonNodes.ClearCurrentExceptionNode clearCurrentExceptionNode) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, PythonContext.get(inliningTarget));
            if (threadState.getCurrentException() == null) {
                return PNone.NONE;
            }
            threadState.syncTracebackToException();
            Object exc = threadState.getCurrentException().getEscapedException();
            TruffleString m = null;
            if (msg instanceof TruffleString) {
                m = (TruffleString)msg;
            }
            writeUnraisableNode.execute(exc, m, obj == PNone.NO_VALUE ? PNone.NONE : obj);
            clearCurrentExceptionNode.execute(inliningTarget, threadState);
            return PNone.NONE;
        }
    }

    static abstract class PyTruffleErr_GetExcInfo
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleErr_GetExcInfo() {
        }

        @Specialization
        Object info(@Bind(value="this") Node inliningTarget, @Cached ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached InlinedBranchProfile noExceptionProfile, @Cached PythonObjectFactory factory) {
            PException currentException = getCaughtExceptionNode.executeFromNative();
            if (currentException == null) {
                noExceptionProfile.enter(inliningTarget);
                return this.getNativeNull();
            }
            assert (currentException != PException.NO_EXCEPTION);
            Object exception = currentException.getEscapedException();
            Object traceback = PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getTracebackNode.execute(inliningTarget, exception));
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, exception), exception, traceback});
        }
    }

    static abstract class PyErr_NewExceptionWithDoc
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyErr_NewExceptionWithDoc() {
        }

        @Specialization
        static Object raise(TruffleString name, Object doc, Object base, Object dict, @Cached PyErr_NewException newExNode, @Cached WriteAttributeToObjectNode writeAtrrNode, @Cached PythonObjectFactory factory) {
            if (base == PNone.NO_VALUE) {
                base = PythonErrorType.Exception;
            }
            if (dict == PNone.NO_VALUE) {
                dict = factory.createDict();
            }
            Object ex = newExNode.execute(name, base, dict);
            if (doc != PNone.NO_VALUE) {
                writeAtrrNode.execute(ex, SpecialAttributeNames.T___DOC__, doc);
            }
            return ex;
        }
    }

    static abstract class PyErr_NewException
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_NewException() {
        }

        @Specialization
        static Object newEx(TruffleString name, Object base, Object dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleString.IndexOfCodePointNode indexOfCodepointNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached DictBuiltins.SetItemNode setItemNode, @Cached BuiltinConstructors.TypeNode typeNode, @Cached InlinedBranchProfile notDotProfile, @Cached InlinedBranchProfile notModuleProfile, @Cached InlinedConditionProfile baseProfile, @Cached PythonObjectFactory.Lazy factory, @Cached PRaiseNode.Lazy raiseNode) {
            int length;
            int dotIdx;
            if (base == PNone.NO_VALUE) {
                base = PythonErrorType.Exception;
            }
            if (dict == PNone.NO_VALUE) {
                dict = factory.get(inliningTarget).createDict();
            }
            if ((dotIdx = indexOfCodepointNode.execute((AbstractTruffleString)name, 46, 0, length = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING)) < 0) {
                notDotProfile.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.MUST_BE_MODULE_CLASS, "PyErr_NewException", "name");
            }
            if (getItem.execute(null, inliningTarget, ((PDict)dict).getDictStorage(), base) == null) {
                notModuleProfile.enter(inliningTarget);
                setItemNode.execute(null, dict, SpecialAttributeNames.T___MODULE__, substringNode.execute((AbstractTruffleString)name, 0, dotIdx, PythonUtils.TS_ENCODING, false));
            }
            PTuple bases = baseProfile.profile(inliningTarget, base instanceof PTuple) ? (PTuple)base : factory.get(inliningTarget).createTuple(new Object[]{base});
            return typeNode.execute(null, (Object)PythonBuiltinClassType.PythonClass, substringNode.execute((AbstractTruffleString)name, dotIdx + 1, length - dotIdx - 1, PythonUtils.TS_ENCODING, false), bases, dict, PKeyword.EMPTY_KEYWORDS);
        }
    }

    static abstract class _PyTruffleErr_CreateAndSetException
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyTruffleErr_CreateAndSetException() {
        }

        @Specialization(guards={"!isExceptionClass(inliningTarget, type, isTypeNode, isSubClassNode)"})
        static Object create(Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, type);
        }

        @Specialization(guards={"isExceptionClass(inliningTarget, type, isTypeNode, isSubClassNode)"})
        static Object create(Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached PrepareExceptionNode prepareExceptionNode) {
            Object exception = prepareExceptionNode.execute(null, type, value);
            throw PRaiseNode.raiseExceptionObject(inliningTarget, exception);
        }

        protected static boolean isExceptionClass(Node inliningTarget, Object obj, TypeNodes.IsTypeNode isTypeNode, BuiltinFunctions.IsSubClassNode isSubClassNode) {
            return isTypeNode.execute(inliningTarget, obj) && isSubClassNode.executeWith(null, obj, (Object)PythonBuiltinClassType.PBaseException);
        }
    }

    static abstract class PyErr_Display
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_Display() {
        }

        @Specialization
        Object run(Object typ, PBaseException val, Object tb) {
            if (val.getException() != null) {
                ExceptionUtils.printPythonLikeStackTrace((Throwable)((Object)val.getException()));
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyErr_SetExcInfo
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_SetExcInfo() {
        }

        @Specialization
        Object doClear(Object typ, PNone val, Object tb) {
            PythonContext pythonContext = this.getContext();
            PythonLanguage lang = this.getLanguage();
            pythonContext.getThreadState(lang).setCaughtException(PException.NO_EXCEPTION);
            return PNone.NONE;
        }

        @Specialization
        Object doFull(Object typ, PBaseException val, Object tb) {
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            PException e = PException.fromExceptionInfo(val, PythonOptions.isPExceptionWithJavaStacktrace(language));
            context.getThreadState(language).setCaughtException(e);
            return PNone.NONE;
        }

        @Fallback
        Object doFallback(Object typ, Object val, Object tb) {
            return PNone.NONE;
        }
    }

    static abstract class _PyTruffleErr_Occurred
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyTruffleErr_Occurred() {
        }

        @Specialization
        Object run(Object threadStatePtr, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.NativeToPythonNode nativePtrToPythonNode, @Cached CExtNodes.PyErrOccurredNode pyErrOccurredNode) {
            Object resolved = nativePtrToPythonNode.execute(threadStatePtr);
            if (resolved instanceof PythonContext.PythonThreadState) {
                PythonContext.PythonThreadState pythonThreadState = (PythonContext.PythonThreadState)resolved;
                Object excType = pyErrOccurredNode.execute(inliningTarget, pythonThreadState);
                return excType != null ? excType : this.getNativeNull();
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)String.format("invalid PyThreadState pointer %s (resolved to: %s)", threadStatePtr, resolved));
        }
    }

    static abstract class PyTruffleErr_Fetch
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleErr_Fetch() {
        }

        @Specialization
        static Object doGeneric(Object pType, Object pValue, Object pTraceback, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtNodes.PyErrFetchNode pyErrFetchNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNewRefNode, @Cached CStructAccess.WritePointerNode writePointerNode) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
            CExtNodes.ExceptionState exceptionState = pyErrFetchNode.execute(inliningTarget, threadState);
            if (exceptionState == null) {
                PyTruffleErr_Fetch.doNoException(pType, pValue, pTraceback);
            } else {
                assert (exceptionState.type() != null);
                assert (exceptionState.value() != null);
                writePointerNode.write(pType, toNativeNewRefNode.execute(exceptionState.type()));
                writePointerNode.write(pValue, toNativeNewRefNode.execute(exceptionState.value()));
                writePointerNode.write(pTraceback, toNativeNewRefNode.execute(exceptionState.traceback() != null ? exceptionState.traceback() : PNone.NO_VALUE));
            }
            return PNone.NO_VALUE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doNoException(Object pType, Object pValue, Object pTraceback) {
            CStructAccess.WritePointerNode.writeUncached(pType, 0L, (Object)0L);
            CStructAccess.WritePointerNode.writeUncached(pValue, 0L, (Object)0L);
            CStructAccess.WritePointerNode.writeUncached(pTraceback, 0L, (Object)0L);
        }
    }

    static abstract class _PyErr_ChainExceptions
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyErr_ChainExceptions() {
        }

        @Specialization
        static Object run(Object typ, Object val, Object tb, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached PrepareExceptionNode prepareExceptionNode, @Cached ExceptionNodes.SetTracebackNode setTracebackNode, @Cached ExceptionNodes.SetContextNode setContextNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            if (typ != PNone.NO_VALUE) {
                PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, PythonContext.get(inliningTarget));
                Object exception = prepareExceptionNode.execute(null, typ, val);
                if (threadState.getCurrentException() != null) {
                    if (tb != PNone.NO_VALUE) {
                        setTracebackNode.execute(inliningTarget, exception, tb);
                    }
                    Object currentException = threadState.getCurrentException().getEscapedException();
                    setContextNode.execute(inliningTarget, currentException, exception);
                } else {
                    LazyTraceback lazyTraceback;
                    PException e = PException.fromExceptionInfo(exception, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(inliningTarget)));
                    if (tb instanceof PTraceback) {
                        PTraceback ptb = (PTraceback)tb;
                        lazyTraceback = new LazyTraceback(ptb);
                    } else {
                        lazyTraceback = null;
                    }
                    transformExceptionToNativeNode.execute(inliningTarget, e, lazyTraceback);
                }
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyErr_Restore
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_Restore() {
        }

        @Specialization
        Object restore(Object typ, Object val, Object tb, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached PrepareExceptionNode prepareExceptionNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached CExtCommonNodes.ClearCurrentExceptionNode clearCurrentExceptionNode) {
            if (typ == PNone.NO_VALUE && val == PNone.NO_VALUE) {
                clearCurrentExceptionNode.execute(inliningTarget, getThreadStateNode.execute(inliningTarget));
            } else {
                LazyTraceback lazyTraceback;
                Object exception = prepareExceptionNode.execute(null, typ, val);
                PException e = PException.fromExceptionInfo(exception, PythonOptions.isPExceptionWithJavaStacktrace(this.getLanguage()));
                if (tb instanceof PTraceback) {
                    PTraceback ptb = (PTraceback)tb;
                    lazyTraceback = new LazyTraceback(ptb);
                } else {
                    lazyTraceback = null;
                }
                transformExceptionToNativeNode.execute(inliningTarget, e, lazyTraceback);
            }
            return PNone.NO_VALUE;
        }
    }
}

