/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.PyExpatModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="pyexpat", os=PythonOS.PLATFORM_WIN32)
public final class PyExpatModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyExpatModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        PythonModule model = core.factory().createPythonModule(PythonUtils.toTruffleStringUncached("pyexpat.model"));
        for (ContentModelConstant v : ContentModelConstant.values()) {
            model.setAttribute(PythonUtils.toTruffleStringUncached(v.name()), v.number);
        }
        this.addBuiltinConstant("model", (Object)model);
        PythonModule errors = core.factory().createPythonModule(PythonUtils.toTruffleStringUncached("pyexpat.errors"));
        EconomicMapStorage codes = EconomicMapStorage.create(ErrorConstant.values().length);
        EconomicMapStorage messages = EconomicMapStorage.create(ErrorConstant.values().length);
        for (ErrorConstant c : ErrorConstant.values()) {
            TruffleString messageTs = PythonUtils.toTruffleStringUncached(c.message);
            errors.setAttribute(PythonUtils.toTruffleStringUncached(c.name()), messageTs);
            int id = c.ordinal() + 1;
            codes.putUncachedWithJavaEq(messageTs, PyObjectHashNode.hash(messageTs, TruffleString.HashCodeNode.getUncached()), id);
            messages.putUncachedWithJavaEq(id, PyObjectHashNode.hash(id), c.message);
        }
        errors.setAttribute(PythonUtils.toTruffleStringUncached("messages"), core.factory().createDict(messages));
        errors.setAttribute(PythonUtils.toTruffleStringUncached("codes"), core.factory().createDict(codes));
        this.addBuiltinConstant("errors", (Object)errors);
    }

    private static enum ContentModelConstant {
        XML_CQUANT_NONE(0),
        XML_CQUANT_OPT(1),
        XML_CQUANT_PLUS(3),
        XML_CQUANT_REP(2),
        XML_CTYPE_ANY(2),
        XML_CTYPE_CHOICE(5),
        XML_CTYPE_EMPTY(1),
        XML_CTYPE_MIXED(3),
        XML_CTYPE_NAME(4),
        XML_CTYPE_SEQ(6);

        private final int number;

        private ContentModelConstant(int number) {
            this.number = number;
        }
    }

    private static enum ErrorConstant {
        XML_ERROR_NO_MEMORY("out of memory"),
        XML_ERROR_SYNTAX("syntax error"),
        XML_ERROR_NO_ELEMENTS("no element found"),
        XML_ERROR_INVALID_TOKEN("not well-formed (invalid token)"),
        XML_ERROR_UNCLOSED_TOKEN("unclosed token"),
        XML_ERROR_PARTIAL_CHAR("partial character"),
        XML_ERROR_TAG_MISMATCH("mismatched tag"),
        XML_ERROR_DUPLICATE_ATTRIBUTE("duplicate attribute"),
        XML_ERROR_JUNK_AFTER_DOC_ELEMENT("junk after document element"),
        XML_ERROR_PARAM_ENTITY_REF("illegal parameter entity reference"),
        XML_ERROR_UNDEFINED_ENTITY("undefined entity"),
        XML_ERROR_RECURSIVE_ENTITY_REF("recursive entity reference"),
        XML_ERROR_ASYNC_ENTITY("asynchronous entity"),
        XML_ERROR_BAD_CHAR_REF("reference to invalid character number"),
        XML_ERROR_BINARY_ENTITY_REF("reference to binary entity"),
        XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF("reference to external entity in attribute"),
        XML_ERROR_MISPLACED_XML_PI("XML or text declaration not at start of entity"),
        XML_ERROR_UNKNOWN_ENCODING("unknown encoding"),
        XML_ERROR_INCORRECT_ENCODING("encoding specified in XML declaration is incorrect"),
        XML_ERROR_UNCLOSED_CDATA_SECTION("unclosed CDATA section"),
        XML_ERROR_EXTERNAL_ENTITY_HANDLING("error in processing external entity reference"),
        XML_ERROR_NOT_STANDALONE("document is not standalone"),
        XML_ERROR_UNEXPECTED_STATE("unexpected parser state - please send a bug report"),
        XML_ERROR_ENTITY_DECLARED_IN_PE("entity declared in parameter entity"),
        XML_ERROR_FEATURE_REQUIRES_XML_DTD("requested feature requires XML_DTD support in Expat"),
        XML_ERROR_CANT_CHANGE_FEATURE_ONCE_PARSING("cannot change setting once parsing has begun"),
        XML_ERROR_UNBOUND_PREFIX("unbound prefix"),
        XML_ERROR_UNDECLARING_PREFIX("must not undeclare prefix"),
        XML_ERROR_INCOMPLETE_PE("incomplete markup in parameter entity"),
        XML_ERROR_XML_DECL("XML declaration not well-formed"),
        XML_ERROR_TEXT_DECL("text declaration not well-formed"),
        XML_ERROR_PUBLICID("illegal character(s) in public id"),
        XML_ERROR_SUSPENDED("parser suspended"),
        XML_ERROR_NOT_SUSPENDED("parser not suspended"),
        XML_ERROR_ABORTED("parsing aborted"),
        XML_ERROR_FINISHED("parsing finished"),
        XML_ERROR_SUSPEND_PE("cannot suspend in external parameter entity");

        private final String message;

        private ErrorConstant(String message) {
            this.message = message;
        }
    }

    @Builtin(name="ParserCreate", parameterNames={"encoding", "namespace_separator", "intern"}, doc="Return a new XML parser object.")
    @GenerateNodeFactory
    static abstract class ParserCreateNode
    extends PythonTernaryBuiltinNode {
        ParserCreateNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object fail(Object encoding, Object namespace_separator, Object intern) {
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("XML pyexpat parser is not implemented"));
        }
    }
}

