/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@CoreFunctions(defineModule="_hpy_debug")
@GenerateNodeFactory
public final class GraalHPyDebugModuleBuiltins
extends PythonBuiltins {
    public static final String J_HPY_DEBUG = "_hpy_debug";
    static final String J_NOT_AVAILABLE = "_not_available";
    private static final TruffleString T_NEW_GENERATION = PythonUtils.tsLiteral("new_generation");
    private static final TruffleString T_GET_OPEN_HANDLES = PythonUtils.tsLiteral("get_open_handles");
    private static final TruffleString T_GET_CLOSED_HANDLES = PythonUtils.tsLiteral("get_closed_handles");
    private static final TruffleString T_GET_QUEUE_MAX_SIZE = PythonUtils.tsLiteral("get_closed_handles_queue_max_size");
    private static final TruffleString T_SET_QUEUE_MAX_SIZE = PythonUtils.tsLiteral("set_closed_handles_queue_max_size");
    private static final TruffleString T_GET_DATA_MAX_SIZE = PythonUtils.tsLiteral("get_protected_raw_data_max_size");
    private static final TruffleString T_SET_DATA_MAX_SIZE = PythonUtils.tsLiteral("set_protected_raw_data_max_size");
    private static final TruffleString T_SET_ON_INVALID_HANDLE = PythonUtils.tsLiteral("set_on_invalid_handle");
    private static final TruffleString T_STACK_TRACE_LIMIT = PythonUtils.tsLiteral("set_handle_stack_trace_limit");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    @Override
    public void postInitialize(Python3Core core) {
        PythonModule hpyDebugModule = core.lookupBuiltinModule(PythonUtils.tsLiteral(J_HPY_DEBUG));
        TruffleString[] keys = new TruffleString[]{T_NEW_GENERATION, T_GET_OPEN_HANDLES, T_GET_CLOSED_HANDLES, T_GET_QUEUE_MAX_SIZE, T_SET_QUEUE_MAX_SIZE, T_GET_DATA_MAX_SIZE, T_SET_DATA_MAX_SIZE, T_SET_ON_INVALID_HANDLE, T_STACK_TRACE_LIMIT};
        try {
            GraalHPyContext hpyContext = GraalHPyContext.ensureHPyWasLoaded(null, core.getContext(), null, null);
            PythonModule nativeDebugModule = hpyContext.getHPyDebugModule();
            PDict nativeDebugDict = GetDictIfExistsNode.getUncached().execute(nativeDebugModule);
            for (TruffleString tkey : keys) {
                hpyDebugModule.setAttribute(tkey, nativeDebugDict.getItem(tkey));
            }
        }
        catch (LoadCExtException.ApiInitException | LoadCExtException.ImportException | IOException e) {
            PBuiltinMethod notAvailableObj = GraalHPyDebugModuleBuiltins.createFunction(core, hpyDebugModule);
            for (TruffleString tkey : keys) {
                hpyDebugModule.setAttribute(tkey, notAvailableObj);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    static PBuiltinMethod createFunction(Python3Core core, PythonModule module) {
        Builtin builtin = NotAvailable.class.getAnnotation(Builtin.class);
        RootCallTarget callTarget = core.getLanguage().createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)NotAvailable.NODE_FACTORY, false), NotAvailable.class, builtin.name());
        int flags = PBuiltinFunction.getFlags(builtin, callTarget);
        TruffleString name = PythonUtils.toTruffleStringUncached(builtin.name());
        PBuiltinFunction fun = core.factory().createBuiltinFunction(name, null, 0, flags, callTarget);
        return core.factory().createBuiltinMethod((Object)module, fun);
    }

    @Builtin(name="_not_available", autoRegister=false, takesVarArgs=true, takesVarKeywordArgs=true)
    static final class NotAvailable
    extends PythonBuiltinNode {
        private static final NodeFactory<NotAvailable> NODE_FACTORY = new PythonUtils.PrototypeNodeFactory<NotAvailable>(new NotAvailable());

        NotAvailable() {
        }

        @Override
        public Object execute(VirtualFrame frame) {
            throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.RuntimeError, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "debug");
        }
    }
}

