/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Slots.class)
public @interface Slot {
    public SlotKind value();

    public boolean isComplex() default false;

    public static enum SlotKind {
        nb_bool,
        sq_length,
        sq_item,
        mp_length,
        mp_subscript,
        tp_descr_get,
        tp_descr_set,
        tp_getattro,
        tp_setattro;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SlotSignature {
        public int minNumOfPositionalArgs() default 0;

        public boolean takesVarArgs() default false;

        public boolean takesVarKeywordArgs() default false;

        public String[] parameterNames() default {};

        public boolean needsFrame() default false;

        public boolean alwaysNeedsCallerFrame() default false;

        public String raiseErrorName() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Slots {
        public Slot[] value();
    }
}

