// CheckStyle: start generated
package com.oracle.graal.python.runtime.object;

import com.oracle.graal.python.builtins.objects.type.TypeNodes.GetInstanceShape;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.GetInstanceShapeNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.object.Shape;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link PythonObjectFactory#getShape(Object, boolean, GetInstanceShape)}
 *     Activation probability: 0.65000
 *     With/without class size: 17/4 bytes
 *   Specialization {@link PythonObjectFactory#doTrace}
 *     Activation probability: 0.35000
 *     With/without class size: 9/4 bytes
 * </pre>
 */
@GeneratedBy(PythonObjectFactory.class)
@SuppressWarnings("javadoc")
public final class PythonObjectFactoryNodeGen extends PythonObjectFactory {

    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link PythonObjectFactory#getShape(Object, boolean, GetInstanceShape)}
     *   1: SpecializationActive {@link PythonObjectFactory#doTrace}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link PythonObjectFactory#getShape(Object, boolean, GetInstanceShape)}
     *   Parameter: {@link GetInstanceShape} getShapeNode</pre>
     */
    @Child private GetInstanceShape getShape_getShapeNode_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link PythonObjectFactory#doTrace}
     *   Parameter: {@link AllocationReporter} reporter</pre>
     */
    @CompilationFinal private AllocationReporter trace_reporter_;

    private PythonObjectFactoryNodeGen() {
    }

    @Override
    protected AllocationReporter executeTrace(Object arg0Value, long arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[PythonObjectFactory.doTrace(Object, long, AllocationReporter)] */) {
            {
                AllocationReporter reporter__ = this.trace_reporter_;
                if (reporter__ != null) {
                    return PythonObjectFactory.doTrace(arg0Value, arg1Value, reporter__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return (AllocationReporter) executeAndSpecialize(arg0Value, arg1Value);
    }

    @Override
    protected Shape executeGetShape(Object arg0Value, boolean arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[PythonObjectFactory.getShape(Object, boolean, GetInstanceShape)] */) {
            {
                GetInstanceShape getShapeNode__ = this.getShape_getShapeNode_;
                if (getShapeNode__ != null) {
                    return PythonObjectFactory.getShape(arg0Value, arg1Value, getShapeNode__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return (Shape) executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if (arg1Value instanceof Boolean) {
            boolean arg1Value_ = (boolean) arg1Value;
            GetInstanceShape getShapeNode__ = this.insert((GetInstanceShapeNodeGen.create()));
            Objects.requireNonNull(getShapeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.getShape_getShapeNode_ = getShapeNode__;
            state_0 = state_0 | 0b1 /* add SpecializationActive[PythonObjectFactory.getShape(Object, boolean, GetInstanceShape)] */;
            this.state_0_ = state_0;
            return PythonObjectFactory.getShape(arg0Value, arg1Value_, getShapeNode__);
        }
        if (arg1Value instanceof Long) {
            long arg1Value_ = (long) arg1Value;
            AllocationReporter reporter__ = (getAllocationReporter());
            Objects.requireNonNull(reporter__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.trace_reporter_ = reporter__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[PythonObjectFactory.doTrace(Object, long, AllocationReporter)] */;
            this.state_0_ = state_0;
            return PythonObjectFactory.doTrace(arg0Value, arg1Value_, reporter__);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
    }

    @NeverDefault
    public static PythonObjectFactory create() {
        return new PythonObjectFactoryNodeGen();
    }

    @NeverDefault
    public static PythonObjectFactory getUncached() {
        return PythonObjectFactoryNodeGen.UNCACHED;
    }

    @GeneratedBy(PythonObjectFactory.class)
    @DenyReplace
    private static final class Uncached extends PythonObjectFactory implements UnadoptableNode {

        @TruffleBoundary
        @Override
        protected AllocationReporter executeTrace(Object arg0Value, long arg1Value) {
            return PythonObjectFactory.doTrace(arg0Value, arg1Value, (getAllocationReporter()));
        }

        @TruffleBoundary
        @Override
        protected Shape executeGetShape(Object arg0Value, boolean arg1Value) {
            return PythonObjectFactory.getShape(arg0Value, arg1Value, (GetInstanceShapeNodeGen.getUncached()));
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link Lazy#doIt}
     *     Activation probability: 1.00000
     *     With/without class size: 24/4 bytes
     * </pre>
     */
    @GeneratedBy(Lazy.class)
    @SuppressWarnings("javadoc")
    public static final class LazyNodeGen {

        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static Lazy getUncached() {
            return LazyNodeGen.UNCACHED;
        }

        /**
         * Required Fields: <ul>
         * <li>{@link Inlined#state_0_}
         * <li>{@link Inlined#node_}
         * </ul>
         */
        @NeverDefault
        public static Lazy inline(@RequiredField(bits = 1, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
            return new LazyNodeGen.Inlined(target);
        }

        @GeneratedBy(Lazy.class)
        @DenyReplace
        private static final class Inlined extends Lazy implements UnadoptableNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Lazy#doIt}
             * </pre>
             */
            private final StateField state_0_;
            private final ReferenceField<PythonObjectFactory> node_;

            @SuppressWarnings("unchecked")
            private Inlined(InlineTarget target) {
                assert target.getTargetClass().isAssignableFrom(Lazy.class);
                this.state_0_ = target.getState(0, 1);
                this.node_ = target.getReference(1, PythonObjectFactory.class);
            }

            @Override
            PythonObjectFactory execute(Node arg0Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0 /* is SpecializationActive[PythonObjectFactory.Lazy.doIt(PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory node__ = this.node_.get(arg0Value);
                        if (node__ != null) {
                            return Lazy.doIt(node__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PythonObjectFactory executeAndSpecialize(Node arg0Value) {
                int state_0 = this.state_0_.get(arg0Value);
                PythonObjectFactory node__ = arg0Value.insert((PythonObjectFactory.create()));
                Objects.requireNonNull(node__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.node_.set(arg0Value, node__);
                state_0 = state_0 | 0b1 /* add SpecializationActive[PythonObjectFactory.Lazy.doIt(PythonObjectFactory)] */;
                this.state_0_.set(arg0Value, state_0);
                return Lazy.doIt(node__);
            }

        }
        @GeneratedBy(Lazy.class)
        @DenyReplace
        private static final class Uncached extends Lazy implements UnadoptableNode {

            @TruffleBoundary
            @Override
            PythonObjectFactory execute(Node arg0Value) {
                return Lazy.doIt((PythonObjectFactory.getUncached()));
            }

        }
    }
}
